<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_fp_view = new material_out_fp_view();

// Run the page
$material_out_fp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_fp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmaterial_out_fpview = currentForm = new ew.Form("fmaterial_out_fpview", "view");

// Form_CustomValidate event
fmaterial_out_fpview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_fpview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_fpview.lists["x_grp"] = <?php echo $material_out_fp_view->grp->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_grp"].options = <?php echo JsonEncode($material_out_fp_view->grp->options(FALSE, TRUE)) ?>;
fmaterial_out_fpview.lists["x_s_grp"] = <?php echo $material_out_fp_view->s_grp->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_fp_view->s_grp->lookupOptions()) ?>;
fmaterial_out_fpview.lists["x_product"] = <?php echo $material_out_fp_view->product->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_product"].options = <?php echo JsonEncode($material_out_fp_view->product->lookupOptions()) ?>;
fmaterial_out_fpview.lists["x_rid"] = <?php echo $material_out_fp_view->rid->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_rid"].options = <?php echo JsonEncode($material_out_fp_view->rid->lookupOptions()) ?>;
fmaterial_out_fpview.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fpview.lists["x_packing_type"] = <?php echo $material_out_fp_view->packing_type->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_fp_view->packing_type->lookupOptions()) ?>;
fmaterial_out_fpview.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fpview.lists["x_godown"] = <?php echo $material_out_fp_view->godown->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_godown"].options = <?php echo JsonEncode($material_out_fp_view->godown->lookupOptions()) ?>;
fmaterial_out_fpview.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_fpview.lists["x_quantity_avg_act"] = <?php echo $material_out_fp_view->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_fp_view->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_fpview.lists["x_process"] = <?php echo $material_out_fp_view->process->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_process"].options = <?php echo JsonEncode($material_out_fp_view->process->lookupOptions()) ?>;
fmaterial_out_fpview.lists["x_issue_to"] = <?php echo $material_out_fp_view->issue_to->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_fp_view->issue_to->lookupOptions()) ?>;
fmaterial_out_fpview.lists["x_status"] = <?php echo $material_out_fp_view->status->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_status"].options = <?php echo JsonEncode($material_out_fp_view->status->options(FALSE, TRUE)) ?>;
fmaterial_out_fpview.lists["x_operator"] = <?php echo $material_out_fp_view->operator->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_operator"].options = <?php echo JsonEncode($material_out_fp_view->operator->lookupOptions()) ?>;
fmaterial_out_fpview.lists["x_po"] = <?php echo $material_out_fp_view->po->Lookup->toClientList() ?>;
fmaterial_out_fpview.lists["x_po"].options = <?php echo JsonEncode($material_out_fp_view->po->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_out_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $material_out_fp_view->ExportOptions->render("body") ?>
<?php $material_out_fp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $material_out_fp_view->showPageHeader(); ?>
<?php
$material_out_fp_view->showMessage();
?>
<form name="fmaterial_out_fpview" id="fmaterial_out_fpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_fp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_fp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_fp">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_fp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($material_out_fp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_id"><?php echo $material_out_fp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $material_out_fp->id->cellAttributes() ?>>
<span id="el_material_out_fp_id">
<span<?php echo $material_out_fp->id->viewAttributes() ?>>
<?php echo $material_out_fp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->gp_no->Visible) { // gp_no ?>
	<tr id="r_gp_no">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_gp_no"><?php echo $material_out_fp->gp_no->caption() ?></span></td>
		<td data-name="gp_no"<?php echo $material_out_fp->gp_no->cellAttributes() ?>>
<span id="el_material_out_fp_gp_no">
<span<?php echo $material_out_fp->gp_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->gp_no->getViewValue())) && $material_out_fp->gp_no->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->gp_no->linkAttributes() ?>><?php echo $material_out_fp->gp_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->gp_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_grp"><?php echo $material_out_fp->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $material_out_fp->grp->cellAttributes() ?>>
<span id="el_material_out_fp_grp">
<span<?php echo $material_out_fp->grp->viewAttributes() ?>>
<?php echo $material_out_fp->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_s_grp"><?php echo $material_out_fp->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $material_out_fp->s_grp->cellAttributes() ?>>
<span id="el_material_out_fp_s_grp">
<span<?php echo $material_out_fp->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->s_grp->getViewValue())) && $material_out_fp->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->s_grp->linkAttributes() ?>><?php echo $material_out_fp->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_product"><?php echo $material_out_fp->product->caption() ?></span></td>
		<td data-name="product"<?php echo $material_out_fp->product->cellAttributes() ?>>
<span id="el_material_out_fp_product">
<span<?php echo $material_out_fp->product->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->product->getViewValue())) && $material_out_fp->product->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->product->linkAttributes() ?>><?php echo $material_out_fp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_rid"><?php echo $material_out_fp->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $material_out_fp->rid->cellAttributes() ?>>
<span id="el_material_out_fp_rid">
<span<?php echo $material_out_fp->rid->viewAttributes() ?>>
<?php echo $material_out_fp->rid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->lot_no->Visible) { // lot_no ?>
	<tr id="r_lot_no">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_lot_no"><?php echo $material_out_fp->lot_no->caption() ?></span></td>
		<td data-name="lot_no"<?php echo $material_out_fp->lot_no->cellAttributes() ?>>
<span id="el_material_out_fp_lot_no">
<span<?php echo $material_out_fp->lot_no->viewAttributes() ?>>
<?php echo $material_out_fp->lot_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->tmp_lot->Visible) { // tmp_lot ?>
	<tr id="r_tmp_lot">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_tmp_lot"><?php echo $material_out_fp->tmp_lot->caption() ?></span></td>
		<td data-name="tmp_lot"<?php echo $material_out_fp->tmp_lot->cellAttributes() ?>>
<span id="el_material_out_fp_tmp_lot">
<span<?php echo $material_out_fp->tmp_lot->viewAttributes() ?>>
<?php echo $material_out_fp->tmp_lot->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_packing_type"><?php echo $material_out_fp->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $material_out_fp->packing_type->cellAttributes() ?>>
<span id="el_material_out_fp_packing_type">
<span<?php echo $material_out_fp->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->packing_type->getViewValue())) && $material_out_fp->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->packing_type->linkAttributes() ?>><?php echo $material_out_fp->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->godown->Visible) { // godown ?>
	<tr id="r_godown">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_godown"><?php echo $material_out_fp->godown->caption() ?></span></td>
		<td data-name="godown"<?php echo $material_out_fp->godown->cellAttributes() ?>>
<span id="el_material_out_fp_godown">
<span<?php echo $material_out_fp->godown->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->godown->getViewValue())) && $material_out_fp->godown->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->godown->linkAttributes() ?>><?php echo $material_out_fp->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<tr id="r_quantity_avg_act">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_quantity_avg_act"><?php echo $material_out_fp->quantity_avg_act->caption() ?></span></td>
		<td data-name="quantity_avg_act"<?php echo $material_out_fp->quantity_avg_act->cellAttributes() ?>>
<span id="el_material_out_fp_quantity_avg_act">
<span<?php echo $material_out_fp->quantity_avg_act->viewAttributes() ?>>
<?php echo $material_out_fp->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->max_qty->Visible) { // max_qty ?>
	<tr id="r_max_qty">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_max_qty"><?php echo $material_out_fp->max_qty->caption() ?></span></td>
		<td data-name="max_qty"<?php echo $material_out_fp->max_qty->cellAttributes() ?>>
<span id="el_material_out_fp_max_qty">
<span<?php echo $material_out_fp->max_qty->viewAttributes() ?>>
<?php echo $material_out_fp->max_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->packets->Visible) { // packets ?>
	<tr id="r_packets">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_packets"><?php echo $material_out_fp->packets->caption() ?></span></td>
		<td data-name="packets"<?php echo $material_out_fp->packets->cellAttributes() ?>>
<span id="el_material_out_fp_packets">
<span<?php echo $material_out_fp->packets->viewAttributes() ?>>
<?php echo $material_out_fp->packets->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_quantity"><?php echo $material_out_fp->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $material_out_fp->quantity->cellAttributes() ?>>
<span id="el_material_out_fp_quantity">
<span<?php echo $material_out_fp->quantity->viewAttributes() ?>>
<?php echo $material_out_fp->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_dated"><?php echo $material_out_fp->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $material_out_fp->dated->cellAttributes() ?>>
<span id="el_material_out_fp_dated">
<span<?php echo $material_out_fp->dated->viewAttributes() ?>>
<?php echo $material_out_fp->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_process"><?php echo $material_out_fp->process->caption() ?></span></td>
		<td data-name="process"<?php echo $material_out_fp->process->cellAttributes() ?>>
<span id="el_material_out_fp_process">
<span<?php echo $material_out_fp->process->viewAttributes() ?>>
<?php echo $material_out_fp->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_remarks"><?php echo $material_out_fp->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $material_out_fp->remarks->cellAttributes() ?>>
<span id="el_material_out_fp_remarks">
<span<?php echo $material_out_fp->remarks->viewAttributes() ?>>
<?php echo $material_out_fp->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->issue_to->Visible) { // issue_to ?>
	<tr id="r_issue_to">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_issue_to"><?php echo $material_out_fp->issue_to->caption() ?></span></td>
		<td data-name="issue_to"<?php echo $material_out_fp->issue_to->cellAttributes() ?>>
<span id="el_material_out_fp_issue_to">
<span<?php echo $material_out_fp->issue_to->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_fp->issue_to->getViewValue())) && $material_out_fp->issue_to->linkAttributes() <> "") { ?>
<a<?php echo $material_out_fp->issue_to->linkAttributes() ?>><?php echo $material_out_fp->issue_to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_fp->issue_to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_status"><?php echo $material_out_fp->status->caption() ?></span></td>
		<td data-name="status"<?php echo $material_out_fp->status->cellAttributes() ?>>
<span id="el_material_out_fp_status">
<span<?php echo $material_out_fp->status->viewAttributes() ?>>
<?php echo $material_out_fp->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_operator"><?php echo $material_out_fp->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $material_out_fp->operator->cellAttributes() ?>>
<span id="el_material_out_fp_operator">
<span<?php echo $material_out_fp->operator->viewAttributes() ?>>
<?php echo $material_out_fp->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_datetime"><?php echo $material_out_fp->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $material_out_fp->datetime->cellAttributes() ?>>
<span id="el_material_out_fp_datetime">
<span<?php echo $material_out_fp->datetime->viewAttributes() ?>>
<?php echo $material_out_fp->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_fp->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $material_out_fp_view->TableLeftColumnClass ?>"><span id="elh_material_out_fp_po"><?php echo $material_out_fp->po->caption() ?></span></td>
		<td data-name="po"<?php echo $material_out_fp->po->cellAttributes() ?>>
<span id="el_material_out_fp_po">
<span<?php echo $material_out_fp->po->viewAttributes() ?>>
<?php echo $material_out_fp->po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$material_out_fp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_fp_view->terminate();
?>