<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_hs_list = new material_out_hs_list();

// Run the page
$material_out_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_out_hslist = currentForm = new ew.Form("fmaterial_out_hslist", "list");
fmaterial_out_hslist.formKeyCountName = '<?php echo $material_out_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_out_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_hslist.lists["x_grp"] = <?php echo $material_out_hs_list->grp->Lookup->toClientList() ?>;
fmaterial_out_hslist.lists["x_grp"].options = <?php echo JsonEncode($material_out_hs_list->grp->options(FALSE, TRUE)) ?>;
fmaterial_out_hslist.lists["x_s_grp"] = <?php echo $material_out_hs_list->s_grp->Lookup->toClientList() ?>;
fmaterial_out_hslist.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_hs_list->s_grp->options(FALSE, TRUE)) ?>;
fmaterial_out_hslist.lists["x_godown"] = <?php echo $material_out_hs_list->godown->Lookup->toClientList() ?>;
fmaterial_out_hslist.lists["x_godown"].options = <?php echo JsonEncode($material_out_hs_list->godown->lookupOptions()) ?>;
fmaterial_out_hslist.lists["x_jc_no"] = <?php echo $material_out_hs_list->jc_no->Lookup->toClientList() ?>;
fmaterial_out_hslist.lists["x_jc_no"].options = <?php echo JsonEncode($material_out_hs_list->jc_no->lookupOptions()) ?>;
fmaterial_out_hslist.lists["x_rid"] = <?php echo $material_out_hs_list->rid->Lookup->toClientList() ?>;
fmaterial_out_hslist.lists["x_rid"].options = <?php echo JsonEncode($material_out_hs_list->rid->lookupOptions()) ?>;
fmaterial_out_hslist.lists["x_emp_id"] = <?php echo $material_out_hs_list->emp_id->Lookup->toClientList() ?>;
fmaterial_out_hslist.lists["x_emp_id"].options = <?php echo JsonEncode($material_out_hs_list->emp_id->lookupOptions()) ?>;
fmaterial_out_hslist.autoSuggests["x_emp_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_hslist.lists["x_lot_no"] = <?php echo $material_out_hs_list->lot_no->Lookup->toClientList() ?>;
fmaterial_out_hslist.lists["x_lot_no"].options = <?php echo JsonEncode($material_out_hs_list->lot_no->lookupOptions()) ?>;
fmaterial_out_hslist.autoSuggests["x_lot_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_hslist.lists["x_tmp_lot"] = <?php echo $material_out_hs_list->tmp_lot->Lookup->toClientList() ?>;
fmaterial_out_hslist.lists["x_tmp_lot"].options = <?php echo JsonEncode($material_out_hs_list->tmp_lot->lookupOptions()) ?>;
fmaterial_out_hslist.autoSuggests["x_tmp_lot"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_hslist.lists["x_operator"] = <?php echo $material_out_hs_list->operator->Lookup->toClientList() ?>;
fmaterial_out_hslist.lists["x_operator"].options = <?php echo JsonEncode($material_out_hs_list->operator->lookupOptions()) ?>;

// Form object for search
var fmaterial_out_hslistsrch = currentSearchForm = new ew.Form("fmaterial_out_hslistsrch");

// Validate function for search
fmaterial_out_hslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_hs->tmp_lot->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_out_hslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_hslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_hslistsrch.lists["x_godown"] = <?php echo $material_out_hs_list->godown->Lookup->toClientList() ?>;
fmaterial_out_hslistsrch.lists["x_godown"].options = <?php echo JsonEncode($material_out_hs_list->godown->lookupOptions()) ?>;
fmaterial_out_hslistsrch.lists["x_lot_no"] = <?php echo $material_out_hs_list->lot_no->Lookup->toClientList() ?>;
fmaterial_out_hslistsrch.lists["x_lot_no"].options = <?php echo JsonEncode($material_out_hs_list->lot_no->lookupOptions()) ?>;
fmaterial_out_hslistsrch.autoSuggests["x_lot_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_hslistsrch.lists["x_tmp_lot"] = <?php echo $material_out_hs_list->tmp_lot->Lookup->toClientList() ?>;
fmaterial_out_hslistsrch.lists["x_tmp_lot"].options = <?php echo JsonEncode($material_out_hs_list->tmp_lot->lookupOptions()) ?>;
fmaterial_out_hslistsrch.autoSuggests["x_tmp_lot"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_hslistsrch.lists["x_operator"] = <?php echo $material_out_hs_list->operator->Lookup->toClientList() ?>;
fmaterial_out_hslistsrch.lists["x_operator"].options = <?php echo JsonEncode($material_out_hs_list->operator->lookupOptions()) ?>;

// Filters
fmaterial_out_hslistsrch.filterList = <?php echo $material_out_hs_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_out_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_out_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_out_hs_list->TotalRecs > 0 && $material_out_hs_list->ExportOptions->visible()) { ?>
<?php $material_out_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_hs_list->ImportOptions->visible()) { ?>
<?php $material_out_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_hs_list->SearchOptions->visible()) { ?>
<?php $material_out_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_hs_list->FilterOptions->visible()) { ?>
<?php $material_out_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_out_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_out_hs->isExport() && !$material_out_hs->CurrentAction) { ?>
<form name="fmaterial_out_hslistsrch" id="fmaterial_out_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_out_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_out_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_out_hs">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_out_hs_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_out_hs->RowType = ROWTYPE_SEARCH;

// Render row
$material_out_hs->resetAttributes();
$material_out_hs_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_out_hs->godown->Visible) { // godown ?>
	<div id="xsc_godown" class="ew-cell form-group">
		<label for="x_godown" class="ew-search-caption ew-label"><?php echo $material_out_hs->godown->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_hs" data-field="x_godown" data-value-separator="<?php echo $material_out_hs->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $material_out_hs->godown->editAttributes() ?>>
		<?php echo $material_out_hs->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $material_out_hs->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out_hs->lot_no->Visible) { // lot_no ?>
	<div id="xsc_lot_no" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $material_out_hs->lot_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$material_out_hs->lot_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_hs->lot_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_lot_no" class="text-nowrap" style="z-index: 8900">
	<input type="text" class="form-control" name="sv_x_lot_no" id="sv_x_lot_no" value="<?php echo RemoveHtml($material_out_hs->lot_no->EditValue) ?>" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($material_out_hs->lot_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_hs->lot_no->getPlaceHolder()) ?>"<?php echo $material_out_hs->lot_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_hs" data-field="x_lot_no" data-value-separator="<?php echo $material_out_hs->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no" id="x_lot_no" value="<?php echo HtmlEncode($material_out_hs->lot_no->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_hslistsrch.createAutoSuggest({"id":"x_lot_no","forceSelect":false});
</script>
<?php echo $material_out_hs->lot_no->Lookup->getParamTag("p_x_lot_no") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out_hs->tmp_lot->Visible) { // tmp_lot ?>
	<div id="xsc_tmp_lot" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $material_out_hs->tmp_lot->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tmp_lot" id="z_tmp_lot" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$material_out_hs->tmp_lot->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_hs->tmp_lot->EditAttrs["onchange"] = "";
?>
<span id="as_x_tmp_lot" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_tmp_lot" id="sv_x_tmp_lot" value="<?php echo RemoveHtml($material_out_hs->tmp_lot->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_hs->tmp_lot->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_hs->tmp_lot->getPlaceHolder()) ?>"<?php echo $material_out_hs->tmp_lot->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_hs" data-field="x_tmp_lot" data-value-separator="<?php echo $material_out_hs->tmp_lot->displayValueSeparatorAttribute() ?>" name="x_tmp_lot" id="x_tmp_lot" value="<?php echo HtmlEncode($material_out_hs->tmp_lot->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_hslistsrch.createAutoSuggest({"id":"x_tmp_lot","forceSelect":false});
</script>
<?php echo $material_out_hs->tmp_lot->Lookup->getParamTag("p_x_tmp_lot") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($material_out_hs->operator->Visible) { // operator ?>
	<div id="xsc_operator" class="ew-cell form-group">
		<label for="x_operator" class="ew-search-caption ew-label"><?php echo $material_out_hs->operator->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_hs" data-field="x_operator" data-value-separator="<?php echo $material_out_hs->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $material_out_hs->operator->editAttributes() ?>>
		<?php echo $material_out_hs->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $material_out_hs->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out_hs->datetime->Visible) { // datetime ?>
	<div id="xsc_datetime" class="ew-cell form-group">
		<label for="x_datetime" class="ew-search-caption ew-label"><?php echo $material_out_hs->datetime->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="material_out_hs" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($material_out_hs->datetime->getPlaceHolder()) ?>" value="<?php echo $material_out_hs->datetime->EditValue ?>"<?php echo $material_out_hs->datetime->editAttributes() ?>>
<?php if (!$material_out_hs->datetime->ReadOnly && !$material_out_hs->datetime->Disabled && !isset($material_out_hs->datetime->EditAttrs["readonly"]) && !isset($material_out_hs->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_hslistsrch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_out_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_out_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_out_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_out_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_out_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_out_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_out_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_out_hs_list->showPageHeader(); ?>
<?php
$material_out_hs_list->showMessage();
?>
<?php if ($material_out_hs_list->TotalRecs > 0 || $material_out_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_out_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_out_hs">
<?php if (!$material_out_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_out_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_hs_list->Pager)) $material_out_hs_list->Pager = new PrevNextPager($material_out_hs_list->StartRec, $material_out_hs_list->DisplayRecs, $material_out_hs_list->TotalRecs, $material_out_hs_list->AutoHidePager) ?>
<?php if ($material_out_hs_list->Pager->RecordCount > 0 && $material_out_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_hs_list->pageUrl() ?>start=<?php echo $material_out_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_hs_list->pageUrl() ?>start=<?php echo $material_out_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_hs_list->pageUrl() ?>start=<?php echo $material_out_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_hs_list->pageUrl() ?>start=<?php echo $material_out_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_hs_list->TotalRecs > 0 && (!$material_out_hs_list->AutoHidePageSizeSelector || $material_out_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_out_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_out_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_out_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_out_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_out_hslist" id="fmaterial_out_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_hs">
<div id="gmp_material_out_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_out_hs_list->TotalRecs > 0 || $material_out_hs->isGridEdit()) { ?>
<table id="tbl_material_out_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_out_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_out_hs_list->renderListOptions();

// Render list options (header, left)
$material_out_hs_list->ListOptions->render("header", "left");
?>
<?php if ($material_out_hs->id->Visible) { // id ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_out_hs->id->headerCellClass() ?>"><div id="elh_material_out_hs_id" class="material_out_hs_id"><div class="ew-table-header-caption"><?php echo $material_out_hs->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_out_hs->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->id) ?>',2);"><div id="elh_material_out_hs_id" class="material_out_hs_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->grp->Visible) { // grp ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $material_out_hs->grp->headerCellClass() ?>"><div id="elh_material_out_hs_grp" class="material_out_hs_grp"><div class="ew-table-header-caption"><?php echo $material_out_hs->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $material_out_hs->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->grp) ?>',2);"><div id="elh_material_out_hs_grp" class="material_out_hs_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->s_grp->Visible) { // s_grp ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $material_out_hs->s_grp->headerCellClass() ?>"><div id="elh_material_out_hs_s_grp" class="material_out_hs_s_grp"><div class="ew-table-header-caption"><?php echo $material_out_hs->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $material_out_hs->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->s_grp) ?>',2);"><div id="elh_material_out_hs_s_grp" class="material_out_hs_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->godown->Visible) { // godown ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $material_out_hs->godown->headerCellClass() ?>"><div id="elh_material_out_hs_godown" class="material_out_hs_godown"><div class="ew-table-header-caption"><?php echo $material_out_hs->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $material_out_hs->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->godown) ?>',2);"><div id="elh_material_out_hs_godown" class="material_out_hs_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->jc_no->Visible) { // jc_no ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $material_out_hs->jc_no->headerCellClass() ?>"><div id="elh_material_out_hs_jc_no" class="material_out_hs_jc_no"><div class="ew-table-header-caption"><?php echo $material_out_hs->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $material_out_hs->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->jc_no) ?>',2);"><div id="elh_material_out_hs_jc_no" class="material_out_hs_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->rid->Visible) { // rid ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $material_out_hs->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_hs_rid" class="material_out_hs_rid"><div class="ew-table-header-caption"><?php echo $material_out_hs->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $material_out_hs->rid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->rid) ?>',2);"><div id="elh_material_out_hs_rid" class="material_out_hs_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->emp_id->Visible) { // emp_id ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $material_out_hs->emp_id->headerCellClass() ?>"><div id="elh_material_out_hs_emp_id" class="material_out_hs_emp_id"><div class="ew-table-header-caption"><?php echo $material_out_hs->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $material_out_hs->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->emp_id) ?>',2);"><div id="elh_material_out_hs_emp_id" class="material_out_hs_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->quantity->Visible) { // quantity ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_out_hs->quantity->headerCellClass() ?>"><div id="elh_material_out_hs_quantity" class="material_out_hs_quantity"><div class="ew-table-header-caption"><?php echo $material_out_hs->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_out_hs->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->quantity) ?>',2);"><div id="elh_material_out_hs_quantity" class="material_out_hs_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->lot_no->Visible) { // lot_no ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $material_out_hs->lot_no->headerCellClass() ?>"><div id="elh_material_out_hs_lot_no" class="material_out_hs_lot_no"><div class="ew-table-header-caption"><?php echo $material_out_hs->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $material_out_hs->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->lot_no) ?>',2);"><div id="elh_material_out_hs_lot_no" class="material_out_hs_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $material_out_hs->tmp_lot->headerCellClass() ?>"><div id="elh_material_out_hs_tmp_lot" class="material_out_hs_tmp_lot"><div class="ew-table-header-caption"><?php echo $material_out_hs->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $material_out_hs->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->tmp_lot) ?>',2);"><div id="elh_material_out_hs_tmp_lot" class="material_out_hs_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->tmp_lot->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->operator->Visible) { // operator ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_out_hs->operator->headerCellClass() ?>"><div id="elh_material_out_hs_operator" class="material_out_hs_operator"><div class="ew-table-header-caption"><?php echo $material_out_hs->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_out_hs->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->operator) ?>',2);"><div id="elh_material_out_hs_operator" class="material_out_hs_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->datetime->Visible) { // datetime ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $material_out_hs->datetime->headerCellClass() ?>"><div id="elh_material_out_hs_datetime" class="material_out_hs_datetime"><div class="ew-table-header-caption"><?php echo $material_out_hs->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $material_out_hs->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->datetime) ?>',2);"><div id="elh_material_out_hs_datetime" class="material_out_hs_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->jc_quantity->Visible) { // jc_quantity ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->jc_quantity) == "") { ?>
		<th data-name="jc_quantity" class="<?php echo $material_out_hs->jc_quantity->headerCellClass() ?>"><div id="elh_material_out_hs_jc_quantity" class="material_out_hs_jc_quantity"><div class="ew-table-header-caption"><?php echo $material_out_hs->jc_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_quantity" class="<?php echo $material_out_hs->jc_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->jc_quantity) ?>',2);"><div id="elh_material_out_hs_jc_quantity" class="material_out_hs_jc_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->jc_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->jc_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->jc_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_hs->batch_no->Visible) { // batch_no ?>
	<?php if ($material_out_hs->sortUrl($material_out_hs->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $material_out_hs->batch_no->headerCellClass() ?>"><div id="elh_material_out_hs_batch_no" class="material_out_hs_batch_no"><div class="ew-table-header-caption"><?php echo $material_out_hs->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $material_out_hs->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_hs->SortUrl($material_out_hs->batch_no) ?>',2);"><div id="elh_material_out_hs_batch_no" class="material_out_hs_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_hs->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_hs->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_hs->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_out_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_out_hs->ExportAll && $material_out_hs->isExport()) {
	$material_out_hs_list->StopRec = $material_out_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_out_hs_list->TotalRecs > $material_out_hs_list->StartRec + $material_out_hs_list->DisplayRecs - 1)
		$material_out_hs_list->StopRec = $material_out_hs_list->StartRec + $material_out_hs_list->DisplayRecs - 1;
	else
		$material_out_hs_list->StopRec = $material_out_hs_list->TotalRecs;
}
$material_out_hs_list->RecCnt = $material_out_hs_list->StartRec - 1;
if ($material_out_hs_list->Recordset && !$material_out_hs_list->Recordset->EOF) {
	$material_out_hs_list->Recordset->moveFirst();
	$selectLimit = $material_out_hs_list->UseSelectLimit;
	if (!$selectLimit && $material_out_hs_list->StartRec > 1)
		$material_out_hs_list->Recordset->move($material_out_hs_list->StartRec - 1);
} elseif (!$material_out_hs->AllowAddDeleteRow && $material_out_hs_list->StopRec == 0) {
	$material_out_hs_list->StopRec = $material_out_hs->GridAddRowCount;
}

// Initialize aggregate
$material_out_hs->RowType = ROWTYPE_AGGREGATEINIT;
$material_out_hs->resetAttributes();
$material_out_hs_list->renderRow();
while ($material_out_hs_list->RecCnt < $material_out_hs_list->StopRec) {
	$material_out_hs_list->RecCnt++;
	if ($material_out_hs_list->RecCnt >= $material_out_hs_list->StartRec) {
		$material_out_hs_list->RowCnt++;

		// Set up key count
		$material_out_hs_list->KeyCount = $material_out_hs_list->RowIndex;

		// Init row class and style
		$material_out_hs->resetAttributes();
		$material_out_hs->CssClass = "";
		if ($material_out_hs->isGridAdd()) {
		} else {
			$material_out_hs_list->loadRowValues($material_out_hs_list->Recordset); // Load row values
		}
		$material_out_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_out_hs->RowAttrs = array_merge($material_out_hs->RowAttrs, array('data-rowindex'=>$material_out_hs_list->RowCnt, 'id'=>'r' . $material_out_hs_list->RowCnt . '_material_out_hs', 'data-rowtype'=>$material_out_hs->RowType));

		// Render row
		$material_out_hs_list->renderRow();

		// Render list options
		$material_out_hs_list->renderListOptions();
?>
	<tr<?php echo $material_out_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_out_hs_list->ListOptions->render("body", "left", $material_out_hs_list->RowCnt);
?>
	<?php if ($material_out_hs->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_out_hs->id->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_id" class="material_out_hs_id">
<span<?php echo $material_out_hs->id->viewAttributes() ?>>
<?php echo $material_out_hs->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $material_out_hs->grp->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_grp" class="material_out_hs_grp">
<span<?php echo $material_out_hs->grp->viewAttributes() ?>>
<?php echo $material_out_hs->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $material_out_hs->s_grp->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_s_grp" class="material_out_hs_s_grp">
<span<?php echo $material_out_hs->s_grp->viewAttributes() ?>>
<?php echo $material_out_hs->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $material_out_hs->godown->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_godown" class="material_out_hs_godown">
<span<?php echo $material_out_hs->godown->viewAttributes() ?>>
<?php echo $material_out_hs->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $material_out_hs->jc_no->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_jc_no" class="material_out_hs_jc_no">
<span<?php echo $material_out_hs->jc_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_hs->jc_no->getViewValue())) && $material_out_hs->jc_no->linkAttributes() <> "") { ?>
<a<?php echo $material_out_hs->jc_no->linkAttributes() ?>><?php echo $material_out_hs->jc_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_hs->jc_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $material_out_hs->rid->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_rid" class="material_out_hs_rid">
<span<?php echo $material_out_hs->rid->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_hs->rid->getViewValue())) && $material_out_hs->rid->linkAttributes() <> "") { ?>
<a<?php echo $material_out_hs->rid->linkAttributes() ?>><?php echo $material_out_hs->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_hs->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $material_out_hs->emp_id->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_emp_id" class="material_out_hs_emp_id">
<span<?php echo $material_out_hs->emp_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_hs->emp_id->getViewValue())) && $material_out_hs->emp_id->linkAttributes() <> "") { ?>
<a<?php echo $material_out_hs->emp_id->linkAttributes() ?>><?php echo $material_out_hs->emp_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_hs->emp_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_out_hs->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_quantity" class="material_out_hs_quantity">
<span<?php echo $material_out_hs->quantity->viewAttributes() ?>>
<?php echo $material_out_hs->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $material_out_hs->lot_no->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_lot_no" class="material_out_hs_lot_no">
<span<?php echo $material_out_hs->lot_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_hs->lot_no->getViewValue())) && $material_out_hs->lot_no->linkAttributes() <> "") { ?>
<a<?php echo $material_out_hs->lot_no->linkAttributes() ?>><?php echo $material_out_hs->lot_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_hs->lot_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $material_out_hs->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_tmp_lot" class="material_out_hs_tmp_lot">
<span<?php echo $material_out_hs->tmp_lot->viewAttributes() ?>>
<?php echo $material_out_hs->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_out_hs->operator->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_operator" class="material_out_hs_operator">
<span<?php echo $material_out_hs->operator->viewAttributes() ?>>
<?php echo $material_out_hs->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $material_out_hs->datetime->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_datetime" class="material_out_hs_datetime">
<span<?php echo $material_out_hs->datetime->viewAttributes() ?>>
<?php echo $material_out_hs->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->jc_quantity->Visible) { // jc_quantity ?>
		<td data-name="jc_quantity"<?php echo $material_out_hs->jc_quantity->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_jc_quantity" class="material_out_hs_jc_quantity">
<span<?php echo $material_out_hs->jc_quantity->viewAttributes() ?>>
<?php echo $material_out_hs->jc_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_hs->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $material_out_hs->batch_no->cellAttributes() ?>>
<span id="el<?php echo $material_out_hs_list->RowCnt ?>_material_out_hs_batch_no" class="material_out_hs_batch_no">
<span<?php echo $material_out_hs->batch_no->viewAttributes() ?>>
<?php echo $material_out_hs->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_out_hs_list->ListOptions->render("body", "right", $material_out_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_out_hs->isGridAdd())
		$material_out_hs_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$material_out_hs->RowType = ROWTYPE_AGGREGATE;
$material_out_hs->resetAttributes();
$material_out_hs_list->renderRow();
?>
<?php if ($material_out_hs_list->TotalRecs > 0 && !$material_out_hs->isGridAdd() && !$material_out_hs->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$material_out_hs_list->renderListOptions();

// Render list options (footer, left)
$material_out_hs_list->ListOptions->render("footer", "left");
?>
	<?php if ($material_out_hs->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $material_out_hs->id->footerCellClass() ?>"><span id="elf_material_out_hs_id" class="material_out_hs_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $material_out_hs->grp->footerCellClass() ?>"><span id="elf_material_out_hs_grp" class="material_out_hs_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp" class="<?php echo $material_out_hs->s_grp->footerCellClass() ?>"><span id="elf_material_out_hs_s_grp" class="material_out_hs_s_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $material_out_hs->godown->footerCellClass() ?>"><span id="elf_material_out_hs_godown" class="material_out_hs_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no" class="<?php echo $material_out_hs->jc_no->footerCellClass() ?>"><span id="elf_material_out_hs_jc_no" class="material_out_hs_jc_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $material_out_hs->rid->footerCellClass() ?>"><span id="elf_material_out_hs_rid" class="material_out_hs_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id" class="<?php echo $material_out_hs->emp_id->footerCellClass() ?>"><span id="elf_material_out_hs_emp_id" class="material_out_hs_emp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $material_out_hs->quantity->footerCellClass() ?>"><span id="elf_material_out_hs_quantity" class="material_out_hs_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_out_hs->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $material_out_hs->lot_no->footerCellClass() ?>"><span id="elf_material_out_hs_lot_no" class="material_out_hs_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot" class="<?php echo $material_out_hs->tmp_lot->footerCellClass() ?>"><span id="elf_material_out_hs_tmp_lot" class="material_out_hs_tmp_lot">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $material_out_hs->operator->footerCellClass() ?>"><span id="elf_material_out_hs_operator" class="material_out_hs_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $material_out_hs->datetime->footerCellClass() ?>"><span id="elf_material_out_hs_datetime" class="material_out_hs_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->jc_quantity->Visible) { // jc_quantity ?>
		<td data-name="jc_quantity" class="<?php echo $material_out_hs->jc_quantity->footerCellClass() ?>"><span id="elf_material_out_hs_jc_quantity" class="material_out_hs_jc_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_hs->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $material_out_hs->batch_no->footerCellClass() ?>"><span id="elf_material_out_hs_batch_no" class="material_out_hs_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$material_out_hs_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_out_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_out_hs_list->Recordset)
	$material_out_hs_list->Recordset->Close();
?>
<?php if (!$material_out_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_out_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_hs_list->Pager)) $material_out_hs_list->Pager = new PrevNextPager($material_out_hs_list->StartRec, $material_out_hs_list->DisplayRecs, $material_out_hs_list->TotalRecs, $material_out_hs_list->AutoHidePager) ?>
<?php if ($material_out_hs_list->Pager->RecordCount > 0 && $material_out_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_hs_list->pageUrl() ?>start=<?php echo $material_out_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_hs_list->pageUrl() ?>start=<?php echo $material_out_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_hs_list->pageUrl() ?>start=<?php echo $material_out_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_hs_list->pageUrl() ?>start=<?php echo $material_out_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_hs_list->TotalRecs > 0 && (!$material_out_hs_list->AutoHidePageSizeSelector || $material_out_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_out_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_out_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_out_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_out_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_out_hs_list->TotalRecs == 0 && !$material_out_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_out_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_out_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_out_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_out_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_hs_list->terminate();
?>