<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_hs_search = new material_out_hs_search();

// Run the page
$material_out_hs_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_hs_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_out_hs_search->IsModal) { ?>
var fmaterial_out_hssearch = currentAdvancedSearchForm = new ew.Form("fmaterial_out_hssearch", "search");
<?php } else { ?>
var fmaterial_out_hssearch = currentForm = new ew.Form("fmaterial_out_hssearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_out_hssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_hssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_hssearch.lists["x_grp"] = <?php echo $material_out_hs_search->grp->Lookup->toClientList() ?>;
fmaterial_out_hssearch.lists["x_grp"].options = <?php echo JsonEncode($material_out_hs_search->grp->options(FALSE, TRUE)) ?>;
fmaterial_out_hssearch.lists["x_s_grp"] = <?php echo $material_out_hs_search->s_grp->Lookup->toClientList() ?>;
fmaterial_out_hssearch.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_hs_search->s_grp->options(FALSE, TRUE)) ?>;
fmaterial_out_hssearch.lists["x_godown"] = <?php echo $material_out_hs_search->godown->Lookup->toClientList() ?>;
fmaterial_out_hssearch.lists["x_godown"].options = <?php echo JsonEncode($material_out_hs_search->godown->lookupOptions()) ?>;
fmaterial_out_hssearch.lists["x_jc_no"] = <?php echo $material_out_hs_search->jc_no->Lookup->toClientList() ?>;
fmaterial_out_hssearch.lists["x_jc_no"].options = <?php echo JsonEncode($material_out_hs_search->jc_no->lookupOptions()) ?>;
fmaterial_out_hssearch.lists["x_rid_1"] = <?php echo $material_out_hs_search->rid_1->Lookup->toClientList() ?>;
fmaterial_out_hssearch.lists["x_rid_1"].options = <?php echo JsonEncode($material_out_hs_search->rid_1->lookupOptions()) ?>;
fmaterial_out_hssearch.lists["x_emp_id"] = <?php echo $material_out_hs_search->emp_id->Lookup->toClientList() ?>;
fmaterial_out_hssearch.lists["x_emp_id"].options = <?php echo JsonEncode($material_out_hs_search->emp_id->lookupOptions()) ?>;
fmaterial_out_hssearch.autoSuggests["x_emp_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_hssearch.lists["x_process"] = <?php echo $material_out_hs_search->process->Lookup->toClientList() ?>;
fmaterial_out_hssearch.lists["x_process"].options = <?php echo JsonEncode($material_out_hs_search->process->lookupOptions()) ?>;
fmaterial_out_hssearch.lists["x_packing_type"] = <?php echo $material_out_hs_search->packing_type->Lookup->toClientList() ?>;
fmaterial_out_hssearch.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_hs_search->packing_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmaterial_out_hssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_hs->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_hs->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_hs->tmp_lot->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_hs->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_hs->jc_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_hs->batch_no->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_hs_search->showPageHeader(); ?>
<?php
$material_out_hs_search->showMessage();
?>
<form name="fmaterial_out_hssearch" id="fmaterial_out_hssearch" class="<?php echo $material_out_hs_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_hs_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_hs_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_hs">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_hs_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_out_hs->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_id"><?php echo $material_out_hs->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->id->cellAttributes() ?>>
			<span id="el_material_out_hs_id">
<input type="text" data-table="material_out_hs" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_out_hs->id->getPlaceHolder()) ?>" value="<?php echo $material_out_hs->id->EditValue ?>"<?php echo $material_out_hs->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_grp"><?php echo $material_out_hs->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->grp->cellAttributes() ?>>
			<span id="el_material_out_hs_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_hs" data-field="x_grp" data-value-separator="<?php echo $material_out_hs->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_out_hs->grp->editAttributes() ?>>
		<?php echo $material_out_hs->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_s_grp"><?php echo $material_out_hs->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->s_grp->cellAttributes() ?>>
			<span id="el_material_out_hs_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_hs" data-field="x_s_grp" data-value-separator="<?php echo $material_out_hs->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_out_hs->s_grp->editAttributes() ?>>
		<?php echo $material_out_hs->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_godown"><?php echo $material_out_hs->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->godown->cellAttributes() ?>>
			<span id="el_material_out_hs_godown">
<?php $material_out_hs->godown->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out_hs->godown->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_hs" data-field="x_godown" data-value-separator="<?php echo $material_out_hs->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $material_out_hs->godown->editAttributes() ?>>
		<?php echo $material_out_hs->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $material_out_hs->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_jc_no"><?php echo $material_out_hs->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->jc_no->cellAttributes() ?>>
			<span id="el_material_out_hs_jc_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_hs" data-field="x_jc_no" data-value-separator="<?php echo $material_out_hs->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $material_out_hs->jc_no->editAttributes() ?>>
		<?php echo $material_out_hs->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
</div>
<?php echo $material_out_hs->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->rid_1->Visible) { // rid_1 ?>
	<div id="r_rid_1" class="form-group row">
		<label class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_rid_1"><?php echo $material_out_hs->rid_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid_1" id="z_rid_1" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->rid_1->cellAttributes() ?>>
			<span id="el_material_out_hs_rid_1">
<div id="tp_x_rid_1" class="ew-template"><input type="radio" class="form-check-input" data-table="material_out_hs" data-field="x_rid_1" data-value-separator="<?php echo $material_out_hs->rid_1->displayValueSeparatorAttribute() ?>" name="x_rid_1" id="x_rid_1" value="{value}"<?php echo $material_out_hs->rid_1->editAttributes() ?>></div>
<div id="dsl_x_rid_1" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_out_hs->rid_1->radioButtonListHtml(FALSE, "x_rid_1") ?>
</div></div>
<?php echo $material_out_hs->rid_1->Lookup->getParamTag("p_x_rid_1") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->emp_id->Visible) { // emp_id ?>
	<div id="r_emp_id" class="form-group row">
		<label class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_emp_id"><?php echo $material_out_hs->emp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emp_id" id="z_emp_id" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->emp_id->cellAttributes() ?>>
			<span id="el_material_out_hs_emp_id">
<?php
$wrkonchange = "" . trim(@$material_out_hs->emp_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_hs->emp_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_emp_id" class="text-nowrap" style="z-index: 8920">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_emp_id" id="sv_x_emp_id" value="<?php echo RemoveHtml($material_out_hs->emp_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_hs->emp_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_hs->emp_id->getPlaceHolder()) ?>"<?php echo $material_out_hs->emp_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_out_hs->emp_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_emp_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($material_out_hs->emp_id->ReadOnly || $material_out_hs->emp_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="material_out_hs" data-field="x_emp_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_out_hs->emp_id->displayValueSeparatorAttribute() ?>" name="x_emp_id" id="x_emp_id" value="<?php echo HtmlEncode($material_out_hs->emp_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_hssearch.createAutoSuggest({"id":"x_emp_id","forceSelect":false});
</script>
<?php echo $material_out_hs->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_quantity"><?php echo $material_out_hs->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->quantity->cellAttributes() ?>>
			<span id="el_material_out_hs_quantity">
<input type="text" data-table="material_out_hs" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out_hs->quantity->getPlaceHolder()) ?>" value="<?php echo $material_out_hs->quantity->EditValue ?>"<?php echo $material_out_hs->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_process"><?php echo $material_out_hs->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->process->cellAttributes() ?>>
			<span id="el_material_out_hs_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_hs" data-field="x_process" data-value-separator="<?php echo $material_out_hs->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $material_out_hs->process->editAttributes() ?>>
		<?php echo $material_out_hs->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $material_out_hs->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->available_quantity->Visible) { // available_quantity ?>
	<div id="r_available_quantity" class="form-group row">
		<label for="x_available_quantity" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_available_quantity"><?php echo $material_out_hs->available_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_available_quantity" id="z_available_quantity" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->available_quantity->cellAttributes() ?>>
			<span id="el_material_out_hs_available_quantity">
<input type="text" data-table="material_out_hs" data-field="x_available_quantity" name="x_available_quantity" id="x_available_quantity" placeholder="<?php echo HtmlEncode($material_out_hs->available_quantity->getPlaceHolder()) ?>" value="<?php echo $material_out_hs->available_quantity->EditValue ?>"<?php echo $material_out_hs->available_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->avg_wt->Visible) { // avg_wt ?>
	<div id="r_avg_wt" class="form-group row">
		<label for="x_avg_wt" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_avg_wt"><?php echo $material_out_hs->avg_wt->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_avg_wt" id="z_avg_wt" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->avg_wt->cellAttributes() ?>>
			<span id="el_material_out_hs_avg_wt">
<input type="text" data-table="material_out_hs" data-field="x_avg_wt" name="x_avg_wt" id="x_avg_wt" placeholder="<?php echo HtmlEncode($material_out_hs->avg_wt->getPlaceHolder()) ?>" value="<?php echo $material_out_hs->avg_wt->EditValue ?>"<?php echo $material_out_hs->avg_wt->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_packing_type"><?php echo $material_out_hs->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->packing_type->cellAttributes() ?>>
			<span id="el_material_out_hs_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_hs" data-field="x_packing_type" data-value-separator="<?php echo $material_out_hs->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $material_out_hs->packing_type->editAttributes() ?>>
		<?php echo $material_out_hs->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $material_out_hs->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_packets"><?php echo $material_out_hs->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->packets->cellAttributes() ?>>
			<span id="el_material_out_hs_packets">
<input type="text" data-table="material_out_hs" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($material_out_hs->packets->getPlaceHolder()) ?>" value="<?php echo $material_out_hs->packets->EditValue ?>"<?php echo $material_out_hs->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->jc_quantity->Visible) { // jc_quantity ?>
	<div id="r_jc_quantity" class="form-group row">
		<label for="x_jc_quantity" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_jc_quantity"><?php echo $material_out_hs->jc_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_quantity" id="z_jc_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->jc_quantity->cellAttributes() ?>>
			<span id="el_material_out_hs_jc_quantity">
<input type="text" data-table="material_out_hs" data-field="x_jc_quantity" name="x_jc_quantity" id="x_jc_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out_hs->jc_quantity->getPlaceHolder()) ?>" value="<?php echo $material_out_hs->jc_quantity->EditValue ?>"<?php echo $material_out_hs->jc_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_hs->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $material_out_hs_search->LeftColumnClass ?>"><span id="elh_material_out_hs_batch_no"><?php echo $material_out_hs->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $material_out_hs_search->RightColumnClass ?>"><div<?php echo $material_out_hs->batch_no->cellAttributes() ?>>
			<span id="el_material_out_hs_batch_no">
<input type="text" data-table="material_out_hs" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($material_out_hs->batch_no->getPlaceHolder()) ?>" value="<?php echo $material_out_hs->batch_no->EditValue ?>"<?php echo $material_out_hs->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_hs_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_hs_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_out_hs_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_out_hs_search->terminate();
?>