<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_po_add = new material_out_po_add();

// Run the page
$material_out_po_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_po_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fmaterial_out_poadd = currentForm = new ew.Form("fmaterial_out_poadd", "add");

// Validate form
fmaterial_out_poadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($material_out_po_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->s_grp->caption(), $material_out_po->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_po_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->product->caption(), $material_out_po->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_po_add->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->po->caption(), $material_out_po->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_po_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->rid->caption(), $material_out_po->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_po->rid->errorMessage()) ?>");
		<?php if ($material_out_po_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->packing_type->caption(), $material_out_po->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_po->packing_type->errorMessage()) ?>");
		<?php if ($material_out_po_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->godown->caption(), $material_out_po->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_po->godown->errorMessage()) ?>");
		<?php if ($material_out_po_add->quantity_avg_act->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity_avg_act");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->quantity_avg_act->caption(), $material_out_po->quantity_avg_act->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_po_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->packets->caption(), $material_out_po->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkRange(elm.value, 0.001, 10000))
				return this.onError(elm, "<?php echo JsEncode($material_out_po->packets->errorMessage()) ?>");
		<?php if ($material_out_po_add->max_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->max_qty->caption(), $material_out_po->max_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_po->max_qty->errorMessage()) ?>");
		<?php if ($material_out_po_add->req_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_req_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->req_qty->caption(), $material_out_po->req_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_po_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->quantity->caption(), $material_out_po->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_po->quantity->errorMessage()) ?>");
		<?php if ($material_out_po_add->avg_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->avg_quantity->caption(), $material_out_po->avg_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_po->avg_quantity->errorMessage()) ?>");
		<?php if ($material_out_po_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->process->caption(), $material_out_po->process->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_po->process->errorMessage()) ?>");
		<?php if ($material_out_po_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->dated->caption(), $material_out_po->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out_po->dated->errorMessage()) ?>");
		<?php if ($material_out_po_add->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->issue_to->caption(), $material_out_po->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_po_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->remarks->caption(), $material_out_po->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_po_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->operator->caption(), $material_out_po->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_po_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out_po->datetime->caption(), $material_out_po->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmaterial_out_poadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_poadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_poadd.lists["x_s_grp"] = <?php echo $material_out_po_add->s_grp->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_po_add->s_grp->lookupOptions()) ?>;
fmaterial_out_poadd.lists["x_product"] = <?php echo $material_out_po_add->product->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_product"].options = <?php echo JsonEncode($material_out_po_add->product->lookupOptions()) ?>;
fmaterial_out_poadd.lists["x_po"] = <?php echo $material_out_po_add->po->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_po"].options = <?php echo JsonEncode($material_out_po_add->po->lookupOptions()) ?>;
fmaterial_out_poadd.lists["x_packing_type"] = <?php echo $material_out_po_add->packing_type->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_po_add->packing_type->lookupOptions()) ?>;
fmaterial_out_poadd.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_poadd.lists["x_godown"] = <?php echo $material_out_po_add->godown->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_godown"].options = <?php echo JsonEncode($material_out_po_add->godown->lookupOptions()) ?>;
fmaterial_out_poadd.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_poadd.lists["x_quantity_avg_act"] = <?php echo $material_out_po_add->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_po_add->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_poadd.lists["x_quantity"] = <?php echo $material_out_po_add->quantity->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_quantity"].options = <?php echo JsonEncode($material_out_po_add->quantity->lookupOptions()) ?>;
fmaterial_out_poadd.autoSuggests["x_quantity"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_poadd.lists["x_process"] = <?php echo $material_out_po_add->process->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_process"].options = <?php echo JsonEncode($material_out_po_add->process->lookupOptions()) ?>;
fmaterial_out_poadd.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_poadd.lists["x_issue_to"] = <?php echo $material_out_po_add->issue_to->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_po_add->issue_to->lookupOptions()) ?>;
fmaterial_out_poadd.lists["x_operator"] = <?php echo $material_out_po_add->operator->Lookup->toClientList() ?>;
fmaterial_out_poadd.lists["x_operator"].options = <?php echo JsonEncode($material_out_po_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_po_add->showPageHeader(); ?>
<?php
$material_out_po_add->showMessage();
?>
<form name="fmaterial_out_poadd" id="fmaterial_out_poadd" class="<?php echo $material_out_po_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_po_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_po_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_po">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_po_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($material_out_po->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_material_out_po_s_grp" for="x_s_grp" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->s_grp->caption() ?><?php echo ($material_out_po->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->s_grp->cellAttributes() ?>>
<span id="el_material_out_po_s_grp">
<?php $material_out_po->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out_po->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_po" data-field="x_s_grp" data-value-separator="<?php echo $material_out_po->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_out_po->s_grp->editAttributes() ?>>
		<?php echo $material_out_po->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_out_po->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $material_out_po->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_material_out_po_product" for="x_product" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->product->caption() ?><?php echo ($material_out_po->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->product->cellAttributes() ?>>
<span id="el_material_out_po_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_po" data-field="x_product" data-value-separator="<?php echo $material_out_po->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_out_po->product->editAttributes() ?>>
		<?php echo $material_out_po->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_out_po->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $material_out_po->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_material_out_po_po" for="x_po" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->po->caption() ?><?php echo ($material_out_po->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->po->cellAttributes() ?>>
<span id="el_material_out_po_po">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_po" data-field="x_po" data-value-separator="<?php echo $material_out_po->po->displayValueSeparatorAttribute() ?>" id="x_po" name="x_po"<?php echo $material_out_po->po->editAttributes() ?>>
		<?php echo $material_out_po->po->selectOptionListHtml("x_po") ?>
	</select>
</div>
<?php echo $material_out_po->po->Lookup->getParamTag("p_x_po") ?>
</span>
<?php echo $material_out_po->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_material_out_po_rid" for="x_rid" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->rid->caption() ?><?php echo ($material_out_po->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->rid->cellAttributes() ?>>
<span id="el_material_out_po_rid">
<input type="text" data-table="material_out_po" data-field="x_rid" name="x_rid" id="x_rid" size="40" placeholder="<?php echo HtmlEncode($material_out_po->rid->getPlaceHolder()) ?>" value="<?php echo $material_out_po->rid->EditValue ?>"<?php echo $material_out_po->rid->editAttributes() ?>>
</span>
<?php echo $material_out_po->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_material_out_po_packing_type" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->packing_type->caption() ?><?php echo ($material_out_po->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->packing_type->cellAttributes() ?>>
<span id="el_material_out_po_packing_type">
<?php
$wrkonchange = "" . trim(@$material_out_po->packing_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_po->packing_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing_type" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_packing_type" id="sv_x_packing_type" value="<?php echo RemoveHtml($material_out_po->packing_type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_po->packing_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_po->packing_type->getPlaceHolder()) ?>"<?php echo $material_out_po->packing_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_po" data-field="x_packing_type" data-value-separator="<?php echo $material_out_po->packing_type->displayValueSeparatorAttribute() ?>" name="x_packing_type" id="x_packing_type" value="<?php echo HtmlEncode($material_out_po->packing_type->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_poadd.createAutoSuggest({"id":"x_packing_type","forceSelect":false});
</script>
<?php echo $material_out_po->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $material_out_po->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_material_out_po_godown" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->godown->caption() ?><?php echo ($material_out_po->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->godown->cellAttributes() ?>>
<span id="el_material_out_po_godown">
<?php
$wrkonchange = "" . trim(@$material_out_po->godown->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_po->godown->EditAttrs["onchange"] = "";
?>
<span id="as_x_godown" class="text-nowrap" style="z-index: 8930">
	<input type="text" class="form-control" name="sv_x_godown" id="sv_x_godown" value="<?php echo RemoveHtml($material_out_po->godown->EditValue) ?>" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($material_out_po->godown->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_po->godown->getPlaceHolder()) ?>"<?php echo $material_out_po->godown->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_po" data-field="x_godown" data-value-separator="<?php echo $material_out_po->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="<?php echo HtmlEncode($material_out_po->godown->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_poadd.createAutoSuggest({"id":"x_godown","forceSelect":false});
</script>
<?php echo $material_out_po->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $material_out_po->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label id="elh_material_out_po_quantity_avg_act" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->quantity_avg_act->caption() ?><?php echo ($material_out_po->quantity_avg_act->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->quantity_avg_act->cellAttributes() ?>>
<span id="el_material_out_po_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="material_out_po" data-field="x_quantity_avg_act" data-value-separator="<?php echo $material_out_po->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $material_out_po->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_out_po->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
<?php echo $material_out_po->quantity_avg_act->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_material_out_po_packets" for="x_packets" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->packets->caption() ?><?php echo ($material_out_po->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->packets->cellAttributes() ?>>
<span id="el_material_out_po_packets">
<input type="text" data-table="material_out_po" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($material_out_po->packets->getPlaceHolder()) ?>" value="<?php echo $material_out_po->packets->EditValue ?>"<?php echo $material_out_po->packets->editAttributes() ?>>
</span>
<?php echo $material_out_po->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label id="elh_material_out_po_max_qty" for="x_max_qty" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->max_qty->caption() ?><?php echo ($material_out_po->max_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->max_qty->cellAttributes() ?>>
<span id="el_material_out_po_max_qty">
<input type="text" data-table="material_out_po" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" size="30" placeholder="<?php echo HtmlEncode($material_out_po->max_qty->getPlaceHolder()) ?>" value="<?php echo $material_out_po->max_qty->EditValue ?>"<?php echo $material_out_po->max_qty->editAttributes() ?>>
</span>
<?php echo $material_out_po->max_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->req_qty->Visible) { // req_qty ?>
	<div id="r_req_qty" class="form-group row">
		<label id="elh_material_out_po_req_qty" for="x_req_qty" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->req_qty->caption() ?><?php echo ($material_out_po->req_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->req_qty->cellAttributes() ?>>
<span id="el_material_out_po_req_qty">
<input type="text" data-table="material_out_po" data-field="x_req_qty" name="x_req_qty" id="x_req_qty" placeholder="<?php echo HtmlEncode($material_out_po->req_qty->getPlaceHolder()) ?>" value="<?php echo $material_out_po->req_qty->EditValue ?>"<?php echo $material_out_po->req_qty->editAttributes() ?>>
</span>
<?php echo $material_out_po->req_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_material_out_po_quantity" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->quantity->caption() ?><?php echo ($material_out_po->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->quantity->cellAttributes() ?>>
<span id="el_material_out_po_quantity">
<?php
$wrkonchange = "" . trim(@$material_out_po->quantity->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_po->quantity->EditAttrs["onchange"] = "";
?>
<span id="as_x_quantity" class="text-nowrap" style="z-index: 8880">
	<input type="text" class="form-control" name="sv_x_quantity" id="sv_x_quantity" value="<?php echo RemoveHtml($material_out_po->quantity->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_po->quantity->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_po->quantity->getPlaceHolder()) ?>"<?php echo $material_out_po->quantity->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_po" data-field="x_quantity" data-value-separator="<?php echo $material_out_po->quantity->displayValueSeparatorAttribute() ?>" name="x_quantity" id="x_quantity" value="<?php echo HtmlEncode($material_out_po->quantity->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_poadd.createAutoSuggest({"id":"x_quantity","forceSelect":false});
</script>
<?php echo $material_out_po->quantity->Lookup->getParamTag("p_x_quantity") ?>
</span>
<?php echo $material_out_po->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label id="elh_material_out_po_avg_quantity" for="x_avg_quantity" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->avg_quantity->caption() ?><?php echo ($material_out_po->avg_quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->avg_quantity->cellAttributes() ?>>
<span id="el_material_out_po_avg_quantity">
<input type="text" data-table="material_out_po" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out_po->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $material_out_po->avg_quantity->EditValue ?>"<?php echo $material_out_po->avg_quantity->editAttributes() ?>>
</span>
<?php echo $material_out_po->avg_quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_material_out_po_process" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->process->caption() ?><?php echo ($material_out_po->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->process->cellAttributes() ?>>
<span id="el_material_out_po_process">
<?php
$wrkonchange = "" . trim(@$material_out_po->process->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_po->process->EditAttrs["onchange"] = "";
?>
<span id="as_x_process" class="text-nowrap" style="z-index: 8860">
	<input type="text" class="form-control" name="sv_x_process" id="sv_x_process" value="<?php echo RemoveHtml($material_out_po->process->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_po->process->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_po->process->getPlaceHolder()) ?>"<?php echo $material_out_po->process->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_po" data-field="x_process" data-value-separator="<?php echo $material_out_po->process->displayValueSeparatorAttribute() ?>" name="x_process" id="x_process" value="<?php echo HtmlEncode($material_out_po->process->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_poadd.createAutoSuggest({"id":"x_process","forceSelect":false});
</script>
<?php echo $material_out_po->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $material_out_po->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_material_out_po_dated" for="x_dated" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->dated->caption() ?><?php echo ($material_out_po->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->dated->cellAttributes() ?>>
<span id="el_material_out_po_dated">
<input type="text" data-table="material_out_po" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($material_out_po->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_po->dated->EditValue ?>"<?php echo $material_out_po->dated->editAttributes() ?>>
<?php if (!$material_out_po->dated->ReadOnly && !$material_out_po->dated->Disabled && !isset($material_out_po->dated->EditAttrs["readonly"]) && !isset($material_out_po->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_poadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_out_po->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_material_out_po_issue_to" for="x_issue_to" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->issue_to->caption() ?><?php echo ($material_out_po->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->issue_to->cellAttributes() ?>>
<span id="el_material_out_po_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_po" data-field="x_issue_to" data-value-separator="<?php echo $material_out_po->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_out_po->issue_to->editAttributes() ?>>
		<?php echo $material_out_po->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$material_out_po->issue_to->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_issue_to" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $material_out_po->issue_to->caption() ?>" data-title="<?php echo $material_out_po->issue_to->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_issue_to',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $material_out_po->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
<?php echo $material_out_po->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_material_out_po_remarks" for="x_remarks" class="<?php echo $material_out_po_add->LeftColumnClass ?>"><?php echo $material_out_po->remarks->caption() ?><?php echo ($material_out_po->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_po_add->RightColumnClass ?>"><div<?php echo $material_out_po->remarks->cellAttributes() ?>>
<span id="el_material_out_po_remarks">
<textarea data-table="material_out_po" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($material_out_po->remarks->getPlaceHolder()) ?>"<?php echo $material_out_po->remarks->editAttributes() ?>><?php echo $material_out_po->remarks->EditValue ?></textarea>
</span>
<?php echo $material_out_po->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_po_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_po_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $material_out_po_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_out_po_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_out_po_add->terminate();
?>