<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_po_list = new material_out_po_list();

// Run the page
$material_out_po_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_po_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out_po->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_out_polist = currentForm = new ew.Form("fmaterial_out_polist", "list");
fmaterial_out_polist.formKeyCountName = '<?php echo $material_out_po_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_out_polist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_polist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_polist.lists["x_s_grp"] = <?php echo $material_out_po_list->s_grp->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_po_list->s_grp->lookupOptions()) ?>;
fmaterial_out_polist.lists["x_product"] = <?php echo $material_out_po_list->product->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_product"].options = <?php echo JsonEncode($material_out_po_list->product->lookupOptions()) ?>;
fmaterial_out_polist.lists["x_packing_type"] = <?php echo $material_out_po_list->packing_type->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_po_list->packing_type->lookupOptions()) ?>;
fmaterial_out_polist.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_polist.lists["x_godown"] = <?php echo $material_out_po_list->godown->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_godown"].options = <?php echo JsonEncode($material_out_po_list->godown->lookupOptions()) ?>;
fmaterial_out_polist.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_polist.lists["x_quantity_avg_act"] = <?php echo $material_out_po_list->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_po_list->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_polist.lists["x_quantity"] = <?php echo $material_out_po_list->quantity->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_quantity"].options = <?php echo JsonEncode($material_out_po_list->quantity->lookupOptions()) ?>;
fmaterial_out_polist.autoSuggests["x_quantity"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_polist.lists["x_process"] = <?php echo $material_out_po_list->process->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_process"].options = <?php echo JsonEncode($material_out_po_list->process->lookupOptions()) ?>;
fmaterial_out_polist.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_polist.lists["x_issue_to"] = <?php echo $material_out_po_list->issue_to->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_po_list->issue_to->lookupOptions()) ?>;
fmaterial_out_polist.lists["x_operator"] = <?php echo $material_out_po_list->operator->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_operator"].options = <?php echo JsonEncode($material_out_po_list->operator->lookupOptions()) ?>;
fmaterial_out_polist.lists["x_status"] = <?php echo $material_out_po_list->status->Lookup->toClientList() ?>;
fmaterial_out_polist.lists["x_status"].options = <?php echo JsonEncode($material_out_po_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fmaterial_out_polistsrch = currentSearchForm = new ew.Form("fmaterial_out_polistsrch");

// Filters
fmaterial_out_polistsrch.filterList = <?php echo $material_out_po_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_out_polistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_out_po->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_out_po_list->TotalRecs > 0 && $material_out_po_list->ExportOptions->visible()) { ?>
<?php $material_out_po_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_po_list->ImportOptions->visible()) { ?>
<?php $material_out_po_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_po_list->SearchOptions->visible()) { ?>
<?php $material_out_po_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_po_list->FilterOptions->visible()) { ?>
<?php $material_out_po_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_out_po_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_out_po->isExport() && !$material_out_po->CurrentAction) { ?>
<form name="fmaterial_out_polistsrch" id="fmaterial_out_polistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_out_po_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_out_polistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_out_po">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_out_po_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_out_po_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_out_po_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_out_po_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_out_po_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_out_po_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_out_po_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_out_po_list->showPageHeader(); ?>
<?php
$material_out_po_list->showMessage();
?>
<?php if ($material_out_po_list->TotalRecs > 0 || $material_out_po->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_out_po_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_out_po">
<?php if (!$material_out_po->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_out_po->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_po_list->Pager)) $material_out_po_list->Pager = new PrevNextPager($material_out_po_list->StartRec, $material_out_po_list->DisplayRecs, $material_out_po_list->TotalRecs, $material_out_po_list->AutoHidePager) ?>
<?php if ($material_out_po_list->Pager->RecordCount > 0 && $material_out_po_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_po_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_po_list->pageUrl() ?>start=<?php echo $material_out_po_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_po_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_po_list->pageUrl() ?>start=<?php echo $material_out_po_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_po_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_po_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_po_list->pageUrl() ?>start=<?php echo $material_out_po_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_po_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_po_list->pageUrl() ?>start=<?php echo $material_out_po_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_po_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_po_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_po_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_po_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_po_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_po_list->TotalRecs > 0 && (!$material_out_po_list->AutoHidePageSizeSelector || $material_out_po_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_po">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_out_po_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_out_po_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_po_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_po_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_out_po_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_out_po->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_po_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_out_polist" id="fmaterial_out_polist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_po_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_po_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_po">
<div id="gmp_material_out_po" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_out_po_list->TotalRecs > 0 || $material_out_po->isGridEdit()) { ?>
<table id="tbl_material_out_polist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_out_po_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_out_po_list->renderListOptions();

// Render list options (header, left)
$material_out_po_list->ListOptions->render("header", "left");
?>
<?php if ($material_out_po->id->Visible) { // id ?>
	<?php if ($material_out_po->sortUrl($material_out_po->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_out_po->id->headerCellClass() ?>"><div id="elh_material_out_po_id" class="material_out_po_id"><div class="ew-table-header-caption"><?php echo $material_out_po->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_out_po->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->id) ?>',2);"><div id="elh_material_out_po_id" class="material_out_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->s_grp->Visible) { // s_grp ?>
	<?php if ($material_out_po->sortUrl($material_out_po->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $material_out_po->s_grp->headerCellClass() ?>"><div id="elh_material_out_po_s_grp" class="material_out_po_s_grp"><div class="ew-table-header-caption"><?php echo $material_out_po->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $material_out_po->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->s_grp) ?>',2);"><div id="elh_material_out_po_s_grp" class="material_out_po_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->product->Visible) { // product ?>
	<?php if ($material_out_po->sortUrl($material_out_po->product) == "") { ?>
		<th data-name="product" class="<?php echo $material_out_po->product->headerCellClass() ?>"><div id="elh_material_out_po_product" class="material_out_po_product"><div class="ew-table-header-caption"><?php echo $material_out_po->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $material_out_po->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->product) ?>',2);"><div id="elh_material_out_po_product" class="material_out_po_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->rid->Visible) { // rid ?>
	<?php if ($material_out_po->sortUrl($material_out_po->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $material_out_po->rid->headerCellClass() ?>"><div id="elh_material_out_po_rid" class="material_out_po_rid"><div class="ew-table-header-caption"><?php echo $material_out_po->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $material_out_po->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->rid) ?>',2);"><div id="elh_material_out_po_rid" class="material_out_po_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->packing_type->Visible) { // packing_type ?>
	<?php if ($material_out_po->sortUrl($material_out_po->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $material_out_po->packing_type->headerCellClass() ?>"><div id="elh_material_out_po_packing_type" class="material_out_po_packing_type"><div class="ew-table-header-caption"><?php echo $material_out_po->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $material_out_po->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->packing_type) ?>',2);"><div id="elh_material_out_po_packing_type" class="material_out_po_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->godown->Visible) { // godown ?>
	<?php if ($material_out_po->sortUrl($material_out_po->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $material_out_po->godown->headerCellClass() ?>"><div id="elh_material_out_po_godown" class="material_out_po_godown"><div class="ew-table-header-caption"><?php echo $material_out_po->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $material_out_po->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->godown) ?>',2);"><div id="elh_material_out_po_godown" class="material_out_po_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<?php if ($material_out_po->sortUrl($material_out_po->quantity_avg_act) == "") { ?>
		<th data-name="quantity_avg_act" class="<?php echo $material_out_po->quantity_avg_act->headerCellClass() ?>"><div id="elh_material_out_po_quantity_avg_act" class="material_out_po_quantity_avg_act"><div class="ew-table-header-caption"><?php echo $material_out_po->quantity_avg_act->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_avg_act" class="<?php echo $material_out_po->quantity_avg_act->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->quantity_avg_act) ?>',2);"><div id="elh_material_out_po_quantity_avg_act" class="material_out_po_quantity_avg_act">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->quantity_avg_act->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->quantity_avg_act->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->quantity_avg_act->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->packets->Visible) { // packets ?>
	<?php if ($material_out_po->sortUrl($material_out_po->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $material_out_po->packets->headerCellClass() ?>"><div id="elh_material_out_po_packets" class="material_out_po_packets"><div class="ew-table-header-caption"><?php echo $material_out_po->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $material_out_po->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->packets) ?>',2);"><div id="elh_material_out_po_packets" class="material_out_po_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->max_qty->Visible) { // max_qty ?>
	<?php if ($material_out_po->sortUrl($material_out_po->max_qty) == "") { ?>
		<th data-name="max_qty" class="<?php echo $material_out_po->max_qty->headerCellClass() ?>"><div id="elh_material_out_po_max_qty" class="material_out_po_max_qty"><div class="ew-table-header-caption"><?php echo $material_out_po->max_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="max_qty" class="<?php echo $material_out_po->max_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->max_qty) ?>',2);"><div id="elh_material_out_po_max_qty" class="material_out_po_max_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->max_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->max_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->max_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->quantity->Visible) { // quantity ?>
	<?php if ($material_out_po->sortUrl($material_out_po->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_out_po->quantity->headerCellClass() ?>"><div id="elh_material_out_po_quantity" class="material_out_po_quantity"><div class="ew-table-header-caption"><?php echo $material_out_po->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_out_po->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->quantity) ?>',2);"><div id="elh_material_out_po_quantity" class="material_out_po_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->avg_quantity->Visible) { // avg_quantity ?>
	<?php if ($material_out_po->sortUrl($material_out_po->avg_quantity) == "") { ?>
		<th data-name="avg_quantity" class="<?php echo $material_out_po->avg_quantity->headerCellClass() ?>"><div id="elh_material_out_po_avg_quantity" class="material_out_po_avg_quantity"><div class="ew-table-header-caption"><?php echo $material_out_po->avg_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_quantity" class="<?php echo $material_out_po->avg_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->avg_quantity) ?>',2);"><div id="elh_material_out_po_avg_quantity" class="material_out_po_avg_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->avg_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->avg_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->avg_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->process->Visible) { // process ?>
	<?php if ($material_out_po->sortUrl($material_out_po->process) == "") { ?>
		<th data-name="process" class="<?php echo $material_out_po->process->headerCellClass() ?>"><div id="elh_material_out_po_process" class="material_out_po_process"><div class="ew-table-header-caption"><?php echo $material_out_po->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $material_out_po->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->process) ?>',2);"><div id="elh_material_out_po_process" class="material_out_po_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->dated->Visible) { // dated ?>
	<?php if ($material_out_po->sortUrl($material_out_po->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $material_out_po->dated->headerCellClass() ?>"><div id="elh_material_out_po_dated" class="material_out_po_dated"><div class="ew-table-header-caption"><?php echo $material_out_po->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $material_out_po->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->dated) ?>',2);"><div id="elh_material_out_po_dated" class="material_out_po_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->issue_to->Visible) { // issue_to ?>
	<?php if ($material_out_po->sortUrl($material_out_po->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $material_out_po->issue_to->headerCellClass() ?>"><div id="elh_material_out_po_issue_to" class="material_out_po_issue_to"><div class="ew-table-header-caption"><?php echo $material_out_po->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $material_out_po->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->issue_to) ?>',2);"><div id="elh_material_out_po_issue_to" class="material_out_po_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->remarks->Visible) { // remarks ?>
	<?php if ($material_out_po->sortUrl($material_out_po->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $material_out_po->remarks->headerCellClass() ?>"><div id="elh_material_out_po_remarks" class="material_out_po_remarks"><div class="ew-table-header-caption"><?php echo $material_out_po->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $material_out_po->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->remarks) ?>',2);"><div id="elh_material_out_po_remarks" class="material_out_po_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->operator->Visible) { // operator ?>
	<?php if ($material_out_po->sortUrl($material_out_po->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_out_po->operator->headerCellClass() ?>"><div id="elh_material_out_po_operator" class="material_out_po_operator"><div class="ew-table-header-caption"><?php echo $material_out_po->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_out_po->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->operator) ?>',2);"><div id="elh_material_out_po_operator" class="material_out_po_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->datetime->Visible) { // datetime ?>
	<?php if ($material_out_po->sortUrl($material_out_po->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $material_out_po->datetime->headerCellClass() ?>"><div id="elh_material_out_po_datetime" class="material_out_po_datetime"><div class="ew-table-header-caption"><?php echo $material_out_po->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $material_out_po->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->datetime) ?>',2);"><div id="elh_material_out_po_datetime" class="material_out_po_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_po->status->Visible) { // status ?>
	<?php if ($material_out_po->sortUrl($material_out_po->status) == "") { ?>
		<th data-name="status" class="<?php echo $material_out_po->status->headerCellClass() ?>"><div id="elh_material_out_po_status" class="material_out_po_status"><div class="ew-table-header-caption"><?php echo $material_out_po->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $material_out_po->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_po->SortUrl($material_out_po->status) ?>',2);"><div id="elh_material_out_po_status" class="material_out_po_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_po->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_po->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_po->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_out_po_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_out_po->ExportAll && $material_out_po->isExport()) {
	$material_out_po_list->StopRec = $material_out_po_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_out_po_list->TotalRecs > $material_out_po_list->StartRec + $material_out_po_list->DisplayRecs - 1)
		$material_out_po_list->StopRec = $material_out_po_list->StartRec + $material_out_po_list->DisplayRecs - 1;
	else
		$material_out_po_list->StopRec = $material_out_po_list->TotalRecs;
}
$material_out_po_list->RecCnt = $material_out_po_list->StartRec - 1;
if ($material_out_po_list->Recordset && !$material_out_po_list->Recordset->EOF) {
	$material_out_po_list->Recordset->moveFirst();
	$selectLimit = $material_out_po_list->UseSelectLimit;
	if (!$selectLimit && $material_out_po_list->StartRec > 1)
		$material_out_po_list->Recordset->move($material_out_po_list->StartRec - 1);
} elseif (!$material_out_po->AllowAddDeleteRow && $material_out_po_list->StopRec == 0) {
	$material_out_po_list->StopRec = $material_out_po->GridAddRowCount;
}

// Initialize aggregate
$material_out_po->RowType = ROWTYPE_AGGREGATEINIT;
$material_out_po->resetAttributes();
$material_out_po_list->renderRow();
while ($material_out_po_list->RecCnt < $material_out_po_list->StopRec) {
	$material_out_po_list->RecCnt++;
	if ($material_out_po_list->RecCnt >= $material_out_po_list->StartRec) {
		$material_out_po_list->RowCnt++;

		// Set up key count
		$material_out_po_list->KeyCount = $material_out_po_list->RowIndex;

		// Init row class and style
		$material_out_po->resetAttributes();
		$material_out_po->CssClass = "";
		if ($material_out_po->isGridAdd()) {
		} else {
			$material_out_po_list->loadRowValues($material_out_po_list->Recordset); // Load row values
		}
		$material_out_po->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_out_po->RowAttrs = array_merge($material_out_po->RowAttrs, array('data-rowindex'=>$material_out_po_list->RowCnt, 'id'=>'r' . $material_out_po_list->RowCnt . '_material_out_po', 'data-rowtype'=>$material_out_po->RowType));

		// Render row
		$material_out_po_list->renderRow();

		// Render list options
		$material_out_po_list->renderListOptions();
?>
	<tr<?php echo $material_out_po->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_out_po_list->ListOptions->render("body", "left", $material_out_po_list->RowCnt);
?>
	<?php if ($material_out_po->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_out_po->id->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_id" class="material_out_po_id">
<span<?php echo $material_out_po->id->viewAttributes() ?>>
<?php echo $material_out_po->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $material_out_po->s_grp->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_s_grp" class="material_out_po_s_grp">
<span<?php echo $material_out_po->s_grp->viewAttributes() ?>>
<?php echo $material_out_po->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->product->Visible) { // product ?>
		<td data-name="product"<?php echo $material_out_po->product->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_product" class="material_out_po_product">
<span<?php echo $material_out_po->product->viewAttributes() ?>>
<?php echo $material_out_po->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $material_out_po->rid->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_rid" class="material_out_po_rid">
<span<?php echo $material_out_po->rid->viewAttributes() ?>>
<?php echo $material_out_po->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $material_out_po->packing_type->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_packing_type" class="material_out_po_packing_type">
<span<?php echo $material_out_po->packing_type->viewAttributes() ?>>
<?php echo $material_out_po->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $material_out_po->godown->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_godown" class="material_out_po_godown">
<span<?php echo $material_out_po->godown->viewAttributes() ?>>
<?php echo $material_out_po->godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act"<?php echo $material_out_po->quantity_avg_act->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_quantity_avg_act" class="material_out_po_quantity_avg_act">
<span<?php echo $material_out_po->quantity_avg_act->viewAttributes() ?>>
<?php echo $material_out_po->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $material_out_po->packets->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_packets" class="material_out_po_packets">
<span<?php echo $material_out_po->packets->viewAttributes() ?>>
<?php echo $material_out_po->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->max_qty->Visible) { // max_qty ?>
		<td data-name="max_qty"<?php echo $material_out_po->max_qty->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_max_qty" class="material_out_po_max_qty">
<span<?php echo $material_out_po->max_qty->viewAttributes() ?>>
<?php echo $material_out_po->max_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_out_po->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_quantity" class="material_out_po_quantity">
<span<?php echo $material_out_po->quantity->viewAttributes() ?>>
<?php echo $material_out_po->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->avg_quantity->Visible) { // avg_quantity ?>
		<td data-name="avg_quantity"<?php echo $material_out_po->avg_quantity->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_avg_quantity" class="material_out_po_avg_quantity">
<span<?php echo $material_out_po->avg_quantity->viewAttributes() ?>>
<?php echo $material_out_po->avg_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->process->Visible) { // process ?>
		<td data-name="process"<?php echo $material_out_po->process->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_process" class="material_out_po_process">
<span<?php echo $material_out_po->process->viewAttributes() ?>>
<?php echo $material_out_po->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $material_out_po->dated->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_dated" class="material_out_po_dated">
<span<?php echo $material_out_po->dated->viewAttributes() ?>>
<?php echo $material_out_po->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $material_out_po->issue_to->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_issue_to" class="material_out_po_issue_to">
<span<?php echo $material_out_po->issue_to->viewAttributes() ?>>
<?php echo $material_out_po->issue_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $material_out_po->remarks->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_remarks" class="material_out_po_remarks">
<span<?php echo $material_out_po->remarks->viewAttributes() ?>>
<?php echo $material_out_po->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_out_po->operator->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_operator" class="material_out_po_operator">
<span<?php echo $material_out_po->operator->viewAttributes() ?>>
<?php echo $material_out_po->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $material_out_po->datetime->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_datetime" class="material_out_po_datetime">
<span<?php echo $material_out_po->datetime->viewAttributes() ?>>
<?php echo $material_out_po->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_po->status->Visible) { // status ?>
		<td data-name="status"<?php echo $material_out_po->status->cellAttributes() ?>>
<span id="el<?php echo $material_out_po_list->RowCnt ?>_material_out_po_status" class="material_out_po_status">
<span<?php echo $material_out_po->status->viewAttributes() ?>>
<?php echo $material_out_po->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_out_po_list->ListOptions->render("body", "right", $material_out_po_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_out_po->isGridAdd())
		$material_out_po_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_out_po->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_out_po_list->Recordset)
	$material_out_po_list->Recordset->Close();
?>
<?php if (!$material_out_po->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_out_po->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_po_list->Pager)) $material_out_po_list->Pager = new PrevNextPager($material_out_po_list->StartRec, $material_out_po_list->DisplayRecs, $material_out_po_list->TotalRecs, $material_out_po_list->AutoHidePager) ?>
<?php if ($material_out_po_list->Pager->RecordCount > 0 && $material_out_po_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_po_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_po_list->pageUrl() ?>start=<?php echo $material_out_po_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_po_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_po_list->pageUrl() ?>start=<?php echo $material_out_po_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_po_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_po_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_po_list->pageUrl() ?>start=<?php echo $material_out_po_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_po_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_po_list->pageUrl() ?>start=<?php echo $material_out_po_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_po_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_po_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_po_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_po_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_po_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_po_list->TotalRecs > 0 && (!$material_out_po_list->AutoHidePageSizeSelector || $material_out_po_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_po">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_out_po_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_out_po_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_po_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_po_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_out_po_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_out_po->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_po_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_out_po_list->TotalRecs == 0 && !$material_out_po->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_out_po_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_out_po_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out_po->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_out_po->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_out_po", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_po_list->terminate();
?>