<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_po_search = new material_out_po_search();

// Run the page
$material_out_po_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_po_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_out_po_search->IsModal) { ?>
var fmaterial_out_posearch = currentAdvancedSearchForm = new ew.Form("fmaterial_out_posearch", "search");
<?php } else { ?>
var fmaterial_out_posearch = currentForm = new ew.Form("fmaterial_out_posearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_out_posearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_posearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_posearch.lists["x_s_grp"] = <?php echo $material_out_po_search->s_grp->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_po_search->s_grp->lookupOptions()) ?>;
fmaterial_out_posearch.lists["x_product"] = <?php echo $material_out_po_search->product->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_product"].options = <?php echo JsonEncode($material_out_po_search->product->lookupOptions()) ?>;
fmaterial_out_posearch.lists["x_packing_type"] = <?php echo $material_out_po_search->packing_type->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_po_search->packing_type->lookupOptions()) ?>;
fmaterial_out_posearch.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_posearch.lists["x_godown"] = <?php echo $material_out_po_search->godown->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_godown"].options = <?php echo JsonEncode($material_out_po_search->godown->lookupOptions()) ?>;
fmaterial_out_posearch.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_posearch.lists["x_quantity_avg_act"] = <?php echo $material_out_po_search->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_po_search->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_posearch.lists["x_quantity"] = <?php echo $material_out_po_search->quantity->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_quantity"].options = <?php echo JsonEncode($material_out_po_search->quantity->lookupOptions()) ?>;
fmaterial_out_posearch.autoSuggests["x_quantity"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_posearch.lists["x_process"] = <?php echo $material_out_po_search->process->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_process"].options = <?php echo JsonEncode($material_out_po_search->process->lookupOptions()) ?>;
fmaterial_out_posearch.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_posearch.lists["x_issue_to"] = <?php echo $material_out_po_search->issue_to->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_po_search->issue_to->lookupOptions()) ?>;
fmaterial_out_posearch.lists["x_operator"] = <?php echo $material_out_po_search->operator->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_operator"].options = <?php echo JsonEncode($material_out_po_search->operator->lookupOptions()) ?>;
fmaterial_out_posearch.lists["x_status"] = <?php echo $material_out_po_search->status->Lookup->toClientList() ?>;
fmaterial_out_posearch.lists["x_status"].options = <?php echo JsonEncode($material_out_po_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fmaterial_out_posearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packing_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->packing_type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_godown");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->godown->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkRange(elm.value, 0.001, 10000))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_max_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->max_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->avg_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_process");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->process->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_po->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_po_search->showPageHeader(); ?>
<?php
$material_out_po_search->showMessage();
?>
<form name="fmaterial_out_posearch" id="fmaterial_out_posearch" class="<?php echo $material_out_po_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_po_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_po_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_po">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_po_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_out_po->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_id"><?php echo $material_out_po->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->id->cellAttributes() ?>>
			<span id="el_material_out_po_id">
<input type="text" data-table="material_out_po" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_out_po->id->getPlaceHolder()) ?>" value="<?php echo $material_out_po->id->EditValue ?>"<?php echo $material_out_po->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_s_grp"><?php echo $material_out_po->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->s_grp->cellAttributes() ?>>
			<span id="el_material_out_po_s_grp">
<?php $material_out_po->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out_po->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_po" data-field="x_s_grp" data-value-separator="<?php echo $material_out_po->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_out_po->s_grp->editAttributes() ?>>
		<?php echo $material_out_po->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_out_po->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_product"><?php echo $material_out_po->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->product->cellAttributes() ?>>
			<span id="el_material_out_po_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_po" data-field="x_product" data-value-separator="<?php echo $material_out_po->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_out_po->product->editAttributes() ?>>
		<?php echo $material_out_po->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_out_po->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_rid"><?php echo $material_out_po->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->rid->cellAttributes() ?>>
			<span id="el_material_out_po_rid">
<input type="text" data-table="material_out_po" data-field="x_rid" name="x_rid" id="x_rid" size="40" placeholder="<?php echo HtmlEncode($material_out_po->rid->getPlaceHolder()) ?>" value="<?php echo $material_out_po->rid->EditValue ?>"<?php echo $material_out_po->rid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_packing_type"><?php echo $material_out_po->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->packing_type->cellAttributes() ?>>
			<span id="el_material_out_po_packing_type">
<?php
$wrkonchange = "" . trim(@$material_out_po->packing_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_po->packing_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_packing_type" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_packing_type" id="sv_x_packing_type" value="<?php echo RemoveHtml($material_out_po->packing_type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_po->packing_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_po->packing_type->getPlaceHolder()) ?>"<?php echo $material_out_po->packing_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_po" data-field="x_packing_type" data-value-separator="<?php echo $material_out_po->packing_type->displayValueSeparatorAttribute() ?>" name="x_packing_type" id="x_packing_type" value="<?php echo HtmlEncode($material_out_po->packing_type->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_posearch.createAutoSuggest({"id":"x_packing_type","forceSelect":false});
</script>
<?php echo $material_out_po->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_godown"><?php echo $material_out_po->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->godown->cellAttributes() ?>>
			<span id="el_material_out_po_godown">
<?php
$wrkonchange = "" . trim(@$material_out_po->godown->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_po->godown->EditAttrs["onchange"] = "";
?>
<span id="as_x_godown" class="text-nowrap" style="z-index: 8930">
	<input type="text" class="form-control" name="sv_x_godown" id="sv_x_godown" value="<?php echo RemoveHtml($material_out_po->godown->EditValue) ?>" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($material_out_po->godown->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_po->godown->getPlaceHolder()) ?>"<?php echo $material_out_po->godown->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_po" data-field="x_godown" data-value-separator="<?php echo $material_out_po->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="<?php echo HtmlEncode($material_out_po->godown->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_posearch.createAutoSuggest({"id":"x_godown","forceSelect":false});
</script>
<?php echo $material_out_po->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<div id="r_quantity_avg_act" class="form-group row">
		<label class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_quantity_avg_act"><?php echo $material_out_po->quantity_avg_act->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity_avg_act" id="z_quantity_avg_act" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->quantity_avg_act->cellAttributes() ?>>
			<span id="el_material_out_po_quantity_avg_act">
<div id="tp_x_quantity_avg_act" class="ew-template"><input type="radio" class="form-check-input" data-table="material_out_po" data-field="x_quantity_avg_act" data-value-separator="<?php echo $material_out_po->quantity_avg_act->displayValueSeparatorAttribute() ?>" name="x_quantity_avg_act" id="x_quantity_avg_act" value="{value}"<?php echo $material_out_po->quantity_avg_act->editAttributes() ?>></div>
<div id="dsl_x_quantity_avg_act" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_out_po->quantity_avg_act->radioButtonListHtml(FALSE, "x_quantity_avg_act") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_packets"><?php echo $material_out_po->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->packets->cellAttributes() ?>>
			<span id="el_material_out_po_packets">
<input type="text" data-table="material_out_po" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($material_out_po->packets->getPlaceHolder()) ?>" value="<?php echo $material_out_po->packets->EditValue ?>"<?php echo $material_out_po->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label for="x_max_qty" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_max_qty"><?php echo $material_out_po->max_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_max_qty" id="z_max_qty" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->max_qty->cellAttributes() ?>>
			<span id="el_material_out_po_max_qty">
<input type="text" data-table="material_out_po" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" size="30" placeholder="<?php echo HtmlEncode($material_out_po->max_qty->getPlaceHolder()) ?>" value="<?php echo $material_out_po->max_qty->EditValue ?>"<?php echo $material_out_po->max_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->req_qty->Visible) { // req_qty ?>
	<div id="r_req_qty" class="form-group row">
		<label for="x_req_qty" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_req_qty"><?php echo $material_out_po->req_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_req_qty" id="z_req_qty" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->req_qty->cellAttributes() ?>>
			<span id="el_material_out_po_req_qty">
<input type="text" data-table="material_out_po" data-field="x_req_qty" name="x_req_qty" id="x_req_qty" placeholder="<?php echo HtmlEncode($material_out_po->req_qty->getPlaceHolder()) ?>" value="<?php echo $material_out_po->req_qty->EditValue ?>"<?php echo $material_out_po->req_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_quantity"><?php echo $material_out_po->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->quantity->cellAttributes() ?>>
			<span id="el_material_out_po_quantity">
<?php
$wrkonchange = "" . trim(@$material_out_po->quantity->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_po->quantity->EditAttrs["onchange"] = "";
?>
<span id="as_x_quantity" class="text-nowrap" style="z-index: 8880">
	<input type="text" class="form-control" name="sv_x_quantity" id="sv_x_quantity" value="<?php echo RemoveHtml($material_out_po->quantity->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_po->quantity->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_po->quantity->getPlaceHolder()) ?>"<?php echo $material_out_po->quantity->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_po" data-field="x_quantity" data-value-separator="<?php echo $material_out_po->quantity->displayValueSeparatorAttribute() ?>" name="x_quantity" id="x_quantity" value="<?php echo HtmlEncode($material_out_po->quantity->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_posearch.createAutoSuggest({"id":"x_quantity","forceSelect":false});
</script>
<?php echo $material_out_po->quantity->Lookup->getParamTag("p_x_quantity") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label for="x_avg_quantity" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_avg_quantity"><?php echo $material_out_po->avg_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_quantity" id="z_avg_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->avg_quantity->cellAttributes() ?>>
			<span id="el_material_out_po_avg_quantity">
<input type="text" data-table="material_out_po" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out_po->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $material_out_po->avg_quantity->EditValue ?>"<?php echo $material_out_po->avg_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_process"><?php echo $material_out_po->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->process->cellAttributes() ?>>
			<span id="el_material_out_po_process">
<?php
$wrkonchange = "" . trim(@$material_out_po->process->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out_po->process->EditAttrs["onchange"] = "";
?>
<span id="as_x_process" class="text-nowrap" style="z-index: 8860">
	<input type="text" class="form-control" name="sv_x_process" id="sv_x_process" value="<?php echo RemoveHtml($material_out_po->process->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_out_po->process->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out_po->process->getPlaceHolder()) ?>"<?php echo $material_out_po->process->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out_po" data-field="x_process" data-value-separator="<?php echo $material_out_po->process->displayValueSeparatorAttribute() ?>" name="x_process" id="x_process" value="<?php echo HtmlEncode($material_out_po->process->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_out_posearch.createAutoSuggest({"id":"x_process","forceSelect":false});
</script>
<?php echo $material_out_po->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_dated"><?php echo $material_out_po->dated->caption() ?></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_out_po->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_out_po->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_out_po->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_out_po->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_out_po->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_out_po->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_out_po->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_out_po->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_out_po->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_out_po_dated">
<input type="text" data-table="material_out_po" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($material_out_po->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_po->dated->EditValue ?>"<?php echo $material_out_po->dated->editAttributes() ?>>
<?php if (!$material_out_po->dated->ReadOnly && !$material_out_po->dated->Disabled && !isset($material_out_po->dated->EditAttrs["readonly"]) && !isset($material_out_po->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_posearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_out_po_dated" class="btw1_dated d-none">
<input type="text" data-table="material_out_po" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($material_out_po->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_po->dated->EditValue2 ?>"<?php echo $material_out_po->dated->editAttributes() ?>>
<?php if (!$material_out_po->dated->ReadOnly && !$material_out_po->dated->Disabled && !isset($material_out_po->dated->EditAttrs["readonly"]) && !isset($material_out_po->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_posearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label for="x_issue_to" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_issue_to"><?php echo $material_out_po->issue_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->issue_to->cellAttributes() ?>>
			<span id="el_material_out_po_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_po" data-field="x_issue_to" data-value-separator="<?php echo $material_out_po->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_out_po->issue_to->editAttributes() ?>>
		<?php echo $material_out_po->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $material_out_po->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_remarks"><?php echo $material_out_po->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->remarks->cellAttributes() ?>>
			<span id="el_material_out_po_remarks">
<input type="text" data-table="material_out_po" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="255" placeholder="<?php echo HtmlEncode($material_out_po->remarks->getPlaceHolder()) ?>" value="<?php echo $material_out_po->remarks->EditValue ?>"<?php echo $material_out_po->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_operator"><?php echo $material_out_po->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->operator->cellAttributes() ?>>
			<span id="el_material_out_po_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_po" data-field="x_operator" data-value-separator="<?php echo $material_out_po->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $material_out_po->operator->editAttributes() ?>>
		<?php echo $material_out_po->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $material_out_po->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_datetime"><?php echo $material_out_po->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->datetime->cellAttributes() ?>>
			<span id="el_material_out_po_datetime">
<input type="text" data-table="material_out_po" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($material_out_po->datetime->getPlaceHolder()) ?>" value="<?php echo $material_out_po->datetime->EditValue ?>"<?php echo $material_out_po->datetime->editAttributes() ?>>
<?php if (!$material_out_po->datetime->ReadOnly && !$material_out_po->datetime->Disabled && !isset($material_out_po->datetime->EditAttrs["readonly"]) && !isset($material_out_po->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_posearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out_po->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $material_out_po_search->LeftColumnClass ?>"><span id="elh_material_out_po_status"><?php echo $material_out_po->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $material_out_po_search->RightColumnClass ?>"><div<?php echo $material_out_po->status->cellAttributes() ?>>
			<span id="el_material_out_po_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_po" data-field="x_status" data-value-separator="<?php echo $material_out_po->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $material_out_po->status->editAttributes() ?>>
		<?php echo $material_out_po->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_po_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_po_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_out_po_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_out_po_search->terminate();
?>