<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_po_view = new material_out_po_view();

// Run the page
$material_out_po_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_po_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out_po->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmaterial_out_poview = currentForm = new ew.Form("fmaterial_out_poview", "view");

// Form_CustomValidate event
fmaterial_out_poview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_poview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_poview.lists["x_s_grp"] = <?php echo $material_out_po_view->s_grp->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_po_view->s_grp->lookupOptions()) ?>;
fmaterial_out_poview.lists["x_product"] = <?php echo $material_out_po_view->product->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_product"].options = <?php echo JsonEncode($material_out_po_view->product->lookupOptions()) ?>;
fmaterial_out_poview.lists["x_packing_type"] = <?php echo $material_out_po_view->packing_type->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_po_view->packing_type->lookupOptions()) ?>;
fmaterial_out_poview.autoSuggests["x_packing_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_poview.lists["x_godown"] = <?php echo $material_out_po_view->godown->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_godown"].options = <?php echo JsonEncode($material_out_po_view->godown->lookupOptions()) ?>;
fmaterial_out_poview.autoSuggests["x_godown"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_poview.lists["x_quantity_avg_act"] = <?php echo $material_out_po_view->quantity_avg_act->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($material_out_po_view->quantity_avg_act->options(FALSE, TRUE)) ?>;
fmaterial_out_poview.lists["x_quantity"] = <?php echo $material_out_po_view->quantity->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_quantity"].options = <?php echo JsonEncode($material_out_po_view->quantity->lookupOptions()) ?>;
fmaterial_out_poview.autoSuggests["x_quantity"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_poview.lists["x_process"] = <?php echo $material_out_po_view->process->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_process"].options = <?php echo JsonEncode($material_out_po_view->process->lookupOptions()) ?>;
fmaterial_out_poview.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_out_poview.lists["x_issue_to"] = <?php echo $material_out_po_view->issue_to->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_po_view->issue_to->lookupOptions()) ?>;
fmaterial_out_poview.lists["x_operator"] = <?php echo $material_out_po_view->operator->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_operator"].options = <?php echo JsonEncode($material_out_po_view->operator->lookupOptions()) ?>;
fmaterial_out_poview.lists["x_status"] = <?php echo $material_out_po_view->status->Lookup->toClientList() ?>;
fmaterial_out_poview.lists["x_status"].options = <?php echo JsonEncode($material_out_po_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_out_po->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $material_out_po_view->ExportOptions->render("body") ?>
<?php $material_out_po_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $material_out_po_view->showPageHeader(); ?>
<?php
$material_out_po_view->showMessage();
?>
<form name="fmaterial_out_poview" id="fmaterial_out_poview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_po_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_po_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_po">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_po_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($material_out_po->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_id"><?php echo $material_out_po->id->caption() ?></span></td>
		<td data-name="id"<?php echo $material_out_po->id->cellAttributes() ?>>
<span id="el_material_out_po_id">
<span<?php echo $material_out_po->id->viewAttributes() ?>>
<?php echo $material_out_po->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_s_grp"><?php echo $material_out_po->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $material_out_po->s_grp->cellAttributes() ?>>
<span id="el_material_out_po_s_grp">
<span<?php echo $material_out_po->s_grp->viewAttributes() ?>>
<?php echo $material_out_po->s_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_product"><?php echo $material_out_po->product->caption() ?></span></td>
		<td data-name="product"<?php echo $material_out_po->product->cellAttributes() ?>>
<span id="el_material_out_po_product">
<span<?php echo $material_out_po->product->viewAttributes() ?>>
<?php echo $material_out_po->product->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_packing_type"><?php echo $material_out_po->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $material_out_po->packing_type->cellAttributes() ?>>
<span id="el_material_out_po_packing_type">
<span<?php echo $material_out_po->packing_type->viewAttributes() ?>>
<?php echo $material_out_po->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->godown->Visible) { // godown ?>
	<tr id="r_godown">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_godown"><?php echo $material_out_po->godown->caption() ?></span></td>
		<td data-name="godown"<?php echo $material_out_po->godown->cellAttributes() ?>>
<span id="el_material_out_po_godown">
<span<?php echo $material_out_po->godown->viewAttributes() ?>>
<?php echo $material_out_po->godown->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<tr id="r_quantity_avg_act">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_quantity_avg_act"><?php echo $material_out_po->quantity_avg_act->caption() ?></span></td>
		<td data-name="quantity_avg_act"<?php echo $material_out_po->quantity_avg_act->cellAttributes() ?>>
<span id="el_material_out_po_quantity_avg_act">
<span<?php echo $material_out_po->quantity_avg_act->viewAttributes() ?>>
<?php echo $material_out_po->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->packets->Visible) { // packets ?>
	<tr id="r_packets">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_packets"><?php echo $material_out_po->packets->caption() ?></span></td>
		<td data-name="packets"<?php echo $material_out_po->packets->cellAttributes() ?>>
<span id="el_material_out_po_packets">
<span<?php echo $material_out_po->packets->viewAttributes() ?>>
<?php echo $material_out_po->packets->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->max_qty->Visible) { // max_qty ?>
	<tr id="r_max_qty">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_max_qty"><?php echo $material_out_po->max_qty->caption() ?></span></td>
		<td data-name="max_qty"<?php echo $material_out_po->max_qty->cellAttributes() ?>>
<span id="el_material_out_po_max_qty">
<span<?php echo $material_out_po->max_qty->viewAttributes() ?>>
<?php echo $material_out_po->max_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->req_qty->Visible) { // req_qty ?>
	<tr id="r_req_qty">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_req_qty"><?php echo $material_out_po->req_qty->caption() ?></span></td>
		<td data-name="req_qty"<?php echo $material_out_po->req_qty->cellAttributes() ?>>
<span id="el_material_out_po_req_qty">
<span<?php echo $material_out_po->req_qty->viewAttributes() ?>>
<?php echo $material_out_po->req_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_quantity"><?php echo $material_out_po->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $material_out_po->quantity->cellAttributes() ?>>
<span id="el_material_out_po_quantity">
<span<?php echo $material_out_po->quantity->viewAttributes() ?>>
<?php echo $material_out_po->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->avg_quantity->Visible) { // avg_quantity ?>
	<tr id="r_avg_quantity">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_avg_quantity"><?php echo $material_out_po->avg_quantity->caption() ?></span></td>
		<td data-name="avg_quantity"<?php echo $material_out_po->avg_quantity->cellAttributes() ?>>
<span id="el_material_out_po_avg_quantity">
<span<?php echo $material_out_po->avg_quantity->viewAttributes() ?>>
<?php echo $material_out_po->avg_quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_process"><?php echo $material_out_po->process->caption() ?></span></td>
		<td data-name="process"<?php echo $material_out_po->process->cellAttributes() ?>>
<span id="el_material_out_po_process">
<span<?php echo $material_out_po->process->viewAttributes() ?>>
<?php echo $material_out_po->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_dated"><?php echo $material_out_po->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $material_out_po->dated->cellAttributes() ?>>
<span id="el_material_out_po_dated">
<span<?php echo $material_out_po->dated->viewAttributes() ?>>
<?php echo $material_out_po->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->issue_to->Visible) { // issue_to ?>
	<tr id="r_issue_to">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_issue_to"><?php echo $material_out_po->issue_to->caption() ?></span></td>
		<td data-name="issue_to"<?php echo $material_out_po->issue_to->cellAttributes() ?>>
<span id="el_material_out_po_issue_to">
<span<?php echo $material_out_po->issue_to->viewAttributes() ?>>
<?php echo $material_out_po->issue_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_remarks"><?php echo $material_out_po->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $material_out_po->remarks->cellAttributes() ?>>
<span id="el_material_out_po_remarks">
<span<?php echo $material_out_po->remarks->viewAttributes() ?>>
<?php echo $material_out_po->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_operator"><?php echo $material_out_po->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $material_out_po->operator->cellAttributes() ?>>
<span id="el_material_out_po_operator">
<span<?php echo $material_out_po->operator->viewAttributes() ?>>
<?php echo $material_out_po->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_datetime"><?php echo $material_out_po->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $material_out_po->datetime->cellAttributes() ?>>
<span id="el_material_out_po_datetime">
<span<?php echo $material_out_po->datetime->viewAttributes() ?>>
<?php echo $material_out_po->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out_po->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $material_out_po_view->TableLeftColumnClass ?>"><span id="elh_material_out_po_status"><?php echo $material_out_po->status->caption() ?></span></td>
		<td data-name="status"<?php echo $material_out_po->status->cellAttributes() ?>>
<span id="el_material_out_po_status">
<span<?php echo $material_out_po->status->viewAttributes() ?>>
<?php echo $material_out_po->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$material_out_po_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out_po->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_po_view->terminate();
?>