<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_wbc_list = new material_out_wbc_list();

// Run the page
$material_out_wbc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_wbc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out_wbc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_out_wbclist = currentForm = new ew.Form("fmaterial_out_wbclist", "list");
fmaterial_out_wbclist.formKeyCountName = '<?php echo $material_out_wbc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_out_wbclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_wbclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_wbclist.lists["x_process"] = <?php echo $material_out_wbc_list->process->Lookup->toClientList() ?>;
fmaterial_out_wbclist.lists["x_process"].options = <?php echo JsonEncode($material_out_wbc_list->process->lookupOptions()) ?>;
fmaterial_out_wbclist.lists["x_issue_to"] = <?php echo $material_out_wbc_list->issue_to->Lookup->toClientList() ?>;
fmaterial_out_wbclist.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_wbc_list->issue_to->lookupOptions()) ?>;
fmaterial_out_wbclist.lists["x_godown"] = <?php echo $material_out_wbc_list->godown->Lookup->toClientList() ?>;
fmaterial_out_wbclist.lists["x_godown"].options = <?php echo JsonEncode($material_out_wbc_list->godown->lookupOptions()) ?>;
fmaterial_out_wbclist.lists["x_rid"] = <?php echo $material_out_wbc_list->rid->Lookup->toClientList() ?>;
fmaterial_out_wbclist.lists["x_rid"].options = <?php echo JsonEncode($material_out_wbc_list->rid->lookupOptions()) ?>;
fmaterial_out_wbclist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fmaterial_out_wbclistsrch = currentSearchForm = new ew.Form("fmaterial_out_wbclistsrch");

// Validate function for search
fmaterial_out_wbclistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out_wbc->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_out_wbclistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_out_wbclistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_out_wbclistsrch.lists["x_process"] = <?php echo $material_out_wbc_list->process->Lookup->toClientList() ?>;
fmaterial_out_wbclistsrch.lists["x_process"].options = <?php echo JsonEncode($material_out_wbc_list->process->lookupOptions()) ?>;
fmaterial_out_wbclistsrch.lists["x_issue_to"] = <?php echo $material_out_wbc_list->issue_to->Lookup->toClientList() ?>;
fmaterial_out_wbclistsrch.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_wbc_list->issue_to->lookupOptions()) ?>;

// Filters
fmaterial_out_wbclistsrch.filterList = <?php echo $material_out_wbc_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_out_wbclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_out_wbc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_out_wbc_list->TotalRecs > 0 && $material_out_wbc_list->ExportOptions->visible()) { ?>
<?php $material_out_wbc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_wbc_list->ImportOptions->visible()) { ?>
<?php $material_out_wbc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_wbc_list->SearchOptions->visible()) { ?>
<?php $material_out_wbc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_wbc_list->FilterOptions->visible()) { ?>
<?php $material_out_wbc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_out_wbc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_out_wbc->isExport() && !$material_out_wbc->CurrentAction) { ?>
<form name="fmaterial_out_wbclistsrch" id="fmaterial_out_wbclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_out_wbc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_out_wbclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_out_wbc">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_out_wbc_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_out_wbc->RowType = ROWTYPE_SEARCH;

// Render row
$material_out_wbc->resetAttributes();
$material_out_wbc_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_out_wbc->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $material_out_wbc->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<?php $material_out_wbc->process->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out_wbc->process->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_wbc" data-field="x_process" data-value-separator="<?php echo $material_out_wbc->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $material_out_wbc->process->editAttributes() ?>>
		<?php echo $material_out_wbc->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $material_out_wbc->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out_wbc->issue_to->Visible) { // issue_to ?>
	<div id="xsc_issue_to" class="ew-cell form-group">
		<label for="x_issue_to" class="ew-search-caption ew-label"><?php echo $material_out_wbc->issue_to->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out_wbc" data-field="x_issue_to" data-value-separator="<?php echo $material_out_wbc->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_out_wbc->issue_to->editAttributes() ?>>
		<?php echo $material_out_wbc->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $material_out_wbc->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out_wbc->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $material_out_wbc->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_out_wbc->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_out_wbc->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_out_wbc->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_out_wbc->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_out_wbc->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_out_wbc->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_out_wbc->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_out_wbc->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_out_wbc->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="material_out_wbc" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($material_out_wbc->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_wbc->dated->EditValue ?>"<?php echo $material_out_wbc->dated->editAttributes() ?>>
<?php if (!$material_out_wbc->dated->ReadOnly && !$material_out_wbc->dated->Disabled && !isset($material_out_wbc->dated->EditAttrs["readonly"]) && !isset($material_out_wbc->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_wbclistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="material_out_wbc" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($material_out_wbc->dated->getPlaceHolder()) ?>" value="<?php echo $material_out_wbc->dated->EditValue2 ?>"<?php echo $material_out_wbc->dated->editAttributes() ?>>
<?php if (!$material_out_wbc->dated->ReadOnly && !$material_out_wbc->dated->Disabled && !isset($material_out_wbc->dated->EditAttrs["readonly"]) && !isset($material_out_wbc->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_out_wbclistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_out_wbc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_out_wbc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_out_wbc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_out_wbc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_out_wbc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_out_wbc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_out_wbc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_out_wbc_list->showPageHeader(); ?>
<?php
$material_out_wbc_list->showMessage();
?>
<?php if ($material_out_wbc_list->TotalRecs > 0 || $material_out_wbc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_out_wbc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_out_wbc">
<?php if (!$material_out_wbc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_out_wbc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_wbc_list->Pager)) $material_out_wbc_list->Pager = new PrevNextPager($material_out_wbc_list->StartRec, $material_out_wbc_list->DisplayRecs, $material_out_wbc_list->TotalRecs, $material_out_wbc_list->AutoHidePager) ?>
<?php if ($material_out_wbc_list->Pager->RecordCount > 0 && $material_out_wbc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_wbc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_wbc_list->pageUrl() ?>start=<?php echo $material_out_wbc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_wbc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_wbc_list->pageUrl() ?>start=<?php echo $material_out_wbc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_wbc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_wbc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_wbc_list->pageUrl() ?>start=<?php echo $material_out_wbc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_wbc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_wbc_list->pageUrl() ?>start=<?php echo $material_out_wbc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_wbc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_wbc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_wbc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_wbc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_wbc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_wbc_list->TotalRecs > 0 && (!$material_out_wbc_list->AutoHidePageSizeSelector || $material_out_wbc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_wbc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($material_out_wbc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_wbc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_wbc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($material_out_wbc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_wbc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_out_wbclist" id="fmaterial_out_wbclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_wbc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_wbc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out_wbc">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_material_out_wbc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_out_wbc_list->TotalRecs > 0 || $material_out_wbc->isGridEdit()) { ?>
<table id="tbl_material_out_wbclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_out_wbc_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_out_wbc_list->renderListOptions();

// Render list options (header, left)
$material_out_wbc_list->ListOptions->render("header", "left");
?>
<?php if ($material_out_wbc->id->Visible) { // id ?>
	<?php if ($material_out_wbc->sortUrl($material_out_wbc->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_out_wbc->id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_wbc_id" class="material_out_wbc_id"><div class="ew-table-header-caption"><?php echo $material_out_wbc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_out_wbc->id->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_wbc->SortUrl($material_out_wbc->id) ?>',1);"><div id="elh_material_out_wbc_id" class="material_out_wbc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_wbc->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_wbc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_wbc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_wbc->process->Visible) { // process ?>
	<?php if ($material_out_wbc->sortUrl($material_out_wbc->process) == "") { ?>
		<th data-name="process" class="<?php echo $material_out_wbc->process->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_wbc_process" class="material_out_wbc_process"><div class="ew-table-header-caption"><?php echo $material_out_wbc->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $material_out_wbc->process->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_wbc->SortUrl($material_out_wbc->process) ?>',1);"><div id="elh_material_out_wbc_process" class="material_out_wbc_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_wbc->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_wbc->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_wbc->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_wbc->issue_to->Visible) { // issue_to ?>
	<?php if ($material_out_wbc->sortUrl($material_out_wbc->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $material_out_wbc->issue_to->headerCellClass() ?>"><div id="elh_material_out_wbc_issue_to" class="material_out_wbc_issue_to"><div class="ew-table-header-caption"><?php echo $material_out_wbc->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $material_out_wbc->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_wbc->SortUrl($material_out_wbc->issue_to) ?>',1);"><div id="elh_material_out_wbc_issue_to" class="material_out_wbc_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_wbc->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_wbc->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_wbc->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_wbc->godown->Visible) { // godown ?>
	<?php if ($material_out_wbc->sortUrl($material_out_wbc->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $material_out_wbc->godown->headerCellClass() ?>"><div id="elh_material_out_wbc_godown" class="material_out_wbc_godown"><div class="ew-table-header-caption"><?php echo $material_out_wbc->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $material_out_wbc->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_wbc->SortUrl($material_out_wbc->godown) ?>',1);"><div id="elh_material_out_wbc_godown" class="material_out_wbc_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_wbc->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out_wbc->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_wbc->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_wbc->rid->Visible) { // rid ?>
	<?php if ($material_out_wbc->sortUrl($material_out_wbc->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $material_out_wbc->rid->headerCellClass() ?>"><div id="elh_material_out_wbc_rid" class="material_out_wbc_rid"><div class="ew-table-header-caption"><?php echo $material_out_wbc->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $material_out_wbc->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_wbc->SortUrl($material_out_wbc->rid) ?>',1);"><div id="elh_material_out_wbc_rid" class="material_out_wbc_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_wbc->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_wbc->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_wbc->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_wbc->quantity->Visible) { // quantity ?>
	<?php if ($material_out_wbc->sortUrl($material_out_wbc->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_out_wbc->quantity->headerCellClass() ?>"><div id="elh_material_out_wbc_quantity" class="material_out_wbc_quantity"><div class="ew-table-header-caption"><?php echo $material_out_wbc->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_out_wbc->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_wbc->SortUrl($material_out_wbc->quantity) ?>',1);"><div id="elh_material_out_wbc_quantity" class="material_out_wbc_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_wbc->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_wbc->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_wbc->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_wbc->dated->Visible) { // dated ?>
	<?php if ($material_out_wbc->sortUrl($material_out_wbc->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $material_out_wbc->dated->headerCellClass() ?>"><div id="elh_material_out_wbc_dated" class="material_out_wbc_dated"><div class="ew-table-header-caption"><?php echo $material_out_wbc->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $material_out_wbc->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_wbc->SortUrl($material_out_wbc->dated) ?>',1);"><div id="elh_material_out_wbc_dated" class="material_out_wbc_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_wbc->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_wbc->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_wbc->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out_wbc->jc_no->Visible) { // jc_no ?>
	<?php if ($material_out_wbc->sortUrl($material_out_wbc->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $material_out_wbc->jc_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_wbc_jc_no" class="material_out_wbc_jc_no"><div class="ew-table-header-caption"><?php echo $material_out_wbc->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $material_out_wbc->jc_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out_wbc->SortUrl($material_out_wbc->jc_no) ?>',1);"><div id="elh_material_out_wbc_jc_no" class="material_out_wbc_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out_wbc->jc_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out_wbc->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out_wbc->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_out_wbc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_out_wbc->ExportAll && $material_out_wbc->isExport()) {
	$material_out_wbc_list->StopRec = $material_out_wbc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_out_wbc_list->TotalRecs > $material_out_wbc_list->StartRec + $material_out_wbc_list->DisplayRecs - 1)
		$material_out_wbc_list->StopRec = $material_out_wbc_list->StartRec + $material_out_wbc_list->DisplayRecs - 1;
	else
		$material_out_wbc_list->StopRec = $material_out_wbc_list->TotalRecs;
}
$material_out_wbc_list->RecCnt = $material_out_wbc_list->StartRec - 1;
if ($material_out_wbc_list->Recordset && !$material_out_wbc_list->Recordset->EOF) {
	$material_out_wbc_list->Recordset->moveFirst();
	$selectLimit = $material_out_wbc_list->UseSelectLimit;
	if (!$selectLimit && $material_out_wbc_list->StartRec > 1)
		$material_out_wbc_list->Recordset->move($material_out_wbc_list->StartRec - 1);
} elseif (!$material_out_wbc->AllowAddDeleteRow && $material_out_wbc_list->StopRec == 0) {
	$material_out_wbc_list->StopRec = $material_out_wbc->GridAddRowCount;
}

// Initialize aggregate
$material_out_wbc->RowType = ROWTYPE_AGGREGATEINIT;
$material_out_wbc->resetAttributes();
$material_out_wbc_list->renderRow();
while ($material_out_wbc_list->RecCnt < $material_out_wbc_list->StopRec) {
	$material_out_wbc_list->RecCnt++;
	if ($material_out_wbc_list->RecCnt >= $material_out_wbc_list->StartRec) {
		$material_out_wbc_list->RowCnt++;

		// Set up key count
		$material_out_wbc_list->KeyCount = $material_out_wbc_list->RowIndex;

		// Init row class and style
		$material_out_wbc->resetAttributes();
		$material_out_wbc->CssClass = "";
		if ($material_out_wbc->isGridAdd()) {
		} else {
			$material_out_wbc_list->loadRowValues($material_out_wbc_list->Recordset); // Load row values
		}
		$material_out_wbc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_out_wbc->RowAttrs = array_merge($material_out_wbc->RowAttrs, array('data-rowindex'=>$material_out_wbc_list->RowCnt, 'id'=>'r' . $material_out_wbc_list->RowCnt . '_material_out_wbc', 'data-rowtype'=>$material_out_wbc->RowType));

		// Render row
		$material_out_wbc_list->renderRow();

		// Render list options
		$material_out_wbc_list->renderListOptions();
?>
	<tr<?php echo $material_out_wbc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_out_wbc_list->ListOptions->render("body", "left", $material_out_wbc_list->RowCnt);
?>
	<?php if ($material_out_wbc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_out_wbc->id->cellAttributes() ?>>
<span id="el<?php echo $material_out_wbc_list->RowCnt ?>_material_out_wbc_id" class="material_out_wbc_id">
<span<?php echo $material_out_wbc->id->viewAttributes() ?>>
<?php echo $material_out_wbc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_wbc->process->Visible) { // process ?>
		<td data-name="process"<?php echo $material_out_wbc->process->cellAttributes() ?>>
<span id="el<?php echo $material_out_wbc_list->RowCnt ?>_material_out_wbc_process" class="material_out_wbc_process">
<span<?php echo $material_out_wbc->process->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_wbc->process->getViewValue())) && $material_out_wbc->process->linkAttributes() <> "") { ?>
<a<?php echo $material_out_wbc->process->linkAttributes() ?>><?php echo $material_out_wbc->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_wbc->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_wbc->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $material_out_wbc->issue_to->cellAttributes() ?>>
<span id="el<?php echo $material_out_wbc_list->RowCnt ?>_material_out_wbc_issue_to" class="material_out_wbc_issue_to">
<span<?php echo $material_out_wbc->issue_to->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_wbc->issue_to->getViewValue())) && $material_out_wbc->issue_to->linkAttributes() <> "") { ?>
<a<?php echo $material_out_wbc->issue_to->linkAttributes() ?>><?php echo $material_out_wbc->issue_to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_wbc->issue_to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_wbc->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $material_out_wbc->godown->cellAttributes() ?>>
<span id="el<?php echo $material_out_wbc_list->RowCnt ?>_material_out_wbc_godown" class="material_out_wbc_godown">
<span<?php echo $material_out_wbc->godown->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_wbc->godown->getViewValue())) && $material_out_wbc->godown->linkAttributes() <> "") { ?>
<a<?php echo $material_out_wbc->godown->linkAttributes() ?>><?php echo $material_out_wbc->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_wbc->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_wbc->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $material_out_wbc->rid->cellAttributes() ?>>
<span id="el<?php echo $material_out_wbc_list->RowCnt ?>_material_out_wbc_rid" class="material_out_wbc_rid">
<span<?php echo $material_out_wbc->rid->viewAttributes() ?>>
<?php if ((!EmptyString($material_out_wbc->rid->getViewValue())) && $material_out_wbc->rid->linkAttributes() <> "") { ?>
<a<?php echo $material_out_wbc->rid->linkAttributes() ?>><?php echo $material_out_wbc->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out_wbc->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_wbc->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_out_wbc->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_out_wbc_list->RowCnt ?>_material_out_wbc_quantity" class="material_out_wbc_quantity">
<span<?php echo $material_out_wbc->quantity->viewAttributes() ?>>
<?php echo $material_out_wbc->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_wbc->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $material_out_wbc->dated->cellAttributes() ?>>
<span id="el<?php echo $material_out_wbc_list->RowCnt ?>_material_out_wbc_dated" class="material_out_wbc_dated">
<span<?php echo $material_out_wbc->dated->viewAttributes() ?>>
<?php echo $material_out_wbc->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out_wbc->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $material_out_wbc->jc_no->cellAttributes() ?>>
<span id="el<?php echo $material_out_wbc_list->RowCnt ?>_material_out_wbc_jc_no" class="material_out_wbc_jc_no">
<span<?php echo $material_out_wbc->jc_no->viewAttributes() ?>>
<?php echo $material_out_wbc->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_out_wbc_list->ListOptions->render("body", "right", $material_out_wbc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_out_wbc->isGridAdd())
		$material_out_wbc_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$material_out_wbc->RowType = ROWTYPE_AGGREGATE;
$material_out_wbc->resetAttributes();
$material_out_wbc_list->renderRow();
?>
<?php if ($material_out_wbc_list->TotalRecs > 0 && !$material_out_wbc->isGridAdd() && !$material_out_wbc->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$material_out_wbc_list->renderListOptions();

// Render list options (footer, left)
$material_out_wbc_list->ListOptions->render("footer", "left");
?>
	<?php if ($material_out_wbc->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $material_out_wbc->id->footerCellClass() ?>"><span id="elf_material_out_wbc_id" class="material_out_wbc_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_wbc->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $material_out_wbc->process->footerCellClass() ?>"><span id="elf_material_out_wbc_process" class="material_out_wbc_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_wbc->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $material_out_wbc->issue_to->footerCellClass() ?>"><span id="elf_material_out_wbc_issue_to" class="material_out_wbc_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_wbc->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $material_out_wbc->godown->footerCellClass() ?>"><span id="elf_material_out_wbc_godown" class="material_out_wbc_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_wbc->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $material_out_wbc->rid->footerCellClass() ?>"><span id="elf_material_out_wbc_rid" class="material_out_wbc_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_wbc->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $material_out_wbc->quantity->footerCellClass() ?>"><span id="elf_material_out_wbc_quantity" class="material_out_wbc_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_out_wbc->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_out_wbc->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $material_out_wbc->dated->footerCellClass() ?>"><span id="elf_material_out_wbc_dated" class="material_out_wbc_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out_wbc->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no" class="<?php echo $material_out_wbc->jc_no->footerCellClass() ?>"><span id="elf_material_out_wbc_jc_no" class="material_out_wbc_jc_no">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$material_out_wbc_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_out_wbc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_out_wbc_list->Recordset)
	$material_out_wbc_list->Recordset->Close();
?>
<?php if (!$material_out_wbc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_out_wbc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_wbc_list->Pager)) $material_out_wbc_list->Pager = new PrevNextPager($material_out_wbc_list->StartRec, $material_out_wbc_list->DisplayRecs, $material_out_wbc_list->TotalRecs, $material_out_wbc_list->AutoHidePager) ?>
<?php if ($material_out_wbc_list->Pager->RecordCount > 0 && $material_out_wbc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_wbc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_wbc_list->pageUrl() ?>start=<?php echo $material_out_wbc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_wbc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_wbc_list->pageUrl() ?>start=<?php echo $material_out_wbc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_wbc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_wbc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_wbc_list->pageUrl() ?>start=<?php echo $material_out_wbc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_wbc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_wbc_list->pageUrl() ?>start=<?php echo $material_out_wbc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_wbc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_wbc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_wbc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_wbc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_wbc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_wbc_list->TotalRecs > 0 && (!$material_out_wbc_list->AutoHidePageSizeSelector || $material_out_wbc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out_wbc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($material_out_wbc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_wbc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_wbc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($material_out_wbc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_wbc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_out_wbc_list->TotalRecs == 0 && !$material_out_wbc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_out_wbc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_out_wbc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out_wbc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_out_wbc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_out_wbc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_wbc_list->terminate();
?>