<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_add = new material_out_add();

// Run the page
$material_out_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fmaterial_outadd = currentForm = new ew.Form("fmaterial_outadd", "add");

// Validate form
fmaterial_outadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($material_out_add->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->process->caption(), $material_out->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->process_type->Required) { ?>
			elm = this.getElements("x" + infix + "_process_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->process_type->caption(), $material_out->process_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->issue_to_unit->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->issue_to_unit->caption(), $material_out->issue_to_unit->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_issue_to_unit");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->issue_to_unit->errorMessage()) ?>");
		<?php if ($material_out_add->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->issue_to->caption(), $material_out->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->godown->caption(), $material_out->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->jc_no->caption(), $material_out->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->grp->caption(), $material_out->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->s_grp->caption(), $material_out->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->product->caption(), $material_out->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->rid_1->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->rid_1->caption(), $material_out->rid_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->packing_type->caption(), $material_out->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->rid_2->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->rid_2->caption(), $material_out->rid_2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->rid_3->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->rid_3->caption(), $material_out->rid_3->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->rid->caption(), $material_out->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->lot_no->caption(), $material_out->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->avg_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->avg_quantity->caption(), $material_out->avg_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->avg_quantity->errorMessage()) ?>");
		<?php if ($material_out_add->max_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->max_qty->caption(), $material_out->max_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->max_qty->errorMessage()) ?>");
		<?php if ($material_out_add->quantity_sub->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity_sub");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->quantity_sub->caption(), $material_out->quantity_sub->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity_sub");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->quantity_sub->errorMessage()) ?>");
		<?php if ($material_out_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->quantity->caption(), $material_out->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->quantity->errorMessage()) ?>");
		<?php if ($material_out_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->packets->caption(), $material_out->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->price->caption(), $material_out->price->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->price->errorMessage()) ?>");
		<?php if ($material_out_add->cart_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_cart_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->cart_amount->caption(), $material_out->cart_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cart_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->cart_amount->errorMessage()) ?>");
		<?php if ($material_out_add->other_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_other_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->other_amount->caption(), $material_out->other_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_other_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->other_amount->errorMessage()) ?>");
		<?php if ($material_out_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->operator->caption(), $material_out->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->datetime->caption(), $material_out->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->dated->caption(), $material_out->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->dated->errorMessage()) ?>");
		<?php if ($material_out_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->remarks->caption(), $material_out->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $material_out->uploads->caption(), $material_out->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_add->godown_po->Required) { ?>
			elm = this.getElements("x" + infix + "_godown_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->godown_po->caption(), $material_out->godown_po->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_godown_po");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->godown_po->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmaterial_outadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_outadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_outadd.lists["x_process"] = <?php echo $material_out_add->process->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_process"].options = <?php echo JsonEncode($material_out_add->process->lookupOptions()) ?>;
fmaterial_outadd.lists["x_process_type"] = <?php echo $material_out_add->process_type->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_process_type"].options = <?php echo JsonEncode($material_out_add->process_type->lookupOptions()) ?>;
fmaterial_outadd.lists["x_issue_to"] = <?php echo $material_out_add->issue_to->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_add->issue_to->lookupOptions()) ?>;
fmaterial_outadd.lists["x_godown"] = <?php echo $material_out_add->godown->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_godown"].options = <?php echo JsonEncode($material_out_add->godown->lookupOptions()) ?>;
fmaterial_outadd.lists["x_grp"] = <?php echo $material_out_add->grp->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_grp"].options = <?php echo JsonEncode($material_out_add->grp->lookupOptions()) ?>;
fmaterial_outadd.lists["x_s_grp"] = <?php echo $material_out_add->s_grp->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_add->s_grp->lookupOptions()) ?>;
fmaterial_outadd.lists["x_product"] = <?php echo $material_out_add->product->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_product"].options = <?php echo JsonEncode($material_out_add->product->lookupOptions()) ?>;
fmaterial_outadd.lists["x_rid_1"] = <?php echo $material_out_add->rid_1->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_rid_1"].options = <?php echo JsonEncode($material_out_add->rid_1->lookupOptions()) ?>;
fmaterial_outadd.lists["x_packing_type"] = <?php echo $material_out_add->packing_type->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_add->packing_type->lookupOptions()) ?>;
fmaterial_outadd.lists["x_rid_2"] = <?php echo $material_out_add->rid_2->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_rid_2"].options = <?php echo JsonEncode($material_out_add->rid_2->lookupOptions()) ?>;
fmaterial_outadd.lists["x_rid_3"] = <?php echo $material_out_add->rid_3->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_rid_3"].options = <?php echo JsonEncode($material_out_add->rid_3->lookupOptions()) ?>;
fmaterial_outadd.lists["x_rid"] = <?php echo $material_out_add->rid->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_rid"].options = <?php echo JsonEncode($material_out_add->rid->lookupOptions()) ?>;
fmaterial_outadd.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_outadd.lists["x_operator"] = <?php echo $material_out_add->operator->Lookup->toClientList() ?>;
fmaterial_outadd.lists["x_operator"].options = <?php echo JsonEncode($material_out_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_add->showPageHeader(); ?>
<?php
$material_out_add->showMessage();
?>
<form name="fmaterial_outadd" id="fmaterial_outadd" class="<?php echo $material_out_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($material_out->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_material_out_process" for="x_process" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->process->caption() ?><?php echo ($material_out->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->process->cellAttributes() ?>>
<span id="el_material_out_process">
<?php $material_out->process->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out->process->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_process" data-value-separator="<?php echo $material_out->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $material_out->process->editAttributes() ?>>
		<?php echo $material_out->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $material_out->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $material_out->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->process_type->Visible) { // process_type ?>
	<div id="r_process_type" class="form-group row">
		<label id="elh_material_out_process_type" for="x_process_type" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->process_type->caption() ?><?php echo ($material_out->process_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->process_type->cellAttributes() ?>>
<span id="el_material_out_process_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_process_type" data-value-separator="<?php echo $material_out->process_type->displayValueSeparatorAttribute() ?>" id="x_process_type" name="x_process_type"<?php echo $material_out->process_type->editAttributes() ?>>
		<?php echo $material_out->process_type->selectOptionListHtml("x_process_type") ?>
	</select>
</div>
<?php echo $material_out->process_type->Lookup->getParamTag("p_x_process_type") ?>
</span>
<?php echo $material_out->process_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->issue_to_unit->Visible) { // issue_to_unit ?>
	<div id="r_issue_to_unit" class="form-group row">
		<label id="elh_material_out_issue_to_unit" for="x_issue_to_unit" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->issue_to_unit->caption() ?><?php echo ($material_out->issue_to_unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->issue_to_unit->cellAttributes() ?>>
<span id="el_material_out_issue_to_unit">
<input type="text" data-table="material_out" data-field="x_issue_to_unit" name="x_issue_to_unit" id="x_issue_to_unit" size="30" placeholder="<?php echo HtmlEncode($material_out->issue_to_unit->getPlaceHolder()) ?>" value="<?php echo $material_out->issue_to_unit->EditValue ?>"<?php echo $material_out->issue_to_unit->editAttributes() ?>>
</span>
<?php echo $material_out->issue_to_unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_material_out_issue_to" for="x_issue_to" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->issue_to->caption() ?><?php echo ($material_out->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->issue_to->cellAttributes() ?>>
<span id="el_material_out_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_issue_to" data-value-separator="<?php echo $material_out->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_out->issue_to->editAttributes() ?>>
		<?php echo $material_out->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $material_out->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
<?php echo $material_out->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_material_out_godown" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->godown->caption() ?><?php echo ($material_out->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->godown->cellAttributes() ?>>
<span id="el_material_out_godown">
<?php $material_out->godown->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$material_out->godown->EditAttrs["onclick"]; ?>
<div id="tp_x_godown" class="ew-template"><input type="radio" class="form-check-input" data-table="material_out" data-field="x_godown" data-value-separator="<?php echo $material_out->godown->displayValueSeparatorAttribute() ?>" name="x_godown" id="x_godown" value="{value}"<?php echo $material_out->godown->editAttributes() ?>></div>
<div id="dsl_x_godown" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_out->godown->radioButtonListHtml(FALSE, "x_godown") ?>
</div></div>
<?php echo $material_out->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $material_out->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_material_out_jc_no" for="x_jc_no" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->jc_no->caption() ?><?php echo ($material_out->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->jc_no->cellAttributes() ?>>
<span id="el_material_out_jc_no">
<input type="text" data-table="material_out" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($material_out->jc_no->getPlaceHolder()) ?>" value="<?php echo $material_out->jc_no->EditValue ?>"<?php echo $material_out->jc_no->editAttributes() ?>>
</span>
<?php echo $material_out->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_material_out_grp" for="x_grp" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->grp->caption() ?><?php echo ($material_out->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->grp->cellAttributes() ?>>
<span id="el_material_out_grp">
<?php $material_out->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_grp" data-value-separator="<?php echo $material_out->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_out->grp->editAttributes() ?>>
		<?php echo $material_out->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $material_out->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $material_out->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_material_out_s_grp" for="x_s_grp" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->s_grp->caption() ?><?php echo ($material_out->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->s_grp->cellAttributes() ?>>
<span id="el_material_out_s_grp">
<?php $material_out->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_s_grp" data-value-separator="<?php echo $material_out->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_out->s_grp->editAttributes() ?>>
		<?php echo $material_out->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_out->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $material_out->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_material_out_product" for="x_product" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->product->caption() ?><?php echo ($material_out->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->product->cellAttributes() ?>>
<span id="el_material_out_product">
<?php $material_out->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_product" data-value-separator="<?php echo $material_out->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_out->product->editAttributes() ?>>
		<?php echo $material_out->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_out->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $material_out->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid_1->Visible) { // rid_1 ?>
	<div id="r_rid_1" class="form-group row">
		<label id="elh_material_out_rid_1" for="x_rid_1" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->rid_1->caption() ?><?php echo ($material_out->rid_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->rid_1->cellAttributes() ?>>
<span id="el_material_out_rid_1">
<?php $material_out->rid_1->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out->rid_1->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_1"><?php echo strval($material_out->rid_1->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($material_out->rid_1->ViewValue) : $material_out->rid_1->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_out->rid_1->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($material_out->rid_1->ReadOnly || $material_out->rid_1->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_1',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $material_out->rid_1->Lookup->getParamTag("p_x_rid_1") ?>
<input type="hidden" data-table="material_out" data-field="x_rid_1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_out->rid_1->displayValueSeparatorAttribute() ?>" name="x_rid_1" id="x_rid_1" value="<?php echo $material_out->rid_1->CurrentValue ?>"<?php echo $material_out->rid_1->editAttributes() ?>>
</span>
<?php echo $material_out->rid_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_material_out_packing_type" for="x_packing_type" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->packing_type->caption() ?><?php echo ($material_out->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->packing_type->cellAttributes() ?>>
<span id="el_material_out_packing_type">
<?php $material_out->packing_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out->packing_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_packing_type" data-value-separator="<?php echo $material_out->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $material_out->packing_type->editAttributes() ?>>
		<?php echo $material_out->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $material_out->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $material_out->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid_2->Visible) { // rid_2 ?>
	<div id="r_rid_2" class="form-group row">
		<label id="elh_material_out_rid_2" for="x_rid_2" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->rid_2->caption() ?><?php echo ($material_out->rid_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->rid_2->cellAttributes() ?>>
<span id="el_material_out_rid_2">
<?php $material_out->rid_2->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out->rid_2->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_2"><?php echo strval($material_out->rid_2->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($material_out->rid_2->ViewValue) : $material_out->rid_2->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_out->rid_2->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($material_out->rid_2->ReadOnly || $material_out->rid_2->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_2',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $material_out->rid_2->Lookup->getParamTag("p_x_rid_2") ?>
<input type="hidden" data-table="material_out" data-field="x_rid_2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_out->rid_2->displayValueSeparatorAttribute() ?>" name="x_rid_2" id="x_rid_2" value="<?php echo $material_out->rid_2->CurrentValue ?>"<?php echo $material_out->rid_2->editAttributes() ?>>
</span>
<?php echo $material_out->rid_2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid_3->Visible) { // rid_3 ?>
	<div id="r_rid_3" class="form-group row">
		<label id="elh_material_out_rid_3" for="x_rid_3" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->rid_3->caption() ?><?php echo ($material_out->rid_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->rid_3->cellAttributes() ?>>
<span id="el_material_out_rid_3">
<?php $material_out->rid_3->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out->rid_3->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_3"><?php echo strval($material_out->rid_3->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($material_out->rid_3->ViewValue) : $material_out->rid_3->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_out->rid_3->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($material_out->rid_3->ReadOnly || $material_out->rid_3->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_3',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $material_out->rid_3->Lookup->getParamTag("p_x_rid_3") ?>
<input type="hidden" data-table="material_out" data-field="x_rid_3" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_out->rid_3->displayValueSeparatorAttribute() ?>" name="x_rid_3" id="x_rid_3" value="<?php echo $material_out->rid_3->CurrentValue ?>"<?php echo $material_out->rid_3->editAttributes() ?>>
</span>
<?php echo $material_out->rid_3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_material_out_rid" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->rid->caption() ?><?php echo ($material_out->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->rid->cellAttributes() ?>>
<span id="el_material_out_rid">
<?php
$wrkonchange = "" . trim(@$material_out->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8840">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($material_out->rid->EditValue) ?>" size="40" placeholder="<?php echo HtmlEncode($material_out->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out->rid->getPlaceHolder()) ?>"<?php echo $material_out->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out" data-field="x_rid" data-value-separator="<?php echo $material_out->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($material_out->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_outadd.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $material_out->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $material_out->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_material_out_lot_no" for="x_lot_no" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->lot_no->caption() ?><?php echo ($material_out->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->lot_no->cellAttributes() ?>>
<span id="el_material_out_lot_no">
<input type="text" data-table="material_out" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($material_out->lot_no->getPlaceHolder()) ?>" value="<?php echo $material_out->lot_no->EditValue ?>"<?php echo $material_out->lot_no->editAttributes() ?>>
</span>
<?php echo $material_out->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label id="elh_material_out_avg_quantity" for="x_avg_quantity" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->avg_quantity->caption() ?><?php echo ($material_out->avg_quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->avg_quantity->cellAttributes() ?>>
<span id="el_material_out_avg_quantity">
<input type="text" data-table="material_out" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $material_out->avg_quantity->EditValue ?>"<?php echo $material_out->avg_quantity->editAttributes() ?>>
</span>
<?php echo $material_out->avg_quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label id="elh_material_out_max_qty" for="x_max_qty" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->max_qty->caption() ?><?php echo ($material_out->max_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->max_qty->cellAttributes() ?>>
<span id="el_material_out_max_qty">
<input type="text" data-table="material_out" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" size="30" placeholder="<?php echo HtmlEncode($material_out->max_qty->getPlaceHolder()) ?>" value="<?php echo $material_out->max_qty->EditValue ?>"<?php echo $material_out->max_qty->editAttributes() ?>>
</span>
<?php echo $material_out->max_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->quantity_sub->Visible) { // quantity_sub ?>
	<div id="r_quantity_sub" class="form-group row">
		<label id="elh_material_out_quantity_sub" for="x_quantity_sub" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->quantity_sub->caption() ?><?php echo ($material_out->quantity_sub->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->quantity_sub->cellAttributes() ?>>
<span id="el_material_out_quantity_sub">
<input type="text" data-table="material_out" data-field="x_quantity_sub" name="x_quantity_sub" id="x_quantity_sub" size="30" placeholder="<?php echo HtmlEncode($material_out->quantity_sub->getPlaceHolder()) ?>" value="<?php echo $material_out->quantity_sub->EditValue ?>"<?php echo $material_out->quantity_sub->editAttributes() ?>>
</span>
<?php echo $material_out->quantity_sub->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_material_out_quantity" for="x_quantity" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->quantity->caption() ?><?php echo ($material_out->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->quantity->cellAttributes() ?>>
<span id="el_material_out_quantity">
<input type="text" data-table="material_out" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out->quantity->getPlaceHolder()) ?>" value="<?php echo $material_out->quantity->EditValue ?>"<?php echo $material_out->quantity->editAttributes() ?>>
</span>
<?php echo $material_out->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_material_out_packets" for="x_packets" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->packets->caption() ?><?php echo ($material_out->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->packets->cellAttributes() ?>>
<span id="el_material_out_packets">
<input type="text" data-table="material_out" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($material_out->packets->getPlaceHolder()) ?>" value="<?php echo $material_out->packets->EditValue ?>"<?php echo $material_out->packets->editAttributes() ?>>
</span>
<?php echo $material_out->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_material_out_price" for="x_price" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->price->caption() ?><?php echo ($material_out->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->price->cellAttributes() ?>>
<span id="el_material_out_price">
<input type="text" data-table="material_out" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($material_out->price->getPlaceHolder()) ?>" value="<?php echo $material_out->price->EditValue ?>"<?php echo $material_out->price->editAttributes() ?>>
</span>
<?php echo $material_out->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->cart_amount->Visible) { // cart_amount ?>
	<div id="r_cart_amount" class="form-group row">
		<label id="elh_material_out_cart_amount" for="x_cart_amount" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->cart_amount->caption() ?><?php echo ($material_out->cart_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->cart_amount->cellAttributes() ?>>
<span id="el_material_out_cart_amount">
<input type="text" data-table="material_out" data-field="x_cart_amount" name="x_cart_amount" id="x_cart_amount" size="30" placeholder="<?php echo HtmlEncode($material_out->cart_amount->getPlaceHolder()) ?>" value="<?php echo $material_out->cart_amount->EditValue ?>"<?php echo $material_out->cart_amount->editAttributes() ?>>
</span>
<?php echo $material_out->cart_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->other_amount->Visible) { // other_amount ?>
	<div id="r_other_amount" class="form-group row">
		<label id="elh_material_out_other_amount" for="x_other_amount" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->other_amount->caption() ?><?php echo ($material_out->other_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->other_amount->cellAttributes() ?>>
<span id="el_material_out_other_amount">
<input type="text" data-table="material_out" data-field="x_other_amount" name="x_other_amount" id="x_other_amount" size="30" placeholder="<?php echo HtmlEncode($material_out->other_amount->getPlaceHolder()) ?>" value="<?php echo $material_out->other_amount->EditValue ?>"<?php echo $material_out->other_amount->editAttributes() ?>>
</span>
<?php echo $material_out->other_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_material_out_dated" for="x_dated" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->dated->caption() ?><?php echo ($material_out->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->dated->cellAttributes() ?>>
<span id="el_material_out_dated">
<input type="text" data-table="material_out" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($material_out->dated->getPlaceHolder()) ?>" value="<?php echo $material_out->dated->EditValue ?>"<?php echo $material_out->dated->editAttributes() ?>>
<?php if (!$material_out->dated->ReadOnly && !$material_out->dated->Disabled && !isset($material_out->dated->EditAttrs["readonly"]) && !isset($material_out->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_outadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_out->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_material_out_remarks" for="x_remarks" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->remarks->caption() ?><?php echo ($material_out->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->remarks->cellAttributes() ?>>
<span id="el_material_out_remarks">
<textarea data-table="material_out" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($material_out->remarks->getPlaceHolder()) ?>"<?php echo $material_out->remarks->editAttributes() ?>><?php echo $material_out->remarks->EditValue ?></textarea>
</span>
<?php echo $material_out->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_material_out_uploads" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->uploads->caption() ?><?php echo ($material_out->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->uploads->cellAttributes() ?>>
<span id="el_material_out_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $material_out->uploads->title() ? $material_out->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($material_out->uploads->ReadOnly || $material_out->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="material_out" data-field="x_uploads" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $material_out->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $material_out->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="250">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $material_out->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $material_out->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $material_out->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $material_out->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->godown_po->Visible) { // godown_po ?>
	<div id="r_godown_po" class="form-group row">
		<label id="elh_material_out_godown_po" for="x_godown_po" class="<?php echo $material_out_add->LeftColumnClass ?>"><?php echo $material_out->godown_po->caption() ?><?php echo ($material_out->godown_po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_add->RightColumnClass ?>"><div<?php echo $material_out->godown_po->cellAttributes() ?>>
<span id="el_material_out_godown_po">
<input type="text" data-table="material_out" data-field="x_godown_po" name="x_godown_po" id="x_godown_po" size="30" placeholder="<?php echo HtmlEncode($material_out->godown_po->getPlaceHolder()) ?>" value="<?php echo $material_out->godown_po->EditValue ?>"<?php echo $material_out->godown_po->editAttributes() ?>>
</span>
<?php echo $material_out->godown_po->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $material_out_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_out_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

	     var process= $('#x_process').val();
	     if (process == 101)
	     {
	     $("#r_process_type").hide();
	     $("#r_issue_to").show();
	     $("#r_jc_no").show();
	     $("#r_tmp_lot").hide();
	     $("#r_price").show();
	     $("#r_other_amount").show();
	     $("#r_cart_amount").show();	     
	     $("#r_rid_1").show();
	     $("#r_rid_3").show();	     	     
	     $("#r_rid_2").hide();	     
	     }
	     else if (process == 102)
	     {
	     $("#r_jc_no").hide();
	     $("#r_process_type").hide();
	     $("#r_issue_to").show();	     
	     $("#x_issue_to").val('');
	     $("#r_tmp_lot").hide();
   	     $("#r_price").show();
	     $("#r_other_amount").hide();
	     $("#r_cart_amount").show();
	     $("#r_rid_1").show();
	     $("#r_rid_3").show();	     	     
	     $("#r_rid_2").hide();	     
	     }
	     else if (process == 103)
	     {
	     $("#r_process_type").show();
	     $("#r_jc_no").show();
	     $("#r_issue_to").show();	     
	     $("#x_issue_to").val('');
	     $("#r_tmp_lot").hide();
	     $("#r_price").hide();
	     $("#r_other_amount").hide();
	     $("#r_cart_amount").hide();
	     $("#r_rid_1").show();		 		 
	     $("#r_rid_3").show();
	     $("#r_rid_2").hide();	     
	     }
	     else if (process == 104)
	     {
	     $("#r_process_type").show();
	     $("#r_jc_no").show();
	     $("#r_issue_to").hide();	     
	     $("#r_tmp_lot").hide();
	     $("#r_price").hide();
	     $("#r_other_amount").hide();
	     $("#r_cart_amount").hide();
	     $("#r_rid_1").show();
	     $("#r_rid_3").show();	     
	     $("#r_rid_2").hide();	     
	     }
	     else if (process == 109)
	     {
	     $("#r_process_type").show();
	     $("#r_jc_no").show();
	     $("#r_issue_to").hide();	     
	     $("#r_tmp_lot").hide();
	     $("#r_price").hide();
	     $("#r_other_amount").hide();
	     $("#r_cart_amount").hide();
	     $("#r_rid_1").hide();
	     $("#r_rid_3").hide();
	     $("#r_rid_2").show();
	     }
</script>
<?php include_once "footer.php" ?>
<?php
$material_out_add->terminate();
?>