<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_edit = new material_out_edit();

// Run the page
$material_out_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fmaterial_outedit = currentForm = new ew.Form("fmaterial_outedit", "edit");

// Validate form
fmaterial_outedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($material_out_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->id->caption(), $material_out->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->process->caption(), $material_out->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->process_type->Required) { ?>
			elm = this.getElements("x" + infix + "_process_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->process_type->caption(), $material_out->process_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->issue_to_unit->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->issue_to_unit->caption(), $material_out->issue_to_unit->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_issue_to_unit");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->issue_to_unit->errorMessage()) ?>");
		<?php if ($material_out_edit->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->issue_to->caption(), $material_out->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->godown->caption(), $material_out->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->grp->caption(), $material_out->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->s_grp->caption(), $material_out->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->product->caption(), $material_out->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->rid_1->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->rid_1->caption(), $material_out->rid_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->packing_type->caption(), $material_out->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->rid_3->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->rid_3->caption(), $material_out->rid_3->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->rid->caption(), $material_out->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->lot_no->caption(), $material_out->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->avg_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_avg_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->avg_quantity->caption(), $material_out->avg_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->max_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->max_qty->caption(), $material_out->max_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_max_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->max_qty->errorMessage()) ?>");
		<?php if ($material_out_edit->quantity_sub->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity_sub");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->quantity_sub->caption(), $material_out->quantity_sub->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity_sub");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->quantity_sub->errorMessage()) ?>");
		<?php if ($material_out_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->quantity->caption(), $material_out->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->packets->caption(), $material_out->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->price->caption(), $material_out->price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->cart_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_cart_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->cart_amount->caption(), $material_out->cart_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->other_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_other_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->other_amount->caption(), $material_out->other_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_other_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->other_amount->errorMessage()) ?>");
		<?php if ($material_out_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->operator->caption(), $material_out->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->datetime->caption(), $material_out->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->dated->caption(), $material_out->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->remarks->caption(), $material_out->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $material_out->uploads->caption(), $material_out->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_out_edit->godown_po->Required) { ?>
			elm = this.getElements("x" + infix + "_godown_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_out->godown_po->caption(), $material_out->godown_po->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_godown_po");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_out->godown_po->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmaterial_outedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_outedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_outedit.lists["x_process"] = <?php echo $material_out_edit->process->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_process"].options = <?php echo JsonEncode($material_out_edit->process->lookupOptions()) ?>;
fmaterial_outedit.lists["x_process_type"] = <?php echo $material_out_edit->process_type->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_process_type"].options = <?php echo JsonEncode($material_out_edit->process_type->lookupOptions()) ?>;
fmaterial_outedit.lists["x_issue_to"] = <?php echo $material_out_edit->issue_to->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_edit->issue_to->lookupOptions()) ?>;
fmaterial_outedit.lists["x_godown"] = <?php echo $material_out_edit->godown->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_godown"].options = <?php echo JsonEncode($material_out_edit->godown->lookupOptions()) ?>;
fmaterial_outedit.lists["x_grp"] = <?php echo $material_out_edit->grp->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_grp"].options = <?php echo JsonEncode($material_out_edit->grp->lookupOptions()) ?>;
fmaterial_outedit.lists["x_s_grp"] = <?php echo $material_out_edit->s_grp->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_edit->s_grp->lookupOptions()) ?>;
fmaterial_outedit.lists["x_product"] = <?php echo $material_out_edit->product->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_product"].options = <?php echo JsonEncode($material_out_edit->product->lookupOptions()) ?>;
fmaterial_outedit.lists["x_rid_1"] = <?php echo $material_out_edit->rid_1->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_rid_1"].options = <?php echo JsonEncode($material_out_edit->rid_1->lookupOptions()) ?>;
fmaterial_outedit.lists["x_packing_type"] = <?php echo $material_out_edit->packing_type->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_edit->packing_type->lookupOptions()) ?>;
fmaterial_outedit.lists["x_rid_3"] = <?php echo $material_out_edit->rid_3->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_rid_3"].options = <?php echo JsonEncode($material_out_edit->rid_3->lookupOptions()) ?>;
fmaterial_outedit.lists["x_rid"] = <?php echo $material_out_edit->rid->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_rid"].options = <?php echo JsonEncode($material_out_edit->rid->lookupOptions()) ?>;
fmaterial_outedit.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_outedit.lists["x_operator"] = <?php echo $material_out_edit->operator->Lookup->toClientList() ?>;
fmaterial_outedit.lists["x_operator"].options = <?php echo JsonEncode($material_out_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_edit->showPageHeader(); ?>
<?php
$material_out_edit->showMessage();
?>
<?php if (!$material_out_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_edit->Pager)) $material_out_edit->Pager = new PrevNextPager($material_out_edit->StartRec, $material_out_edit->DisplayRecs, $material_out_edit->TotalRecs, $material_out_edit->AutoHidePager) ?>
<?php if ($material_out_edit->Pager->RecordCount > 0 && $material_out_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_edit->pageUrl() ?>start=<?php echo $material_out_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_edit->pageUrl() ?>start=<?php echo $material_out_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_edit->pageUrl() ?>start=<?php echo $material_out_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_edit->pageUrl() ?>start=<?php echo $material_out_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fmaterial_outedit" id="fmaterial_outedit" class="<?php echo $material_out_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($material_out->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_material_out_id" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->id->caption() ?><?php echo ($material_out->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->id->cellAttributes() ?>>
<span id="el_material_out_id">
<span<?php echo $material_out->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_out" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($material_out->id->CurrentValue) ?>">
<?php echo $material_out->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_material_out_process" for="x_process" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->process->caption() ?><?php echo ($material_out->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->process->cellAttributes() ?>>
<span id="el_material_out_process">
<span<?php echo $material_out->process->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->process->EditValue)) && $material_out->process->linkAttributes() <> "") { ?>
<a<?php echo $material_out->process->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->process->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->process->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_out" data-field="x_process" name="x_process" id="x_process" value="<?php echo HtmlEncode($material_out->process->CurrentValue) ?>">
<?php echo $material_out->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->process_type->Visible) { // process_type ?>
	<div id="r_process_type" class="form-group row">
		<label id="elh_material_out_process_type" for="x_process_type" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->process_type->caption() ?><?php echo ($material_out->process_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->process_type->cellAttributes() ?>>
<span id="el_material_out_process_type">
<span<?php echo $material_out->process_type->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->process_type->EditValue)) && $material_out->process_type->linkAttributes() <> "") { ?>
<a<?php echo $material_out->process_type->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->process_type->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->process_type->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_out" data-field="x_process_type" name="x_process_type" id="x_process_type" value="<?php echo HtmlEncode($material_out->process_type->CurrentValue) ?>">
<?php echo $material_out->process_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->issue_to_unit->Visible) { // issue_to_unit ?>
	<div id="r_issue_to_unit" class="form-group row">
		<label id="elh_material_out_issue_to_unit" for="x_issue_to_unit" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->issue_to_unit->caption() ?><?php echo ($material_out->issue_to_unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->issue_to_unit->cellAttributes() ?>>
<span id="el_material_out_issue_to_unit">
<input type="text" data-table="material_out" data-field="x_issue_to_unit" name="x_issue_to_unit" id="x_issue_to_unit" size="30" placeholder="<?php echo HtmlEncode($material_out->issue_to_unit->getPlaceHolder()) ?>" value="<?php echo $material_out->issue_to_unit->EditValue ?>"<?php echo $material_out->issue_to_unit->editAttributes() ?>>
</span>
<?php echo $material_out->issue_to_unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_material_out_issue_to" for="x_issue_to" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->issue_to->caption() ?><?php echo ($material_out->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->issue_to->cellAttributes() ?>>
<span id="el_material_out_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_issue_to" data-value-separator="<?php echo $material_out->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_out->issue_to->editAttributes() ?>>
		<?php echo $material_out->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $material_out->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
<?php echo $material_out->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_material_out_godown" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->godown->caption() ?><?php echo ($material_out->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->godown->cellAttributes() ?>>
<span id="el_material_out_godown">
<span<?php echo $material_out->godown->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->godown->EditValue)) && $material_out->godown->linkAttributes() <> "") { ?>
<a<?php echo $material_out->godown->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->godown->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->godown->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_out" data-field="x_godown" name="x_godown" id="x_godown" value="<?php echo HtmlEncode($material_out->godown->CurrentValue) ?>">
<?php echo $material_out->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_material_out_grp" for="x_grp" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->grp->caption() ?><?php echo ($material_out->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->grp->cellAttributes() ?>>
<span id="el_material_out_grp">
<span<?php echo $material_out->grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->grp->EditValue)) && $material_out->grp->linkAttributes() <> "") { ?>
<a<?php echo $material_out->grp->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->grp->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->grp->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_out" data-field="x_grp" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($material_out->grp->CurrentValue) ?>">
<?php echo $material_out->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_material_out_s_grp" for="x_s_grp" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->s_grp->caption() ?><?php echo ($material_out->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->s_grp->cellAttributes() ?>>
<span id="el_material_out_s_grp">
<span<?php echo $material_out->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->s_grp->EditValue)) && $material_out->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $material_out->s_grp->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->s_grp->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->s_grp->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_out" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($material_out->s_grp->CurrentValue) ?>">
<?php echo $material_out->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_material_out_product" for="x_product" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->product->caption() ?><?php echo ($material_out->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->product->cellAttributes() ?>>
<span id="el_material_out_product">
<span<?php echo $material_out->product->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->product->EditValue)) && $material_out->product->linkAttributes() <> "") { ?>
<a<?php echo $material_out->product->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->product->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->product->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_out" data-field="x_product" name="x_product" id="x_product" value="<?php echo HtmlEncode($material_out->product->CurrentValue) ?>">
<?php echo $material_out->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid_1->Visible) { // rid_1 ?>
	<div id="r_rid_1" class="form-group row">
		<label id="elh_material_out_rid_1" for="x_rid_1" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->rid_1->caption() ?><?php echo ($material_out->rid_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->rid_1->cellAttributes() ?>>
<span id="el_material_out_rid_1">
<span<?php echo $material_out->rid_1->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->rid_1->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_out" data-field="x_rid_1" name="x_rid_1" id="x_rid_1" value="<?php echo HtmlEncode($material_out->rid_1->CurrentValue) ?>">
<?php echo $material_out->rid_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_material_out_packing_type" for="x_packing_type" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->packing_type->caption() ?><?php echo ($material_out->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->packing_type->cellAttributes() ?>>
<span id="el_material_out_packing_type">
<span<?php echo $material_out->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->packing_type->EditValue)) && $material_out->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $material_out->packing_type->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->packing_type->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->packing_type->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_out" data-field="x_packing_type" name="x_packing_type" id="x_packing_type" value="<?php echo HtmlEncode($material_out->packing_type->CurrentValue) ?>">
<?php echo $material_out->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid_3->Visible) { // rid_3 ?>
	<div id="r_rid_3" class="form-group row">
		<label id="elh_material_out_rid_3" for="x_rid_3" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->rid_3->caption() ?><?php echo ($material_out->rid_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->rid_3->cellAttributes() ?>>
<span id="el_material_out_rid_3">
<?php $material_out->rid_3->EditAttrs["onchange"] = "ew.autoFill(this);" . @$material_out->rid_3->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_3"><?php echo strval($material_out->rid_3->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($material_out->rid_3->ViewValue) : $material_out->rid_3->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_out->rid_3->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($material_out->rid_3->ReadOnly || $material_out->rid_3->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_3',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $material_out->rid_3->Lookup->getParamTag("p_x_rid_3") ?>
<input type="hidden" data-table="material_out" data-field="x_rid_3" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_out->rid_3->displayValueSeparatorAttribute() ?>" name="x_rid_3" id="x_rid_3" value="<?php echo $material_out->rid_3->CurrentValue ?>"<?php echo $material_out->rid_3->editAttributes() ?>>
</span>
<?php echo $material_out->rid_3->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_material_out_rid" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->rid->caption() ?><?php echo ($material_out->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->rid->cellAttributes() ?>>
<span id="el_material_out_rid">
<span<?php echo $material_out->rid->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->rid->EditValue)) && $material_out->rid->linkAttributes() <> "") { ?>
<a<?php echo $material_out->rid->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->rid->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->rid->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_out" data-field="x_rid" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($material_out->rid->CurrentValue) ?>">
<?php echo $material_out->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_material_out_lot_no" for="x_lot_no" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->lot_no->caption() ?><?php echo ($material_out->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->lot_no->cellAttributes() ?>>
<span id="el_material_out_lot_no">
<span<?php echo $material_out->lot_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->lot_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_out" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" value="<?php echo HtmlEncode($material_out->lot_no->CurrentValue) ?>">
<?php echo $material_out->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label id="elh_material_out_avg_quantity" for="x_avg_quantity" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->avg_quantity->caption() ?><?php echo ($material_out->avg_quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->avg_quantity->cellAttributes() ?>>
<span id="el_material_out_avg_quantity">
<span<?php echo $material_out->avg_quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->avg_quantity->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_out" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" value="<?php echo HtmlEncode($material_out->avg_quantity->CurrentValue) ?>">
<?php echo $material_out->avg_quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label id="elh_material_out_max_qty" for="x_max_qty" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->max_qty->caption() ?><?php echo ($material_out->max_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->max_qty->cellAttributes() ?>>
<span id="el_material_out_max_qty">
<input type="text" data-table="material_out" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" size="30" placeholder="<?php echo HtmlEncode($material_out->max_qty->getPlaceHolder()) ?>" value="<?php echo $material_out->max_qty->EditValue ?>"<?php echo $material_out->max_qty->editAttributes() ?>>
</span>
<?php echo $material_out->max_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->quantity_sub->Visible) { // quantity_sub ?>
	<div id="r_quantity_sub" class="form-group row">
		<label id="elh_material_out_quantity_sub" for="x_quantity_sub" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->quantity_sub->caption() ?><?php echo ($material_out->quantity_sub->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->quantity_sub->cellAttributes() ?>>
<span id="el_material_out_quantity_sub">
<input type="text" data-table="material_out" data-field="x_quantity_sub" name="x_quantity_sub" id="x_quantity_sub" size="30" placeholder="<?php echo HtmlEncode($material_out->quantity_sub->getPlaceHolder()) ?>" value="<?php echo $material_out->quantity_sub->EditValue ?>"<?php echo $material_out->quantity_sub->editAttributes() ?>>
</span>
<?php echo $material_out->quantity_sub->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_material_out_quantity" for="x_quantity" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->quantity->caption() ?><?php echo ($material_out->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->quantity->cellAttributes() ?>>
<span id="el_material_out_quantity">
<span<?php echo $material_out->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->quantity->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_out" data-field="x_quantity" name="x_quantity" id="x_quantity" value="<?php echo HtmlEncode($material_out->quantity->CurrentValue) ?>">
<?php echo $material_out->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_material_out_packets" for="x_packets" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->packets->caption() ?><?php echo ($material_out->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->packets->cellAttributes() ?>>
<span id="el_material_out_packets">
<span<?php echo $material_out->packets->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->packets->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_out" data-field="x_packets" name="x_packets" id="x_packets" value="<?php echo HtmlEncode($material_out->packets->CurrentValue) ?>">
<?php echo $material_out->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_material_out_price" for="x_price" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->price->caption() ?><?php echo ($material_out->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->price->cellAttributes() ?>>
<span id="el_material_out_price">
<span<?php echo $material_out->price->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->price->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_out" data-field="x_price" name="x_price" id="x_price" value="<?php echo HtmlEncode($material_out->price->CurrentValue) ?>">
<?php echo $material_out->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->cart_amount->Visible) { // cart_amount ?>
	<div id="r_cart_amount" class="form-group row">
		<label id="elh_material_out_cart_amount" for="x_cart_amount" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->cart_amount->caption() ?><?php echo ($material_out->cart_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->cart_amount->cellAttributes() ?>>
<span id="el_material_out_cart_amount">
<span<?php echo $material_out->cart_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->cart_amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_out" data-field="x_cart_amount" name="x_cart_amount" id="x_cart_amount" value="<?php echo HtmlEncode($material_out->cart_amount->CurrentValue) ?>">
<?php echo $material_out->cart_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->other_amount->Visible) { // other_amount ?>
	<div id="r_other_amount" class="form-group row">
		<label id="elh_material_out_other_amount" for="x_other_amount" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->other_amount->caption() ?><?php echo ($material_out->other_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->other_amount->cellAttributes() ?>>
<span id="el_material_out_other_amount">
<input type="text" data-table="material_out" data-field="x_other_amount" name="x_other_amount" id="x_other_amount" size="30" placeholder="<?php echo HtmlEncode($material_out->other_amount->getPlaceHolder()) ?>" value="<?php echo $material_out->other_amount->EditValue ?>"<?php echo $material_out->other_amount->editAttributes() ?>>
</span>
<?php echo $material_out->other_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_material_out_dated" for="x_dated" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->dated->caption() ?><?php echo ($material_out->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->dated->cellAttributes() ?>>
<span id="el_material_out_dated">
<span<?php echo $material_out->dated->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_out->dated->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_out" data-field="x_dated" name="x_dated" id="x_dated" value="<?php echo HtmlEncode($material_out->dated->CurrentValue) ?>">
<?php echo $material_out->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_material_out_remarks" for="x_remarks" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->remarks->caption() ?><?php echo ($material_out->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->remarks->cellAttributes() ?>>
<span id="el_material_out_remarks">
<textarea data-table="material_out" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($material_out->remarks->getPlaceHolder()) ?>"<?php echo $material_out->remarks->editAttributes() ?>><?php echo $material_out->remarks->EditValue ?></textarea>
</span>
<?php echo $material_out->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_material_out_uploads" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->uploads->caption() ?><?php echo ($material_out->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->uploads->cellAttributes() ?>>
<span id="el_material_out_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $material_out->uploads->title() ? $material_out->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($material_out->uploads->ReadOnly || $material_out->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="material_out" data-field="x_uploads" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $material_out->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $material_out->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="250">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $material_out->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $material_out->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $material_out->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $material_out->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_out->godown_po->Visible) { // godown_po ?>
	<div id="r_godown_po" class="form-group row">
		<label id="elh_material_out_godown_po" for="x_godown_po" class="<?php echo $material_out_edit->LeftColumnClass ?>"><?php echo $material_out->godown_po->caption() ?><?php echo ($material_out->godown_po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_out_edit->RightColumnClass ?>"><div<?php echo $material_out->godown_po->cellAttributes() ?>>
<span id="el_material_out_godown_po">
<input type="text" data-table="material_out" data-field="x_godown_po" name="x_godown_po" id="x_godown_po" size="30" placeholder="<?php echo HtmlEncode($material_out->godown_po->getPlaceHolder()) ?>" value="<?php echo $material_out->godown_po->EditValue ?>"<?php echo $material_out->godown_po->editAttributes() ?>>
</span>
<?php echo $material_out->godown_po->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $material_out_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$material_out_edit->IsModal) { ?>
<?php if (!isset($material_out_edit->Pager)) $material_out_edit->Pager = new PrevNextPager($material_out_edit->StartRec, $material_out_edit->DisplayRecs, $material_out_edit->TotalRecs, $material_out_edit->AutoHidePager) ?>
<?php if ($material_out_edit->Pager->RecordCount > 0 && $material_out_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_edit->pageUrl() ?>start=<?php echo $material_out_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_edit->pageUrl() ?>start=<?php echo $material_out_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_edit->pageUrl() ?>start=<?php echo $material_out_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_edit->pageUrl() ?>start=<?php echo $material_out_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$material_out_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var process= $('#x_process').val();
	     if (process == 101)
	     {
	     $("#r_process_type").hide();
	     $("#r_issue_to").show();
	     $("#r_jc_no").show();
	     $("#r_tmp_lot").hide();
	     $("#r_price").show();
	     $("#r_other_amount").show();
	     $("#r_cart_amount").show();	     
	     $("#r_rid_1").show();
	     $("#r_rid_3").show();	     	     
	     $("#r_rid_2").hide();	     
	     }
	     else if (process == 102)
	     {
	     $("#r_jc_no").hide();
	     $("#r_process_type").hide();
	     $("#r_issue_to").show();	     
	     $("#x_issue_to").val('');
	     $("#r_tmp_lot").hide();
   	     $("#r_price").show();
	     $("#r_other_amount").hide();
	     $("#r_cart_amount").show();
	     $("#r_rid_1").show();
	     $("#r_rid_3").show();	     	     
	     $("#r_rid_2").hide();	     
	     }
	     else if (process == 103)
	     {
	     $("#r_process_type").show();
	     $("#r_jc_no").show();
	     $("#r_issue_to").show();	     
	     $("#x_issue_to").val('');
	     $("#r_tmp_lot").hide();
	     $("#r_price").hide();
	     $("#r_other_amount").hide();
	     $("#r_cart_amount").hide();
	     $("#r_rid_1").show();		 		 
	     $("#r_rid_3").show();
	     $("#r_rid_2").hide();	     
	     }
	     else if (process == 104)
	     {
	     $("#r_process_type").show();
	     $("#r_jc_no").show();
	     $("#r_issue_to").hide();	     
	     $("#r_tmp_lot").hide();
	     $("#r_price").hide();
	     $("#r_other_amount").hide();
	     $("#r_cart_amount").hide();
	     $("#r_rid_1").show();
	     $("#r_rid_3").show();	     
	     $("#r_rid_2").hide();	     
	     }
	     else if (process == 109)
	     {
	     $("#r_process_type").show();
	     $("#r_jc_no").show();
	     $("#r_issue_to").hide();	     
	     $("#r_tmp_lot").hide();
	     $("#r_price").hide();
	     $("#r_other_amount").hide();
	     $("#r_cart_amount").hide();
	     $("#r_rid_1").hide();
	     $("#r_rid_3").hide();
	     $("#r_rid_2").show();
	     }
</script>
<?php include_once "footer.php" ?>
<?php
$material_out_edit->terminate();
?>