<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_list = new material_out_list();

// Run the page
$material_out_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_outlist = currentForm = new ew.Form("fmaterial_outlist", "list");
fmaterial_outlist.formKeyCountName = '<?php echo $material_out_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_outlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_outlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_outlist.lists["x_process"] = <?php echo $material_out_list->process->Lookup->toClientList() ?>;
fmaterial_outlist.lists["x_process"].options = <?php echo JsonEncode($material_out_list->process->lookupOptions()) ?>;
fmaterial_outlist.lists["x_process_type"] = <?php echo $material_out_list->process_type->Lookup->toClientList() ?>;
fmaterial_outlist.lists["x_process_type"].options = <?php echo JsonEncode($material_out_list->process_type->lookupOptions()) ?>;
fmaterial_outlist.lists["x_issue_to"] = <?php echo $material_out_list->issue_to->Lookup->toClientList() ?>;
fmaterial_outlist.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_list->issue_to->lookupOptions()) ?>;
fmaterial_outlist.lists["x_godown"] = <?php echo $material_out_list->godown->Lookup->toClientList() ?>;
fmaterial_outlist.lists["x_godown"].options = <?php echo JsonEncode($material_out_list->godown->lookupOptions()) ?>;
fmaterial_outlist.lists["x_product"] = <?php echo $material_out_list->product->Lookup->toClientList() ?>;
fmaterial_outlist.lists["x_product"].options = <?php echo JsonEncode($material_out_list->product->lookupOptions()) ?>;
fmaterial_outlist.lists["x_packing_type"] = <?php echo $material_out_list->packing_type->Lookup->toClientList() ?>;
fmaterial_outlist.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_list->packing_type->lookupOptions()) ?>;
fmaterial_outlist.lists["x_rid"] = <?php echo $material_out_list->rid->Lookup->toClientList() ?>;
fmaterial_outlist.lists["x_rid"].options = <?php echo JsonEncode($material_out_list->rid->lookupOptions()) ?>;
fmaterial_outlist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_outlist.lists["x_status"] = <?php echo $material_out_list->status->Lookup->toClientList() ?>;
fmaterial_outlist.lists["x_status"].options = <?php echo JsonEncode($material_out_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fmaterial_outlistsrch = currentSearchForm = new ew.Form("fmaterial_outlistsrch");

// Validate function for search
fmaterial_outlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_outlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_outlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_outlistsrch.lists["x_process"] = <?php echo $material_out_list->process->Lookup->toClientList() ?>;
fmaterial_outlistsrch.lists["x_process"].options = <?php echo JsonEncode($material_out_list->process->lookupOptions()) ?>;
fmaterial_outlistsrch.lists["x_product"] = <?php echo $material_out_list->product->Lookup->toClientList() ?>;
fmaterial_outlistsrch.lists["x_product"].options = <?php echo JsonEncode($material_out_list->product->lookupOptions()) ?>;

// Filters
fmaterial_outlistsrch.filterList = <?php echo $material_out_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_outlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
var GSTChallan = function(CID, PID){
	  var CAID =[];
	  $("#tbl_material_outlist tbody input[type='checkbox']:checked").each(function(){
	  		 CAID.push($(this).val());	  		 
	  });	  
	  if(CAID.length>0)
	  {
	  	$.getJSON("apcajax.php?getfromto=" + CAID,function(data) {
		if (data.godown_count > 1 || data.issue_to_count > 1)
		{
	  	ew.alert("Please Select Comman From & To");		
		} 
		else
		{
		location.href='gate_passadd.php?CID='+ CAID.toString() + '&f=' + data.godown + '&t=' + data.issue_to + '&tn=1&fcid=' + data.company_id;
		}
	  	});
	  }
	  else
	  {
	  	ew.alert("Please Select atleast a row to Update");
	  }
}
</script>
<?php } ?>
<?php if (!$material_out->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_out_list->TotalRecs > 0 && $material_out_list->ExportOptions->visible()) { ?>
<?php $material_out_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_list->ImportOptions->visible()) { ?>
<?php $material_out_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_list->SearchOptions->visible()) { ?>
<?php $material_out_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_out_list->FilterOptions->visible()) { ?>
<?php $material_out_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_out_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_out->isExport() && !$material_out->CurrentAction) { ?>
<form name="fmaterial_outlistsrch" id="fmaterial_outlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_out_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_outlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_out">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_out_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_out->RowType = ROWTYPE_SEARCH;

// Render row
$material_out->resetAttributes();
$material_out_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_out->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $material_out->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_process" data-value-separator="<?php echo $material_out->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $material_out->process->editAttributes() ?>>
		<?php echo $material_out->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $material_out->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $material_out->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="material_out" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($material_out->product->getPlaceHolder()) ?>" value="<?php echo $material_out->product->EditValue ?>"<?php echo $material_out->product->editAttributes() ?>>
<?php echo $material_out->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_out->lot_no->Visible) { // lot_no ?>
	<div id="xsc_lot_no" class="ew-cell form-group">
		<label for="x_lot_no" class="ew-search-caption ew-label"><?php echo $material_out->lot_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="material_out" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($material_out->lot_no->getPlaceHolder()) ?>" value="<?php echo $material_out->lot_no->EditValue ?>"<?php echo $material_out->lot_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_out_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_out_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_out_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_out_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_out_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_out_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_out_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_out_list->showPageHeader(); ?>
<?php
$material_out_list->showMessage();
?>
<?php if ($material_out_list->TotalRecs > 0 || $material_out->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_out_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_out">
<?php if (!$material_out->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_out->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_list->Pager)) $material_out_list->Pager = new PrevNextPager($material_out_list->StartRec, $material_out_list->DisplayRecs, $material_out_list->TotalRecs, $material_out_list->AutoHidePager) ?>
<?php if ($material_out_list->Pager->RecordCount > 0 && $material_out_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_list->pageUrl() ?>start=<?php echo $material_out_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_list->pageUrl() ?>start=<?php echo $material_out_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_list->pageUrl() ?>start=<?php echo $material_out_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_list->pageUrl() ?>start=<?php echo $material_out_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_list->TotalRecs > 0 && (!$material_out_list->AutoHidePageSizeSelector || $material_out_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($material_out_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($material_out->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_outlist" id="fmaterial_outlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_material_out" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_out_list->TotalRecs > 0 || $material_out->isGridEdit()) { ?>
<table id="tbl_material_outlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_out_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_out_list->renderListOptions();

// Render list options (header, left)
$material_out_list->ListOptions->render("header", "left");
?>
<?php if ($material_out->id->Visible) { // id ?>
	<?php if ($material_out->sortUrl($material_out->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_out->id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_id" class="material_out_id"><div class="ew-table-header-caption"><?php echo $material_out->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_out->id->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->id) ?>',1);"><div id="elh_material_out_id" class="material_out_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->process->Visible) { // process ?>
	<?php if ($material_out->sortUrl($material_out->process) == "") { ?>
		<th data-name="process" class="<?php echo $material_out->process->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_process" class="material_out_process"><div class="ew-table-header-caption"><?php echo $material_out->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $material_out->process->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->process) ?>',1);"><div id="elh_material_out_process" class="material_out_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->process_type->Visible) { // process_type ?>
	<?php if ($material_out->sortUrl($material_out->process_type) == "") { ?>
		<th data-name="process_type" class="<?php echo $material_out->process_type->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_process_type" class="material_out_process_type"><div class="ew-table-header-caption"><?php echo $material_out->process_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_type" class="<?php echo $material_out->process_type->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->process_type) ?>',1);"><div id="elh_material_out_process_type" class="material_out_process_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->process_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->process_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->process_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->issue_to_unit->Visible) { // issue_to_unit ?>
	<?php if ($material_out->sortUrl($material_out->issue_to_unit) == "") { ?>
		<th data-name="issue_to_unit" class="<?php echo $material_out->issue_to_unit->headerCellClass() ?>"><div id="elh_material_out_issue_to_unit" class="material_out_issue_to_unit"><div class="ew-table-header-caption"><?php echo $material_out->issue_to_unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to_unit" class="<?php echo $material_out->issue_to_unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->issue_to_unit) ?>',1);"><div id="elh_material_out_issue_to_unit" class="material_out_issue_to_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->issue_to_unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->issue_to_unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->issue_to_unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->issue_to->Visible) { // issue_to ?>
	<?php if ($material_out->sortUrl($material_out->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $material_out->issue_to->headerCellClass() ?>"><div id="elh_material_out_issue_to" class="material_out_issue_to"><div class="ew-table-header-caption"><?php echo $material_out->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $material_out->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->issue_to) ?>',1);"><div id="elh_material_out_issue_to" class="material_out_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->godown->Visible) { // godown ?>
	<?php if ($material_out->sortUrl($material_out->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $material_out->godown->headerCellClass() ?>"><div id="elh_material_out_godown" class="material_out_godown"><div class="ew-table-header-caption"><?php echo $material_out->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $material_out->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->godown) ?>',1);"><div id="elh_material_out_godown" class="material_out_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->jc_no->Visible) { // jc_no ?>
	<?php if ($material_out->sortUrl($material_out->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $material_out->jc_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_jc_no" class="material_out_jc_no"><div class="ew-table-header-caption"><?php echo $material_out->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $material_out->jc_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->jc_no) ?>',1);"><div id="elh_material_out_jc_no" class="material_out_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->jc_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->product->Visible) { // product ?>
	<?php if ($material_out->sortUrl($material_out->product) == "") { ?>
		<th data-name="product" class="<?php echo $material_out->product->headerCellClass() ?>"><div id="elh_material_out_product" class="material_out_product"><div class="ew-table-header-caption"><?php echo $material_out->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $material_out->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->product) ?>',1);"><div id="elh_material_out_product" class="material_out_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->packing_type->Visible) { // packing_type ?>
	<?php if ($material_out->sortUrl($material_out->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $material_out->packing_type->headerCellClass() ?>"><div id="elh_material_out_packing_type" class="material_out_packing_type"><div class="ew-table-header-caption"><?php echo $material_out->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $material_out->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->packing_type) ?>',1);"><div id="elh_material_out_packing_type" class="material_out_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->rid->Visible) { // rid ?>
	<?php if ($material_out->sortUrl($material_out->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $material_out->rid->headerCellClass() ?>"><div id="elh_material_out_rid" class="material_out_rid"><div class="ew-table-header-caption"><?php echo $material_out->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $material_out->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->rid) ?>',1);"><div id="elh_material_out_rid" class="material_out_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->lot_no->Visible) { // lot_no ?>
	<?php if ($material_out->sortUrl($material_out->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $material_out->lot_no->headerCellClass() ?>"><div id="elh_material_out_lot_no" class="material_out_lot_no"><div class="ew-table-header-caption"><?php echo $material_out->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $material_out->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->lot_no) ?>',1);"><div id="elh_material_out_lot_no" class="material_out_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->quantity_sub->Visible) { // quantity_sub ?>
	<?php if ($material_out->sortUrl($material_out->quantity_sub) == "") { ?>
		<th data-name="quantity_sub" class="<?php echo $material_out->quantity_sub->headerCellClass() ?>"><div id="elh_material_out_quantity_sub" class="material_out_quantity_sub"><div class="ew-table-header-caption"><?php echo $material_out->quantity_sub->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_sub" class="<?php echo $material_out->quantity_sub->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->quantity_sub) ?>',1);"><div id="elh_material_out_quantity_sub" class="material_out_quantity_sub">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->quantity_sub->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->quantity_sub->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->quantity_sub->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->quantity->Visible) { // quantity ?>
	<?php if ($material_out->sortUrl($material_out->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_out->quantity->headerCellClass() ?>"><div id="elh_material_out_quantity" class="material_out_quantity"><div class="ew-table-header-caption"><?php echo $material_out->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_out->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->quantity) ?>',1);"><div id="elh_material_out_quantity" class="material_out_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->packets->Visible) { // packets ?>
	<?php if ($material_out->sortUrl($material_out->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $material_out->packets->headerCellClass() ?>"><div id="elh_material_out_packets" class="material_out_packets"><div class="ew-table-header-caption"><?php echo $material_out->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $material_out->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->packets) ?>',1);"><div id="elh_material_out_packets" class="material_out_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->packets->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->price->Visible) { // price ?>
	<?php if ($material_out->sortUrl($material_out->price) == "") { ?>
		<th data-name="price" class="<?php echo $material_out->price->headerCellClass() ?>"><div id="elh_material_out_price" class="material_out_price"><div class="ew-table-header-caption"><?php echo $material_out->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $material_out->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->price) ?>',1);"><div id="elh_material_out_price" class="material_out_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->price->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->dated->Visible) { // dated ?>
	<?php if ($material_out->sortUrl($material_out->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $material_out->dated->headerCellClass() ?>"><div id="elh_material_out_dated" class="material_out_dated"><div class="ew-table-header-caption"><?php echo $material_out->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $material_out->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->dated) ?>',1);"><div id="elh_material_out_dated" class="material_out_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->status->Visible) { // status ?>
	<?php if ($material_out->sortUrl($material_out->status) == "") { ?>
		<th data-name="status" class="<?php echo $material_out->status->headerCellClass() ?>"><div id="elh_material_out_status" class="material_out_status"><div class="ew-table-header-caption"><?php echo $material_out->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $material_out->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->status) ?>',1);"><div id="elh_material_out_status" class="material_out_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->total_amount->Visible) { // total_amount ?>
	<?php if ($material_out->sortUrl($material_out->total_amount) == "") { ?>
		<th data-name="total_amount" class="<?php echo $material_out->total_amount->headerCellClass() ?>"><div id="elh_material_out_total_amount" class="material_out_total_amount"><div class="ew-table-header-caption"><?php echo $material_out->total_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_amount" class="<?php echo $material_out->total_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->total_amount) ?>',1);"><div id="elh_material_out_total_amount" class="material_out_total_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->total_amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->total_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->total_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->cart_ref->Visible) { // cart_ref ?>
	<?php if ($material_out->sortUrl($material_out->cart_ref) == "") { ?>
		<th data-name="cart_ref" class="<?php echo $material_out->cart_ref->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_out_cart_ref" class="material_out_cart_ref"><div class="ew-table-header-caption"><?php echo $material_out->cart_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cart_ref" class="<?php echo $material_out->cart_ref->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->cart_ref) ?>',1);"><div id="elh_material_out_cart_ref" class="material_out_cart_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->cart_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->cart_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->cart_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->uploads->Visible) { // uploads ?>
	<?php if ($material_out->sortUrl($material_out->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $material_out->uploads->headerCellClass() ?>"><div id="elh_material_out_uploads" class="material_out_uploads"><div class="ew-table-header-caption"><?php echo $material_out->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $material_out->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->uploads) ?>',1);"><div id="elh_material_out_uploads" class="material_out_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_out->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_out->godown_po->Visible) { // godown_po ?>
	<?php if ($material_out->sortUrl($material_out->godown_po) == "") { ?>
		<th data-name="godown_po" class="<?php echo $material_out->godown_po->headerCellClass() ?>"><div id="elh_material_out_godown_po" class="material_out_godown_po"><div class="ew-table-header-caption"><?php echo $material_out->godown_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown_po" class="<?php echo $material_out->godown_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_out->SortUrl($material_out->godown_po) ?>',1);"><div id="elh_material_out_godown_po" class="material_out_godown_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_out->godown_po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_out->godown_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_out->godown_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_out_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_out->ExportAll && $material_out->isExport()) {
	$material_out_list->StopRec = $material_out_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_out_list->TotalRecs > $material_out_list->StartRec + $material_out_list->DisplayRecs - 1)
		$material_out_list->StopRec = $material_out_list->StartRec + $material_out_list->DisplayRecs - 1;
	else
		$material_out_list->StopRec = $material_out_list->TotalRecs;
}
$material_out_list->RecCnt = $material_out_list->StartRec - 1;
if ($material_out_list->Recordset && !$material_out_list->Recordset->EOF) {
	$material_out_list->Recordset->moveFirst();
	$selectLimit = $material_out_list->UseSelectLimit;
	if (!$selectLimit && $material_out_list->StartRec > 1)
		$material_out_list->Recordset->move($material_out_list->StartRec - 1);
} elseif (!$material_out->AllowAddDeleteRow && $material_out_list->StopRec == 0) {
	$material_out_list->StopRec = $material_out->GridAddRowCount;
}

// Initialize aggregate
$material_out->RowType = ROWTYPE_AGGREGATEINIT;
$material_out->resetAttributes();
$material_out_list->renderRow();
while ($material_out_list->RecCnt < $material_out_list->StopRec) {
	$material_out_list->RecCnt++;
	if ($material_out_list->RecCnt >= $material_out_list->StartRec) {
		$material_out_list->RowCnt++;

		// Set up key count
		$material_out_list->KeyCount = $material_out_list->RowIndex;

		// Init row class and style
		$material_out->resetAttributes();
		$material_out->CssClass = "";
		if ($material_out->isGridAdd()) {
		} else {
			$material_out_list->loadRowValues($material_out_list->Recordset); // Load row values
		}
		$material_out->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_out->RowAttrs = array_merge($material_out->RowAttrs, array('data-rowindex'=>$material_out_list->RowCnt, 'id'=>'r' . $material_out_list->RowCnt . '_material_out', 'data-rowtype'=>$material_out->RowType));

		// Render row
		$material_out_list->renderRow();

		// Render list options
		$material_out_list->renderListOptions();
?>
	<tr<?php echo $material_out->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_out_list->ListOptions->render("body", "left", $material_out_list->RowCnt);
?>
	<?php if ($material_out->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_out->id->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_id" class="material_out_id">
<span<?php echo $material_out->id->viewAttributes() ?>>
<?php echo $material_out->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->process->Visible) { // process ?>
		<td data-name="process"<?php echo $material_out->process->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_process" class="material_out_process">
<span<?php echo $material_out->process->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->process->getViewValue())) && $material_out->process->linkAttributes() <> "") { ?>
<a<?php echo $material_out->process->linkAttributes() ?>><?php echo $material_out->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->process_type->Visible) { // process_type ?>
		<td data-name="process_type"<?php echo $material_out->process_type->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_process_type" class="material_out_process_type">
<span<?php echo $material_out->process_type->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->process_type->getViewValue())) && $material_out->process_type->linkAttributes() <> "") { ?>
<a<?php echo $material_out->process_type->linkAttributes() ?>><?php echo $material_out->process_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->process_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->issue_to_unit->Visible) { // issue_to_unit ?>
		<td data-name="issue_to_unit"<?php echo $material_out->issue_to_unit->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_issue_to_unit" class="material_out_issue_to_unit">
<span<?php echo $material_out->issue_to_unit->viewAttributes() ?>>
<?php echo $material_out->issue_to_unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $material_out->issue_to->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_issue_to" class="material_out_issue_to">
<span<?php echo $material_out->issue_to->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->issue_to->getViewValue())) && $material_out->issue_to->linkAttributes() <> "") { ?>
<a<?php echo $material_out->issue_to->linkAttributes() ?>><?php echo $material_out->issue_to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->issue_to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $material_out->godown->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_godown" class="material_out_godown">
<span<?php echo $material_out->godown->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->godown->getViewValue())) && $material_out->godown->linkAttributes() <> "") { ?>
<a<?php echo $material_out->godown->linkAttributes() ?>><?php echo $material_out->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $material_out->jc_no->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_jc_no" class="material_out_jc_no">
<span<?php echo $material_out->jc_no->viewAttributes() ?>>
<?php echo $material_out->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->product->Visible) { // product ?>
		<td data-name="product"<?php echo $material_out->product->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_product" class="material_out_product">
<span<?php echo $material_out->product->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->product->getViewValue())) && $material_out->product->linkAttributes() <> "") { ?>
<a<?php echo $material_out->product->linkAttributes() ?>><?php echo $material_out->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $material_out->packing_type->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_packing_type" class="material_out_packing_type">
<span<?php echo $material_out->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->packing_type->getViewValue())) && $material_out->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $material_out->packing_type->linkAttributes() ?>><?php echo $material_out->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $material_out->rid->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_rid" class="material_out_rid">
<span<?php echo $material_out->rid->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->rid->getViewValue())) && $material_out->rid->linkAttributes() <> "") { ?>
<a<?php echo $material_out->rid->linkAttributes() ?>><?php echo $material_out->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $material_out->lot_no->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_lot_no" class="material_out_lot_no">
<span<?php echo $material_out->lot_no->viewAttributes() ?>>
<?php echo $material_out->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->quantity_sub->Visible) { // quantity_sub ?>
		<td data-name="quantity_sub"<?php echo $material_out->quantity_sub->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_quantity_sub" class="material_out_quantity_sub">
<span<?php echo $material_out->quantity_sub->viewAttributes() ?>>
<?php echo $material_out->quantity_sub->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_out->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_quantity" class="material_out_quantity">
<span<?php echo $material_out->quantity->viewAttributes() ?>>
<?php echo $material_out->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $material_out->packets->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_packets" class="material_out_packets">
<span<?php echo $material_out->packets->viewAttributes() ?>>
<?php echo $material_out->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->price->Visible) { // price ?>
		<td data-name="price"<?php echo $material_out->price->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_price" class="material_out_price">
<span<?php echo $material_out->price->viewAttributes() ?>>
<?php echo $material_out->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $material_out->dated->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_dated" class="material_out_dated">
<span<?php echo $material_out->dated->viewAttributes() ?>>
<?php echo $material_out->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->status->Visible) { // status ?>
		<td data-name="status"<?php echo $material_out->status->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_status" class="material_out_status">
<span<?php echo $material_out->status->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->status->getViewValue())) && $material_out->status->linkAttributes() <> "") { ?>
<a<?php echo $material_out->status->linkAttributes() ?>><?php echo $material_out->status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount"<?php echo $material_out->total_amount->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_total_amount" class="material_out_total_amount">
<span<?php echo $material_out->total_amount->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->total_amount->getViewValue())) && $material_out->total_amount->linkAttributes() <> "") { ?>
<a<?php echo $material_out->total_amount->linkAttributes() ?>><?php echo $material_out->total_amount->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->total_amount->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->cart_ref->Visible) { // cart_ref ?>
		<td data-name="cart_ref"<?php echo $material_out->cart_ref->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_cart_ref" class="material_out_cart_ref">
<span<?php echo $material_out->cart_ref->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->cart_ref->getViewValue())) && $material_out->cart_ref->linkAttributes() <> "") { ?>
<a<?php echo $material_out->cart_ref->linkAttributes() ?>><?php echo $material_out->cart_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->cart_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $material_out->uploads->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_uploads" class="material_out_uploads">
<span>
<?php echo GetFileViewTag($material_out->uploads, $material_out->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_out->godown_po->Visible) { // godown_po ?>
		<td data-name="godown_po"<?php echo $material_out->godown_po->cellAttributes() ?>>
<span id="el<?php echo $material_out_list->RowCnt ?>_material_out_godown_po" class="material_out_godown_po">
<span<?php echo $material_out->godown_po->viewAttributes() ?>>
<?php echo $material_out->godown_po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_out_list->ListOptions->render("body", "right", $material_out_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_out->isGridAdd())
		$material_out_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$material_out->RowType = ROWTYPE_AGGREGATE;
$material_out->resetAttributes();
$material_out_list->renderRow();
?>
<?php if ($material_out_list->TotalRecs > 0 && !$material_out->isGridAdd() && !$material_out->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$material_out_list->renderListOptions();

// Render list options (footer, left)
$material_out_list->ListOptions->render("footer", "left");
?>
	<?php if ($material_out->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $material_out->id->footerCellClass() ?>"><span id="elf_material_out_id" class="material_out_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $material_out->process->footerCellClass() ?>"><span id="elf_material_out_process" class="material_out_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->process_type->Visible) { // process_type ?>
		<td data-name="process_type" class="<?php echo $material_out->process_type->footerCellClass() ?>"><span id="elf_material_out_process_type" class="material_out_process_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->issue_to_unit->Visible) { // issue_to_unit ?>
		<td data-name="issue_to_unit" class="<?php echo $material_out->issue_to_unit->footerCellClass() ?>"><span id="elf_material_out_issue_to_unit" class="material_out_issue_to_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $material_out->issue_to->footerCellClass() ?>"><span id="elf_material_out_issue_to" class="material_out_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $material_out->godown->footerCellClass() ?>"><span id="elf_material_out_godown" class="material_out_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no" class="<?php echo $material_out->jc_no->footerCellClass() ?>"><span id="elf_material_out_jc_no" class="material_out_jc_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $material_out->product->footerCellClass() ?>"><span id="elf_material_out_product" class="material_out_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $material_out->packing_type->footerCellClass() ?>"><span id="elf_material_out_packing_type" class="material_out_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $material_out->rid->footerCellClass() ?>"><span id="elf_material_out_rid" class="material_out_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $material_out->lot_no->footerCellClass() ?>"><span id="elf_material_out_lot_no" class="material_out_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->quantity_sub->Visible) { // quantity_sub ?>
		<td data-name="quantity_sub" class="<?php echo $material_out->quantity_sub->footerCellClass() ?>"><span id="elf_material_out_quantity_sub" class="material_out_quantity_sub">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $material_out->quantity->footerCellClass() ?>"><span id="elf_material_out_quantity" class="material_out_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_out->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_out->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $material_out->packets->footerCellClass() ?>"><span id="elf_material_out_packets" class="material_out_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_out->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_out->price->Visible) { // price ?>
		<td data-name="price" class="<?php echo $material_out->price->footerCellClass() ?>"><span id="elf_material_out_price" class="material_out_price">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $material_out->dated->footerCellClass() ?>"><span id="elf_material_out_dated" class="material_out_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $material_out->status->footerCellClass() ?>"><span id="elf_material_out_status" class="material_out_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->total_amount->Visible) { // total_amount ?>
		<td data-name="total_amount" class="<?php echo $material_out->total_amount->footerCellClass() ?>"><span id="elf_material_out_total_amount" class="material_out_total_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_out->total_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_out->cart_ref->Visible) { // cart_ref ?>
		<td data-name="cart_ref" class="<?php echo $material_out->cart_ref->footerCellClass() ?>"><span id="elf_material_out_cart_ref" class="material_out_cart_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->uploads->Visible) { // uploads ?>
		<td data-name="uploads" class="<?php echo $material_out->uploads->footerCellClass() ?>"><span id="elf_material_out_uploads" class="material_out_uploads">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_out->godown_po->Visible) { // godown_po ?>
		<td data-name="godown_po" class="<?php echo $material_out->godown_po->footerCellClass() ?>"><span id="elf_material_out_godown_po" class="material_out_godown_po">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$material_out_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_out->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_out_list->Recordset)
	$material_out_list->Recordset->Close();
?>
<?php if (!$material_out->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_out->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_out_list->Pager)) $material_out_list->Pager = new PrevNextPager($material_out_list->StartRec, $material_out_list->DisplayRecs, $material_out_list->TotalRecs, $material_out_list->AutoHidePager) ?>
<?php if ($material_out_list->Pager->RecordCount > 0 && $material_out_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_out_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_out_list->pageUrl() ?>start=<?php echo $material_out_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_out_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_out_list->pageUrl() ?>start=<?php echo $material_out_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_out_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_out_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_out_list->pageUrl() ?>start=<?php echo $material_out_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_out_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_out_list->pageUrl() ?>start=<?php echo $material_out_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_out_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_out_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_out_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_out_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_out_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_out_list->TotalRecs > 0 && (!$material_out_list->AutoHidePageSizeSelector || $material_out_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_out">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($material_out_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_out_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_out_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($material_out->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_out_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_out_list->TotalRecs == 0 && !$material_out->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_out_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_out_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_out->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_out", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_list->terminate();
?>