<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_search = new material_out_search();

// Run the page
$material_out_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_out_search->IsModal) { ?>
var fmaterial_outsearch = currentAdvancedSearchForm = new ew.Form("fmaterial_outsearch", "search");
<?php } else { ?>
var fmaterial_outsearch = currentForm = new ew.Form("fmaterial_outsearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_outsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_outsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_outsearch.lists["x_process"] = <?php echo $material_out_search->process->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_process"].options = <?php echo JsonEncode($material_out_search->process->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_issue_to"] = <?php echo $material_out_search->issue_to->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_search->issue_to->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_godown"] = <?php echo $material_out_search->godown->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_godown"].options = <?php echo JsonEncode($material_out_search->godown->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_grp"] = <?php echo $material_out_search->grp->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_grp"].options = <?php echo JsonEncode($material_out_search->grp->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_s_grp"] = <?php echo $material_out_search->s_grp->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_search->s_grp->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_product"] = <?php echo $material_out_search->product->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_product"].options = <?php echo JsonEncode($material_out_search->product->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_rid_1"] = <?php echo $material_out_search->rid_1->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_rid_1"].options = <?php echo JsonEncode($material_out_search->rid_1->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_packing_type"] = <?php echo $material_out_search->packing_type->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_search->packing_type->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_rid_2"] = <?php echo $material_out_search->rid_2->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_rid_2"].options = <?php echo JsonEncode($material_out_search->rid_2->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_rid_3"] = <?php echo $material_out_search->rid_3->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_rid_3"].options = <?php echo JsonEncode($material_out_search->rid_3->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_rid"] = <?php echo $material_out_search->rid->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_rid"].options = <?php echo JsonEncode($material_out_search->rid->lookupOptions()) ?>;
fmaterial_outsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_outsearch.lists["x_operator"] = <?php echo $material_out_search->operator->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_operator"].options = <?php echo JsonEncode($material_out_search->operator->lookupOptions()) ?>;
fmaterial_outsearch.lists["x_status"] = <?php echo $material_out_search->status->Lookup->toClientList() ?>;
fmaterial_outsearch.lists["x_status"].options = <?php echo JsonEncode($material_out_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fmaterial_outsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_to_unit");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->issue_to_unit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_avg_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->avg_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_max_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->max_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity_sub");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->quantity_sub->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cart_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->cart_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_other_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->other_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_hsn_code");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->hsn_code->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tax_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->tax_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tax_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->tax_percent->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_total_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->total_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cart_ref");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->cart_ref->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_godown_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_out->godown_po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_out_search->showPageHeader(); ?>
<?php
$material_out_search->showMessage();
?>
<form name="fmaterial_outsearch" id="fmaterial_outsearch" class="<?php echo $material_out_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_out->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_id"><?php echo $material_out->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->id->cellAttributes() ?>>
			<span id="el_material_out_id">
<input type="text" data-table="material_out" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_out->id->getPlaceHolder()) ?>" value="<?php echo $material_out->id->EditValue ?>"<?php echo $material_out->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_process"><?php echo $material_out->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->process->cellAttributes() ?>>
			<span id="el_material_out_process">
<?php $material_out->process->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out->process->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_process" data-value-separator="<?php echo $material_out->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $material_out->process->editAttributes() ?>>
		<?php echo $material_out->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $material_out->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->issue_to_unit->Visible) { // issue_to_unit ?>
	<div id="r_issue_to_unit" class="form-group row">
		<label for="x_issue_to_unit" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_issue_to_unit"><?php echo $material_out->issue_to_unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to_unit" id="z_issue_to_unit" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->issue_to_unit->cellAttributes() ?>>
			<span id="el_material_out_issue_to_unit">
<input type="text" data-table="material_out" data-field="x_issue_to_unit" name="x_issue_to_unit" id="x_issue_to_unit" size="30" placeholder="<?php echo HtmlEncode($material_out->issue_to_unit->getPlaceHolder()) ?>" value="<?php echo $material_out->issue_to_unit->EditValue ?>"<?php echo $material_out->issue_to_unit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label for="x_issue_to" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_issue_to"><?php echo $material_out->issue_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->issue_to->cellAttributes() ?>>
			<span id="el_material_out_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_issue_to" data-value-separator="<?php echo $material_out->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_out->issue_to->editAttributes() ?>>
		<?php echo $material_out->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $material_out->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_godown"><?php echo $material_out->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->godown->cellAttributes() ?>>
			<span id="el_material_out_godown">
<input type="text" data-table="material_out" data-field="x_godown" name="x_godown" id="x_godown" size="30" placeholder="<?php echo HtmlEncode($material_out->godown->getPlaceHolder()) ?>" value="<?php echo $material_out->godown->EditValue ?>"<?php echo $material_out->godown->editAttributes() ?>>
<?php echo $material_out->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_grp"><?php echo $material_out->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->grp->cellAttributes() ?>>
			<span id="el_material_out_grp">
<?php $material_out->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_out->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_grp" data-value-separator="<?php echo $material_out->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_out->grp->editAttributes() ?>>
		<?php echo $material_out->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $material_out->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_s_grp"><?php echo $material_out->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->s_grp->cellAttributes() ?>>
			<span id="el_material_out_s_grp">
<input type="text" data-table="material_out" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" size="30" placeholder="<?php echo HtmlEncode($material_out->s_grp->getPlaceHolder()) ?>" value="<?php echo $material_out->s_grp->EditValue ?>"<?php echo $material_out->s_grp->editAttributes() ?>>
<?php echo $material_out->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_product"><?php echo $material_out->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->product->cellAttributes() ?>>
			<span id="el_material_out_product">
<input type="text" data-table="material_out" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($material_out->product->getPlaceHolder()) ?>" value="<?php echo $material_out->product->EditValue ?>"<?php echo $material_out->product->editAttributes() ?>>
<?php echo $material_out->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid_1->Visible) { // rid_1 ?>
	<div id="r_rid_1" class="form-group row">
		<label for="x_rid_1" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_rid_1"><?php echo $material_out->rid_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid_1" id="z_rid_1" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->rid_1->cellAttributes() ?>>
			<span id="el_material_out_rid_1">
<input type="text" data-table="material_out" data-field="x_rid_1" name="x_rid_1" id="x_rid_1" size="30" placeholder="<?php echo HtmlEncode($material_out->rid_1->getPlaceHolder()) ?>" value="<?php echo $material_out->rid_1->EditValue ?>"<?php echo $material_out->rid_1->editAttributes() ?>>
<?php echo $material_out->rid_1->Lookup->getParamTag("p_x_rid_1") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_packing_type"><?php echo $material_out->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->packing_type->cellAttributes() ?>>
			<span id="el_material_out_packing_type">
<input type="text" data-table="material_out" data-field="x_packing_type" name="x_packing_type" id="x_packing_type" size="30" placeholder="<?php echo HtmlEncode($material_out->packing_type->getPlaceHolder()) ?>" value="<?php echo $material_out->packing_type->EditValue ?>"<?php echo $material_out->packing_type->editAttributes() ?>>
<?php echo $material_out->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid_2->Visible) { // rid_2 ?>
	<div id="r_rid_2" class="form-group row">
		<label for="x_rid_2" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_rid_2"><?php echo $material_out->rid_2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid_2" id="z_rid_2" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->rid_2->cellAttributes() ?>>
			<span id="el_material_out_rid_2">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_2"><?php echo strval($material_out->rid_2->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($material_out->rid_2->AdvancedSearch->ViewValue) : $material_out->rid_2->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_out->rid_2->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($material_out->rid_2->ReadOnly || $material_out->rid_2->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_2',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $material_out->rid_2->Lookup->getParamTag("p_x_rid_2") ?>
<input type="hidden" data-table="material_out" data-field="x_rid_2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_out->rid_2->displayValueSeparatorAttribute() ?>" name="x_rid_2" id="x_rid_2" value="<?php echo $material_out->rid_2->AdvancedSearch->SearchValue ?>"<?php echo $material_out->rid_2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid_3->Visible) { // rid_3 ?>
	<div id="r_rid_3" class="form-group row">
		<label for="x_rid_3" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_rid_3"><?php echo $material_out->rid_3->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rid_3" id="z_rid_3" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->rid_3->cellAttributes() ?>>
			<span id="el_material_out_rid_3">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_3"><?php echo strval($material_out->rid_3->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($material_out->rid_3->AdvancedSearch->ViewValue) : $material_out->rid_3->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_out->rid_3->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($material_out->rid_3->ReadOnly || $material_out->rid_3->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_3',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $material_out->rid_3->Lookup->getParamTag("p_x_rid_3") ?>
<input type="hidden" data-table="material_out" data-field="x_rid_3" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_out->rid_3->displayValueSeparatorAttribute() ?>" name="x_rid_3" id="x_rid_3" value="<?php echo $material_out->rid_3->AdvancedSearch->SearchValue ?>"<?php echo $material_out->rid_3->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_rid"><?php echo $material_out->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->rid->cellAttributes() ?>>
			<span id="el_material_out_rid">
<?php
$wrkonchange = "" . trim(@$material_out->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_out->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8840">
	<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($material_out->rid->EditValue) ?>" size="40" placeholder="<?php echo HtmlEncode($material_out->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_out->rid->getPlaceHolder()) ?>"<?php echo $material_out->rid->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_out" data-field="x_rid" data-value-separator="<?php echo $material_out->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($material_out->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_outsearch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $material_out->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_lot_no"><?php echo $material_out->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->lot_no->cellAttributes() ?>>
			<span id="el_material_out_lot_no">
<input type="text" data-table="material_out" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($material_out->lot_no->getPlaceHolder()) ?>" value="<?php echo $material_out->lot_no->EditValue ?>"<?php echo $material_out->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->avg_quantity->Visible) { // avg_quantity ?>
	<div id="r_avg_quantity" class="form-group row">
		<label for="x_avg_quantity" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_avg_quantity"><?php echo $material_out->avg_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_avg_quantity" id="z_avg_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->avg_quantity->cellAttributes() ?>>
			<span id="el_material_out_avg_quantity">
<input type="text" data-table="material_out" data-field="x_avg_quantity" name="x_avg_quantity" id="x_avg_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out->avg_quantity->getPlaceHolder()) ?>" value="<?php echo $material_out->avg_quantity->EditValue ?>"<?php echo $material_out->avg_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->max_qty->Visible) { // max_qty ?>
	<div id="r_max_qty" class="form-group row">
		<label for="x_max_qty" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_max_qty"><?php echo $material_out->max_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_max_qty" id="z_max_qty" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->max_qty->cellAttributes() ?>>
			<span id="el_material_out_max_qty">
<input type="text" data-table="material_out" data-field="x_max_qty" name="x_max_qty" id="x_max_qty" size="30" placeholder="<?php echo HtmlEncode($material_out->max_qty->getPlaceHolder()) ?>" value="<?php echo $material_out->max_qty->EditValue ?>"<?php echo $material_out->max_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->quantity_sub->Visible) { // quantity_sub ?>
	<div id="r_quantity_sub" class="form-group row">
		<label for="x_quantity_sub" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_quantity_sub"><?php echo $material_out->quantity_sub->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity_sub" id="z_quantity_sub" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->quantity_sub->cellAttributes() ?>>
			<span id="el_material_out_quantity_sub">
<input type="text" data-table="material_out" data-field="x_quantity_sub" name="x_quantity_sub" id="x_quantity_sub" size="30" placeholder="<?php echo HtmlEncode($material_out->quantity_sub->getPlaceHolder()) ?>" value="<?php echo $material_out->quantity_sub->EditValue ?>"<?php echo $material_out->quantity_sub->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_quantity"><?php echo $material_out->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->quantity->cellAttributes() ?>>
			<span id="el_material_out_quantity">
<input type="text" data-table="material_out" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_out->quantity->getPlaceHolder()) ?>" value="<?php echo $material_out->quantity->EditValue ?>"<?php echo $material_out->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_packets"><?php echo $material_out->packets->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packets" id="z_packets" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->packets->cellAttributes() ?>>
			<span id="el_material_out_packets">
<input type="text" data-table="material_out" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($material_out->packets->getPlaceHolder()) ?>" value="<?php echo $material_out->packets->EditValue ?>"<?php echo $material_out->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_price"><?php echo $material_out->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->price->cellAttributes() ?>>
			<span id="el_material_out_price">
<input type="text" data-table="material_out" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($material_out->price->getPlaceHolder()) ?>" value="<?php echo $material_out->price->EditValue ?>"<?php echo $material_out->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->cart_amount->Visible) { // cart_amount ?>
	<div id="r_cart_amount" class="form-group row">
		<label for="x_cart_amount" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_cart_amount"><?php echo $material_out->cart_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cart_amount" id="z_cart_amount" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->cart_amount->cellAttributes() ?>>
			<span id="el_material_out_cart_amount">
<input type="text" data-table="material_out" data-field="x_cart_amount" name="x_cart_amount" id="x_cart_amount" size="30" placeholder="<?php echo HtmlEncode($material_out->cart_amount->getPlaceHolder()) ?>" value="<?php echo $material_out->cart_amount->EditValue ?>"<?php echo $material_out->cart_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->other_amount->Visible) { // other_amount ?>
	<div id="r_other_amount" class="form-group row">
		<label for="x_other_amount" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_other_amount"><?php echo $material_out->other_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_other_amount" id="z_other_amount" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->other_amount->cellAttributes() ?>>
			<span id="el_material_out_other_amount">
<input type="text" data-table="material_out" data-field="x_other_amount" name="x_other_amount" id="x_other_amount" size="30" placeholder="<?php echo HtmlEncode($material_out->other_amount->getPlaceHolder()) ?>" value="<?php echo $material_out->other_amount->EditValue ?>"<?php echo $material_out->other_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_operator"><?php echo $material_out->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->operator->cellAttributes() ?>>
			<span id="el_material_out_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_operator" data-value-separator="<?php echo $material_out->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $material_out->operator->editAttributes() ?>>
		<?php echo $material_out->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $material_out->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_datetime"><?php echo $material_out->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->datetime->cellAttributes() ?>>
			<span id="el_material_out_datetime">
<input type="text" data-table="material_out" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($material_out->datetime->getPlaceHolder()) ?>" value="<?php echo $material_out->datetime->EditValue ?>"<?php echo $material_out->datetime->editAttributes() ?>>
<?php if (!$material_out->datetime->ReadOnly && !$material_out->datetime->Disabled && !isset($material_out->datetime->EditAttrs["readonly"]) && !isset($material_out->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_outsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_dated"><?php echo $material_out->dated->caption() ?></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_out->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_out->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_out->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_out->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_out->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_out->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_out->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_out->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_out->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_out_dated">
<input type="text" data-table="material_out" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($material_out->dated->getPlaceHolder()) ?>" value="<?php echo $material_out->dated->EditValue ?>"<?php echo $material_out->dated->editAttributes() ?>>
<?php if (!$material_out->dated->ReadOnly && !$material_out->dated->Disabled && !isset($material_out->dated->EditAttrs["readonly"]) && !isset($material_out->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_outsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_out_dated" class="btw1_dated d-none">
<input type="text" data-table="material_out" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($material_out->dated->getPlaceHolder()) ?>" value="<?php echo $material_out->dated->EditValue2 ?>"<?php echo $material_out->dated->editAttributes() ?>>
<?php if (!$material_out->dated->ReadOnly && !$material_out->dated->Disabled && !isset($material_out->dated->EditAttrs["readonly"]) && !isset($material_out->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_outsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_remarks"><?php echo $material_out->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->remarks->cellAttributes() ?>>
			<span id="el_material_out_remarks">
<input type="text" data-table="material_out" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="255" placeholder="<?php echo HtmlEncode($material_out->remarks->getPlaceHolder()) ?>" value="<?php echo $material_out->remarks->EditValue ?>"<?php echo $material_out->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_status"><?php echo $material_out->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->status->cellAttributes() ?>>
			<span id="el_material_out_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_out" data-field="x_status" data-value-separator="<?php echo $material_out->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $material_out->status->editAttributes() ?>>
		<?php echo $material_out->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->hsn_code->Visible) { // hsn_code ?>
	<div id="r_hsn_code" class="form-group row">
		<label for="x_hsn_code" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_hsn_code"><?php echo $material_out->hsn_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_hsn_code" id="z_hsn_code" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->hsn_code->cellAttributes() ?>>
			<span id="el_material_out_hsn_code">
<input type="text" data-table="material_out" data-field="x_hsn_code" name="x_hsn_code" id="x_hsn_code" size="30" placeholder="<?php echo HtmlEncode($material_out->hsn_code->getPlaceHolder()) ?>" value="<?php echo $material_out->hsn_code->EditValue ?>"<?php echo $material_out->hsn_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_amount"><?php echo $material_out->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->amount->cellAttributes() ?>>
			<span id="el_material_out_amount">
<input type="text" data-table="material_out" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($material_out->amount->getPlaceHolder()) ?>" value="<?php echo $material_out->amount->EditValue ?>"<?php echo $material_out->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->tax_amount->Visible) { // tax_amount ?>
	<div id="r_tax_amount" class="form-group row">
		<label for="x_tax_amount" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_tax_amount"><?php echo $material_out->tax_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tax_amount" id="z_tax_amount" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->tax_amount->cellAttributes() ?>>
			<span id="el_material_out_tax_amount">
<input type="text" data-table="material_out" data-field="x_tax_amount" name="x_tax_amount" id="x_tax_amount" size="30" placeholder="<?php echo HtmlEncode($material_out->tax_amount->getPlaceHolder()) ?>" value="<?php echo $material_out->tax_amount->EditValue ?>"<?php echo $material_out->tax_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->tax_percent->Visible) { // tax_percent ?>
	<div id="r_tax_percent" class="form-group row">
		<label for="x_tax_percent" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_tax_percent"><?php echo $material_out->tax_percent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tax_percent" id="z_tax_percent" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->tax_percent->cellAttributes() ?>>
			<span id="el_material_out_tax_percent">
<input type="text" data-table="material_out" data-field="x_tax_percent" name="x_tax_percent" id="x_tax_percent" size="30" placeholder="<?php echo HtmlEncode($material_out->tax_percent->getPlaceHolder()) ?>" value="<?php echo $material_out->tax_percent->EditValue ?>"<?php echo $material_out->tax_percent->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label for="x_total_amount" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_total_amount"><?php echo $material_out->total_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_total_amount" id="z_total_amount" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->total_amount->cellAttributes() ?>>
			<span id="el_material_out_total_amount">
<input type="text" data-table="material_out" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($material_out->total_amount->getPlaceHolder()) ?>" value="<?php echo $material_out->total_amount->EditValue ?>"<?php echo $material_out->total_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->cart_ref->Visible) { // cart_ref ?>
	<div id="r_cart_ref" class="form-group row">
		<label for="x_cart_ref" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_cart_ref"><?php echo $material_out->cart_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cart_ref" id="z_cart_ref" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->cart_ref->cellAttributes() ?>>
			<span id="el_material_out_cart_ref">
<input type="text" data-table="material_out" data-field="x_cart_ref" name="x_cart_ref" id="x_cart_ref" size="30" placeholder="<?php echo HtmlEncode($material_out->cart_ref->getPlaceHolder()) ?>" value="<?php echo $material_out->cart_ref->EditValue ?>"<?php echo $material_out->cart_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_uploads"><?php echo $material_out->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->uploads->cellAttributes() ?>>
			<span id="el_material_out_uploads">
<input type="text" data-table="material_out" data-field="x_uploads" name="x_uploads" id="x_uploads" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($material_out->uploads->getPlaceHolder()) ?>" value="<?php echo $material_out->uploads->EditValue ?>"<?php echo $material_out->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_out->godown_po->Visible) { // godown_po ?>
	<div id="r_godown_po" class="form-group row">
		<label for="x_godown_po" class="<?php echo $material_out_search->LeftColumnClass ?>"><span id="elh_material_out_godown_po"><?php echo $material_out->godown_po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown_po" id="z_godown_po" value="="></span>
		</label>
		<div class="<?php echo $material_out_search->RightColumnClass ?>"><div<?php echo $material_out->godown_po->cellAttributes() ?>>
			<span id="el_material_out_godown_po">
<input type="text" data-table="material_out" data-field="x_godown_po" name="x_godown_po" id="x_godown_po" size="30" placeholder="<?php echo HtmlEncode($material_out->godown_po->getPlaceHolder()) ?>" value="<?php echo $material_out->godown_po->EditValue ?>"<?php echo $material_out->godown_po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_out_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_out_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_out_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_out_search->terminate();
?>