<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_out_view = new material_out_view();

// Run the page
$material_out_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_out_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_out->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmaterial_outview = currentForm = new ew.Form("fmaterial_outview", "view");

// Form_CustomValidate event
fmaterial_outview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_outview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_outview.lists["x_process"] = <?php echo $material_out_view->process->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_process"].options = <?php echo JsonEncode($material_out_view->process->lookupOptions()) ?>;
fmaterial_outview.lists["x_issue_to"] = <?php echo $material_out_view->issue_to->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_issue_to"].options = <?php echo JsonEncode($material_out_view->issue_to->lookupOptions()) ?>;
fmaterial_outview.lists["x_godown"] = <?php echo $material_out_view->godown->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_godown"].options = <?php echo JsonEncode($material_out_view->godown->lookupOptions()) ?>;
fmaterial_outview.lists["x_grp"] = <?php echo $material_out_view->grp->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_grp"].options = <?php echo JsonEncode($material_out_view->grp->lookupOptions()) ?>;
fmaterial_outview.lists["x_s_grp"] = <?php echo $material_out_view->s_grp->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_s_grp"].options = <?php echo JsonEncode($material_out_view->s_grp->lookupOptions()) ?>;
fmaterial_outview.lists["x_product"] = <?php echo $material_out_view->product->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_product"].options = <?php echo JsonEncode($material_out_view->product->lookupOptions()) ?>;
fmaterial_outview.lists["x_rid_1"] = <?php echo $material_out_view->rid_1->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_rid_1"].options = <?php echo JsonEncode($material_out_view->rid_1->lookupOptions()) ?>;
fmaterial_outview.lists["x_packing_type"] = <?php echo $material_out_view->packing_type->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_packing_type"].options = <?php echo JsonEncode($material_out_view->packing_type->lookupOptions()) ?>;
fmaterial_outview.lists["x_rid_2"] = <?php echo $material_out_view->rid_2->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_rid_2"].options = <?php echo JsonEncode($material_out_view->rid_2->lookupOptions()) ?>;
fmaterial_outview.lists["x_rid_3"] = <?php echo $material_out_view->rid_3->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_rid_3"].options = <?php echo JsonEncode($material_out_view->rid_3->lookupOptions()) ?>;
fmaterial_outview.lists["x_operator"] = <?php echo $material_out_view->operator->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_operator"].options = <?php echo JsonEncode($material_out_view->operator->lookupOptions()) ?>;
fmaterial_outview.lists["x_status"] = <?php echo $material_out_view->status->Lookup->toClientList() ?>;
fmaterial_outview.lists["x_status"].options = <?php echo JsonEncode($material_out_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_out->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $material_out_view->ExportOptions->render("body") ?>
<?php $material_out_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $material_out_view->showPageHeader(); ?>
<?php
$material_out_view->showMessage();
?>
<form name="fmaterial_outview" id="fmaterial_outview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_out_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_out_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_out">
<input type="hidden" name="modal" value="<?php echo (int)$material_out_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($material_out->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_id"><?php echo $material_out->id->caption() ?></span></td>
		<td data-name="id"<?php echo $material_out->id->cellAttributes() ?>>
<span id="el_material_out_id">
<span<?php echo $material_out->id->viewAttributes() ?>>
<?php echo $material_out->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_process"><?php echo $material_out->process->caption() ?></span></td>
		<td data-name="process"<?php echo $material_out->process->cellAttributes() ?>>
<span id="el_material_out_process">
<span<?php echo $material_out->process->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->process->getViewValue())) && $material_out->process->linkAttributes() <> "") { ?>
<a<?php echo $material_out->process->linkAttributes() ?>><?php echo $material_out->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->issue_to_unit->Visible) { // issue_to_unit ?>
	<tr id="r_issue_to_unit">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_issue_to_unit"><?php echo $material_out->issue_to_unit->caption() ?></span></td>
		<td data-name="issue_to_unit"<?php echo $material_out->issue_to_unit->cellAttributes() ?>>
<span id="el_material_out_issue_to_unit">
<span<?php echo $material_out->issue_to_unit->viewAttributes() ?>>
<?php echo $material_out->issue_to_unit->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->issue_to->Visible) { // issue_to ?>
	<tr id="r_issue_to">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_issue_to"><?php echo $material_out->issue_to->caption() ?></span></td>
		<td data-name="issue_to"<?php echo $material_out->issue_to->cellAttributes() ?>>
<span id="el_material_out_issue_to">
<span<?php echo $material_out->issue_to->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->issue_to->getViewValue())) && $material_out->issue_to->linkAttributes() <> "") { ?>
<a<?php echo $material_out->issue_to->linkAttributes() ?>><?php echo $material_out->issue_to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->issue_to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->godown->Visible) { // godown ?>
	<tr id="r_godown">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_godown"><?php echo $material_out->godown->caption() ?></span></td>
		<td data-name="godown"<?php echo $material_out->godown->cellAttributes() ?>>
<span id="el_material_out_godown">
<span<?php echo $material_out->godown->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->godown->getViewValue())) && $material_out->godown->linkAttributes() <> "") { ?>
<a<?php echo $material_out->godown->linkAttributes() ?>><?php echo $material_out->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->jc_no->Visible) { // jc_no ?>
	<tr id="r_jc_no">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_jc_no"><?php echo $material_out->jc_no->caption() ?></span></td>
		<td data-name="jc_no"<?php echo $material_out->jc_no->cellAttributes() ?>>
<span id="el_material_out_jc_no">
<span<?php echo $material_out->jc_no->viewAttributes() ?>>
<?php echo $material_out->jc_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_grp"><?php echo $material_out->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $material_out->grp->cellAttributes() ?>>
<span id="el_material_out_grp">
<span<?php echo $material_out->grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->grp->getViewValue())) && $material_out->grp->linkAttributes() <> "") { ?>
<a<?php echo $material_out->grp->linkAttributes() ?>><?php echo $material_out->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_s_grp"><?php echo $material_out->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $material_out->s_grp->cellAttributes() ?>>
<span id="el_material_out_s_grp">
<span<?php echo $material_out->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->s_grp->getViewValue())) && $material_out->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $material_out->s_grp->linkAttributes() ?>><?php echo $material_out->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_product"><?php echo $material_out->product->caption() ?></span></td>
		<td data-name="product"<?php echo $material_out->product->cellAttributes() ?>>
<span id="el_material_out_product">
<span<?php echo $material_out->product->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->product->getViewValue())) && $material_out->product->linkAttributes() <> "") { ?>
<a<?php echo $material_out->product->linkAttributes() ?>><?php echo $material_out->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->rid_1->Visible) { // rid_1 ?>
	<tr id="r_rid_1">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_rid_1"><?php echo $material_out->rid_1->caption() ?></span></td>
		<td data-name="rid_1"<?php echo $material_out->rid_1->cellAttributes() ?>>
<span id="el_material_out_rid_1">
<span<?php echo $material_out->rid_1->viewAttributes() ?>>
<?php echo $material_out->rid_1->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_packing_type"><?php echo $material_out->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $material_out->packing_type->cellAttributes() ?>>
<span id="el_material_out_packing_type">
<span<?php echo $material_out->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->packing_type->getViewValue())) && $material_out->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $material_out->packing_type->linkAttributes() ?>><?php echo $material_out->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->rid_2->Visible) { // rid_2 ?>
	<tr id="r_rid_2">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_rid_2"><?php echo $material_out->rid_2->caption() ?></span></td>
		<td data-name="rid_2"<?php echo $material_out->rid_2->cellAttributes() ?>>
<span id="el_material_out_rid_2">
<span<?php echo $material_out->rid_2->viewAttributes() ?>>
<?php echo $material_out->rid_2->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->rid_3->Visible) { // rid_3 ?>
	<tr id="r_rid_3">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_rid_3"><?php echo $material_out->rid_3->caption() ?></span></td>
		<td data-name="rid_3"<?php echo $material_out->rid_3->cellAttributes() ?>>
<span id="el_material_out_rid_3">
<span<?php echo $material_out->rid_3->viewAttributes() ?>>
<?php echo $material_out->rid_3->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->lot_no->Visible) { // lot_no ?>
	<tr id="r_lot_no">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_lot_no"><?php echo $material_out->lot_no->caption() ?></span></td>
		<td data-name="lot_no"<?php echo $material_out->lot_no->cellAttributes() ?>>
<span id="el_material_out_lot_no">
<span<?php echo $material_out->lot_no->viewAttributes() ?>>
<?php echo $material_out->lot_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->avg_quantity->Visible) { // avg_quantity ?>
	<tr id="r_avg_quantity">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_avg_quantity"><?php echo $material_out->avg_quantity->caption() ?></span></td>
		<td data-name="avg_quantity"<?php echo $material_out->avg_quantity->cellAttributes() ?>>
<span id="el_material_out_avg_quantity">
<span<?php echo $material_out->avg_quantity->viewAttributes() ?>>
<?php echo $material_out->avg_quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->max_qty->Visible) { // max_qty ?>
	<tr id="r_max_qty">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_max_qty"><?php echo $material_out->max_qty->caption() ?></span></td>
		<td data-name="max_qty"<?php echo $material_out->max_qty->cellAttributes() ?>>
<span id="el_material_out_max_qty">
<span<?php echo $material_out->max_qty->viewAttributes() ?>>
<?php echo $material_out->max_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->quantity_sub->Visible) { // quantity_sub ?>
	<tr id="r_quantity_sub">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_quantity_sub"><?php echo $material_out->quantity_sub->caption() ?></span></td>
		<td data-name="quantity_sub"<?php echo $material_out->quantity_sub->cellAttributes() ?>>
<span id="el_material_out_quantity_sub">
<span<?php echo $material_out->quantity_sub->viewAttributes() ?>>
<?php echo $material_out->quantity_sub->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_quantity"><?php echo $material_out->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $material_out->quantity->cellAttributes() ?>>
<span id="el_material_out_quantity">
<span<?php echo $material_out->quantity->viewAttributes() ?>>
<?php echo $material_out->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->packets->Visible) { // packets ?>
	<tr id="r_packets">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_packets"><?php echo $material_out->packets->caption() ?></span></td>
		<td data-name="packets"<?php echo $material_out->packets->cellAttributes() ?>>
<span id="el_material_out_packets">
<span<?php echo $material_out->packets->viewAttributes() ?>>
<?php echo $material_out->packets->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->price->Visible) { // price ?>
	<tr id="r_price">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_price"><?php echo $material_out->price->caption() ?></span></td>
		<td data-name="price"<?php echo $material_out->price->cellAttributes() ?>>
<span id="el_material_out_price">
<span<?php echo $material_out->price->viewAttributes() ?>>
<?php echo $material_out->price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->cart_amount->Visible) { // cart_amount ?>
	<tr id="r_cart_amount">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_cart_amount"><?php echo $material_out->cart_amount->caption() ?></span></td>
		<td data-name="cart_amount"<?php echo $material_out->cart_amount->cellAttributes() ?>>
<span id="el_material_out_cart_amount">
<span<?php echo $material_out->cart_amount->viewAttributes() ?>>
<?php echo $material_out->cart_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->other_amount->Visible) { // other_amount ?>
	<tr id="r_other_amount">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_other_amount"><?php echo $material_out->other_amount->caption() ?></span></td>
		<td data-name="other_amount"<?php echo $material_out->other_amount->cellAttributes() ?>>
<span id="el_material_out_other_amount">
<span<?php echo $material_out->other_amount->viewAttributes() ?>>
<?php echo $material_out->other_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_operator"><?php echo $material_out->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $material_out->operator->cellAttributes() ?>>
<span id="el_material_out_operator">
<span<?php echo $material_out->operator->viewAttributes() ?>>
<?php echo $material_out->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_datetime"><?php echo $material_out->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $material_out->datetime->cellAttributes() ?>>
<span id="el_material_out_datetime">
<span<?php echo $material_out->datetime->viewAttributes() ?>>
<?php echo $material_out->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_dated"><?php echo $material_out->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $material_out->dated->cellAttributes() ?>>
<span id="el_material_out_dated">
<span<?php echo $material_out->dated->viewAttributes() ?>>
<?php echo $material_out->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_remarks"><?php echo $material_out->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $material_out->remarks->cellAttributes() ?>>
<span id="el_material_out_remarks">
<span<?php echo $material_out->remarks->viewAttributes() ?>>
<?php echo $material_out->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_status"><?php echo $material_out->status->caption() ?></span></td>
		<td data-name="status"<?php echo $material_out->status->cellAttributes() ?>>
<span id="el_material_out_status">
<span<?php echo $material_out->status->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->status->getViewValue())) && $material_out->status->linkAttributes() <> "") { ?>
<a<?php echo $material_out->status->linkAttributes() ?>><?php echo $material_out->status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->tax_percent->Visible) { // tax_percent ?>
	<tr id="r_tax_percent">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_tax_percent"><?php echo $material_out->tax_percent->caption() ?></span></td>
		<td data-name="tax_percent"<?php echo $material_out->tax_percent->cellAttributes() ?>>
<span id="el_material_out_tax_percent">
<span<?php echo $material_out->tax_percent->viewAttributes() ?>>
<?php echo $material_out->tax_percent->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->cart_ref->Visible) { // cart_ref ?>
	<tr id="r_cart_ref">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_cart_ref"><?php echo $material_out->cart_ref->caption() ?></span></td>
		<td data-name="cart_ref"<?php echo $material_out->cart_ref->cellAttributes() ?>>
<span id="el_material_out_cart_ref">
<span<?php echo $material_out->cart_ref->viewAttributes() ?>>
<?php if ((!EmptyString($material_out->cart_ref->getViewValue())) && $material_out->cart_ref->linkAttributes() <> "") { ?>
<a<?php echo $material_out->cart_ref->linkAttributes() ?>><?php echo $material_out->cart_ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_out->cart_ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out__barcode"><?php echo $material_out->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $material_out->_barcode->cellAttributes() ?>>
<span id="el_material_out__barcode">
<span<?php echo $material_out->_barcode->viewAttributes() ?>>
<?php echo $material_out->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_uploads"><?php echo $material_out->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $material_out->uploads->cellAttributes() ?>>
<span id="el_material_out_uploads">
<span>
<?php echo GetFileViewTag($material_out->uploads, $material_out->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_company_id"><?php echo $material_out->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $material_out->company_id->cellAttributes() ?>>
<span id="el_material_out_company_id">
<span<?php echo $material_out->company_id->viewAttributes() ?>>
<?php echo $material_out->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_out->godown_po->Visible) { // godown_po ?>
	<tr id="r_godown_po">
		<td class="<?php echo $material_out_view->TableLeftColumnClass ?>"><span id="elh_material_out_godown_po"><?php echo $material_out->godown_po->caption() ?></span></td>
		<td data-name="godown_po"<?php echo $material_out->godown_po->cellAttributes() ?>>
<span id="el_material_out_godown_po">
<span<?php echo $material_out->godown_po->viewAttributes() ?>>
<?php echo $material_out->godown_po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$material_out_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_out->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_out_view->terminate();
?>