<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_export_list = new material_required_export_list();

// Run the page
$material_required_export_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_export_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_required_export->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_required_exportlist = currentForm = new ew.Form("fmaterial_required_exportlist", "list");
fmaterial_required_exportlist.formKeyCountName = '<?php echo $material_required_export_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_required_exportlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_exportlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_exportlist.lists["x_buyer_id"] = <?php echo $material_required_export_list->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_exportlist.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_export_list->buyer_id->lookupOptions()) ?>;
fmaterial_required_exportlist.lists["x_product_id"] = <?php echo $material_required_export_list->product_id->Lookup->toClientList() ?>;
fmaterial_required_exportlist.lists["x_product_id"].options = <?php echo JsonEncode($material_required_export_list->product_id->lookupOptions()) ?>;
fmaterial_required_exportlist.lists["x_req_material_rid"] = <?php echo $material_required_export_list->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_exportlist.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_export_list->req_material_rid->lookupOptions()) ?>;
fmaterial_required_exportlist.lists["x_req_material_packing"] = <?php echo $material_required_export_list->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_exportlist.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_export_list->req_material_packing->lookupOptions()) ?>;
fmaterial_required_exportlist.lists["x_batch_no"] = <?php echo $material_required_export_list->batch_no->Lookup->toClientList() ?>;
fmaterial_required_exportlist.lists["x_batch_no"].options = <?php echo JsonEncode($material_required_export_list->batch_no->lookupOptions()) ?>;
fmaterial_required_exportlist.lists["x_unit"] = <?php echo $material_required_export_list->unit->Lookup->toClientList() ?>;
fmaterial_required_exportlist.lists["x_unit"].options = <?php echo JsonEncode($material_required_export_list->unit->lookupOptions()) ?>;
fmaterial_required_exportlist.lists["x_method"] = <?php echo $material_required_export_list->method->Lookup->toClientList() ?>;
fmaterial_required_exportlist.lists["x_method"].options = <?php echo JsonEncode($material_required_export_list->method->lookupOptions()) ?>;
fmaterial_required_exportlist.lists["x_despatch_week"] = <?php echo $material_required_export_list->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_exportlist.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_export_list->despatch_week->lookupOptions()) ?>;

// Form object for search
var fmaterial_required_exportlistsrch = currentSearchForm = new ew.Form("fmaterial_required_exportlistsrch");

// Validate function for search
fmaterial_required_exportlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_export->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_required_exportlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_exportlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_exportlistsrch.lists["x_product_id"] = <?php echo $material_required_export_list->product_id->Lookup->toClientList() ?>;
fmaterial_required_exportlistsrch.lists["x_product_id"].options = <?php echo JsonEncode($material_required_export_list->product_id->lookupOptions()) ?>;
fmaterial_required_exportlistsrch.lists["x_req_material_rid"] = <?php echo $material_required_export_list->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_exportlistsrch.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_export_list->req_material_rid->lookupOptions()) ?>;
fmaterial_required_exportlistsrch.lists["x_req_material_packing"] = <?php echo $material_required_export_list->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_exportlistsrch.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_export_list->req_material_packing->lookupOptions()) ?>;
fmaterial_required_exportlistsrch.lists["x_batch_no"] = <?php echo $material_required_export_list->batch_no->Lookup->toClientList() ?>;
fmaterial_required_exportlistsrch.lists["x_batch_no"].options = <?php echo JsonEncode($material_required_export_list->batch_no->lookupOptions()) ?>;
fmaterial_required_exportlistsrch.lists["x_method"] = <?php echo $material_required_export_list->method->Lookup->toClientList() ?>;
fmaterial_required_exportlistsrch.lists["x_method"].options = <?php echo JsonEncode($material_required_export_list->method->lookupOptions()) ?>;

// Filters
fmaterial_required_exportlistsrch.filterList = <?php echo $material_required_export_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_required_exportlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_required_export->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_required_export_list->TotalRecs > 0 && $material_required_export_list->ExportOptions->visible()) { ?>
<?php $material_required_export_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_export_list->ImportOptions->visible()) { ?>
<?php $material_required_export_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_export_list->SearchOptions->visible()) { ?>
<?php $material_required_export_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_export_list->FilterOptions->visible()) { ?>
<?php $material_required_export_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_required_export_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_required_export->isExport() && !$material_required_export->CurrentAction) { ?>
<form name="fmaterial_required_exportlistsrch" id="fmaterial_required_exportlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_required_export_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_required_exportlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_required_export">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_required_export_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_required_export->RowType = ROWTYPE_SEARCH;

// Render row
$material_required_export->resetAttributes();
$material_required_export_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_required_export->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $material_required_export->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required_export" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required_export->po->getPlaceHolder()) ?>" value="<?php echo $material_required_export->po->EditValue ?>"<?php echo $material_required_export->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="material_required_export" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($material_required_export->po->getPlaceHolder()) ?>" value="<?php echo $material_required_export->po->EditValue2 ?>"<?php echo $material_required_export->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($material_required_export->product_id->Visible) { // product_id ?>
	<div id="xsc_product_id" class="ew-cell form-group">
		<label for="x_product_id" class="ew-search-caption ew-label"><?php echo $material_required_export->product_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_id" id="z_product_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_product_id" data-value-separator="<?php echo $material_required_export->product_id->displayValueSeparatorAttribute() ?>" id="x_product_id" name="x_product_id"<?php echo $material_required_export->product_id->editAttributes() ?>>
		<?php echo $material_required_export->product_id->selectOptionListHtml("x_product_id") ?>
	</select>
</div>
<?php echo $material_required_export->product_id->Lookup->getParamTag("p_x_product_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_export->req_material_rid->Visible) { // req_material_rid ?>
	<div id="xsc_req_material_rid" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $material_required_export->req_material_rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required_export" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_export->req_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_export->req_material_rid->EditValue ?>"<?php echo $material_required_export->req_material_rid->editAttributes() ?>>
<?php echo $material_required_export->req_material_rid->Lookup->getParamTag("p_x_req_material_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($material_required_export->req_material_packing->Visible) { // req_material_packing ?>
	<div id="xsc_req_material_packing" class="ew-cell form-group">
		<label for="x_req_material_packing" class="ew-search-caption ew-label"><?php echo $material_required_export->req_material_packing->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_req_material_packing" data-value-separator="<?php echo $material_required_export->req_material_packing->displayValueSeparatorAttribute() ?>" id="x_req_material_packing" name="x_req_material_packing"<?php echo $material_required_export->req_material_packing->editAttributes() ?>>
		<?php echo $material_required_export->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
	</select>
</div>
<?php echo $material_required_export->req_material_packing->Lookup->getParamTag("p_x_req_material_packing") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_export->batch_no->Visible) { // batch_no ?>
	<div id="xsc_batch_no" class="ew-cell form-group">
		<label for="x_batch_no" class="ew-search-caption ew-label"><?php echo $material_required_export->batch_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		<span class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_batch_no"><?php echo strval($material_required_export->batch_no->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($material_required_export->batch_no->AdvancedSearch->ViewValue) : $material_required_export->batch_no->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_required_export->batch_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($material_required_export->batch_no->ReadOnly || $material_required_export->batch_no->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_batch_no',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $material_required_export->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
<input type="hidden" data-table="material_required_export" data-field="x_batch_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_required_export->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?php echo $material_required_export->batch_no->AdvancedSearch->SearchValue ?>"<?php echo $material_required_export->batch_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($material_required_export->method->Visible) { // method ?>
	<div id="xsc_method" class="ew-cell form-group">
		<label for="x_method" class="ew-search-caption ew-label"><?php echo $material_required_export->method->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_method" data-value-separator="<?php echo $material_required_export->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $material_required_export->method->editAttributes() ?>>
		<?php echo $material_required_export->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $material_required_export->method->Lookup->getParamTag("p_x_method") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_required_export_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_required_export_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_required_export_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_required_export_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_required_export_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_required_export_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_required_export_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_required_export_list->showPageHeader(); ?>
<?php
$material_required_export_list->showMessage();
?>
<?php if ($material_required_export_list->TotalRecs > 0 || $material_required_export->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_required_export_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_required_export">
<?php if (!$material_required_export->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_required_export->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_export_list->Pager)) $material_required_export_list->Pager = new PrevNextPager($material_required_export_list->StartRec, $material_required_export_list->DisplayRecs, $material_required_export_list->TotalRecs, $material_required_export_list->AutoHidePager) ?>
<?php if ($material_required_export_list->Pager->RecordCount > 0 && $material_required_export_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_export_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_export_list->pageUrl() ?>start=<?php echo $material_required_export_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_export_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_export_list->pageUrl() ?>start=<?php echo $material_required_export_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_export_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_export_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_export_list->pageUrl() ?>start=<?php echo $material_required_export_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_export_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_export_list->pageUrl() ?>start=<?php echo $material_required_export_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_export_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_export_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_export_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_export_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_export_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_export_list->TotalRecs > 0 && (!$material_required_export_list->AutoHidePageSizeSelector || $material_required_export_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_export">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_export_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_export_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_export_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_export_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_export_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_export->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_export_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_required_exportlist" id="fmaterial_required_exportlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_export_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_export_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_export">
<div id="gmp_material_required_export" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_required_export_list->TotalRecs > 0 || $material_required_export->isGridEdit()) { ?>
<table id="tbl_material_required_exportlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_required_export_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_required_export_list->renderListOptions();

// Render list options (header, left)
$material_required_export_list->ListOptions->render("header", "left");
?>
<?php if ($material_required_export->id->Visible) { // id ?>
	<?php if ($material_required_export->sortUrl($material_required_export->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_required_export->id->headerCellClass() ?>"><div id="elh_material_required_export_id" class="material_required_export_id"><div class="ew-table-header-caption"><?php echo $material_required_export->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_required_export->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->id) ?>',2);"><div id="elh_material_required_export_id" class="material_required_export_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->weaving_works->Visible) { // weaving_works ?>
	<?php if ($material_required_export->sortUrl($material_required_export->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $material_required_export->weaving_works->headerCellClass() ?>"><div id="elh_material_required_export_weaving_works" class="material_required_export_weaving_works"><div class="ew-table-header-caption"><?php echo $material_required_export->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $material_required_export->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->weaving_works) ?>',2);"><div id="elh_material_required_export_weaving_works" class="material_required_export_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->week->Visible) { // week ?>
	<?php if ($material_required_export->sortUrl($material_required_export->week) == "") { ?>
		<th data-name="week" class="<?php echo $material_required_export->week->headerCellClass() ?>"><div id="elh_material_required_export_week" class="material_required_export_week"><div class="ew-table-header-caption"><?php echo $material_required_export->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $material_required_export->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->week) ?>',2);"><div id="elh_material_required_export_week" class="material_required_export_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->po->Visible) { // po ?>
	<?php if ($material_required_export->sortUrl($material_required_export->po) == "") { ?>
		<th data-name="po" class="<?php echo $material_required_export->po->headerCellClass() ?>"><div id="elh_material_required_export_po" class="material_required_export_po"><div class="ew-table-header-caption"><?php echo $material_required_export->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $material_required_export->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->po) ?>',2);"><div id="elh_material_required_export_po" class="material_required_export_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->buyer_id->Visible) { // buyer_id ?>
	<?php if ($material_required_export->sortUrl($material_required_export->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_export->buyer_id->headerCellClass() ?>"><div id="elh_material_required_export_buyer_id" class="material_required_export_buyer_id"><div class="ew-table-header-caption"><?php echo $material_required_export->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_export->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->buyer_id) ?>',2);"><div id="elh_material_required_export_buyer_id" class="material_required_export_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->product_id->Visible) { // product_id ?>
	<?php if ($material_required_export->sortUrl($material_required_export->product_id) == "") { ?>
		<th data-name="product_id" class="<?php echo $material_required_export->product_id->headerCellClass() ?>"><div id="elh_material_required_export_product_id" class="material_required_export_product_id"><div class="ew-table-header-caption"><?php echo $material_required_export->product_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_id" class="<?php echo $material_required_export->product_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->product_id) ?>',2);"><div id="elh_material_required_export_product_id" class="material_required_export_product_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->product_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->product_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->product_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required_export->sortUrl($material_required_export->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_export->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_export_req_material_rid" class="material_required_export_req_material_rid"><div class="ew-table-header-caption"><?php echo $material_required_export->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_export->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->req_material_rid) ?>',2);"><div id="elh_material_required_export_req_material_rid" class="material_required_export_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required_export->sortUrl($material_required_export->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_export->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_export_req_material_qty" class="material_required_export_req_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_export->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_export->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->req_material_qty) ?>',2);"><div id="elh_material_required_export_req_material_qty" class="material_required_export_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->req_material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($material_required_export->sortUrl($material_required_export->req_material_packing) == "") { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_export->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_export_req_material_packing" class="material_required_export_req_material_packing"><div class="ew-table-header-caption"><?php echo $material_required_export->req_material_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_export->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->req_material_packing) ?>',2);"><div id="elh_material_required_export_req_material_packing" class="material_required_export_req_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->req_material_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->req_material_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->batch_no->Visible) { // batch_no ?>
	<?php if ($material_required_export->sortUrl($material_required_export->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $material_required_export->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_export_batch_no" class="material_required_export_batch_no"><div class="ew-table-header-caption"><?php echo $material_required_export->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $material_required_export->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->batch_no) ?>',2);"><div id="elh_material_required_export_batch_no" class="material_required_export_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->quantity->Visible) { // quantity ?>
	<?php if ($material_required_export->sortUrl($material_required_export->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_required_export->quantity->headerCellClass() ?>"><div id="elh_material_required_export_quantity" class="material_required_export_quantity"><div class="ew-table-header-caption"><?php echo $material_required_export->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_required_export->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->quantity) ?>',2);"><div id="elh_material_required_export_quantity" class="material_required_export_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->Size_wl->Visible) { // Size_wl ?>
	<?php if ($material_required_export->sortUrl($material_required_export->Size_wl) == "") { ?>
		<th data-name="Size_wl" class="<?php echo $material_required_export->Size_wl->headerCellClass() ?>"><div id="elh_material_required_export_Size_wl" class="material_required_export_Size_wl"><div class="ew-table-header-caption"><?php echo $material_required_export->Size_wl->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Size_wl" class="<?php echo $material_required_export->Size_wl->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->Size_wl) ?>',2);"><div id="elh_material_required_export_Size_wl" class="material_required_export_Size_wl">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->Size_wl->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->Size_wl->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->Size_wl->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->sqm->Visible) { // sqm ?>
	<?php if ($material_required_export->sortUrl($material_required_export->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $material_required_export->sqm->headerCellClass() ?>"><div id="elh_material_required_export_sqm" class="material_required_export_sqm"><div class="ew-table-header-caption"><?php echo $material_required_export->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $material_required_export->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->sqm) ?>',2);"><div id="elh_material_required_export_sqm" class="material_required_export_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->t_sqm->Visible) { // t_sqm ?>
	<?php if ($material_required_export->sortUrl($material_required_export->t_sqm) == "") { ?>
		<th data-name="t_sqm" class="<?php echo $material_required_export->t_sqm->headerCellClass() ?>"><div id="elh_material_required_export_t_sqm" class="material_required_export_t_sqm"><div class="ew-table-header-caption"><?php echo $material_required_export->t_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_sqm" class="<?php echo $material_required_export->t_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->t_sqm) ?>',2);"><div id="elh_material_required_export_t_sqm" class="material_required_export_t_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->t_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->t_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->t_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->unit->Visible) { // unit ?>
	<?php if ($material_required_export->sortUrl($material_required_export->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $material_required_export->unit->headerCellClass() ?>"><div id="elh_material_required_export_unit" class="material_required_export_unit"><div class="ew-table-header-caption"><?php echo $material_required_export->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $material_required_export->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->unit) ?>',2);"><div id="elh_material_required_export_unit" class="material_required_export_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->material_qty->Visible) { // material_qty ?>
	<?php if ($material_required_export->sortUrl($material_required_export->material_qty) == "") { ?>
		<th data-name="material_qty" class="<?php echo $material_required_export->material_qty->headerCellClass() ?>"><div id="elh_material_required_export_material_qty" class="material_required_export_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_export->material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_qty" class="<?php echo $material_required_export->material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->material_qty) ?>',2);"><div id="elh_material_required_export_material_qty" class="material_required_export_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->method->Visible) { // method ?>
	<?php if ($material_required_export->sortUrl($material_required_export->method) == "") { ?>
		<th data-name="method" class="<?php echo $material_required_export->method->headerCellClass() ?>"><div id="elh_material_required_export_method" class="material_required_export_method"><div class="ew-table-header-caption"><?php echo $material_required_export->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $material_required_export->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->method) ?>',2);"><div id="elh_material_required_export_method" class="material_required_export_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_export->despatch_week->Visible) { // despatch_week ?>
	<?php if ($material_required_export->sortUrl($material_required_export->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_export->despatch_week->headerCellClass() ?>"><div id="elh_material_required_export_despatch_week" class="material_required_export_despatch_week"><div class="ew-table-header-caption"><?php echo $material_required_export->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_export->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_export->SortUrl($material_required_export->despatch_week) ?>',2);"><div id="elh_material_required_export_despatch_week" class="material_required_export_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_export->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_export->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_export->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_export_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_required_export->ExportAll && $material_required_export->isExport()) {
	$material_required_export_list->StopRec = $material_required_export_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_required_export_list->TotalRecs > $material_required_export_list->StartRec + $material_required_export_list->DisplayRecs - 1)
		$material_required_export_list->StopRec = $material_required_export_list->StartRec + $material_required_export_list->DisplayRecs - 1;
	else
		$material_required_export_list->StopRec = $material_required_export_list->TotalRecs;
}
$material_required_export_list->RecCnt = $material_required_export_list->StartRec - 1;
if ($material_required_export_list->Recordset && !$material_required_export_list->Recordset->EOF) {
	$material_required_export_list->Recordset->moveFirst();
	$selectLimit = $material_required_export_list->UseSelectLimit;
	if (!$selectLimit && $material_required_export_list->StartRec > 1)
		$material_required_export_list->Recordset->move($material_required_export_list->StartRec - 1);
} elseif (!$material_required_export->AllowAddDeleteRow && $material_required_export_list->StopRec == 0) {
	$material_required_export_list->StopRec = $material_required_export->GridAddRowCount;
}

// Initialize aggregate
$material_required_export->RowType = ROWTYPE_AGGREGATEINIT;
$material_required_export->resetAttributes();
$material_required_export_list->renderRow();
while ($material_required_export_list->RecCnt < $material_required_export_list->StopRec) {
	$material_required_export_list->RecCnt++;
	if ($material_required_export_list->RecCnt >= $material_required_export_list->StartRec) {
		$material_required_export_list->RowCnt++;

		// Set up key count
		$material_required_export_list->KeyCount = $material_required_export_list->RowIndex;

		// Init row class and style
		$material_required_export->resetAttributes();
		$material_required_export->CssClass = "";
		if ($material_required_export->isGridAdd()) {
		} else {
			$material_required_export_list->loadRowValues($material_required_export_list->Recordset); // Load row values
		}
		$material_required_export->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_required_export->RowAttrs = array_merge($material_required_export->RowAttrs, array('data-rowindex'=>$material_required_export_list->RowCnt, 'id'=>'r' . $material_required_export_list->RowCnt . '_material_required_export', 'data-rowtype'=>$material_required_export->RowType));

		// Render row
		$material_required_export_list->renderRow();

		// Render list options
		$material_required_export_list->renderListOptions();
?>
	<tr<?php echo $material_required_export->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_export_list->ListOptions->render("body", "left", $material_required_export_list->RowCnt);
?>
	<?php if ($material_required_export->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_required_export->id->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_id" class="material_required_export_id">
<span<?php echo $material_required_export->id->viewAttributes() ?>>
<?php echo $material_required_export->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $material_required_export->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_weaving_works" class="material_required_export_weaving_works">
<span<?php echo $material_required_export->weaving_works->viewAttributes() ?>>
<?php echo $material_required_export->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->week->Visible) { // week ?>
		<td data-name="week"<?php echo $material_required_export->week->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_week" class="material_required_export_week">
<span<?php echo $material_required_export->week->viewAttributes() ?>>
<?php echo $material_required_export->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->po->Visible) { // po ?>
		<td data-name="po"<?php echo $material_required_export->po->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_po" class="material_required_export_po">
<span<?php echo $material_required_export->po->viewAttributes() ?>>
<?php echo $material_required_export->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $material_required_export->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_buyer_id" class="material_required_export_buyer_id">
<span<?php echo $material_required_export->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_export->buyer_id->getViewValue())) && $material_required_export->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_export->buyer_id->linkAttributes() ?>><?php echo $material_required_export->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_export->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->product_id->Visible) { // product_id ?>
		<td data-name="product_id"<?php echo $material_required_export->product_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_product_id" class="material_required_export_product_id">
<span<?php echo $material_required_export->product_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_export->product_id->getViewValue())) && $material_required_export->product_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_export->product_id->linkAttributes() ?>><?php echo $material_required_export->product_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_export->product_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $material_required_export->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_req_material_rid" class="material_required_export_req_material_rid">
<span<?php echo $material_required_export->req_material_rid->viewAttributes() ?>>
<?php echo $material_required_export->req_material_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $material_required_export->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_req_material_qty" class="material_required_export_req_material_qty">
<span<?php echo $material_required_export->req_material_qty->viewAttributes() ?>>
<?php echo $material_required_export->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing"<?php echo $material_required_export->req_material_packing->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_req_material_packing" class="material_required_export_req_material_packing">
<span<?php echo $material_required_export->req_material_packing->viewAttributes() ?>>
<?php echo $material_required_export->req_material_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $material_required_export->batch_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_batch_no" class="material_required_export_batch_no">
<span<?php echo $material_required_export->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_export->batch_no->getViewValue())) && $material_required_export->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $material_required_export->batch_no->linkAttributes() ?>><?php echo $material_required_export->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_export->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_required_export->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_quantity" class="material_required_export_quantity">
<span<?php echo $material_required_export->quantity->viewAttributes() ?>>
<?php echo $material_required_export->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->Size_wl->Visible) { // Size_wl ?>
		<td data-name="Size_wl"<?php echo $material_required_export->Size_wl->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_Size_wl" class="material_required_export_Size_wl">
<span<?php echo $material_required_export->Size_wl->viewAttributes() ?>>
<?php echo $material_required_export->Size_wl->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $material_required_export->sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_sqm" class="material_required_export_sqm">
<span<?php echo $material_required_export->sqm->viewAttributes() ?>>
<?php echo $material_required_export->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->t_sqm->Visible) { // t_sqm ?>
		<td data-name="t_sqm"<?php echo $material_required_export->t_sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_t_sqm" class="material_required_export_t_sqm">
<span<?php echo $material_required_export->t_sqm->viewAttributes() ?>>
<?php echo $material_required_export->t_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $material_required_export->unit->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_unit" class="material_required_export_unit">
<span<?php echo $material_required_export->unit->viewAttributes() ?>>
<?php echo $material_required_export->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty"<?php echo $material_required_export->material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_material_qty" class="material_required_export_material_qty">
<span<?php echo $material_required_export->material_qty->viewAttributes() ?>>
<?php echo $material_required_export->material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->method->Visible) { // method ?>
		<td data-name="method"<?php echo $material_required_export->method->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_method" class="material_required_export_method">
<span<?php echo $material_required_export->method->viewAttributes() ?>>
<?php echo $material_required_export->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_export->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $material_required_export->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $material_required_export_list->RowCnt ?>_material_required_export_despatch_week" class="material_required_export_despatch_week">
<span<?php echo $material_required_export->despatch_week->viewAttributes() ?>>
<?php echo $material_required_export->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_required_export_list->ListOptions->render("body", "right", $material_required_export_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_required_export->isGridAdd())
		$material_required_export_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$material_required_export->RowType = ROWTYPE_AGGREGATE;
$material_required_export->resetAttributes();
$material_required_export_list->renderRow();
?>
<?php if ($material_required_export_list->TotalRecs > 0 && !$material_required_export->isGridAdd() && !$material_required_export->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$material_required_export_list->renderListOptions();

// Render list options (footer, left)
$material_required_export_list->ListOptions->render("footer", "left");
?>
	<?php if ($material_required_export->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $material_required_export->id->footerCellClass() ?>"><span id="elf_material_required_export_id" class="material_required_export_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works" class="<?php echo $material_required_export->weaving_works->footerCellClass() ?>"><span id="elf_material_required_export_weaving_works" class="material_required_export_weaving_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->week->Visible) { // week ?>
		<td data-name="week" class="<?php echo $material_required_export->week->footerCellClass() ?>"><span id="elf_material_required_export_week" class="material_required_export_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $material_required_export->po->footerCellClass() ?>"><span id="elf_material_required_export_po" class="material_required_export_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $material_required_export->buyer_id->footerCellClass() ?>"><span id="elf_material_required_export_buyer_id" class="material_required_export_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->product_id->Visible) { // product_id ?>
		<td data-name="product_id" class="<?php echo $material_required_export->product_id->footerCellClass() ?>"><span id="elf_material_required_export_product_id" class="material_required_export_product_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid" class="<?php echo $material_required_export->req_material_rid->footerCellClass() ?>"><span id="elf_material_required_export_req_material_rid" class="material_required_export_req_material_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty" class="<?php echo $material_required_export->req_material_qty->footerCellClass() ?>"><span id="elf_material_required_export_req_material_qty" class="material_required_export_req_material_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_required_export->req_material_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing" class="<?php echo $material_required_export->req_material_packing->footerCellClass() ?>"><span id="elf_material_required_export_req_material_packing" class="material_required_export_req_material_packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $material_required_export->batch_no->footerCellClass() ?>"><span id="elf_material_required_export_batch_no" class="material_required_export_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $material_required_export->quantity->footerCellClass() ?>"><span id="elf_material_required_export_quantity" class="material_required_export_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->Size_wl->Visible) { // Size_wl ?>
		<td data-name="Size_wl" class="<?php echo $material_required_export->Size_wl->footerCellClass() ?>"><span id="elf_material_required_export_Size_wl" class="material_required_export_Size_wl">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $material_required_export->sqm->footerCellClass() ?>"><span id="elf_material_required_export_sqm" class="material_required_export_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->t_sqm->Visible) { // t_sqm ?>
		<td data-name="t_sqm" class="<?php echo $material_required_export->t_sqm->footerCellClass() ?>"><span id="elf_material_required_export_t_sqm" class="material_required_export_t_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->unit->Visible) { // unit ?>
		<td data-name="unit" class="<?php echo $material_required_export->unit->footerCellClass() ?>"><span id="elf_material_required_export_unit" class="material_required_export_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty" class="<?php echo $material_required_export->material_qty->footerCellClass() ?>"><span id="elf_material_required_export_material_qty" class="material_required_export_material_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->method->Visible) { // method ?>
		<td data-name="method" class="<?php echo $material_required_export->method->footerCellClass() ?>"><span id="elf_material_required_export_method" class="material_required_export_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_export->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week" class="<?php echo $material_required_export->despatch_week->footerCellClass() ?>"><span id="elf_material_required_export_despatch_week" class="material_required_export_despatch_week">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$material_required_export_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_required_export->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_required_export_list->Recordset)
	$material_required_export_list->Recordset->Close();
?>
<?php if (!$material_required_export->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_required_export->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_export_list->Pager)) $material_required_export_list->Pager = new PrevNextPager($material_required_export_list->StartRec, $material_required_export_list->DisplayRecs, $material_required_export_list->TotalRecs, $material_required_export_list->AutoHidePager) ?>
<?php if ($material_required_export_list->Pager->RecordCount > 0 && $material_required_export_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_export_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_export_list->pageUrl() ?>start=<?php echo $material_required_export_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_export_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_export_list->pageUrl() ?>start=<?php echo $material_required_export_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_export_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_export_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_export_list->pageUrl() ?>start=<?php echo $material_required_export_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_export_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_export_list->pageUrl() ?>start=<?php echo $material_required_export_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_export_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_export_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_export_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_export_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_export_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_export_list->TotalRecs > 0 && (!$material_required_export_list->AutoHidePageSizeSelector || $material_required_export_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_export">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_export_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_export_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_export_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_export_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_export_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_export->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_export_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_required_export_list->TotalRecs == 0 && !$material_required_export->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_required_export_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_required_export_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_required_export->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_required_export->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_required_export", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_required_export_list->terminate();
?>