<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_export_search = new material_required_export_search();

// Run the page
$material_required_export_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_export_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_required_export_search->IsModal) { ?>
var fmaterial_required_exportsearch = currentAdvancedSearchForm = new ew.Form("fmaterial_required_exportsearch", "search");
<?php } else { ?>
var fmaterial_required_exportsearch = currentForm = new ew.Form("fmaterial_required_exportsearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_required_exportsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_exportsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_exportsearch.lists["x_buyer_id"] = <?php echo $material_required_export_search->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_exportsearch.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_export_search->buyer_id->lookupOptions()) ?>;
fmaterial_required_exportsearch.lists["x_product_id"] = <?php echo $material_required_export_search->product_id->Lookup->toClientList() ?>;
fmaterial_required_exportsearch.lists["x_product_id"].options = <?php echo JsonEncode($material_required_export_search->product_id->lookupOptions()) ?>;
fmaterial_required_exportsearch.lists["x_req_material_rid"] = <?php echo $material_required_export_search->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_exportsearch.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_export_search->req_material_rid->lookupOptions()) ?>;
fmaterial_required_exportsearch.lists["x_req_material_packing"] = <?php echo $material_required_export_search->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_exportsearch.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_export_search->req_material_packing->lookupOptions()) ?>;
fmaterial_required_exportsearch.lists["x_batch_no"] = <?php echo $material_required_export_search->batch_no->Lookup->toClientList() ?>;
fmaterial_required_exportsearch.lists["x_batch_no"].options = <?php echo JsonEncode($material_required_export_search->batch_no->lookupOptions()) ?>;
fmaterial_required_exportsearch.lists["x_unit"] = <?php echo $material_required_export_search->unit->Lookup->toClientList() ?>;
fmaterial_required_exportsearch.lists["x_unit"].options = <?php echo JsonEncode($material_required_export_search->unit->lookupOptions()) ?>;
fmaterial_required_exportsearch.lists["x_method"] = <?php echo $material_required_export_search->method->Lookup->toClientList() ?>;
fmaterial_required_exportsearch.lists["x_method"].options = <?php echo JsonEncode($material_required_export_search->method->lookupOptions()) ?>;
fmaterial_required_exportsearch.lists["x_despatch_week"] = <?php echo $material_required_export_search->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_exportsearch.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_export_search->despatch_week->lookupOptions()) ?>;
fmaterial_required_exportsearch.lists["x_production_plan"] = <?php echo $material_required_export_search->production_plan->Lookup->toClientList() ?>;
fmaterial_required_exportsearch.lists["x_production_plan"].options = <?php echo JsonEncode($material_required_export_search->production_plan->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fmaterial_required_exportsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_export->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weaving_works");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_export->weaving_works->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_week");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_export->week->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_export->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_req_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_export->req_material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_export->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_t_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_export->t_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_export->material_qty->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_required_export_search->showPageHeader(); ?>
<?php
$material_required_export_search->showMessage();
?>
<form name="fmaterial_required_exportsearch" id="fmaterial_required_exportsearch" class="<?php echo $material_required_export_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_export_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_export_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_export">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_required_export_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_required_export->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_id"><?php echo $material_required_export->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->id->cellAttributes() ?>>
			<span id="el_material_required_export_id">
<input type="text" data-table="material_required_export" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_required_export->id->getPlaceHolder()) ?>" value="<?php echo $material_required_export->id->EditValue ?>"<?php echo $material_required_export->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_weaving_works"><?php echo $material_required_export->weaving_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->weaving_works->cellAttributes() ?>>
			<span id="el_material_required_export_weaving_works">
<input type="text" data-table="material_required_export" data-field="x_weaving_works" name="x_weaving_works" id="x_weaving_works" size="30" placeholder="<?php echo HtmlEncode($material_required_export->weaving_works->getPlaceHolder()) ?>" value="<?php echo $material_required_export->weaving_works->EditValue ?>"<?php echo $material_required_export->weaving_works->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->week->Visible) { // week ?>
	<div id="r_week" class="form-group row">
		<label for="x_week" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_week"><?php echo $material_required_export->week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_week" id="z_week" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->week->cellAttributes() ?>>
			<span id="el_material_required_export_week">
<input type="text" data-table="material_required_export" data-field="x_week" name="x_week" id="x_week" size="30" placeholder="<?php echo HtmlEncode($material_required_export->week->getPlaceHolder()) ?>" value="<?php echo $material_required_export->week->EditValue ?>"<?php echo $material_required_export->week->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_po"><?php echo $material_required_export->po->caption() ?></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required_export->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_required_export_po">
<input type="text" data-table="material_required_export" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required_export->po->getPlaceHolder()) ?>" value="<?php echo $material_required_export->po->EditValue ?>"<?php echo $material_required_export->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_required_export_po" class="btw1_po d-none">
<input type="text" data-table="material_required_export" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($material_required_export->po->getPlaceHolder()) ?>" value="<?php echo $material_required_export->po->EditValue2 ?>"<?php echo $material_required_export->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_buyer_id"><?php echo $material_required_export->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->buyer_id->cellAttributes() ?>>
			<span id="el_material_required_export_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_buyer_id" data-value-separator="<?php echo $material_required_export->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $material_required_export->buyer_id->editAttributes() ?>>
		<?php echo $material_required_export->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $material_required_export->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->product_id->Visible) { // product_id ?>
	<div id="r_product_id" class="form-group row">
		<label for="x_product_id" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_product_id"><?php echo $material_required_export->product_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_id" id="z_product_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->product_id->cellAttributes() ?>>
			<span id="el_material_required_export_product_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_product_id" data-value-separator="<?php echo $material_required_export->product_id->displayValueSeparatorAttribute() ?>" id="x_product_id" name="x_product_id"<?php echo $material_required_export->product_id->editAttributes() ?>>
		<?php echo $material_required_export->product_id->selectOptionListHtml("x_product_id") ?>
	</select>
</div>
<?php echo $material_required_export->product_id->Lookup->getParamTag("p_x_product_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->req_material_rid->Visible) { // req_material_rid ?>
	<div id="r_req_material_rid" class="form-group row">
		<label class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_req_material_rid"><?php echo $material_required_export->req_material_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->req_material_rid->cellAttributes() ?>>
			<span id="el_material_required_export_req_material_rid">
<input type="text" data-table="material_required_export" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_export->req_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_export->req_material_rid->EditValue ?>"<?php echo $material_required_export->req_material_rid->editAttributes() ?>>
<?php echo $material_required_export->req_material_rid->Lookup->getParamTag("p_x_req_material_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->req_material_qty->Visible) { // req_material_qty ?>
	<div id="r_req_material_qty" class="form-group row">
		<label for="x_req_material_qty" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_req_material_qty"><?php echo $material_required_export->req_material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_qty" id="z_req_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->req_material_qty->cellAttributes() ?>>
			<span id="el_material_required_export_req_material_qty">
<input type="text" data-table="material_required_export" data-field="x_req_material_qty" name="x_req_material_qty" id="x_req_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_export->req_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_export->req_material_qty->EditValue ?>"<?php echo $material_required_export->req_material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->req_material_packing->Visible) { // req_material_packing ?>
	<div id="r_req_material_packing" class="form-group row">
		<label for="x_req_material_packing" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_req_material_packing"><?php echo $material_required_export->req_material_packing->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->req_material_packing->cellAttributes() ?>>
			<span id="el_material_required_export_req_material_packing">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_req_material_packing" data-value-separator="<?php echo $material_required_export->req_material_packing->displayValueSeparatorAttribute() ?>" id="x_req_material_packing" name="x_req_material_packing"<?php echo $material_required_export->req_material_packing->editAttributes() ?>>
		<?php echo $material_required_export->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
	</select>
</div>
<?php echo $material_required_export->req_material_packing->Lookup->getParamTag("p_x_req_material_packing") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_batch_no"><?php echo $material_required_export->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->batch_no->cellAttributes() ?>>
			<span id="el_material_required_export_batch_no">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_batch_no"><?php echo strval($material_required_export->batch_no->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($material_required_export->batch_no->AdvancedSearch->ViewValue) : $material_required_export->batch_no->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_required_export->batch_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($material_required_export->batch_no->ReadOnly || $material_required_export->batch_no->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_batch_no',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $material_required_export->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
<input type="hidden" data-table="material_required_export" data-field="x_batch_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_required_export->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?php echo $material_required_export->batch_no->AdvancedSearch->SearchValue ?>"<?php echo $material_required_export->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_quantity"><?php echo $material_required_export->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->quantity->cellAttributes() ?>>
			<span id="el_material_required_export_quantity">
<input type="text" data-table="material_required_export" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_required_export->quantity->getPlaceHolder()) ?>" value="<?php echo $material_required_export->quantity->EditValue ?>"<?php echo $material_required_export->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->Size_wl->Visible) { // Size_wl ?>
	<div id="r_Size_wl" class="form-group row">
		<label for="x_Size_wl" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_Size_wl"><?php echo $material_required_export->Size_wl->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Size_wl" id="z_Size_wl" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->Size_wl->cellAttributes() ?>>
			<span id="el_material_required_export_Size_wl">
<input type="text" data-table="material_required_export" data-field="x_Size_wl" name="x_Size_wl" id="x_Size_wl" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($material_required_export->Size_wl->getPlaceHolder()) ?>" value="<?php echo $material_required_export->Size_wl->EditValue ?>"<?php echo $material_required_export->Size_wl->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_sqm"><?php echo $material_required_export->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->sqm->cellAttributes() ?>>
			<span id="el_material_required_export_sqm">
<input type="text" data-table="material_required_export" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($material_required_export->sqm->getPlaceHolder()) ?>" value="<?php echo $material_required_export->sqm->EditValue ?>"<?php echo $material_required_export->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->t_sqm->Visible) { // t_sqm ?>
	<div id="r_t_sqm" class="form-group row">
		<label for="x_t_sqm" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_t_sqm"><?php echo $material_required_export->t_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_t_sqm" id="z_t_sqm" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->t_sqm->cellAttributes() ?>>
			<span id="el_material_required_export_t_sqm">
<input type="text" data-table="material_required_export" data-field="x_t_sqm" name="x_t_sqm" id="x_t_sqm" size="30" placeholder="<?php echo HtmlEncode($material_required_export->t_sqm->getPlaceHolder()) ?>" value="<?php echo $material_required_export->t_sqm->EditValue ?>"<?php echo $material_required_export->t_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_unit"><?php echo $material_required_export->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->unit->cellAttributes() ?>>
			<span id="el_material_required_export_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_unit" data-value-separator="<?php echo $material_required_export->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $material_required_export->unit->editAttributes() ?>>
		<?php echo $material_required_export->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $material_required_export->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->material_qty->Visible) { // material_qty ?>
	<div id="r_material_qty" class="form-group row">
		<label for="x_material_qty" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_material_qty"><?php echo $material_required_export->material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_qty" id="z_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->material_qty->cellAttributes() ?>>
			<span id="el_material_required_export_material_qty">
<input type="text" data-table="material_required_export" data-field="x_material_qty" name="x_material_qty" id="x_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_export->material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_export->material_qty->EditValue ?>"<?php echo $material_required_export->material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_method"><?php echo $material_required_export->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->method->cellAttributes() ?>>
			<span id="el_material_required_export_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_method" data-value-separator="<?php echo $material_required_export->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $material_required_export->method->editAttributes() ?>>
		<?php echo $material_required_export->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $material_required_export->method->Lookup->getParamTag("p_x_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_despatch_week"><?php echo $material_required_export->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->despatch_week->cellAttributes() ?>>
			<span id="el_material_required_export_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_despatch_week" data-value-separator="<?php echo $material_required_export->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $material_required_export->despatch_week->editAttributes() ?>>
		<?php echo $material_required_export->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $material_required_export->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_export->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $material_required_export_search->LeftColumnClass ?>"><span id="elh_material_required_export_production_plan"><?php echo $material_required_export->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $material_required_export_search->RightColumnClass ?>"><div<?php echo $material_required_export->production_plan->cellAttributes() ?>>
			<span id="el_material_required_export_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_export" data-field="x_production_plan" data-value-separator="<?php echo $material_required_export->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $material_required_export->production_plan->editAttributes() ?>>
		<?php echo $material_required_export->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_required_export_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_required_export_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_required_export_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_required_export_search->terminate();
?>