<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_issue_fp_edit = new material_required_issue_fp_edit();

// Run the page
$material_required_issue_fp_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_issue_fp_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fmaterial_required_issue_fpedit = currentForm = new ew.Form("fmaterial_required_issue_fpedit", "edit");

// Validate form
fmaterial_required_issue_fpedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($material_required_issue_fp_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->id->caption(), $material_required_issue_fp->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->jc_no->caption(), $material_required_issue_fp->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->po->caption(), $material_required_issue_fp->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->week->Required) { ?>
			elm = this.getElements("x" + infix + "_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->week->caption(), $material_required_issue_fp->week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->buyer_id->caption(), $material_required_issue_fp->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->grp->caption(), $material_required_issue_fp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->s_grp->caption(), $material_required_issue_fp->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->product->caption(), $material_required_issue_fp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->product_id->Required) { ?>
			elm = this.getElements("x" + infix + "_product_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->product_id->caption(), $material_required_issue_fp->product_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->batch_no->caption(), $material_required_issue_fp->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->quantity->caption(), $material_required_issue_fp->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->req_material_sgrp->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_sgrp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->req_material_sgrp->caption(), $material_required_issue_fp->req_material_sgrp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->issue_material_sgrp->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_sgrp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->issue_material_sgrp->caption(), $material_required_issue_fp->issue_material_sgrp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->req_material_product->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->req_material_product->caption(), $material_required_issue_fp->req_material_product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->issue_material_product->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->issue_material_product->caption(), $material_required_issue_fp->issue_material_product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->req_material_rid->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->req_material_rid->caption(), $material_required_issue_fp->req_material_rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->issue_material_id->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->issue_material_id->caption(), $material_required_issue_fp->issue_material_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->req_material_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->req_material_qty->caption(), $material_required_issue_fp->req_material_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->issue_material_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->issue_material_qty->caption(), $material_required_issue_fp->issue_material_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_issue_material_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->issue_material_qty->errorMessage()) ?>");
		<?php if ($material_required_issue_fp_edit->material_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_material_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->material_qty->caption(), $material_required_issue_fp->material_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->unit->caption(), $material_required_issue_fp->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->method->Required) { ?>
			elm = this.getElements("x" + infix + "_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->method->caption(), $material_required_issue_fp->method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->despatch_week->caption(), $material_required_issue_fp->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->despatch_date->caption(), $material_required_issue_fp->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->despatch_date->errorMessage()) ?>");
		<?php if ($material_required_issue_fp_edit->production_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->production_plan->caption(), $material_required_issue_fp->production_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->operator->caption(), $material_required_issue_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->datetime->caption(), $material_required_issue_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->material_out->Required) { ?>
			elm = this.getElements("x" + infix + "_material_out");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->material_out->caption(), $material_required_issue_fp->material_out->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_issue_fp_edit->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_issue_fp->issue_to->caption(), $material_required_issue_fp->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmaterial_required_issue_fpedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_issue_fpedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_issue_fpedit.lists["x_jc_no"] = <?php echo $material_required_issue_fp_edit->jc_no->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_jc_no"].options = <?php echo JsonEncode($material_required_issue_fp_edit->jc_no->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_week"] = <?php echo $material_required_issue_fp_edit->week->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_week"].options = <?php echo JsonEncode($material_required_issue_fp_edit->week->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_buyer_id"] = <?php echo $material_required_issue_fp_edit->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_issue_fp_edit->buyer_id->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_grp"] = <?php echo $material_required_issue_fp_edit->grp->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_grp"].options = <?php echo JsonEncode($material_required_issue_fp_edit->grp->options(FALSE, TRUE)) ?>;
fmaterial_required_issue_fpedit.lists["x_s_grp"] = <?php echo $material_required_issue_fp_edit->s_grp->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_s_grp"].options = <?php echo JsonEncode($material_required_issue_fp_edit->s_grp->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_product"] = <?php echo $material_required_issue_fp_edit->product->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_product"].options = <?php echo JsonEncode($material_required_issue_fp_edit->product->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_product_id"] = <?php echo $material_required_issue_fp_edit->product_id->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_product_id"].options = <?php echo JsonEncode($material_required_issue_fp_edit->product_id->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_req_material_sgrp"] = <?php echo $material_required_issue_fp_edit->req_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_req_material_sgrp"].options = <?php echo JsonEncode($material_required_issue_fp_edit->req_material_sgrp->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_issue_material_sgrp"] = <?php echo $material_required_issue_fp_edit->issue_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_issue_material_sgrp"].options = <?php echo JsonEncode($material_required_issue_fp_edit->issue_material_sgrp->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_req_material_product"] = <?php echo $material_required_issue_fp_edit->req_material_product->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_req_material_product"].options = <?php echo JsonEncode($material_required_issue_fp_edit->req_material_product->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_issue_material_product"] = <?php echo $material_required_issue_fp_edit->issue_material_product->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_issue_material_product"].options = <?php echo JsonEncode($material_required_issue_fp_edit->issue_material_product->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_req_material_rid"] = <?php echo $material_required_issue_fp_edit->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_issue_fp_edit->req_material_rid->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_unit"] = <?php echo $material_required_issue_fp_edit->unit->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_unit"].options = <?php echo JsonEncode($material_required_issue_fp_edit->unit->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_method"] = <?php echo $material_required_issue_fp_edit->method->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_method"].options = <?php echo JsonEncode($material_required_issue_fp_edit->method->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_despatch_week"] = <?php echo $material_required_issue_fp_edit->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_issue_fp_edit->despatch_week->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_production_plan"] = <?php echo $material_required_issue_fp_edit->production_plan->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_production_plan"].options = <?php echo JsonEncode($material_required_issue_fp_edit->production_plan->options(FALSE, TRUE)) ?>;
fmaterial_required_issue_fpedit.lists["x_operator"] = <?php echo $material_required_issue_fp_edit->operator->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_operator"].options = <?php echo JsonEncode($material_required_issue_fp_edit->operator->lookupOptions()) ?>;
fmaterial_required_issue_fpedit.lists["x_material_out"] = <?php echo $material_required_issue_fp_edit->material_out->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_material_out"].options = <?php echo JsonEncode($material_required_issue_fp_edit->material_out->options(FALSE, TRUE)) ?>;
fmaterial_required_issue_fpedit.lists["x_issue_to"] = <?php echo $material_required_issue_fp_edit->issue_to->Lookup->toClientList() ?>;
fmaterial_required_issue_fpedit.lists["x_issue_to"].options = <?php echo JsonEncode($material_required_issue_fp_edit->issue_to->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_required_issue_fp_edit->showPageHeader(); ?>
<?php
$material_required_issue_fp_edit->showMessage();
?>
<form name="fmaterial_required_issue_fpedit" id="fmaterial_required_issue_fpedit" class="<?php echo $material_required_issue_fp_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_issue_fp_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_issue_fp_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_issue_fp">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$material_required_issue_fp_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($material_required_issue_fp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_material_required_issue_fp_id" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->id->caption() ?><?php echo ($material_required_issue_fp->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->id->cellAttributes() ?>>
<span id="el_material_required_issue_fp_id">
<span<?php echo $material_required_issue_fp->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($material_required_issue_fp->id->CurrentValue) ?>">
<?php echo $material_required_issue_fp->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_material_required_issue_fp_jc_no" for="x_jc_no" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->jc_no->caption() ?><?php echo ($material_required_issue_fp->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->jc_no->cellAttributes() ?>>
<span id="el_material_required_issue_fp_jc_no">
<span<?php echo $material_required_issue_fp->jc_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->jc_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" value="<?php echo HtmlEncode($material_required_issue_fp->jc_no->CurrentValue) ?>">
<?php echo $material_required_issue_fp->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_material_required_issue_fp_po" for="x_po" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->po->caption() ?><?php echo ($material_required_issue_fp->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->po->cellAttributes() ?>>
<span id="el_material_required_issue_fp_po">
<span<?php echo $material_required_issue_fp->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_po" name="x_po" id="x_po" value="<?php echo HtmlEncode($material_required_issue_fp->po->CurrentValue) ?>">
<?php echo $material_required_issue_fp->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->week->Visible) { // week ?>
	<div id="r_week" class="form-group row">
		<label id="elh_material_required_issue_fp_week" for="x_week" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->week->caption() ?><?php echo ($material_required_issue_fp->week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->week->cellAttributes() ?>>
<span id="el_material_required_issue_fp_week">
<span<?php echo $material_required_issue_fp->week->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->week->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_week" name="x_week" id="x_week" value="<?php echo HtmlEncode($material_required_issue_fp->week->CurrentValue) ?>">
<?php echo $material_required_issue_fp->week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_material_required_issue_fp_buyer_id" for="x_buyer_id" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->buyer_id->caption() ?><?php echo ($material_required_issue_fp->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->buyer_id->cellAttributes() ?>>
<span id="el_material_required_issue_fp_buyer_id">
<span<?php echo $material_required_issue_fp->buyer_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->buyer_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($material_required_issue_fp->buyer_id->CurrentValue) ?>">
<?php echo $material_required_issue_fp->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_material_required_issue_fp_grp" for="x_grp" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->grp->caption() ?><?php echo ($material_required_issue_fp->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->grp->cellAttributes() ?>>
<span id="el_material_required_issue_fp_grp">
<span<?php echo $material_required_issue_fp->grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_grp" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($material_required_issue_fp->grp->CurrentValue) ?>">
<?php echo $material_required_issue_fp->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_material_required_issue_fp_s_grp" for="x_s_grp" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->s_grp->caption() ?><?php echo ($material_required_issue_fp->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->s_grp->cellAttributes() ?>>
<span id="el_material_required_issue_fp_s_grp">
<span<?php echo $material_required_issue_fp->s_grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->s_grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($material_required_issue_fp->s_grp->CurrentValue) ?>">
<?php echo $material_required_issue_fp->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_material_required_issue_fp_product" for="x_product" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->product->caption() ?><?php echo ($material_required_issue_fp->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->product->cellAttributes() ?>>
<span id="el_material_required_issue_fp_product">
<span<?php echo $material_required_issue_fp->product->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->product->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_product" name="x_product" id="x_product" value="<?php echo HtmlEncode($material_required_issue_fp->product->CurrentValue) ?>">
<?php echo $material_required_issue_fp->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->product_id->Visible) { // product_id ?>
	<div id="r_product_id" class="form-group row">
		<label id="elh_material_required_issue_fp_product_id" for="x_product_id" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->product_id->caption() ?><?php echo ($material_required_issue_fp->product_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->product_id->cellAttributes() ?>>
<span id="el_material_required_issue_fp_product_id">
<span<?php echo $material_required_issue_fp->product_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->product_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_product_id" name="x_product_id" id="x_product_id" value="<?php echo HtmlEncode($material_required_issue_fp->product_id->CurrentValue) ?>">
<?php echo $material_required_issue_fp->product_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_material_required_issue_fp_batch_no" for="x_batch_no" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->batch_no->caption() ?><?php echo ($material_required_issue_fp->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->batch_no->cellAttributes() ?>>
<span id="el_material_required_issue_fp_batch_no">
<span<?php echo $material_required_issue_fp->batch_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->batch_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" value="<?php echo HtmlEncode($material_required_issue_fp->batch_no->CurrentValue) ?>">
<?php echo $material_required_issue_fp->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_material_required_issue_fp_quantity" for="x_quantity" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->quantity->caption() ?><?php echo ($material_required_issue_fp->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->quantity->cellAttributes() ?>>
<span id="el_material_required_issue_fp_quantity">
<span<?php echo $material_required_issue_fp->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->quantity->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_quantity" name="x_quantity" id="x_quantity" value="<?php echo HtmlEncode($material_required_issue_fp->quantity->CurrentValue) ?>">
<?php echo $material_required_issue_fp->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<div id="r_req_material_sgrp" class="form-group row">
		<label id="elh_material_required_issue_fp_req_material_sgrp" for="x_req_material_sgrp" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->req_material_sgrp->caption() ?><?php echo ($material_required_issue_fp->req_material_sgrp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->req_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_issue_fp_req_material_sgrp">
<span<?php echo $material_required_issue_fp->req_material_sgrp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->req_material_sgrp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_req_material_sgrp" name="x_req_material_sgrp" id="x_req_material_sgrp" value="<?php echo HtmlEncode($material_required_issue_fp->req_material_sgrp->CurrentValue) ?>">
<?php echo $material_required_issue_fp->req_material_sgrp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->issue_material_sgrp->Visible) { // issue_material_sgrp ?>
	<div id="r_issue_material_sgrp" class="form-group row">
		<label id="elh_material_required_issue_fp_issue_material_sgrp" for="x_issue_material_sgrp" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->issue_material_sgrp->caption() ?><?php echo ($material_required_issue_fp->issue_material_sgrp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->issue_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_issue_fp_issue_material_sgrp">
<?php $material_required_issue_fp->issue_material_sgrp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_issue_fp->issue_material_sgrp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_issue_material_sgrp" data-value-separator="<?php echo $material_required_issue_fp->issue_material_sgrp->displayValueSeparatorAttribute() ?>" id="x_issue_material_sgrp" name="x_issue_material_sgrp"<?php echo $material_required_issue_fp->issue_material_sgrp->editAttributes() ?>>
		<?php echo $material_required_issue_fp->issue_material_sgrp->selectOptionListHtml("x_issue_material_sgrp") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->issue_material_sgrp->Lookup->getParamTag("p_x_issue_material_sgrp") ?>
</span>
<?php echo $material_required_issue_fp->issue_material_sgrp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_product->Visible) { // req_material_product ?>
	<div id="r_req_material_product" class="form-group row">
		<label id="elh_material_required_issue_fp_req_material_product" for="x_req_material_product" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->req_material_product->caption() ?><?php echo ($material_required_issue_fp->req_material_product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->req_material_product->cellAttributes() ?>>
<span id="el_material_required_issue_fp_req_material_product">
<span<?php echo $material_required_issue_fp->req_material_product->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->req_material_product->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_req_material_product" name="x_req_material_product" id="x_req_material_product" value="<?php echo HtmlEncode($material_required_issue_fp->req_material_product->CurrentValue) ?>">
<?php echo $material_required_issue_fp->req_material_product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->issue_material_product->Visible) { // issue_material_product ?>
	<div id="r_issue_material_product" class="form-group row">
		<label id="elh_material_required_issue_fp_issue_material_product" for="x_issue_material_product" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->issue_material_product->caption() ?><?php echo ($material_required_issue_fp->issue_material_product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->issue_material_product->cellAttributes() ?>>
<span id="el_material_required_issue_fp_issue_material_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_issue_material_product" data-value-separator="<?php echo $material_required_issue_fp->issue_material_product->displayValueSeparatorAttribute() ?>" id="x_issue_material_product" name="x_issue_material_product"<?php echo $material_required_issue_fp->issue_material_product->editAttributes() ?>>
		<?php echo $material_required_issue_fp->issue_material_product->selectOptionListHtml("x_issue_material_product") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->issue_material_product->Lookup->getParamTag("p_x_issue_material_product") ?>
</span>
<?php echo $material_required_issue_fp->issue_material_product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_rid->Visible) { // req_material_rid ?>
	<div id="r_req_material_rid" class="form-group row">
		<label id="elh_material_required_issue_fp_req_material_rid" for="x_req_material_rid" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->req_material_rid->caption() ?><?php echo ($material_required_issue_fp->req_material_rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->req_material_rid->cellAttributes() ?>>
<span id="el_material_required_issue_fp_req_material_rid">
<span<?php echo $material_required_issue_fp->req_material_rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->req_material_rid->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" value="<?php echo HtmlEncode($material_required_issue_fp->req_material_rid->CurrentValue) ?>">
<?php echo $material_required_issue_fp->req_material_rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->issue_material_id->Visible) { // issue_material_id ?>
	<div id="r_issue_material_id" class="form-group row">
		<label id="elh_material_required_issue_fp_issue_material_id" for="x_issue_material_id" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->issue_material_id->caption() ?><?php echo ($material_required_issue_fp->issue_material_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->issue_material_id->cellAttributes() ?>>
<span id="el_material_required_issue_fp_issue_material_id">
<input type="text" data-table="material_required_issue_fp" data-field="x_issue_material_id" name="x_issue_material_id" id="x_issue_material_id" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($material_required_issue_fp->issue_material_id->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->issue_material_id->EditValue ?>"<?php echo $material_required_issue_fp->issue_material_id->editAttributes() ?>>
</span>
<?php echo $material_required_issue_fp->issue_material_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_qty->Visible) { // req_material_qty ?>
	<div id="r_req_material_qty" class="form-group row">
		<label id="elh_material_required_issue_fp_req_material_qty" for="x_req_material_qty" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->req_material_qty->caption() ?><?php echo ($material_required_issue_fp->req_material_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->req_material_qty->cellAttributes() ?>>
<span id="el_material_required_issue_fp_req_material_qty">
<span<?php echo $material_required_issue_fp->req_material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->req_material_qty->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_req_material_qty" name="x_req_material_qty" id="x_req_material_qty" value="<?php echo HtmlEncode($material_required_issue_fp->req_material_qty->CurrentValue) ?>">
<?php echo $material_required_issue_fp->req_material_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->issue_material_qty->Visible) { // issue_material_qty ?>
	<div id="r_issue_material_qty" class="form-group row">
		<label id="elh_material_required_issue_fp_issue_material_qty" for="x_issue_material_qty" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->issue_material_qty->caption() ?><?php echo ($material_required_issue_fp->issue_material_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->issue_material_qty->cellAttributes() ?>>
<span id="el_material_required_issue_fp_issue_material_qty">
<input type="text" data-table="material_required_issue_fp" data-field="x_issue_material_qty" name="x_issue_material_qty" id="x_issue_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->issue_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->issue_material_qty->EditValue ?>"<?php echo $material_required_issue_fp->issue_material_qty->editAttributes() ?>>
</span>
<?php echo $material_required_issue_fp->issue_material_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->material_qty->Visible) { // material_qty ?>
	<div id="r_material_qty" class="form-group row">
		<label id="elh_material_required_issue_fp_material_qty" for="x_material_qty" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->material_qty->caption() ?><?php echo ($material_required_issue_fp->material_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->material_qty->cellAttributes() ?>>
<span id="el_material_required_issue_fp_material_qty">
<span<?php echo $material_required_issue_fp->material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->material_qty->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_material_qty" name="x_material_qty" id="x_material_qty" value="<?php echo HtmlEncode($material_required_issue_fp->material_qty->CurrentValue) ?>">
<?php echo $material_required_issue_fp->material_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label id="elh_material_required_issue_fp_unit" for="x_unit" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->unit->caption() ?><?php echo ($material_required_issue_fp->unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->unit->cellAttributes() ?>>
<span id="el_material_required_issue_fp_unit">
<span<?php echo $material_required_issue_fp->unit->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->unit->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_unit" name="x_unit" id="x_unit" value="<?php echo HtmlEncode($material_required_issue_fp->unit->CurrentValue) ?>">
<?php echo $material_required_issue_fp->unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label id="elh_material_required_issue_fp_method" for="x_method" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->method->caption() ?><?php echo ($material_required_issue_fp->method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->method->cellAttributes() ?>>
<span id="el_material_required_issue_fp_method">
<span<?php echo $material_required_issue_fp->method->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->method->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_method" name="x_method" id="x_method" value="<?php echo HtmlEncode($material_required_issue_fp->method->CurrentValue) ?>">
<?php echo $material_required_issue_fp->method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_material_required_issue_fp_despatch_week" for="x_despatch_week" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->despatch_week->caption() ?><?php echo ($material_required_issue_fp->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->despatch_week->cellAttributes() ?>>
<span id="el_material_required_issue_fp_despatch_week">
<span<?php echo $material_required_issue_fp->despatch_week->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->despatch_week->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_despatch_week" name="x_despatch_week" id="x_despatch_week" value="<?php echo HtmlEncode($material_required_issue_fp->despatch_week->CurrentValue) ?>">
<?php echo $material_required_issue_fp->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_material_required_issue_fp_despatch_date" for="x_despatch_date" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->despatch_date->caption() ?><?php echo ($material_required_issue_fp->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->despatch_date->cellAttributes() ?>>
<span id="el_material_required_issue_fp_despatch_date">
<input type="text" data-table="material_required_issue_fp" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($material_required_issue_fp->despatch_date->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->despatch_date->EditValue ?>"<?php echo $material_required_issue_fp->despatch_date->editAttributes() ?>>
<?php if (!$material_required_issue_fp->despatch_date->ReadOnly && !$material_required_issue_fp->despatch_date->Disabled && !isset($material_required_issue_fp->despatch_date->EditAttrs["readonly"]) && !isset($material_required_issue_fp->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_issue_fpedit", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_required_issue_fp->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label id="elh_material_required_issue_fp_production_plan" for="x_production_plan" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->production_plan->caption() ?><?php echo ($material_required_issue_fp->production_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->production_plan->cellAttributes() ?>>
<span id="el_material_required_issue_fp_production_plan">
<span<?php echo $material_required_issue_fp->production_plan->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->production_plan->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_production_plan" name="x_production_plan" id="x_production_plan" value="<?php echo HtmlEncode($material_required_issue_fp->production_plan->CurrentValue) ?>">
<?php echo $material_required_issue_fp->production_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->material_out->Visible) { // material_out ?>
	<div id="r_material_out" class="form-group row">
		<label id="elh_material_required_issue_fp_material_out" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->material_out->caption() ?><?php echo ($material_required_issue_fp->material_out->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->material_out->cellAttributes() ?>>
<span id="el_material_required_issue_fp_material_out">
<div id="tp_x_material_out" class="ew-template"><input type="radio" class="form-check-input" data-table="material_required_issue_fp" data-field="x_material_out" data-value-separator="<?php echo $material_required_issue_fp->material_out->displayValueSeparatorAttribute() ?>" name="x_material_out" id="x_material_out" value="{value}"<?php echo $material_required_issue_fp->material_out->editAttributes() ?>></div>
<div id="dsl_x_material_out" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_required_issue_fp->material_out->radioButtonListHtml(FALSE, "x_material_out") ?>
</div></div>
</span>
<?php echo $material_required_issue_fp->material_out->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_material_required_issue_fp_issue_to" for="x_issue_to" class="<?php echo $material_required_issue_fp_edit->LeftColumnClass ?>"><?php echo $material_required_issue_fp->issue_to->caption() ?><?php echo ($material_required_issue_fp->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_issue_fp_edit->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->issue_to->cellAttributes() ?>>
<span id="el_material_required_issue_fp_issue_to">
<span<?php echo $material_required_issue_fp->issue_to->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_issue_fp->issue_to->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_issue_fp" data-field="x_issue_to" name="x_issue_to" id="x_issue_to" value="<?php echo HtmlEncode($material_required_issue_fp->issue_to->CurrentValue) ?>">
<?php echo $material_required_issue_fp->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_required_issue_fp_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_required_issue_fp_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $material_required_issue_fp_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_required_issue_fp_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_required_issue_fp_edit->terminate();
?>