<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_issue_fp_list = new material_required_issue_fp_list();

// Run the page
$material_required_issue_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_issue_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_required_issue_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_required_issue_fplist = currentForm = new ew.Form("fmaterial_required_issue_fplist", "list");
fmaterial_required_issue_fplist.formKeyCountName = '<?php echo $material_required_issue_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_required_issue_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_issue_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_issue_fplist.lists["x_jc_no"] = <?php echo $material_required_issue_fp_list->jc_no->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_jc_no"].options = <?php echo JsonEncode($material_required_issue_fp_list->jc_no->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_week"] = <?php echo $material_required_issue_fp_list->week->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_week"].options = <?php echo JsonEncode($material_required_issue_fp_list->week->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_buyer_id"] = <?php echo $material_required_issue_fp_list->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_issue_fp_list->buyer_id->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_product"] = <?php echo $material_required_issue_fp_list->product->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_product"].options = <?php echo JsonEncode($material_required_issue_fp_list->product->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_product_id"] = <?php echo $material_required_issue_fp_list->product_id->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_product_id"].options = <?php echo JsonEncode($material_required_issue_fp_list->product_id->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_req_material_sgrp"] = <?php echo $material_required_issue_fp_list->req_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_req_material_sgrp"].options = <?php echo JsonEncode($material_required_issue_fp_list->req_material_sgrp->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_req_material_product"] = <?php echo $material_required_issue_fp_list->req_material_product->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_req_material_product"].options = <?php echo JsonEncode($material_required_issue_fp_list->req_material_product->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_req_material_rid"] = <?php echo $material_required_issue_fp_list->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_issue_fp_list->req_material_rid->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_unit"] = <?php echo $material_required_issue_fp_list->unit->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_unit"].options = <?php echo JsonEncode($material_required_issue_fp_list->unit->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_method"] = <?php echo $material_required_issue_fp_list->method->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_method"].options = <?php echo JsonEncode($material_required_issue_fp_list->method->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_despatch_week"] = <?php echo $material_required_issue_fp_list->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_issue_fp_list->despatch_week->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_production_plan"] = <?php echo $material_required_issue_fp_list->production_plan->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_production_plan"].options = <?php echo JsonEncode($material_required_issue_fp_list->production_plan->options(FALSE, TRUE)) ?>;
fmaterial_required_issue_fplist.lists["x_operator"] = <?php echo $material_required_issue_fp_list->operator->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_operator"].options = <?php echo JsonEncode($material_required_issue_fp_list->operator->lookupOptions()) ?>;
fmaterial_required_issue_fplist.lists["x_material_out"] = <?php echo $material_required_issue_fp_list->material_out->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_material_out"].options = <?php echo JsonEncode($material_required_issue_fp_list->material_out->options(FALSE, TRUE)) ?>;
fmaterial_required_issue_fplist.lists["x_material_out_id"] = <?php echo $material_required_issue_fp_list->material_out_id->Lookup->toClientList() ?>;
fmaterial_required_issue_fplist.lists["x_material_out_id"].options = <?php echo JsonEncode($material_required_issue_fp_list->material_out_id->lookupOptions()) ?>;

// Form object for search
var fmaterial_required_issue_fplistsrch = currentSearchForm = new ew.Form("fmaterial_required_issue_fplistsrch");

// Validate function for search
fmaterial_required_issue_fplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_issue_material_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->issue_material_rid->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_required_issue_fplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_issue_fplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fmaterial_required_issue_fplistsrch.filterList = <?php echo $material_required_issue_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_required_issue_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_required_issue_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_required_issue_fp_list->TotalRecs > 0 && $material_required_issue_fp_list->ExportOptions->visible()) { ?>
<?php $material_required_issue_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_issue_fp_list->ImportOptions->visible()) { ?>
<?php $material_required_issue_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_issue_fp_list->SearchOptions->visible()) { ?>
<?php $material_required_issue_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_issue_fp_list->FilterOptions->visible()) { ?>
<?php $material_required_issue_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_required_issue_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_required_issue_fp->isExport() && !$material_required_issue_fp->CurrentAction) { ?>
<form name="fmaterial_required_issue_fplistsrch" id="fmaterial_required_issue_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_required_issue_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_required_issue_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_required_issue_fp">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_required_issue_fp_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_required_issue_fp->RowType = ROWTYPE_SEARCH;

// Render row
$material_required_issue_fp->resetAttributes();
$material_required_issue_fp_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_required_issue_fp->issue_material_rid->Visible) { // issue_material_rid ?>
	<div id="xsc_issue_material_rid" class="ew-cell form-group">
		<label for="x_issue_material_rid" class="ew-search-caption ew-label"><?php echo $material_required_issue_fp->issue_material_rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_rid" id="z_issue_material_rid" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required_issue_fp" data-field="x_issue_material_rid" name="x_issue_material_rid" id="x_issue_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->issue_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->issue_material_rid->EditValue ?>"<?php echo $material_required_issue_fp->issue_material_rid->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_required_issue_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_required_issue_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_required_issue_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_required_issue_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_required_issue_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_required_issue_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_required_issue_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_required_issue_fp_list->showPageHeader(); ?>
<?php
$material_required_issue_fp_list->showMessage();
?>
<?php if ($material_required_issue_fp_list->TotalRecs > 0 || $material_required_issue_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_required_issue_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_required_issue_fp">
<?php if (!$material_required_issue_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_required_issue_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_issue_fp_list->Pager)) $material_required_issue_fp_list->Pager = new PrevNextPager($material_required_issue_fp_list->StartRec, $material_required_issue_fp_list->DisplayRecs, $material_required_issue_fp_list->TotalRecs, $material_required_issue_fp_list->AutoHidePager) ?>
<?php if ($material_required_issue_fp_list->Pager->RecordCount > 0 && $material_required_issue_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_issue_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_issue_fp_list->pageUrl() ?>start=<?php echo $material_required_issue_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_issue_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_issue_fp_list->pageUrl() ?>start=<?php echo $material_required_issue_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_issue_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_issue_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_issue_fp_list->pageUrl() ?>start=<?php echo $material_required_issue_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_issue_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_issue_fp_list->pageUrl() ?>start=<?php echo $material_required_issue_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_issue_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_issue_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_issue_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_issue_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_issue_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_issue_fp_list->TotalRecs > 0 && (!$material_required_issue_fp_list->AutoHidePageSizeSelector || $material_required_issue_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_issue_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_issue_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_issue_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_issue_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_issue_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_issue_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_issue_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_issue_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_required_issue_fplist" id="fmaterial_required_issue_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_issue_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_issue_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_issue_fp">
<div id="gmp_material_required_issue_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_required_issue_fp_list->TotalRecs > 0 || $material_required_issue_fp->isGridEdit()) { ?>
<table id="tbl_material_required_issue_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_required_issue_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_required_issue_fp_list->renderListOptions();

// Render list options (header, left)
$material_required_issue_fp_list->ListOptions->render("header", "left");
?>
<?php if ($material_required_issue_fp->id->Visible) { // id ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_required_issue_fp->id->headerCellClass() ?>"><div id="elh_material_required_issue_fp_id" class="material_required_issue_fp_id"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_required_issue_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->id) ?>',2);"><div id="elh_material_required_issue_fp_id" class="material_required_issue_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->jc_no->Visible) { // jc_no ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $material_required_issue_fp->jc_no->headerCellClass() ?>"><div id="elh_material_required_issue_fp_jc_no" class="material_required_issue_fp_jc_no"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $material_required_issue_fp->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->jc_no) ?>',2);"><div id="elh_material_required_issue_fp_jc_no" class="material_required_issue_fp_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->po->Visible) { // po ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->po) == "") { ?>
		<th data-name="po" class="<?php echo $material_required_issue_fp->po->headerCellClass() ?>"><div id="elh_material_required_issue_fp_po" class="material_required_issue_fp_po"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $material_required_issue_fp->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->po) ?>',2);"><div id="elh_material_required_issue_fp_po" class="material_required_issue_fp_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->week->Visible) { // week ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->week) == "") { ?>
		<th data-name="week" class="<?php echo $material_required_issue_fp->week->headerCellClass() ?>"><div id="elh_material_required_issue_fp_week" class="material_required_issue_fp_week"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $material_required_issue_fp->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->week) ?>',2);"><div id="elh_material_required_issue_fp_week" class="material_required_issue_fp_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->buyer_id->Visible) { // buyer_id ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_issue_fp->buyer_id->headerCellClass() ?>"><div id="elh_material_required_issue_fp_buyer_id" class="material_required_issue_fp_buyer_id"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_issue_fp->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->buyer_id) ?>',2);"><div id="elh_material_required_issue_fp_buyer_id" class="material_required_issue_fp_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->product->Visible) { // product ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->product) == "") { ?>
		<th data-name="product" class="<?php echo $material_required_issue_fp->product->headerCellClass() ?>"><div id="elh_material_required_issue_fp_product" class="material_required_issue_fp_product"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $material_required_issue_fp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->product) ?>',2);"><div id="elh_material_required_issue_fp_product" class="material_required_issue_fp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->product_id->Visible) { // product_id ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->product_id) == "") { ?>
		<th data-name="product_id" class="<?php echo $material_required_issue_fp->product_id->headerCellClass() ?>"><div id="elh_material_required_issue_fp_product_id" class="material_required_issue_fp_product_id"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->product_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_id" class="<?php echo $material_required_issue_fp->product_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->product_id) ?>',2);"><div id="elh_material_required_issue_fp_product_id" class="material_required_issue_fp_product_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->product_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->product_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->product_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->batch_no->Visible) { // batch_no ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $material_required_issue_fp->batch_no->headerCellClass() ?>"><div id="elh_material_required_issue_fp_batch_no" class="material_required_issue_fp_batch_no"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $material_required_issue_fp->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->batch_no) ?>',2);"><div id="elh_material_required_issue_fp_batch_no" class="material_required_issue_fp_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->quantity->Visible) { // quantity ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_required_issue_fp->quantity->headerCellClass() ?>"><div id="elh_material_required_issue_fp_quantity" class="material_required_issue_fp_quantity"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_required_issue_fp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->quantity) ?>',2);"><div id="elh_material_required_issue_fp_quantity" class="material_required_issue_fp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->req_material_sgrp) == "") { ?>
		<th data-name="req_material_sgrp" class="<?php echo $material_required_issue_fp->req_material_sgrp->headerCellClass() ?>"><div id="elh_material_required_issue_fp_req_material_sgrp" class="material_required_issue_fp_req_material_sgrp"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->req_material_sgrp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_sgrp" class="<?php echo $material_required_issue_fp->req_material_sgrp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->req_material_sgrp) ?>',2);"><div id="elh_material_required_issue_fp_req_material_sgrp" class="material_required_issue_fp_req_material_sgrp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->req_material_sgrp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->req_material_sgrp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->req_material_sgrp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_product->Visible) { // req_material_product ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->req_material_product) == "") { ?>
		<th data-name="req_material_product" class="<?php echo $material_required_issue_fp->req_material_product->headerCellClass() ?>"><div id="elh_material_required_issue_fp_req_material_product" class="material_required_issue_fp_req_material_product"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->req_material_product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_product" class="<?php echo $material_required_issue_fp->req_material_product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->req_material_product) ?>',2);"><div id="elh_material_required_issue_fp_req_material_product" class="material_required_issue_fp_req_material_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->req_material_product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->req_material_product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->req_material_product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_issue_fp->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_issue_fp_req_material_rid" class="material_required_issue_fp_req_material_rid"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_issue_fp->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->req_material_rid) ?>',2);"><div id="elh_material_required_issue_fp_req_material_rid" class="material_required_issue_fp_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->issue_material_rid->Visible) { // issue_material_rid ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->issue_material_rid) == "") { ?>
		<th data-name="issue_material_rid" class="<?php echo $material_required_issue_fp->issue_material_rid->headerCellClass() ?>"><div id="elh_material_required_issue_fp_issue_material_rid" class="material_required_issue_fp_issue_material_rid"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->issue_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_material_rid" class="<?php echo $material_required_issue_fp->issue_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->issue_material_rid) ?>',2);"><div id="elh_material_required_issue_fp_issue_material_rid" class="material_required_issue_fp_issue_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->issue_material_rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->issue_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->issue_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_issue_fp->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_issue_fp_req_material_qty" class="material_required_issue_fp_req_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_issue_fp->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->req_material_qty) ?>',2);"><div id="elh_material_required_issue_fp_req_material_qty" class="material_required_issue_fp_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->req_material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->material_qty->Visible) { // material_qty ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->material_qty) == "") { ?>
		<th data-name="material_qty" class="<?php echo $material_required_issue_fp->material_qty->headerCellClass() ?>"><div id="elh_material_required_issue_fp_material_qty" class="material_required_issue_fp_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_qty" class="<?php echo $material_required_issue_fp->material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->material_qty) ?>',2);"><div id="elh_material_required_issue_fp_material_qty" class="material_required_issue_fp_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->unit->Visible) { // unit ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $material_required_issue_fp->unit->headerCellClass() ?>"><div id="elh_material_required_issue_fp_unit" class="material_required_issue_fp_unit"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $material_required_issue_fp->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->unit) ?>',2);"><div id="elh_material_required_issue_fp_unit" class="material_required_issue_fp_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->method->Visible) { // method ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->method) == "") { ?>
		<th data-name="method" class="<?php echo $material_required_issue_fp->method->headerCellClass() ?>"><div id="elh_material_required_issue_fp_method" class="material_required_issue_fp_method"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $material_required_issue_fp->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->method) ?>',2);"><div id="elh_material_required_issue_fp_method" class="material_required_issue_fp_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->despatch_week->Visible) { // despatch_week ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_issue_fp->despatch_week->headerCellClass() ?>"><div id="elh_material_required_issue_fp_despatch_week" class="material_required_issue_fp_despatch_week"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_issue_fp->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->despatch_week) ?>',2);"><div id="elh_material_required_issue_fp_despatch_week" class="material_required_issue_fp_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->despatch_date->Visible) { // despatch_date ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_issue_fp->despatch_date->headerCellClass() ?>"><div id="elh_material_required_issue_fp_despatch_date" class="material_required_issue_fp_despatch_date"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_issue_fp->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->despatch_date) ?>',2);"><div id="elh_material_required_issue_fp_despatch_date" class="material_required_issue_fp_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->production_plan->Visible) { // production_plan ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->production_plan) == "") { ?>
		<th data-name="production_plan" class="<?php echo $material_required_issue_fp->production_plan->headerCellClass() ?>"><div id="elh_material_required_issue_fp_production_plan" class="material_required_issue_fp_production_plan"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->production_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_plan" class="<?php echo $material_required_issue_fp->production_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->production_plan) ?>',2);"><div id="elh_material_required_issue_fp_production_plan" class="material_required_issue_fp_production_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->production_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->production_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->production_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->operator->Visible) { // operator ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_required_issue_fp->operator->headerCellClass() ?>"><div id="elh_material_required_issue_fp_operator" class="material_required_issue_fp_operator"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_required_issue_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->operator) ?>',2);"><div id="elh_material_required_issue_fp_operator" class="material_required_issue_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->datetime->Visible) { // datetime ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $material_required_issue_fp->datetime->headerCellClass() ?>"><div id="elh_material_required_issue_fp_datetime" class="material_required_issue_fp_datetime"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $material_required_issue_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->datetime) ?>',2);"><div id="elh_material_required_issue_fp_datetime" class="material_required_issue_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->material_out->Visible) { // material_out ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->material_out) == "") { ?>
		<th data-name="material_out" class="<?php echo $material_required_issue_fp->material_out->headerCellClass() ?>"><div id="elh_material_required_issue_fp_material_out" class="material_required_issue_fp_material_out"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->material_out->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_out" class="<?php echo $material_required_issue_fp->material_out->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->material_out) ?>',2);"><div id="elh_material_required_issue_fp_material_out" class="material_required_issue_fp_material_out">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->material_out->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->material_out->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->material_out->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue_fp->material_out_id->Visible) { // material_out_id ?>
	<?php if ($material_required_issue_fp->sortUrl($material_required_issue_fp->material_out_id) == "") { ?>
		<th data-name="material_out_id" class="<?php echo $material_required_issue_fp->material_out_id->headerCellClass() ?>"><div id="elh_material_required_issue_fp_material_out_id" class="material_required_issue_fp_material_out_id"><div class="ew-table-header-caption"><?php echo $material_required_issue_fp->material_out_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_out_id" class="<?php echo $material_required_issue_fp->material_out_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue_fp->SortUrl($material_required_issue_fp->material_out_id) ?>',2);"><div id="elh_material_required_issue_fp_material_out_id" class="material_required_issue_fp_material_out_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue_fp->material_out_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue_fp->material_out_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue_fp->material_out_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_issue_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_required_issue_fp->ExportAll && $material_required_issue_fp->isExport()) {
	$material_required_issue_fp_list->StopRec = $material_required_issue_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_required_issue_fp_list->TotalRecs > $material_required_issue_fp_list->StartRec + $material_required_issue_fp_list->DisplayRecs - 1)
		$material_required_issue_fp_list->StopRec = $material_required_issue_fp_list->StartRec + $material_required_issue_fp_list->DisplayRecs - 1;
	else
		$material_required_issue_fp_list->StopRec = $material_required_issue_fp_list->TotalRecs;
}
$material_required_issue_fp_list->RecCnt = $material_required_issue_fp_list->StartRec - 1;
if ($material_required_issue_fp_list->Recordset && !$material_required_issue_fp_list->Recordset->EOF) {
	$material_required_issue_fp_list->Recordset->moveFirst();
	$selectLimit = $material_required_issue_fp_list->UseSelectLimit;
	if (!$selectLimit && $material_required_issue_fp_list->StartRec > 1)
		$material_required_issue_fp_list->Recordset->move($material_required_issue_fp_list->StartRec - 1);
} elseif (!$material_required_issue_fp->AllowAddDeleteRow && $material_required_issue_fp_list->StopRec == 0) {
	$material_required_issue_fp_list->StopRec = $material_required_issue_fp->GridAddRowCount;
}

// Initialize aggregate
$material_required_issue_fp->RowType = ROWTYPE_AGGREGATEINIT;
$material_required_issue_fp->resetAttributes();
$material_required_issue_fp_list->renderRow();
while ($material_required_issue_fp_list->RecCnt < $material_required_issue_fp_list->StopRec) {
	$material_required_issue_fp_list->RecCnt++;
	if ($material_required_issue_fp_list->RecCnt >= $material_required_issue_fp_list->StartRec) {
		$material_required_issue_fp_list->RowCnt++;

		// Set up key count
		$material_required_issue_fp_list->KeyCount = $material_required_issue_fp_list->RowIndex;

		// Init row class and style
		$material_required_issue_fp->resetAttributes();
		$material_required_issue_fp->CssClass = "";
		if ($material_required_issue_fp->isGridAdd()) {
		} else {
			$material_required_issue_fp_list->loadRowValues($material_required_issue_fp_list->Recordset); // Load row values
		}
		$material_required_issue_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_required_issue_fp->RowAttrs = array_merge($material_required_issue_fp->RowAttrs, array('data-rowindex'=>$material_required_issue_fp_list->RowCnt, 'id'=>'r' . $material_required_issue_fp_list->RowCnt . '_material_required_issue_fp', 'data-rowtype'=>$material_required_issue_fp->RowType));

		// Render row
		$material_required_issue_fp_list->renderRow();

		// Render list options
		$material_required_issue_fp_list->renderListOptions();
?>
	<tr<?php echo $material_required_issue_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_issue_fp_list->ListOptions->render("body", "left", $material_required_issue_fp_list->RowCnt);
?>
	<?php if ($material_required_issue_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_required_issue_fp->id->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_id" class="material_required_issue_fp_id">
<span<?php echo $material_required_issue_fp->id->viewAttributes() ?>>
<?php echo $material_required_issue_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $material_required_issue_fp->jc_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_jc_no" class="material_required_issue_fp_jc_no">
<span<?php echo $material_required_issue_fp->jc_no->viewAttributes() ?>>
<?php echo $material_required_issue_fp->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->po->Visible) { // po ?>
		<td data-name="po"<?php echo $material_required_issue_fp->po->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_po" class="material_required_issue_fp_po">
<span<?php echo $material_required_issue_fp->po->viewAttributes() ?>>
<?php echo $material_required_issue_fp->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->week->Visible) { // week ?>
		<td data-name="week"<?php echo $material_required_issue_fp->week->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_week" class="material_required_issue_fp_week">
<span<?php echo $material_required_issue_fp->week->viewAttributes() ?>>
<?php echo $material_required_issue_fp->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $material_required_issue_fp->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_buyer_id" class="material_required_issue_fp_buyer_id">
<span<?php echo $material_required_issue_fp->buyer_id->viewAttributes() ?>>
<?php echo $material_required_issue_fp->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $material_required_issue_fp->product->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_product" class="material_required_issue_fp_product">
<span<?php echo $material_required_issue_fp->product->viewAttributes() ?>>
<?php echo $material_required_issue_fp->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->product_id->Visible) { // product_id ?>
		<td data-name="product_id"<?php echo $material_required_issue_fp->product_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_product_id" class="material_required_issue_fp_product_id">
<span<?php echo $material_required_issue_fp->product_id->viewAttributes() ?>>
<?php echo $material_required_issue_fp->product_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $material_required_issue_fp->batch_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_batch_no" class="material_required_issue_fp_batch_no">
<span<?php echo $material_required_issue_fp->batch_no->viewAttributes() ?>>
<?php echo $material_required_issue_fp->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_required_issue_fp->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_quantity" class="material_required_issue_fp_quantity">
<span<?php echo $material_required_issue_fp->quantity->viewAttributes() ?>>
<?php echo $material_required_issue_fp->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->req_material_sgrp->Visible) { // req_material_sgrp ?>
		<td data-name="req_material_sgrp"<?php echo $material_required_issue_fp->req_material_sgrp->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_req_material_sgrp" class="material_required_issue_fp_req_material_sgrp">
<span<?php echo $material_required_issue_fp->req_material_sgrp->viewAttributes() ?>>
<?php echo $material_required_issue_fp->req_material_sgrp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->req_material_product->Visible) { // req_material_product ?>
		<td data-name="req_material_product"<?php echo $material_required_issue_fp->req_material_product->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_req_material_product" class="material_required_issue_fp_req_material_product">
<span<?php echo $material_required_issue_fp->req_material_product->viewAttributes() ?>>
<?php echo $material_required_issue_fp->req_material_product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $material_required_issue_fp->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_req_material_rid" class="material_required_issue_fp_req_material_rid">
<span<?php echo $material_required_issue_fp->req_material_rid->viewAttributes() ?>>
<?php echo $material_required_issue_fp->req_material_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->issue_material_rid->Visible) { // issue_material_rid ?>
		<td data-name="issue_material_rid"<?php echo $material_required_issue_fp->issue_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_issue_material_rid" class="material_required_issue_fp_issue_material_rid">
<span<?php echo $material_required_issue_fp->issue_material_rid->viewAttributes() ?>>
<?php echo $material_required_issue_fp->issue_material_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $material_required_issue_fp->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_req_material_qty" class="material_required_issue_fp_req_material_qty">
<span<?php echo $material_required_issue_fp->req_material_qty->viewAttributes() ?>>
<?php echo $material_required_issue_fp->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty"<?php echo $material_required_issue_fp->material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_material_qty" class="material_required_issue_fp_material_qty">
<span<?php echo $material_required_issue_fp->material_qty->viewAttributes() ?>>
<?php echo $material_required_issue_fp->material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $material_required_issue_fp->unit->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_unit" class="material_required_issue_fp_unit">
<span<?php echo $material_required_issue_fp->unit->viewAttributes() ?>>
<?php echo $material_required_issue_fp->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->method->Visible) { // method ?>
		<td data-name="method"<?php echo $material_required_issue_fp->method->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_method" class="material_required_issue_fp_method">
<span<?php echo $material_required_issue_fp->method->viewAttributes() ?>>
<?php echo $material_required_issue_fp->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $material_required_issue_fp->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_despatch_week" class="material_required_issue_fp_despatch_week">
<span<?php echo $material_required_issue_fp->despatch_week->viewAttributes() ?>>
<?php echo $material_required_issue_fp->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $material_required_issue_fp->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_despatch_date" class="material_required_issue_fp_despatch_date">
<span<?php echo $material_required_issue_fp->despatch_date->viewAttributes() ?>>
<?php echo $material_required_issue_fp->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->production_plan->Visible) { // production_plan ?>
		<td data-name="production_plan"<?php echo $material_required_issue_fp->production_plan->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_production_plan" class="material_required_issue_fp_production_plan">
<span<?php echo $material_required_issue_fp->production_plan->viewAttributes() ?>>
<?php echo $material_required_issue_fp->production_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_required_issue_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_operator" class="material_required_issue_fp_operator">
<span<?php echo $material_required_issue_fp->operator->viewAttributes() ?>>
<?php echo $material_required_issue_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $material_required_issue_fp->datetime->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_datetime" class="material_required_issue_fp_datetime">
<span<?php echo $material_required_issue_fp->datetime->viewAttributes() ?>>
<?php echo $material_required_issue_fp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->material_out->Visible) { // material_out ?>
		<td data-name="material_out"<?php echo $material_required_issue_fp->material_out->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_material_out" class="material_required_issue_fp_material_out">
<span<?php echo $material_required_issue_fp->material_out->viewAttributes() ?>>
<?php echo $material_required_issue_fp->material_out->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue_fp->material_out_id->Visible) { // material_out_id ?>
		<td data-name="material_out_id"<?php echo $material_required_issue_fp->material_out_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_fp_list->RowCnt ?>_material_required_issue_fp_material_out_id" class="material_required_issue_fp_material_out_id">
<span<?php echo $material_required_issue_fp->material_out_id->viewAttributes() ?>>
<?php echo $material_required_issue_fp->material_out_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_required_issue_fp_list->ListOptions->render("body", "right", $material_required_issue_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_required_issue_fp->isGridAdd())
		$material_required_issue_fp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_required_issue_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_required_issue_fp_list->Recordset)
	$material_required_issue_fp_list->Recordset->Close();
?>
<?php if (!$material_required_issue_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_required_issue_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_issue_fp_list->Pager)) $material_required_issue_fp_list->Pager = new PrevNextPager($material_required_issue_fp_list->StartRec, $material_required_issue_fp_list->DisplayRecs, $material_required_issue_fp_list->TotalRecs, $material_required_issue_fp_list->AutoHidePager) ?>
<?php if ($material_required_issue_fp_list->Pager->RecordCount > 0 && $material_required_issue_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_issue_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_issue_fp_list->pageUrl() ?>start=<?php echo $material_required_issue_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_issue_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_issue_fp_list->pageUrl() ?>start=<?php echo $material_required_issue_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_issue_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_issue_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_issue_fp_list->pageUrl() ?>start=<?php echo $material_required_issue_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_issue_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_issue_fp_list->pageUrl() ?>start=<?php echo $material_required_issue_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_issue_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_issue_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_issue_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_issue_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_issue_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_issue_fp_list->TotalRecs > 0 && (!$material_required_issue_fp_list->AutoHidePageSizeSelector || $material_required_issue_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_issue_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_issue_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_issue_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_issue_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_issue_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_issue_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_issue_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_issue_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_required_issue_fp_list->TotalRecs == 0 && !$material_required_issue_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_required_issue_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_required_issue_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_required_issue_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_required_issue_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_required_issue_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_required_issue_fp_list->terminate();
?>