<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_issue_fp_search = new material_required_issue_fp_search();

// Run the page
$material_required_issue_fp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_issue_fp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_required_issue_fp_search->IsModal) { ?>
var fmaterial_required_issue_fpsearch = currentAdvancedSearchForm = new ew.Form("fmaterial_required_issue_fpsearch", "search");
<?php } else { ?>
var fmaterial_required_issue_fpsearch = currentForm = new ew.Form("fmaterial_required_issue_fpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_required_issue_fpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_issue_fpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_issue_fpsearch.lists["x_jc_no"] = <?php echo $material_required_issue_fp_search->jc_no->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_jc_no"].options = <?php echo JsonEncode($material_required_issue_fp_search->jc_no->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_poid"] = <?php echo $material_required_issue_fp_search->poid->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_poid"].options = <?php echo JsonEncode($material_required_issue_fp_search->poid->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_week"] = <?php echo $material_required_issue_fp_search->week->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_week"].options = <?php echo JsonEncode($material_required_issue_fp_search->week->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_buyer_id"] = <?php echo $material_required_issue_fp_search->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_issue_fp_search->buyer_id->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_grp"] = <?php echo $material_required_issue_fp_search->grp->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_grp"].options = <?php echo JsonEncode($material_required_issue_fp_search->grp->options(FALSE, TRUE)) ?>;
fmaterial_required_issue_fpsearch.lists["x_s_grp"] = <?php echo $material_required_issue_fp_search->s_grp->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_s_grp"].options = <?php echo JsonEncode($material_required_issue_fp_search->s_grp->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_product"] = <?php echo $material_required_issue_fp_search->product->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_product"].options = <?php echo JsonEncode($material_required_issue_fp_search->product->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_product_id"] = <?php echo $material_required_issue_fp_search->product_id->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_product_id"].options = <?php echo JsonEncode($material_required_issue_fp_search->product_id->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_req_material_sgrp"] = <?php echo $material_required_issue_fp_search->req_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_req_material_sgrp"].options = <?php echo JsonEncode($material_required_issue_fp_search->req_material_sgrp->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_issue_material_sgrp"] = <?php echo $material_required_issue_fp_search->issue_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_issue_material_sgrp"].options = <?php echo JsonEncode($material_required_issue_fp_search->issue_material_sgrp->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_req_material_product"] = <?php echo $material_required_issue_fp_search->req_material_product->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_req_material_product"].options = <?php echo JsonEncode($material_required_issue_fp_search->req_material_product->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_issue_material_product"] = <?php echo $material_required_issue_fp_search->issue_material_product->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_issue_material_product"].options = <?php echo JsonEncode($material_required_issue_fp_search->issue_material_product->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_req_material_rid"] = <?php echo $material_required_issue_fp_search->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_issue_fp_search->req_material_rid->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_unit"] = <?php echo $material_required_issue_fp_search->unit->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_unit"].options = <?php echo JsonEncode($material_required_issue_fp_search->unit->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_method"] = <?php echo $material_required_issue_fp_search->method->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_method"].options = <?php echo JsonEncode($material_required_issue_fp_search->method->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_despatch_week"] = <?php echo $material_required_issue_fp_search->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_issue_fp_search->despatch_week->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_production_plan"] = <?php echo $material_required_issue_fp_search->production_plan->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_production_plan"].options = <?php echo JsonEncode($material_required_issue_fp_search->production_plan->options(FALSE, TRUE)) ?>;
fmaterial_required_issue_fpsearch.lists["x_operator"] = <?php echo $material_required_issue_fp_search->operator->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_operator"].options = <?php echo JsonEncode($material_required_issue_fp_search->operator->lookupOptions()) ?>;
fmaterial_required_issue_fpsearch.lists["x_material_out"] = <?php echo $material_required_issue_fp_search->material_out->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_material_out"].options = <?php echo JsonEncode($material_required_issue_fp_search->material_out->options(FALSE, TRUE)) ?>;
fmaterial_required_issue_fpsearch.lists["x_material_out_id"] = <?php echo $material_required_issue_fp_search->material_out_id->Lookup->toClientList() ?>;
fmaterial_required_issue_fpsearch.lists["x_material_out_id"].options = <?php echo JsonEncode($material_required_issue_fp_search->material_out_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmaterial_required_issue_fpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->batch_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_material_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->issue_material_rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_req_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->req_material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->issue_material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->despatch_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_updated");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->updated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue_fp->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_required_issue_fp_search->showPageHeader(); ?>
<?php
$material_required_issue_fp_search->showMessage();
?>
<form name="fmaterial_required_issue_fpsearch" id="fmaterial_required_issue_fpsearch" class="<?php echo $material_required_issue_fp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_issue_fp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_issue_fp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_issue_fp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_required_issue_fp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_required_issue_fp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_id"><?php echo $material_required_issue_fp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->id->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_id">
<input type="text" data-table="material_required_issue_fp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_required_issue_fp->id->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->id->EditValue ?>"<?php echo $material_required_issue_fp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_jc_no"><?php echo $material_required_issue_fp->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->jc_no->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_jc_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_jc_no" data-value-separator="<?php echo $material_required_issue_fp->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $material_required_issue_fp->jc_no->editAttributes() ?>>
		<?php echo $material_required_issue_fp->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_po"><?php echo $material_required_issue_fp->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->po->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_po">
<input type="text" data-table="material_required_issue_fp" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->po->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->po->EditValue ?>"<?php echo $material_required_issue_fp->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label for="x_poid" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_poid"><?php echo $material_required_issue_fp->poid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_poid" id="z_poid" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->poid->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_poid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_poid" data-value-separator="<?php echo $material_required_issue_fp->poid->displayValueSeparatorAttribute() ?>" id="x_poid" name="x_poid"<?php echo $material_required_issue_fp->poid->editAttributes() ?>>
		<?php echo $material_required_issue_fp->poid->selectOptionListHtml("x_poid") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->poid->Lookup->getParamTag("p_x_poid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->week->Visible) { // week ?>
	<div id="r_week" class="form-group row">
		<label for="x_week" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_week"><?php echo $material_required_issue_fp->week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_week" id="z_week" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->week->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_week" data-value-separator="<?php echo $material_required_issue_fp->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $material_required_issue_fp->week->editAttributes() ?>>
		<?php echo $material_required_issue_fp->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->week->Lookup->getParamTag("p_x_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_buyer_id"><?php echo $material_required_issue_fp->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->buyer_id->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_buyer_id" data-value-separator="<?php echo $material_required_issue_fp->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $material_required_issue_fp->buyer_id->editAttributes() ?>>
		<?php echo $material_required_issue_fp->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_grp"><?php echo $material_required_issue_fp->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->grp->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_grp" data-value-separator="<?php echo $material_required_issue_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_required_issue_fp->grp->editAttributes() ?>>
		<?php echo $material_required_issue_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_s_grp"><?php echo $material_required_issue_fp->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->s_grp->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_s_grp" data-value-separator="<?php echo $material_required_issue_fp->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_required_issue_fp->s_grp->editAttributes() ?>>
		<?php echo $material_required_issue_fp->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_product"><?php echo $material_required_issue_fp->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->product->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_product" data-value-separator="<?php echo $material_required_issue_fp->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_required_issue_fp->product->editAttributes() ?>>
		<?php echo $material_required_issue_fp->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->product_id->Visible) { // product_id ?>
	<div id="r_product_id" class="form-group row">
		<label for="x_product_id" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_product_id"><?php echo $material_required_issue_fp->product_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_id" id="z_product_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->product_id->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_product_id">
<?php $material_required_issue_fp->product_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_issue_fp->product_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_product_id" data-value-separator="<?php echo $material_required_issue_fp->product_id->displayValueSeparatorAttribute() ?>" id="x_product_id" name="x_product_id"<?php echo $material_required_issue_fp->product_id->editAttributes() ?>>
		<?php echo $material_required_issue_fp->product_id->selectOptionListHtml("x_product_id") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->product_id->Lookup->getParamTag("p_x_product_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_batch_no"><?php echo $material_required_issue_fp->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->batch_no->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_batch_no">
<input type="text" data-table="material_required_issue_fp" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->batch_no->EditValue ?>"<?php echo $material_required_issue_fp->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_quantity"><?php echo $material_required_issue_fp->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->quantity->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_quantity">
<input type="text" data-table="material_required_issue_fp" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->quantity->EditValue ?>"<?php echo $material_required_issue_fp->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<div id="r_req_material_sgrp" class="form-group row">
		<label for="x_req_material_sgrp" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_req_material_sgrp"><?php echo $material_required_issue_fp->req_material_sgrp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_sgrp" id="z_req_material_sgrp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->req_material_sgrp->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_req_material_sgrp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_req_material_sgrp" data-value-separator="<?php echo $material_required_issue_fp->req_material_sgrp->displayValueSeparatorAttribute() ?>" id="x_req_material_sgrp" name="x_req_material_sgrp"<?php echo $material_required_issue_fp->req_material_sgrp->editAttributes() ?>>
		<?php echo $material_required_issue_fp->req_material_sgrp->selectOptionListHtml("x_req_material_sgrp") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->req_material_sgrp->Lookup->getParamTag("p_x_req_material_sgrp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->issue_material_sgrp->Visible) { // issue_material_sgrp ?>
	<div id="r_issue_material_sgrp" class="form-group row">
		<label for="x_issue_material_sgrp" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_issue_material_sgrp"><?php echo $material_required_issue_fp->issue_material_sgrp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_sgrp" id="z_issue_material_sgrp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->issue_material_sgrp->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_issue_material_sgrp">
<?php $material_required_issue_fp->issue_material_sgrp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_issue_fp->issue_material_sgrp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_issue_material_sgrp" data-value-separator="<?php echo $material_required_issue_fp->issue_material_sgrp->displayValueSeparatorAttribute() ?>" id="x_issue_material_sgrp" name="x_issue_material_sgrp"<?php echo $material_required_issue_fp->issue_material_sgrp->editAttributes() ?>>
		<?php echo $material_required_issue_fp->issue_material_sgrp->selectOptionListHtml("x_issue_material_sgrp") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->issue_material_sgrp->Lookup->getParamTag("p_x_issue_material_sgrp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_product->Visible) { // req_material_product ?>
	<div id="r_req_material_product" class="form-group row">
		<label for="x_req_material_product" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_req_material_product"><?php echo $material_required_issue_fp->req_material_product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_product" id="z_req_material_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->req_material_product->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_req_material_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_req_material_product" data-value-separator="<?php echo $material_required_issue_fp->req_material_product->displayValueSeparatorAttribute() ?>" id="x_req_material_product" name="x_req_material_product"<?php echo $material_required_issue_fp->req_material_product->editAttributes() ?>>
		<?php echo $material_required_issue_fp->req_material_product->selectOptionListHtml("x_req_material_product") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->req_material_product->Lookup->getParamTag("p_x_req_material_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->issue_material_product->Visible) { // issue_material_product ?>
	<div id="r_issue_material_product" class="form-group row">
		<label for="x_issue_material_product" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_issue_material_product"><?php echo $material_required_issue_fp->issue_material_product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_product" id="z_issue_material_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->issue_material_product->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_issue_material_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_issue_material_product" data-value-separator="<?php echo $material_required_issue_fp->issue_material_product->displayValueSeparatorAttribute() ?>" id="x_issue_material_product" name="x_issue_material_product"<?php echo $material_required_issue_fp->issue_material_product->editAttributes() ?>>
		<?php echo $material_required_issue_fp->issue_material_product->selectOptionListHtml("x_issue_material_product") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->issue_material_product->Lookup->getParamTag("p_x_issue_material_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_rid->Visible) { // req_material_rid ?>
	<div id="r_req_material_rid" class="form-group row">
		<label for="x_req_material_rid" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_req_material_rid"><?php echo $material_required_issue_fp->req_material_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->req_material_rid->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_req_material_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_req_material_rid" data-value-separator="<?php echo $material_required_issue_fp->req_material_rid->displayValueSeparatorAttribute() ?>" id="x_req_material_rid" name="x_req_material_rid"<?php echo $material_required_issue_fp->req_material_rid->editAttributes() ?>>
		<?php echo $material_required_issue_fp->req_material_rid->selectOptionListHtml("x_req_material_rid") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->req_material_rid->Lookup->getParamTag("p_x_req_material_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->issue_material_rid->Visible) { // issue_material_rid ?>
	<div id="r_issue_material_rid" class="form-group row">
		<label for="x_issue_material_rid" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_issue_material_rid"><?php echo $material_required_issue_fp->issue_material_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_rid" id="z_issue_material_rid" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->issue_material_rid->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_issue_material_rid">
<input type="text" data-table="material_required_issue_fp" data-field="x_issue_material_rid" name="x_issue_material_rid" id="x_issue_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->issue_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->issue_material_rid->EditValue ?>"<?php echo $material_required_issue_fp->issue_material_rid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->req_material_qty->Visible) { // req_material_qty ?>
	<div id="r_req_material_qty" class="form-group row">
		<label for="x_req_material_qty" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_req_material_qty"><?php echo $material_required_issue_fp->req_material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_qty" id="z_req_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->req_material_qty->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_req_material_qty">
<input type="text" data-table="material_required_issue_fp" data-field="x_req_material_qty" name="x_req_material_qty" id="x_req_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->req_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->req_material_qty->EditValue ?>"<?php echo $material_required_issue_fp->req_material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->issue_material_qty->Visible) { // issue_material_qty ?>
	<div id="r_issue_material_qty" class="form-group row">
		<label for="x_issue_material_qty" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_issue_material_qty"><?php echo $material_required_issue_fp->issue_material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_qty" id="z_issue_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->issue_material_qty->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_issue_material_qty">
<input type="text" data-table="material_required_issue_fp" data-field="x_issue_material_qty" name="x_issue_material_qty" id="x_issue_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->issue_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->issue_material_qty->EditValue ?>"<?php echo $material_required_issue_fp->issue_material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->material_qty->Visible) { // material_qty ?>
	<div id="r_material_qty" class="form-group row">
		<label for="x_material_qty" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_material_qty"><?php echo $material_required_issue_fp->material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_qty" id="z_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->material_qty->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_material_qty">
<input type="text" data-table="material_required_issue_fp" data-field="x_material_qty" name="x_material_qty" id="x_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->material_qty->EditValue ?>"<?php echo $material_required_issue_fp->material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_unit"><?php echo $material_required_issue_fp->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_unit" id="z_unit" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->unit->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_unit" data-value-separator="<?php echo $material_required_issue_fp->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $material_required_issue_fp->unit->editAttributes() ?>>
		<?php echo $material_required_issue_fp->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_method"><?php echo $material_required_issue_fp->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->method->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_method" data-value-separator="<?php echo $material_required_issue_fp->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $material_required_issue_fp->method->editAttributes() ?>>
		<?php echo $material_required_issue_fp->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->method->Lookup->getParamTag("p_x_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_despatch_week"><?php echo $material_required_issue_fp->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->despatch_week->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_despatch_week" data-value-separator="<?php echo $material_required_issue_fp->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $material_required_issue_fp->despatch_week->editAttributes() ?>>
		<?php echo $material_required_issue_fp->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_despatch_date"><?php echo $material_required_issue_fp->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->despatch_date->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_despatch_date">
<input type="text" data-table="material_required_issue_fp" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($material_required_issue_fp->despatch_date->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->despatch_date->EditValue ?>"<?php echo $material_required_issue_fp->despatch_date->editAttributes() ?>>
<?php if (!$material_required_issue_fp->despatch_date->ReadOnly && !$material_required_issue_fp->despatch_date->Disabled && !isset($material_required_issue_fp->despatch_date->EditAttrs["readonly"]) && !isset($material_required_issue_fp->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_issue_fpsearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_production_plan"><?php echo $material_required_issue_fp->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->production_plan->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_production_plan" data-value-separator="<?php echo $material_required_issue_fp->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $material_required_issue_fp->production_plan->editAttributes() ?>>
		<?php echo $material_required_issue_fp->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_remarks"><?php echo $material_required_issue_fp->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->remarks->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_remarks">
<input type="text" data-table="material_required_issue_fp" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($material_required_issue_fp->remarks->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->remarks->EditValue ?>"<?php echo $material_required_issue_fp->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->updated->Visible) { // updated ?>
	<div id="r_updated" class="form-group row">
		<label for="x_updated" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_updated"><?php echo $material_required_issue_fp->updated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_updated" id="z_updated" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->updated->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_updated">
<input type="text" data-table="material_required_issue_fp" data-field="x_updated" name="x_updated" id="x_updated" size="30" placeholder="<?php echo HtmlEncode($material_required_issue_fp->updated->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->updated->EditValue ?>"<?php echo $material_required_issue_fp->updated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_operator"><?php echo $material_required_issue_fp->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->operator->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_operator" data-value-separator="<?php echo $material_required_issue_fp->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $material_required_issue_fp->operator->editAttributes() ?>>
		<?php echo $material_required_issue_fp->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_datetime"><?php echo $material_required_issue_fp->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->datetime->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_datetime">
<input type="text" data-table="material_required_issue_fp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($material_required_issue_fp->datetime->getPlaceHolder()) ?>" value="<?php echo $material_required_issue_fp->datetime->EditValue ?>"<?php echo $material_required_issue_fp->datetime->editAttributes() ?>>
<?php if (!$material_required_issue_fp->datetime->ReadOnly && !$material_required_issue_fp->datetime->Disabled && !isset($material_required_issue_fp->datetime->EditAttrs["readonly"]) && !isset($material_required_issue_fp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_issue_fpsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->material_out->Visible) { // material_out ?>
	<div id="r_material_out" class="form-group row">
		<label class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_material_out"><?php echo $material_required_issue_fp->material_out->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_out" id="z_material_out" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->material_out->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_material_out">
<div id="tp_x_material_out" class="ew-template"><input type="radio" class="form-check-input" data-table="material_required_issue_fp" data-field="x_material_out" data-value-separator="<?php echo $material_required_issue_fp->material_out->displayValueSeparatorAttribute() ?>" name="x_material_out" id="x_material_out" value="{value}"<?php echo $material_required_issue_fp->material_out->editAttributes() ?>></div>
<div id="dsl_x_material_out" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_required_issue_fp->material_out->radioButtonListHtml(FALSE, "x_material_out") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue_fp->material_out_id->Visible) { // material_out_id ?>
	<div id="r_material_out_id" class="form-group row">
		<label for="x_material_out_id" class="<?php echo $material_required_issue_fp_search->LeftColumnClass ?>"><span id="elh_material_required_issue_fp_material_out_id"><?php echo $material_required_issue_fp->material_out_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_out_id" id="z_material_out_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_fp_search->RightColumnClass ?>"><div<?php echo $material_required_issue_fp->material_out_id->cellAttributes() ?>>
			<span id="el_material_required_issue_fp_material_out_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue_fp" data-field="x_material_out_id" data-value-separator="<?php echo $material_required_issue_fp->material_out_id->displayValueSeparatorAttribute() ?>" id="x_material_out_id" name="x_material_out_id"<?php echo $material_required_issue_fp->material_out_id->editAttributes() ?>>
		<?php echo $material_required_issue_fp->material_out_id->selectOptionListHtml("x_material_out_id") ?>
	</select>
</div>
<?php echo $material_required_issue_fp->material_out_id->Lookup->getParamTag("p_x_material_out_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_required_issue_fp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_required_issue_fp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_required_issue_fp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_required_issue_fp_search->terminate();
?>