<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_issue_list = new material_required_issue_list();

// Run the page
$material_required_issue_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_issue_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_required_issue->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_required_issuelist = currentForm = new ew.Form("fmaterial_required_issuelist", "list");
fmaterial_required_issuelist.formKeyCountName = '<?php echo $material_required_issue_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_required_issuelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_issuelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_issuelist.lists["x_jc_no"] = <?php echo $material_required_issue_list->jc_no->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_jc_no"].options = <?php echo JsonEncode($material_required_issue_list->jc_no->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_week"] = <?php echo $material_required_issue_list->week->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_week"].options = <?php echo JsonEncode($material_required_issue_list->week->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_buyer_id"] = <?php echo $material_required_issue_list->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_issue_list->buyer_id->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_product"] = <?php echo $material_required_issue_list->product->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_product"].options = <?php echo JsonEncode($material_required_issue_list->product->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_product_id"] = <?php echo $material_required_issue_list->product_id->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_product_id"].options = <?php echo JsonEncode($material_required_issue_list->product_id->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_req_material_sgrp"] = <?php echo $material_required_issue_list->req_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_req_material_sgrp"].options = <?php echo JsonEncode($material_required_issue_list->req_material_sgrp->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_req_material_product"] = <?php echo $material_required_issue_list->req_material_product->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_req_material_product"].options = <?php echo JsonEncode($material_required_issue_list->req_material_product->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_req_material_rid"] = <?php echo $material_required_issue_list->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_issue_list->req_material_rid->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_unit"] = <?php echo $material_required_issue_list->unit->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_unit"].options = <?php echo JsonEncode($material_required_issue_list->unit->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_method"] = <?php echo $material_required_issue_list->method->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_method"].options = <?php echo JsonEncode($material_required_issue_list->method->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_despatch_week"] = <?php echo $material_required_issue_list->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_issue_list->despatch_week->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_production_plan"] = <?php echo $material_required_issue_list->production_plan->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_production_plan"].options = <?php echo JsonEncode($material_required_issue_list->production_plan->options(FALSE, TRUE)) ?>;
fmaterial_required_issuelist.lists["x_operator"] = <?php echo $material_required_issue_list->operator->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_operator"].options = <?php echo JsonEncode($material_required_issue_list->operator->lookupOptions()) ?>;
fmaterial_required_issuelist.lists["x_material_out"] = <?php echo $material_required_issue_list->material_out->Lookup->toClientList() ?>;
fmaterial_required_issuelist.lists["x_material_out"].options = <?php echo JsonEncode($material_required_issue_list->material_out->options(FALSE, TRUE)) ?>;

// Form object for search
var fmaterial_required_issuelistsrch = currentSearchForm = new ew.Form("fmaterial_required_issuelistsrch");

// Filters
fmaterial_required_issuelistsrch.filterList = <?php echo $material_required_issue_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_required_issuelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_required_issue->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_required_issue_list->TotalRecs > 0 && $material_required_issue_list->ExportOptions->visible()) { ?>
<?php $material_required_issue_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_issue_list->ImportOptions->visible()) { ?>
<?php $material_required_issue_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_issue_list->SearchOptions->visible()) { ?>
<?php $material_required_issue_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_issue_list->FilterOptions->visible()) { ?>
<?php $material_required_issue_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_required_issue_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_required_issue->isExport() && !$material_required_issue->CurrentAction) { ?>
<form name="fmaterial_required_issuelistsrch" id="fmaterial_required_issuelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_required_issue_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_required_issuelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_required_issue">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_required_issue_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_required_issue_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_required_issue_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_required_issue_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_required_issue_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_required_issue_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_required_issue_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_required_issue_list->showPageHeader(); ?>
<?php
$material_required_issue_list->showMessage();
?>
<?php if ($material_required_issue_list->TotalRecs > 0 || $material_required_issue->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_required_issue_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_required_issue">
<?php if (!$material_required_issue->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_required_issue->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_issue_list->Pager)) $material_required_issue_list->Pager = new PrevNextPager($material_required_issue_list->StartRec, $material_required_issue_list->DisplayRecs, $material_required_issue_list->TotalRecs, $material_required_issue_list->AutoHidePager) ?>
<?php if ($material_required_issue_list->Pager->RecordCount > 0 && $material_required_issue_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_issue_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_issue_list->pageUrl() ?>start=<?php echo $material_required_issue_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_issue_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_issue_list->pageUrl() ?>start=<?php echo $material_required_issue_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_issue_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_issue_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_issue_list->pageUrl() ?>start=<?php echo $material_required_issue_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_issue_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_issue_list->pageUrl() ?>start=<?php echo $material_required_issue_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_issue_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_issue_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_issue_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_issue_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_issue_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_issue_list->TotalRecs > 0 && (!$material_required_issue_list->AutoHidePageSizeSelector || $material_required_issue_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_issue">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_issue_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_issue_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_issue_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_issue_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_issue_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_issue->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_issue_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_required_issuelist" id="fmaterial_required_issuelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_issue_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_issue_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_issue">
<div id="gmp_material_required_issue" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_required_issue_list->TotalRecs > 0 || $material_required_issue->isGridEdit()) { ?>
<table id="tbl_material_required_issuelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_required_issue_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_required_issue_list->renderListOptions();

// Render list options (header, left)
$material_required_issue_list->ListOptions->render("header", "left");
?>
<?php if ($material_required_issue->id->Visible) { // id ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_required_issue->id->headerCellClass() ?>"><div id="elh_material_required_issue_id" class="material_required_issue_id"><div class="ew-table-header-caption"><?php echo $material_required_issue->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_required_issue->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->id) ?>',2);"><div id="elh_material_required_issue_id" class="material_required_issue_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->jc_no->Visible) { // jc_no ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $material_required_issue->jc_no->headerCellClass() ?>"><div id="elh_material_required_issue_jc_no" class="material_required_issue_jc_no"><div class="ew-table-header-caption"><?php echo $material_required_issue->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $material_required_issue->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->jc_no) ?>',2);"><div id="elh_material_required_issue_jc_no" class="material_required_issue_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->po->Visible) { // po ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->po) == "") { ?>
		<th data-name="po" class="<?php echo $material_required_issue->po->headerCellClass() ?>"><div id="elh_material_required_issue_po" class="material_required_issue_po"><div class="ew-table-header-caption"><?php echo $material_required_issue->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $material_required_issue->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->po) ?>',2);"><div id="elh_material_required_issue_po" class="material_required_issue_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->week->Visible) { // week ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->week) == "") { ?>
		<th data-name="week" class="<?php echo $material_required_issue->week->headerCellClass() ?>"><div id="elh_material_required_issue_week" class="material_required_issue_week"><div class="ew-table-header-caption"><?php echo $material_required_issue->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $material_required_issue->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->week) ?>',2);"><div id="elh_material_required_issue_week" class="material_required_issue_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->buyer_id->Visible) { // buyer_id ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_issue->buyer_id->headerCellClass() ?>"><div id="elh_material_required_issue_buyer_id" class="material_required_issue_buyer_id"><div class="ew-table-header-caption"><?php echo $material_required_issue->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_issue->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->buyer_id) ?>',2);"><div id="elh_material_required_issue_buyer_id" class="material_required_issue_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->product->Visible) { // product ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->product) == "") { ?>
		<th data-name="product" class="<?php echo $material_required_issue->product->headerCellClass() ?>"><div id="elh_material_required_issue_product" class="material_required_issue_product"><div class="ew-table-header-caption"><?php echo $material_required_issue->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $material_required_issue->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->product) ?>',2);"><div id="elh_material_required_issue_product" class="material_required_issue_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->product_id->Visible) { // product_id ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->product_id) == "") { ?>
		<th data-name="product_id" class="<?php echo $material_required_issue->product_id->headerCellClass() ?>"><div id="elh_material_required_issue_product_id" class="material_required_issue_product_id"><div class="ew-table-header-caption"><?php echo $material_required_issue->product_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_id" class="<?php echo $material_required_issue->product_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->product_id) ?>',2);"><div id="elh_material_required_issue_product_id" class="material_required_issue_product_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->product_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->product_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->product_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->batch_no->Visible) { // batch_no ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $material_required_issue->batch_no->headerCellClass() ?>"><div id="elh_material_required_issue_batch_no" class="material_required_issue_batch_no"><div class="ew-table-header-caption"><?php echo $material_required_issue->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $material_required_issue->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->batch_no) ?>',2);"><div id="elh_material_required_issue_batch_no" class="material_required_issue_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->quantity->Visible) { // quantity ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_required_issue->quantity->headerCellClass() ?>"><div id="elh_material_required_issue_quantity" class="material_required_issue_quantity"><div class="ew-table-header-caption"><?php echo $material_required_issue->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_required_issue->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->quantity) ?>',2);"><div id="elh_material_required_issue_quantity" class="material_required_issue_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->req_material_sgrp) == "") { ?>
		<th data-name="req_material_sgrp" class="<?php echo $material_required_issue->req_material_sgrp->headerCellClass() ?>"><div id="elh_material_required_issue_req_material_sgrp" class="material_required_issue_req_material_sgrp"><div class="ew-table-header-caption"><?php echo $material_required_issue->req_material_sgrp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_sgrp" class="<?php echo $material_required_issue->req_material_sgrp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->req_material_sgrp) ?>',2);"><div id="elh_material_required_issue_req_material_sgrp" class="material_required_issue_req_material_sgrp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->req_material_sgrp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->req_material_sgrp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->req_material_sgrp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->req_material_product->Visible) { // req_material_product ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->req_material_product) == "") { ?>
		<th data-name="req_material_product" class="<?php echo $material_required_issue->req_material_product->headerCellClass() ?>"><div id="elh_material_required_issue_req_material_product" class="material_required_issue_req_material_product"><div class="ew-table-header-caption"><?php echo $material_required_issue->req_material_product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_product" class="<?php echo $material_required_issue->req_material_product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->req_material_product) ?>',2);"><div id="elh_material_required_issue_req_material_product" class="material_required_issue_req_material_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->req_material_product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->req_material_product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->req_material_product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_issue->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_issue_req_material_rid" class="material_required_issue_req_material_rid"><div class="ew-table-header-caption"><?php echo $material_required_issue->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_issue->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->req_material_rid) ?>',2);"><div id="elh_material_required_issue_req_material_rid" class="material_required_issue_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_issue->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_issue_req_material_qty" class="material_required_issue_req_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_issue->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_issue->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->req_material_qty) ?>',2);"><div id="elh_material_required_issue_req_material_qty" class="material_required_issue_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->req_material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->material_qty->Visible) { // material_qty ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->material_qty) == "") { ?>
		<th data-name="material_qty" class="<?php echo $material_required_issue->material_qty->headerCellClass() ?>"><div id="elh_material_required_issue_material_qty" class="material_required_issue_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_issue->material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_qty" class="<?php echo $material_required_issue->material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->material_qty) ?>',2);"><div id="elh_material_required_issue_material_qty" class="material_required_issue_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->unit->Visible) { // unit ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $material_required_issue->unit->headerCellClass() ?>"><div id="elh_material_required_issue_unit" class="material_required_issue_unit"><div class="ew-table-header-caption"><?php echo $material_required_issue->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $material_required_issue->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->unit) ?>',2);"><div id="elh_material_required_issue_unit" class="material_required_issue_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->method->Visible) { // method ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->method) == "") { ?>
		<th data-name="method" class="<?php echo $material_required_issue->method->headerCellClass() ?>"><div id="elh_material_required_issue_method" class="material_required_issue_method"><div class="ew-table-header-caption"><?php echo $material_required_issue->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $material_required_issue->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->method) ?>',2);"><div id="elh_material_required_issue_method" class="material_required_issue_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->despatch_week->Visible) { // despatch_week ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_issue->despatch_week->headerCellClass() ?>"><div id="elh_material_required_issue_despatch_week" class="material_required_issue_despatch_week"><div class="ew-table-header-caption"><?php echo $material_required_issue->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_issue->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->despatch_week) ?>',2);"><div id="elh_material_required_issue_despatch_week" class="material_required_issue_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->production_plan->Visible) { // production_plan ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->production_plan) == "") { ?>
		<th data-name="production_plan" class="<?php echo $material_required_issue->production_plan->headerCellClass() ?>"><div id="elh_material_required_issue_production_plan" class="material_required_issue_production_plan"><div class="ew-table-header-caption"><?php echo $material_required_issue->production_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_plan" class="<?php echo $material_required_issue->production_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->production_plan) ?>',2);"><div id="elh_material_required_issue_production_plan" class="material_required_issue_production_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->production_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->production_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->production_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->operator->Visible) { // operator ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_required_issue->operator->headerCellClass() ?>"><div id="elh_material_required_issue_operator" class="material_required_issue_operator"><div class="ew-table-header-caption"><?php echo $material_required_issue->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_required_issue->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->operator) ?>',2);"><div id="elh_material_required_issue_operator" class="material_required_issue_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->datetime->Visible) { // datetime ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $material_required_issue->datetime->headerCellClass() ?>"><div id="elh_material_required_issue_datetime" class="material_required_issue_datetime"><div class="ew-table-header-caption"><?php echo $material_required_issue->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $material_required_issue->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->datetime) ?>',2);"><div id="elh_material_required_issue_datetime" class="material_required_issue_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->material_out->Visible) { // material_out ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->material_out) == "") { ?>
		<th data-name="material_out" class="<?php echo $material_required_issue->material_out->headerCellClass() ?>"><div id="elh_material_required_issue_material_out" class="material_required_issue_material_out"><div class="ew-table-header-caption"><?php echo $material_required_issue->material_out->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_out" class="<?php echo $material_required_issue->material_out->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->material_out) ?>',2);"><div id="elh_material_required_issue_material_out" class="material_required_issue_material_out">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->material_out->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->material_out->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->material_out->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->despatch_date->Visible) { // despatch_date ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_issue->despatch_date->headerCellClass() ?>"><div id="elh_material_required_issue_despatch_date" class="material_required_issue_despatch_date"><div class="ew-table-header-caption"><?php echo $material_required_issue->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_issue->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->despatch_date) ?>',2);"><div id="elh_material_required_issue_despatch_date" class="material_required_issue_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_issue->issue_material_id->Visible) { // issue_material_id ?>
	<?php if ($material_required_issue->sortUrl($material_required_issue->issue_material_id) == "") { ?>
		<th data-name="issue_material_id" class="<?php echo $material_required_issue->issue_material_id->headerCellClass() ?>"><div id="elh_material_required_issue_issue_material_id" class="material_required_issue_issue_material_id"><div class="ew-table-header-caption"><?php echo $material_required_issue->issue_material_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_material_id" class="<?php echo $material_required_issue->issue_material_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_issue->SortUrl($material_required_issue->issue_material_id) ?>',2);"><div id="elh_material_required_issue_issue_material_id" class="material_required_issue_issue_material_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_issue->issue_material_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_issue->issue_material_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_issue->issue_material_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_issue_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_required_issue->ExportAll && $material_required_issue->isExport()) {
	$material_required_issue_list->StopRec = $material_required_issue_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_required_issue_list->TotalRecs > $material_required_issue_list->StartRec + $material_required_issue_list->DisplayRecs - 1)
		$material_required_issue_list->StopRec = $material_required_issue_list->StartRec + $material_required_issue_list->DisplayRecs - 1;
	else
		$material_required_issue_list->StopRec = $material_required_issue_list->TotalRecs;
}
$material_required_issue_list->RecCnt = $material_required_issue_list->StartRec - 1;
if ($material_required_issue_list->Recordset && !$material_required_issue_list->Recordset->EOF) {
	$material_required_issue_list->Recordset->moveFirst();
	$selectLimit = $material_required_issue_list->UseSelectLimit;
	if (!$selectLimit && $material_required_issue_list->StartRec > 1)
		$material_required_issue_list->Recordset->move($material_required_issue_list->StartRec - 1);
} elseif (!$material_required_issue->AllowAddDeleteRow && $material_required_issue_list->StopRec == 0) {
	$material_required_issue_list->StopRec = $material_required_issue->GridAddRowCount;
}

// Initialize aggregate
$material_required_issue->RowType = ROWTYPE_AGGREGATEINIT;
$material_required_issue->resetAttributes();
$material_required_issue_list->renderRow();
while ($material_required_issue_list->RecCnt < $material_required_issue_list->StopRec) {
	$material_required_issue_list->RecCnt++;
	if ($material_required_issue_list->RecCnt >= $material_required_issue_list->StartRec) {
		$material_required_issue_list->RowCnt++;

		// Set up key count
		$material_required_issue_list->KeyCount = $material_required_issue_list->RowIndex;

		// Init row class and style
		$material_required_issue->resetAttributes();
		$material_required_issue->CssClass = "";
		if ($material_required_issue->isGridAdd()) {
		} else {
			$material_required_issue_list->loadRowValues($material_required_issue_list->Recordset); // Load row values
		}
		$material_required_issue->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_required_issue->RowAttrs = array_merge($material_required_issue->RowAttrs, array('data-rowindex'=>$material_required_issue_list->RowCnt, 'id'=>'r' . $material_required_issue_list->RowCnt . '_material_required_issue', 'data-rowtype'=>$material_required_issue->RowType));

		// Render row
		$material_required_issue_list->renderRow();

		// Render list options
		$material_required_issue_list->renderListOptions();
?>
	<tr<?php echo $material_required_issue->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_issue_list->ListOptions->render("body", "left", $material_required_issue_list->RowCnt);
?>
	<?php if ($material_required_issue->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_required_issue->id->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_id" class="material_required_issue_id">
<span<?php echo $material_required_issue->id->viewAttributes() ?>>
<?php echo $material_required_issue->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $material_required_issue->jc_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_jc_no" class="material_required_issue_jc_no">
<span<?php echo $material_required_issue->jc_no->viewAttributes() ?>>
<?php echo $material_required_issue->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->po->Visible) { // po ?>
		<td data-name="po"<?php echo $material_required_issue->po->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_po" class="material_required_issue_po">
<span<?php echo $material_required_issue->po->viewAttributes() ?>>
<?php echo $material_required_issue->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->week->Visible) { // week ?>
		<td data-name="week"<?php echo $material_required_issue->week->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_week" class="material_required_issue_week">
<span<?php echo $material_required_issue->week->viewAttributes() ?>>
<?php echo $material_required_issue->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $material_required_issue->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_buyer_id" class="material_required_issue_buyer_id">
<span<?php echo $material_required_issue->buyer_id->viewAttributes() ?>>
<?php echo $material_required_issue->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->product->Visible) { // product ?>
		<td data-name="product"<?php echo $material_required_issue->product->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_product" class="material_required_issue_product">
<span<?php echo $material_required_issue->product->viewAttributes() ?>>
<?php echo $material_required_issue->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->product_id->Visible) { // product_id ?>
		<td data-name="product_id"<?php echo $material_required_issue->product_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_product_id" class="material_required_issue_product_id">
<span<?php echo $material_required_issue->product_id->viewAttributes() ?>>
<?php echo $material_required_issue->product_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $material_required_issue->batch_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_batch_no" class="material_required_issue_batch_no">
<span<?php echo $material_required_issue->batch_no->viewAttributes() ?>>
<?php echo $material_required_issue->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_required_issue->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_quantity" class="material_required_issue_quantity">
<span<?php echo $material_required_issue->quantity->viewAttributes() ?>>
<?php echo $material_required_issue->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->req_material_sgrp->Visible) { // req_material_sgrp ?>
		<td data-name="req_material_sgrp"<?php echo $material_required_issue->req_material_sgrp->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_req_material_sgrp" class="material_required_issue_req_material_sgrp">
<span<?php echo $material_required_issue->req_material_sgrp->viewAttributes() ?>>
<?php echo $material_required_issue->req_material_sgrp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->req_material_product->Visible) { // req_material_product ?>
		<td data-name="req_material_product"<?php echo $material_required_issue->req_material_product->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_req_material_product" class="material_required_issue_req_material_product">
<span<?php echo $material_required_issue->req_material_product->viewAttributes() ?>>
<?php echo $material_required_issue->req_material_product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $material_required_issue->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_req_material_rid" class="material_required_issue_req_material_rid">
<span<?php echo $material_required_issue->req_material_rid->viewAttributes() ?>>
<?php echo $material_required_issue->req_material_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $material_required_issue->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_req_material_qty" class="material_required_issue_req_material_qty">
<span<?php echo $material_required_issue->req_material_qty->viewAttributes() ?>>
<?php echo $material_required_issue->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty"<?php echo $material_required_issue->material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_material_qty" class="material_required_issue_material_qty">
<span<?php echo $material_required_issue->material_qty->viewAttributes() ?>>
<?php echo $material_required_issue->material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $material_required_issue->unit->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_unit" class="material_required_issue_unit">
<span<?php echo $material_required_issue->unit->viewAttributes() ?>>
<?php echo $material_required_issue->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->method->Visible) { // method ?>
		<td data-name="method"<?php echo $material_required_issue->method->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_method" class="material_required_issue_method">
<span<?php echo $material_required_issue->method->viewAttributes() ?>>
<?php echo $material_required_issue->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $material_required_issue->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_despatch_week" class="material_required_issue_despatch_week">
<span<?php echo $material_required_issue->despatch_week->viewAttributes() ?>>
<?php echo $material_required_issue->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->production_plan->Visible) { // production_plan ?>
		<td data-name="production_plan"<?php echo $material_required_issue->production_plan->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_production_plan" class="material_required_issue_production_plan">
<span<?php echo $material_required_issue->production_plan->viewAttributes() ?>>
<?php echo $material_required_issue->production_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_required_issue->operator->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_operator" class="material_required_issue_operator">
<span<?php echo $material_required_issue->operator->viewAttributes() ?>>
<?php echo $material_required_issue->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $material_required_issue->datetime->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_datetime" class="material_required_issue_datetime">
<span<?php echo $material_required_issue->datetime->viewAttributes() ?>>
<?php echo $material_required_issue->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->material_out->Visible) { // material_out ?>
		<td data-name="material_out"<?php echo $material_required_issue->material_out->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_material_out" class="material_required_issue_material_out">
<span<?php echo $material_required_issue->material_out->viewAttributes() ?>>
<?php echo $material_required_issue->material_out->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $material_required_issue->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_despatch_date" class="material_required_issue_despatch_date">
<span<?php echo $material_required_issue->despatch_date->viewAttributes() ?>>
<?php echo $material_required_issue->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_issue->issue_material_id->Visible) { // issue_material_id ?>
		<td data-name="issue_material_id"<?php echo $material_required_issue->issue_material_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_issue_list->RowCnt ?>_material_required_issue_issue_material_id" class="material_required_issue_issue_material_id">
<span<?php echo $material_required_issue->issue_material_id->viewAttributes() ?>>
<?php echo $material_required_issue->issue_material_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_required_issue_list->ListOptions->render("body", "right", $material_required_issue_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_required_issue->isGridAdd())
		$material_required_issue_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_required_issue->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_required_issue_list->Recordset)
	$material_required_issue_list->Recordset->Close();
?>
<?php if (!$material_required_issue->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_required_issue->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_issue_list->Pager)) $material_required_issue_list->Pager = new PrevNextPager($material_required_issue_list->StartRec, $material_required_issue_list->DisplayRecs, $material_required_issue_list->TotalRecs, $material_required_issue_list->AutoHidePager) ?>
<?php if ($material_required_issue_list->Pager->RecordCount > 0 && $material_required_issue_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_issue_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_issue_list->pageUrl() ?>start=<?php echo $material_required_issue_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_issue_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_issue_list->pageUrl() ?>start=<?php echo $material_required_issue_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_issue_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_issue_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_issue_list->pageUrl() ?>start=<?php echo $material_required_issue_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_issue_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_issue_list->pageUrl() ?>start=<?php echo $material_required_issue_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_issue_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_issue_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_issue_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_issue_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_issue_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_issue_list->TotalRecs > 0 && (!$material_required_issue_list->AutoHidePageSizeSelector || $material_required_issue_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_issue">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_issue_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_issue_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_issue_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_issue_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_issue_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_issue->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_issue_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_required_issue_list->TotalRecs == 0 && !$material_required_issue->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_required_issue_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_required_issue_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_required_issue->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_required_issue->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_required_issue", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_required_issue_list->terminate();
?>