<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_issue_search = new material_required_issue_search();

// Run the page
$material_required_issue_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_issue_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_required_issue_search->IsModal) { ?>
var fmaterial_required_issuesearch = currentAdvancedSearchForm = new ew.Form("fmaterial_required_issuesearch", "search");
<?php } else { ?>
var fmaterial_required_issuesearch = currentForm = new ew.Form("fmaterial_required_issuesearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_required_issuesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_issuesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_issuesearch.lists["x_jc_no"] = <?php echo $material_required_issue_search->jc_no->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_jc_no"].options = <?php echo JsonEncode($material_required_issue_search->jc_no->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_week"] = <?php echo $material_required_issue_search->week->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_week"].options = <?php echo JsonEncode($material_required_issue_search->week->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_buyer_id"] = <?php echo $material_required_issue_search->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_issue_search->buyer_id->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_grp"] = <?php echo $material_required_issue_search->grp->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_grp"].options = <?php echo JsonEncode($material_required_issue_search->grp->options(FALSE, TRUE)) ?>;
fmaterial_required_issuesearch.lists["x_s_grp"] = <?php echo $material_required_issue_search->s_grp->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_s_grp"].options = <?php echo JsonEncode($material_required_issue_search->s_grp->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_product"] = <?php echo $material_required_issue_search->product->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_product"].options = <?php echo JsonEncode($material_required_issue_search->product->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_product_id"] = <?php echo $material_required_issue_search->product_id->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_product_id"].options = <?php echo JsonEncode($material_required_issue_search->product_id->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_req_material_sgrp"] = <?php echo $material_required_issue_search->req_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_req_material_sgrp"].options = <?php echo JsonEncode($material_required_issue_search->req_material_sgrp->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_issue_material_sgrp"] = <?php echo $material_required_issue_search->issue_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_issue_material_sgrp"].options = <?php echo JsonEncode($material_required_issue_search->issue_material_sgrp->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_req_material_product"] = <?php echo $material_required_issue_search->req_material_product->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_req_material_product"].options = <?php echo JsonEncode($material_required_issue_search->req_material_product->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_issue_material_product"] = <?php echo $material_required_issue_search->issue_material_product->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_issue_material_product"].options = <?php echo JsonEncode($material_required_issue_search->issue_material_product->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_req_material_rid"] = <?php echo $material_required_issue_search->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_issue_search->req_material_rid->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_unit"] = <?php echo $material_required_issue_search->unit->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_unit"].options = <?php echo JsonEncode($material_required_issue_search->unit->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_method"] = <?php echo $material_required_issue_search->method->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_method"].options = <?php echo JsonEncode($material_required_issue_search->method->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_despatch_week"] = <?php echo $material_required_issue_search->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_issue_search->despatch_week->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_production_plan"] = <?php echo $material_required_issue_search->production_plan->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_production_plan"].options = <?php echo JsonEncode($material_required_issue_search->production_plan->options(FALSE, TRUE)) ?>;
fmaterial_required_issuesearch.lists["x_operator"] = <?php echo $material_required_issue_search->operator->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_operator"].options = <?php echo JsonEncode($material_required_issue_search->operator->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_material_out"] = <?php echo $material_required_issue_search->material_out->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_material_out"].options = <?php echo JsonEncode($material_required_issue_search->material_out->options(FALSE, TRUE)) ?>;
fmaterial_required_issuesearch.lists["x_material_out_id"] = <?php echo $material_required_issue_search->material_out_id->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_material_out_id"].options = <?php echo JsonEncode($material_required_issue_search->material_out_id->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_req_material_grp"] = <?php echo $material_required_issue_search->req_material_grp->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_req_material_grp"].options = <?php echo JsonEncode($material_required_issue_search->req_material_grp->lookupOptions()) ?>;
fmaterial_required_issuesearch.lists["x_poid"] = <?php echo $material_required_issue_search->poid->Lookup->toClientList() ?>;
fmaterial_required_issuesearch.lists["x_poid"].options = <?php echo JsonEncode($material_required_issue_search->poid->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmaterial_required_issuesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_batch_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->batch_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_material_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->issue_material_rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_req_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->req_material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->issue_material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_updated");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->updated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_to");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->issue_to->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_issue->despatch_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_required_issue_search->showPageHeader(); ?>
<?php
$material_required_issue_search->showMessage();
?>
<form name="fmaterial_required_issuesearch" id="fmaterial_required_issuesearch" class="<?php echo $material_required_issue_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_issue_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_issue_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_issue">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_required_issue_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_required_issue->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_id"><?php echo $material_required_issue->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->id->cellAttributes() ?>>
			<span id="el_material_required_issue_id">
<input type="text" data-table="material_required_issue" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_required_issue->id->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->id->EditValue ?>"<?php echo $material_required_issue->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_jc_no"><?php echo $material_required_issue->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->jc_no->cellAttributes() ?>>
			<span id="el_material_required_issue_jc_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_jc_no" data-value-separator="<?php echo $material_required_issue->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $material_required_issue->jc_no->editAttributes() ?>>
		<?php echo $material_required_issue->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
</div>
<?php echo $material_required_issue->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_po"><?php echo $material_required_issue->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->po->cellAttributes() ?>>
			<span id="el_material_required_issue_po">
<input type="text" data-table="material_required_issue" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->po->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->po->EditValue ?>"<?php echo $material_required_issue->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->week->Visible) { // week ?>
	<div id="r_week" class="form-group row">
		<label for="x_week" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_week"><?php echo $material_required_issue->week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_week" id="z_week" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->week->cellAttributes() ?>>
			<span id="el_material_required_issue_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_week" data-value-separator="<?php echo $material_required_issue->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $material_required_issue->week->editAttributes() ?>>
		<?php echo $material_required_issue->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $material_required_issue->week->Lookup->getParamTag("p_x_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_buyer_id"><?php echo $material_required_issue->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->buyer_id->cellAttributes() ?>>
			<span id="el_material_required_issue_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_buyer_id" data-value-separator="<?php echo $material_required_issue->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $material_required_issue->buyer_id->editAttributes() ?>>
		<?php echo $material_required_issue->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $material_required_issue->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_grp"><?php echo $material_required_issue->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->grp->cellAttributes() ?>>
			<span id="el_material_required_issue_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_grp" data-value-separator="<?php echo $material_required_issue->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_required_issue->grp->editAttributes() ?>>
		<?php echo $material_required_issue->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_s_grp"><?php echo $material_required_issue->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->s_grp->cellAttributes() ?>>
			<span id="el_material_required_issue_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_s_grp" data-value-separator="<?php echo $material_required_issue->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_required_issue->s_grp->editAttributes() ?>>
		<?php echo $material_required_issue->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_required_issue->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_product"><?php echo $material_required_issue->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->product->cellAttributes() ?>>
			<span id="el_material_required_issue_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_product" data-value-separator="<?php echo $material_required_issue->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_required_issue->product->editAttributes() ?>>
		<?php echo $material_required_issue->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_required_issue->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->product_id->Visible) { // product_id ?>
	<div id="r_product_id" class="form-group row">
		<label for="x_product_id" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_product_id"><?php echo $material_required_issue->product_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_id" id="z_product_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->product_id->cellAttributes() ?>>
			<span id="el_material_required_issue_product_id">
<?php $material_required_issue->product_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_issue->product_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_product_id" data-value-separator="<?php echo $material_required_issue->product_id->displayValueSeparatorAttribute() ?>" id="x_product_id" name="x_product_id"<?php echo $material_required_issue->product_id->editAttributes() ?>>
		<?php echo $material_required_issue->product_id->selectOptionListHtml("x_product_id") ?>
	</select>
</div>
<?php echo $material_required_issue->product_id->Lookup->getParamTag("p_x_product_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_batch_no"><?php echo $material_required_issue->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->batch_no->cellAttributes() ?>>
			<span id="el_material_required_issue_batch_no">
<input type="text" data-table="material_required_issue" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->batch_no->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->batch_no->EditValue ?>"<?php echo $material_required_issue->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_quantity"><?php echo $material_required_issue->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->quantity->cellAttributes() ?>>
			<span id="el_material_required_issue_quantity">
<input type="text" data-table="material_required_issue" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->quantity->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->quantity->EditValue ?>"<?php echo $material_required_issue->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<div id="r_req_material_sgrp" class="form-group row">
		<label for="x_req_material_sgrp" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_sgrp"><?php echo $material_required_issue->req_material_sgrp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_sgrp" id="z_req_material_sgrp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->req_material_sgrp->cellAttributes() ?>>
			<span id="el_material_required_issue_req_material_sgrp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_req_material_sgrp" data-value-separator="<?php echo $material_required_issue->req_material_sgrp->displayValueSeparatorAttribute() ?>" id="x_req_material_sgrp" name="x_req_material_sgrp"<?php echo $material_required_issue->req_material_sgrp->editAttributes() ?>>
		<?php echo $material_required_issue->req_material_sgrp->selectOptionListHtml("x_req_material_sgrp") ?>
	</select>
</div>
<?php echo $material_required_issue->req_material_sgrp->Lookup->getParamTag("p_x_req_material_sgrp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->issue_material_sgrp->Visible) { // issue_material_sgrp ?>
	<div id="r_issue_material_sgrp" class="form-group row">
		<label for="x_issue_material_sgrp" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_sgrp"><?php echo $material_required_issue->issue_material_sgrp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_sgrp" id="z_issue_material_sgrp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->issue_material_sgrp->cellAttributes() ?>>
			<span id="el_material_required_issue_issue_material_sgrp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_issue_material_sgrp" data-value-separator="<?php echo $material_required_issue->issue_material_sgrp->displayValueSeparatorAttribute() ?>" id="x_issue_material_sgrp" name="x_issue_material_sgrp"<?php echo $material_required_issue->issue_material_sgrp->editAttributes() ?>>
		<?php echo $material_required_issue->issue_material_sgrp->selectOptionListHtml("x_issue_material_sgrp") ?>
	</select>
</div>
<?php echo $material_required_issue->issue_material_sgrp->Lookup->getParamTag("p_x_issue_material_sgrp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->req_material_product->Visible) { // req_material_product ?>
	<div id="r_req_material_product" class="form-group row">
		<label for="x_req_material_product" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_product"><?php echo $material_required_issue->req_material_product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_product" id="z_req_material_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->req_material_product->cellAttributes() ?>>
			<span id="el_material_required_issue_req_material_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_req_material_product" data-value-separator="<?php echo $material_required_issue->req_material_product->displayValueSeparatorAttribute() ?>" id="x_req_material_product" name="x_req_material_product"<?php echo $material_required_issue->req_material_product->editAttributes() ?>>
		<?php echo $material_required_issue->req_material_product->selectOptionListHtml("x_req_material_product") ?>
	</select>
</div>
<?php echo $material_required_issue->req_material_product->Lookup->getParamTag("p_x_req_material_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->issue_material_product->Visible) { // issue_material_product ?>
	<div id="r_issue_material_product" class="form-group row">
		<label for="x_issue_material_product" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_product"><?php echo $material_required_issue->issue_material_product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_product" id="z_issue_material_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->issue_material_product->cellAttributes() ?>>
			<span id="el_material_required_issue_issue_material_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_issue_material_product" data-value-separator="<?php echo $material_required_issue->issue_material_product->displayValueSeparatorAttribute() ?>" id="x_issue_material_product" name="x_issue_material_product"<?php echo $material_required_issue->issue_material_product->editAttributes() ?>>
		<?php echo $material_required_issue->issue_material_product->selectOptionListHtml("x_issue_material_product") ?>
	</select>
</div>
<?php echo $material_required_issue->issue_material_product->Lookup->getParamTag("p_x_issue_material_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->req_material_rid->Visible) { // req_material_rid ?>
	<div id="r_req_material_rid" class="form-group row">
		<label for="x_req_material_rid" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_rid"><?php echo $material_required_issue->req_material_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->req_material_rid->cellAttributes() ?>>
			<span id="el_material_required_issue_req_material_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_req_material_rid" data-value-separator="<?php echo $material_required_issue->req_material_rid->displayValueSeparatorAttribute() ?>" id="x_req_material_rid" name="x_req_material_rid"<?php echo $material_required_issue->req_material_rid->editAttributes() ?>>
		<?php echo $material_required_issue->req_material_rid->selectOptionListHtml("x_req_material_rid") ?>
	</select>
</div>
<?php echo $material_required_issue->req_material_rid->Lookup->getParamTag("p_x_req_material_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->issue_material_rid->Visible) { // issue_material_rid ?>
	<div id="r_issue_material_rid" class="form-group row">
		<label for="x_issue_material_rid" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_rid"><?php echo $material_required_issue->issue_material_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_rid" id="z_issue_material_rid" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->issue_material_rid->cellAttributes() ?>>
			<span id="el_material_required_issue_issue_material_rid">
<input type="text" data-table="material_required_issue" data-field="x_issue_material_rid" name="x_issue_material_rid" id="x_issue_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->issue_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->issue_material_rid->EditValue ?>"<?php echo $material_required_issue->issue_material_rid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->req_material_qty->Visible) { // req_material_qty ?>
	<div id="r_req_material_qty" class="form-group row">
		<label for="x_req_material_qty" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_qty"><?php echo $material_required_issue->req_material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_qty" id="z_req_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->req_material_qty->cellAttributes() ?>>
			<span id="el_material_required_issue_req_material_qty">
<input type="text" data-table="material_required_issue" data-field="x_req_material_qty" name="x_req_material_qty" id="x_req_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->req_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->req_material_qty->EditValue ?>"<?php echo $material_required_issue->req_material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->issue_material_qty->Visible) { // issue_material_qty ?>
	<div id="r_issue_material_qty" class="form-group row">
		<label for="x_issue_material_qty" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_qty"><?php echo $material_required_issue->issue_material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_qty" id="z_issue_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->issue_material_qty->cellAttributes() ?>>
			<span id="el_material_required_issue_issue_material_qty">
<input type="text" data-table="material_required_issue" data-field="x_issue_material_qty" name="x_issue_material_qty" id="x_issue_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->issue_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->issue_material_qty->EditValue ?>"<?php echo $material_required_issue->issue_material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->material_qty->Visible) { // material_qty ?>
	<div id="r_material_qty" class="form-group row">
		<label for="x_material_qty" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_material_qty"><?php echo $material_required_issue->material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_qty" id="z_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->material_qty->cellAttributes() ?>>
			<span id="el_material_required_issue_material_qty">
<input type="text" data-table="material_required_issue" data-field="x_material_qty" name="x_material_qty" id="x_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->material_qty->EditValue ?>"<?php echo $material_required_issue->material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_unit"><?php echo $material_required_issue->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_unit" id="z_unit" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->unit->cellAttributes() ?>>
			<span id="el_material_required_issue_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_unit" data-value-separator="<?php echo $material_required_issue->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $material_required_issue->unit->editAttributes() ?>>
		<?php echo $material_required_issue->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $material_required_issue->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_method"><?php echo $material_required_issue->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->method->cellAttributes() ?>>
			<span id="el_material_required_issue_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_method" data-value-separator="<?php echo $material_required_issue->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $material_required_issue->method->editAttributes() ?>>
		<?php echo $material_required_issue->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $material_required_issue->method->Lookup->getParamTag("p_x_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_despatch_week"><?php echo $material_required_issue->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->despatch_week->cellAttributes() ?>>
			<span id="el_material_required_issue_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_despatch_week" data-value-separator="<?php echo $material_required_issue->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $material_required_issue->despatch_week->editAttributes() ?>>
		<?php echo $material_required_issue->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $material_required_issue->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_production_plan"><?php echo $material_required_issue->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->production_plan->cellAttributes() ?>>
			<span id="el_material_required_issue_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_production_plan" data-value-separator="<?php echo $material_required_issue->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $material_required_issue->production_plan->editAttributes() ?>>
		<?php echo $material_required_issue->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_remarks"><?php echo $material_required_issue->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->remarks->cellAttributes() ?>>
			<span id="el_material_required_issue_remarks">
<input type="text" data-table="material_required_issue" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($material_required_issue->remarks->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->remarks->EditValue ?>"<?php echo $material_required_issue->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_operator"><?php echo $material_required_issue->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->operator->cellAttributes() ?>>
			<span id="el_material_required_issue_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_operator" data-value-separator="<?php echo $material_required_issue->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $material_required_issue->operator->editAttributes() ?>>
		<?php echo $material_required_issue->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $material_required_issue->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_datetime"><?php echo $material_required_issue->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->datetime->cellAttributes() ?>>
			<span id="el_material_required_issue_datetime">
<input type="text" data-table="material_required_issue" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($material_required_issue->datetime->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->datetime->EditValue ?>"<?php echo $material_required_issue->datetime->editAttributes() ?>>
<?php if (!$material_required_issue->datetime->ReadOnly && !$material_required_issue->datetime->Disabled && !isset($material_required_issue->datetime->EditAttrs["readonly"]) && !isset($material_required_issue->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_issuesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->material_out->Visible) { // material_out ?>
	<div id="r_material_out" class="form-group row">
		<label class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_material_out"><?php echo $material_required_issue->material_out->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_out" id="z_material_out" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->material_out->cellAttributes() ?>>
			<span id="el_material_required_issue_material_out">
<div id="tp_x_material_out" class="ew-template"><input type="radio" class="form-check-input" data-table="material_required_issue" data-field="x_material_out" data-value-separator="<?php echo $material_required_issue->material_out->displayValueSeparatorAttribute() ?>" name="x_material_out" id="x_material_out" value="{value}"<?php echo $material_required_issue->material_out->editAttributes() ?>></div>
<div id="dsl_x_material_out" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_required_issue->material_out->radioButtonListHtml(FALSE, "x_material_out") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->material_out_id->Visible) { // material_out_id ?>
	<div id="r_material_out_id" class="form-group row">
		<label for="x_material_out_id" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_material_out_id"><?php echo $material_required_issue->material_out_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_out_id" id="z_material_out_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->material_out_id->cellAttributes() ?>>
			<span id="el_material_required_issue_material_out_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_material_out_id" data-value-separator="<?php echo $material_required_issue->material_out_id->displayValueSeparatorAttribute() ?>" id="x_material_out_id" name="x_material_out_id"<?php echo $material_required_issue->material_out_id->editAttributes() ?>>
		<?php echo $material_required_issue->material_out_id->selectOptionListHtml("x_material_out_id") ?>
	</select>
</div>
<?php echo $material_required_issue->material_out_id->Lookup->getParamTag("p_x_material_out_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->size_wl->Visible) { // size_wl ?>
	<div id="r_size_wl" class="form-group row">
		<label for="x_size_wl" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_size_wl"><?php echo $material_required_issue->size_wl->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_wl" id="z_size_wl" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->size_wl->cellAttributes() ?>>
			<span id="el_material_required_issue_size_wl">
<input type="text" data-table="material_required_issue" data-field="x_size_wl" name="x_size_wl" id="x_size_wl" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($material_required_issue->size_wl->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->size_wl->EditValue ?>"<?php echo $material_required_issue->size_wl->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_sqm"><?php echo $material_required_issue->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->sqm->cellAttributes() ?>>
			<span id="el_material_required_issue_sqm">
<input type="text" data-table="material_required_issue" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->sqm->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->sqm->EditValue ?>"<?php echo $material_required_issue->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->req_material_grp->Visible) { // req_material_grp ?>
	<div id="r_req_material_grp" class="form-group row">
		<label for="x_req_material_grp" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_req_material_grp"><?php echo $material_required_issue->req_material_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_grp" id="z_req_material_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->req_material_grp->cellAttributes() ?>>
			<span id="el_material_required_issue_req_material_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_req_material_grp" data-value-separator="<?php echo $material_required_issue->req_material_grp->displayValueSeparatorAttribute() ?>" id="x_req_material_grp" name="x_req_material_grp"<?php echo $material_required_issue->req_material_grp->editAttributes() ?>>
		<?php echo $material_required_issue->req_material_grp->selectOptionListHtml("x_req_material_grp") ?>
	</select>
</div>
<?php echo $material_required_issue->req_material_grp->Lookup->getParamTag("p_x_req_material_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->issue_material_grp->Visible) { // issue_material_grp ?>
	<div id="r_issue_material_grp" class="form-group row">
		<label for="x_issue_material_grp" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_grp"><?php echo $material_required_issue->issue_material_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_grp" id="z_issue_material_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->issue_material_grp->cellAttributes() ?>>
			<span id="el_material_required_issue_issue_material_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_issue_material_grp" data-value-separator="<?php echo $material_required_issue->issue_material_grp->displayValueSeparatorAttribute() ?>" id="x_issue_material_grp" name="x_issue_material_grp"<?php echo $material_required_issue->issue_material_grp->editAttributes() ?>>
		<?php echo $material_required_issue->issue_material_grp->selectOptionListHtml("x_issue_material_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->updated->Visible) { // updated ?>
	<div id="r_updated" class="form-group row">
		<label for="x_updated" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_updated"><?php echo $material_required_issue->updated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_updated" id="z_updated" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->updated->cellAttributes() ?>>
			<span id="el_material_required_issue_updated">
<input type="text" data-table="material_required_issue" data-field="x_updated" name="x_updated" id="x_updated" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->updated->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->updated->EditValue ?>"<?php echo $material_required_issue->updated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label for="x_poid" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_poid"><?php echo $material_required_issue->poid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_poid" id="z_poid" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->poid->cellAttributes() ?>>
			<span id="el_material_required_issue_poid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_issue" data-field="x_poid" data-value-separator="<?php echo $material_required_issue->poid->displayValueSeparatorAttribute() ?>" id="x_poid" name="x_poid"<?php echo $material_required_issue->poid->editAttributes() ?>>
		<?php echo $material_required_issue->poid->selectOptionListHtml("x_poid") ?>
	</select>
</div>
<?php echo $material_required_issue->poid->Lookup->getParamTag("p_x_poid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label for="x_issue_to" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_to"><?php echo $material_required_issue->issue_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->issue_to->cellAttributes() ?>>
			<span id="el_material_required_issue_issue_to">
<input type="text" data-table="material_required_issue" data-field="x_issue_to" name="x_issue_to" id="x_issue_to" size="30" placeholder="<?php echo HtmlEncode($material_required_issue->issue_to->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->issue_to->EditValue ?>"<?php echo $material_required_issue->issue_to->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_despatch_date"><?php echo $material_required_issue->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->despatch_date->cellAttributes() ?>>
			<span id="el_material_required_issue_despatch_date">
<input type="text" data-table="material_required_issue" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($material_required_issue->despatch_date->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->despatch_date->EditValue ?>"<?php echo $material_required_issue->despatch_date->editAttributes() ?>>
<?php if (!$material_required_issue->despatch_date->ReadOnly && !$material_required_issue->despatch_date->Disabled && !isset($material_required_issue->despatch_date->EditAttrs["readonly"]) && !isset($material_required_issue->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_issuesearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_issue->issue_material_id->Visible) { // issue_material_id ?>
	<div id="r_issue_material_id" class="form-group row">
		<label for="x_issue_material_id" class="<?php echo $material_required_issue_search->LeftColumnClass ?>"><span id="elh_material_required_issue_issue_material_id"><?php echo $material_required_issue->issue_material_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_issue_material_id" id="z_issue_material_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_issue_search->RightColumnClass ?>"><div<?php echo $material_required_issue->issue_material_id->cellAttributes() ?>>
			<span id="el_material_required_issue_issue_material_id">
<input type="text" data-table="material_required_issue" data-field="x_issue_material_id" name="x_issue_material_id" id="x_issue_material_id" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($material_required_issue->issue_material_id->getPlaceHolder()) ?>" value="<?php echo $material_required_issue->issue_material_id->EditValue ?>"<?php echo $material_required_issue->issue_material_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_required_issue_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_required_issue_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_required_issue_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_required_issue_search->terminate();
?>