<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_job_card_add = new material_required_job_card_add();

// Run the page
$material_required_job_card_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_job_card_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fmaterial_required_job_cardadd = currentForm = new ew.Form("fmaterial_required_job_cardadd", "add");

// Validate form
fmaterial_required_job_cardadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($material_required_job_card_add->poid->Required) { ?>
			elm = this.getElements("x" + infix + "_poid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->poid->caption(), $material_required_job_card->poid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_poid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->poid->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->jc_no->caption(), $material_required_job_card->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->jc_no->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->location->caption(), $material_required_job_card->location->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->location->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->issue_to->caption(), $material_required_job_card->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->issue_to->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->week->Required) { ?>
			elm = this.getElements("x" + infix + "_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->week->caption(), $material_required_job_card->week->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_week");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->week->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->po->caption(), $material_required_job_card->po->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->po->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->buyer_id->caption(), $material_required_job_card->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->buyer_id->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->grp->caption(), $material_required_job_card->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->grp->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->s_grp->caption(), $material_required_job_card->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->s_grp->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->product->caption(), $material_required_job_card->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->product->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->product_id->Required) { ?>
			elm = this.getElements("x" + infix + "_product_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->product_id->caption(), $material_required_job_card->product_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->product_id->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->batch_no->caption(), $material_required_job_card->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->batch_no->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->quantity->caption(), $material_required_job_card->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->quantity->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->size_cm->Required) { ?>
			elm = this.getElements("x" + infix + "_size_cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->size_cm->caption(), $material_required_job_card->size_cm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_job_card_add->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->sqm->caption(), $material_required_job_card->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->sqm->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->t_sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_t_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->t_sqm->caption(), $material_required_job_card->t_sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_t_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->t_sqm->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->req_material_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->req_material_grp->caption(), $material_required_job_card->req_material_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_req_material_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->req_material_grp->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->req_material_sgrp->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_sgrp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->req_material_sgrp->caption(), $material_required_job_card->req_material_sgrp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_req_material_sgrp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->req_material_sgrp->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->req_material_product->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->req_material_product->caption(), $material_required_job_card->req_material_product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_req_material_product");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->req_material_product->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->req_material_rid->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->req_material_rid->caption(), $material_required_job_card->req_material_rid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_req_material_rid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->req_material_rid->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->req_material_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->req_material_qty->caption(), $material_required_job_card->req_material_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_req_material_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->req_material_qty->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->req_material_packing->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_packing");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->req_material_packing->caption(), $material_required_job_card->req_material_packing->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_req_material_packing");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->req_material_packing->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->stock->Required) { ?>
			elm = this.getElements("x" + infix + "_stock");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->stock->caption(), $material_required_job_card->stock->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_stock");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->stock->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->short->Required) { ?>
			elm = this.getElements("x" + infix + "_short");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->short->caption(), $material_required_job_card->short->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_short");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->short->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->unit->caption(), $material_required_job_card->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_job_card_add->material_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_material_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->material_qty->caption(), $material_required_job_card->material_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_material_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->material_qty->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->method->Required) { ?>
			elm = this.getElements("x" + infix + "_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->method->caption(), $material_required_job_card->method->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_method");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->method->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->despatch_week->caption(), $material_required_job_card->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->despatch_week->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->despatch_date->caption(), $material_required_job_card->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->despatch_date->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->production_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->production_plan->caption(), $material_required_job_card->production_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->production_plan->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->remarks->caption(), $material_required_job_card->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_job_card_add->updated->Required) { ?>
			elm = this.getElements("x" + infix + "_updated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->updated->caption(), $material_required_job_card->updated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_updated");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->updated->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->operator->caption(), $material_required_job_card->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->operator->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->datetime->caption(), $material_required_job_card->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->datetime->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->jc_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->jc_datetime->caption(), $material_required_job_card->jc_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_jc_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->jc_datetime->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->company_id->caption(), $material_required_job_card->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->company_id->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->m_out_id->Required) { ?>
			elm = this.getElements("x" + infix + "_m_out_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->m_out_id->caption(), $material_required_job_card->m_out_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_job_card_add->issued_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_issued_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->issued_qty->caption(), $material_required_job_card->issued_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_issued_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->issued_qty->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->pending_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_pending_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->pending_qty->caption(), $material_required_job_card->pending_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pending_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_job_card->pending_qty->errorMessage()) ?>");
		<?php if ($material_required_job_card_add->m_out_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_m_out_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_job_card->m_out_remarks->caption(), $material_required_job_card->m_out_remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmaterial_required_job_cardadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_job_cardadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_required_job_card_add->showPageHeader(); ?>
<?php
$material_required_job_card_add->showMessage();
?>
<form name="fmaterial_required_job_cardadd" id="fmaterial_required_job_cardadd" class="<?php echo $material_required_job_card_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_job_card_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_job_card_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_job_card">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$material_required_job_card_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($material_required_job_card->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label id="elh_material_required_job_card_poid" for="x_poid" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->poid->caption() ?><?php echo ($material_required_job_card->poid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->poid->cellAttributes() ?>>
<span id="el_material_required_job_card_poid">
<input type="text" data-table="material_required_job_card" data-field="x_poid" name="x_poid" id="x_poid" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->poid->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->poid->EditValue ?>"<?php echo $material_required_job_card->poid->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->poid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_material_required_job_card_jc_no" for="x_jc_no" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->jc_no->caption() ?><?php echo ($material_required_job_card->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->jc_no->cellAttributes() ?>>
<span id="el_material_required_job_card_jc_no">
<input type="text" data-table="material_required_job_card" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->jc_no->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->jc_no->EditValue ?>"<?php echo $material_required_job_card->jc_no->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_material_required_job_card_location" for="x_location" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->location->caption() ?><?php echo ($material_required_job_card->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->location->cellAttributes() ?>>
<span id="el_material_required_job_card_location">
<input type="text" data-table="material_required_job_card" data-field="x_location" name="x_location" id="x_location" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->location->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->location->EditValue ?>"<?php echo $material_required_job_card->location->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_material_required_job_card_issue_to" for="x_issue_to" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->issue_to->caption() ?><?php echo ($material_required_job_card->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->issue_to->cellAttributes() ?>>
<span id="el_material_required_job_card_issue_to">
<input type="text" data-table="material_required_job_card" data-field="x_issue_to" name="x_issue_to" id="x_issue_to" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->issue_to->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->issue_to->EditValue ?>"<?php echo $material_required_job_card->issue_to->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->week->Visible) { // week ?>
	<div id="r_week" class="form-group row">
		<label id="elh_material_required_job_card_week" for="x_week" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->week->caption() ?><?php echo ($material_required_job_card->week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->week->cellAttributes() ?>>
<span id="el_material_required_job_card_week">
<input type="text" data-table="material_required_job_card" data-field="x_week" name="x_week" id="x_week" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->week->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->week->EditValue ?>"<?php echo $material_required_job_card->week->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_material_required_job_card_po" for="x_po" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->po->caption() ?><?php echo ($material_required_job_card->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->po->cellAttributes() ?>>
<span id="el_material_required_job_card_po">
<input type="text" data-table="material_required_job_card" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->po->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->po->EditValue ?>"<?php echo $material_required_job_card->po->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_material_required_job_card_buyer_id" for="x_buyer_id" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->buyer_id->caption() ?><?php echo ($material_required_job_card->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->buyer_id->cellAttributes() ?>>
<span id="el_material_required_job_card_buyer_id">
<input type="text" data-table="material_required_job_card" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->buyer_id->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->buyer_id->EditValue ?>"<?php echo $material_required_job_card->buyer_id->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_material_required_job_card_grp" for="x_grp" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->grp->caption() ?><?php echo ($material_required_job_card->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->grp->cellAttributes() ?>>
<span id="el_material_required_job_card_grp">
<input type="text" data-table="material_required_job_card" data-field="x_grp" name="x_grp" id="x_grp" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->grp->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->grp->EditValue ?>"<?php echo $material_required_job_card->grp->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_material_required_job_card_s_grp" for="x_s_grp" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->s_grp->caption() ?><?php echo ($material_required_job_card->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->s_grp->cellAttributes() ?>>
<span id="el_material_required_job_card_s_grp">
<input type="text" data-table="material_required_job_card" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->s_grp->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->s_grp->EditValue ?>"<?php echo $material_required_job_card->s_grp->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_material_required_job_card_product" for="x_product" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->product->caption() ?><?php echo ($material_required_job_card->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->product->cellAttributes() ?>>
<span id="el_material_required_job_card_product">
<input type="text" data-table="material_required_job_card" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->product->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->product->EditValue ?>"<?php echo $material_required_job_card->product->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->product_id->Visible) { // product_id ?>
	<div id="r_product_id" class="form-group row">
		<label id="elh_material_required_job_card_product_id" for="x_product_id" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->product_id->caption() ?><?php echo ($material_required_job_card->product_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->product_id->cellAttributes() ?>>
<span id="el_material_required_job_card_product_id">
<input type="text" data-table="material_required_job_card" data-field="x_product_id" name="x_product_id" id="x_product_id" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->product_id->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->product_id->EditValue ?>"<?php echo $material_required_job_card->product_id->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->product_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_material_required_job_card_batch_no" for="x_batch_no" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->batch_no->caption() ?><?php echo ($material_required_job_card->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->batch_no->cellAttributes() ?>>
<span id="el_material_required_job_card_batch_no">
<input type="text" data-table="material_required_job_card" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->batch_no->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->batch_no->EditValue ?>"<?php echo $material_required_job_card->batch_no->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_material_required_job_card_quantity" for="x_quantity" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->quantity->caption() ?><?php echo ($material_required_job_card->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->quantity->cellAttributes() ?>>
<span id="el_material_required_job_card_quantity">
<input type="text" data-table="material_required_job_card" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->quantity->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->quantity->EditValue ?>"<?php echo $material_required_job_card->quantity->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label id="elh_material_required_job_card_size_cm" for="x_size_cm" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->size_cm->caption() ?><?php echo ($material_required_job_card->size_cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->size_cm->cellAttributes() ?>>
<span id="el_material_required_job_card_size_cm">
<input type="text" data-table="material_required_job_card" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($material_required_job_card->size_cm->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->size_cm->EditValue ?>"<?php echo $material_required_job_card->size_cm->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->size_cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_material_required_job_card_sqm" for="x_sqm" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->sqm->caption() ?><?php echo ($material_required_job_card->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->sqm->cellAttributes() ?>>
<span id="el_material_required_job_card_sqm">
<input type="text" data-table="material_required_job_card" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->sqm->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->sqm->EditValue ?>"<?php echo $material_required_job_card->sqm->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->t_sqm->Visible) { // t_sqm ?>
	<div id="r_t_sqm" class="form-group row">
		<label id="elh_material_required_job_card_t_sqm" for="x_t_sqm" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->t_sqm->caption() ?><?php echo ($material_required_job_card->t_sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->t_sqm->cellAttributes() ?>>
<span id="el_material_required_job_card_t_sqm">
<input type="text" data-table="material_required_job_card" data-field="x_t_sqm" name="x_t_sqm" id="x_t_sqm" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->t_sqm->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->t_sqm->EditValue ?>"<?php echo $material_required_job_card->t_sqm->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->t_sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->req_material_grp->Visible) { // req_material_grp ?>
	<div id="r_req_material_grp" class="form-group row">
		<label id="elh_material_required_job_card_req_material_grp" for="x_req_material_grp" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->req_material_grp->caption() ?><?php echo ($material_required_job_card->req_material_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->req_material_grp->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_grp">
<input type="text" data-table="material_required_job_card" data-field="x_req_material_grp" name="x_req_material_grp" id="x_req_material_grp" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->req_material_grp->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->req_material_grp->EditValue ?>"<?php echo $material_required_job_card->req_material_grp->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->req_material_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<div id="r_req_material_sgrp" class="form-group row">
		<label id="elh_material_required_job_card_req_material_sgrp" for="x_req_material_sgrp" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->req_material_sgrp->caption() ?><?php echo ($material_required_job_card->req_material_sgrp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->req_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_sgrp">
<input type="text" data-table="material_required_job_card" data-field="x_req_material_sgrp" name="x_req_material_sgrp" id="x_req_material_sgrp" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->req_material_sgrp->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->req_material_sgrp->EditValue ?>"<?php echo $material_required_job_card->req_material_sgrp->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->req_material_sgrp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->req_material_product->Visible) { // req_material_product ?>
	<div id="r_req_material_product" class="form-group row">
		<label id="elh_material_required_job_card_req_material_product" for="x_req_material_product" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->req_material_product->caption() ?><?php echo ($material_required_job_card->req_material_product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->req_material_product->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_product">
<input type="text" data-table="material_required_job_card" data-field="x_req_material_product" name="x_req_material_product" id="x_req_material_product" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->req_material_product->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->req_material_product->EditValue ?>"<?php echo $material_required_job_card->req_material_product->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->req_material_product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->req_material_rid->Visible) { // req_material_rid ?>
	<div id="r_req_material_rid" class="form-group row">
		<label id="elh_material_required_job_card_req_material_rid" for="x_req_material_rid" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->req_material_rid->caption() ?><?php echo ($material_required_job_card->req_material_rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->req_material_rid->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_rid">
<input type="text" data-table="material_required_job_card" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->req_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->req_material_rid->EditValue ?>"<?php echo $material_required_job_card->req_material_rid->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->req_material_rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->req_material_qty->Visible) { // req_material_qty ?>
	<div id="r_req_material_qty" class="form-group row">
		<label id="elh_material_required_job_card_req_material_qty" for="x_req_material_qty" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->req_material_qty->caption() ?><?php echo ($material_required_job_card->req_material_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->req_material_qty->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_qty">
<input type="text" data-table="material_required_job_card" data-field="x_req_material_qty" name="x_req_material_qty" id="x_req_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->req_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->req_material_qty->EditValue ?>"<?php echo $material_required_job_card->req_material_qty->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->req_material_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->req_material_packing->Visible) { // req_material_packing ?>
	<div id="r_req_material_packing" class="form-group row">
		<label id="elh_material_required_job_card_req_material_packing" for="x_req_material_packing" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->req_material_packing->caption() ?><?php echo ($material_required_job_card->req_material_packing->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->req_material_packing->cellAttributes() ?>>
<span id="el_material_required_job_card_req_material_packing">
<input type="text" data-table="material_required_job_card" data-field="x_req_material_packing" name="x_req_material_packing" id="x_req_material_packing" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->req_material_packing->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->req_material_packing->EditValue ?>"<?php echo $material_required_job_card->req_material_packing->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->req_material_packing->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->stock->Visible) { // stock ?>
	<div id="r_stock" class="form-group row">
		<label id="elh_material_required_job_card_stock" for="x_stock" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->stock->caption() ?><?php echo ($material_required_job_card->stock->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->stock->cellAttributes() ?>>
<span id="el_material_required_job_card_stock">
<input type="text" data-table="material_required_job_card" data-field="x_stock" name="x_stock" id="x_stock" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->stock->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->stock->EditValue ?>"<?php echo $material_required_job_card->stock->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->stock->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->short->Visible) { // short ?>
	<div id="r_short" class="form-group row">
		<label id="elh_material_required_job_card_short" for="x_short" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->short->caption() ?><?php echo ($material_required_job_card->short->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->short->cellAttributes() ?>>
<span id="el_material_required_job_card_short">
<input type="text" data-table="material_required_job_card" data-field="x_short" name="x_short" id="x_short" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->short->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->short->EditValue ?>"<?php echo $material_required_job_card->short->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->short->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label id="elh_material_required_job_card_unit" for="x_unit" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->unit->caption() ?><?php echo ($material_required_job_card->unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->unit->cellAttributes() ?>>
<span id="el_material_required_job_card_unit">
<input type="text" data-table="material_required_job_card" data-field="x_unit" name="x_unit" id="x_unit" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($material_required_job_card->unit->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->unit->EditValue ?>"<?php echo $material_required_job_card->unit->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->material_qty->Visible) { // material_qty ?>
	<div id="r_material_qty" class="form-group row">
		<label id="elh_material_required_job_card_material_qty" for="x_material_qty" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->material_qty->caption() ?><?php echo ($material_required_job_card->material_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->material_qty->cellAttributes() ?>>
<span id="el_material_required_job_card_material_qty">
<input type="text" data-table="material_required_job_card" data-field="x_material_qty" name="x_material_qty" id="x_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->material_qty->EditValue ?>"<?php echo $material_required_job_card->material_qty->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->material_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label id="elh_material_required_job_card_method" for="x_method" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->method->caption() ?><?php echo ($material_required_job_card->method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->method->cellAttributes() ?>>
<span id="el_material_required_job_card_method">
<input type="text" data-table="material_required_job_card" data-field="x_method" name="x_method" id="x_method" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->method->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->method->EditValue ?>"<?php echo $material_required_job_card->method->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_material_required_job_card_despatch_week" for="x_despatch_week" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->despatch_week->caption() ?><?php echo ($material_required_job_card->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->despatch_week->cellAttributes() ?>>
<span id="el_material_required_job_card_despatch_week">
<input type="text" data-table="material_required_job_card" data-field="x_despatch_week" name="x_despatch_week" id="x_despatch_week" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->despatch_week->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->despatch_week->EditValue ?>"<?php echo $material_required_job_card->despatch_week->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_material_required_job_card_despatch_date" for="x_despatch_date" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->despatch_date->caption() ?><?php echo ($material_required_job_card->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->despatch_date->cellAttributes() ?>>
<span id="el_material_required_job_card_despatch_date">
<input type="text" data-table="material_required_job_card" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($material_required_job_card->despatch_date->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->despatch_date->EditValue ?>"<?php echo $material_required_job_card->despatch_date->editAttributes() ?>>
<?php if (!$material_required_job_card->despatch_date->ReadOnly && !$material_required_job_card->despatch_date->Disabled && !isset($material_required_job_card->despatch_date->EditAttrs["readonly"]) && !isset($material_required_job_card->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_job_cardadd", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_required_job_card->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label id="elh_material_required_job_card_production_plan" for="x_production_plan" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->production_plan->caption() ?><?php echo ($material_required_job_card->production_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->production_plan->cellAttributes() ?>>
<span id="el_material_required_job_card_production_plan">
<input type="text" data-table="material_required_job_card" data-field="x_production_plan" name="x_production_plan" id="x_production_plan" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->production_plan->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->production_plan->EditValue ?>"<?php echo $material_required_job_card->production_plan->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->production_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_material_required_job_card_remarks" for="x_remarks" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->remarks->caption() ?><?php echo ($material_required_job_card->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->remarks->cellAttributes() ?>>
<span id="el_material_required_job_card_remarks">
<textarea data-table="material_required_job_card" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($material_required_job_card->remarks->getPlaceHolder()) ?>"<?php echo $material_required_job_card->remarks->editAttributes() ?>><?php echo $material_required_job_card->remarks->EditValue ?></textarea>
</span>
<?php echo $material_required_job_card->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->updated->Visible) { // updated ?>
	<div id="r_updated" class="form-group row">
		<label id="elh_material_required_job_card_updated" for="x_updated" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->updated->caption() ?><?php echo ($material_required_job_card->updated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->updated->cellAttributes() ?>>
<span id="el_material_required_job_card_updated">
<input type="text" data-table="material_required_job_card" data-field="x_updated" name="x_updated" id="x_updated" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->updated->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->updated->EditValue ?>"<?php echo $material_required_job_card->updated->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->updated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_material_required_job_card_operator" for="x_operator" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->operator->caption() ?><?php echo ($material_required_job_card->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->operator->cellAttributes() ?>>
<span id="el_material_required_job_card_operator">
<input type="text" data-table="material_required_job_card" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->operator->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->operator->EditValue ?>"<?php echo $material_required_job_card->operator->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_material_required_job_card_datetime" for="x_datetime" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->datetime->caption() ?><?php echo ($material_required_job_card->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->datetime->cellAttributes() ?>>
<span id="el_material_required_job_card_datetime">
<input type="text" data-table="material_required_job_card" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($material_required_job_card->datetime->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->datetime->EditValue ?>"<?php echo $material_required_job_card->datetime->editAttributes() ?>>
<?php if (!$material_required_job_card->datetime->ReadOnly && !$material_required_job_card->datetime->Disabled && !isset($material_required_job_card->datetime->EditAttrs["readonly"]) && !isset($material_required_job_card->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_job_cardadd", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_required_job_card->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->jc_datetime->Visible) { // jc_datetime ?>
	<div id="r_jc_datetime" class="form-group row">
		<label id="elh_material_required_job_card_jc_datetime" for="x_jc_datetime" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->jc_datetime->caption() ?><?php echo ($material_required_job_card->jc_datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->jc_datetime->cellAttributes() ?>>
<span id="el_material_required_job_card_jc_datetime">
<input type="text" data-table="material_required_job_card" data-field="x_jc_datetime" name="x_jc_datetime" id="x_jc_datetime" placeholder="<?php echo HtmlEncode($material_required_job_card->jc_datetime->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->jc_datetime->EditValue ?>"<?php echo $material_required_job_card->jc_datetime->editAttributes() ?>>
<?php if (!$material_required_job_card->jc_datetime->ReadOnly && !$material_required_job_card->jc_datetime->Disabled && !isset($material_required_job_card->jc_datetime->EditAttrs["readonly"]) && !isset($material_required_job_card->jc_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_job_cardadd", "x_jc_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_required_job_card->jc_datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_material_required_job_card_company_id" for="x_company_id" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->company_id->caption() ?><?php echo ($material_required_job_card->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->company_id->cellAttributes() ?>>
<span id="el_material_required_job_card_company_id">
<input type="text" data-table="material_required_job_card" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->company_id->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->company_id->EditValue ?>"<?php echo $material_required_job_card->company_id->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->m_out_id->Visible) { // m_out_id ?>
	<div id="r_m_out_id" class="form-group row">
		<label id="elh_material_required_job_card_m_out_id" for="x_m_out_id" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->m_out_id->caption() ?><?php echo ($material_required_job_card->m_out_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->m_out_id->cellAttributes() ?>>
<span id="el_material_required_job_card_m_out_id">
<input type="text" data-table="material_required_job_card" data-field="x_m_out_id" name="x_m_out_id" id="x_m_out_id" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($material_required_job_card->m_out_id->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->m_out_id->EditValue ?>"<?php echo $material_required_job_card->m_out_id->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->m_out_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->issued_qty->Visible) { // issued_qty ?>
	<div id="r_issued_qty" class="form-group row">
		<label id="elh_material_required_job_card_issued_qty" for="x_issued_qty" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->issued_qty->caption() ?><?php echo ($material_required_job_card->issued_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->issued_qty->cellAttributes() ?>>
<span id="el_material_required_job_card_issued_qty">
<input type="text" data-table="material_required_job_card" data-field="x_issued_qty" name="x_issued_qty" id="x_issued_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->issued_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->issued_qty->EditValue ?>"<?php echo $material_required_job_card->issued_qty->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->issued_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->pending_qty->Visible) { // pending_qty ?>
	<div id="r_pending_qty" class="form-group row">
		<label id="elh_material_required_job_card_pending_qty" for="x_pending_qty" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->pending_qty->caption() ?><?php echo ($material_required_job_card->pending_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->pending_qty->cellAttributes() ?>>
<span id="el_material_required_job_card_pending_qty">
<input type="text" data-table="material_required_job_card" data-field="x_pending_qty" name="x_pending_qty" id="x_pending_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_job_card->pending_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->pending_qty->EditValue ?>"<?php echo $material_required_job_card->pending_qty->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->pending_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_job_card->m_out_remarks->Visible) { // m_out_remarks ?>
	<div id="r_m_out_remarks" class="form-group row">
		<label id="elh_material_required_job_card_m_out_remarks" for="x_m_out_remarks" class="<?php echo $material_required_job_card_add->LeftColumnClass ?>"><?php echo $material_required_job_card->m_out_remarks->caption() ?><?php echo ($material_required_job_card->m_out_remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_job_card_add->RightColumnClass ?>"><div<?php echo $material_required_job_card->m_out_remarks->cellAttributes() ?>>
<span id="el_material_required_job_card_m_out_remarks">
<input type="text" data-table="material_required_job_card" data-field="x_m_out_remarks" name="x_m_out_remarks" id="x_m_out_remarks" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($material_required_job_card->m_out_remarks->getPlaceHolder()) ?>" value="<?php echo $material_required_job_card->m_out_remarks->EditValue ?>"<?php echo $material_required_job_card->m_out_remarks->editAttributes() ?>>
</span>
<?php echo $material_required_job_card->m_out_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_required_job_card_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_required_job_card_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $material_required_job_card_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_required_job_card_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_required_job_card_add->terminate();
?>