<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_job_card_list = new material_required_job_card_list();

// Run the page
$material_required_job_card_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_job_card_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_required_job_card->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_required_job_cardlist = currentForm = new ew.Form("fmaterial_required_job_cardlist", "list");
fmaterial_required_job_cardlist.formKeyCountName = '<?php echo $material_required_job_card_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_required_job_cardlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_job_cardlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fmaterial_required_job_cardlistsrch = currentSearchForm = new ew.Form("fmaterial_required_job_cardlistsrch");

// Filters
fmaterial_required_job_cardlistsrch.filterList = <?php echo $material_required_job_card_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_required_job_cardlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_required_job_card->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_required_job_card_list->TotalRecs > 0 && $material_required_job_card_list->ExportOptions->visible()) { ?>
<?php $material_required_job_card_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_job_card_list->ImportOptions->visible()) { ?>
<?php $material_required_job_card_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_job_card_list->SearchOptions->visible()) { ?>
<?php $material_required_job_card_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_job_card_list->FilterOptions->visible()) { ?>
<?php $material_required_job_card_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_required_job_card_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_required_job_card->isExport() && !$material_required_job_card->CurrentAction) { ?>
<form name="fmaterial_required_job_cardlistsrch" id="fmaterial_required_job_cardlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_required_job_card_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_required_job_cardlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_required_job_card">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_required_job_card_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_required_job_card_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_required_job_card_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_required_job_card_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_required_job_card_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_required_job_card_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_required_job_card_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_required_job_card_list->showPageHeader(); ?>
<?php
$material_required_job_card_list->showMessage();
?>
<?php if ($material_required_job_card_list->TotalRecs > 0 || $material_required_job_card->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_required_job_card_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_required_job_card">
<?php if (!$material_required_job_card->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_required_job_card->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_job_card_list->Pager)) $material_required_job_card_list->Pager = new PrevNextPager($material_required_job_card_list->StartRec, $material_required_job_card_list->DisplayRecs, $material_required_job_card_list->TotalRecs, $material_required_job_card_list->AutoHidePager) ?>
<?php if ($material_required_job_card_list->Pager->RecordCount > 0 && $material_required_job_card_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_job_card_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_job_card_list->pageUrl() ?>start=<?php echo $material_required_job_card_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_job_card_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_job_card_list->pageUrl() ?>start=<?php echo $material_required_job_card_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_job_card_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_job_card_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_job_card_list->pageUrl() ?>start=<?php echo $material_required_job_card_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_job_card_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_job_card_list->pageUrl() ?>start=<?php echo $material_required_job_card_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_job_card_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_job_card_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_job_card_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_job_card_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_job_card_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_job_card_list->TotalRecs > 0 && (!$material_required_job_card_list->AutoHidePageSizeSelector || $material_required_job_card_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_job_card">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_job_card_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_job_card_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_job_card_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_job_card_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_job_card_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_job_card->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_job_card_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_required_job_cardlist" id="fmaterial_required_job_cardlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_job_card_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_job_card_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_job_card">
<div id="gmp_material_required_job_card" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_required_job_card_list->TotalRecs > 0 || $material_required_job_card->isGridEdit()) { ?>
<table id="tbl_material_required_job_cardlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_required_job_card_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_required_job_card_list->renderListOptions();

// Render list options (header, left)
$material_required_job_card_list->ListOptions->render("header", "left");
?>
<?php if ($material_required_job_card->id->Visible) { // id ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_required_job_card->id->headerCellClass() ?>"><div id="elh_material_required_job_card_id" class="material_required_job_card_id"><div class="ew-table-header-caption"><?php echo $material_required_job_card->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_required_job_card->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->id) ?>',2);"><div id="elh_material_required_job_card_id" class="material_required_job_card_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->poid->Visible) { // poid ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->poid) == "") { ?>
		<th data-name="poid" class="<?php echo $material_required_job_card->poid->headerCellClass() ?>"><div id="elh_material_required_job_card_poid" class="material_required_job_card_poid"><div class="ew-table-header-caption"><?php echo $material_required_job_card->poid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="poid" class="<?php echo $material_required_job_card->poid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->poid) ?>',2);"><div id="elh_material_required_job_card_poid" class="material_required_job_card_poid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->poid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->poid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->poid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->jc_no->Visible) { // jc_no ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $material_required_job_card->jc_no->headerCellClass() ?>"><div id="elh_material_required_job_card_jc_no" class="material_required_job_card_jc_no"><div class="ew-table-header-caption"><?php echo $material_required_job_card->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $material_required_job_card->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->jc_no) ?>',2);"><div id="elh_material_required_job_card_jc_no" class="material_required_job_card_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->location->Visible) { // location ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->location) == "") { ?>
		<th data-name="location" class="<?php echo $material_required_job_card->location->headerCellClass() ?>"><div id="elh_material_required_job_card_location" class="material_required_job_card_location"><div class="ew-table-header-caption"><?php echo $material_required_job_card->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $material_required_job_card->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->location) ?>',2);"><div id="elh_material_required_job_card_location" class="material_required_job_card_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->issue_to->Visible) { // issue_to ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $material_required_job_card->issue_to->headerCellClass() ?>"><div id="elh_material_required_job_card_issue_to" class="material_required_job_card_issue_to"><div class="ew-table-header-caption"><?php echo $material_required_job_card->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $material_required_job_card->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->issue_to) ?>',2);"><div id="elh_material_required_job_card_issue_to" class="material_required_job_card_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->week->Visible) { // week ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->week) == "") { ?>
		<th data-name="week" class="<?php echo $material_required_job_card->week->headerCellClass() ?>"><div id="elh_material_required_job_card_week" class="material_required_job_card_week"><div class="ew-table-header-caption"><?php echo $material_required_job_card->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $material_required_job_card->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->week) ?>',2);"><div id="elh_material_required_job_card_week" class="material_required_job_card_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->po->Visible) { // po ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->po) == "") { ?>
		<th data-name="po" class="<?php echo $material_required_job_card->po->headerCellClass() ?>"><div id="elh_material_required_job_card_po" class="material_required_job_card_po"><div class="ew-table-header-caption"><?php echo $material_required_job_card->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $material_required_job_card->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->po) ?>',2);"><div id="elh_material_required_job_card_po" class="material_required_job_card_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->buyer_id->Visible) { // buyer_id ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_job_card->buyer_id->headerCellClass() ?>"><div id="elh_material_required_job_card_buyer_id" class="material_required_job_card_buyer_id"><div class="ew-table-header-caption"><?php echo $material_required_job_card->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_job_card->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->buyer_id) ?>',2);"><div id="elh_material_required_job_card_buyer_id" class="material_required_job_card_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->grp->Visible) { // grp ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $material_required_job_card->grp->headerCellClass() ?>"><div id="elh_material_required_job_card_grp" class="material_required_job_card_grp"><div class="ew-table-header-caption"><?php echo $material_required_job_card->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $material_required_job_card->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->grp) ?>',2);"><div id="elh_material_required_job_card_grp" class="material_required_job_card_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->s_grp->Visible) { // s_grp ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $material_required_job_card->s_grp->headerCellClass() ?>"><div id="elh_material_required_job_card_s_grp" class="material_required_job_card_s_grp"><div class="ew-table-header-caption"><?php echo $material_required_job_card->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $material_required_job_card->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->s_grp) ?>',2);"><div id="elh_material_required_job_card_s_grp" class="material_required_job_card_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->product->Visible) { // product ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->product) == "") { ?>
		<th data-name="product" class="<?php echo $material_required_job_card->product->headerCellClass() ?>"><div id="elh_material_required_job_card_product" class="material_required_job_card_product"><div class="ew-table-header-caption"><?php echo $material_required_job_card->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $material_required_job_card->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->product) ?>',2);"><div id="elh_material_required_job_card_product" class="material_required_job_card_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->product_id->Visible) { // product_id ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->product_id) == "") { ?>
		<th data-name="product_id" class="<?php echo $material_required_job_card->product_id->headerCellClass() ?>"><div id="elh_material_required_job_card_product_id" class="material_required_job_card_product_id"><div class="ew-table-header-caption"><?php echo $material_required_job_card->product_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_id" class="<?php echo $material_required_job_card->product_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->product_id) ?>',2);"><div id="elh_material_required_job_card_product_id" class="material_required_job_card_product_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->product_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->product_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->product_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->batch_no->Visible) { // batch_no ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $material_required_job_card->batch_no->headerCellClass() ?>"><div id="elh_material_required_job_card_batch_no" class="material_required_job_card_batch_no"><div class="ew-table-header-caption"><?php echo $material_required_job_card->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $material_required_job_card->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->batch_no) ?>',2);"><div id="elh_material_required_job_card_batch_no" class="material_required_job_card_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->quantity->Visible) { // quantity ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_required_job_card->quantity->headerCellClass() ?>"><div id="elh_material_required_job_card_quantity" class="material_required_job_card_quantity"><div class="ew-table-header-caption"><?php echo $material_required_job_card->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_required_job_card->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->quantity) ?>',2);"><div id="elh_material_required_job_card_quantity" class="material_required_job_card_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->size_cm->Visible) { // size_cm ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $material_required_job_card->size_cm->headerCellClass() ?>"><div id="elh_material_required_job_card_size_cm" class="material_required_job_card_size_cm"><div class="ew-table-header-caption"><?php echo $material_required_job_card->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $material_required_job_card->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->size_cm) ?>',2);"><div id="elh_material_required_job_card_size_cm" class="material_required_job_card_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->sqm->Visible) { // sqm ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $material_required_job_card->sqm->headerCellClass() ?>"><div id="elh_material_required_job_card_sqm" class="material_required_job_card_sqm"><div class="ew-table-header-caption"><?php echo $material_required_job_card->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $material_required_job_card->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->sqm) ?>',2);"><div id="elh_material_required_job_card_sqm" class="material_required_job_card_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->t_sqm->Visible) { // t_sqm ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->t_sqm) == "") { ?>
		<th data-name="t_sqm" class="<?php echo $material_required_job_card->t_sqm->headerCellClass() ?>"><div id="elh_material_required_job_card_t_sqm" class="material_required_job_card_t_sqm"><div class="ew-table-header-caption"><?php echo $material_required_job_card->t_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_sqm" class="<?php echo $material_required_job_card->t_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->t_sqm) ?>',2);"><div id="elh_material_required_job_card_t_sqm" class="material_required_job_card_t_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->t_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->t_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->t_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->req_material_grp->Visible) { // req_material_grp ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->req_material_grp) == "") { ?>
		<th data-name="req_material_grp" class="<?php echo $material_required_job_card->req_material_grp->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_grp" class="material_required_job_card_req_material_grp"><div class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_grp" class="<?php echo $material_required_job_card->req_material_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->req_material_grp) ?>',2);"><div id="elh_material_required_job_card_req_material_grp" class="material_required_job_card_req_material_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->req_material_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->req_material_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->req_material_sgrp) == "") { ?>
		<th data-name="req_material_sgrp" class="<?php echo $material_required_job_card->req_material_sgrp->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_sgrp" class="material_required_job_card_req_material_sgrp"><div class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_sgrp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_sgrp" class="<?php echo $material_required_job_card->req_material_sgrp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->req_material_sgrp) ?>',2);"><div id="elh_material_required_job_card_req_material_sgrp" class="material_required_job_card_req_material_sgrp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_sgrp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->req_material_sgrp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->req_material_sgrp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->req_material_product->Visible) { // req_material_product ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->req_material_product) == "") { ?>
		<th data-name="req_material_product" class="<?php echo $material_required_job_card->req_material_product->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_product" class="material_required_job_card_req_material_product"><div class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_product" class="<?php echo $material_required_job_card->req_material_product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->req_material_product) ?>',2);"><div id="elh_material_required_job_card_req_material_product" class="material_required_job_card_req_material_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->req_material_product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->req_material_product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_job_card->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_rid" class="material_required_job_card_req_material_rid"><div class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_job_card->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->req_material_rid) ?>',2);"><div id="elh_material_required_job_card_req_material_rid" class="material_required_job_card_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_job_card->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_qty" class="material_required_job_card_req_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_job_card->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->req_material_qty) ?>',2);"><div id="elh_material_required_job_card_req_material_qty" class="material_required_job_card_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->req_material_packing) == "") { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_job_card->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_job_card_req_material_packing" class="material_required_job_card_req_material_packing"><div class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_job_card->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->req_material_packing) ?>',2);"><div id="elh_material_required_job_card_req_material_packing" class="material_required_job_card_req_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->req_material_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->req_material_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->stock->Visible) { // stock ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->stock) == "") { ?>
		<th data-name="stock" class="<?php echo $material_required_job_card->stock->headerCellClass() ?>"><div id="elh_material_required_job_card_stock" class="material_required_job_card_stock"><div class="ew-table-header-caption"><?php echo $material_required_job_card->stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stock" class="<?php echo $material_required_job_card->stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->stock) ?>',2);"><div id="elh_material_required_job_card_stock" class="material_required_job_card_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->short->Visible) { // short ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->short) == "") { ?>
		<th data-name="short" class="<?php echo $material_required_job_card->short->headerCellClass() ?>"><div id="elh_material_required_job_card_short" class="material_required_job_card_short"><div class="ew-table-header-caption"><?php echo $material_required_job_card->short->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="short" class="<?php echo $material_required_job_card->short->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->short) ?>',2);"><div id="elh_material_required_job_card_short" class="material_required_job_card_short">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->short->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->short->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->short->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->unit->Visible) { // unit ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $material_required_job_card->unit->headerCellClass() ?>"><div id="elh_material_required_job_card_unit" class="material_required_job_card_unit"><div class="ew-table-header-caption"><?php echo $material_required_job_card->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $material_required_job_card->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->unit) ?>',2);"><div id="elh_material_required_job_card_unit" class="material_required_job_card_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->unit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->material_qty->Visible) { // material_qty ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->material_qty) == "") { ?>
		<th data-name="material_qty" class="<?php echo $material_required_job_card->material_qty->headerCellClass() ?>"><div id="elh_material_required_job_card_material_qty" class="material_required_job_card_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_job_card->material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_qty" class="<?php echo $material_required_job_card->material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->material_qty) ?>',2);"><div id="elh_material_required_job_card_material_qty" class="material_required_job_card_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->method->Visible) { // method ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->method) == "") { ?>
		<th data-name="method" class="<?php echo $material_required_job_card->method->headerCellClass() ?>"><div id="elh_material_required_job_card_method" class="material_required_job_card_method"><div class="ew-table-header-caption"><?php echo $material_required_job_card->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $material_required_job_card->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->method) ?>',2);"><div id="elh_material_required_job_card_method" class="material_required_job_card_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->despatch_week->Visible) { // despatch_week ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_job_card->despatch_week->headerCellClass() ?>"><div id="elh_material_required_job_card_despatch_week" class="material_required_job_card_despatch_week"><div class="ew-table-header-caption"><?php echo $material_required_job_card->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_job_card->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->despatch_week) ?>',2);"><div id="elh_material_required_job_card_despatch_week" class="material_required_job_card_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->despatch_date->Visible) { // despatch_date ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_job_card->despatch_date->headerCellClass() ?>"><div id="elh_material_required_job_card_despatch_date" class="material_required_job_card_despatch_date"><div class="ew-table-header-caption"><?php echo $material_required_job_card->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_job_card->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->despatch_date) ?>',2);"><div id="elh_material_required_job_card_despatch_date" class="material_required_job_card_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->production_plan->Visible) { // production_plan ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->production_plan) == "") { ?>
		<th data-name="production_plan" class="<?php echo $material_required_job_card->production_plan->headerCellClass() ?>"><div id="elh_material_required_job_card_production_plan" class="material_required_job_card_production_plan"><div class="ew-table-header-caption"><?php echo $material_required_job_card->production_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_plan" class="<?php echo $material_required_job_card->production_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->production_plan) ?>',2);"><div id="elh_material_required_job_card_production_plan" class="material_required_job_card_production_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->production_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->production_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->production_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->updated->Visible) { // updated ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->updated) == "") { ?>
		<th data-name="updated" class="<?php echo $material_required_job_card->updated->headerCellClass() ?>"><div id="elh_material_required_job_card_updated" class="material_required_job_card_updated"><div class="ew-table-header-caption"><?php echo $material_required_job_card->updated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="updated" class="<?php echo $material_required_job_card->updated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->updated) ?>',2);"><div id="elh_material_required_job_card_updated" class="material_required_job_card_updated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->updated->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->updated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->updated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->operator->Visible) { // operator ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_required_job_card->operator->headerCellClass() ?>"><div id="elh_material_required_job_card_operator" class="material_required_job_card_operator"><div class="ew-table-header-caption"><?php echo $material_required_job_card->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_required_job_card->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->operator) ?>',2);"><div id="elh_material_required_job_card_operator" class="material_required_job_card_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->datetime->Visible) { // datetime ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $material_required_job_card->datetime->headerCellClass() ?>"><div id="elh_material_required_job_card_datetime" class="material_required_job_card_datetime"><div class="ew-table-header-caption"><?php echo $material_required_job_card->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $material_required_job_card->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->datetime) ?>',2);"><div id="elh_material_required_job_card_datetime" class="material_required_job_card_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->jc_datetime->Visible) { // jc_datetime ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->jc_datetime) == "") { ?>
		<th data-name="jc_datetime" class="<?php echo $material_required_job_card->jc_datetime->headerCellClass() ?>"><div id="elh_material_required_job_card_jc_datetime" class="material_required_job_card_jc_datetime"><div class="ew-table-header-caption"><?php echo $material_required_job_card->jc_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_datetime" class="<?php echo $material_required_job_card->jc_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->jc_datetime) ?>',2);"><div id="elh_material_required_job_card_jc_datetime" class="material_required_job_card_jc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->jc_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->jc_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->jc_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->company_id->Visible) { // company_id ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $material_required_job_card->company_id->headerCellClass() ?>"><div id="elh_material_required_job_card_company_id" class="material_required_job_card_company_id"><div class="ew-table-header-caption"><?php echo $material_required_job_card->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $material_required_job_card->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->company_id) ?>',2);"><div id="elh_material_required_job_card_company_id" class="material_required_job_card_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->m_out_id->Visible) { // m_out_id ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->m_out_id) == "") { ?>
		<th data-name="m_out_id" class="<?php echo $material_required_job_card->m_out_id->headerCellClass() ?>"><div id="elh_material_required_job_card_m_out_id" class="material_required_job_card_m_out_id"><div class="ew-table-header-caption"><?php echo $material_required_job_card->m_out_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="m_out_id" class="<?php echo $material_required_job_card->m_out_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->m_out_id) ?>',2);"><div id="elh_material_required_job_card_m_out_id" class="material_required_job_card_m_out_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->m_out_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->m_out_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->m_out_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->issued_qty->Visible) { // issued_qty ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->issued_qty) == "") { ?>
		<th data-name="issued_qty" class="<?php echo $material_required_job_card->issued_qty->headerCellClass() ?>"><div id="elh_material_required_job_card_issued_qty" class="material_required_job_card_issued_qty"><div class="ew-table-header-caption"><?php echo $material_required_job_card->issued_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issued_qty" class="<?php echo $material_required_job_card->issued_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->issued_qty) ?>',2);"><div id="elh_material_required_job_card_issued_qty" class="material_required_job_card_issued_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->issued_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->issued_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->issued_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->pending_qty->Visible) { // pending_qty ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->pending_qty) == "") { ?>
		<th data-name="pending_qty" class="<?php echo $material_required_job_card->pending_qty->headerCellClass() ?>"><div id="elh_material_required_job_card_pending_qty" class="material_required_job_card_pending_qty"><div class="ew-table-header-caption"><?php echo $material_required_job_card->pending_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_qty" class="<?php echo $material_required_job_card->pending_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->pending_qty) ?>',2);"><div id="elh_material_required_job_card_pending_qty" class="material_required_job_card_pending_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->pending_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->pending_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->pending_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_job_card->m_out_remarks->Visible) { // m_out_remarks ?>
	<?php if ($material_required_job_card->sortUrl($material_required_job_card->m_out_remarks) == "") { ?>
		<th data-name="m_out_remarks" class="<?php echo $material_required_job_card->m_out_remarks->headerCellClass() ?>"><div id="elh_material_required_job_card_m_out_remarks" class="material_required_job_card_m_out_remarks"><div class="ew-table-header-caption"><?php echo $material_required_job_card->m_out_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="m_out_remarks" class="<?php echo $material_required_job_card->m_out_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_job_card->SortUrl($material_required_job_card->m_out_remarks) ?>',2);"><div id="elh_material_required_job_card_m_out_remarks" class="material_required_job_card_m_out_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_job_card->m_out_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_job_card->m_out_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_job_card->m_out_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_job_card_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_required_job_card->ExportAll && $material_required_job_card->isExport()) {
	$material_required_job_card_list->StopRec = $material_required_job_card_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_required_job_card_list->TotalRecs > $material_required_job_card_list->StartRec + $material_required_job_card_list->DisplayRecs - 1)
		$material_required_job_card_list->StopRec = $material_required_job_card_list->StartRec + $material_required_job_card_list->DisplayRecs - 1;
	else
		$material_required_job_card_list->StopRec = $material_required_job_card_list->TotalRecs;
}
$material_required_job_card_list->RecCnt = $material_required_job_card_list->StartRec - 1;
if ($material_required_job_card_list->Recordset && !$material_required_job_card_list->Recordset->EOF) {
	$material_required_job_card_list->Recordset->moveFirst();
	$selectLimit = $material_required_job_card_list->UseSelectLimit;
	if (!$selectLimit && $material_required_job_card_list->StartRec > 1)
		$material_required_job_card_list->Recordset->move($material_required_job_card_list->StartRec - 1);
} elseif (!$material_required_job_card->AllowAddDeleteRow && $material_required_job_card_list->StopRec == 0) {
	$material_required_job_card_list->StopRec = $material_required_job_card->GridAddRowCount;
}

// Initialize aggregate
$material_required_job_card->RowType = ROWTYPE_AGGREGATEINIT;
$material_required_job_card->resetAttributes();
$material_required_job_card_list->renderRow();
while ($material_required_job_card_list->RecCnt < $material_required_job_card_list->StopRec) {
	$material_required_job_card_list->RecCnt++;
	if ($material_required_job_card_list->RecCnt >= $material_required_job_card_list->StartRec) {
		$material_required_job_card_list->RowCnt++;

		// Set up key count
		$material_required_job_card_list->KeyCount = $material_required_job_card_list->RowIndex;

		// Init row class and style
		$material_required_job_card->resetAttributes();
		$material_required_job_card->CssClass = "";
		if ($material_required_job_card->isGridAdd()) {
		} else {
			$material_required_job_card_list->loadRowValues($material_required_job_card_list->Recordset); // Load row values
		}
		$material_required_job_card->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_required_job_card->RowAttrs = array_merge($material_required_job_card->RowAttrs, array('data-rowindex'=>$material_required_job_card_list->RowCnt, 'id'=>'r' . $material_required_job_card_list->RowCnt . '_material_required_job_card', 'data-rowtype'=>$material_required_job_card->RowType));

		// Render row
		$material_required_job_card_list->renderRow();

		// Render list options
		$material_required_job_card_list->renderListOptions();
?>
	<tr<?php echo $material_required_job_card->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_job_card_list->ListOptions->render("body", "left", $material_required_job_card_list->RowCnt);
?>
	<?php if ($material_required_job_card->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_required_job_card->id->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_id" class="material_required_job_card_id">
<span<?php echo $material_required_job_card->id->viewAttributes() ?>>
<?php echo $material_required_job_card->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->poid->Visible) { // poid ?>
		<td data-name="poid"<?php echo $material_required_job_card->poid->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_poid" class="material_required_job_card_poid">
<span<?php echo $material_required_job_card->poid->viewAttributes() ?>>
<?php echo $material_required_job_card->poid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $material_required_job_card->jc_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_jc_no" class="material_required_job_card_jc_no">
<span<?php echo $material_required_job_card->jc_no->viewAttributes() ?>>
<?php echo $material_required_job_card->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->location->Visible) { // location ?>
		<td data-name="location"<?php echo $material_required_job_card->location->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_location" class="material_required_job_card_location">
<span<?php echo $material_required_job_card->location->viewAttributes() ?>>
<?php echo $material_required_job_card->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $material_required_job_card->issue_to->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_issue_to" class="material_required_job_card_issue_to">
<span<?php echo $material_required_job_card->issue_to->viewAttributes() ?>>
<?php echo $material_required_job_card->issue_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->week->Visible) { // week ?>
		<td data-name="week"<?php echo $material_required_job_card->week->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_week" class="material_required_job_card_week">
<span<?php echo $material_required_job_card->week->viewAttributes() ?>>
<?php echo $material_required_job_card->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->po->Visible) { // po ?>
		<td data-name="po"<?php echo $material_required_job_card->po->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_po" class="material_required_job_card_po">
<span<?php echo $material_required_job_card->po->viewAttributes() ?>>
<?php echo $material_required_job_card->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $material_required_job_card->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_buyer_id" class="material_required_job_card_buyer_id">
<span<?php echo $material_required_job_card->buyer_id->viewAttributes() ?>>
<?php echo $material_required_job_card->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $material_required_job_card->grp->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_grp" class="material_required_job_card_grp">
<span<?php echo $material_required_job_card->grp->viewAttributes() ?>>
<?php echo $material_required_job_card->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $material_required_job_card->s_grp->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_s_grp" class="material_required_job_card_s_grp">
<span<?php echo $material_required_job_card->s_grp->viewAttributes() ?>>
<?php echo $material_required_job_card->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->product->Visible) { // product ?>
		<td data-name="product"<?php echo $material_required_job_card->product->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_product" class="material_required_job_card_product">
<span<?php echo $material_required_job_card->product->viewAttributes() ?>>
<?php echo $material_required_job_card->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->product_id->Visible) { // product_id ?>
		<td data-name="product_id"<?php echo $material_required_job_card->product_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_product_id" class="material_required_job_card_product_id">
<span<?php echo $material_required_job_card->product_id->viewAttributes() ?>>
<?php echo $material_required_job_card->product_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $material_required_job_card->batch_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_batch_no" class="material_required_job_card_batch_no">
<span<?php echo $material_required_job_card->batch_no->viewAttributes() ?>>
<?php echo $material_required_job_card->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_required_job_card->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_quantity" class="material_required_job_card_quantity">
<span<?php echo $material_required_job_card->quantity->viewAttributes() ?>>
<?php echo $material_required_job_card->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $material_required_job_card->size_cm->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_size_cm" class="material_required_job_card_size_cm">
<span<?php echo $material_required_job_card->size_cm->viewAttributes() ?>>
<?php echo $material_required_job_card->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $material_required_job_card->sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_sqm" class="material_required_job_card_sqm">
<span<?php echo $material_required_job_card->sqm->viewAttributes() ?>>
<?php echo $material_required_job_card->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->t_sqm->Visible) { // t_sqm ?>
		<td data-name="t_sqm"<?php echo $material_required_job_card->t_sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_t_sqm" class="material_required_job_card_t_sqm">
<span<?php echo $material_required_job_card->t_sqm->viewAttributes() ?>>
<?php echo $material_required_job_card->t_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->req_material_grp->Visible) { // req_material_grp ?>
		<td data-name="req_material_grp"<?php echo $material_required_job_card->req_material_grp->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_req_material_grp" class="material_required_job_card_req_material_grp">
<span<?php echo $material_required_job_card->req_material_grp->viewAttributes() ?>>
<?php echo $material_required_job_card->req_material_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->req_material_sgrp->Visible) { // req_material_sgrp ?>
		<td data-name="req_material_sgrp"<?php echo $material_required_job_card->req_material_sgrp->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_req_material_sgrp" class="material_required_job_card_req_material_sgrp">
<span<?php echo $material_required_job_card->req_material_sgrp->viewAttributes() ?>>
<?php echo $material_required_job_card->req_material_sgrp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->req_material_product->Visible) { // req_material_product ?>
		<td data-name="req_material_product"<?php echo $material_required_job_card->req_material_product->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_req_material_product" class="material_required_job_card_req_material_product">
<span<?php echo $material_required_job_card->req_material_product->viewAttributes() ?>>
<?php echo $material_required_job_card->req_material_product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $material_required_job_card->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_req_material_rid" class="material_required_job_card_req_material_rid">
<span<?php echo $material_required_job_card->req_material_rid->viewAttributes() ?>>
<?php echo $material_required_job_card->req_material_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $material_required_job_card->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_req_material_qty" class="material_required_job_card_req_material_qty">
<span<?php echo $material_required_job_card->req_material_qty->viewAttributes() ?>>
<?php echo $material_required_job_card->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing"<?php echo $material_required_job_card->req_material_packing->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_req_material_packing" class="material_required_job_card_req_material_packing">
<span<?php echo $material_required_job_card->req_material_packing->viewAttributes() ?>>
<?php echo $material_required_job_card->req_material_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->stock->Visible) { // stock ?>
		<td data-name="stock"<?php echo $material_required_job_card->stock->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_stock" class="material_required_job_card_stock">
<span<?php echo $material_required_job_card->stock->viewAttributes() ?>>
<?php echo $material_required_job_card->stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->short->Visible) { // short ?>
		<td data-name="short"<?php echo $material_required_job_card->short->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_short" class="material_required_job_card_short">
<span<?php echo $material_required_job_card->short->viewAttributes() ?>>
<?php echo $material_required_job_card->short->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $material_required_job_card->unit->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_unit" class="material_required_job_card_unit">
<span<?php echo $material_required_job_card->unit->viewAttributes() ?>>
<?php echo $material_required_job_card->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty"<?php echo $material_required_job_card->material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_material_qty" class="material_required_job_card_material_qty">
<span<?php echo $material_required_job_card->material_qty->viewAttributes() ?>>
<?php echo $material_required_job_card->material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->method->Visible) { // method ?>
		<td data-name="method"<?php echo $material_required_job_card->method->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_method" class="material_required_job_card_method">
<span<?php echo $material_required_job_card->method->viewAttributes() ?>>
<?php echo $material_required_job_card->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $material_required_job_card->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_despatch_week" class="material_required_job_card_despatch_week">
<span<?php echo $material_required_job_card->despatch_week->viewAttributes() ?>>
<?php echo $material_required_job_card->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $material_required_job_card->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_despatch_date" class="material_required_job_card_despatch_date">
<span<?php echo $material_required_job_card->despatch_date->viewAttributes() ?>>
<?php echo $material_required_job_card->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->production_plan->Visible) { // production_plan ?>
		<td data-name="production_plan"<?php echo $material_required_job_card->production_plan->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_production_plan" class="material_required_job_card_production_plan">
<span<?php echo $material_required_job_card->production_plan->viewAttributes() ?>>
<?php echo $material_required_job_card->production_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->updated->Visible) { // updated ?>
		<td data-name="updated"<?php echo $material_required_job_card->updated->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_updated" class="material_required_job_card_updated">
<span<?php echo $material_required_job_card->updated->viewAttributes() ?>>
<?php echo $material_required_job_card->updated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_required_job_card->operator->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_operator" class="material_required_job_card_operator">
<span<?php echo $material_required_job_card->operator->viewAttributes() ?>>
<?php echo $material_required_job_card->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $material_required_job_card->datetime->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_datetime" class="material_required_job_card_datetime">
<span<?php echo $material_required_job_card->datetime->viewAttributes() ?>>
<?php echo $material_required_job_card->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->jc_datetime->Visible) { // jc_datetime ?>
		<td data-name="jc_datetime"<?php echo $material_required_job_card->jc_datetime->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_jc_datetime" class="material_required_job_card_jc_datetime">
<span<?php echo $material_required_job_card->jc_datetime->viewAttributes() ?>>
<?php echo $material_required_job_card->jc_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $material_required_job_card->company_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_company_id" class="material_required_job_card_company_id">
<span<?php echo $material_required_job_card->company_id->viewAttributes() ?>>
<?php echo $material_required_job_card->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->m_out_id->Visible) { // m_out_id ?>
		<td data-name="m_out_id"<?php echo $material_required_job_card->m_out_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_m_out_id" class="material_required_job_card_m_out_id">
<span<?php echo $material_required_job_card->m_out_id->viewAttributes() ?>>
<?php echo $material_required_job_card->m_out_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->issued_qty->Visible) { // issued_qty ?>
		<td data-name="issued_qty"<?php echo $material_required_job_card->issued_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_issued_qty" class="material_required_job_card_issued_qty">
<span<?php echo $material_required_job_card->issued_qty->viewAttributes() ?>>
<?php echo $material_required_job_card->issued_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->pending_qty->Visible) { // pending_qty ?>
		<td data-name="pending_qty"<?php echo $material_required_job_card->pending_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_pending_qty" class="material_required_job_card_pending_qty">
<span<?php echo $material_required_job_card->pending_qty->viewAttributes() ?>>
<?php echo $material_required_job_card->pending_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_job_card->m_out_remarks->Visible) { // m_out_remarks ?>
		<td data-name="m_out_remarks"<?php echo $material_required_job_card->m_out_remarks->cellAttributes() ?>>
<span id="el<?php echo $material_required_job_card_list->RowCnt ?>_material_required_job_card_m_out_remarks" class="material_required_job_card_m_out_remarks">
<span<?php echo $material_required_job_card->m_out_remarks->viewAttributes() ?>>
<?php echo $material_required_job_card->m_out_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_required_job_card_list->ListOptions->render("body", "right", $material_required_job_card_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_required_job_card->isGridAdd())
		$material_required_job_card_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_required_job_card->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_required_job_card_list->Recordset)
	$material_required_job_card_list->Recordset->Close();
?>
<?php if (!$material_required_job_card->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_required_job_card->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_job_card_list->Pager)) $material_required_job_card_list->Pager = new PrevNextPager($material_required_job_card_list->StartRec, $material_required_job_card_list->DisplayRecs, $material_required_job_card_list->TotalRecs, $material_required_job_card_list->AutoHidePager) ?>
<?php if ($material_required_job_card_list->Pager->RecordCount > 0 && $material_required_job_card_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_job_card_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_job_card_list->pageUrl() ?>start=<?php echo $material_required_job_card_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_job_card_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_job_card_list->pageUrl() ?>start=<?php echo $material_required_job_card_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_job_card_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_job_card_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_job_card_list->pageUrl() ?>start=<?php echo $material_required_job_card_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_job_card_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_job_card_list->pageUrl() ?>start=<?php echo $material_required_job_card_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_job_card_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_job_card_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_job_card_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_job_card_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_job_card_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_job_card_list->TotalRecs > 0 && (!$material_required_job_card_list->AutoHidePageSizeSelector || $material_required_job_card_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_job_card">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_job_card_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_job_card_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_job_card_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_job_card_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_job_card_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_job_card->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_job_card_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_required_job_card_list->TotalRecs == 0 && !$material_required_job_card->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_required_job_card_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_required_job_card_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_required_job_card->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_required_job_card->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_required_job_card", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_required_job_card_list->terminate();
?>