<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_live_edit = new material_required_live_edit();

// Run the page
$material_required_live_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_live_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fmaterial_required_liveedit = currentForm = new ew.Form("fmaterial_required_liveedit", "edit");

// Validate form
fmaterial_required_liveedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($material_required_live_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->id->caption(), $material_required_live->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->poid->Required) { ?>
			elm = this.getElements("x" + infix + "_poid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->poid->caption(), $material_required_live->poid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->weaving_works->Required) { ?>
			elm = this.getElements("x" + infix + "_weaving_works");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->weaving_works->caption(), $material_required_live->weaving_works->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->week->Required) { ?>
			elm = this.getElements("x" + infix + "_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->week->caption(), $material_required_live->week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->po->caption(), $material_required_live->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->buyer_id->caption(), $material_required_live->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->grp->caption(), $material_required_live->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->s_grp->caption(), $material_required_live->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->product->caption(), $material_required_live->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->product_id->Required) { ?>
			elm = this.getElements("x" + infix + "_product_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->product_id->caption(), $material_required_live->product_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->batch_no->caption(), $material_required_live->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->quantity->caption(), $material_required_live->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->Size_wl->Required) { ?>
			elm = this.getElements("x" + infix + "_Size_wl");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->Size_wl->caption(), $material_required_live->Size_wl->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->sqm->caption(), $material_required_live->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->req_material_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->req_material_grp->caption(), $material_required_live->req_material_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_req_material_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_live->req_material_grp->errorMessage()) ?>");
		<?php if ($material_required_live_edit->req_material_sgrp->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_sgrp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->req_material_sgrp->caption(), $material_required_live->req_material_sgrp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->req_material_product->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->req_material_product->caption(), $material_required_live->req_material_product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->req_material_rid->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->req_material_rid->caption(), $material_required_live->req_material_rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->req_material_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->req_material_qty->caption(), $material_required_live->req_material_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->req_material_packing->Required) { ?>
			elm = this.getElements("x" + infix + "_req_material_packing");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->req_material_packing->caption(), $material_required_live->req_material_packing->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->issue_material_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->issue_material_grp->caption(), $material_required_live->issue_material_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_issue_material_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_live->issue_material_grp->errorMessage()) ?>");
		<?php if ($material_required_live_edit->issue_material_sgrp->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_sgrp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->issue_material_sgrp->caption(), $material_required_live->issue_material_sgrp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->issue_material_product->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->issue_material_product->caption(), $material_required_live->issue_material_product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->issue_material_rid->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->issue_material_rid->caption(), $material_required_live->issue_material_rid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_issue_material_rid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_live->issue_material_rid->errorMessage()) ?>");
		<?php if ($material_required_live_edit->issue_material_packing->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_packing");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->issue_material_packing->caption(), $material_required_live->issue_material_packing->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->issue_material_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_material_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->issue_material_qty->caption(), $material_required_live->issue_material_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_issue_material_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_live->issue_material_qty->errorMessage()) ?>");
		<?php if ($material_required_live_edit->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->unit->caption(), $material_required_live->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->material_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_material_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->material_qty->caption(), $material_required_live->material_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->method->Required) { ?>
			elm = this.getElements("x" + infix + "_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->method->caption(), $material_required_live->method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->despatch_week->caption(), $material_required_live->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->despatch_date->caption(), $material_required_live->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_live->despatch_date->errorMessage()) ?>");
		<?php if ($material_required_live_edit->production_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->production_plan->caption(), $material_required_live->production_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->operator->caption(), $material_required_live->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->datetime->caption(), $material_required_live->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->material_out->Required) { ?>
			elm = this.getElements("x" + infix + "_material_out");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->material_out->caption(), $material_required_live->material_out->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->issue_to->Required) { ?>
			elm = this.getElements("x" + infix + "_issue_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->issue_to->caption(), $material_required_live->issue_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($material_required_live_edit->pp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->pp_id->caption(), $material_required_live->pp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_live->pp_id->errorMessage()) ?>");
		<?php if ($material_required_live_edit->level->Required) { ?>
			elm = this.getElements("x" + infix + "_level");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $material_required_live->level->caption(), $material_required_live->level->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_level");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($material_required_live->level->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmaterial_required_liveedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_liveedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_liveedit.lists["x_weaving_works"] = <?php echo $material_required_live_edit->weaving_works->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_weaving_works"].options = <?php echo JsonEncode($material_required_live_edit->weaving_works->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_week"] = <?php echo $material_required_live_edit->week->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_week"].options = <?php echo JsonEncode($material_required_live_edit->week->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_buyer_id"] = <?php echo $material_required_live_edit->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_live_edit->buyer_id->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_grp"] = <?php echo $material_required_live_edit->grp->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_grp"].options = <?php echo JsonEncode($material_required_live_edit->grp->options(FALSE, TRUE)) ?>;
fmaterial_required_liveedit.lists["x_s_grp"] = <?php echo $material_required_live_edit->s_grp->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_s_grp"].options = <?php echo JsonEncode($material_required_live_edit->s_grp->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_product"] = <?php echo $material_required_live_edit->product->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_product"].options = <?php echo JsonEncode($material_required_live_edit->product->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_product_id"] = <?php echo $material_required_live_edit->product_id->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_product_id"].options = <?php echo JsonEncode($material_required_live_edit->product_id->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_batch_no"] = <?php echo $material_required_live_edit->batch_no->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_batch_no"].options = <?php echo JsonEncode($material_required_live_edit->batch_no->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_req_material_sgrp"] = <?php echo $material_required_live_edit->req_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_req_material_sgrp"].options = <?php echo JsonEncode($material_required_live_edit->req_material_sgrp->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_req_material_product"] = <?php echo $material_required_live_edit->req_material_product->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_req_material_product"].options = <?php echo JsonEncode($material_required_live_edit->req_material_product->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_req_material_rid"] = <?php echo $material_required_live_edit->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_live_edit->req_material_rid->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_req_material_packing"] = <?php echo $material_required_live_edit->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_live_edit->req_material_packing->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_issue_material_sgrp"] = <?php echo $material_required_live_edit->issue_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_issue_material_sgrp"].options = <?php echo JsonEncode($material_required_live_edit->issue_material_sgrp->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_issue_material_product"] = <?php echo $material_required_live_edit->issue_material_product->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_issue_material_product"].options = <?php echo JsonEncode($material_required_live_edit->issue_material_product->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_issue_material_packing"] = <?php echo $material_required_live_edit->issue_material_packing->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_issue_material_packing"].options = <?php echo JsonEncode($material_required_live_edit->issue_material_packing->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_unit"] = <?php echo $material_required_live_edit->unit->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_unit"].options = <?php echo JsonEncode($material_required_live_edit->unit->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_material_qty"] = <?php echo $material_required_live_edit->material_qty->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_material_qty"].options = <?php echo JsonEncode($material_required_live_edit->material_qty->lookupOptions()) ?>;
fmaterial_required_liveedit.autoSuggests["x_material_qty"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_required_liveedit.lists["x_method"] = <?php echo $material_required_live_edit->method->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_method"].options = <?php echo JsonEncode($material_required_live_edit->method->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_despatch_week"] = <?php echo $material_required_live_edit->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_live_edit->despatch_week->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_production_plan"] = <?php echo $material_required_live_edit->production_plan->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_production_plan"].options = <?php echo JsonEncode($material_required_live_edit->production_plan->options(FALSE, TRUE)) ?>;
fmaterial_required_liveedit.lists["x_operator"] = <?php echo $material_required_live_edit->operator->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_operator"].options = <?php echo JsonEncode($material_required_live_edit->operator->lookupOptions()) ?>;
fmaterial_required_liveedit.lists["x_material_out"] = <?php echo $material_required_live_edit->material_out->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_material_out"].options = <?php echo JsonEncode($material_required_live_edit->material_out->options(FALSE, TRUE)) ?>;
fmaterial_required_liveedit.lists["x_issue_to"] = <?php echo $material_required_live_edit->issue_to->Lookup->toClientList() ?>;
fmaterial_required_liveedit.lists["x_issue_to"].options = <?php echo JsonEncode($material_required_live_edit->issue_to->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_required_live_edit->showPageHeader(); ?>
<?php
$material_required_live_edit->showMessage();
?>
<form name="fmaterial_required_liveedit" id="fmaterial_required_liveedit" class="<?php echo $material_required_live_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_live_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_live_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_live">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$material_required_live_edit->IsModal ?>">
<?php if ($material_required_live->getCurrentMasterTable() == "required_material_compiled_live") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="required_material_compiled_live">
<input type="hidden" name="fk_po" value="<?php echo $material_required_live->po->getSessionValue() ?>">
<input type="hidden" name="fk_req_material_rid" value="<?php echo $material_required_live->req_material_rid->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($material_required_live->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_material_required_live_id" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->id->caption() ?><?php echo ($material_required_live->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->id->cellAttributes() ?>>
<span id="el_material_required_live_id">
<span<?php echo $material_required_live->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($material_required_live->id->CurrentValue) ?>">
<?php echo $material_required_live->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label id="elh_material_required_live_poid" for="x_poid" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->poid->caption() ?><?php echo ($material_required_live->poid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->poid->cellAttributes() ?>>
<span id="el_material_required_live_poid">
<span<?php echo $material_required_live->poid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->poid->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_poid" name="x_poid" id="x_poid" value="<?php echo HtmlEncode($material_required_live->poid->CurrentValue) ?>">
<?php echo $material_required_live->poid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label id="elh_material_required_live_weaving_works" for="x_weaving_works" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->weaving_works->caption() ?><?php echo ($material_required_live->weaving_works->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->weaving_works->cellAttributes() ?>>
<span id="el_material_required_live_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_weaving_works" data-value-separator="<?php echo $material_required_live->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $material_required_live->weaving_works->editAttributes() ?>>
		<?php echo $material_required_live->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $material_required_live->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
<?php echo $material_required_live->weaving_works->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->week->Visible) { // week ?>
	<div id="r_week" class="form-group row">
		<label id="elh_material_required_live_week" for="x_week" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->week->caption() ?><?php echo ($material_required_live->week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->week->cellAttributes() ?>>
<span id="el_material_required_live_week">
<span<?php echo $material_required_live->week->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->week->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_week" name="x_week" id="x_week" value="<?php echo HtmlEncode($material_required_live->week->CurrentValue) ?>">
<?php echo $material_required_live->week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_material_required_live_po" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->po->caption() ?><?php echo ($material_required_live->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->po->cellAttributes() ?>>
<span id="el_material_required_live_po">
<span<?php echo $material_required_live->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_po" name="x_po" id="x_po" value="<?php echo HtmlEncode($material_required_live->po->CurrentValue) ?>">
<?php echo $material_required_live->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_material_required_live_buyer_id" for="x_buyer_id" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->buyer_id->caption() ?><?php echo ($material_required_live->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->buyer_id->cellAttributes() ?>>
<span id="el_material_required_live_buyer_id">
<span<?php echo $material_required_live->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_live->buyer_id->EditValue)) && $material_required_live->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_live->buyer_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->buyer_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->buyer_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_buyer_id" name="x_buyer_id" id="x_buyer_id" value="<?php echo HtmlEncode($material_required_live->buyer_id->CurrentValue) ?>">
<?php echo $material_required_live->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_material_required_live_grp" for="x_grp" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->grp->caption() ?><?php echo ($material_required_live->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->grp->cellAttributes() ?>>
<span id="el_material_required_live_grp">
<span<?php echo $material_required_live->grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_grp" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($material_required_live->grp->CurrentValue) ?>">
<?php echo $material_required_live->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_material_required_live_s_grp" for="x_s_grp" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->s_grp->caption() ?><?php echo ($material_required_live->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->s_grp->cellAttributes() ?>>
<span id="el_material_required_live_s_grp">
<span<?php echo $material_required_live->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_live->s_grp->EditValue)) && $material_required_live->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $material_required_live->s_grp->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->s_grp->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->s_grp->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_s_grp" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($material_required_live->s_grp->CurrentValue) ?>">
<?php echo $material_required_live->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_material_required_live_product" for="x_product" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->product->caption() ?><?php echo ($material_required_live->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->product->cellAttributes() ?>>
<span id="el_material_required_live_product">
<span<?php echo $material_required_live->product->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_live->product->EditValue)) && $material_required_live->product->linkAttributes() <> "") { ?>
<a<?php echo $material_required_live->product->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->product->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->product->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_product" name="x_product" id="x_product" value="<?php echo HtmlEncode($material_required_live->product->CurrentValue) ?>">
<?php echo $material_required_live->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->product_id->Visible) { // product_id ?>
	<div id="r_product_id" class="form-group row">
		<label id="elh_material_required_live_product_id" for="x_product_id" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->product_id->caption() ?><?php echo ($material_required_live->product_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->product_id->cellAttributes() ?>>
<span id="el_material_required_live_product_id">
<span<?php echo $material_required_live->product_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_live->product_id->EditValue)) && $material_required_live->product_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_live->product_id->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->product_id->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->product_id->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_product_id" name="x_product_id" id="x_product_id" value="<?php echo HtmlEncode($material_required_live->product_id->CurrentValue) ?>">
<?php echo $material_required_live->product_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_material_required_live_batch_no" for="x_batch_no" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->batch_no->caption() ?><?php echo ($material_required_live->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->batch_no->cellAttributes() ?>>
<span id="el_material_required_live_batch_no">
<span<?php echo $material_required_live->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_live->batch_no->EditValue)) && $material_required_live->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $material_required_live->batch_no->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->batch_no->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->batch_no->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" value="<?php echo HtmlEncode($material_required_live->batch_no->CurrentValue) ?>">
<?php echo $material_required_live->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_material_required_live_quantity" for="x_quantity" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->quantity->caption() ?><?php echo ($material_required_live->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->quantity->cellAttributes() ?>>
<span id="el_material_required_live_quantity">
<span<?php echo $material_required_live->quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->quantity->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_quantity" name="x_quantity" id="x_quantity" value="<?php echo HtmlEncode($material_required_live->quantity->CurrentValue) ?>">
<?php echo $material_required_live->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->Size_wl->Visible) { // Size_wl ?>
	<div id="r_Size_wl" class="form-group row">
		<label id="elh_material_required_live_Size_wl" for="x_Size_wl" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->Size_wl->caption() ?><?php echo ($material_required_live->Size_wl->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->Size_wl->cellAttributes() ?>>
<span id="el_material_required_live_Size_wl">
<span<?php echo $material_required_live->Size_wl->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->Size_wl->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_Size_wl" name="x_Size_wl" id="x_Size_wl" value="<?php echo HtmlEncode($material_required_live->Size_wl->CurrentValue) ?>">
<?php echo $material_required_live->Size_wl->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_material_required_live_sqm" for="x_sqm" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->sqm->caption() ?><?php echo ($material_required_live->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->sqm->cellAttributes() ?>>
<span id="el_material_required_live_sqm">
<span<?php echo $material_required_live->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->sqm->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_sqm" name="x_sqm" id="x_sqm" value="<?php echo HtmlEncode($material_required_live->sqm->CurrentValue) ?>">
<?php echo $material_required_live->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_grp->Visible) { // req_material_grp ?>
	<div id="r_req_material_grp" class="form-group row">
		<label id="elh_material_required_live_req_material_grp" for="x_req_material_grp" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->req_material_grp->caption() ?><?php echo ($material_required_live->req_material_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_grp->cellAttributes() ?>>
<span id="el_material_required_live_req_material_grp">
<input type="text" data-table="material_required_live" data-field="x_req_material_grp" name="x_req_material_grp" id="x_req_material_grp" size="30" placeholder="<?php echo HtmlEncode($material_required_live->req_material_grp->getPlaceHolder()) ?>" value="<?php echo $material_required_live->req_material_grp->EditValue ?>"<?php echo $material_required_live->req_material_grp->editAttributes() ?>>
</span>
<?php echo $material_required_live->req_material_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<div id="r_req_material_sgrp" class="form-group row">
		<label id="elh_material_required_live_req_material_sgrp" for="x_req_material_sgrp" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->req_material_sgrp->caption() ?><?php echo ($material_required_live->req_material_sgrp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_live_req_material_sgrp">
<span<?php echo $material_required_live->req_material_sgrp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->req_material_sgrp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_sgrp" name="x_req_material_sgrp" id="x_req_material_sgrp" value="<?php echo HtmlEncode($material_required_live->req_material_sgrp->CurrentValue) ?>">
<?php echo $material_required_live->req_material_sgrp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_product->Visible) { // req_material_product ?>
	<div id="r_req_material_product" class="form-group row">
		<label id="elh_material_required_live_req_material_product" for="x_req_material_product" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->req_material_product->caption() ?><?php echo ($material_required_live->req_material_product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_product->cellAttributes() ?>>
<span id="el_material_required_live_req_material_product">
<span<?php echo $material_required_live->req_material_product->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->req_material_product->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_product" name="x_req_material_product" id="x_req_material_product" value="<?php echo HtmlEncode($material_required_live->req_material_product->CurrentValue) ?>">
<?php echo $material_required_live->req_material_product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_rid->Visible) { // req_material_rid ?>
	<div id="r_req_material_rid" class="form-group row">
		<label id="elh_material_required_live_req_material_rid" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->req_material_rid->caption() ?><?php echo ($material_required_live->req_material_rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_rid->cellAttributes() ?>>
<span id="el_material_required_live_req_material_rid">
<span<?php echo $material_required_live->req_material_rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->req_material_rid->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" value="<?php echo HtmlEncode($material_required_live->req_material_rid->CurrentValue) ?>">
<?php echo $material_required_live->req_material_rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_qty->Visible) { // req_material_qty ?>
	<div id="r_req_material_qty" class="form-group row">
		<label id="elh_material_required_live_req_material_qty" for="x_req_material_qty" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->req_material_qty->caption() ?><?php echo ($material_required_live->req_material_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_qty->cellAttributes() ?>>
<span id="el_material_required_live_req_material_qty">
<span<?php echo $material_required_live->req_material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->req_material_qty->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_req_material_qty" name="x_req_material_qty" id="x_req_material_qty" value="<?php echo HtmlEncode($material_required_live->req_material_qty->CurrentValue) ?>">
<?php echo $material_required_live->req_material_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_packing->Visible) { // req_material_packing ?>
	<div id="r_req_material_packing" class="form-group row">
		<label id="elh_material_required_live_req_material_packing" for="x_req_material_packing" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->req_material_packing->caption() ?><?php echo ($material_required_live->req_material_packing->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_packing->cellAttributes() ?>>
<span id="el_material_required_live_req_material_packing">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_req_material_packing" data-value-separator="<?php echo $material_required_live->req_material_packing->displayValueSeparatorAttribute() ?>" id="x_req_material_packing" name="x_req_material_packing"<?php echo $material_required_live->req_material_packing->editAttributes() ?>>
		<?php echo $material_required_live->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
	</select>
</div>
<?php echo $material_required_live->req_material_packing->Lookup->getParamTag("p_x_req_material_packing") ?>
</span>
<?php echo $material_required_live->req_material_packing->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_grp->Visible) { // issue_material_grp ?>
	<div id="r_issue_material_grp" class="form-group row">
		<label id="elh_material_required_live_issue_material_grp" for="x_issue_material_grp" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->issue_material_grp->caption() ?><?php echo ($material_required_live->issue_material_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_grp->cellAttributes() ?>>
<span id="el_material_required_live_issue_material_grp">
<input type="text" data-table="material_required_live" data-field="x_issue_material_grp" name="x_issue_material_grp" id="x_issue_material_grp" size="30" placeholder="<?php echo HtmlEncode($material_required_live->issue_material_grp->getPlaceHolder()) ?>" value="<?php echo $material_required_live->issue_material_grp->EditValue ?>"<?php echo $material_required_live->issue_material_grp->editAttributes() ?>>
</span>
<?php echo $material_required_live->issue_material_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_sgrp->Visible) { // issue_material_sgrp ?>
	<div id="r_issue_material_sgrp" class="form-group row">
		<label id="elh_material_required_live_issue_material_sgrp" for="x_issue_material_sgrp" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->issue_material_sgrp->caption() ?><?php echo ($material_required_live->issue_material_sgrp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_sgrp->cellAttributes() ?>>
<span id="el_material_required_live_issue_material_sgrp">
<?php $material_required_live->issue_material_sgrp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_live->issue_material_sgrp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_issue_material_sgrp" data-value-separator="<?php echo $material_required_live->issue_material_sgrp->displayValueSeparatorAttribute() ?>" id="x_issue_material_sgrp" name="x_issue_material_sgrp"<?php echo $material_required_live->issue_material_sgrp->editAttributes() ?>>
		<?php echo $material_required_live->issue_material_sgrp->selectOptionListHtml("x_issue_material_sgrp") ?>
	</select>
</div>
<?php echo $material_required_live->issue_material_sgrp->Lookup->getParamTag("p_x_issue_material_sgrp") ?>
</span>
<?php echo $material_required_live->issue_material_sgrp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_product->Visible) { // issue_material_product ?>
	<div id="r_issue_material_product" class="form-group row">
		<label id="elh_material_required_live_issue_material_product" for="x_issue_material_product" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->issue_material_product->caption() ?><?php echo ($material_required_live->issue_material_product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_product->cellAttributes() ?>>
<span id="el_material_required_live_issue_material_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_issue_material_product" data-value-separator="<?php echo $material_required_live->issue_material_product->displayValueSeparatorAttribute() ?>" id="x_issue_material_product" name="x_issue_material_product"<?php echo $material_required_live->issue_material_product->editAttributes() ?>>
		<?php echo $material_required_live->issue_material_product->selectOptionListHtml("x_issue_material_product") ?>
	</select>
</div>
<?php echo $material_required_live->issue_material_product->Lookup->getParamTag("p_x_issue_material_product") ?>
</span>
<?php echo $material_required_live->issue_material_product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_rid->Visible) { // issue_material_rid ?>
	<div id="r_issue_material_rid" class="form-group row">
		<label id="elh_material_required_live_issue_material_rid" for="x_issue_material_rid" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->issue_material_rid->caption() ?><?php echo ($material_required_live->issue_material_rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_rid->cellAttributes() ?>>
<span id="el_material_required_live_issue_material_rid">
<input type="text" data-table="material_required_live" data-field="x_issue_material_rid" name="x_issue_material_rid" id="x_issue_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_live->issue_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_live->issue_material_rid->EditValue ?>"<?php echo $material_required_live->issue_material_rid->editAttributes() ?>>
</span>
<?php echo $material_required_live->issue_material_rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_packing->Visible) { // issue_material_packing ?>
	<div id="r_issue_material_packing" class="form-group row">
		<label id="elh_material_required_live_issue_material_packing" for="x_issue_material_packing" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->issue_material_packing->caption() ?><?php echo ($material_required_live->issue_material_packing->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_packing->cellAttributes() ?>>
<span id="el_material_required_live_issue_material_packing">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_issue_material_packing" data-value-separator="<?php echo $material_required_live->issue_material_packing->displayValueSeparatorAttribute() ?>" id="x_issue_material_packing" name="x_issue_material_packing"<?php echo $material_required_live->issue_material_packing->editAttributes() ?>>
		<?php echo $material_required_live->issue_material_packing->selectOptionListHtml("x_issue_material_packing") ?>
	</select>
</div>
<?php echo $material_required_live->issue_material_packing->Lookup->getParamTag("p_x_issue_material_packing") ?>
</span>
<?php echo $material_required_live->issue_material_packing->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_qty->Visible) { // issue_material_qty ?>
	<div id="r_issue_material_qty" class="form-group row">
		<label id="elh_material_required_live_issue_material_qty" for="x_issue_material_qty" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->issue_material_qty->caption() ?><?php echo ($material_required_live->issue_material_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_qty->cellAttributes() ?>>
<span id="el_material_required_live_issue_material_qty">
<input type="text" data-table="material_required_live" data-field="x_issue_material_qty" name="x_issue_material_qty" id="x_issue_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_live->issue_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_live->issue_material_qty->EditValue ?>"<?php echo $material_required_live->issue_material_qty->editAttributes() ?>>
</span>
<?php echo $material_required_live->issue_material_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label id="elh_material_required_live_unit" for="x_unit" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->unit->caption() ?><?php echo ($material_required_live->unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->unit->cellAttributes() ?>>
<span id="el_material_required_live_unit">
<span<?php echo $material_required_live->unit->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->unit->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_unit" name="x_unit" id="x_unit" value="<?php echo HtmlEncode($material_required_live->unit->CurrentValue) ?>">
<?php echo $material_required_live->unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->material_qty->Visible) { // material_qty ?>
	<div id="r_material_qty" class="form-group row">
		<label id="elh_material_required_live_material_qty" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->material_qty->caption() ?><?php echo ($material_required_live->material_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->material_qty->cellAttributes() ?>>
<span id="el_material_required_live_material_qty">
<span<?php echo $material_required_live->material_qty->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->material_qty->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_material_qty" name="x_material_qty" id="x_material_qty" value="<?php echo HtmlEncode($material_required_live->material_qty->CurrentValue) ?>">
<?php echo $material_required_live->material_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label id="elh_material_required_live_method" for="x_method" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->method->caption() ?><?php echo ($material_required_live->method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->method->cellAttributes() ?>>
<span id="el_material_required_live_method">
<span<?php echo $material_required_live->method->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->method->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_method" name="x_method" id="x_method" value="<?php echo HtmlEncode($material_required_live->method->CurrentValue) ?>">
<?php echo $material_required_live->method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_material_required_live_despatch_week" for="x_despatch_week" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->despatch_week->caption() ?><?php echo ($material_required_live->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->despatch_week->cellAttributes() ?>>
<span id="el_material_required_live_despatch_week">
<span<?php echo $material_required_live->despatch_week->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->despatch_week->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_despatch_week" name="x_despatch_week" id="x_despatch_week" value="<?php echo HtmlEncode($material_required_live->despatch_week->CurrentValue) ?>">
<?php echo $material_required_live->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_material_required_live_despatch_date" for="x_despatch_date" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->despatch_date->caption() ?><?php echo ($material_required_live->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->despatch_date->cellAttributes() ?>>
<span id="el_material_required_live_despatch_date">
<input type="text" data-table="material_required_live" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($material_required_live->despatch_date->getPlaceHolder()) ?>" value="<?php echo $material_required_live->despatch_date->EditValue ?>"<?php echo $material_required_live->despatch_date->editAttributes() ?>>
<?php if (!$material_required_live->despatch_date->ReadOnly && !$material_required_live->despatch_date->Disabled && !isset($material_required_live->despatch_date->EditAttrs["readonly"]) && !isset($material_required_live->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_liveedit", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $material_required_live->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label id="elh_material_required_live_production_plan" for="x_production_plan" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->production_plan->caption() ?><?php echo ($material_required_live->production_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->production_plan->cellAttributes() ?>>
<span id="el_material_required_live_production_plan">
<span<?php echo $material_required_live->production_plan->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($material_required_live->production_plan->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_production_plan" name="x_production_plan" id="x_production_plan" value="<?php echo HtmlEncode($material_required_live->production_plan->CurrentValue) ?>">
<?php echo $material_required_live->production_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->material_out->Visible) { // material_out ?>
	<div id="r_material_out" class="form-group row">
		<label id="elh_material_required_live_material_out" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->material_out->caption() ?><?php echo ($material_required_live->material_out->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->material_out->cellAttributes() ?>>
<span id="el_material_required_live_material_out">
<div id="tp_x_material_out" class="ew-template"><input type="radio" class="form-check-input" data-table="material_required_live" data-field="x_material_out" data-value-separator="<?php echo $material_required_live->material_out->displayValueSeparatorAttribute() ?>" name="x_material_out" id="x_material_out" value="{value}"<?php echo $material_required_live->material_out->editAttributes() ?>></div>
<div id="dsl_x_material_out" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_required_live->material_out->radioButtonListHtml(FALSE, "x_material_out") ?>
</div></div>
</span>
<?php echo $material_required_live->material_out->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label id="elh_material_required_live_issue_to" for="x_issue_to" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->issue_to->caption() ?><?php echo ($material_required_live->issue_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->issue_to->cellAttributes() ?>>
<span id="el_material_required_live_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_issue_to" data-value-separator="<?php echo $material_required_live->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_required_live->issue_to->editAttributes() ?>>
		<?php echo $material_required_live->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $material_required_live->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
<?php echo $material_required_live->issue_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label id="elh_material_required_live_pp_id" for="x_pp_id" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->pp_id->caption() ?><?php echo ($material_required_live->pp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->pp_id->cellAttributes() ?>>
<span id="el_material_required_live_pp_id">
<input type="text" data-table="material_required_live" data-field="x_pp_id" name="x_pp_id" id="x_pp_id" size="30" placeholder="<?php echo HtmlEncode($material_required_live->pp_id->getPlaceHolder()) ?>" value="<?php echo $material_required_live->pp_id->EditValue ?>"<?php echo $material_required_live->pp_id->editAttributes() ?>>
</span>
<?php echo $material_required_live->pp_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->level->Visible) { // level ?>
	<div id="r_level" class="form-group row">
		<label id="elh_material_required_live_level" for="x_level" class="<?php echo $material_required_live_edit->LeftColumnClass ?>"><?php echo $material_required_live->level->caption() ?><?php echo ($material_required_live->level->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $material_required_live_edit->RightColumnClass ?>"><div<?php echo $material_required_live->level->cellAttributes() ?>>
<span id="el_material_required_live_level">
<input type="text" data-table="material_required_live" data-field="x_level" name="x_level" id="x_level" size="30" placeholder="<?php echo HtmlEncode($material_required_live->level->getPlaceHolder()) ?>" value="<?php echo $material_required_live->level->EditValue ?>"<?php echo $material_required_live->level->editAttributes() ?>>
</span>
<?php echo $material_required_live->level->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_required_live_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_required_live_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $material_required_live_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_required_live_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_required_live_edit->terminate();
?>