<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_live_list = new material_required_live_list();

// Run the page
$material_required_live_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_live_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_required_live->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_required_livelist = currentForm = new ew.Form("fmaterial_required_livelist", "list");
fmaterial_required_livelist.formKeyCountName = '<?php echo $material_required_live_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_required_livelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_livelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_livelist.lists["x_weaving_works"] = <?php echo $material_required_live_list->weaving_works->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_weaving_works"].options = <?php echo JsonEncode($material_required_live_list->weaving_works->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_week"] = <?php echo $material_required_live_list->week->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_week"].options = <?php echo JsonEncode($material_required_live_list->week->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_buyer_id"] = <?php echo $material_required_live_list->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_live_list->buyer_id->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_product_id"] = <?php echo $material_required_live_list->product_id->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_product_id"].options = <?php echo JsonEncode($material_required_live_list->product_id->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_batch_no"] = <?php echo $material_required_live_list->batch_no->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_batch_no"].options = <?php echo JsonEncode($material_required_live_list->batch_no->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_req_material_rid"] = <?php echo $material_required_live_list->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_live_list->req_material_rid->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_req_material_packing"] = <?php echo $material_required_live_list->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_live_list->req_material_packing->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_issue_material_packing"] = <?php echo $material_required_live_list->issue_material_packing->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_issue_material_packing"].options = <?php echo JsonEncode($material_required_live_list->issue_material_packing->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_unit"] = <?php echo $material_required_live_list->unit->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_unit"].options = <?php echo JsonEncode($material_required_live_list->unit->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_material_qty"] = <?php echo $material_required_live_list->material_qty->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_material_qty"].options = <?php echo JsonEncode($material_required_live_list->material_qty->lookupOptions()) ?>;
fmaterial_required_livelist.autoSuggests["x_material_qty"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_required_livelist.lists["x_method"] = <?php echo $material_required_live_list->method->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_method"].options = <?php echo JsonEncode($material_required_live_list->method->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_despatch_week"] = <?php echo $material_required_live_list->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_live_list->despatch_week->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_operator"] = <?php echo $material_required_live_list->operator->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_operator"].options = <?php echo JsonEncode($material_required_live_list->operator->lookupOptions()) ?>;
fmaterial_required_livelist.lists["x_material_out"] = <?php echo $material_required_live_list->material_out->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_material_out"].options = <?php echo JsonEncode($material_required_live_list->material_out->options(FALSE, TRUE)) ?>;
fmaterial_required_livelist.lists["x_issue_to"] = <?php echo $material_required_live_list->issue_to->Lookup->toClientList() ?>;
fmaterial_required_livelist.lists["x_issue_to"].options = <?php echo JsonEncode($material_required_live_list->issue_to->lookupOptions()) ?>;

// Form object for search
var fmaterial_required_livelistsrch = currentSearchForm = new ew.Form("fmaterial_required_livelistsrch");

// Validate function for search
fmaterial_required_livelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_required_livelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_livelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_livelistsrch.lists["x_weaving_works"] = <?php echo $material_required_live_list->weaving_works->Lookup->toClientList() ?>;
fmaterial_required_livelistsrch.lists["x_weaving_works"].options = <?php echo JsonEncode($material_required_live_list->weaving_works->lookupOptions()) ?>;
fmaterial_required_livelistsrch.lists["x_week"] = <?php echo $material_required_live_list->week->Lookup->toClientList() ?>;
fmaterial_required_livelistsrch.lists["x_week"].options = <?php echo JsonEncode($material_required_live_list->week->lookupOptions()) ?>;
fmaterial_required_livelistsrch.lists["x_product_id"] = <?php echo $material_required_live_list->product_id->Lookup->toClientList() ?>;
fmaterial_required_livelistsrch.lists["x_product_id"].options = <?php echo JsonEncode($material_required_live_list->product_id->lookupOptions()) ?>;
fmaterial_required_livelistsrch.lists["x_req_material_packing"] = <?php echo $material_required_live_list->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_livelistsrch.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_live_list->req_material_packing->lookupOptions()) ?>;
fmaterial_required_livelistsrch.lists["x_method"] = <?php echo $material_required_live_list->method->Lookup->toClientList() ?>;
fmaterial_required_livelistsrch.lists["x_method"].options = <?php echo JsonEncode($material_required_live_list->method->lookupOptions()) ?>;

// Filters
fmaterial_required_livelistsrch.filterList = <?php echo $material_required_live_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_required_livelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_required_live->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_required_live_list->TotalRecs > 0 && $material_required_live_list->ExportOptions->visible()) { ?>
<?php $material_required_live_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_live_list->ImportOptions->visible()) { ?>
<?php $material_required_live_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_live_list->SearchOptions->visible()) { ?>
<?php $material_required_live_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_live_list->FilterOptions->visible()) { ?>
<?php $material_required_live_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$material_required_live->isExport() || EXPORT_MASTER_RECORD && $material_required_live->isExport("print")) { ?>
<?php
if ($material_required_live_list->DbMasterFilter <> "" && $material_required_live->getCurrentMasterTable() == "required_material_compiled_live") {
	if ($material_required_live_list->MasterRecordExists) {
		include_once "required_material_compiled_livemaster.php";
	}
}
?>
<?php } ?>
<?php
$material_required_live_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_required_live->isExport() && !$material_required_live->CurrentAction) { ?>
<form name="fmaterial_required_livelistsrch" id="fmaterial_required_livelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_required_live_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_required_livelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_required_live">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_required_live_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_required_live->RowType = ROWTYPE_SEARCH;

// Render row
$material_required_live->resetAttributes();
$material_required_live_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_required_live->weaving_works->Visible) { // weaving_works ?>
	<div id="xsc_weaving_works" class="ew-cell form-group">
		<label for="x_weaving_works" class="ew-search-caption ew-label"><?php echo $material_required_live->weaving_works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_weaving_works" data-value-separator="<?php echo $material_required_live->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $material_required_live->weaving_works->editAttributes() ?>>
		<?php echo $material_required_live->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $material_required_live->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_live->week->Visible) { // week ?>
	<div id="xsc_week" class="ew-cell form-group">
		<label for="x_week" class="ew-search-caption ew-label"><?php echo $material_required_live->week->caption() ?></label>
		<span class="ew-search-operator"><select name="z_week" id="z_week" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_week" data-value-separator="<?php echo $material_required_live->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $material_required_live->week->editAttributes() ?>>
		<?php echo $material_required_live->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $material_required_live->week->Lookup->getParamTag("p_x_week") ?>
</span>
		<span class="ew-search-cond btw1_week style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_week style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_week" data-value-separator="<?php echo $material_required_live->week->displayValueSeparatorAttribute() ?>" id="y_week" name="y_week"<?php echo $material_required_live->week->editAttributes() ?>>
		<?php echo $material_required_live->week->selectOptionListHtml("y_week") ?>
	</select>
</div>
<?php echo $material_required_live->week->Lookup->getParamTag("p_y_week") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_live->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $material_required_live->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required_live" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required_live->po->getPlaceHolder()) ?>" value="<?php echo $material_required_live->po->EditValue ?>"<?php echo $material_required_live->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="material_required_live" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($material_required_live->po->getPlaceHolder()) ?>" value="<?php echo $material_required_live->po->EditValue2 ?>"<?php echo $material_required_live->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($material_required_live->product_id->Visible) { // product_id ?>
	<div id="xsc_product_id" class="ew-cell form-group">
		<label for="x_product_id" class="ew-search-caption ew-label"><?php echo $material_required_live->product_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_id" id="z_product_id" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required_live" data-field="x_product_id" name="x_product_id" id="x_product_id" size="30" placeholder="<?php echo HtmlEncode($material_required_live->product_id->getPlaceHolder()) ?>" value="<?php echo $material_required_live->product_id->EditValue ?>"<?php echo $material_required_live->product_id->editAttributes() ?>>
<?php echo $material_required_live->product_id->Lookup->getParamTag("p_x_product_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_live->Size_wl->Visible) { // Size_wl ?>
	<div id="xsc_Size_wl" class="ew-cell form-group">
		<label for="x_Size_wl" class="ew-search-caption ew-label"><?php echo $material_required_live->Size_wl->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Size_wl" id="z_Size_wl" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required_live" data-field="x_Size_wl" name="x_Size_wl" id="x_Size_wl" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($material_required_live->Size_wl->getPlaceHolder()) ?>" value="<?php echo $material_required_live->Size_wl->EditValue ?>"<?php echo $material_required_live->Size_wl->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_packing->Visible) { // req_material_packing ?>
	<div id="xsc_req_material_packing" class="ew-cell form-group">
		<label for="x_req_material_packing" class="ew-search-caption ew-label"><?php echo $material_required_live->req_material_packing->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_req_material_packing" data-value-separator="<?php echo $material_required_live->req_material_packing->displayValueSeparatorAttribute() ?>" id="x_req_material_packing" name="x_req_material_packing"<?php echo $material_required_live->req_material_packing->editAttributes() ?>>
		<?php echo $material_required_live->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
	</select>
</div>
<?php echo $material_required_live->req_material_packing->Lookup->getParamTag("p_x_req_material_packing") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($material_required_live->method->Visible) { // method ?>
	<div id="xsc_method" class="ew-cell form-group">
		<label for="x_method" class="ew-search-caption ew-label"><?php echo $material_required_live->method->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_method" data-value-separator="<?php echo $material_required_live->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $material_required_live->method->editAttributes() ?>>
		<?php echo $material_required_live->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $material_required_live->method->Lookup->getParamTag("p_x_method") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_required_live_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_required_live_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_required_live_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_required_live_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_required_live_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_required_live_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_required_live_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_required_live_list->showPageHeader(); ?>
<?php
$material_required_live_list->showMessage();
?>
<?php if ($material_required_live_list->TotalRecs > 0 || $material_required_live->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_required_live_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_required_live">
<?php if (!$material_required_live->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_required_live->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_live_list->Pager)) $material_required_live_list->Pager = new PrevNextPager($material_required_live_list->StartRec, $material_required_live_list->DisplayRecs, $material_required_live_list->TotalRecs, $material_required_live_list->AutoHidePager) ?>
<?php if ($material_required_live_list->Pager->RecordCount > 0 && $material_required_live_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_live_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_live_list->pageUrl() ?>start=<?php echo $material_required_live_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_live_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_live_list->pageUrl() ?>start=<?php echo $material_required_live_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_live_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_live_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_live_list->pageUrl() ?>start=<?php echo $material_required_live_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_live_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_live_list->pageUrl() ?>start=<?php echo $material_required_live_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_live_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_live_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_live_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_live_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_live_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_live_list->TotalRecs > 0 && (!$material_required_live_list->AutoHidePageSizeSelector || $material_required_live_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_live">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_live_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_live_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_live_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_live_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_live_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_live->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_live_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_required_livelist" id="fmaterial_required_livelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_live_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_live_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_live">
<?php if ($material_required_live->getCurrentMasterTable() == "required_material_compiled_live" && $material_required_live->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="required_material_compiled_live">
<input type="hidden" name="fk_po" value="<?php echo $material_required_live->po->getSessionValue() ?>">
<input type="hidden" name="fk_req_material_rid" value="<?php echo $material_required_live->req_material_rid->getSessionValue() ?>">
<?php } ?>
<div id="gmp_material_required_live" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_required_live_list->TotalRecs > 0 || $material_required_live->isGridEdit()) { ?>
<table id="tbl_material_required_livelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_required_live_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_required_live_list->renderListOptions();

// Render list options (header, left)
$material_required_live_list->ListOptions->render("header", "left");
?>
<?php if ($material_required_live->id->Visible) { // id ?>
	<?php if ($material_required_live->sortUrl($material_required_live->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_required_live->id->headerCellClass() ?>"><div id="elh_material_required_live_id" class="material_required_live_id"><div class="ew-table-header-caption"><?php echo $material_required_live->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_required_live->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->id) ?>',2);"><div id="elh_material_required_live_id" class="material_required_live_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->poid->Visible) { // poid ?>
	<?php if ($material_required_live->sortUrl($material_required_live->poid) == "") { ?>
		<th data-name="poid" class="<?php echo $material_required_live->poid->headerCellClass() ?>"><div id="elh_material_required_live_poid" class="material_required_live_poid"><div class="ew-table-header-caption"><?php echo $material_required_live->poid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="poid" class="<?php echo $material_required_live->poid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->poid) ?>',2);"><div id="elh_material_required_live_poid" class="material_required_live_poid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->poid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->poid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->poid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->weaving_works->Visible) { // weaving_works ?>
	<?php if ($material_required_live->sortUrl($material_required_live->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $material_required_live->weaving_works->headerCellClass() ?>"><div id="elh_material_required_live_weaving_works" class="material_required_live_weaving_works"><div class="ew-table-header-caption"><?php echo $material_required_live->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $material_required_live->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->weaving_works) ?>',2);"><div id="elh_material_required_live_weaving_works" class="material_required_live_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->week->Visible) { // week ?>
	<?php if ($material_required_live->sortUrl($material_required_live->week) == "") { ?>
		<th data-name="week" class="<?php echo $material_required_live->week->headerCellClass() ?>"><div id="elh_material_required_live_week" class="material_required_live_week"><div class="ew-table-header-caption"><?php echo $material_required_live->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $material_required_live->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->week) ?>',2);"><div id="elh_material_required_live_week" class="material_required_live_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->po->Visible) { // po ?>
	<?php if ($material_required_live->sortUrl($material_required_live->po) == "") { ?>
		<th data-name="po" class="<?php echo $material_required_live->po->headerCellClass() ?>"><div id="elh_material_required_live_po" class="material_required_live_po"><div class="ew-table-header-caption"><?php echo $material_required_live->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $material_required_live->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->po) ?>',2);"><div id="elh_material_required_live_po" class="material_required_live_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->buyer_id->Visible) { // buyer_id ?>
	<?php if ($material_required_live->sortUrl($material_required_live->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_live->buyer_id->headerCellClass() ?>"><div id="elh_material_required_live_buyer_id" class="material_required_live_buyer_id"><div class="ew-table-header-caption"><?php echo $material_required_live->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_live->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->buyer_id) ?>',2);"><div id="elh_material_required_live_buyer_id" class="material_required_live_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->product_id->Visible) { // product_id ?>
	<?php if ($material_required_live->sortUrl($material_required_live->product_id) == "") { ?>
		<th data-name="product_id" class="<?php echo $material_required_live->product_id->headerCellClass() ?>"><div id="elh_material_required_live_product_id" class="material_required_live_product_id"><div class="ew-table-header-caption"><?php echo $material_required_live->product_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_id" class="<?php echo $material_required_live->product_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->product_id) ?>',2);"><div id="elh_material_required_live_product_id" class="material_required_live_product_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->product_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->product_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->product_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->batch_no->Visible) { // batch_no ?>
	<?php if ($material_required_live->sortUrl($material_required_live->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $material_required_live->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_live_batch_no" class="material_required_live_batch_no"><div class="ew-table-header-caption"><?php echo $material_required_live->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $material_required_live->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->batch_no) ?>',2);"><div id="elh_material_required_live_batch_no" class="material_required_live_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->quantity->Visible) { // quantity ?>
	<?php if ($material_required_live->sortUrl($material_required_live->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_required_live->quantity->headerCellClass() ?>"><div id="elh_material_required_live_quantity" class="material_required_live_quantity"><div class="ew-table-header-caption"><?php echo $material_required_live->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_required_live->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->quantity) ?>',2);"><div id="elh_material_required_live_quantity" class="material_required_live_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->Size_wl->Visible) { // Size_wl ?>
	<?php if ($material_required_live->sortUrl($material_required_live->Size_wl) == "") { ?>
		<th data-name="Size_wl" class="<?php echo $material_required_live->Size_wl->headerCellClass() ?>"><div id="elh_material_required_live_Size_wl" class="material_required_live_Size_wl"><div class="ew-table-header-caption"><?php echo $material_required_live->Size_wl->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Size_wl" class="<?php echo $material_required_live->Size_wl->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->Size_wl) ?>',2);"><div id="elh_material_required_live_Size_wl" class="material_required_live_Size_wl">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->Size_wl->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->Size_wl->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->Size_wl->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->sqm->Visible) { // sqm ?>
	<?php if ($material_required_live->sortUrl($material_required_live->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $material_required_live->sqm->headerCellClass() ?>"><div id="elh_material_required_live_sqm" class="material_required_live_sqm"><div class="ew-table-header-caption"><?php echo $material_required_live->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $material_required_live->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->sqm) ?>',2);"><div id="elh_material_required_live_sqm" class="material_required_live_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required_live->sortUrl($material_required_live->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_live->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_live_req_material_rid" class="material_required_live_req_material_rid"><div class="ew-table-header-caption"><?php echo $material_required_live->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_live->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->req_material_rid) ?>',2);"><div id="elh_material_required_live_req_material_rid" class="material_required_live_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required_live->sortUrl($material_required_live->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_live->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_live_req_material_qty" class="material_required_live_req_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_live->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_live->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->req_material_qty) ?>',2);"><div id="elh_material_required_live_req_material_qty" class="material_required_live_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->req_material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($material_required_live->sortUrl($material_required_live->req_material_packing) == "") { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_live->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_live_req_material_packing" class="material_required_live_req_material_packing"><div class="ew-table-header-caption"><?php echo $material_required_live->req_material_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_live->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->req_material_packing) ?>',2);"><div id="elh_material_required_live_req_material_packing" class="material_required_live_req_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->req_material_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->req_material_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->issue_material_rid->Visible) { // issue_material_rid ?>
	<?php if ($material_required_live->sortUrl($material_required_live->issue_material_rid) == "") { ?>
		<th data-name="issue_material_rid" class="<?php echo $material_required_live->issue_material_rid->headerCellClass() ?>"><div id="elh_material_required_live_issue_material_rid" class="material_required_live_issue_material_rid"><div class="ew-table-header-caption"><?php echo $material_required_live->issue_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_material_rid" class="<?php echo $material_required_live->issue_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->issue_material_rid) ?>',2);"><div id="elh_material_required_live_issue_material_rid" class="material_required_live_issue_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->issue_material_rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->issue_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->issue_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->issue_material_packing->Visible) { // issue_material_packing ?>
	<?php if ($material_required_live->sortUrl($material_required_live->issue_material_packing) == "") { ?>
		<th data-name="issue_material_packing" class="<?php echo $material_required_live->issue_material_packing->headerCellClass() ?>"><div id="elh_material_required_live_issue_material_packing" class="material_required_live_issue_material_packing"><div class="ew-table-header-caption"><?php echo $material_required_live->issue_material_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_material_packing" class="<?php echo $material_required_live->issue_material_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->issue_material_packing) ?>',2);"><div id="elh_material_required_live_issue_material_packing" class="material_required_live_issue_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->issue_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->issue_material_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->issue_material_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->issue_material_qty->Visible) { // issue_material_qty ?>
	<?php if ($material_required_live->sortUrl($material_required_live->issue_material_qty) == "") { ?>
		<th data-name="issue_material_qty" class="<?php echo $material_required_live->issue_material_qty->headerCellClass() ?>"><div id="elh_material_required_live_issue_material_qty" class="material_required_live_issue_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_live->issue_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_material_qty" class="<?php echo $material_required_live->issue_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->issue_material_qty) ?>',2);"><div id="elh_material_required_live_issue_material_qty" class="material_required_live_issue_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->issue_material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->issue_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->issue_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->unit->Visible) { // unit ?>
	<?php if ($material_required_live->sortUrl($material_required_live->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $material_required_live->unit->headerCellClass() ?>"><div id="elh_material_required_live_unit" class="material_required_live_unit"><div class="ew-table-header-caption"><?php echo $material_required_live->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $material_required_live->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->unit) ?>',2);"><div id="elh_material_required_live_unit" class="material_required_live_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->material_qty->Visible) { // material_qty ?>
	<?php if ($material_required_live->sortUrl($material_required_live->material_qty) == "") { ?>
		<th data-name="material_qty" class="<?php echo $material_required_live->material_qty->headerCellClass() ?>"><div id="elh_material_required_live_material_qty" class="material_required_live_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_live->material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_qty" class="<?php echo $material_required_live->material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->material_qty) ?>',2);"><div id="elh_material_required_live_material_qty" class="material_required_live_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->method->Visible) { // method ?>
	<?php if ($material_required_live->sortUrl($material_required_live->method) == "") { ?>
		<th data-name="method" class="<?php echo $material_required_live->method->headerCellClass() ?>"><div id="elh_material_required_live_method" class="material_required_live_method"><div class="ew-table-header-caption"><?php echo $material_required_live->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $material_required_live->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->method) ?>',2);"><div id="elh_material_required_live_method" class="material_required_live_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->despatch_week->Visible) { // despatch_week ?>
	<?php if ($material_required_live->sortUrl($material_required_live->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_live->despatch_week->headerCellClass() ?>"><div id="elh_material_required_live_despatch_week" class="material_required_live_despatch_week"><div class="ew-table-header-caption"><?php echo $material_required_live->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_live->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->despatch_week) ?>',2);"><div id="elh_material_required_live_despatch_week" class="material_required_live_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->despatch_date->Visible) { // despatch_date ?>
	<?php if ($material_required_live->sortUrl($material_required_live->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_live->despatch_date->headerCellClass() ?>"><div id="elh_material_required_live_despatch_date" class="material_required_live_despatch_date"><div class="ew-table-header-caption"><?php echo $material_required_live->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_live->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->despatch_date) ?>',2);"><div id="elh_material_required_live_despatch_date" class="material_required_live_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->despatch_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->operator->Visible) { // operator ?>
	<?php if ($material_required_live->sortUrl($material_required_live->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_required_live->operator->headerCellClass() ?>"><div id="elh_material_required_live_operator" class="material_required_live_operator"><div class="ew-table-header-caption"><?php echo $material_required_live->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_required_live->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->operator) ?>',2);"><div id="elh_material_required_live_operator" class="material_required_live_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->material_out->Visible) { // material_out ?>
	<?php if ($material_required_live->sortUrl($material_required_live->material_out) == "") { ?>
		<th data-name="material_out" class="<?php echo $material_required_live->material_out->headerCellClass() ?>"><div id="elh_material_required_live_material_out" class="material_required_live_material_out"><div class="ew-table-header-caption"><?php echo $material_required_live->material_out->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_out" class="<?php echo $material_required_live->material_out->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->material_out) ?>',2);"><div id="elh_material_required_live_material_out" class="material_required_live_material_out">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->material_out->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->material_out->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->material_out->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->order_id->Visible) { // order_id ?>
	<?php if ($material_required_live->sortUrl($material_required_live->order_id) == "") { ?>
		<th data-name="order_id" class="<?php echo $material_required_live->order_id->headerCellClass() ?>"><div id="elh_material_required_live_order_id" class="material_required_live_order_id"><div class="ew-table-header-caption"><?php echo $material_required_live->order_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_id" class="<?php echo $material_required_live->order_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->order_id) ?>',2);"><div id="elh_material_required_live_order_id" class="material_required_live_order_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->order_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->order_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->order_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->issue_to->Visible) { // issue_to ?>
	<?php if ($material_required_live->sortUrl($material_required_live->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $material_required_live->issue_to->headerCellClass() ?>"><div id="elh_material_required_live_issue_to" class="material_required_live_issue_to"><div class="ew-table-header-caption"><?php echo $material_required_live->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $material_required_live->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->issue_to) ?>',2);"><div id="elh_material_required_live_issue_to" class="material_required_live_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->pp_id->Visible) { // pp_id ?>
	<?php if ($material_required_live->sortUrl($material_required_live->pp_id) == "") { ?>
		<th data-name="pp_id" class="<?php echo $material_required_live->pp_id->headerCellClass() ?>"><div id="elh_material_required_live_pp_id" class="material_required_live_pp_id"><div class="ew-table-header-caption"><?php echo $material_required_live->pp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_id" class="<?php echo $material_required_live->pp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->pp_id) ?>',2);"><div id="elh_material_required_live_pp_id" class="material_required_live_pp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->pp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->pp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->pp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_live->level->Visible) { // level ?>
	<?php if ($material_required_live->sortUrl($material_required_live->level) == "") { ?>
		<th data-name="level" class="<?php echo $material_required_live->level->headerCellClass() ?>"><div id="elh_material_required_live_level" class="material_required_live_level"><div class="ew-table-header-caption"><?php echo $material_required_live->level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="level" class="<?php echo $material_required_live->level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_live->SortUrl($material_required_live->level) ?>',2);"><div id="elh_material_required_live_level" class="material_required_live_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_live->level->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_live->level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_live->level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_live_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_required_live->ExportAll && $material_required_live->isExport()) {
	$material_required_live_list->StopRec = $material_required_live_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_required_live_list->TotalRecs > $material_required_live_list->StartRec + $material_required_live_list->DisplayRecs - 1)
		$material_required_live_list->StopRec = $material_required_live_list->StartRec + $material_required_live_list->DisplayRecs - 1;
	else
		$material_required_live_list->StopRec = $material_required_live_list->TotalRecs;
}
$material_required_live_list->RecCnt = $material_required_live_list->StartRec - 1;
if ($material_required_live_list->Recordset && !$material_required_live_list->Recordset->EOF) {
	$material_required_live_list->Recordset->moveFirst();
	$selectLimit = $material_required_live_list->UseSelectLimit;
	if (!$selectLimit && $material_required_live_list->StartRec > 1)
		$material_required_live_list->Recordset->move($material_required_live_list->StartRec - 1);
} elseif (!$material_required_live->AllowAddDeleteRow && $material_required_live_list->StopRec == 0) {
	$material_required_live_list->StopRec = $material_required_live->GridAddRowCount;
}

// Initialize aggregate
$material_required_live->RowType = ROWTYPE_AGGREGATEINIT;
$material_required_live->resetAttributes();
$material_required_live_list->renderRow();
while ($material_required_live_list->RecCnt < $material_required_live_list->StopRec) {
	$material_required_live_list->RecCnt++;
	if ($material_required_live_list->RecCnt >= $material_required_live_list->StartRec) {
		$material_required_live_list->RowCnt++;

		// Set up key count
		$material_required_live_list->KeyCount = $material_required_live_list->RowIndex;

		// Init row class and style
		$material_required_live->resetAttributes();
		$material_required_live->CssClass = "";
		if ($material_required_live->isGridAdd()) {
		} else {
			$material_required_live_list->loadRowValues($material_required_live_list->Recordset); // Load row values
		}
		$material_required_live->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_required_live->RowAttrs = array_merge($material_required_live->RowAttrs, array('data-rowindex'=>$material_required_live_list->RowCnt, 'id'=>'r' . $material_required_live_list->RowCnt . '_material_required_live', 'data-rowtype'=>$material_required_live->RowType));

		// Render row
		$material_required_live_list->renderRow();

		// Render list options
		$material_required_live_list->renderListOptions();
?>
	<tr<?php echo $material_required_live->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_live_list->ListOptions->render("body", "left", $material_required_live_list->RowCnt);
?>
	<?php if ($material_required_live->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_required_live->id->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_id" class="material_required_live_id">
<span<?php echo $material_required_live->id->viewAttributes() ?>>
<?php echo $material_required_live->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->poid->Visible) { // poid ?>
		<td data-name="poid"<?php echo $material_required_live->poid->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_poid" class="material_required_live_poid">
<span<?php echo $material_required_live->poid->viewAttributes() ?>>
<?php echo $material_required_live->poid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $material_required_live->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_weaving_works" class="material_required_live_weaving_works">
<span<?php echo $material_required_live->weaving_works->viewAttributes() ?>>
<?php echo $material_required_live->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->week->Visible) { // week ?>
		<td data-name="week"<?php echo $material_required_live->week->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_week" class="material_required_live_week">
<span<?php echo $material_required_live->week->viewAttributes() ?>>
<?php echo $material_required_live->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->po->Visible) { // po ?>
		<td data-name="po"<?php echo $material_required_live->po->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_po" class="material_required_live_po">
<span<?php echo $material_required_live->po->viewAttributes() ?>>
<?php echo $material_required_live->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $material_required_live->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_buyer_id" class="material_required_live_buyer_id">
<span<?php echo $material_required_live->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_live->buyer_id->getViewValue())) && $material_required_live->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_live->buyer_id->linkAttributes() ?>><?php echo $material_required_live->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_live->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->product_id->Visible) { // product_id ?>
		<td data-name="product_id"<?php echo $material_required_live->product_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_product_id" class="material_required_live_product_id">
<span<?php echo $material_required_live->product_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_live->product_id->getViewValue())) && $material_required_live->product_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_live->product_id->linkAttributes() ?>><?php echo $material_required_live->product_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_live->product_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $material_required_live->batch_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_batch_no" class="material_required_live_batch_no">
<span<?php echo $material_required_live->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_live->batch_no->getViewValue())) && $material_required_live->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $material_required_live->batch_no->linkAttributes() ?>><?php echo $material_required_live->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_live->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_required_live->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_quantity" class="material_required_live_quantity">
<span<?php echo $material_required_live->quantity->viewAttributes() ?>>
<?php echo $material_required_live->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->Size_wl->Visible) { // Size_wl ?>
		<td data-name="Size_wl"<?php echo $material_required_live->Size_wl->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_Size_wl" class="material_required_live_Size_wl">
<span<?php echo $material_required_live->Size_wl->viewAttributes() ?>>
<?php echo $material_required_live->Size_wl->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $material_required_live->sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_sqm" class="material_required_live_sqm">
<span<?php echo $material_required_live->sqm->viewAttributes() ?>>
<?php echo $material_required_live->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $material_required_live->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_req_material_rid" class="material_required_live_req_material_rid">
<span<?php echo $material_required_live->req_material_rid->viewAttributes() ?>>
<?php echo $material_required_live->req_material_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $material_required_live->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_req_material_qty" class="material_required_live_req_material_qty">
<span<?php echo $material_required_live->req_material_qty->viewAttributes() ?>>
<?php echo $material_required_live->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing"<?php echo $material_required_live->req_material_packing->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_req_material_packing" class="material_required_live_req_material_packing">
<span<?php echo $material_required_live->req_material_packing->viewAttributes() ?>>
<?php echo $material_required_live->req_material_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->issue_material_rid->Visible) { // issue_material_rid ?>
		<td data-name="issue_material_rid"<?php echo $material_required_live->issue_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_issue_material_rid" class="material_required_live_issue_material_rid">
<span<?php echo $material_required_live->issue_material_rid->viewAttributes() ?>>
<?php echo $material_required_live->issue_material_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->issue_material_packing->Visible) { // issue_material_packing ?>
		<td data-name="issue_material_packing"<?php echo $material_required_live->issue_material_packing->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_issue_material_packing" class="material_required_live_issue_material_packing">
<span<?php echo $material_required_live->issue_material_packing->viewAttributes() ?>>
<?php echo $material_required_live->issue_material_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->issue_material_qty->Visible) { // issue_material_qty ?>
		<td data-name="issue_material_qty"<?php echo $material_required_live->issue_material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_issue_material_qty" class="material_required_live_issue_material_qty">
<span<?php echo $material_required_live->issue_material_qty->viewAttributes() ?>>
<?php echo $material_required_live->issue_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $material_required_live->unit->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_unit" class="material_required_live_unit">
<span<?php echo $material_required_live->unit->viewAttributes() ?>>
<?php echo $material_required_live->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty"<?php echo $material_required_live->material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_material_qty" class="material_required_live_material_qty">
<span<?php echo $material_required_live->material_qty->viewAttributes() ?>>
<?php echo $material_required_live->material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->method->Visible) { // method ?>
		<td data-name="method"<?php echo $material_required_live->method->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_method" class="material_required_live_method">
<span<?php echo $material_required_live->method->viewAttributes() ?>>
<?php echo $material_required_live->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $material_required_live->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_despatch_week" class="material_required_live_despatch_week">
<span<?php echo $material_required_live->despatch_week->viewAttributes() ?>>
<?php echo $material_required_live->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $material_required_live->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_despatch_date" class="material_required_live_despatch_date">
<span<?php echo $material_required_live->despatch_date->viewAttributes() ?>>
<?php echo $material_required_live->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_required_live->operator->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_operator" class="material_required_live_operator">
<span<?php echo $material_required_live->operator->viewAttributes() ?>>
<?php echo $material_required_live->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->material_out->Visible) { // material_out ?>
		<td data-name="material_out"<?php echo $material_required_live->material_out->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_material_out" class="material_required_live_material_out">
<span<?php echo $material_required_live->material_out->viewAttributes() ?>>
<?php echo $material_required_live->material_out->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->order_id->Visible) { // order_id ?>
		<td data-name="order_id"<?php echo $material_required_live->order_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_order_id" class="material_required_live_order_id">
<span<?php echo $material_required_live->order_id->viewAttributes() ?>>
<?php echo $material_required_live->order_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $material_required_live->issue_to->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_issue_to" class="material_required_live_issue_to">
<span<?php echo $material_required_live->issue_to->viewAttributes() ?>>
<?php echo $material_required_live->issue_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->pp_id->Visible) { // pp_id ?>
		<td data-name="pp_id"<?php echo $material_required_live->pp_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_pp_id" class="material_required_live_pp_id">
<span<?php echo $material_required_live->pp_id->viewAttributes() ?>>
<?php echo $material_required_live->pp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_live->level->Visible) { // level ?>
		<td data-name="level"<?php echo $material_required_live->level->cellAttributes() ?>>
<span id="el<?php echo $material_required_live_list->RowCnt ?>_material_required_live_level" class="material_required_live_level">
<span<?php echo $material_required_live->level->viewAttributes() ?>>
<?php echo $material_required_live->level->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_required_live_list->ListOptions->render("body", "right", $material_required_live_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_required_live->isGridAdd())
		$material_required_live_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$material_required_live->RowType = ROWTYPE_AGGREGATE;
$material_required_live->resetAttributes();
$material_required_live_list->renderRow();
?>
<?php if ($material_required_live_list->TotalRecs > 0 && !$material_required_live->isGridAdd() && !$material_required_live->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$material_required_live_list->renderListOptions();

// Render list options (footer, left)
$material_required_live_list->ListOptions->render("footer", "left");
?>
	<?php if ($material_required_live->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $material_required_live->id->footerCellClass() ?>"><span id="elf_material_required_live_id" class="material_required_live_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->poid->Visible) { // poid ?>
		<td data-name="poid" class="<?php echo $material_required_live->poid->footerCellClass() ?>"><span id="elf_material_required_live_poid" class="material_required_live_poid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works" class="<?php echo $material_required_live->weaving_works->footerCellClass() ?>"><span id="elf_material_required_live_weaving_works" class="material_required_live_weaving_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->week->Visible) { // week ?>
		<td data-name="week" class="<?php echo $material_required_live->week->footerCellClass() ?>"><span id="elf_material_required_live_week" class="material_required_live_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $material_required_live->po->footerCellClass() ?>"><span id="elf_material_required_live_po" class="material_required_live_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $material_required_live->buyer_id->footerCellClass() ?>"><span id="elf_material_required_live_buyer_id" class="material_required_live_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->product_id->Visible) { // product_id ?>
		<td data-name="product_id" class="<?php echo $material_required_live->product_id->footerCellClass() ?>"><span id="elf_material_required_live_product_id" class="material_required_live_product_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $material_required_live->batch_no->footerCellClass() ?>"><span id="elf_material_required_live_batch_no" class="material_required_live_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $material_required_live->quantity->footerCellClass() ?>"><span id="elf_material_required_live_quantity" class="material_required_live_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->Size_wl->Visible) { // Size_wl ?>
		<td data-name="Size_wl" class="<?php echo $material_required_live->Size_wl->footerCellClass() ?>"><span id="elf_material_required_live_Size_wl" class="material_required_live_Size_wl">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $material_required_live->sqm->footerCellClass() ?>"><span id="elf_material_required_live_sqm" class="material_required_live_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid" class="<?php echo $material_required_live->req_material_rid->footerCellClass() ?>"><span id="elf_material_required_live_req_material_rid" class="material_required_live_req_material_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty" class="<?php echo $material_required_live->req_material_qty->footerCellClass() ?>"><span id="elf_material_required_live_req_material_qty" class="material_required_live_req_material_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_required_live->req_material_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing" class="<?php echo $material_required_live->req_material_packing->footerCellClass() ?>"><span id="elf_material_required_live_req_material_packing" class="material_required_live_req_material_packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->issue_material_rid->Visible) { // issue_material_rid ?>
		<td data-name="issue_material_rid" class="<?php echo $material_required_live->issue_material_rid->footerCellClass() ?>"><span id="elf_material_required_live_issue_material_rid" class="material_required_live_issue_material_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->issue_material_packing->Visible) { // issue_material_packing ?>
		<td data-name="issue_material_packing" class="<?php echo $material_required_live->issue_material_packing->footerCellClass() ?>"><span id="elf_material_required_live_issue_material_packing" class="material_required_live_issue_material_packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->issue_material_qty->Visible) { // issue_material_qty ?>
		<td data-name="issue_material_qty" class="<?php echo $material_required_live->issue_material_qty->footerCellClass() ?>"><span id="elf_material_required_live_issue_material_qty" class="material_required_live_issue_material_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_required_live->issue_material_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->unit->Visible) { // unit ?>
		<td data-name="unit" class="<?php echo $material_required_live->unit->footerCellClass() ?>"><span id="elf_material_required_live_unit" class="material_required_live_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty" class="<?php echo $material_required_live->material_qty->footerCellClass() ?>"><span id="elf_material_required_live_material_qty" class="material_required_live_material_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->method->Visible) { // method ?>
		<td data-name="method" class="<?php echo $material_required_live->method->footerCellClass() ?>"><span id="elf_material_required_live_method" class="material_required_live_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week" class="<?php echo $material_required_live->despatch_week->footerCellClass() ?>"><span id="elf_material_required_live_despatch_week" class="material_required_live_despatch_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date" class="<?php echo $material_required_live->despatch_date->footerCellClass() ?>"><span id="elf_material_required_live_despatch_date" class="material_required_live_despatch_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $material_required_live->operator->footerCellClass() ?>"><span id="elf_material_required_live_operator" class="material_required_live_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->material_out->Visible) { // material_out ?>
		<td data-name="material_out" class="<?php echo $material_required_live->material_out->footerCellClass() ?>"><span id="elf_material_required_live_material_out" class="material_required_live_material_out">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->order_id->Visible) { // order_id ?>
		<td data-name="order_id" class="<?php echo $material_required_live->order_id->footerCellClass() ?>"><span id="elf_material_required_live_order_id" class="material_required_live_order_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $material_required_live->issue_to->footerCellClass() ?>"><span id="elf_material_required_live_issue_to" class="material_required_live_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->pp_id->Visible) { // pp_id ?>
		<td data-name="pp_id" class="<?php echo $material_required_live->pp_id->footerCellClass() ?>"><span id="elf_material_required_live_pp_id" class="material_required_live_pp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_live->level->Visible) { // level ?>
		<td data-name="level" class="<?php echo $material_required_live->level->footerCellClass() ?>"><span id="elf_material_required_live_level" class="material_required_live_level">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$material_required_live_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_required_live->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_required_live_list->Recordset)
	$material_required_live_list->Recordset->Close();
?>
<?php if (!$material_required_live->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_required_live->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_live_list->Pager)) $material_required_live_list->Pager = new PrevNextPager($material_required_live_list->StartRec, $material_required_live_list->DisplayRecs, $material_required_live_list->TotalRecs, $material_required_live_list->AutoHidePager) ?>
<?php if ($material_required_live_list->Pager->RecordCount > 0 && $material_required_live_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_live_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_live_list->pageUrl() ?>start=<?php echo $material_required_live_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_live_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_live_list->pageUrl() ?>start=<?php echo $material_required_live_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_live_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_live_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_live_list->pageUrl() ?>start=<?php echo $material_required_live_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_live_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_live_list->pageUrl() ?>start=<?php echo $material_required_live_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_live_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_live_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_live_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_live_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_live_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_live_list->TotalRecs > 0 && (!$material_required_live_list->AutoHidePageSizeSelector || $material_required_live_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_live">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_live_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_live_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_live_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_live_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_live_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_live->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_live_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_required_live_list->TotalRecs == 0 && !$material_required_live->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_required_live_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_required_live_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_required_live->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_required_live->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_required_live", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_required_live_list->terminate();
?>