<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_live_search = new material_required_live_search();

// Run the page
$material_required_live_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_live_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_required_live_search->IsModal) { ?>
var fmaterial_required_livesearch = currentAdvancedSearchForm = new ew.Form("fmaterial_required_livesearch", "search");
<?php } else { ?>
var fmaterial_required_livesearch = currentForm = new ew.Form("fmaterial_required_livesearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_required_livesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_livesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_livesearch.lists["x_weaving_works"] = <?php echo $material_required_live_search->weaving_works->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_weaving_works"].options = <?php echo JsonEncode($material_required_live_search->weaving_works->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_week"] = <?php echo $material_required_live_search->week->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_week"].options = <?php echo JsonEncode($material_required_live_search->week->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_buyer_id"] = <?php echo $material_required_live_search->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_live_search->buyer_id->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_grp"] = <?php echo $material_required_live_search->grp->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_grp"].options = <?php echo JsonEncode($material_required_live_search->grp->options(FALSE, TRUE)) ?>;
fmaterial_required_livesearch.lists["x_s_grp"] = <?php echo $material_required_live_search->s_grp->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_s_grp"].options = <?php echo JsonEncode($material_required_live_search->s_grp->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_product"] = <?php echo $material_required_live_search->product->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_product"].options = <?php echo JsonEncode($material_required_live_search->product->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_product_id"] = <?php echo $material_required_live_search->product_id->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_product_id"].options = <?php echo JsonEncode($material_required_live_search->product_id->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_req_material_sgrp"] = <?php echo $material_required_live_search->req_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_req_material_sgrp"].options = <?php echo JsonEncode($material_required_live_search->req_material_sgrp->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_req_material_product"] = <?php echo $material_required_live_search->req_material_product->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_req_material_product"].options = <?php echo JsonEncode($material_required_live_search->req_material_product->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_req_material_rid"] = <?php echo $material_required_live_search->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_live_search->req_material_rid->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_req_material_packing"] = <?php echo $material_required_live_search->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_live_search->req_material_packing->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_issue_material_sgrp"] = <?php echo $material_required_live_search->issue_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_issue_material_sgrp"].options = <?php echo JsonEncode($material_required_live_search->issue_material_sgrp->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_issue_material_product"] = <?php echo $material_required_live_search->issue_material_product->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_issue_material_product"].options = <?php echo JsonEncode($material_required_live_search->issue_material_product->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_issue_material_packing"] = <?php echo $material_required_live_search->issue_material_packing->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_issue_material_packing"].options = <?php echo JsonEncode($material_required_live_search->issue_material_packing->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_unit"] = <?php echo $material_required_live_search->unit->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_unit"].options = <?php echo JsonEncode($material_required_live_search->unit->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_material_qty"] = <?php echo $material_required_live_search->material_qty->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_material_qty"].options = <?php echo JsonEncode($material_required_live_search->material_qty->lookupOptions()) ?>;
fmaterial_required_livesearch.autoSuggests["x_material_qty"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_required_livesearch.lists["x_method"] = <?php echo $material_required_live_search->method->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_method"].options = <?php echo JsonEncode($material_required_live_search->method->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_despatch_week"] = <?php echo $material_required_live_search->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_live_search->despatch_week->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_production_plan"] = <?php echo $material_required_live_search->production_plan->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_production_plan"].options = <?php echo JsonEncode($material_required_live_search->production_plan->options(FALSE, TRUE)) ?>;
fmaterial_required_livesearch.lists["x_operator"] = <?php echo $material_required_live_search->operator->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_operator"].options = <?php echo JsonEncode($material_required_live_search->operator->lookupOptions()) ?>;
fmaterial_required_livesearch.lists["x_material_out"] = <?php echo $material_required_live_search->material_out->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_material_out"].options = <?php echo JsonEncode($material_required_live_search->material_out->options(FALSE, TRUE)) ?>;
fmaterial_required_livesearch.lists["x_issue_to"] = <?php echo $material_required_live_search->issue_to->Lookup->toClientList() ?>;
fmaterial_required_livesearch.lists["x_issue_to"].options = <?php echo JsonEncode($material_required_live_search->issue_to->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmaterial_required_livesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_poid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->poid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_req_material_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->req_material_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_req_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->req_material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_material_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->issue_material_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_material_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->issue_material_rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->issue_material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->despatch_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pp_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->pp_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_level");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_live->level->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_required_live_search->showPageHeader(); ?>
<?php
$material_required_live_search->showMessage();
?>
<form name="fmaterial_required_livesearch" id="fmaterial_required_livesearch" class="<?php echo $material_required_live_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_live_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_live_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_live">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_required_live_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_required_live->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_id"><?php echo $material_required_live->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->id->cellAttributes() ?>>
			<span id="el_material_required_live_id">
<input type="text" data-table="material_required_live" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_required_live->id->getPlaceHolder()) ?>" value="<?php echo $material_required_live->id->EditValue ?>"<?php echo $material_required_live->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label for="x_poid" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_poid"><?php echo $material_required_live->poid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_poid" id="z_poid" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->poid->cellAttributes() ?>>
			<span id="el_material_required_live_poid">
<input type="text" data-table="material_required_live" data-field="x_poid" name="x_poid" id="x_poid" size="30" placeholder="<?php echo HtmlEncode($material_required_live->poid->getPlaceHolder()) ?>" value="<?php echo $material_required_live->poid->EditValue ?>"<?php echo $material_required_live->poid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_weaving_works"><?php echo $material_required_live->weaving_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->weaving_works->cellAttributes() ?>>
			<span id="el_material_required_live_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_weaving_works" data-value-separator="<?php echo $material_required_live->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $material_required_live->weaving_works->editAttributes() ?>>
		<?php echo $material_required_live->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $material_required_live->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->week->Visible) { // week ?>
	<div id="r_week" class="form-group row">
		<label for="x_week" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_week"><?php echo $material_required_live->week->caption() ?></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->week->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_week" id="z_week" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($material_required_live->week->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_required_live_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_week" data-value-separator="<?php echo $material_required_live->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $material_required_live->week->editAttributes() ?>>
		<?php echo $material_required_live->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $material_required_live->week->Lookup->getParamTag("p_x_week") ?>
</span>
			<span class="ew-search-cond btw1_week d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_required_live_week" class="btw1_week d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_week" data-value-separator="<?php echo $material_required_live->week->displayValueSeparatorAttribute() ?>" id="y_week" name="y_week"<?php echo $material_required_live->week->editAttributes() ?>>
		<?php echo $material_required_live->week->selectOptionListHtml("y_week") ?>
	</select>
</div>
<?php echo $material_required_live->week->Lookup->getParamTag("p_y_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_po"><?php echo $material_required_live->po->caption() ?></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required_live->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_required_live_po">
<input type="text" data-table="material_required_live" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required_live->po->getPlaceHolder()) ?>" value="<?php echo $material_required_live->po->EditValue ?>"<?php echo $material_required_live->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_required_live_po" class="btw1_po d-none">
<input type="text" data-table="material_required_live" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($material_required_live->po->getPlaceHolder()) ?>" value="<?php echo $material_required_live->po->EditValue2 ?>"<?php echo $material_required_live->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_buyer_id"><?php echo $material_required_live->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->buyer_id->cellAttributes() ?>>
			<span id="el_material_required_live_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_buyer_id" data-value-separator="<?php echo $material_required_live->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $material_required_live->buyer_id->editAttributes() ?>>
		<?php echo $material_required_live->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $material_required_live->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_grp"><?php echo $material_required_live->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->grp->cellAttributes() ?>>
			<span id="el_material_required_live_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_grp" data-value-separator="<?php echo $material_required_live->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_required_live->grp->editAttributes() ?>>
		<?php echo $material_required_live->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_s_grp"><?php echo $material_required_live->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->s_grp->cellAttributes() ?>>
			<span id="el_material_required_live_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_s_grp" data-value-separator="<?php echo $material_required_live->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_required_live->s_grp->editAttributes() ?>>
		<?php echo $material_required_live->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_required_live->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_product"><?php echo $material_required_live->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->product->cellAttributes() ?>>
			<span id="el_material_required_live_product">
<input type="text" data-table="material_required_live" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($material_required_live->product->getPlaceHolder()) ?>" value="<?php echo $material_required_live->product->EditValue ?>"<?php echo $material_required_live->product->editAttributes() ?>>
<?php echo $material_required_live->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->product_id->Visible) { // product_id ?>
	<div id="r_product_id" class="form-group row">
		<label for="x_product_id" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_product_id"><?php echo $material_required_live->product_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_id" id="z_product_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->product_id->cellAttributes() ?>>
			<span id="el_material_required_live_product_id">
<input type="text" data-table="material_required_live" data-field="x_product_id" name="x_product_id" id="x_product_id" size="30" placeholder="<?php echo HtmlEncode($material_required_live->product_id->getPlaceHolder()) ?>" value="<?php echo $material_required_live->product_id->EditValue ?>"<?php echo $material_required_live->product_id->editAttributes() ?>>
<?php echo $material_required_live->product_id->Lookup->getParamTag("p_x_product_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_quantity"><?php echo $material_required_live->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->quantity->cellAttributes() ?>>
			<span id="el_material_required_live_quantity">
<input type="text" data-table="material_required_live" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_required_live->quantity->getPlaceHolder()) ?>" value="<?php echo $material_required_live->quantity->EditValue ?>"<?php echo $material_required_live->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->Size_wl->Visible) { // Size_wl ?>
	<div id="r_Size_wl" class="form-group row">
		<label for="x_Size_wl" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_Size_wl"><?php echo $material_required_live->Size_wl->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Size_wl" id="z_Size_wl" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->Size_wl->cellAttributes() ?>>
			<span id="el_material_required_live_Size_wl">
<input type="text" data-table="material_required_live" data-field="x_Size_wl" name="x_Size_wl" id="x_Size_wl" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($material_required_live->Size_wl->getPlaceHolder()) ?>" value="<?php echo $material_required_live->Size_wl->EditValue ?>"<?php echo $material_required_live->Size_wl->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_sqm"><?php echo $material_required_live->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->sqm->cellAttributes() ?>>
			<span id="el_material_required_live_sqm">
<input type="text" data-table="material_required_live" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($material_required_live->sqm->getPlaceHolder()) ?>" value="<?php echo $material_required_live->sqm->EditValue ?>"<?php echo $material_required_live->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_grp->Visible) { // req_material_grp ?>
	<div id="r_req_material_grp" class="form-group row">
		<label for="x_req_material_grp" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_req_material_grp"><?php echo $material_required_live->req_material_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_grp" id="z_req_material_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_grp->cellAttributes() ?>>
			<span id="el_material_required_live_req_material_grp">
<input type="text" data-table="material_required_live" data-field="x_req_material_grp" name="x_req_material_grp" id="x_req_material_grp" size="30" placeholder="<?php echo HtmlEncode($material_required_live->req_material_grp->getPlaceHolder()) ?>" value="<?php echo $material_required_live->req_material_grp->EditValue ?>"<?php echo $material_required_live->req_material_grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<div id="r_req_material_sgrp" class="form-group row">
		<label for="x_req_material_sgrp" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_req_material_sgrp"><?php echo $material_required_live->req_material_sgrp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_sgrp" id="z_req_material_sgrp" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_sgrp->cellAttributes() ?>>
			<span id="el_material_required_live_req_material_sgrp">
<?php $material_required_live->req_material_sgrp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_live->req_material_sgrp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_req_material_sgrp" data-value-separator="<?php echo $material_required_live->req_material_sgrp->displayValueSeparatorAttribute() ?>" id="x_req_material_sgrp" name="x_req_material_sgrp"<?php echo $material_required_live->req_material_sgrp->editAttributes() ?>>
		<?php echo $material_required_live->req_material_sgrp->selectOptionListHtml("x_req_material_sgrp") ?>
	</select>
</div>
<?php echo $material_required_live->req_material_sgrp->Lookup->getParamTag("p_x_req_material_sgrp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_product->Visible) { // req_material_product ?>
	<div id="r_req_material_product" class="form-group row">
		<label for="x_req_material_product" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_req_material_product"><?php echo $material_required_live->req_material_product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_product" id="z_req_material_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_product->cellAttributes() ?>>
			<span id="el_material_required_live_req_material_product">
<?php $material_required_live->req_material_product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_live->req_material_product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_req_material_product" data-value-separator="<?php echo $material_required_live->req_material_product->displayValueSeparatorAttribute() ?>" id="x_req_material_product" name="x_req_material_product"<?php echo $material_required_live->req_material_product->editAttributes() ?>>
		<?php echo $material_required_live->req_material_product->selectOptionListHtml("x_req_material_product") ?>
	</select>
</div>
<?php echo $material_required_live->req_material_product->Lookup->getParamTag("p_x_req_material_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_rid->Visible) { // req_material_rid ?>
	<div id="r_req_material_rid" class="form-group row">
		<label class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_req_material_rid"><?php echo $material_required_live->req_material_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_rid->cellAttributes() ?>>
			<span id="el_material_required_live_req_material_rid">
<input type="text" data-table="material_required_live" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_live->req_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_live->req_material_rid->EditValue ?>"<?php echo $material_required_live->req_material_rid->editAttributes() ?>>
<?php echo $material_required_live->req_material_rid->Lookup->getParamTag("p_x_req_material_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_qty->Visible) { // req_material_qty ?>
	<div id="r_req_material_qty" class="form-group row">
		<label for="x_req_material_qty" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_req_material_qty"><?php echo $material_required_live->req_material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_qty" id="z_req_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_qty->cellAttributes() ?>>
			<span id="el_material_required_live_req_material_qty">
<input type="text" data-table="material_required_live" data-field="x_req_material_qty" name="x_req_material_qty" id="x_req_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_live->req_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_live->req_material_qty->EditValue ?>"<?php echo $material_required_live->req_material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->req_material_packing->Visible) { // req_material_packing ?>
	<div id="r_req_material_packing" class="form-group row">
		<label for="x_req_material_packing" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_req_material_packing"><?php echo $material_required_live->req_material_packing->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->req_material_packing->cellAttributes() ?>>
			<span id="el_material_required_live_req_material_packing">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_req_material_packing" data-value-separator="<?php echo $material_required_live->req_material_packing->displayValueSeparatorAttribute() ?>" id="x_req_material_packing" name="x_req_material_packing"<?php echo $material_required_live->req_material_packing->editAttributes() ?>>
		<?php echo $material_required_live->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
	</select>
</div>
<?php echo $material_required_live->req_material_packing->Lookup->getParamTag("p_x_req_material_packing") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_grp->Visible) { // issue_material_grp ?>
	<div id="r_issue_material_grp" class="form-group row">
		<label for="x_issue_material_grp" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_issue_material_grp"><?php echo $material_required_live->issue_material_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_grp" id="z_issue_material_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_grp->cellAttributes() ?>>
			<span id="el_material_required_live_issue_material_grp">
<input type="text" data-table="material_required_live" data-field="x_issue_material_grp" name="x_issue_material_grp" id="x_issue_material_grp" size="30" placeholder="<?php echo HtmlEncode($material_required_live->issue_material_grp->getPlaceHolder()) ?>" value="<?php echo $material_required_live->issue_material_grp->EditValue ?>"<?php echo $material_required_live->issue_material_grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_sgrp->Visible) { // issue_material_sgrp ?>
	<div id="r_issue_material_sgrp" class="form-group row">
		<label for="x_issue_material_sgrp" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_issue_material_sgrp"><?php echo $material_required_live->issue_material_sgrp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_sgrp" id="z_issue_material_sgrp" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_sgrp->cellAttributes() ?>>
			<span id="el_material_required_live_issue_material_sgrp">
<?php $material_required_live->issue_material_sgrp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_live->issue_material_sgrp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_issue_material_sgrp" data-value-separator="<?php echo $material_required_live->issue_material_sgrp->displayValueSeparatorAttribute() ?>" id="x_issue_material_sgrp" name="x_issue_material_sgrp"<?php echo $material_required_live->issue_material_sgrp->editAttributes() ?>>
		<?php echo $material_required_live->issue_material_sgrp->selectOptionListHtml("x_issue_material_sgrp") ?>
	</select>
</div>
<?php echo $material_required_live->issue_material_sgrp->Lookup->getParamTag("p_x_issue_material_sgrp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_product->Visible) { // issue_material_product ?>
	<div id="r_issue_material_product" class="form-group row">
		<label for="x_issue_material_product" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_issue_material_product"><?php echo $material_required_live->issue_material_product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_product" id="z_issue_material_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_product->cellAttributes() ?>>
			<span id="el_material_required_live_issue_material_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_issue_material_product" data-value-separator="<?php echo $material_required_live->issue_material_product->displayValueSeparatorAttribute() ?>" id="x_issue_material_product" name="x_issue_material_product"<?php echo $material_required_live->issue_material_product->editAttributes() ?>>
		<?php echo $material_required_live->issue_material_product->selectOptionListHtml("x_issue_material_product") ?>
	</select>
</div>
<?php echo $material_required_live->issue_material_product->Lookup->getParamTag("p_x_issue_material_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_rid->Visible) { // issue_material_rid ?>
	<div id="r_issue_material_rid" class="form-group row">
		<label for="x_issue_material_rid" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_issue_material_rid"><?php echo $material_required_live->issue_material_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_rid" id="z_issue_material_rid" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_rid->cellAttributes() ?>>
			<span id="el_material_required_live_issue_material_rid">
<input type="text" data-table="material_required_live" data-field="x_issue_material_rid" name="x_issue_material_rid" id="x_issue_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_live->issue_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_live->issue_material_rid->EditValue ?>"<?php echo $material_required_live->issue_material_rid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_packing->Visible) { // issue_material_packing ?>
	<div id="r_issue_material_packing" class="form-group row">
		<label for="x_issue_material_packing" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_issue_material_packing"><?php echo $material_required_live->issue_material_packing->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_packing" id="z_issue_material_packing" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_packing->cellAttributes() ?>>
			<span id="el_material_required_live_issue_material_packing">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_issue_material_packing" data-value-separator="<?php echo $material_required_live->issue_material_packing->displayValueSeparatorAttribute() ?>" id="x_issue_material_packing" name="x_issue_material_packing"<?php echo $material_required_live->issue_material_packing->editAttributes() ?>>
		<?php echo $material_required_live->issue_material_packing->selectOptionListHtml("x_issue_material_packing") ?>
	</select>
</div>
<?php echo $material_required_live->issue_material_packing->Lookup->getParamTag("p_x_issue_material_packing") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_material_qty->Visible) { // issue_material_qty ?>
	<div id="r_issue_material_qty" class="form-group row">
		<label for="x_issue_material_qty" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_issue_material_qty"><?php echo $material_required_live->issue_material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_material_qty" id="z_issue_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->issue_material_qty->cellAttributes() ?>>
			<span id="el_material_required_live_issue_material_qty">
<input type="text" data-table="material_required_live" data-field="x_issue_material_qty" name="x_issue_material_qty" id="x_issue_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_live->issue_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_live->issue_material_qty->EditValue ?>"<?php echo $material_required_live->issue_material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_unit"><?php echo $material_required_live->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->unit->cellAttributes() ?>>
			<span id="el_material_required_live_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_unit" data-value-separator="<?php echo $material_required_live->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $material_required_live->unit->editAttributes() ?>>
		<?php echo $material_required_live->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $material_required_live->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->material_qty->Visible) { // material_qty ?>
	<div id="r_material_qty" class="form-group row">
		<label class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_material_qty"><?php echo $material_required_live->material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_qty" id="z_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->material_qty->cellAttributes() ?>>
			<span id="el_material_required_live_material_qty">
<?php
$wrkonchange = "" . trim(@$material_required_live->material_qty->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_required_live->material_qty->EditAttrs["onchange"] = "";
?>
<span id="as_x_material_qty" class="text-nowrap" style="z-index: 8720">
	<input type="text" class="form-control" name="sv_x_material_qty" id="sv_x_material_qty" value="<?php echo RemoveHtml($material_required_live->material_qty->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_required_live->material_qty->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_required_live->material_qty->getPlaceHolder()) ?>"<?php echo $material_required_live->material_qty->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_required_live" data-field="x_material_qty" data-value-separator="<?php echo $material_required_live->material_qty->displayValueSeparatorAttribute() ?>" name="x_material_qty" id="x_material_qty" value="<?php echo HtmlEncode($material_required_live->material_qty->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_required_livesearch.createAutoSuggest({"id":"x_material_qty","forceSelect":false});
</script>
<?php echo $material_required_live->material_qty->Lookup->getParamTag("p_x_material_qty") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_method"><?php echo $material_required_live->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->method->cellAttributes() ?>>
			<span id="el_material_required_live_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_method" data-value-separator="<?php echo $material_required_live->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $material_required_live->method->editAttributes() ?>>
		<?php echo $material_required_live->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $material_required_live->method->Lookup->getParamTag("p_x_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_despatch_week"><?php echo $material_required_live->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->despatch_week->cellAttributes() ?>>
			<span id="el_material_required_live_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_despatch_week" data-value-separator="<?php echo $material_required_live->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $material_required_live->despatch_week->editAttributes() ?>>
		<?php echo $material_required_live->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $material_required_live->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_despatch_date"><?php echo $material_required_live->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->despatch_date->cellAttributes() ?>>
			<span id="el_material_required_live_despatch_date">
<input type="text" data-table="material_required_live" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($material_required_live->despatch_date->getPlaceHolder()) ?>" value="<?php echo $material_required_live->despatch_date->EditValue ?>"<?php echo $material_required_live->despatch_date->editAttributes() ?>>
<?php if (!$material_required_live->despatch_date->ReadOnly && !$material_required_live->despatch_date->Disabled && !isset($material_required_live->despatch_date->EditAttrs["readonly"]) && !isset($material_required_live->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_livesearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_production_plan"><?php echo $material_required_live->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->production_plan->cellAttributes() ?>>
			<span id="el_material_required_live_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_production_plan" data-value-separator="<?php echo $material_required_live->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $material_required_live->production_plan->editAttributes() ?>>
		<?php echo $material_required_live->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_operator"><?php echo $material_required_live->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->operator->cellAttributes() ?>>
			<span id="el_material_required_live_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_operator" data-value-separator="<?php echo $material_required_live->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $material_required_live->operator->editAttributes() ?>>
		<?php echo $material_required_live->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $material_required_live->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_datetime"><?php echo $material_required_live->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->datetime->cellAttributes() ?>>
			<span id="el_material_required_live_datetime">
<input type="text" data-table="material_required_live" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($material_required_live->datetime->getPlaceHolder()) ?>" value="<?php echo $material_required_live->datetime->EditValue ?>"<?php echo $material_required_live->datetime->editAttributes() ?>>
<?php if (!$material_required_live->datetime->ReadOnly && !$material_required_live->datetime->Disabled && !isset($material_required_live->datetime->EditAttrs["readonly"]) && !isset($material_required_live->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_livesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->material_out->Visible) { // material_out ?>
	<div id="r_material_out" class="form-group row">
		<label class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_material_out"><?php echo $material_required_live->material_out->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_out" id="z_material_out" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->material_out->cellAttributes() ?>>
			<span id="el_material_required_live_material_out">
<div id="tp_x_material_out" class="ew-template"><input type="radio" class="form-check-input" data-table="material_required_live" data-field="x_material_out" data-value-separator="<?php echo $material_required_live->material_out->displayValueSeparatorAttribute() ?>" name="x_material_out" id="x_material_out" value="{value}"<?php echo $material_required_live->material_out->editAttributes() ?>></div>
<div id="dsl_x_material_out" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $material_required_live->material_out->radioButtonListHtml(FALSE, "x_material_out") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label for="x_issue_to" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_issue_to"><?php echo $material_required_live->issue_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->issue_to->cellAttributes() ?>>
			<span id="el_material_required_live_issue_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_live" data-field="x_issue_to" data-value-separator="<?php echo $material_required_live->issue_to->displayValueSeparatorAttribute() ?>" id="x_issue_to" name="x_issue_to"<?php echo $material_required_live->issue_to->editAttributes() ?>>
		<?php echo $material_required_live->issue_to->selectOptionListHtml("x_issue_to") ?>
	</select>
</div>
<?php echo $material_required_live->issue_to->Lookup->getParamTag("p_x_issue_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label for="x_pp_id" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_pp_id"><?php echo $material_required_live->pp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pp_id" id="z_pp_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->pp_id->cellAttributes() ?>>
			<span id="el_material_required_live_pp_id">
<input type="text" data-table="material_required_live" data-field="x_pp_id" name="x_pp_id" id="x_pp_id" size="30" placeholder="<?php echo HtmlEncode($material_required_live->pp_id->getPlaceHolder()) ?>" value="<?php echo $material_required_live->pp_id->EditValue ?>"<?php echo $material_required_live->pp_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_live->level->Visible) { // level ?>
	<div id="r_level" class="form-group row">
		<label for="x_level" class="<?php echo $material_required_live_search->LeftColumnClass ?>"><span id="elh_material_required_live_level"><?php echo $material_required_live->level->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_level" id="z_level" value="="></span>
		</label>
		<div class="<?php echo $material_required_live_search->RightColumnClass ?>"><div<?php echo $material_required_live->level->cellAttributes() ?>>
			<span id="el_material_required_live_level">
<input type="text" data-table="material_required_live" data-field="x_level" name="x_level" id="x_level" size="30" placeholder="<?php echo HtmlEncode($material_required_live->level->getPlaceHolder()) ?>" value="<?php echo $material_required_live->level->EditValue ?>"<?php echo $material_required_live->level->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_required_live_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_required_live_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_required_live_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_required_live_search->terminate();
?>