<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_monthly_cross_company_list = new material_required_monthly_cross_company_list();

// Run the page
$material_required_monthly_cross_company_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_monthly_cross_company_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_required_monthly_cross_company->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_required_monthly_cross_companylist = currentForm = new ew.Form("fmaterial_required_monthly_cross_companylist", "list");
fmaterial_required_monthly_cross_companylist.formKeyCountName = '<?php echo $material_required_monthly_cross_company_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_required_monthly_cross_companylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_monthly_cross_companylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_monthly_cross_companylist.lists["x_month"] = <?php echo $material_required_monthly_cross_company_list->month->Lookup->toClientList() ?>;
fmaterial_required_monthly_cross_companylist.lists["x_month"].options = <?php echo JsonEncode($material_required_monthly_cross_company_list->month->lookupOptions()) ?>;
fmaterial_required_monthly_cross_companylist.lists["x_buyer"] = <?php echo $material_required_monthly_cross_company_list->buyer->Lookup->toClientList() ?>;
fmaterial_required_monthly_cross_companylist.lists["x_buyer"].options = <?php echo JsonEncode($material_required_monthly_cross_company_list->buyer->lookupOptions()) ?>;
fmaterial_required_monthly_cross_companylist.lists["x_processed_by"] = <?php echo $material_required_monthly_cross_company_list->processed_by->Lookup->toClientList() ?>;
fmaterial_required_monthly_cross_companylist.lists["x_processed_by"].options = <?php echo JsonEncode($material_required_monthly_cross_company_list->processed_by->lookupOptions()) ?>;
fmaterial_required_monthly_cross_companylist.autoSuggests["x_processed_by"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_required_monthly_cross_companylist.lists["x_design_id"] = <?php echo $material_required_monthly_cross_company_list->design_id->Lookup->toClientList() ?>;
fmaterial_required_monthly_cross_companylist.lists["x_design_id"].options = <?php echo JsonEncode($material_required_monthly_cross_company_list->design_id->lookupOptions()) ?>;
fmaterial_required_monthly_cross_companylist.lists["x_req_material_rid"] = <?php echo $material_required_monthly_cross_company_list->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_monthly_cross_companylist.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_monthly_cross_company_list->req_material_rid->lookupOptions()) ?>;
fmaterial_required_monthly_cross_companylist.lists["x_req_material_packing"] = <?php echo $material_required_monthly_cross_company_list->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_monthly_cross_companylist.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_monthly_cross_company_list->req_material_packing->lookupOptions()) ?>;

// Form object for search
var fmaterial_required_monthly_cross_companylistsrch = currentSearchForm = new ew.Form("fmaterial_required_monthly_cross_companylistsrch");

// Validate function for search
fmaterial_required_monthly_cross_companylistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_processed_by");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_monthly_cross_company->processed_by->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_required_monthly_cross_companylistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_monthly_cross_companylistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_monthly_cross_companylistsrch.lists["x_month"] = <?php echo $material_required_monthly_cross_company_list->month->Lookup->toClientList() ?>;
fmaterial_required_monthly_cross_companylistsrch.lists["x_month"].options = <?php echo JsonEncode($material_required_monthly_cross_company_list->month->lookupOptions()) ?>;
fmaterial_required_monthly_cross_companylistsrch.lists["x_buyer"] = <?php echo $material_required_monthly_cross_company_list->buyer->Lookup->toClientList() ?>;
fmaterial_required_monthly_cross_companylistsrch.lists["x_buyer"].options = <?php echo JsonEncode($material_required_monthly_cross_company_list->buyer->lookupOptions()) ?>;
fmaterial_required_monthly_cross_companylistsrch.lists["x_processed_by"] = <?php echo $material_required_monthly_cross_company_list->processed_by->Lookup->toClientList() ?>;
fmaterial_required_monthly_cross_companylistsrch.lists["x_processed_by"].options = <?php echo JsonEncode($material_required_monthly_cross_company_list->processed_by->lookupOptions()) ?>;
fmaterial_required_monthly_cross_companylistsrch.autoSuggests["x_processed_by"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fmaterial_required_monthly_cross_companylistsrch.filterList = <?php echo $material_required_monthly_cross_company_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_required_monthly_cross_companylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_required_monthly_cross_company->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_required_monthly_cross_company_list->TotalRecs > 0 && $material_required_monthly_cross_company_list->ExportOptions->visible()) { ?>
<?php $material_required_monthly_cross_company_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company_list->ImportOptions->visible()) { ?>
<?php $material_required_monthly_cross_company_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company_list->SearchOptions->visible()) { ?>
<?php $material_required_monthly_cross_company_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company_list->FilterOptions->visible()) { ?>
<?php $material_required_monthly_cross_company_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_required_monthly_cross_company_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_required_monthly_cross_company->isExport() && !$material_required_monthly_cross_company->CurrentAction) { ?>
<form name="fmaterial_required_monthly_cross_companylistsrch" id="fmaterial_required_monthly_cross_companylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_required_monthly_cross_company_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_required_monthly_cross_companylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_required_monthly_cross_company">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_required_monthly_cross_company_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_required_monthly_cross_company->RowType = ROWTYPE_SEARCH;

// Render row
$material_required_monthly_cross_company->resetAttributes();
$material_required_monthly_cross_company_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_required_monthly_cross_company->month->Visible) { // month ?>
	<div id="xsc_month" class="ew-cell form-group">
		<label for="x_month" class="ew-search-caption ew-label"><?php echo $material_required_monthly_cross_company->month->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_month" id="z_month" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_monthly_cross_company" data-field="x_month" data-value-separator="<?php echo $material_required_monthly_cross_company->month->displayValueSeparatorAttribute() ?>" id="x_month" name="x_month"<?php echo $material_required_monthly_cross_company->month->editAttributes() ?>>
		<?php echo $material_required_monthly_cross_company->month->selectOptionListHtml("x_month") ?>
	</select>
</div>
<?php echo $material_required_monthly_cross_company->month->Lookup->getParamTag("p_x_month") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_monthly_cross_company->buyer->Visible) { // buyer ?>
	<div id="xsc_buyer" class="ew-cell form-group">
		<label for="x_buyer" class="ew-search-caption ew-label"><?php echo $material_required_monthly_cross_company->buyer->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_monthly_cross_company" data-field="x_buyer" data-value-separator="<?php echo $material_required_monthly_cross_company->buyer->displayValueSeparatorAttribute() ?>" id="x_buyer" name="x_buyer"<?php echo $material_required_monthly_cross_company->buyer->editAttributes() ?>>
		<?php echo $material_required_monthly_cross_company->buyer->selectOptionListHtml("x_buyer") ?>
	</select>
</div>
<?php echo $material_required_monthly_cross_company->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_monthly_cross_company->processed_by->Visible) { // processed_by ?>
	<div id="xsc_processed_by" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $material_required_monthly_cross_company->processed_by->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_processed_by" id="z_processed_by" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$material_required_monthly_cross_company->processed_by->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_required_monthly_cross_company->processed_by->EditAttrs["onchange"] = "";
?>
<span id="as_x_processed_by" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_processed_by" id="sv_x_processed_by" value="<?php echo RemoveHtml($material_required_monthly_cross_company->processed_by->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_required_monthly_cross_company->processed_by->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_required_monthly_cross_company->processed_by->getPlaceHolder()) ?>"<?php echo $material_required_monthly_cross_company->processed_by->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_required_monthly_cross_company" data-field="x_processed_by" data-value-separator="<?php echo $material_required_monthly_cross_company->processed_by->displayValueSeparatorAttribute() ?>" name="x_processed_by" id="x_processed_by" value="<?php echo HtmlEncode($material_required_monthly_cross_company->processed_by->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_required_monthly_cross_companylistsrch.createAutoSuggest({"id":"x_processed_by","forceSelect":false});
</script>
<?php echo $material_required_monthly_cross_company->processed_by->Lookup->getParamTag("p_x_processed_by") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_required_monthly_cross_company_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_required_monthly_cross_company_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_required_monthly_cross_company_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_required_monthly_cross_company_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_required_monthly_cross_company_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_required_monthly_cross_company_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_required_monthly_cross_company_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_required_monthly_cross_company_list->showPageHeader(); ?>
<?php
$material_required_monthly_cross_company_list->showMessage();
?>
<?php if ($material_required_monthly_cross_company_list->TotalRecs > 0 || $material_required_monthly_cross_company->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_required_monthly_cross_company_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_required_monthly_cross_company">
<?php if (!$material_required_monthly_cross_company->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_required_monthly_cross_company->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_monthly_cross_company_list->Pager)) $material_required_monthly_cross_company_list->Pager = new PrevNextPager($material_required_monthly_cross_company_list->StartRec, $material_required_monthly_cross_company_list->DisplayRecs, $material_required_monthly_cross_company_list->TotalRecs, $material_required_monthly_cross_company_list->AutoHidePager) ?>
<?php if ($material_required_monthly_cross_company_list->Pager->RecordCount > 0 && $material_required_monthly_cross_company_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_monthly_cross_company_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_monthly_cross_company_list->pageUrl() ?>start=<?php echo $material_required_monthly_cross_company_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_monthly_cross_company_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_monthly_cross_company_list->pageUrl() ?>start=<?php echo $material_required_monthly_cross_company_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_monthly_cross_company_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_monthly_cross_company_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_monthly_cross_company_list->pageUrl() ?>start=<?php echo $material_required_monthly_cross_company_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_monthly_cross_company_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_monthly_cross_company_list->pageUrl() ?>start=<?php echo $material_required_monthly_cross_company_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_monthly_cross_company_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_monthly_cross_company_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_monthly_cross_company_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_monthly_cross_company_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_monthly_cross_company_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_monthly_cross_company_list->TotalRecs > 0 && (!$material_required_monthly_cross_company_list->AutoHidePageSizeSelector || $material_required_monthly_cross_company_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_monthly_cross_company">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_monthly_cross_company->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_monthly_cross_company_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_required_monthly_cross_companylist" id="fmaterial_required_monthly_cross_companylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_monthly_cross_company_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_monthly_cross_company_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_monthly_cross_company">
<div id="gmp_material_required_monthly_cross_company" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_required_monthly_cross_company_list->TotalRecs > 0 || $material_required_monthly_cross_company->isGridEdit()) { ?>
<table id="tbl_material_required_monthly_cross_companylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_required_monthly_cross_company_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_required_monthly_cross_company_list->renderListOptions();

// Render list options (header, left)
$material_required_monthly_cross_company_list->ListOptions->render("header", "left");
?>
<?php if ($material_required_monthly_cross_company->month->Visible) { // month ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->month) == "") { ?>
		<th data-name="month" class="<?php echo $material_required_monthly_cross_company->month->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_month" class="material_required_monthly_cross_company_month"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->month->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="month" class="<?php echo $material_required_monthly_cross_company->month->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->month) ?>',2);"><div id="elh_material_required_monthly_cross_company_month" class="material_required_monthly_cross_company_month">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->month->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->month->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->month->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->buyer->Visible) { // buyer ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->buyer) == "") { ?>
		<th data-name="buyer" class="<?php echo $material_required_monthly_cross_company->buyer->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_buyer" class="material_required_monthly_cross_company_buyer"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer" class="<?php echo $material_required_monthly_cross_company->buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->buyer) ?>',2);"><div id="elh_material_required_monthly_cross_company_buyer" class="material_required_monthly_cross_company_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->buyer->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->processed_by->Visible) { // processed_by ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->processed_by) == "") { ?>
		<th data-name="processed_by" class="<?php echo $material_required_monthly_cross_company->processed_by->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_processed_by" class="material_required_monthly_cross_company_processed_by"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->processed_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="processed_by" class="<?php echo $material_required_monthly_cross_company->processed_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->processed_by) ?>',2);"><div id="elh_material_required_monthly_cross_company_processed_by" class="material_required_monthly_cross_company_processed_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->processed_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->processed_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->processed_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->design_id->Visible) { // design_id ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $material_required_monthly_cross_company->design_id->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_design_id" class="material_required_monthly_cross_company_design_id"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $material_required_monthly_cross_company->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->design_id) ?>',2);"><div id="elh_material_required_monthly_cross_company_design_id" class="material_required_monthly_cross_company_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->size_cm->Visible) { // size_cm ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $material_required_monthly_cross_company->size_cm->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_size_cm" class="material_required_monthly_cross_company_size_cm"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $material_required_monthly_cross_company->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->size_cm) ?>',2);"><div id="elh_material_required_monthly_cross_company_size_cm" class="material_required_monthly_cross_company_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->sqm->Visible) { // sqm ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $material_required_monthly_cross_company->sqm->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_sqm" class="material_required_monthly_cross_company_sqm"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $material_required_monthly_cross_company->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->sqm) ?>',2);"><div id="elh_material_required_monthly_cross_company_sqm" class="material_required_monthly_cross_company_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_monthly_cross_company->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_req_material_rid" class="material_required_monthly_cross_company_req_material_rid"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_monthly_cross_company->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->req_material_rid) ?>',2);"><div id="elh_material_required_monthly_cross_company_req_material_rid" class="material_required_monthly_cross_company_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->req_material_packing) == "") { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_monthly_cross_company->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_req_material_packing" class="material_required_monthly_cross_company_req_material_packing"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->req_material_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_monthly_cross_company->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->req_material_packing) ?>',2);"><div id="elh_material_required_monthly_cross_company_req_material_packing" class="material_required_monthly_cross_company_req_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->req_material_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->req_material_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_monthly_cross_company->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_req_material_qty" class="material_required_monthly_cross_company_req_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_monthly_cross_company->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->req_material_qty) ?>',2);"><div id="elh_material_required_monthly_cross_company_req_material_qty" class="material_required_monthly_cross_company_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->req_material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->_barcode->Visible) { // barcode ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $material_required_monthly_cross_company->_barcode->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company__barcode" class="material_required_monthly_cross_company__barcode"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $material_required_monthly_cross_company->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->_barcode) ?>',2);"><div id="elh_material_required_monthly_cross_company__barcode" class="material_required_monthly_cross_company__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->no->Visible) { // no ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->no) == "") { ?>
		<th data-name="no" class="<?php echo $material_required_monthly_cross_company->no->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_no" class="material_required_monthly_cross_company_no"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no" class="<?php echo $material_required_monthly_cross_company->no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->no) ?>',2);"><div id="elh_material_required_monthly_cross_company_no" class="material_required_monthly_cross_company_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_monthly_cross_company->datetime->Visible) { // datetime ?>
	<?php if ($material_required_monthly_cross_company->sortUrl($material_required_monthly_cross_company->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $material_required_monthly_cross_company->datetime->headerCellClass() ?>"><div id="elh_material_required_monthly_cross_company_datetime" class="material_required_monthly_cross_company_datetime"><div class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $material_required_monthly_cross_company->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_monthly_cross_company->SortUrl($material_required_monthly_cross_company->datetime) ?>',2);"><div id="elh_material_required_monthly_cross_company_datetime" class="material_required_monthly_cross_company_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_monthly_cross_company->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_monthly_cross_company->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_monthly_cross_company->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_monthly_cross_company_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_required_monthly_cross_company->ExportAll && $material_required_monthly_cross_company->isExport()) {
	$material_required_monthly_cross_company_list->StopRec = $material_required_monthly_cross_company_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_required_monthly_cross_company_list->TotalRecs > $material_required_monthly_cross_company_list->StartRec + $material_required_monthly_cross_company_list->DisplayRecs - 1)
		$material_required_monthly_cross_company_list->StopRec = $material_required_monthly_cross_company_list->StartRec + $material_required_monthly_cross_company_list->DisplayRecs - 1;
	else
		$material_required_monthly_cross_company_list->StopRec = $material_required_monthly_cross_company_list->TotalRecs;
}
$material_required_monthly_cross_company_list->RecCnt = $material_required_monthly_cross_company_list->StartRec - 1;
if ($material_required_monthly_cross_company_list->Recordset && !$material_required_monthly_cross_company_list->Recordset->EOF) {
	$material_required_monthly_cross_company_list->Recordset->moveFirst();
	$selectLimit = $material_required_monthly_cross_company_list->UseSelectLimit;
	if (!$selectLimit && $material_required_monthly_cross_company_list->StartRec > 1)
		$material_required_monthly_cross_company_list->Recordset->move($material_required_monthly_cross_company_list->StartRec - 1);
} elseif (!$material_required_monthly_cross_company->AllowAddDeleteRow && $material_required_monthly_cross_company_list->StopRec == 0) {
	$material_required_monthly_cross_company_list->StopRec = $material_required_monthly_cross_company->GridAddRowCount;
}

// Initialize aggregate
$material_required_monthly_cross_company->RowType = ROWTYPE_AGGREGATEINIT;
$material_required_monthly_cross_company->resetAttributes();
$material_required_monthly_cross_company_list->renderRow();
while ($material_required_monthly_cross_company_list->RecCnt < $material_required_monthly_cross_company_list->StopRec) {
	$material_required_monthly_cross_company_list->RecCnt++;
	if ($material_required_monthly_cross_company_list->RecCnt >= $material_required_monthly_cross_company_list->StartRec) {
		$material_required_monthly_cross_company_list->RowCnt++;

		// Set up key count
		$material_required_monthly_cross_company_list->KeyCount = $material_required_monthly_cross_company_list->RowIndex;

		// Init row class and style
		$material_required_monthly_cross_company->resetAttributes();
		$material_required_monthly_cross_company->CssClass = "";
		if ($material_required_monthly_cross_company->isGridAdd()) {
		} else {
			$material_required_monthly_cross_company_list->loadRowValues($material_required_monthly_cross_company_list->Recordset); // Load row values
		}
		$material_required_monthly_cross_company->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_required_monthly_cross_company->RowAttrs = array_merge($material_required_monthly_cross_company->RowAttrs, array('data-rowindex'=>$material_required_monthly_cross_company_list->RowCnt, 'id'=>'r' . $material_required_monthly_cross_company_list->RowCnt . '_material_required_monthly_cross_company', 'data-rowtype'=>$material_required_monthly_cross_company->RowType));

		// Render row
		$material_required_monthly_cross_company_list->renderRow();

		// Render list options
		$material_required_monthly_cross_company_list->renderListOptions();
?>
	<tr<?php echo $material_required_monthly_cross_company->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_monthly_cross_company_list->ListOptions->render("body", "left", $material_required_monthly_cross_company_list->RowCnt);
?>
	<?php if ($material_required_monthly_cross_company->month->Visible) { // month ?>
		<td data-name="month"<?php echo $material_required_monthly_cross_company->month->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_month" class="material_required_monthly_cross_company_month">
<span<?php echo $material_required_monthly_cross_company->month->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->month->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->buyer->Visible) { // buyer ?>
		<td data-name="buyer"<?php echo $material_required_monthly_cross_company->buyer->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_buyer" class="material_required_monthly_cross_company_buyer">
<span<?php echo $material_required_monthly_cross_company->buyer->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->processed_by->Visible) { // processed_by ?>
		<td data-name="processed_by"<?php echo $material_required_monthly_cross_company->processed_by->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_processed_by" class="material_required_monthly_cross_company_processed_by">
<span<?php echo $material_required_monthly_cross_company->processed_by->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->processed_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $material_required_monthly_cross_company->design_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_design_id" class="material_required_monthly_cross_company_design_id">
<span<?php echo $material_required_monthly_cross_company->design_id->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->design_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $material_required_monthly_cross_company->size_cm->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_size_cm" class="material_required_monthly_cross_company_size_cm">
<span<?php echo $material_required_monthly_cross_company->size_cm->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $material_required_monthly_cross_company->sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_sqm" class="material_required_monthly_cross_company_sqm">
<span<?php echo $material_required_monthly_cross_company->sqm->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $material_required_monthly_cross_company->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_req_material_rid" class="material_required_monthly_cross_company_req_material_rid">
<span<?php echo $material_required_monthly_cross_company->req_material_rid->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->req_material_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing"<?php echo $material_required_monthly_cross_company->req_material_packing->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_req_material_packing" class="material_required_monthly_cross_company_req_material_packing">
<span<?php echo $material_required_monthly_cross_company->req_material_packing->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->req_material_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $material_required_monthly_cross_company->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_req_material_qty" class="material_required_monthly_cross_company_req_material_qty">
<span<?php echo $material_required_monthly_cross_company->req_material_qty->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $material_required_monthly_cross_company->_barcode->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company__barcode" class="material_required_monthly_cross_company__barcode">
<span<?php echo $material_required_monthly_cross_company->_barcode->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->no->Visible) { // no ?>
		<td data-name="no"<?php echo $material_required_monthly_cross_company->no->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_no" class="material_required_monthly_cross_company_no">
<span<?php echo $material_required_monthly_cross_company->no->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $material_required_monthly_cross_company->datetime->cellAttributes() ?>>
<span id="el<?php echo $material_required_monthly_cross_company_list->RowCnt ?>_material_required_monthly_cross_company_datetime" class="material_required_monthly_cross_company_datetime">
<span<?php echo $material_required_monthly_cross_company->datetime->viewAttributes() ?>>
<?php echo $material_required_monthly_cross_company->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_required_monthly_cross_company_list->ListOptions->render("body", "right", $material_required_monthly_cross_company_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_required_monthly_cross_company->isGridAdd())
		$material_required_monthly_cross_company_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$material_required_monthly_cross_company->RowType = ROWTYPE_AGGREGATE;
$material_required_monthly_cross_company->resetAttributes();
$material_required_monthly_cross_company_list->renderRow();
?>
<?php if ($material_required_monthly_cross_company_list->TotalRecs > 0 && !$material_required_monthly_cross_company->isGridAdd() && !$material_required_monthly_cross_company->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$material_required_monthly_cross_company_list->renderListOptions();

// Render list options (footer, left)
$material_required_monthly_cross_company_list->ListOptions->render("footer", "left");
?>
	<?php if ($material_required_monthly_cross_company->month->Visible) { // month ?>
		<td data-name="month" class="<?php echo $material_required_monthly_cross_company->month->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_month" class="material_required_monthly_cross_company_month">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->buyer->Visible) { // buyer ?>
		<td data-name="buyer" class="<?php echo $material_required_monthly_cross_company->buyer->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_buyer" class="material_required_monthly_cross_company_buyer">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->processed_by->Visible) { // processed_by ?>
		<td data-name="processed_by" class="<?php echo $material_required_monthly_cross_company->processed_by->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_processed_by" class="material_required_monthly_cross_company_processed_by">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->design_id->Visible) { // design_id ?>
		<td data-name="design_id" class="<?php echo $material_required_monthly_cross_company->design_id->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_design_id" class="material_required_monthly_cross_company_design_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm" class="<?php echo $material_required_monthly_cross_company->size_cm->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_size_cm" class="material_required_monthly_cross_company_size_cm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $material_required_monthly_cross_company->sqm->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_sqm" class="material_required_monthly_cross_company_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid" class="<?php echo $material_required_monthly_cross_company->req_material_rid->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_req_material_rid" class="material_required_monthly_cross_company_req_material_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing" class="<?php echo $material_required_monthly_cross_company->req_material_packing->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_req_material_packing" class="material_required_monthly_cross_company_req_material_packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty" class="<?php echo $material_required_monthly_cross_company->req_material_qty->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_req_material_qty" class="material_required_monthly_cross_company_req_material_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_required_monthly_cross_company->req_material_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $material_required_monthly_cross_company->_barcode->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company__barcode" class="material_required_monthly_cross_company__barcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->no->Visible) { // no ?>
		<td data-name="no" class="<?php echo $material_required_monthly_cross_company->no->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_no" class="material_required_monthly_cross_company_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_monthly_cross_company->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $material_required_monthly_cross_company->datetime->footerCellClass() ?>"><span id="elf_material_required_monthly_cross_company_datetime" class="material_required_monthly_cross_company_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$material_required_monthly_cross_company_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_required_monthly_cross_company->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_required_monthly_cross_company_list->Recordset)
	$material_required_monthly_cross_company_list->Recordset->Close();
?>
<?php if (!$material_required_monthly_cross_company->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_required_monthly_cross_company->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_monthly_cross_company_list->Pager)) $material_required_monthly_cross_company_list->Pager = new PrevNextPager($material_required_monthly_cross_company_list->StartRec, $material_required_monthly_cross_company_list->DisplayRecs, $material_required_monthly_cross_company_list->TotalRecs, $material_required_monthly_cross_company_list->AutoHidePager) ?>
<?php if ($material_required_monthly_cross_company_list->Pager->RecordCount > 0 && $material_required_monthly_cross_company_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_monthly_cross_company_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_monthly_cross_company_list->pageUrl() ?>start=<?php echo $material_required_monthly_cross_company_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_monthly_cross_company_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_monthly_cross_company_list->pageUrl() ?>start=<?php echo $material_required_monthly_cross_company_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_monthly_cross_company_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_monthly_cross_company_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_monthly_cross_company_list->pageUrl() ?>start=<?php echo $material_required_monthly_cross_company_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_monthly_cross_company_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_monthly_cross_company_list->pageUrl() ?>start=<?php echo $material_required_monthly_cross_company_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_monthly_cross_company_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_monthly_cross_company_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_monthly_cross_company_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_monthly_cross_company_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_monthly_cross_company_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_monthly_cross_company_list->TotalRecs > 0 && (!$material_required_monthly_cross_company_list->AutoHidePageSizeSelector || $material_required_monthly_cross_company_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_monthly_cross_company">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_monthly_cross_company_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_monthly_cross_company->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_monthly_cross_company_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_required_monthly_cross_company_list->TotalRecs == 0 && !$material_required_monthly_cross_company->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_required_monthly_cross_company_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_required_monthly_cross_company_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_required_monthly_cross_company->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_required_monthly_cross_company->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_required_monthly_cross_company", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_required_monthly_cross_company_list->terminate();
?>