<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_processing_outside_list = new material_required_processing_outside_list();

// Run the page
$material_required_processing_outside_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_processing_outside_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_required_processing_outside->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_required_processing_outsidelist = currentForm = new ew.Form("fmaterial_required_processing_outsidelist", "list");
fmaterial_required_processing_outsidelist.formKeyCountName = '<?php echo $material_required_processing_outside_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_required_processing_outsidelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_processing_outsidelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_processing_outsidelist.lists["x_location"] = <?php echo $material_required_processing_outside_list->location->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_location"].options = <?php echo JsonEncode($material_required_processing_outside_list->location->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_week"] = <?php echo $material_required_processing_outside_list->week->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_week"].options = <?php echo JsonEncode($material_required_processing_outside_list->week->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_buyer_id"] = <?php echo $material_required_processing_outside_list->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_processing_outside_list->buyer_id->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_product_id"] = <?php echo $material_required_processing_outside_list->product_id->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_product_id"].options = <?php echo JsonEncode($material_required_processing_outside_list->product_id->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_batch_no"] = <?php echo $material_required_processing_outside_list->batch_no->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_batch_no"].options = <?php echo JsonEncode($material_required_processing_outside_list->batch_no->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_req_material_rid"] = <?php echo $material_required_processing_outside_list->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_processing_outside_list->req_material_rid->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_req_material_packing"] = <?php echo $material_required_processing_outside_list->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_processing_outside_list->req_material_packing->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_unit"] = <?php echo $material_required_processing_outside_list->unit->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_unit"].options = <?php echo JsonEncode($material_required_processing_outside_list->unit->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_method"] = <?php echo $material_required_processing_outside_list->method->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_method"].options = <?php echo JsonEncode($material_required_processing_outside_list->method->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_despatch_week"] = <?php echo $material_required_processing_outside_list->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_processing_outside_list->despatch_week->lookupOptions()) ?>;
fmaterial_required_processing_outsidelist.lists["x_operator"] = <?php echo $material_required_processing_outside_list->operator->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelist.lists["x_operator"].options = <?php echo JsonEncode($material_required_processing_outside_list->operator->lookupOptions()) ?>;

// Form object for search
var fmaterial_required_processing_outsidelistsrch = currentSearchForm = new ew.Form("fmaterial_required_processing_outsidelistsrch");

// Validate function for search
fmaterial_required_processing_outsidelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_short");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->short->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_required_processing_outsidelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_processing_outsidelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_processing_outsidelistsrch.lists["x_location"] = <?php echo $material_required_processing_outside_list->location->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelistsrch.lists["x_location"].options = <?php echo JsonEncode($material_required_processing_outside_list->location->lookupOptions()) ?>;
fmaterial_required_processing_outsidelistsrch.lists["x_week"] = <?php echo $material_required_processing_outside_list->week->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidelistsrch.lists["x_week"].options = <?php echo JsonEncode($material_required_processing_outside_list->week->lookupOptions()) ?>;

// Filters
fmaterial_required_processing_outsidelistsrch.filterList = <?php echo $material_required_processing_outside_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_required_processing_outsidelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_required_processing_outside->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_required_processing_outside_list->TotalRecs > 0 && $material_required_processing_outside_list->ExportOptions->visible()) { ?>
<?php $material_required_processing_outside_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_processing_outside_list->ImportOptions->visible()) { ?>
<?php $material_required_processing_outside_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_processing_outside_list->SearchOptions->visible()) { ?>
<?php $material_required_processing_outside_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_processing_outside_list->FilterOptions->visible()) { ?>
<?php $material_required_processing_outside_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_required_processing_outside_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_required_processing_outside->isExport() && !$material_required_processing_outside->CurrentAction) { ?>
<form name="fmaterial_required_processing_outsidelistsrch" id="fmaterial_required_processing_outsidelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_required_processing_outside_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_required_processing_outsidelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_required_processing_outside">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_required_processing_outside_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_required_processing_outside->RowType = ROWTYPE_SEARCH;

// Render row
$material_required_processing_outside->resetAttributes();
$material_required_processing_outside_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_required_processing_outside->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $material_required_processing_outside->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_location" data-value-separator="<?php echo $material_required_processing_outside->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $material_required_processing_outside->location->editAttributes() ?>>
		<?php echo $material_required_processing_outside->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->week->Visible) { // week ?>
	<div id="xsc_week" class="ew-cell form-group">
		<label for="x_week" class="ew-search-caption ew-label"><?php echo $material_required_processing_outside->week->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_week" id="z_week" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_week" data-value-separator="<?php echo $material_required_processing_outside->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $material_required_processing_outside->week->editAttributes() ?>>
		<?php echo $material_required_processing_outside->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->week->Lookup->getParamTag("p_x_week") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $material_required_processing_outside->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required_processing_outside" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->po->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->po->EditValue ?>"<?php echo $material_required_processing_outside->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="material_required_processing_outside" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->po->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->po->EditValue2 ?>"<?php echo $material_required_processing_outside->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($material_required_processing_outside->short->Visible) { // short ?>
	<div id="xsc_short" class="ew-cell form-group">
		<label for="x_short" class="ew-search-caption ew-label"><?php echo $material_required_processing_outside->short->caption() ?></label>
		<span class="ew-search-operator"><select name="z_short" id="z_short" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required_processing_outside" data-field="x_short" name="x_short" id="x_short" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->short->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->short->EditValue ?>"<?php echo $material_required_processing_outside->short->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_short style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_short style="d-none"">
<input type="text" data-table="material_required_processing_outside" data-field="x_short" name="y_short" id="y_short" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->short->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->short->EditValue2 ?>"<?php echo $material_required_processing_outside->short->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_required_processing_outside_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_required_processing_outside_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_required_processing_outside_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_required_processing_outside_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_required_processing_outside_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_required_processing_outside_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_required_processing_outside_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_required_processing_outside_list->showPageHeader(); ?>
<?php
$material_required_processing_outside_list->showMessage();
?>
<?php if ($material_required_processing_outside_list->TotalRecs > 0 || $material_required_processing_outside->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_required_processing_outside_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_required_processing_outside">
<?php if (!$material_required_processing_outside->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_required_processing_outside->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_processing_outside_list->Pager)) $material_required_processing_outside_list->Pager = new PrevNextPager($material_required_processing_outside_list->StartRec, $material_required_processing_outside_list->DisplayRecs, $material_required_processing_outside_list->TotalRecs, $material_required_processing_outside_list->AutoHidePager) ?>
<?php if ($material_required_processing_outside_list->Pager->RecordCount > 0 && $material_required_processing_outside_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_processing_outside_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_processing_outside_list->pageUrl() ?>start=<?php echo $material_required_processing_outside_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_processing_outside_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_processing_outside_list->pageUrl() ?>start=<?php echo $material_required_processing_outside_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_processing_outside_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_processing_outside_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_processing_outside_list->pageUrl() ?>start=<?php echo $material_required_processing_outside_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_processing_outside_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_processing_outside_list->pageUrl() ?>start=<?php echo $material_required_processing_outside_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_processing_outside_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_processing_outside_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_processing_outside_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_processing_outside_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_processing_outside_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_processing_outside_list->TotalRecs > 0 && (!$material_required_processing_outside_list->AutoHidePageSizeSelector || $material_required_processing_outside_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_processing_outside">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_processing_outside_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_processing_outside_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_processing_outside_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_processing_outside_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_processing_outside_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_processing_outside->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_processing_outside_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_required_processing_outsidelist" id="fmaterial_required_processing_outsidelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_processing_outside_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_processing_outside_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_processing_outside">
<div id="gmp_material_required_processing_outside" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_required_processing_outside_list->TotalRecs > 0 || $material_required_processing_outside->isGridEdit()) { ?>
<table id="tbl_material_required_processing_outsidelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_required_processing_outside_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_required_processing_outside_list->renderListOptions();

// Render list options (header, left)
$material_required_processing_outside_list->ListOptions->render("header", "left");
?>
<?php if ($material_required_processing_outside->id->Visible) { // id ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_required_processing_outside->id->headerCellClass() ?>"><div id="elh_material_required_processing_outside_id" class="material_required_processing_outside_id"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_required_processing_outside->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->id) ?>',2);"><div id="elh_material_required_processing_outside_id" class="material_required_processing_outside_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->poid->Visible) { // poid ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->poid) == "") { ?>
		<th data-name="poid" class="<?php echo $material_required_processing_outside->poid->headerCellClass() ?>"><div id="elh_material_required_processing_outside_poid" class="material_required_processing_outside_poid"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->poid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="poid" class="<?php echo $material_required_processing_outside->poid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->poid) ?>',2);"><div id="elh_material_required_processing_outside_poid" class="material_required_processing_outside_poid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->poid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->poid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->poid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->location->Visible) { // location ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->location) == "") { ?>
		<th data-name="location" class="<?php echo $material_required_processing_outside->location->headerCellClass() ?>"><div id="elh_material_required_processing_outside_location" class="material_required_processing_outside_location"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $material_required_processing_outside->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->location) ?>',2);"><div id="elh_material_required_processing_outside_location" class="material_required_processing_outside_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->week->Visible) { // week ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->week) == "") { ?>
		<th data-name="week" class="<?php echo $material_required_processing_outside->week->headerCellClass() ?>"><div id="elh_material_required_processing_outside_week" class="material_required_processing_outside_week"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $material_required_processing_outside->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->week) ?>',2);"><div id="elh_material_required_processing_outside_week" class="material_required_processing_outside_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->po->Visible) { // po ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->po) == "") { ?>
		<th data-name="po" class="<?php echo $material_required_processing_outside->po->headerCellClass() ?>"><div id="elh_material_required_processing_outside_po" class="material_required_processing_outside_po"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $material_required_processing_outside->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->po) ?>',2);"><div id="elh_material_required_processing_outside_po" class="material_required_processing_outside_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->buyer_id->Visible) { // buyer_id ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_processing_outside->buyer_id->headerCellClass() ?>"><div id="elh_material_required_processing_outside_buyer_id" class="material_required_processing_outside_buyer_id"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $material_required_processing_outside->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->buyer_id) ?>',2);"><div id="elh_material_required_processing_outside_buyer_id" class="material_required_processing_outside_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->product_id->Visible) { // product_id ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->product_id) == "") { ?>
		<th data-name="product_id" class="<?php echo $material_required_processing_outside->product_id->headerCellClass() ?>"><div id="elh_material_required_processing_outside_product_id" class="material_required_processing_outside_product_id"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->product_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_id" class="<?php echo $material_required_processing_outside->product_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->product_id) ?>',2);"><div id="elh_material_required_processing_outside_product_id" class="material_required_processing_outside_product_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->product_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->product_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->product_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->batch_no->Visible) { // batch_no ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $material_required_processing_outside->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_processing_outside_batch_no" class="material_required_processing_outside_batch_no"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $material_required_processing_outside->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->batch_no) ?>',2);"><div id="elh_material_required_processing_outside_batch_no" class="material_required_processing_outside_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->quantity->Visible) { // quantity ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_required_processing_outside->quantity->headerCellClass() ?>"><div id="elh_material_required_processing_outside_quantity" class="material_required_processing_outside_quantity"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_required_processing_outside->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->quantity) ?>',2);"><div id="elh_material_required_processing_outside_quantity" class="material_required_processing_outside_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->size_cm->Visible) { // size_cm ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $material_required_processing_outside->size_cm->headerCellClass() ?>"><div id="elh_material_required_processing_outside_size_cm" class="material_required_processing_outside_size_cm"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $material_required_processing_outside->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->size_cm) ?>',2);"><div id="elh_material_required_processing_outside_size_cm" class="material_required_processing_outside_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->sqm->Visible) { // sqm ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $material_required_processing_outside->sqm->headerCellClass() ?>"><div id="elh_material_required_processing_outside_sqm" class="material_required_processing_outside_sqm"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $material_required_processing_outside->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->sqm) ?>',2);"><div id="elh_material_required_processing_outside_sqm" class="material_required_processing_outside_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->t_sqm->Visible) { // t_sqm ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->t_sqm) == "") { ?>
		<th data-name="t_sqm" class="<?php echo $material_required_processing_outside->t_sqm->headerCellClass() ?>"><div id="elh_material_required_processing_outside_t_sqm" class="material_required_processing_outside_t_sqm"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->t_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_sqm" class="<?php echo $material_required_processing_outside->t_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->t_sqm) ?>',2);"><div id="elh_material_required_processing_outside_t_sqm" class="material_required_processing_outside_t_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->t_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->t_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->t_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_processing_outside->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_processing_outside_req_material_rid" class="material_required_processing_outside_req_material_rid"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required_processing_outside->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->req_material_rid) ?>',2);"><div id="elh_material_required_processing_outside_req_material_rid" class="material_required_processing_outside_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_processing_outside->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_processing_outside_req_material_qty" class="material_required_processing_outside_req_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required_processing_outside->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->req_material_qty) ?>',2);"><div id="elh_material_required_processing_outside_req_material_qty" class="material_required_processing_outside_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->req_material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->stock->Visible) { // stock ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->stock) == "") { ?>
		<th data-name="stock" class="<?php echo $material_required_processing_outside->stock->headerCellClass() ?>"><div id="elh_material_required_processing_outside_stock" class="material_required_processing_outside_stock"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stock" class="<?php echo $material_required_processing_outside->stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->stock) ?>',2);"><div id="elh_material_required_processing_outside_stock" class="material_required_processing_outside_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->short->Visible) { // short ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->short) == "") { ?>
		<th data-name="short" class="<?php echo $material_required_processing_outside->short->headerCellClass() ?>"><div id="elh_material_required_processing_outside_short" class="material_required_processing_outside_short"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->short->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="short" class="<?php echo $material_required_processing_outside->short->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->short) ?>',2);"><div id="elh_material_required_processing_outside_short" class="material_required_processing_outside_short">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->short->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->short->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->short->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->req_material_packing) == "") { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_processing_outside->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_processing_outside_req_material_packing" class="material_required_processing_outside_req_material_packing"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->req_material_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required_processing_outside->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->req_material_packing) ?>',2);"><div id="elh_material_required_processing_outside_req_material_packing" class="material_required_processing_outside_req_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->req_material_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->req_material_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->unit->Visible) { // unit ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $material_required_processing_outside->unit->headerCellClass() ?>"><div id="elh_material_required_processing_outside_unit" class="material_required_processing_outside_unit"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $material_required_processing_outside->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->unit) ?>',2);"><div id="elh_material_required_processing_outside_unit" class="material_required_processing_outside_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->material_qty->Visible) { // material_qty ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->material_qty) == "") { ?>
		<th data-name="material_qty" class="<?php echo $material_required_processing_outside->material_qty->headerCellClass() ?>"><div id="elh_material_required_processing_outside_material_qty" class="material_required_processing_outside_material_qty"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_qty" class="<?php echo $material_required_processing_outside->material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->material_qty) ?>',2);"><div id="elh_material_required_processing_outside_material_qty" class="material_required_processing_outside_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->method->Visible) { // method ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->method) == "") { ?>
		<th data-name="method" class="<?php echo $material_required_processing_outside->method->headerCellClass() ?>"><div id="elh_material_required_processing_outside_method" class="material_required_processing_outside_method"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $material_required_processing_outside->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->method) ?>',2);"><div id="elh_material_required_processing_outside_method" class="material_required_processing_outside_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->despatch_week->Visible) { // despatch_week ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_processing_outside->despatch_week->headerCellClass() ?>"><div id="elh_material_required_processing_outside_despatch_week" class="material_required_processing_outside_despatch_week"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $material_required_processing_outside->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->despatch_week) ?>',2);"><div id="elh_material_required_processing_outside_despatch_week" class="material_required_processing_outside_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->despatch_date->Visible) { // despatch_date ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_processing_outside->despatch_date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_processing_outside_despatch_date" class="material_required_processing_outside_despatch_date"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $material_required_processing_outside->despatch_date->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->despatch_date) ?>',2);"><div id="elh_material_required_processing_outside_despatch_date" class="material_required_processing_outside_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->despatch_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->operator->Visible) { // operator ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_required_processing_outside->operator->headerCellClass() ?>"><div id="elh_material_required_processing_outside_operator" class="material_required_processing_outside_operator"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_required_processing_outside->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->operator) ?>',2);"><div id="elh_material_required_processing_outside_operator" class="material_required_processing_outside_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->issue_to->Visible) { // issue_to ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $material_required_processing_outside->issue_to->headerCellClass() ?>"><div id="elh_material_required_processing_outside_issue_to" class="material_required_processing_outside_issue_to"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $material_required_processing_outside->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->issue_to) ?>',2);"><div id="elh_material_required_processing_outside_issue_to" class="material_required_processing_outside_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->jc_no->Visible) { // jc_no ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $material_required_processing_outside->jc_no->headerCellClass() ?>"><div id="elh_material_required_processing_outside_jc_no" class="material_required_processing_outside_jc_no"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $material_required_processing_outside->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->jc_no) ?>',2);"><div id="elh_material_required_processing_outside_jc_no" class="material_required_processing_outside_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->company_id->Visible) { // company_id ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $material_required_processing_outside->company_id->headerCellClass() ?>"><div id="elh_material_required_processing_outside_company_id" class="material_required_processing_outside_company_id"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $material_required_processing_outside->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->company_id) ?>',2);"><div id="elh_material_required_processing_outside_company_id" class="material_required_processing_outside_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->issued_qty->Visible) { // issued_qty ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->issued_qty) == "") { ?>
		<th data-name="issued_qty" class="<?php echo $material_required_processing_outside->issued_qty->headerCellClass() ?>"><div id="elh_material_required_processing_outside_issued_qty" class="material_required_processing_outside_issued_qty"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->issued_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issued_qty" class="<?php echo $material_required_processing_outside->issued_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->issued_qty) ?>',2);"><div id="elh_material_required_processing_outside_issued_qty" class="material_required_processing_outside_issued_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->issued_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->issued_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->issued_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->issued_pkt->Visible) { // issued_pkt ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->issued_pkt) == "") { ?>
		<th data-name="issued_pkt" class="<?php echo $material_required_processing_outside->issued_pkt->headerCellClass() ?>"><div id="elh_material_required_processing_outside_issued_pkt" class="material_required_processing_outside_issued_pkt"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->issued_pkt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issued_pkt" class="<?php echo $material_required_processing_outside->issued_pkt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->issued_pkt) ?>',2);"><div id="elh_material_required_processing_outside_issued_pkt" class="material_required_processing_outside_issued_pkt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->issued_pkt->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->issued_pkt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->issued_pkt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_processing_outside->lot_no->Visible) { // lot_no ?>
	<?php if ($material_required_processing_outside->sortUrl($material_required_processing_outside->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $material_required_processing_outside->lot_no->headerCellClass() ?>"><div id="elh_material_required_processing_outside_lot_no" class="material_required_processing_outside_lot_no"><div class="ew-table-header-caption"><?php echo $material_required_processing_outside->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $material_required_processing_outside->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_processing_outside->SortUrl($material_required_processing_outside->lot_no) ?>',2);"><div id="elh_material_required_processing_outside_lot_no" class="material_required_processing_outside_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_processing_outside->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_processing_outside->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_processing_outside->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_processing_outside_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_required_processing_outside->ExportAll && $material_required_processing_outside->isExport()) {
	$material_required_processing_outside_list->StopRec = $material_required_processing_outside_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_required_processing_outside_list->TotalRecs > $material_required_processing_outside_list->StartRec + $material_required_processing_outside_list->DisplayRecs - 1)
		$material_required_processing_outside_list->StopRec = $material_required_processing_outside_list->StartRec + $material_required_processing_outside_list->DisplayRecs - 1;
	else
		$material_required_processing_outside_list->StopRec = $material_required_processing_outside_list->TotalRecs;
}
$material_required_processing_outside_list->RecCnt = $material_required_processing_outside_list->StartRec - 1;
if ($material_required_processing_outside_list->Recordset && !$material_required_processing_outside_list->Recordset->EOF) {
	$material_required_processing_outside_list->Recordset->moveFirst();
	$selectLimit = $material_required_processing_outside_list->UseSelectLimit;
	if (!$selectLimit && $material_required_processing_outside_list->StartRec > 1)
		$material_required_processing_outside_list->Recordset->move($material_required_processing_outside_list->StartRec - 1);
} elseif (!$material_required_processing_outside->AllowAddDeleteRow && $material_required_processing_outside_list->StopRec == 0) {
	$material_required_processing_outside_list->StopRec = $material_required_processing_outside->GridAddRowCount;
}

// Initialize aggregate
$material_required_processing_outside->RowType = ROWTYPE_AGGREGATEINIT;
$material_required_processing_outside->resetAttributes();
$material_required_processing_outside_list->renderRow();
while ($material_required_processing_outside_list->RecCnt < $material_required_processing_outside_list->StopRec) {
	$material_required_processing_outside_list->RecCnt++;
	if ($material_required_processing_outside_list->RecCnt >= $material_required_processing_outside_list->StartRec) {
		$material_required_processing_outside_list->RowCnt++;

		// Set up key count
		$material_required_processing_outside_list->KeyCount = $material_required_processing_outside_list->RowIndex;

		// Init row class and style
		$material_required_processing_outside->resetAttributes();
		$material_required_processing_outside->CssClass = "";
		if ($material_required_processing_outside->isGridAdd()) {
		} else {
			$material_required_processing_outside_list->loadRowValues($material_required_processing_outside_list->Recordset); // Load row values
		}
		$material_required_processing_outside->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_required_processing_outside->RowAttrs = array_merge($material_required_processing_outside->RowAttrs, array('data-rowindex'=>$material_required_processing_outside_list->RowCnt, 'id'=>'r' . $material_required_processing_outside_list->RowCnt . '_material_required_processing_outside', 'data-rowtype'=>$material_required_processing_outside->RowType));

		// Render row
		$material_required_processing_outside_list->renderRow();

		// Render list options
		$material_required_processing_outside_list->renderListOptions();
?>
	<tr<?php echo $material_required_processing_outside->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_processing_outside_list->ListOptions->render("body", "left", $material_required_processing_outside_list->RowCnt);
?>
	<?php if ($material_required_processing_outside->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_required_processing_outside->id->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_id" class="material_required_processing_outside_id">
<span<?php echo $material_required_processing_outside->id->viewAttributes() ?>>
<?php echo $material_required_processing_outside->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->poid->Visible) { // poid ?>
		<td data-name="poid"<?php echo $material_required_processing_outside->poid->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_poid" class="material_required_processing_outside_poid">
<span<?php echo $material_required_processing_outside->poid->viewAttributes() ?>>
<?php echo $material_required_processing_outside->poid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->location->Visible) { // location ?>
		<td data-name="location"<?php echo $material_required_processing_outside->location->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_location" class="material_required_processing_outside_location">
<span<?php echo $material_required_processing_outside->location->viewAttributes() ?>>
<?php echo $material_required_processing_outside->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->week->Visible) { // week ?>
		<td data-name="week"<?php echo $material_required_processing_outside->week->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_week" class="material_required_processing_outside_week">
<span<?php echo $material_required_processing_outside->week->viewAttributes() ?>>
<?php echo $material_required_processing_outside->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->po->Visible) { // po ?>
		<td data-name="po"<?php echo $material_required_processing_outside->po->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_po" class="material_required_processing_outside_po">
<span<?php echo $material_required_processing_outside->po->viewAttributes() ?>>
<?php echo $material_required_processing_outside->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $material_required_processing_outside->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_buyer_id" class="material_required_processing_outside_buyer_id">
<span<?php echo $material_required_processing_outside->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_processing_outside->buyer_id->getViewValue())) && $material_required_processing_outside->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_processing_outside->buyer_id->linkAttributes() ?>><?php echo $material_required_processing_outside->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_processing_outside->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->product_id->Visible) { // product_id ?>
		<td data-name="product_id"<?php echo $material_required_processing_outside->product_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_product_id" class="material_required_processing_outside_product_id">
<span<?php echo $material_required_processing_outside->product_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_processing_outside->product_id->getViewValue())) && $material_required_processing_outside->product_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_processing_outside->product_id->linkAttributes() ?>><?php echo $material_required_processing_outside->product_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_processing_outside->product_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $material_required_processing_outside->batch_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_batch_no" class="material_required_processing_outside_batch_no">
<span<?php echo $material_required_processing_outside->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_processing_outside->batch_no->getViewValue())) && $material_required_processing_outside->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $material_required_processing_outside->batch_no->linkAttributes() ?>><?php echo $material_required_processing_outside->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_processing_outside->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_required_processing_outside->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_quantity" class="material_required_processing_outside_quantity">
<span<?php echo $material_required_processing_outside->quantity->viewAttributes() ?>>
<?php echo $material_required_processing_outside->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $material_required_processing_outside->size_cm->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_size_cm" class="material_required_processing_outside_size_cm">
<span<?php echo $material_required_processing_outside->size_cm->viewAttributes() ?>>
<?php echo $material_required_processing_outside->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $material_required_processing_outside->sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_sqm" class="material_required_processing_outside_sqm">
<span<?php echo $material_required_processing_outside->sqm->viewAttributes() ?>>
<?php echo $material_required_processing_outside->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->t_sqm->Visible) { // t_sqm ?>
		<td data-name="t_sqm"<?php echo $material_required_processing_outside->t_sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_t_sqm" class="material_required_processing_outside_t_sqm">
<span<?php echo $material_required_processing_outside->t_sqm->viewAttributes() ?>>
<?php echo $material_required_processing_outside->t_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $material_required_processing_outside->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_req_material_rid" class="material_required_processing_outside_req_material_rid">
<span<?php echo $material_required_processing_outside->req_material_rid->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_processing_outside->req_material_rid->getViewValue())) && $material_required_processing_outside->req_material_rid->linkAttributes() <> "") { ?>
<a<?php echo $material_required_processing_outside->req_material_rid->linkAttributes() ?>><?php echo $material_required_processing_outside->req_material_rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_processing_outside->req_material_rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $material_required_processing_outside->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_req_material_qty" class="material_required_processing_outside_req_material_qty">
<span<?php echo $material_required_processing_outside->req_material_qty->viewAttributes() ?>>
<?php echo $material_required_processing_outside->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->stock->Visible) { // stock ?>
		<td data-name="stock"<?php echo $material_required_processing_outside->stock->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_stock" class="material_required_processing_outside_stock">
<span<?php echo $material_required_processing_outside->stock->viewAttributes() ?>>
<?php echo $material_required_processing_outside->stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->short->Visible) { // short ?>
		<td data-name="short"<?php echo $material_required_processing_outside->short->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_short" class="material_required_processing_outside_short">
<span<?php echo $material_required_processing_outside->short->viewAttributes() ?>>
<?php echo $material_required_processing_outside->short->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing"<?php echo $material_required_processing_outside->req_material_packing->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_req_material_packing" class="material_required_processing_outside_req_material_packing">
<span<?php echo $material_required_processing_outside->req_material_packing->viewAttributes() ?>>
<?php echo $material_required_processing_outside->req_material_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $material_required_processing_outside->unit->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_unit" class="material_required_processing_outside_unit">
<span<?php echo $material_required_processing_outside->unit->viewAttributes() ?>>
<?php echo $material_required_processing_outside->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty"<?php echo $material_required_processing_outside->material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_material_qty" class="material_required_processing_outside_material_qty">
<span<?php echo $material_required_processing_outside->material_qty->viewAttributes() ?>>
<?php echo $material_required_processing_outside->material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->method->Visible) { // method ?>
		<td data-name="method"<?php echo $material_required_processing_outside->method->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_method" class="material_required_processing_outside_method">
<span<?php echo $material_required_processing_outside->method->viewAttributes() ?>>
<?php echo $material_required_processing_outside->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $material_required_processing_outside->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_despatch_week" class="material_required_processing_outside_despatch_week">
<span<?php echo $material_required_processing_outside->despatch_week->viewAttributes() ?>>
<?php echo $material_required_processing_outside->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $material_required_processing_outside->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_despatch_date" class="material_required_processing_outside_despatch_date">
<span<?php echo $material_required_processing_outside->despatch_date->viewAttributes() ?>>
<?php echo $material_required_processing_outside->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_required_processing_outside->operator->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_operator" class="material_required_processing_outside_operator">
<span<?php echo $material_required_processing_outside->operator->viewAttributes() ?>>
<?php echo $material_required_processing_outside->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $material_required_processing_outside->issue_to->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_issue_to" class="material_required_processing_outside_issue_to">
<span<?php echo $material_required_processing_outside->issue_to->viewAttributes() ?>>
<?php echo $material_required_processing_outside->issue_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $material_required_processing_outside->jc_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_jc_no" class="material_required_processing_outside_jc_no">
<span<?php echo $material_required_processing_outside->jc_no->viewAttributes() ?>>
<?php echo $material_required_processing_outside->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $material_required_processing_outside->company_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_company_id" class="material_required_processing_outside_company_id">
<span<?php echo $material_required_processing_outside->company_id->viewAttributes() ?>>
<?php echo $material_required_processing_outside->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->issued_qty->Visible) { // issued_qty ?>
		<td data-name="issued_qty"<?php echo $material_required_processing_outside->issued_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_issued_qty" class="material_required_processing_outside_issued_qty">
<span<?php echo $material_required_processing_outside->issued_qty->viewAttributes() ?>>
<?php echo $material_required_processing_outside->issued_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->issued_pkt->Visible) { // issued_pkt ?>
		<td data-name="issued_pkt"<?php echo $material_required_processing_outside->issued_pkt->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_issued_pkt" class="material_required_processing_outside_issued_pkt">
<span<?php echo $material_required_processing_outside->issued_pkt->viewAttributes() ?>>
<?php echo $material_required_processing_outside->issued_pkt->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_processing_outside->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $material_required_processing_outside->lot_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_processing_outside_list->RowCnt ?>_material_required_processing_outside_lot_no" class="material_required_processing_outside_lot_no">
<span<?php echo $material_required_processing_outside->lot_no->viewAttributes() ?>>
<?php echo $material_required_processing_outside->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_required_processing_outside_list->ListOptions->render("body", "right", $material_required_processing_outside_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_required_processing_outside->isGridAdd())
		$material_required_processing_outside_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$material_required_processing_outside->RowType = ROWTYPE_AGGREGATE;
$material_required_processing_outside->resetAttributes();
$material_required_processing_outside_list->renderRow();
?>
<?php if ($material_required_processing_outside_list->TotalRecs > 0 && !$material_required_processing_outside->isGridAdd() && !$material_required_processing_outside->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$material_required_processing_outside_list->renderListOptions();

// Render list options (footer, left)
$material_required_processing_outside_list->ListOptions->render("footer", "left");
?>
	<?php if ($material_required_processing_outside->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $material_required_processing_outside->id->footerCellClass() ?>"><span id="elf_material_required_processing_outside_id" class="material_required_processing_outside_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->poid->Visible) { // poid ?>
		<td data-name="poid" class="<?php echo $material_required_processing_outside->poid->footerCellClass() ?>"><span id="elf_material_required_processing_outside_poid" class="material_required_processing_outside_poid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $material_required_processing_outside->location->footerCellClass() ?>"><span id="elf_material_required_processing_outside_location" class="material_required_processing_outside_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->week->Visible) { // week ?>
		<td data-name="week" class="<?php echo $material_required_processing_outside->week->footerCellClass() ?>"><span id="elf_material_required_processing_outside_week" class="material_required_processing_outside_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $material_required_processing_outside->po->footerCellClass() ?>"><span id="elf_material_required_processing_outside_po" class="material_required_processing_outside_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $material_required_processing_outside->buyer_id->footerCellClass() ?>"><span id="elf_material_required_processing_outside_buyer_id" class="material_required_processing_outside_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->product_id->Visible) { // product_id ?>
		<td data-name="product_id" class="<?php echo $material_required_processing_outside->product_id->footerCellClass() ?>"><span id="elf_material_required_processing_outside_product_id" class="material_required_processing_outside_product_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $material_required_processing_outside->batch_no->footerCellClass() ?>"><span id="elf_material_required_processing_outside_batch_no" class="material_required_processing_outside_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $material_required_processing_outside->quantity->footerCellClass() ?>"><span id="elf_material_required_processing_outside_quantity" class="material_required_processing_outside_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm" class="<?php echo $material_required_processing_outside->size_cm->footerCellClass() ?>"><span id="elf_material_required_processing_outside_size_cm" class="material_required_processing_outside_size_cm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $material_required_processing_outside->sqm->footerCellClass() ?>"><span id="elf_material_required_processing_outside_sqm" class="material_required_processing_outside_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->t_sqm->Visible) { // t_sqm ?>
		<td data-name="t_sqm" class="<?php echo $material_required_processing_outside->t_sqm->footerCellClass() ?>"><span id="elf_material_required_processing_outside_t_sqm" class="material_required_processing_outside_t_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid" class="<?php echo $material_required_processing_outside->req_material_rid->footerCellClass() ?>"><span id="elf_material_required_processing_outside_req_material_rid" class="material_required_processing_outside_req_material_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty" class="<?php echo $material_required_processing_outside->req_material_qty->footerCellClass() ?>"><span id="elf_material_required_processing_outside_req_material_qty" class="material_required_processing_outside_req_material_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_required_processing_outside->req_material_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->stock->Visible) { // stock ?>
		<td data-name="stock" class="<?php echo $material_required_processing_outside->stock->footerCellClass() ?>"><span id="elf_material_required_processing_outside_stock" class="material_required_processing_outside_stock">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->short->Visible) { // short ?>
		<td data-name="short" class="<?php echo $material_required_processing_outside->short->footerCellClass() ?>"><span id="elf_material_required_processing_outside_short" class="material_required_processing_outside_short">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing" class="<?php echo $material_required_processing_outside->req_material_packing->footerCellClass() ?>"><span id="elf_material_required_processing_outside_req_material_packing" class="material_required_processing_outside_req_material_packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->unit->Visible) { // unit ?>
		<td data-name="unit" class="<?php echo $material_required_processing_outside->unit->footerCellClass() ?>"><span id="elf_material_required_processing_outside_unit" class="material_required_processing_outside_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty" class="<?php echo $material_required_processing_outside->material_qty->footerCellClass() ?>"><span id="elf_material_required_processing_outside_material_qty" class="material_required_processing_outside_material_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->method->Visible) { // method ?>
		<td data-name="method" class="<?php echo $material_required_processing_outside->method->footerCellClass() ?>"><span id="elf_material_required_processing_outside_method" class="material_required_processing_outside_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week" class="<?php echo $material_required_processing_outside->despatch_week->footerCellClass() ?>"><span id="elf_material_required_processing_outside_despatch_week" class="material_required_processing_outside_despatch_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date" class="<?php echo $material_required_processing_outside->despatch_date->footerCellClass() ?>"><span id="elf_material_required_processing_outside_despatch_date" class="material_required_processing_outside_despatch_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $material_required_processing_outside->operator->footerCellClass() ?>"><span id="elf_material_required_processing_outside_operator" class="material_required_processing_outside_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $material_required_processing_outside->issue_to->footerCellClass() ?>"><span id="elf_material_required_processing_outside_issue_to" class="material_required_processing_outside_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no" class="<?php echo $material_required_processing_outside->jc_no->footerCellClass() ?>"><span id="elf_material_required_processing_outside_jc_no" class="material_required_processing_outside_jc_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $material_required_processing_outside->company_id->footerCellClass() ?>"><span id="elf_material_required_processing_outside_company_id" class="material_required_processing_outside_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->issued_qty->Visible) { // issued_qty ?>
		<td data-name="issued_qty" class="<?php echo $material_required_processing_outside->issued_qty->footerCellClass() ?>"><span id="elf_material_required_processing_outside_issued_qty" class="material_required_processing_outside_issued_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->issued_pkt->Visible) { // issued_pkt ?>
		<td data-name="issued_pkt" class="<?php echo $material_required_processing_outside->issued_pkt->footerCellClass() ?>"><span id="elf_material_required_processing_outside_issued_pkt" class="material_required_processing_outside_issued_pkt">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required_processing_outside->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $material_required_processing_outside->lot_no->footerCellClass() ?>"><span id="elf_material_required_processing_outside_lot_no" class="material_required_processing_outside_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$material_required_processing_outside_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_required_processing_outside->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_required_processing_outside_list->Recordset)
	$material_required_processing_outside_list->Recordset->Close();
?>
<?php if (!$material_required_processing_outside->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_required_processing_outside->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_processing_outside_list->Pager)) $material_required_processing_outside_list->Pager = new PrevNextPager($material_required_processing_outside_list->StartRec, $material_required_processing_outside_list->DisplayRecs, $material_required_processing_outside_list->TotalRecs, $material_required_processing_outside_list->AutoHidePager) ?>
<?php if ($material_required_processing_outside_list->Pager->RecordCount > 0 && $material_required_processing_outside_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_processing_outside_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_processing_outside_list->pageUrl() ?>start=<?php echo $material_required_processing_outside_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_processing_outside_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_processing_outside_list->pageUrl() ?>start=<?php echo $material_required_processing_outside_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_processing_outside_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_processing_outside_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_processing_outside_list->pageUrl() ?>start=<?php echo $material_required_processing_outside_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_processing_outside_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_processing_outside_list->pageUrl() ?>start=<?php echo $material_required_processing_outside_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_processing_outside_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_processing_outside_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_processing_outside_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_processing_outside_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_processing_outside_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_processing_outside_list->TotalRecs > 0 && (!$material_required_processing_outside_list->AutoHidePageSizeSelector || $material_required_processing_outside_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_processing_outside">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_processing_outside_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_processing_outside_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_processing_outside_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_processing_outside_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_processing_outside_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_processing_outside->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_processing_outside_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_required_processing_outside_list->TotalRecs == 0 && !$material_required_processing_outside->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_required_processing_outside_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_required_processing_outside_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_required_processing_outside->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_required_processing_outside->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_required_processing_outside", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_required_processing_outside_list->terminate();
?>