<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_processing_outside_search = new material_required_processing_outside_search();

// Run the page
$material_required_processing_outside_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_processing_outside_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_required_processing_outside_search->IsModal) { ?>
var fmaterial_required_processing_outsidesearch = currentAdvancedSearchForm = new ew.Form("fmaterial_required_processing_outsidesearch", "search");
<?php } else { ?>
var fmaterial_required_processing_outsidesearch = currentForm = new ew.Form("fmaterial_required_processing_outsidesearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_required_processing_outsidesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_processing_outsidesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_processing_outsidesearch.lists["x_location"] = <?php echo $material_required_processing_outside_search->location->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_location"].options = <?php echo JsonEncode($material_required_processing_outside_search->location->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_week"] = <?php echo $material_required_processing_outside_search->week->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_week"].options = <?php echo JsonEncode($material_required_processing_outside_search->week->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_buyer_id"] = <?php echo $material_required_processing_outside_search->buyer_id->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_processing_outside_search->buyer_id->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_grp"] = <?php echo $material_required_processing_outside_search->grp->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_grp"].options = <?php echo JsonEncode($material_required_processing_outside_search->grp->options(FALSE, TRUE)) ?>;
fmaterial_required_processing_outsidesearch.lists["x_s_grp"] = <?php echo $material_required_processing_outside_search->s_grp->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_s_grp"].options = <?php echo JsonEncode($material_required_processing_outside_search->s_grp->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_product"] = <?php echo $material_required_processing_outside_search->product->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_product"].options = <?php echo JsonEncode($material_required_processing_outside_search->product->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_product_id"] = <?php echo $material_required_processing_outside_search->product_id->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_product_id"].options = <?php echo JsonEncode($material_required_processing_outside_search->product_id->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_batch_no"] = <?php echo $material_required_processing_outside_search->batch_no->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_batch_no"].options = <?php echo JsonEncode($material_required_processing_outside_search->batch_no->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_req_material_sgrp"] = <?php echo $material_required_processing_outside_search->req_material_sgrp->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_req_material_sgrp"].options = <?php echo JsonEncode($material_required_processing_outside_search->req_material_sgrp->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_req_material_product"] = <?php echo $material_required_processing_outside_search->req_material_product->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_req_material_product"].options = <?php echo JsonEncode($material_required_processing_outside_search->req_material_product->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_req_material_rid"] = <?php echo $material_required_processing_outside_search->req_material_rid->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_processing_outside_search->req_material_rid->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_req_material_packing"] = <?php echo $material_required_processing_outside_search->req_material_packing->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_processing_outside_search->req_material_packing->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_unit"] = <?php echo $material_required_processing_outside_search->unit->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_unit"].options = <?php echo JsonEncode($material_required_processing_outside_search->unit->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_method"] = <?php echo $material_required_processing_outside_search->method->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_method"].options = <?php echo JsonEncode($material_required_processing_outside_search->method->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_despatch_week"] = <?php echo $material_required_processing_outside_search->despatch_week->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_processing_outside_search->despatch_week->lookupOptions()) ?>;
fmaterial_required_processing_outsidesearch.lists["x_production_plan"] = <?php echo $material_required_processing_outside_search->production_plan->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_production_plan"].options = <?php echo JsonEncode($material_required_processing_outside_search->production_plan->options(FALSE, TRUE)) ?>;
fmaterial_required_processing_outsidesearch.lists["x_operator"] = <?php echo $material_required_processing_outside_search->operator->Lookup->toClientList() ?>;
fmaterial_required_processing_outsidesearch.lists["x_operator"].options = <?php echo JsonEncode($material_required_processing_outside_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmaterial_required_processing_outsidesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_poid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->poid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_t_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->t_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_req_material_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->req_material_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_req_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->req_material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_stock");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->stock->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_short");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->short->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_material_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->material_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->despatch_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issue_to");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->issue_to->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->jc_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issued_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->issued_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_issued_pkt");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_processing_outside->issued_pkt->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_required_processing_outside_search->showPageHeader(); ?>
<?php
$material_required_processing_outside_search->showMessage();
?>
<form name="fmaterial_required_processing_outsidesearch" id="fmaterial_required_processing_outsidesearch" class="<?php echo $material_required_processing_outside_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_processing_outside_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_processing_outside_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_processing_outside">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_required_processing_outside_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_required_processing_outside->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_id"><?php echo $material_required_processing_outside->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->id->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_id">
<input type="text" data-table="material_required_processing_outside" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_required_processing_outside->id->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->id->EditValue ?>"<?php echo $material_required_processing_outside->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->poid->Visible) { // poid ?>
	<div id="r_poid" class="form-group row">
		<label for="x_poid" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_poid"><?php echo $material_required_processing_outside->poid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_poid" id="z_poid" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->poid->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_poid">
<input type="text" data-table="material_required_processing_outside" data-field="x_poid" name="x_poid" id="x_poid" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->poid->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->poid->EditValue ?>"<?php echo $material_required_processing_outside->poid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_location"><?php echo $material_required_processing_outside->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->location->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_location" data-value-separator="<?php echo $material_required_processing_outside->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $material_required_processing_outside->location->editAttributes() ?>>
		<?php echo $material_required_processing_outside->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->week->Visible) { // week ?>
	<div id="r_week" class="form-group row">
		<label for="x_week" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_week"><?php echo $material_required_processing_outside->week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_week" id="z_week" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->week->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_week" data-value-separator="<?php echo $material_required_processing_outside->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $material_required_processing_outside->week->editAttributes() ?>>
		<?php echo $material_required_processing_outside->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->week->Lookup->getParamTag("p_x_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_po"><?php echo $material_required_processing_outside->po->caption() ?></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required_processing_outside->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_required_processing_outside_po">
<input type="text" data-table="material_required_processing_outside" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->po->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->po->EditValue ?>"<?php echo $material_required_processing_outside->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_required_processing_outside_po" class="btw1_po d-none">
<input type="text" data-table="material_required_processing_outside" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->po->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->po->EditValue2 ?>"<?php echo $material_required_processing_outside->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_buyer_id"><?php echo $material_required_processing_outside->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->buyer_id->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_buyer_id" data-value-separator="<?php echo $material_required_processing_outside->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $material_required_processing_outside->buyer_id->editAttributes() ?>>
		<?php echo $material_required_processing_outside->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_grp"><?php echo $material_required_processing_outside->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->grp->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_grp" data-value-separator="<?php echo $material_required_processing_outside->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_required_processing_outside->grp->editAttributes() ?>>
		<?php echo $material_required_processing_outside->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_s_grp"><?php echo $material_required_processing_outside->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->s_grp->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_s_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_s_grp" data-value-separator="<?php echo $material_required_processing_outside->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_required_processing_outside->s_grp->editAttributes() ?>>
		<?php echo $material_required_processing_outside->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_product"><?php echo $material_required_processing_outside->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->product->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_product">
<?php $material_required_processing_outside->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_processing_outside->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_product" data-value-separator="<?php echo $material_required_processing_outside->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_required_processing_outside->product->editAttributes() ?>>
		<?php echo $material_required_processing_outside->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->product_id->Visible) { // product_id ?>
	<div id="r_product_id" class="form-group row">
		<label for="x_product_id" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_product_id"><?php echo $material_required_processing_outside->product_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_id" id="z_product_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->product_id->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_product_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_product_id" data-value-separator="<?php echo $material_required_processing_outside->product_id->displayValueSeparatorAttribute() ?>" id="x_product_id" name="x_product_id"<?php echo $material_required_processing_outside->product_id->editAttributes() ?>>
		<?php echo $material_required_processing_outside->product_id->selectOptionListHtml("x_product_id") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->product_id->Lookup->getParamTag("p_x_product_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_batch_no"><?php echo $material_required_processing_outside->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->batch_no->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_batch_no">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_batch_no"><?php echo strval($material_required_processing_outside->batch_no->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($material_required_processing_outside->batch_no->AdvancedSearch->ViewValue) : $material_required_processing_outside->batch_no->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_required_processing_outside->batch_no->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($material_required_processing_outside->batch_no->ReadOnly || $material_required_processing_outside->batch_no->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_batch_no',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $material_required_processing_outside->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
<input type="hidden" data-table="material_required_processing_outside" data-field="x_batch_no" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_required_processing_outside->batch_no->displayValueSeparatorAttribute() ?>" name="x_batch_no" id="x_batch_no" value="<?php echo $material_required_processing_outside->batch_no->AdvancedSearch->SearchValue ?>"<?php echo $material_required_processing_outside->batch_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_quantity"><?php echo $material_required_processing_outside->quantity->caption() ?></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->quantity->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_quantity" id="z_quantity" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_processing_outside->quantity->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_processing_outside->quantity->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_processing_outside->quantity->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_processing_outside->quantity->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_processing_outside->quantity->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_processing_outside->quantity->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required_processing_outside->quantity->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required_processing_outside->quantity->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required_processing_outside->quantity->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_required_processing_outside_quantity">
<input type="text" data-table="material_required_processing_outside" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->quantity->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->quantity->EditValue ?>"<?php echo $material_required_processing_outside->quantity->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_quantity d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_required_processing_outside_quantity" class="btw1_quantity d-none">
<input type="text" data-table="material_required_processing_outside" data-field="x_quantity" name="y_quantity" id="y_quantity" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->quantity->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->quantity->EditValue2 ?>"<?php echo $material_required_processing_outside->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_size_cm"><?php echo $material_required_processing_outside->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->size_cm->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_size_cm">
<input type="text" data-table="material_required_processing_outside" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($material_required_processing_outside->size_cm->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->size_cm->EditValue ?>"<?php echo $material_required_processing_outside->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_sqm"><?php echo $material_required_processing_outside->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->sqm->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_sqm">
<input type="text" data-table="material_required_processing_outside" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->sqm->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->sqm->EditValue ?>"<?php echo $material_required_processing_outside->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->t_sqm->Visible) { // t_sqm ?>
	<div id="r_t_sqm" class="form-group row">
		<label for="x_t_sqm" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_t_sqm"><?php echo $material_required_processing_outside->t_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_t_sqm" id="z_t_sqm" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->t_sqm->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_t_sqm">
<input type="text" data-table="material_required_processing_outside" data-field="x_t_sqm" name="x_t_sqm" id="x_t_sqm" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->t_sqm->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->t_sqm->EditValue ?>"<?php echo $material_required_processing_outside->t_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->req_material_grp->Visible) { // req_material_grp ?>
	<div id="r_req_material_grp" class="form-group row">
		<label for="x_req_material_grp" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_req_material_grp"><?php echo $material_required_processing_outside->req_material_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_grp" id="z_req_material_grp" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->req_material_grp->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_req_material_grp">
<input type="text" data-table="material_required_processing_outside" data-field="x_req_material_grp" name="x_req_material_grp" id="x_req_material_grp" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->req_material_grp->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->req_material_grp->EditValue ?>"<?php echo $material_required_processing_outside->req_material_grp->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->req_material_sgrp->Visible) { // req_material_sgrp ?>
	<div id="r_req_material_sgrp" class="form-group row">
		<label for="x_req_material_sgrp" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_req_material_sgrp"><?php echo $material_required_processing_outside->req_material_sgrp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_sgrp" id="z_req_material_sgrp" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->req_material_sgrp->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_req_material_sgrp">
<?php $material_required_processing_outside->req_material_sgrp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_processing_outside->req_material_sgrp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_req_material_sgrp" data-value-separator="<?php echo $material_required_processing_outside->req_material_sgrp->displayValueSeparatorAttribute() ?>" id="x_req_material_sgrp" name="x_req_material_sgrp"<?php echo $material_required_processing_outside->req_material_sgrp->editAttributes() ?>>
		<?php echo $material_required_processing_outside->req_material_sgrp->selectOptionListHtml("x_req_material_sgrp") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->req_material_sgrp->Lookup->getParamTag("p_x_req_material_sgrp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->req_material_product->Visible) { // req_material_product ?>
	<div id="r_req_material_product" class="form-group row">
		<label for="x_req_material_product" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_req_material_product"><?php echo $material_required_processing_outside->req_material_product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_product" id="z_req_material_product" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->req_material_product->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_req_material_product">
<?php $material_required_processing_outside->req_material_product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_required_processing_outside->req_material_product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_req_material_product" data-value-separator="<?php echo $material_required_processing_outside->req_material_product->displayValueSeparatorAttribute() ?>" id="x_req_material_product" name="x_req_material_product"<?php echo $material_required_processing_outside->req_material_product->editAttributes() ?>>
		<?php echo $material_required_processing_outside->req_material_product->selectOptionListHtml("x_req_material_product") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->req_material_product->Lookup->getParamTag("p_x_req_material_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->req_material_rid->Visible) { // req_material_rid ?>
	<div id="r_req_material_rid" class="form-group row">
		<label class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_req_material_rid"><?php echo $material_required_processing_outside->req_material_rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->req_material_rid->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_req_material_rid">
<input type="text" data-table="material_required_processing_outside" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->req_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->req_material_rid->EditValue ?>"<?php echo $material_required_processing_outside->req_material_rid->editAttributes() ?>>
<?php echo $material_required_processing_outside->req_material_rid->Lookup->getParamTag("p_x_req_material_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->req_material_qty->Visible) { // req_material_qty ?>
	<div id="r_req_material_qty" class="form-group row">
		<label for="x_req_material_qty" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_req_material_qty"><?php echo $material_required_processing_outside->req_material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_qty" id="z_req_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->req_material_qty->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_req_material_qty">
<input type="text" data-table="material_required_processing_outside" data-field="x_req_material_qty" name="x_req_material_qty" id="x_req_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->req_material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->req_material_qty->EditValue ?>"<?php echo $material_required_processing_outside->req_material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->stock->Visible) { // stock ?>
	<div id="r_stock" class="form-group row">
		<label for="x_stock" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_stock"><?php echo $material_required_processing_outside->stock->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_stock" id="z_stock" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->stock->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_stock">
<input type="text" data-table="material_required_processing_outside" data-field="x_stock" name="x_stock" id="x_stock" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->stock->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->stock->EditValue ?>"<?php echo $material_required_processing_outside->stock->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->short->Visible) { // short ?>
	<div id="r_short" class="form-group row">
		<label for="x_short" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_short"><?php echo $material_required_processing_outside->short->caption() ?></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->short->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_short" id="z_short" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($material_required_processing_outside->short->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_required_processing_outside_short">
<input type="text" data-table="material_required_processing_outside" data-field="x_short" name="x_short" id="x_short" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->short->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->short->EditValue ?>"<?php echo $material_required_processing_outside->short->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_short d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_required_processing_outside_short" class="btw1_short d-none">
<input type="text" data-table="material_required_processing_outside" data-field="x_short" name="y_short" id="y_short" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->short->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->short->EditValue2 ?>"<?php echo $material_required_processing_outside->short->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->req_material_packing->Visible) { // req_material_packing ?>
	<div id="r_req_material_packing" class="form-group row">
		<label for="x_req_material_packing" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_req_material_packing"><?php echo $material_required_processing_outside->req_material_packing->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->req_material_packing->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_req_material_packing">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_req_material_packing" data-value-separator="<?php echo $material_required_processing_outside->req_material_packing->displayValueSeparatorAttribute() ?>" id="x_req_material_packing" name="x_req_material_packing"<?php echo $material_required_processing_outside->req_material_packing->editAttributes() ?>>
		<?php echo $material_required_processing_outside->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->req_material_packing->Lookup->getParamTag("p_x_req_material_packing") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_unit"><?php echo $material_required_processing_outside->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->unit->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_unit" data-value-separator="<?php echo $material_required_processing_outside->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $material_required_processing_outside->unit->editAttributes() ?>>
		<?php echo $material_required_processing_outside->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->unit->Lookup->getParamTag("p_x_unit") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->material_qty->Visible) { // material_qty ?>
	<div id="r_material_qty" class="form-group row">
		<label for="x_material_qty" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_material_qty"><?php echo $material_required_processing_outside->material_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material_qty" id="z_material_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->material_qty->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_material_qty">
<input type="text" data-table="material_required_processing_outside" data-field="x_material_qty" name="x_material_qty" id="x_material_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->material_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->material_qty->EditValue ?>"<?php echo $material_required_processing_outside->material_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_method"><?php echo $material_required_processing_outside->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->method->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_method" data-value-separator="<?php echo $material_required_processing_outside->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $material_required_processing_outside->method->editAttributes() ?>>
		<?php echo $material_required_processing_outside->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->method->Lookup->getParamTag("p_x_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_despatch_week"><?php echo $material_required_processing_outside->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->despatch_week->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_despatch_week" data-value-separator="<?php echo $material_required_processing_outside->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $material_required_processing_outside->despatch_week->editAttributes() ?>>
		<?php echo $material_required_processing_outside->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_despatch_date"><?php echo $material_required_processing_outside->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->despatch_date->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_despatch_date">
<input type="text" data-table="material_required_processing_outside" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($material_required_processing_outside->despatch_date->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->despatch_date->EditValue ?>"<?php echo $material_required_processing_outside->despatch_date->editAttributes() ?>>
<?php if (!$material_required_processing_outside->despatch_date->ReadOnly && !$material_required_processing_outside->despatch_date->Disabled && !isset($material_required_processing_outside->despatch_date->EditAttrs["readonly"]) && !isset($material_required_processing_outside->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_processing_outsidesearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_production_plan"><?php echo $material_required_processing_outside->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->production_plan->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_production_plan" data-value-separator="<?php echo $material_required_processing_outside->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $material_required_processing_outside->production_plan->editAttributes() ?>>
		<?php echo $material_required_processing_outside->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_operator"><?php echo $material_required_processing_outside->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->operator->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_processing_outside" data-field="x_operator" data-value-separator="<?php echo $material_required_processing_outside->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $material_required_processing_outside->operator->editAttributes() ?>>
		<?php echo $material_required_processing_outside->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $material_required_processing_outside->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_datetime"><?php echo $material_required_processing_outside->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->datetime->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_datetime">
<input type="text" data-table="material_required_processing_outside" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($material_required_processing_outside->datetime->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->datetime->EditValue ?>"<?php echo $material_required_processing_outside->datetime->editAttributes() ?>>
<?php if (!$material_required_processing_outside->datetime->ReadOnly && !$material_required_processing_outside->datetime->Disabled && !isset($material_required_processing_outside->datetime->EditAttrs["readonly"]) && !isset($material_required_processing_outside->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmaterial_required_processing_outsidesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->issue_to->Visible) { // issue_to ?>
	<div id="r_issue_to" class="form-group row">
		<label for="x_issue_to" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_issue_to"><?php echo $material_required_processing_outside->issue_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issue_to" id="z_issue_to" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->issue_to->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_issue_to">
<input type="text" data-table="material_required_processing_outside" data-field="x_issue_to" name="x_issue_to" id="x_issue_to" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->issue_to->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->issue_to->EditValue ?>"<?php echo $material_required_processing_outside->issue_to->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_jc_no"><?php echo $material_required_processing_outside->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->jc_no->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_jc_no">
<input type="text" data-table="material_required_processing_outside" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->jc_no->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->jc_no->EditValue ?>"<?php echo $material_required_processing_outside->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_company_id"><?php echo $material_required_processing_outside->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->company_id->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_company_id">
<input type="text" data-table="material_required_processing_outside" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->company_id->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->company_id->EditValue ?>"<?php echo $material_required_processing_outside->company_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->issued_qty->Visible) { // issued_qty ?>
	<div id="r_issued_qty" class="form-group row">
		<label for="x_issued_qty" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_issued_qty"><?php echo $material_required_processing_outside->issued_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issued_qty" id="z_issued_qty" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->issued_qty->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_issued_qty">
<input type="text" data-table="material_required_processing_outside" data-field="x_issued_qty" name="x_issued_qty" id="x_issued_qty" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->issued_qty->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->issued_qty->EditValue ?>"<?php echo $material_required_processing_outside->issued_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->issued_pkt->Visible) { // issued_pkt ?>
	<div id="r_issued_pkt" class="form-group row">
		<label for="x_issued_pkt" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_issued_pkt"><?php echo $material_required_processing_outside->issued_pkt->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_issued_pkt" id="z_issued_pkt" value="="></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->issued_pkt->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_issued_pkt">
<input type="text" data-table="material_required_processing_outside" data-field="x_issued_pkt" name="x_issued_pkt" id="x_issued_pkt" size="30" placeholder="<?php echo HtmlEncode($material_required_processing_outside->issued_pkt->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->issued_pkt->EditValue ?>"<?php echo $material_required_processing_outside->issued_pkt->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_processing_outside->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $material_required_processing_outside_search->LeftColumnClass ?>"><span id="elh_material_required_processing_outside_lot_no"><?php echo $material_required_processing_outside->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_required_processing_outside_search->RightColumnClass ?>"><div<?php echo $material_required_processing_outside->lot_no->cellAttributes() ?>>
			<span id="el_material_required_processing_outside_lot_no">
<input type="text" data-table="material_required_processing_outside" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($material_required_processing_outside->lot_no->getPlaceHolder()) ?>" value="<?php echo $material_required_processing_outside->lot_no->EditValue ?>"<?php echo $material_required_processing_outside->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_required_processing_outside_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_required_processing_outside_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_required_processing_outside_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_required_processing_outside_search->terminate();
?>