<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$material_required_weekly_loomplan_preview = new material_required_weekly_loomplan_preview();

// Run the page
$material_required_weekly_loomplan_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_weekly_loomplan_preview->Page_Render();
?>
<?php $material_required_weekly_loomplan_preview->showPageHeader(); ?>
<div class="card ew-grid material_required_weekly_loomplan"><!-- .card -->
<?php if ($material_required_weekly_loomplan_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$material_required_weekly_loomplan_preview->renderListOptions();

// Render list options (header, left)
$material_required_weekly_loomplan_preview->ListOptions->render("header", "left");
?>
<?php if ($material_required_weekly_loomplan->poid->Visible) { // poid ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->poid) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->poid->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->poid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->poid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->poid->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->poid->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->poid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->poid->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->weaving_works->Visible) { // weaving_works ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->weaving_works) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->weaving_works->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->weaving_works->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->weaving_works->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->weaving_works->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->weaving_works->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->weaving_works->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->week->Visible) { // week ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->week) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->week->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->week->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->week->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->week->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->week->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->week->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->po->Visible) { // po ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->po) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->po->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->po->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->po->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->po->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->po->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->po->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->buyer_id->Visible) { // buyer_id ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->buyer_id) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->buyer_id->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->buyer_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->buyer_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->buyer_id->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->buyer_id->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->buyer_id->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->product_id->Visible) { // product_id ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->product_id) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->product_id->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->product_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->product_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->product_id->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->product_id->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->product_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->product_id->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->batch_no->Visible) { // batch_no ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->batch_no) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->batch_no->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->batch_no->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->batch_no->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->batch_no->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->batch_no->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->batch_no->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->quantity->Visible) { // quantity ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->quantity) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->quantity->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->quantity->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->quantity->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->quantity->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->quantity->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->quantity->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->Size_wl->Visible) { // Size_wl ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->Size_wl) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->Size_wl->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->Size_wl->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->Size_wl->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->Size_wl->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->Size_wl->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->Size_wl->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->Size_wl->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->sqm->Visible) { // sqm ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->sqm) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->sqm->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->sqm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->sqm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->sqm->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->sqm->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->sqm->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->req_material_rid) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->req_material_rid->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->req_material_rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->req_material_rid->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->req_material_rid->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->req_material_rid->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->req_material_packing) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->req_material_packing->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->req_material_packing->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->req_material_packing->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->req_material_packing->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->req_material_packing->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->req_material_qty) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->req_material_qty->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->req_material_qty->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->req_material_qty->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->req_material_qty->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->req_material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->req_material_qty->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->unit->Visible) { // unit ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->unit) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->unit->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->unit->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->unit->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->unit->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->unit->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->unit->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->material_qty->Visible) { // material_qty ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->material_qty) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->material_qty->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->material_qty->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->material_qty->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->material_qty->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->material_qty->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->material_qty->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->method->Visible) { // method ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->method) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->method->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->method->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->method->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->method->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->method->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->method->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly_loomplan->despatch_week->Visible) { // despatch_week ?>
	<?php if ($material_required_weekly_loomplan->SortUrl($material_required_weekly_loomplan->despatch_week) == "") { ?>
		<th class="<?php echo $material_required_weekly_loomplan->despatch_week->headerCellClass() ?>"><?php echo $material_required_weekly_loomplan->despatch_week->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required_weekly_loomplan->despatch_week->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required_weekly_loomplan->despatch_week->Name) ?>" data-sort-order="<?php echo $material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->despatch_week->Name && $material_required_weekly_loomplan_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly_loomplan->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly_loomplan_preview->SortField == $material_required_weekly_loomplan->despatch_week->Name) { ?><?php if ($material_required_weekly_loomplan_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly_loomplan_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_weekly_loomplan_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$material_required_weekly_loomplan_preview->RecCount = 0;
$material_required_weekly_loomplan_preview->RowCnt = 0;
while ($material_required_weekly_loomplan_preview->Recordset && !$material_required_weekly_loomplan_preview->Recordset->EOF) {

	// Init row class and style
	$material_required_weekly_loomplan_preview->RecCount++;
	$material_required_weekly_loomplan_preview->RowCnt++;
	$material_required_weekly_loomplan_preview->CssStyle = "";
	$material_required_weekly_loomplan_preview->loadListRowValues($material_required_weekly_loomplan_preview->Recordset);
	$material_required_weekly_loomplan_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$material_required_weekly_loomplan_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$material_required_weekly_loomplan_preview->resetAttributes();
	$material_required_weekly_loomplan_preview->renderListRow();

	// Render list options
	$material_required_weekly_loomplan_preview->renderListOptions();
?>
	<tr<?php echo $material_required_weekly_loomplan_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_weekly_loomplan_preview->ListOptions->render("body", "left", $material_required_weekly_loomplan_preview->RowCnt);
?>
<?php if ($material_required_weekly_loomplan->poid->Visible) { // poid ?>
		<!-- poid -->
		<td<?php echo $material_required_weekly_loomplan->poid->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->poid->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->poid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->weaving_works->Visible) { // weaving_works ?>
		<!-- weaving_works -->
		<td<?php echo $material_required_weekly_loomplan->weaving_works->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->weaving_works->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->weaving_works->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->week->Visible) { // week ?>
		<!-- week -->
		<td<?php echo $material_required_weekly_loomplan->week->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->week->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->week->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->po->Visible) { // po ?>
		<!-- po -->
		<td<?php echo $material_required_weekly_loomplan->po->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->po->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->po->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->buyer_id->Visible) { // buyer_id ?>
		<!-- buyer_id -->
		<td<?php echo $material_required_weekly_loomplan->buyer_id->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_weekly_loomplan->buyer_id->getViewValue())) && $material_required_weekly_loomplan->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_weekly_loomplan->buyer_id->linkAttributes() ?>><?php echo $material_required_weekly_loomplan->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_weekly_loomplan->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->product_id->Visible) { // product_id ?>
		<!-- product_id -->
		<td<?php echo $material_required_weekly_loomplan->product_id->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->product_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_weekly_loomplan->product_id->getViewValue())) && $material_required_weekly_loomplan->product_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required_weekly_loomplan->product_id->linkAttributes() ?>><?php echo $material_required_weekly_loomplan->product_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_weekly_loomplan->product_id->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->batch_no->Visible) { // batch_no ?>
		<!-- batch_no -->
		<td<?php echo $material_required_weekly_loomplan->batch_no->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_weekly_loomplan->batch_no->getViewValue())) && $material_required_weekly_loomplan->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $material_required_weekly_loomplan->batch_no->linkAttributes() ?>><?php echo $material_required_weekly_loomplan->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_weekly_loomplan->batch_no->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->quantity->Visible) { // quantity ?>
		<!-- quantity -->
		<td<?php echo $material_required_weekly_loomplan->quantity->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->quantity->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->quantity->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->Size_wl->Visible) { // Size_wl ?>
		<!-- Size_wl -->
		<td<?php echo $material_required_weekly_loomplan->Size_wl->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->Size_wl->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->Size_wl->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->sqm->Visible) { // sqm ?>
		<!-- sqm -->
		<td<?php echo $material_required_weekly_loomplan->sqm->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->sqm->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->sqm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->req_material_rid->Visible) { // req_material_rid ?>
		<!-- req_material_rid -->
		<td<?php echo $material_required_weekly_loomplan->req_material_rid->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->req_material_rid->viewAttributes() ?>>
<?php if ((!EmptyString($material_required_weekly_loomplan->req_material_rid->getViewValue())) && $material_required_weekly_loomplan->req_material_rid->linkAttributes() <> "") { ?>
<a<?php echo $material_required_weekly_loomplan->req_material_rid->linkAttributes() ?>><?php echo $material_required_weekly_loomplan->req_material_rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required_weekly_loomplan->req_material_rid->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->req_material_packing->Visible) { // req_material_packing ?>
		<!-- req_material_packing -->
		<td<?php echo $material_required_weekly_loomplan->req_material_packing->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->req_material_packing->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->req_material_packing->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->req_material_qty->Visible) { // req_material_qty ?>
		<!-- req_material_qty -->
		<td<?php echo $material_required_weekly_loomplan->req_material_qty->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->req_material_qty->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->req_material_qty->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->unit->Visible) { // unit ?>
		<!-- unit -->
		<td<?php echo $material_required_weekly_loomplan->unit->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->unit->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->unit->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->material_qty->Visible) { // material_qty ?>
		<!-- material_qty -->
		<td<?php echo $material_required_weekly_loomplan->material_qty->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->material_qty->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->material_qty->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->method->Visible) { // method ?>
		<!-- method -->
		<td<?php echo $material_required_weekly_loomplan->method->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->method->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->method->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->despatch_week->Visible) { // despatch_week ?>
		<!-- despatch_week -->
		<td<?php echo $material_required_weekly_loomplan->despatch_week->cellAttributes() ?>>
<span<?php echo $material_required_weekly_loomplan->despatch_week->viewAttributes() ?>>
<?php echo $material_required_weekly_loomplan->despatch_week->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$material_required_weekly_loomplan_preview->ListOptions->render("body", "right", $material_required_weekly_loomplan_preview->RowCnt);
?>
	</tr>
<?php
	$material_required_weekly_loomplan_preview->Recordset->MoveNext();
}
?>
	</tbody>
<?php

	// Render aggregate row
	$material_required_weekly_loomplan_preview->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$material_required_weekly_loomplan_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$material_required_weekly_loomplan_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$material_required_weekly_loomplan_preview->ListOptions->render("footer", "left");
?>
<?php if ($material_required_weekly_loomplan->poid->Visible) { // poid ?>
		<!-- poid -->
		<td class="<?php echo $material_required_weekly_loomplan->poid->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->weaving_works->Visible) { // weaving_works ?>
		<!-- weaving_works -->
		<td class="<?php echo $material_required_weekly_loomplan->weaving_works->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->week->Visible) { // week ?>
		<!-- week -->
		<td class="<?php echo $material_required_weekly_loomplan->week->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->po->Visible) { // po ?>
		<!-- po -->
		<td class="<?php echo $material_required_weekly_loomplan->po->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->buyer_id->Visible) { // buyer_id ?>
		<!-- buyer_id -->
		<td class="<?php echo $material_required_weekly_loomplan->buyer_id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->product_id->Visible) { // product_id ?>
		<!-- product_id -->
		<td class="<?php echo $material_required_weekly_loomplan->product_id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->batch_no->Visible) { // batch_no ?>
		<!-- batch_no -->
		<td class="<?php echo $material_required_weekly_loomplan->batch_no->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->quantity->Visible) { // quantity ?>
		<!-- quantity -->
		<td class="<?php echo $material_required_weekly_loomplan->quantity->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->Size_wl->Visible) { // Size_wl ?>
		<!-- Size_wl -->
		<td class="<?php echo $material_required_weekly_loomplan->Size_wl->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->sqm->Visible) { // sqm ?>
		<!-- sqm -->
		<td class="<?php echo $material_required_weekly_loomplan->sqm->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->req_material_rid->Visible) { // req_material_rid ?>
		<!-- req_material_rid -->
		<td class="<?php echo $material_required_weekly_loomplan->req_material_rid->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->req_material_packing->Visible) { // req_material_packing ?>
		<!-- req_material_packing -->
		<td class="<?php echo $material_required_weekly_loomplan->req_material_packing->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->req_material_qty->Visible) { // req_material_qty ?>
		<!-- req_material_qty -->
		<td class="<?php echo $material_required_weekly_loomplan->req_material_qty->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_required_weekly_loomplan->req_material_qty->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->unit->Visible) { // unit ?>
		<!-- unit -->
		<td class="<?php echo $material_required_weekly_loomplan->unit->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->material_qty->Visible) { // material_qty ?>
		<!-- material_qty -->
		<td class="<?php echo $material_required_weekly_loomplan->material_qty->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->method->Visible) { // method ?>
		<!-- method -->
		<td class="<?php echo $material_required_weekly_loomplan->method->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required_weekly_loomplan->despatch_week->Visible) { // despatch_week ?>
		<!-- despatch_week -->
		<td class="<?php echo $material_required_weekly_loomplan->despatch_week->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$material_required_weekly_loomplan_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($material_required_weekly_loomplan_preview->TotalRecs > 0) { ?>
<?php if (!isset($material_required_weekly_loomplan_preview->Pager)) $material_required_weekly_loomplan_preview->Pager = new PrevNextPager($material_required_weekly_loomplan_preview->StartRec, $material_required_weekly_loomplan_preview->DisplayRecs, $material_required_weekly_loomplan_preview->TotalRecs) ?>
<?php if ($material_required_weekly_loomplan_preview->Pager->RecordCount > 0 && $material_required_weekly_loomplan_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($material_required_weekly_loomplan_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $material_required_weekly_loomplan_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($material_required_weekly_loomplan_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $material_required_weekly_loomplan_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($material_required_weekly_loomplan_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $material_required_weekly_loomplan_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($material_required_weekly_loomplan_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $material_required_weekly_loomplan_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $material_required_weekly_loomplan_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $material_required_weekly_loomplan_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $material_required_weekly_loomplan_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($material_required_weekly_loomplan_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$material_required_weekly_loomplan_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($material_required_weekly_loomplan_preview->Recordset)
	$material_required_weekly_loomplan_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$material_required_weekly_loomplan_preview->terminate();
?>