<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_weekly_list = new material_required_weekly_list();

// Run the page
$material_required_weekly_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_weekly_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_required_weekly->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_required_weeklylist = currentForm = new ew.Form("fmaterial_required_weeklylist", "list");
fmaterial_required_weeklylist.formKeyCountName = '<?php echo $material_required_weekly_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_required_weeklylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_weeklylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_weeklylist.lists["x_week"] = <?php echo $material_required_weekly_list->week->Lookup->toClientList() ?>;
fmaterial_required_weeklylist.lists["x_week"].options = <?php echo JsonEncode($material_required_weekly_list->week->lookupOptions()) ?>;
fmaterial_required_weeklylist.lists["x_rid"] = <?php echo $material_required_weekly_list->rid->Lookup->toClientList() ?>;
fmaterial_required_weeklylist.lists["x_rid"].options = <?php echo JsonEncode($material_required_weekly_list->rid->lookupOptions()) ?>;
fmaterial_required_weeklylist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_required_weeklylist.lists["x_packing"] = <?php echo $material_required_weekly_list->packing->Lookup->toClientList() ?>;
fmaterial_required_weeklylist.lists["x_packing"].options = <?php echo JsonEncode($material_required_weekly_list->packing->lookupOptions()) ?>;

// Form object for search
var fmaterial_required_weeklylistsrch = currentSearchForm = new ew.Form("fmaterial_required_weeklylistsrch");

// Validate function for search
fmaterial_required_weeklylistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_required_weeklylistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_weeklylistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_weeklylistsrch.lists["x_week"] = <?php echo $material_required_weekly_list->week->Lookup->toClientList() ?>;
fmaterial_required_weeklylistsrch.lists["x_week"].options = <?php echo JsonEncode($material_required_weekly_list->week->lookupOptions()) ?>;
fmaterial_required_weeklylistsrch.lists["x_rid"] = <?php echo $material_required_weekly_list->rid->Lookup->toClientList() ?>;
fmaterial_required_weeklylistsrch.lists["x_rid"].options = <?php echo JsonEncode($material_required_weekly_list->rid->lookupOptions()) ?>;
fmaterial_required_weeklylistsrch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_required_weeklylistsrch.lists["x_packing"] = <?php echo $material_required_weekly_list->packing->Lookup->toClientList() ?>;
fmaterial_required_weeklylistsrch.lists["x_packing"].options = <?php echo JsonEncode($material_required_weekly_list->packing->lookupOptions()) ?>;

// Filters
fmaterial_required_weeklylistsrch.filterList = <?php echo $material_required_weekly_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_required_weeklylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_required_weekly->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_required_weekly_list->TotalRecs > 0 && $material_required_weekly_list->ExportOptions->visible()) { ?>
<?php $material_required_weekly_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_weekly_list->ImportOptions->visible()) { ?>
<?php $material_required_weekly_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_weekly_list->SearchOptions->visible()) { ?>
<?php $material_required_weekly_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_weekly_list->FilterOptions->visible()) { ?>
<?php $material_required_weekly_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_required_weekly_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_required_weekly->isExport() && !$material_required_weekly->CurrentAction) { ?>
<form name="fmaterial_required_weeklylistsrch" id="fmaterial_required_weeklylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_required_weekly_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_required_weeklylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_required_weekly">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_required_weekly_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_required_weekly->RowType = ROWTYPE_SEARCH;

// Render row
$material_required_weekly->resetAttributes();
$material_required_weekly_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_required_weekly->week->Visible) { // week ?>
	<div id="xsc_week" class="ew-cell form-group">
		<label for="x_week" class="ew-search-caption ew-label"><?php echo $material_required_weekly->week->caption() ?></label>
		<span class="ew-search-operator"><select name="z_week" id="z_week" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_weekly" data-field="x_week" data-value-separator="<?php echo $material_required_weekly->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $material_required_weekly->week->editAttributes() ?>>
		<?php echo $material_required_weekly->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $material_required_weekly->week->Lookup->getParamTag("p_x_week") ?>
</span>
		<span class="ew-search-cond btw1_week style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_week style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_weekly" data-field="x_week" data-value-separator="<?php echo $material_required_weekly->week->displayValueSeparatorAttribute() ?>" id="y_week" name="y_week"<?php echo $material_required_weekly->week->editAttributes() ?>>
		<?php echo $material_required_weekly->week->selectOptionListHtml("y_week") ?>
	</select>
</div>
<?php echo $material_required_weekly->week->Lookup->getParamTag("p_y_week") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_weekly->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $material_required_weekly->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$material_required_weekly->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_required_weekly->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($material_required_weekly->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_required_weekly->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_required_weekly->rid->getPlaceHolder()) ?>"<?php echo $material_required_weekly->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_required_weekly->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($material_required_weekly->rid->ReadOnly || $material_required_weekly->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="material_required_weekly" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_required_weekly->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($material_required_weekly->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_required_weeklylistsrch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $material_required_weekly->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
<?php if ($material_required_weekly->packing->Visible) { // packing ?>
	<div id="xsc_packing" class="ew-cell form-group">
		<label for="x_packing" class="ew-search-caption ew-label"><?php echo $material_required_weekly->packing->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing" id="z_packing" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_weekly" data-field="x_packing" data-value-separator="<?php echo $material_required_weekly->packing->displayValueSeparatorAttribute() ?>" id="x_packing" name="x_packing"<?php echo $material_required_weekly->packing->editAttributes() ?>>
		<?php echo $material_required_weekly->packing->selectOptionListHtml("x_packing") ?>
	</select>
</div>
<?php echo $material_required_weekly->packing->Lookup->getParamTag("p_x_packing") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_required_weekly_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_required_weekly_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_required_weekly_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_required_weekly_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_required_weekly_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_required_weekly_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_required_weekly_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_required_weekly_list->showPageHeader(); ?>
<?php
$material_required_weekly_list->showMessage();
?>
<?php if ($material_required_weekly_list->TotalRecs > 0 || $material_required_weekly->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_required_weekly_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_required_weekly">
<?php if (!$material_required_weekly->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_required_weekly->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_weekly_list->Pager)) $material_required_weekly_list->Pager = new PrevNextPager($material_required_weekly_list->StartRec, $material_required_weekly_list->DisplayRecs, $material_required_weekly_list->TotalRecs, $material_required_weekly_list->AutoHidePager) ?>
<?php if ($material_required_weekly_list->Pager->RecordCount > 0 && $material_required_weekly_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_weekly_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_weekly_list->pageUrl() ?>start=<?php echo $material_required_weekly_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_weekly_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_weekly_list->pageUrl() ?>start=<?php echo $material_required_weekly_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_weekly_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_weekly_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_weekly_list->pageUrl() ?>start=<?php echo $material_required_weekly_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_weekly_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_weekly_list->pageUrl() ?>start=<?php echo $material_required_weekly_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_weekly_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_weekly_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_weekly_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_weekly_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_weekly_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_weekly_list->TotalRecs > 0 && (!$material_required_weekly_list->AutoHidePageSizeSelector || $material_required_weekly_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_weekly">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_weekly_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_weekly_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_weekly_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_weekly_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_weekly_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_weekly->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_weekly_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_required_weeklylist" id="fmaterial_required_weeklylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_weekly_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_weekly_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_weekly">
<div id="gmp_material_required_weekly" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_required_weekly_list->TotalRecs > 0 || $material_required_weekly->isGridEdit()) { ?>
<table id="tbl_material_required_weeklylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_required_weekly_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_required_weekly_list->renderListOptions();

// Render list options (header, left)
$material_required_weekly_list->ListOptions->render("header", "left");
?>
<?php if ($material_required_weekly->week->Visible) { // week ?>
	<?php if ($material_required_weekly->sortUrl($material_required_weekly->week) == "") { ?>
		<th data-name="week" class="<?php echo $material_required_weekly->week->headerCellClass() ?>"><div id="elh_material_required_weekly_week" class="material_required_weekly_week"><div class="ew-table-header-caption"><?php echo $material_required_weekly->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $material_required_weekly->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_weekly->SortUrl($material_required_weekly->week) ?>',2);"><div id="elh_material_required_weekly_week" class="material_required_weekly_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly->rid->Visible) { // rid ?>
	<?php if ($material_required_weekly->sortUrl($material_required_weekly->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $material_required_weekly->rid->headerCellClass() ?>"><div id="elh_material_required_weekly_rid" class="material_required_weekly_rid"><div class="ew-table-header-caption"><?php echo $material_required_weekly->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $material_required_weekly->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_weekly->SortUrl($material_required_weekly->rid) ?>',2);"><div id="elh_material_required_weekly_rid" class="material_required_weekly_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly->packing->Visible) { // packing ?>
	<?php if ($material_required_weekly->sortUrl($material_required_weekly->packing) == "") { ?>
		<th data-name="packing" class="<?php echo $material_required_weekly->packing->headerCellClass() ?>"><div id="elh_material_required_weekly_packing" class="material_required_weekly_packing"><div class="ew-table-header-caption"><?php echo $material_required_weekly->packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing" class="<?php echo $material_required_weekly->packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_weekly->SortUrl($material_required_weekly->packing) ?>',2);"><div id="elh_material_required_weekly_packing" class="material_required_weekly_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly->packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly->packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly->packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly->stock->Visible) { // stock ?>
	<?php if ($material_required_weekly->sortUrl($material_required_weekly->stock) == "") { ?>
		<th data-name="stock" class="<?php echo $material_required_weekly->stock->headerCellClass() ?>"><div id="elh_material_required_weekly_stock" class="material_required_weekly_stock"><div class="ew-table-header-caption"><?php echo $material_required_weekly->stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stock" class="<?php echo $material_required_weekly->stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_weekly->SortUrl($material_required_weekly->stock) ?>',2);"><div id="elh_material_required_weekly_stock" class="material_required_weekly_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly->stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly->stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly->stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required_weekly->required->Visible) { // required ?>
	<?php if ($material_required_weekly->sortUrl($material_required_weekly->required) == "") { ?>
		<th data-name="required" class="<?php echo $material_required_weekly->required->headerCellClass() ?>"><div id="elh_material_required_weekly_required" class="material_required_weekly_required"><div class="ew-table-header-caption"><?php echo $material_required_weekly->required->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="required" class="<?php echo $material_required_weekly->required->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required_weekly->SortUrl($material_required_weekly->required) ?>',2);"><div id="elh_material_required_weekly_required" class="material_required_weekly_required">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required_weekly->required->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_weekly->required->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_weekly->required->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_weekly_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_required_weekly->ExportAll && $material_required_weekly->isExport()) {
	$material_required_weekly_list->StopRec = $material_required_weekly_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_required_weekly_list->TotalRecs > $material_required_weekly_list->StartRec + $material_required_weekly_list->DisplayRecs - 1)
		$material_required_weekly_list->StopRec = $material_required_weekly_list->StartRec + $material_required_weekly_list->DisplayRecs - 1;
	else
		$material_required_weekly_list->StopRec = $material_required_weekly_list->TotalRecs;
}
$material_required_weekly_list->RecCnt = $material_required_weekly_list->StartRec - 1;
if ($material_required_weekly_list->Recordset && !$material_required_weekly_list->Recordset->EOF) {
	$material_required_weekly_list->Recordset->moveFirst();
	$selectLimit = $material_required_weekly_list->UseSelectLimit;
	if (!$selectLimit && $material_required_weekly_list->StartRec > 1)
		$material_required_weekly_list->Recordset->move($material_required_weekly_list->StartRec - 1);
} elseif (!$material_required_weekly->AllowAddDeleteRow && $material_required_weekly_list->StopRec == 0) {
	$material_required_weekly_list->StopRec = $material_required_weekly->GridAddRowCount;
}

// Initialize aggregate
$material_required_weekly->RowType = ROWTYPE_AGGREGATEINIT;
$material_required_weekly->resetAttributes();
$material_required_weekly_list->renderRow();
while ($material_required_weekly_list->RecCnt < $material_required_weekly_list->StopRec) {
	$material_required_weekly_list->RecCnt++;
	if ($material_required_weekly_list->RecCnt >= $material_required_weekly_list->StartRec) {
		$material_required_weekly_list->RowCnt++;

		// Set up key count
		$material_required_weekly_list->KeyCount = $material_required_weekly_list->RowIndex;

		// Init row class and style
		$material_required_weekly->resetAttributes();
		$material_required_weekly->CssClass = "";
		if ($material_required_weekly->isGridAdd()) {
		} else {
			$material_required_weekly_list->loadRowValues($material_required_weekly_list->Recordset); // Load row values
		}
		$material_required_weekly->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_required_weekly->RowAttrs = array_merge($material_required_weekly->RowAttrs, array('data-rowindex'=>$material_required_weekly_list->RowCnt, 'id'=>'r' . $material_required_weekly_list->RowCnt . '_material_required_weekly', 'data-rowtype'=>$material_required_weekly->RowType));

		// Render row
		$material_required_weekly_list->renderRow();

		// Render list options
		$material_required_weekly_list->renderListOptions();
?>
	<tr<?php echo $material_required_weekly->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_weekly_list->ListOptions->render("body", "left", $material_required_weekly_list->RowCnt);
?>
	<?php if ($material_required_weekly->week->Visible) { // week ?>
		<td data-name="week"<?php echo $material_required_weekly->week->cellAttributes() ?>>
<span id="el<?php echo $material_required_weekly_list->RowCnt ?>_material_required_weekly_week" class="material_required_weekly_week">
<span<?php echo $material_required_weekly->week->viewAttributes() ?>>
<?php echo $material_required_weekly->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_weekly->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $material_required_weekly->rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_weekly_list->RowCnt ?>_material_required_weekly_rid" class="material_required_weekly_rid">
<span<?php echo $material_required_weekly->rid->viewAttributes() ?>>
<?php echo $material_required_weekly->rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_weekly->packing->Visible) { // packing ?>
		<td data-name="packing"<?php echo $material_required_weekly->packing->cellAttributes() ?>>
<span id="el<?php echo $material_required_weekly_list->RowCnt ?>_material_required_weekly_packing" class="material_required_weekly_packing">
<span<?php echo $material_required_weekly->packing->viewAttributes() ?>>
<?php echo $material_required_weekly->packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_weekly->stock->Visible) { // stock ?>
		<td data-name="stock"<?php echo $material_required_weekly->stock->cellAttributes() ?>>
<span id="el<?php echo $material_required_weekly_list->RowCnt ?>_material_required_weekly_stock" class="material_required_weekly_stock">
<span<?php echo $material_required_weekly->stock->viewAttributes() ?>>
<?php echo $material_required_weekly->stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required_weekly->required->Visible) { // required ?>
		<td data-name="required"<?php echo $material_required_weekly->required->cellAttributes() ?>>
<span id="el<?php echo $material_required_weekly_list->RowCnt ?>_material_required_weekly_required" class="material_required_weekly_required">
<span<?php echo $material_required_weekly->required->viewAttributes() ?>>
<?php echo $material_required_weekly->required->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_required_weekly_list->ListOptions->render("body", "right", $material_required_weekly_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_required_weekly->isGridAdd())
		$material_required_weekly_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_required_weekly->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_required_weekly_list->Recordset)
	$material_required_weekly_list->Recordset->Close();
?>
<?php if (!$material_required_weekly->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_required_weekly->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_weekly_list->Pager)) $material_required_weekly_list->Pager = new PrevNextPager($material_required_weekly_list->StartRec, $material_required_weekly_list->DisplayRecs, $material_required_weekly_list->TotalRecs, $material_required_weekly_list->AutoHidePager) ?>
<?php if ($material_required_weekly_list->Pager->RecordCount > 0 && $material_required_weekly_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_weekly_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_weekly_list->pageUrl() ?>start=<?php echo $material_required_weekly_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_weekly_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_weekly_list->pageUrl() ?>start=<?php echo $material_required_weekly_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_weekly_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_weekly_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_weekly_list->pageUrl() ?>start=<?php echo $material_required_weekly_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_weekly_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_weekly_list->pageUrl() ?>start=<?php echo $material_required_weekly_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_weekly_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_weekly_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_weekly_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_weekly_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_weekly_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_weekly_list->TotalRecs > 0 && (!$material_required_weekly_list->AutoHidePageSizeSelector || $material_required_weekly_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required_weekly">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_weekly_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_weekly_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_weekly_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_weekly_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_weekly_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required_weekly->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_weekly_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_required_weekly_list->TotalRecs == 0 && !$material_required_weekly->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_required_weekly_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_required_weekly_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_required_weekly->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_required_weekly->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_required_weekly", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_required_weekly_list->terminate();
?>