<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_weekly_search = new material_required_weekly_search();

// Run the page
$material_required_weekly_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_weekly_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_required_weekly_search->IsModal) { ?>
var fmaterial_required_weeklysearch = currentAdvancedSearchForm = new ew.Form("fmaterial_required_weeklysearch", "search");
<?php } else { ?>
var fmaterial_required_weeklysearch = currentForm = new ew.Form("fmaterial_required_weeklysearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_required_weeklysearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_required_weeklysearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_required_weeklysearch.lists["x_week"] = <?php echo $material_required_weekly_search->week->Lookup->toClientList() ?>;
fmaterial_required_weeklysearch.lists["x_week"].options = <?php echo JsonEncode($material_required_weekly_search->week->lookupOptions()) ?>;
fmaterial_required_weeklysearch.lists["x_rid"] = <?php echo $material_required_weekly_search->rid->Lookup->toClientList() ?>;
fmaterial_required_weeklysearch.lists["x_rid"].options = <?php echo JsonEncode($material_required_weekly_search->rid->lookupOptions()) ?>;
fmaterial_required_weeklysearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_required_weeklysearch.lists["x_packing"] = <?php echo $material_required_weekly_search->packing->Lookup->toClientList() ?>;
fmaterial_required_weeklysearch.lists["x_packing"].options = <?php echo JsonEncode($material_required_weekly_search->packing->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmaterial_required_weeklysearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_stock");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_weekly->stock->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_required");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required_weekly->required->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_required_weekly_search->showPageHeader(); ?>
<?php
$material_required_weekly_search->showMessage();
?>
<form name="fmaterial_required_weeklysearch" id="fmaterial_required_weeklysearch" class="<?php echo $material_required_weekly_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_weekly_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_weekly_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required_weekly">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_required_weekly_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_required_weekly->week->Visible) { // week ?>
	<div id="r_week" class="form-group row">
		<label for="x_week" class="<?php echo $material_required_weekly_search->LeftColumnClass ?>"><span id="elh_material_required_weekly_week"><?php echo $material_required_weekly->week->caption() ?></span>
		</label>
		<div class="<?php echo $material_required_weekly_search->RightColumnClass ?>"><div<?php echo $material_required_weekly->week->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_week" id="z_week" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required_weekly->week->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_material_required_weekly_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_weekly" data-field="x_week" data-value-separator="<?php echo $material_required_weekly->week->displayValueSeparatorAttribute() ?>" id="x_week" name="x_week"<?php echo $material_required_weekly->week->editAttributes() ?>>
		<?php echo $material_required_weekly->week->selectOptionListHtml("x_week") ?>
	</select>
</div>
<?php echo $material_required_weekly->week->Lookup->getParamTag("p_x_week") ?>
</span>
			<span class="ew-search-cond btw1_week d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_material_required_weekly_week" class="btw1_week d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_weekly" data-field="x_week" data-value-separator="<?php echo $material_required_weekly->week->displayValueSeparatorAttribute() ?>" id="y_week" name="y_week"<?php echo $material_required_weekly->week->editAttributes() ?>>
		<?php echo $material_required_weekly->week->selectOptionListHtml("y_week") ?>
	</select>
</div>
<?php echo $material_required_weekly->week->Lookup->getParamTag("p_y_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_weekly->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $material_required_weekly_search->LeftColumnClass ?>"><span id="elh_material_required_weekly_rid"><?php echo $material_required_weekly->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $material_required_weekly_search->RightColumnClass ?>"><div<?php echo $material_required_weekly->rid->cellAttributes() ?>>
			<span id="el_material_required_weekly_rid">
<?php
$wrkonchange = "" . trim(@$material_required_weekly->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_required_weekly->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($material_required_weekly->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($material_required_weekly->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_required_weekly->rid->getPlaceHolder()) ?>"<?php echo $material_required_weekly->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($material_required_weekly->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($material_required_weekly->rid->ReadOnly || $material_required_weekly->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="material_required_weekly" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $material_required_weekly->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($material_required_weekly->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_required_weeklysearch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $material_required_weekly->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_weekly->packing->Visible) { // packing ?>
	<div id="r_packing" class="form-group row">
		<label for="x_packing" class="<?php echo $material_required_weekly_search->LeftColumnClass ?>"><span id="elh_material_required_weekly_packing"><?php echo $material_required_weekly->packing->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing" id="z_packing" value="="></span>
		</label>
		<div class="<?php echo $material_required_weekly_search->RightColumnClass ?>"><div<?php echo $material_required_weekly->packing->cellAttributes() ?>>
			<span id="el_material_required_weekly_packing">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required_weekly" data-field="x_packing" data-value-separator="<?php echo $material_required_weekly->packing->displayValueSeparatorAttribute() ?>" id="x_packing" name="x_packing"<?php echo $material_required_weekly->packing->editAttributes() ?>>
		<?php echo $material_required_weekly->packing->selectOptionListHtml("x_packing") ?>
	</select>
</div>
<?php echo $material_required_weekly->packing->Lookup->getParamTag("p_x_packing") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_weekly->stock->Visible) { // stock ?>
	<div id="r_stock" class="form-group row">
		<label for="x_stock" class="<?php echo $material_required_weekly_search->LeftColumnClass ?>"><span id="elh_material_required_weekly_stock"><?php echo $material_required_weekly->stock->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_stock" id="z_stock" value="="></span>
		</label>
		<div class="<?php echo $material_required_weekly_search->RightColumnClass ?>"><div<?php echo $material_required_weekly->stock->cellAttributes() ?>>
			<span id="el_material_required_weekly_stock">
<input type="text" data-table="material_required_weekly" data-field="x_stock" name="x_stock" id="x_stock" size="30" placeholder="<?php echo HtmlEncode($material_required_weekly->stock->getPlaceHolder()) ?>" value="<?php echo $material_required_weekly->stock->EditValue ?>"<?php echo $material_required_weekly->stock->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_required_weekly->required->Visible) { // required ?>
	<div id="r_required" class="form-group row">
		<label for="x_required" class="<?php echo $material_required_weekly_search->LeftColumnClass ?>"><span id="elh_material_required_weekly_required"><?php echo $material_required_weekly->required->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_required" id="z_required" value="="></span>
		</label>
		<div class="<?php echo $material_required_weekly_search->RightColumnClass ?>"><div<?php echo $material_required_weekly->required->cellAttributes() ?>>
			<span id="el_material_required_weekly_required">
<input type="text" data-table="material_required_weekly" data-field="x_required" name="x_required" id="x_required" size="30" placeholder="<?php echo HtmlEncode($material_required_weekly->required->getPlaceHolder()) ?>" value="<?php echo $material_required_weekly->required->EditValue ?>"<?php echo $material_required_weekly->required->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_required_weekly_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_required_weekly_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_required_weekly_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_required_weekly_search->terminate();
?>