<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_required_list = new material_required_list();

// Run the page
$material_required_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_required->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_requiredlist = currentForm = new ew.Form("fmaterial_requiredlist", "list");
fmaterial_requiredlist.formKeyCountName = '<?php echo $material_required_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_requiredlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_requiredlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_requiredlist.lists["x_buyer_id"] = <?php echo $material_required_list->buyer_id->Lookup->toClientList() ?>;
fmaterial_requiredlist.lists["x_buyer_id"].options = <?php echo JsonEncode($material_required_list->buyer_id->lookupOptions()) ?>;
fmaterial_requiredlist.lists["x_product_id"] = <?php echo $material_required_list->product_id->Lookup->toClientList() ?>;
fmaterial_requiredlist.lists["x_product_id"].options = <?php echo JsonEncode($material_required_list->product_id->lookupOptions()) ?>;
fmaterial_requiredlist.lists["x_batch_no"] = <?php echo $material_required_list->batch_no->Lookup->toClientList() ?>;
fmaterial_requiredlist.lists["x_batch_no"].options = <?php echo JsonEncode($material_required_list->batch_no->lookupOptions()) ?>;
fmaterial_requiredlist.lists["x_unit"] = <?php echo $material_required_list->unit->Lookup->toClientList() ?>;
fmaterial_requiredlist.lists["x_unit"].options = <?php echo JsonEncode($material_required_list->unit->lookupOptions()) ?>;
fmaterial_requiredlist.lists["x_method"] = <?php echo $material_required_list->method->Lookup->toClientList() ?>;
fmaterial_requiredlist.lists["x_method"].options = <?php echo JsonEncode($material_required_list->method->lookupOptions()) ?>;
fmaterial_requiredlist.lists["x_despatch_week"] = <?php echo $material_required_list->despatch_week->Lookup->toClientList() ?>;
fmaterial_requiredlist.lists["x_despatch_week"].options = <?php echo JsonEncode($material_required_list->despatch_week->lookupOptions()) ?>;
fmaterial_requiredlist.lists["x_req_material_rid"] = <?php echo $material_required_list->req_material_rid->Lookup->toClientList() ?>;
fmaterial_requiredlist.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_list->req_material_rid->lookupOptions()) ?>;
fmaterial_requiredlist.lists["x_req_material_packing"] = <?php echo $material_required_list->req_material_packing->Lookup->toClientList() ?>;
fmaterial_requiredlist.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_list->req_material_packing->lookupOptions()) ?>;
fmaterial_requiredlist.lists["x_operator"] = <?php echo $material_required_list->operator->Lookup->toClientList() ?>;
fmaterial_requiredlist.lists["x_operator"].options = <?php echo JsonEncode($material_required_list->operator->lookupOptions()) ?>;

// Form object for search
var fmaterial_requiredlistsrch = currentSearchForm = new ew.Form("fmaterial_requiredlistsrch");

// Validate function for search
fmaterial_requiredlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_required->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_requiredlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_requiredlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_requiredlistsrch.lists["x_product_id"] = <?php echo $material_required_list->product_id->Lookup->toClientList() ?>;
fmaterial_requiredlistsrch.lists["x_product_id"].options = <?php echo JsonEncode($material_required_list->product_id->lookupOptions()) ?>;
fmaterial_requiredlistsrch.lists["x_req_material_rid"] = <?php echo $material_required_list->req_material_rid->Lookup->toClientList() ?>;
fmaterial_requiredlistsrch.lists["x_req_material_rid"].options = <?php echo JsonEncode($material_required_list->req_material_rid->lookupOptions()) ?>;
fmaterial_requiredlistsrch.lists["x_req_material_packing"] = <?php echo $material_required_list->req_material_packing->Lookup->toClientList() ?>;
fmaterial_requiredlistsrch.lists["x_req_material_packing"].options = <?php echo JsonEncode($material_required_list->req_material_packing->lookupOptions()) ?>;

// Filters
fmaterial_requiredlistsrch.filterList = <?php echo $material_required_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_requiredlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_required->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_required_list->TotalRecs > 0 && $material_required_list->ExportOptions->visible()) { ?>
<?php $material_required_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_list->ImportOptions->visible()) { ?>
<?php $material_required_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_list->SearchOptions->visible()) { ?>
<?php $material_required_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_required_list->FilterOptions->visible()) { ?>
<?php $material_required_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$material_required->isExport() || EXPORT_MASTER_RECORD && $material_required->isExport("print")) { ?>
<?php
if ($material_required_list->DbMasterFilter <> "" && $material_required->getCurrentMasterTable() == "required_material_compiled") {
	if ($material_required_list->MasterRecordExists) {
		include_once "required_material_compiledmaster.php";
	}
}
?>
<?php } ?>
<?php
$material_required_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_required->isExport() && !$material_required->CurrentAction) { ?>
<form name="fmaterial_requiredlistsrch" id="fmaterial_requiredlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_required_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_requiredlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_required">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_required_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_required->RowType = ROWTYPE_SEARCH;

// Render row
$material_required->resetAttributes();
$material_required_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_required->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $material_required->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($material_required->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($material_required->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($material_required->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($material_required->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($material_required->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($material_required->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($material_required->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($material_required->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($material_required->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($material_required->po->getPlaceHolder()) ?>" value="<?php echo $material_required->po->EditValue ?>"<?php echo $material_required->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="material_required" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($material_required->po->getPlaceHolder()) ?>" value="<?php echo $material_required->po->EditValue2 ?>"<?php echo $material_required->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($material_required->product_id->Visible) { // product_id ?>
	<div id="xsc_product_id" class="ew-cell form-group">
		<label for="x_product_id" class="ew-search-caption ew-label"><?php echo $material_required->product_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_id" id="z_product_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required" data-field="x_product_id" data-value-separator="<?php echo $material_required->product_id->displayValueSeparatorAttribute() ?>" id="x_product_id" name="x_product_id"<?php echo $material_required->product_id->editAttributes() ?>>
		<?php echo $material_required->product_id->selectOptionListHtml("x_product_id") ?>
	</select>
</div>
<?php echo $material_required->product_id->Lookup->getParamTag("p_x_product_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($material_required->req_material_rid->Visible) { // req_material_rid ?>
	<div id="xsc_req_material_rid" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $material_required->req_material_rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="material_required" data-field="x_req_material_rid" name="x_req_material_rid" id="x_req_material_rid" size="30" placeholder="<?php echo HtmlEncode($material_required->req_material_rid->getPlaceHolder()) ?>" value="<?php echo $material_required->req_material_rid->EditValue ?>"<?php echo $material_required->req_material_rid->editAttributes() ?>>
<?php echo $material_required->req_material_rid->Lookup->getParamTag("p_x_req_material_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
<?php if ($material_required->req_material_packing->Visible) { // req_material_packing ?>
	<div id="xsc_req_material_packing" class="ew-cell form-group">
		<label for="x_req_material_packing" class="ew-search-caption ew-label"><?php echo $material_required->req_material_packing->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_required" data-field="x_req_material_packing" data-value-separator="<?php echo $material_required->req_material_packing->displayValueSeparatorAttribute() ?>" id="x_req_material_packing" name="x_req_material_packing"<?php echo $material_required->req_material_packing->editAttributes() ?>>
		<?php echo $material_required->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
	</select>
</div>
<?php echo $material_required->req_material_packing->Lookup->getParamTag("p_x_req_material_packing") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_required_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_required_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_required_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_required_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_required_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_required_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_required_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_required_list->showPageHeader(); ?>
<?php
$material_required_list->showMessage();
?>
<?php if ($material_required_list->TotalRecs > 0 || $material_required->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_required_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_required">
<?php if (!$material_required->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_required->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_list->Pager)) $material_required_list->Pager = new PrevNextPager($material_required_list->StartRec, $material_required_list->DisplayRecs, $material_required_list->TotalRecs, $material_required_list->AutoHidePager) ?>
<?php if ($material_required_list->Pager->RecordCount > 0 && $material_required_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_list->pageUrl() ?>start=<?php echo $material_required_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_list->pageUrl() ?>start=<?php echo $material_required_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_list->pageUrl() ?>start=<?php echo $material_required_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_list->pageUrl() ?>start=<?php echo $material_required_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_list->TotalRecs > 0 && (!$material_required_list->AutoHidePageSizeSelector || $material_required_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_requiredlist" id="fmaterial_requiredlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_required_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_required_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_required">
<?php if ($material_required->getCurrentMasterTable() == "required_material_compiled" && $material_required->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="required_material_compiled">
<input type="hidden" name="fk_po" value="<?php echo $material_required->po->getSessionValue() ?>">
<input type="hidden" name="fk_req_material_rid" value="<?php echo $material_required->req_material_rid->getSessionValue() ?>">
<?php } ?>
<div id="gmp_material_required" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_required_list->TotalRecs > 0 || $material_required->isGridEdit()) { ?>
<table id="tbl_material_requiredlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_required_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_required_list->renderListOptions();

// Render list options (header, left)
$material_required_list->ListOptions->render("header", "left");
?>
<?php if ($material_required->id->Visible) { // id ?>
	<?php if ($material_required->sortUrl($material_required->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_required->id->headerCellClass() ?>"><div id="elh_material_required_id" class="material_required_id"><div class="ew-table-header-caption"><?php echo $material_required->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_required->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->id) ?>',2);"><div id="elh_material_required_id" class="material_required_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->poid->Visible) { // poid ?>
	<?php if ($material_required->sortUrl($material_required->poid) == "") { ?>
		<th data-name="poid" class="<?php echo $material_required->poid->headerCellClass() ?>"><div id="elh_material_required_poid" class="material_required_poid"><div class="ew-table-header-caption"><?php echo $material_required->poid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="poid" class="<?php echo $material_required->poid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->poid) ?>',2);"><div id="elh_material_required_poid" class="material_required_poid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->poid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->poid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->poid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->po->Visible) { // po ?>
	<?php if ($material_required->sortUrl($material_required->po) == "") { ?>
		<th data-name="po" class="<?php echo $material_required->po->headerCellClass() ?>"><div id="elh_material_required_po" class="material_required_po"><div class="ew-table-header-caption"><?php echo $material_required->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $material_required->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->po) ?>',2);"><div id="elh_material_required_po" class="material_required_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->week->Visible) { // week ?>
	<?php if ($material_required->sortUrl($material_required->week) == "") { ?>
		<th data-name="week" class="<?php echo $material_required->week->headerCellClass() ?>"><div id="elh_material_required_week" class="material_required_week"><div class="ew-table-header-caption"><?php echo $material_required->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $material_required->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->week) ?>',2);"><div id="elh_material_required_week" class="material_required_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->buyer_id->Visible) { // buyer_id ?>
	<?php if ($material_required->sortUrl($material_required->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $material_required->buyer_id->headerCellClass() ?>"><div id="elh_material_required_buyer_id" class="material_required_buyer_id"><div class="ew-table-header-caption"><?php echo $material_required->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $material_required->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->buyer_id) ?>',2);"><div id="elh_material_required_buyer_id" class="material_required_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->product_id->Visible) { // product_id ?>
	<?php if ($material_required->sortUrl($material_required->product_id) == "") { ?>
		<th data-name="product_id" class="<?php echo $material_required->product_id->headerCellClass() ?>"><div id="elh_material_required_product_id" class="material_required_product_id"><div class="ew-table-header-caption"><?php echo $material_required->product_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_id" class="<?php echo $material_required->product_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->product_id) ?>',2);"><div id="elh_material_required_product_id" class="material_required_product_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->product_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->product_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->product_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->batch_no->Visible) { // batch_no ?>
	<?php if ($material_required->sortUrl($material_required->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $material_required->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_material_required_batch_no" class="material_required_batch_no"><div class="ew-table-header-caption"><?php echo $material_required->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $material_required->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->batch_no) ?>',2);"><div id="elh_material_required_batch_no" class="material_required_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->quantity->Visible) { // quantity ?>
	<?php if ($material_required->sortUrl($material_required->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $material_required->quantity->headerCellClass() ?>"><div id="elh_material_required_quantity" class="material_required_quantity"><div class="ew-table-header-caption"><?php echo $material_required->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $material_required->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->quantity) ?>',2);"><div id="elh_material_required_quantity" class="material_required_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->Size_wl->Visible) { // Size_wl ?>
	<?php if ($material_required->sortUrl($material_required->Size_wl) == "") { ?>
		<th data-name="Size_wl" class="<?php echo $material_required->Size_wl->headerCellClass() ?>"><div id="elh_material_required_Size_wl" class="material_required_Size_wl"><div class="ew-table-header-caption"><?php echo $material_required->Size_wl->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Size_wl" class="<?php echo $material_required->Size_wl->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->Size_wl) ?>',2);"><div id="elh_material_required_Size_wl" class="material_required_Size_wl">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->Size_wl->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->Size_wl->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->Size_wl->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->sqm->Visible) { // sqm ?>
	<?php if ($material_required->sortUrl($material_required->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $material_required->sqm->headerCellClass() ?>"><div id="elh_material_required_sqm" class="material_required_sqm"><div class="ew-table-header-caption"><?php echo $material_required->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $material_required->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->sqm) ?>',2);"><div id="elh_material_required_sqm" class="material_required_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->t_sqm->Visible) { // t_sqm ?>
	<?php if ($material_required->sortUrl($material_required->t_sqm) == "") { ?>
		<th data-name="t_sqm" class="<?php echo $material_required->t_sqm->headerCellClass() ?>"><div id="elh_material_required_t_sqm" class="material_required_t_sqm"><div class="ew-table-header-caption"><?php echo $material_required->t_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_sqm" class="<?php echo $material_required->t_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->t_sqm) ?>',2);"><div id="elh_material_required_t_sqm" class="material_required_t_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->t_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->t_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->t_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->unit->Visible) { // unit ?>
	<?php if ($material_required->sortUrl($material_required->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $material_required->unit->headerCellClass() ?>"><div id="elh_material_required_unit" class="material_required_unit"><div class="ew-table-header-caption"><?php echo $material_required->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $material_required->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->unit) ?>',2);"><div id="elh_material_required_unit" class="material_required_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->material_qty->Visible) { // material_qty ?>
	<?php if ($material_required->sortUrl($material_required->material_qty) == "") { ?>
		<th data-name="material_qty" class="<?php echo $material_required->material_qty->headerCellClass() ?>"><div id="elh_material_required_material_qty" class="material_required_material_qty"><div class="ew-table-header-caption"><?php echo $material_required->material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material_qty" class="<?php echo $material_required->material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->material_qty) ?>',2);"><div id="elh_material_required_material_qty" class="material_required_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->method->Visible) { // method ?>
	<?php if ($material_required->sortUrl($material_required->method) == "") { ?>
		<th data-name="method" class="<?php echo $material_required->method->headerCellClass() ?>"><div id="elh_material_required_method" class="material_required_method"><div class="ew-table-header-caption"><?php echo $material_required->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $material_required->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->method) ?>',2);"><div id="elh_material_required_method" class="material_required_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->despatch_week->Visible) { // despatch_week ?>
	<?php if ($material_required->sortUrl($material_required->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $material_required->despatch_week->headerCellClass() ?>"><div id="elh_material_required_despatch_week" class="material_required_despatch_week"><div class="ew-table-header-caption"><?php echo $material_required->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $material_required->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->despatch_week) ?>',2);"><div id="elh_material_required_despatch_week" class="material_required_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required->sortUrl($material_required->req_material_rid) == "") { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required->req_material_rid->headerCellClass() ?>"><div id="elh_material_required_req_material_rid" class="material_required_req_material_rid"><div class="ew-table-header-caption"><?php echo $material_required->req_material_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_rid" class="<?php echo $material_required->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->req_material_rid) ?>',2);"><div id="elh_material_required_req_material_rid" class="material_required_req_material_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->req_material_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->req_material_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($material_required->sortUrl($material_required->req_material_packing) == "") { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required->req_material_packing->headerCellClass() ?>"><div id="elh_material_required_req_material_packing" class="material_required_req_material_packing"><div class="ew-table-header-caption"><?php echo $material_required->req_material_packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_packing" class="<?php echo $material_required->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->req_material_packing) ?>',2);"><div id="elh_material_required_req_material_packing" class="material_required_req_material_packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->req_material_packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->req_material_packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required->sortUrl($material_required->req_material_qty) == "") { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required->req_material_qty->headerCellClass() ?>"><div id="elh_material_required_req_material_qty" class="material_required_req_material_qty"><div class="ew-table-header-caption"><?php echo $material_required->req_material_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="req_material_qty" class="<?php echo $material_required->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->req_material_qty) ?>',2);"><div id="elh_material_required_req_material_qty" class="material_required_req_material_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->req_material_qty->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->req_material_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->req_material_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->operator->Visible) { // operator ?>
	<?php if ($material_required->sortUrl($material_required->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $material_required->operator->headerCellClass() ?>"><div id="elh_material_required_operator" class="material_required_operator"><div class="ew-table-header-caption"><?php echo $material_required->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $material_required->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->operator) ?>',2);"><div id="elh_material_required_operator" class="material_required_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->despatch_date->Visible) { // despatch_date ?>
	<?php if ($material_required->sortUrl($material_required->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $material_required->despatch_date->headerCellClass() ?>"><div id="elh_material_required_despatch_date" class="material_required_despatch_date"><div class="ew-table-header-caption"><?php echo $material_required->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $material_required->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->despatch_date) ?>',2);"><div id="elh_material_required_despatch_date" class="material_required_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->despatch_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->order_id->Visible) { // order_id ?>
	<?php if ($material_required->sortUrl($material_required->order_id) == "") { ?>
		<th data-name="order_id" class="<?php echo $material_required->order_id->headerCellClass() ?>"><div id="elh_material_required_order_id" class="material_required_order_id"><div class="ew-table-header-caption"><?php echo $material_required->order_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_id" class="<?php echo $material_required->order_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->order_id) ?>',2);"><div id="elh_material_required_order_id" class="material_required_order_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->order_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->order_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->order_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->weaving_works->Visible) { // weaving_works ?>
	<?php if ($material_required->sortUrl($material_required->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $material_required->weaving_works->headerCellClass() ?>"><div id="elh_material_required_weaving_works" class="material_required_weaving_works"><div class="ew-table-header-caption"><?php echo $material_required->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $material_required->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->weaving_works) ?>',2);"><div id="elh_material_required_weaving_works" class="material_required_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->company_id->Visible) { // company_id ?>
	<?php if ($material_required->sortUrl($material_required->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $material_required->company_id->headerCellClass() ?>"><div id="elh_material_required_company_id" class="material_required_company_id"><div class="ew-table-header-caption"><?php echo $material_required->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $material_required->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->company_id) ?>',2);"><div id="elh_material_required_company_id" class="material_required_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->issue_material_lcgp_rid->Visible) { // issue_material_lcgp_rid ?>
	<?php if ($material_required->sortUrl($material_required->issue_material_lcgp_rid) == "") { ?>
		<th data-name="issue_material_lcgp_rid" class="<?php echo $material_required->issue_material_lcgp_rid->headerCellClass() ?>"><div id="elh_material_required_issue_material_lcgp_rid" class="material_required_issue_material_lcgp_rid"><div class="ew-table-header-caption"><?php echo $material_required->issue_material_lcgp_rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_material_lcgp_rid" class="<?php echo $material_required->issue_material_lcgp_rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->issue_material_lcgp_rid) ?>',2);"><div id="elh_material_required_issue_material_lcgp_rid" class="material_required_issue_material_lcgp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->issue_material_lcgp_rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->issue_material_lcgp_rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->issue_material_lcgp_rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->issue_material_lot_no->Visible) { // issue_material_lot_no ?>
	<?php if ($material_required->sortUrl($material_required->issue_material_lot_no) == "") { ?>
		<th data-name="issue_material_lot_no" class="<?php echo $material_required->issue_material_lot_no->headerCellClass() ?>"><div id="elh_material_required_issue_material_lot_no" class="material_required_issue_material_lot_no"><div class="ew-table-header-caption"><?php echo $material_required->issue_material_lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_material_lot_no" class="<?php echo $material_required->issue_material_lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->issue_material_lot_no) ?>',2);"><div id="elh_material_required_issue_material_lot_no" class="material_required_issue_material_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->issue_material_lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_required->issue_material_lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->issue_material_lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->issue_material_godown->Visible) { // issue_material_godown ?>
	<?php if ($material_required->sortUrl($material_required->issue_material_godown) == "") { ?>
		<th data-name="issue_material_godown" class="<?php echo $material_required->issue_material_godown->headerCellClass() ?>"><div id="elh_material_required_issue_material_godown" class="material_required_issue_material_godown"><div class="ew-table-header-caption"><?php echo $material_required->issue_material_godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_material_godown" class="<?php echo $material_required->issue_material_godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_required->SortUrl($material_required->issue_material_godown) ?>',2);"><div id="elh_material_required_issue_material_godown" class="material_required_issue_material_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->issue_material_godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required->issue_material_godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required->issue_material_godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_required->ExportAll && $material_required->isExport()) {
	$material_required_list->StopRec = $material_required_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_required_list->TotalRecs > $material_required_list->StartRec + $material_required_list->DisplayRecs - 1)
		$material_required_list->StopRec = $material_required_list->StartRec + $material_required_list->DisplayRecs - 1;
	else
		$material_required_list->StopRec = $material_required_list->TotalRecs;
}
$material_required_list->RecCnt = $material_required_list->StartRec - 1;
if ($material_required_list->Recordset && !$material_required_list->Recordset->EOF) {
	$material_required_list->Recordset->moveFirst();
	$selectLimit = $material_required_list->UseSelectLimit;
	if (!$selectLimit && $material_required_list->StartRec > 1)
		$material_required_list->Recordset->move($material_required_list->StartRec - 1);
} elseif (!$material_required->AllowAddDeleteRow && $material_required_list->StopRec == 0) {
	$material_required_list->StopRec = $material_required->GridAddRowCount;
}

// Initialize aggregate
$material_required->RowType = ROWTYPE_AGGREGATEINIT;
$material_required->resetAttributes();
$material_required_list->renderRow();
while ($material_required_list->RecCnt < $material_required_list->StopRec) {
	$material_required_list->RecCnt++;
	if ($material_required_list->RecCnt >= $material_required_list->StartRec) {
		$material_required_list->RowCnt++;

		// Set up key count
		$material_required_list->KeyCount = $material_required_list->RowIndex;

		// Init row class and style
		$material_required->resetAttributes();
		$material_required->CssClass = "";
		if ($material_required->isGridAdd()) {
		} else {
			$material_required_list->loadRowValues($material_required_list->Recordset); // Load row values
		}
		$material_required->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_required->RowAttrs = array_merge($material_required->RowAttrs, array('data-rowindex'=>$material_required_list->RowCnt, 'id'=>'r' . $material_required_list->RowCnt . '_material_required', 'data-rowtype'=>$material_required->RowType));

		// Render row
		$material_required_list->renderRow();

		// Render list options
		$material_required_list->renderListOptions();
?>
	<tr<?php echo $material_required->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_list->ListOptions->render("body", "left", $material_required_list->RowCnt);
?>
	<?php if ($material_required->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_required->id->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_id" class="material_required_id">
<span<?php echo $material_required->id->viewAttributes() ?>>
<?php echo $material_required->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->poid->Visible) { // poid ?>
		<td data-name="poid"<?php echo $material_required->poid->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_poid" class="material_required_poid">
<span<?php echo $material_required->poid->viewAttributes() ?>>
<?php echo $material_required->poid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->po->Visible) { // po ?>
		<td data-name="po"<?php echo $material_required->po->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_po" class="material_required_po">
<span<?php echo $material_required->po->viewAttributes() ?>>
<?php echo $material_required->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->week->Visible) { // week ?>
		<td data-name="week"<?php echo $material_required->week->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_week" class="material_required_week">
<span<?php echo $material_required->week->viewAttributes() ?>>
<?php echo $material_required->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $material_required->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_buyer_id" class="material_required_buyer_id">
<span<?php echo $material_required->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required->buyer_id->getViewValue())) && $material_required->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required->buyer_id->linkAttributes() ?>><?php echo $material_required->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->product_id->Visible) { // product_id ?>
		<td data-name="product_id"<?php echo $material_required->product_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_product_id" class="material_required_product_id">
<span<?php echo $material_required->product_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required->product_id->getViewValue())) && $material_required->product_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required->product_id->linkAttributes() ?>><?php echo $material_required->product_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required->product_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $material_required->batch_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_batch_no" class="material_required_batch_no">
<span<?php echo $material_required->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_required->batch_no->getViewValue())) && $material_required->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $material_required->batch_no->linkAttributes() ?>><?php echo $material_required->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $material_required->quantity->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_quantity" class="material_required_quantity">
<span<?php echo $material_required->quantity->viewAttributes() ?>>
<?php echo $material_required->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->Size_wl->Visible) { // Size_wl ?>
		<td data-name="Size_wl"<?php echo $material_required->Size_wl->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_Size_wl" class="material_required_Size_wl">
<span<?php echo $material_required->Size_wl->viewAttributes() ?>>
<?php echo $material_required->Size_wl->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $material_required->sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_sqm" class="material_required_sqm">
<span<?php echo $material_required->sqm->viewAttributes() ?>>
<?php echo $material_required->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->t_sqm->Visible) { // t_sqm ?>
		<td data-name="t_sqm"<?php echo $material_required->t_sqm->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_t_sqm" class="material_required_t_sqm">
<span<?php echo $material_required->t_sqm->viewAttributes() ?>>
<?php echo $material_required->t_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $material_required->unit->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_unit" class="material_required_unit">
<span<?php echo $material_required->unit->viewAttributes() ?>>
<?php echo $material_required->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty"<?php echo $material_required->material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_material_qty" class="material_required_material_qty">
<span<?php echo $material_required->material_qty->viewAttributes() ?>>
<?php echo $material_required->material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->method->Visible) { // method ?>
		<td data-name="method"<?php echo $material_required->method->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_method" class="material_required_method">
<span<?php echo $material_required->method->viewAttributes() ?>>
<?php echo $material_required->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $material_required->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_despatch_week" class="material_required_despatch_week">
<span<?php echo $material_required->despatch_week->viewAttributes() ?>>
<?php echo $material_required->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid"<?php echo $material_required->req_material_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_req_material_rid" class="material_required_req_material_rid">
<span<?php echo $material_required->req_material_rid->viewAttributes() ?>>
<?php echo $material_required->req_material_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing"<?php echo $material_required->req_material_packing->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_req_material_packing" class="material_required_req_material_packing">
<span<?php echo $material_required->req_material_packing->viewAttributes() ?>>
<?php echo $material_required->req_material_packing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty"<?php echo $material_required->req_material_qty->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_req_material_qty" class="material_required_req_material_qty">
<span<?php echo $material_required->req_material_qty->viewAttributes() ?>>
<?php echo $material_required->req_material_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $material_required->operator->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_operator" class="material_required_operator">
<span<?php echo $material_required->operator->viewAttributes() ?>>
<?php echo $material_required->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $material_required->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_despatch_date" class="material_required_despatch_date">
<span<?php echo $material_required->despatch_date->viewAttributes() ?>>
<?php echo $material_required->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->order_id->Visible) { // order_id ?>
		<td data-name="order_id"<?php echo $material_required->order_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_order_id" class="material_required_order_id">
<span<?php echo $material_required->order_id->viewAttributes() ?>>
<?php echo $material_required->order_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $material_required->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_weaving_works" class="material_required_weaving_works">
<span<?php echo $material_required->weaving_works->viewAttributes() ?>>
<?php echo $material_required->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $material_required->company_id->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_company_id" class="material_required_company_id">
<span<?php echo $material_required->company_id->viewAttributes() ?>>
<?php echo $material_required->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->issue_material_lcgp_rid->Visible) { // issue_material_lcgp_rid ?>
		<td data-name="issue_material_lcgp_rid"<?php echo $material_required->issue_material_lcgp_rid->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_issue_material_lcgp_rid" class="material_required_issue_material_lcgp_rid">
<span<?php echo $material_required->issue_material_lcgp_rid->viewAttributes() ?>>
<?php echo $material_required->issue_material_lcgp_rid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->issue_material_lot_no->Visible) { // issue_material_lot_no ?>
		<td data-name="issue_material_lot_no"<?php echo $material_required->issue_material_lot_no->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_issue_material_lot_no" class="material_required_issue_material_lot_no">
<span<?php echo $material_required->issue_material_lot_no->viewAttributes() ?>>
<?php echo $material_required->issue_material_lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_required->issue_material_godown->Visible) { // issue_material_godown ?>
		<td data-name="issue_material_godown"<?php echo $material_required->issue_material_godown->cellAttributes() ?>>
<span id="el<?php echo $material_required_list->RowCnt ?>_material_required_issue_material_godown" class="material_required_issue_material_godown">
<span<?php echo $material_required->issue_material_godown->viewAttributes() ?>>
<?php echo $material_required->issue_material_godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_required_list->ListOptions->render("body", "right", $material_required_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_required->isGridAdd())
		$material_required_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$material_required->RowType = ROWTYPE_AGGREGATE;
$material_required->resetAttributes();
$material_required_list->renderRow();
?>
<?php if ($material_required_list->TotalRecs > 0 && !$material_required->isGridAdd() && !$material_required->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$material_required_list->renderListOptions();

// Render list options (footer, left)
$material_required_list->ListOptions->render("footer", "left");
?>
	<?php if ($material_required->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $material_required->id->footerCellClass() ?>"><span id="elf_material_required_id" class="material_required_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->poid->Visible) { // poid ?>
		<td data-name="poid" class="<?php echo $material_required->poid->footerCellClass() ?>"><span id="elf_material_required_poid" class="material_required_poid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $material_required->po->footerCellClass() ?>"><span id="elf_material_required_po" class="material_required_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->week->Visible) { // week ?>
		<td data-name="week" class="<?php echo $material_required->week->footerCellClass() ?>"><span id="elf_material_required_week" class="material_required_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $material_required->buyer_id->footerCellClass() ?>"><span id="elf_material_required_buyer_id" class="material_required_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->product_id->Visible) { // product_id ?>
		<td data-name="product_id" class="<?php echo $material_required->product_id->footerCellClass() ?>"><span id="elf_material_required_product_id" class="material_required_product_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $material_required->batch_no->footerCellClass() ?>"><span id="elf_material_required_batch_no" class="material_required_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $material_required->quantity->footerCellClass() ?>"><span id="elf_material_required_quantity" class="material_required_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->Size_wl->Visible) { // Size_wl ?>
		<td data-name="Size_wl" class="<?php echo $material_required->Size_wl->footerCellClass() ?>"><span id="elf_material_required_Size_wl" class="material_required_Size_wl">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $material_required->sqm->footerCellClass() ?>"><span id="elf_material_required_sqm" class="material_required_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->t_sqm->Visible) { // t_sqm ?>
		<td data-name="t_sqm" class="<?php echo $material_required->t_sqm->footerCellClass() ?>"><span id="elf_material_required_t_sqm" class="material_required_t_sqm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->unit->Visible) { // unit ?>
		<td data-name="unit" class="<?php echo $material_required->unit->footerCellClass() ?>"><span id="elf_material_required_unit" class="material_required_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->material_qty->Visible) { // material_qty ?>
		<td data-name="material_qty" class="<?php echo $material_required->material_qty->footerCellClass() ?>"><span id="elf_material_required_material_qty" class="material_required_material_qty">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->method->Visible) { // method ?>
		<td data-name="method" class="<?php echo $material_required->method->footerCellClass() ?>"><span id="elf_material_required_method" class="material_required_method">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week" class="<?php echo $material_required->despatch_week->footerCellClass() ?>"><span id="elf_material_required_despatch_week" class="material_required_despatch_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->req_material_rid->Visible) { // req_material_rid ?>
		<td data-name="req_material_rid" class="<?php echo $material_required->req_material_rid->footerCellClass() ?>"><span id="elf_material_required_req_material_rid" class="material_required_req_material_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->req_material_packing->Visible) { // req_material_packing ?>
		<td data-name="req_material_packing" class="<?php echo $material_required->req_material_packing->footerCellClass() ?>"><span id="elf_material_required_req_material_packing" class="material_required_req_material_packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->req_material_qty->Visible) { // req_material_qty ?>
		<td data-name="req_material_qty" class="<?php echo $material_required->req_material_qty->footerCellClass() ?>"><span id="elf_material_required_req_material_qty" class="material_required_req_material_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_required->req_material_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($material_required->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $material_required->operator->footerCellClass() ?>"><span id="elf_material_required_operator" class="material_required_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date" class="<?php echo $material_required->despatch_date->footerCellClass() ?>"><span id="elf_material_required_despatch_date" class="material_required_despatch_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->order_id->Visible) { // order_id ?>
		<td data-name="order_id" class="<?php echo $material_required->order_id->footerCellClass() ?>"><span id="elf_material_required_order_id" class="material_required_order_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works" class="<?php echo $material_required->weaving_works->footerCellClass() ?>"><span id="elf_material_required_weaving_works" class="material_required_weaving_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $material_required->company_id->footerCellClass() ?>"><span id="elf_material_required_company_id" class="material_required_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->issue_material_lcgp_rid->Visible) { // issue_material_lcgp_rid ?>
		<td data-name="issue_material_lcgp_rid" class="<?php echo $material_required->issue_material_lcgp_rid->footerCellClass() ?>"><span id="elf_material_required_issue_material_lcgp_rid" class="material_required_issue_material_lcgp_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->issue_material_lot_no->Visible) { // issue_material_lot_no ?>
		<td data-name="issue_material_lot_no" class="<?php echo $material_required->issue_material_lot_no->footerCellClass() ?>"><span id="elf_material_required_issue_material_lot_no" class="material_required_issue_material_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($material_required->issue_material_godown->Visible) { // issue_material_godown ?>
		<td data-name="issue_material_godown" class="<?php echo $material_required->issue_material_godown->footerCellClass() ?>"><span id="elf_material_required_issue_material_godown" class="material_required_issue_material_godown">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$material_required_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_required->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_required_list->Recordset)
	$material_required_list->Recordset->Close();
?>
<?php if (!$material_required->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_required->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_required_list->Pager)) $material_required_list->Pager = new PrevNextPager($material_required_list->StartRec, $material_required_list->DisplayRecs, $material_required_list->TotalRecs, $material_required_list->AutoHidePager) ?>
<?php if ($material_required_list->Pager->RecordCount > 0 && $material_required_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_required_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_required_list->pageUrl() ?>start=<?php echo $material_required_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_required_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_required_list->pageUrl() ?>start=<?php echo $material_required_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_required_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_required_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_required_list->pageUrl() ?>start=<?php echo $material_required_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_required_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_required_list->pageUrl() ?>start=<?php echo $material_required_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_required_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_required_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_required_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_required_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_required_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_required_list->TotalRecs > 0 && (!$material_required_list->AutoHidePageSizeSelector || $material_required_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_required">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_required_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_required_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_required_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_required_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_required_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_required->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_required_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_required_list->TotalRecs == 0 && !$material_required->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_required_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_required_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_required->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_required->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_required", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_required_list->terminate();
?>