<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$material_required_preview = new material_required_preview();

// Run the page
$material_required_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_required_preview->Page_Render();
?>
<?php $material_required_preview->showPageHeader(); ?>
<div class="card ew-grid material_required"><!-- .card -->
<?php if ($material_required_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$material_required_preview->renderListOptions();

// Render list options (header, left)
$material_required_preview->ListOptions->render("header", "left");
?>
<?php if ($material_required->id->Visible) { // id ?>
	<?php if ($material_required->SortUrl($material_required->id) == "") { ?>
		<th class="<?php echo $material_required->id->headerCellClass() ?>"><?php echo $material_required->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->id->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->id->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->id->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->poid->Visible) { // poid ?>
	<?php if ($material_required->SortUrl($material_required->poid) == "") { ?>
		<th class="<?php echo $material_required->poid->headerCellClass() ?>"><?php echo $material_required->poid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->poid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->poid->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->poid->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->poid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->poid->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->po->Visible) { // po ?>
	<?php if ($material_required->SortUrl($material_required->po) == "") { ?>
		<th class="<?php echo $material_required->po->headerCellClass() ?>"><?php echo $material_required->po->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->po->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->po->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->po->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->po->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->week->Visible) { // week ?>
	<?php if ($material_required->SortUrl($material_required->week) == "") { ?>
		<th class="<?php echo $material_required->week->headerCellClass() ?>"><?php echo $material_required->week->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->week->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->week->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->week->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->week->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->buyer_id->Visible) { // buyer_id ?>
	<?php if ($material_required->SortUrl($material_required->buyer_id) == "") { ?>
		<th class="<?php echo $material_required->buyer_id->headerCellClass() ?>"><?php echo $material_required->buyer_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->buyer_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->buyer_id->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->buyer_id->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->buyer_id->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->product_id->Visible) { // product_id ?>
	<?php if ($material_required->SortUrl($material_required->product_id) == "") { ?>
		<th class="<?php echo $material_required->product_id->headerCellClass() ?>"><?php echo $material_required->product_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->product_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->product_id->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->product_id->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->product_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->product_id->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->batch_no->Visible) { // batch_no ?>
	<?php if ($material_required->SortUrl($material_required->batch_no) == "") { ?>
		<th class="<?php echo $material_required->batch_no->headerCellClass() ?>"><?php echo $material_required->batch_no->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->batch_no->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->batch_no->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->batch_no->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->batch_no->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->quantity->Visible) { // quantity ?>
	<?php if ($material_required->SortUrl($material_required->quantity) == "") { ?>
		<th class="<?php echo $material_required->quantity->headerCellClass() ?>"><?php echo $material_required->quantity->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->quantity->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->quantity->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->quantity->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->quantity->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->Size_wl->Visible) { // Size_wl ?>
	<?php if ($material_required->SortUrl($material_required->Size_wl) == "") { ?>
		<th class="<?php echo $material_required->Size_wl->headerCellClass() ?>"><?php echo $material_required->Size_wl->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->Size_wl->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->Size_wl->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->Size_wl->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->Size_wl->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->Size_wl->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->sqm->Visible) { // sqm ?>
	<?php if ($material_required->SortUrl($material_required->sqm) == "") { ?>
		<th class="<?php echo $material_required->sqm->headerCellClass() ?>"><?php echo $material_required->sqm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->sqm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->sqm->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->sqm->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->sqm->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->t_sqm->Visible) { // t_sqm ?>
	<?php if ($material_required->SortUrl($material_required->t_sqm) == "") { ?>
		<th class="<?php echo $material_required->t_sqm->headerCellClass() ?>"><?php echo $material_required->t_sqm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->t_sqm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->t_sqm->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->t_sqm->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->t_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->t_sqm->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->unit->Visible) { // unit ?>
	<?php if ($material_required->SortUrl($material_required->unit) == "") { ?>
		<th class="<?php echo $material_required->unit->headerCellClass() ?>"><?php echo $material_required->unit->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->unit->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->unit->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->unit->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->unit->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->material_qty->Visible) { // material_qty ?>
	<?php if ($material_required->SortUrl($material_required->material_qty) == "") { ?>
		<th class="<?php echo $material_required->material_qty->headerCellClass() ?>"><?php echo $material_required->material_qty->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->material_qty->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->material_qty->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->material_qty->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->material_qty->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->method->Visible) { // method ?>
	<?php if ($material_required->SortUrl($material_required->method) == "") { ?>
		<th class="<?php echo $material_required->method->headerCellClass() ?>"><?php echo $material_required->method->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->method->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->method->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->method->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->method->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->despatch_week->Visible) { // despatch_week ?>
	<?php if ($material_required->SortUrl($material_required->despatch_week) == "") { ?>
		<th class="<?php echo $material_required->despatch_week->headerCellClass() ?>"><?php echo $material_required->despatch_week->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->despatch_week->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->despatch_week->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->despatch_week->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->despatch_week->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->req_material_rid->Visible) { // req_material_rid ?>
	<?php if ($material_required->SortUrl($material_required->req_material_rid) == "") { ?>
		<th class="<?php echo $material_required->req_material_rid->headerCellClass() ?>"><?php echo $material_required->req_material_rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->req_material_rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->req_material_rid->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->req_material_rid->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->req_material_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->req_material_rid->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->req_material_packing->Visible) { // req_material_packing ?>
	<?php if ($material_required->SortUrl($material_required->req_material_packing) == "") { ?>
		<th class="<?php echo $material_required->req_material_packing->headerCellClass() ?>"><?php echo $material_required->req_material_packing->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->req_material_packing->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->req_material_packing->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->req_material_packing->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->req_material_packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->req_material_packing->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->req_material_qty->Visible) { // req_material_qty ?>
	<?php if ($material_required->SortUrl($material_required->req_material_qty) == "") { ?>
		<th class="<?php echo $material_required->req_material_qty->headerCellClass() ?>"><?php echo $material_required->req_material_qty->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->req_material_qty->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->req_material_qty->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->req_material_qty->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->req_material_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->req_material_qty->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->operator->Visible) { // operator ?>
	<?php if ($material_required->SortUrl($material_required->operator) == "") { ?>
		<th class="<?php echo $material_required->operator->headerCellClass() ?>"><?php echo $material_required->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->operator->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->operator->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->operator->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->despatch_date->Visible) { // despatch_date ?>
	<?php if ($material_required->SortUrl($material_required->despatch_date) == "") { ?>
		<th class="<?php echo $material_required->despatch_date->headerCellClass() ?>"><?php echo $material_required->despatch_date->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->despatch_date->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->despatch_date->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->despatch_date->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->despatch_date->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->order_id->Visible) { // order_id ?>
	<?php if ($material_required->SortUrl($material_required->order_id) == "") { ?>
		<th class="<?php echo $material_required->order_id->headerCellClass() ?>"><?php echo $material_required->order_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->order_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->order_id->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->order_id->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->order_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->order_id->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->weaving_works->Visible) { // weaving_works ?>
	<?php if ($material_required->SortUrl($material_required->weaving_works) == "") { ?>
		<th class="<?php echo $material_required->weaving_works->headerCellClass() ?>"><?php echo $material_required->weaving_works->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->weaving_works->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->weaving_works->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->weaving_works->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->weaving_works->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->company_id->Visible) { // company_id ?>
	<?php if ($material_required->SortUrl($material_required->company_id) == "") { ?>
		<th class="<?php echo $material_required->company_id->headerCellClass() ?>"><?php echo $material_required->company_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->company_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->company_id->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->company_id->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->company_id->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->issue_material_lcgp_rid->Visible) { // issue_material_lcgp_rid ?>
	<?php if ($material_required->SortUrl($material_required->issue_material_lcgp_rid) == "") { ?>
		<th class="<?php echo $material_required->issue_material_lcgp_rid->headerCellClass() ?>"><?php echo $material_required->issue_material_lcgp_rid->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->issue_material_lcgp_rid->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->issue_material_lcgp_rid->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->issue_material_lcgp_rid->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->issue_material_lcgp_rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->issue_material_lcgp_rid->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->issue_material_lot_no->Visible) { // issue_material_lot_no ?>
	<?php if ($material_required->SortUrl($material_required->issue_material_lot_no) == "") { ?>
		<th class="<?php echo $material_required->issue_material_lot_no->headerCellClass() ?>"><?php echo $material_required->issue_material_lot_no->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->issue_material_lot_no->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->issue_material_lot_no->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->issue_material_lot_no->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->issue_material_lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->issue_material_lot_no->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_required->issue_material_godown->Visible) { // issue_material_godown ?>
	<?php if ($material_required->SortUrl($material_required->issue_material_godown) == "") { ?>
		<th class="<?php echo $material_required->issue_material_godown->headerCellClass() ?>"><?php echo $material_required->issue_material_godown->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $material_required->issue_material_godown->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($material_required->issue_material_godown->Name) ?>" data-sort-order="<?php echo $material_required_preview->SortField == $material_required->issue_material_godown->Name && $material_required_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_required->issue_material_godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_required_preview->SortField == $material_required->issue_material_godown->Name) { ?><?php if ($material_required_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_required_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_required_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$material_required_preview->RecCount = 0;
$material_required_preview->RowCnt = 0;
while ($material_required_preview->Recordset && !$material_required_preview->Recordset->EOF) {

	// Init row class and style
	$material_required_preview->RecCount++;
	$material_required_preview->RowCnt++;
	$material_required_preview->CssStyle = "";
	$material_required_preview->loadListRowValues($material_required_preview->Recordset);
	$material_required_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$material_required_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$material_required_preview->resetAttributes();
	$material_required_preview->renderListRow();

	// Render list options
	$material_required_preview->renderListOptions();
?>
	<tr<?php echo $material_required_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_required_preview->ListOptions->render("body", "left", $material_required_preview->RowCnt);
?>
<?php if ($material_required->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $material_required->id->cellAttributes() ?>>
<span<?php echo $material_required->id->viewAttributes() ?>>
<?php echo $material_required->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->poid->Visible) { // poid ?>
		<!-- poid -->
		<td<?php echo $material_required->poid->cellAttributes() ?>>
<span<?php echo $material_required->poid->viewAttributes() ?>>
<?php echo $material_required->poid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->po->Visible) { // po ?>
		<!-- po -->
		<td<?php echo $material_required->po->cellAttributes() ?>>
<span<?php echo $material_required->po->viewAttributes() ?>>
<?php echo $material_required->po->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->week->Visible) { // week ?>
		<!-- week -->
		<td<?php echo $material_required->week->cellAttributes() ?>>
<span<?php echo $material_required->week->viewAttributes() ?>>
<?php echo $material_required->week->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->buyer_id->Visible) { // buyer_id ?>
		<!-- buyer_id -->
		<td<?php echo $material_required->buyer_id->cellAttributes() ?>>
<span<?php echo $material_required->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required->buyer_id->getViewValue())) && $material_required->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required->buyer_id->linkAttributes() ?>><?php echo $material_required->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($material_required->product_id->Visible) { // product_id ?>
		<!-- product_id -->
		<td<?php echo $material_required->product_id->cellAttributes() ?>>
<span<?php echo $material_required->product_id->viewAttributes() ?>>
<?php if ((!EmptyString($material_required->product_id->getViewValue())) && $material_required->product_id->linkAttributes() <> "") { ?>
<a<?php echo $material_required->product_id->linkAttributes() ?>><?php echo $material_required->product_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required->product_id->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($material_required->batch_no->Visible) { // batch_no ?>
		<!-- batch_no -->
		<td<?php echo $material_required->batch_no->cellAttributes() ?>>
<span<?php echo $material_required->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($material_required->batch_no->getViewValue())) && $material_required->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $material_required->batch_no->linkAttributes() ?>><?php echo $material_required->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_required->batch_no->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($material_required->quantity->Visible) { // quantity ?>
		<!-- quantity -->
		<td<?php echo $material_required->quantity->cellAttributes() ?>>
<span<?php echo $material_required->quantity->viewAttributes() ?>>
<?php echo $material_required->quantity->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->Size_wl->Visible) { // Size_wl ?>
		<!-- Size_wl -->
		<td<?php echo $material_required->Size_wl->cellAttributes() ?>>
<span<?php echo $material_required->Size_wl->viewAttributes() ?>>
<?php echo $material_required->Size_wl->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->sqm->Visible) { // sqm ?>
		<!-- sqm -->
		<td<?php echo $material_required->sqm->cellAttributes() ?>>
<span<?php echo $material_required->sqm->viewAttributes() ?>>
<?php echo $material_required->sqm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->t_sqm->Visible) { // t_sqm ?>
		<!-- t_sqm -->
		<td<?php echo $material_required->t_sqm->cellAttributes() ?>>
<span<?php echo $material_required->t_sqm->viewAttributes() ?>>
<?php echo $material_required->t_sqm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->unit->Visible) { // unit ?>
		<!-- unit -->
		<td<?php echo $material_required->unit->cellAttributes() ?>>
<span<?php echo $material_required->unit->viewAttributes() ?>>
<?php echo $material_required->unit->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->material_qty->Visible) { // material_qty ?>
		<!-- material_qty -->
		<td<?php echo $material_required->material_qty->cellAttributes() ?>>
<span<?php echo $material_required->material_qty->viewAttributes() ?>>
<?php echo $material_required->material_qty->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->method->Visible) { // method ?>
		<!-- method -->
		<td<?php echo $material_required->method->cellAttributes() ?>>
<span<?php echo $material_required->method->viewAttributes() ?>>
<?php echo $material_required->method->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->despatch_week->Visible) { // despatch_week ?>
		<!-- despatch_week -->
		<td<?php echo $material_required->despatch_week->cellAttributes() ?>>
<span<?php echo $material_required->despatch_week->viewAttributes() ?>>
<?php echo $material_required->despatch_week->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->req_material_rid->Visible) { // req_material_rid ?>
		<!-- req_material_rid -->
		<td<?php echo $material_required->req_material_rid->cellAttributes() ?>>
<span<?php echo $material_required->req_material_rid->viewAttributes() ?>>
<?php echo $material_required->req_material_rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->req_material_packing->Visible) { // req_material_packing ?>
		<!-- req_material_packing -->
		<td<?php echo $material_required->req_material_packing->cellAttributes() ?>>
<span<?php echo $material_required->req_material_packing->viewAttributes() ?>>
<?php echo $material_required->req_material_packing->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->req_material_qty->Visible) { // req_material_qty ?>
		<!-- req_material_qty -->
		<td<?php echo $material_required->req_material_qty->cellAttributes() ?>>
<span<?php echo $material_required->req_material_qty->viewAttributes() ?>>
<?php echo $material_required->req_material_qty->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $material_required->operator->cellAttributes() ?>>
<span<?php echo $material_required->operator->viewAttributes() ?>>
<?php echo $material_required->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->despatch_date->Visible) { // despatch_date ?>
		<!-- despatch_date -->
		<td<?php echo $material_required->despatch_date->cellAttributes() ?>>
<span<?php echo $material_required->despatch_date->viewAttributes() ?>>
<?php echo $material_required->despatch_date->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->order_id->Visible) { // order_id ?>
		<!-- order_id -->
		<td<?php echo $material_required->order_id->cellAttributes() ?>>
<span<?php echo $material_required->order_id->viewAttributes() ?>>
<?php echo $material_required->order_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->weaving_works->Visible) { // weaving_works ?>
		<!-- weaving_works -->
		<td<?php echo $material_required->weaving_works->cellAttributes() ?>>
<span<?php echo $material_required->weaving_works->viewAttributes() ?>>
<?php echo $material_required->weaving_works->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->company_id->Visible) { // company_id ?>
		<!-- company_id -->
		<td<?php echo $material_required->company_id->cellAttributes() ?>>
<span<?php echo $material_required->company_id->viewAttributes() ?>>
<?php echo $material_required->company_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->issue_material_lcgp_rid->Visible) { // issue_material_lcgp_rid ?>
		<!-- issue_material_lcgp_rid -->
		<td<?php echo $material_required->issue_material_lcgp_rid->cellAttributes() ?>>
<span<?php echo $material_required->issue_material_lcgp_rid->viewAttributes() ?>>
<?php echo $material_required->issue_material_lcgp_rid->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->issue_material_lot_no->Visible) { // issue_material_lot_no ?>
		<!-- issue_material_lot_no -->
		<td<?php echo $material_required->issue_material_lot_no->cellAttributes() ?>>
<span<?php echo $material_required->issue_material_lot_no->viewAttributes() ?>>
<?php echo $material_required->issue_material_lot_no->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($material_required->issue_material_godown->Visible) { // issue_material_godown ?>
		<!-- issue_material_godown -->
		<td<?php echo $material_required->issue_material_godown->cellAttributes() ?>>
<span<?php echo $material_required->issue_material_godown->viewAttributes() ?>>
<?php echo $material_required->issue_material_godown->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$material_required_preview->ListOptions->render("body", "right", $material_required_preview->RowCnt);
?>
	</tr>
<?php
	$material_required_preview->Recordset->MoveNext();
}
?>
	</tbody>
<?php

	// Render aggregate row
	$material_required_preview->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$material_required_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$material_required_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$material_required_preview->ListOptions->render("footer", "left");
?>
<?php if ($material_required->id->Visible) { // id ?>
		<!-- id -->
		<td class="<?php echo $material_required->id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->poid->Visible) { // poid ?>
		<!-- poid -->
		<td class="<?php echo $material_required->poid->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->po->Visible) { // po ?>
		<!-- po -->
		<td class="<?php echo $material_required->po->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->week->Visible) { // week ?>
		<!-- week -->
		<td class="<?php echo $material_required->week->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->buyer_id->Visible) { // buyer_id ?>
		<!-- buyer_id -->
		<td class="<?php echo $material_required->buyer_id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->product_id->Visible) { // product_id ?>
		<!-- product_id -->
		<td class="<?php echo $material_required->product_id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->batch_no->Visible) { // batch_no ?>
		<!-- batch_no -->
		<td class="<?php echo $material_required->batch_no->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->quantity->Visible) { // quantity ?>
		<!-- quantity -->
		<td class="<?php echo $material_required->quantity->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->Size_wl->Visible) { // Size_wl ?>
		<!-- Size_wl -->
		<td class="<?php echo $material_required->Size_wl->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->sqm->Visible) { // sqm ?>
		<!-- sqm -->
		<td class="<?php echo $material_required->sqm->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->t_sqm->Visible) { // t_sqm ?>
		<!-- t_sqm -->
		<td class="<?php echo $material_required->t_sqm->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->unit->Visible) { // unit ?>
		<!-- unit -->
		<td class="<?php echo $material_required->unit->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->material_qty->Visible) { // material_qty ?>
		<!-- material_qty -->
		<td class="<?php echo $material_required->material_qty->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->method->Visible) { // method ?>
		<!-- method -->
		<td class="<?php echo $material_required->method->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->despatch_week->Visible) { // despatch_week ?>
		<!-- despatch_week -->
		<td class="<?php echo $material_required->despatch_week->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->req_material_rid->Visible) { // req_material_rid ?>
		<!-- req_material_rid -->
		<td class="<?php echo $material_required->req_material_rid->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->req_material_packing->Visible) { // req_material_packing ?>
		<!-- req_material_packing -->
		<td class="<?php echo $material_required->req_material_packing->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->req_material_qty->Visible) { // req_material_qty ?>
		<!-- req_material_qty -->
		<td class="<?php echo $material_required->req_material_qty->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $material_required->req_material_qty->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($material_required->operator->Visible) { // operator ?>
		<!-- operator -->
		<td class="<?php echo $material_required->operator->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->despatch_date->Visible) { // despatch_date ?>
		<!-- despatch_date -->
		<td class="<?php echo $material_required->despatch_date->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->order_id->Visible) { // order_id ?>
		<!-- order_id -->
		<td class="<?php echo $material_required->order_id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->weaving_works->Visible) { // weaving_works ?>
		<!-- weaving_works -->
		<td class="<?php echo $material_required->weaving_works->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->company_id->Visible) { // company_id ?>
		<!-- company_id -->
		<td class="<?php echo $material_required->company_id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->issue_material_lcgp_rid->Visible) { // issue_material_lcgp_rid ?>
		<!-- issue_material_lcgp_rid -->
		<td class="<?php echo $material_required->issue_material_lcgp_rid->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->issue_material_lot_no->Visible) { // issue_material_lot_no ?>
		<!-- issue_material_lot_no -->
		<td class="<?php echo $material_required->issue_material_lot_no->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($material_required->issue_material_godown->Visible) { // issue_material_godown ?>
		<!-- issue_material_godown -->
		<td class="<?php echo $material_required->issue_material_godown->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$material_required_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($material_required_preview->TotalRecs > 0) { ?>
<?php if (!isset($material_required_preview->Pager)) $material_required_preview->Pager = new PrevNextPager($material_required_preview->StartRec, $material_required_preview->DisplayRecs, $material_required_preview->TotalRecs) ?>
<?php if ($material_required_preview->Pager->RecordCount > 0 && $material_required_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($material_required_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $material_required_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($material_required_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $material_required_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($material_required_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $material_required_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($material_required_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $material_required_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $material_required_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $material_required_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $material_required_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($material_required_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$material_required_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($material_required_preview->Recordset)
	$material_required_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$material_required_preview->terminate();
?>