<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_status_list = new material_status_list();

// Run the page
$material_status_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_status_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_status->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmaterial_statuslist = currentForm = new ew.Form("fmaterial_statuslist", "list");
fmaterial_statuslist.formKeyCountName = '<?php echo $material_status_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmaterial_statuslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_statuslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_statuslist.lists["x_status"] = <?php echo $material_status_list->status->Lookup->toClientList() ?>;
fmaterial_statuslist.lists["x_status"].options = <?php echo JsonEncode($material_status_list->status->options(FALSE, TRUE)) ?>;
fmaterial_statuslist.lists["x_grp"] = <?php echo $material_status_list->grp->Lookup->toClientList() ?>;
fmaterial_statuslist.lists["x_grp"].options = <?php echo JsonEncode($material_status_list->grp->lookupOptions()) ?>;
fmaterial_statuslist.lists["x_s_grp"] = <?php echo $material_status_list->s_grp->Lookup->toClientList() ?>;
fmaterial_statuslist.lists["x_s_grp"].options = <?php echo JsonEncode($material_status_list->s_grp->lookupOptions()) ?>;
fmaterial_statuslist.lists["x_product"] = <?php echo $material_status_list->product->Lookup->toClientList() ?>;
fmaterial_statuslist.lists["x_product"].options = <?php echo JsonEncode($material_status_list->product->lookupOptions()) ?>;
fmaterial_statuslist.lists["x_packing_type"] = <?php echo $material_status_list->packing_type->Lookup->toClientList() ?>;
fmaterial_statuslist.lists["x_packing_type"].options = <?php echo JsonEncode($material_status_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fmaterial_statuslistsrch = currentSearchForm = new ew.Form("fmaterial_statuslistsrch");

// Validate function for search
fmaterial_statuslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmaterial_statuslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_statuslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_statuslistsrch.lists["x_status"] = <?php echo $material_status_list->status->Lookup->toClientList() ?>;
fmaterial_statuslistsrch.lists["x_status"].options = <?php echo JsonEncode($material_status_list->status->options(FALSE, TRUE)) ?>;

// Filters
fmaterial_statuslistsrch.filterList = <?php echo $material_status_list->getFilterList() ?>;

// Init search panel as collapsed
fmaterial_statuslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
var CreateOrder =function(){
	  var checkID =[];
	  $("#tbl_material_statuslist tbody input[type='checkbox']:checked").each(function(){
	  		 checkID.push($(this).val());
	  });
	  if(checkID.length>0)
	  {
	  	location.href='autoprogramme.php?apcid=&id='+checkID.toString();
	  }
	  else
	  {
	  	ew.alert("Please Select atleast a row to Update");
	  }
}
</script>
<?php } ?>
<?php if (!$material_status->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($material_status_list->TotalRecs > 0 && $material_status_list->ExportOptions->visible()) { ?>
<?php $material_status_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($material_status_list->ImportOptions->visible()) { ?>
<?php $material_status_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($material_status_list->SearchOptions->visible()) { ?>
<?php $material_status_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($material_status_list->FilterOptions->visible()) { ?>
<?php $material_status_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$material_status_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$material_status->isExport() && !$material_status->CurrentAction) { ?>
<form name="fmaterial_statuslistsrch" id="fmaterial_statuslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($material_status_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmaterial_statuslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="material_status">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$material_status_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$material_status->RowType = ROWTYPE_SEARCH;

// Render row
$material_status->resetAttributes();
$material_status_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($material_status->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $material_status->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="material_status" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($material_status->product_code->getPlaceHolder()) ?>" value="<?php echo $material_status->product_code->EditValue ?>"<?php echo $material_status->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($material_status->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $material_status->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_status" data-field="x_status" data-value-separator="<?php echo $material_status->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $material_status->status->editAttributes() ?>>
		<?php echo $material_status->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($material_status_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($material_status_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $material_status_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($material_status_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($material_status_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($material_status_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($material_status_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $material_status_list->showPageHeader(); ?>
<?php
$material_status_list->showMessage();
?>
<?php if ($material_status_list->TotalRecs > 0 || $material_status->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($material_status_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> material_status">
<?php if (!$material_status->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$material_status->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_status_list->Pager)) $material_status_list->Pager = new PrevNextPager($material_status_list->StartRec, $material_status_list->DisplayRecs, $material_status_list->TotalRecs, $material_status_list->AutoHidePager) ?>
<?php if ($material_status_list->Pager->RecordCount > 0 && $material_status_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_status_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_status_list->pageUrl() ?>start=<?php echo $material_status_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_status_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_status_list->pageUrl() ?>start=<?php echo $material_status_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_status_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_status_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_status_list->pageUrl() ?>start=<?php echo $material_status_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_status_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_status_list->pageUrl() ?>start=<?php echo $material_status_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_status_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_status_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_status_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_status_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_status_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_status_list->TotalRecs > 0 && (!$material_status_list->AutoHidePageSizeSelector || $material_status_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_status">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_status_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_status_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_status_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_status_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_status_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_status->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmaterial_statuslist" id="fmaterial_statuslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_status_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_status_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_status">
<div id="gmp_material_status" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($material_status_list->TotalRecs > 0 || $material_status->isGridEdit()) { ?>
<table id="tbl_material_statuslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$material_status_list->RowType = ROWTYPE_HEADER;

// Render list options
$material_status_list->renderListOptions();

// Render list options (header, left)
$material_status_list->ListOptions->render("header", "left");
?>
<?php if ($material_status->id->Visible) { // id ?>
	<?php if ($material_status->sortUrl($material_status->id) == "") { ?>
		<th data-name="id" class="<?php echo $material_status->id->headerCellClass() ?>"><div id="elh_material_status_id" class="material_status_id"><div class="ew-table-header-caption"><?php echo $material_status->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $material_status->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_status->SortUrl($material_status->id) ?>',2);"><div id="elh_material_status_id" class="material_status_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_status->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_status->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_status->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_status->s_code->Visible) { // s_code ?>
	<?php if ($material_status->sortUrl($material_status->s_code) == "") { ?>
		<th data-name="s_code" class="<?php echo $material_status->s_code->headerCellClass() ?>"><div id="elh_material_status_s_code" class="material_status_s_code"><div class="ew-table-header-caption"><?php echo $material_status->s_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_code" class="<?php echo $material_status->s_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_status->SortUrl($material_status->s_code) ?>',2);"><div id="elh_material_status_s_code" class="material_status_s_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_status->s_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_status->s_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_status->s_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_status->image->Visible) { // image ?>
	<?php if ($material_status->sortUrl($material_status->image) == "") { ?>
		<th data-name="image" class="<?php echo $material_status->image->headerCellClass() ?>"><div id="elh_material_status_image" class="material_status_image"><div class="ew-table-header-caption"><?php echo $material_status->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $material_status->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_status->SortUrl($material_status->image) ?>',2);"><div id="elh_material_status_image" class="material_status_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_status->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_status->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_status->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_status->product_code->Visible) { // product_code ?>
	<?php if ($material_status->sortUrl($material_status->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $material_status->product_code->headerCellClass() ?>"><div id="elh_material_status_product_code" class="material_status_product_code"><div class="ew-table-header-caption"><?php echo $material_status->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $material_status->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_status->SortUrl($material_status->product_code) ?>',2);"><div id="elh_material_status_product_code" class="material_status_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_status->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($material_status->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_status->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_status->status->Visible) { // status ?>
	<?php if ($material_status->sortUrl($material_status->status) == "") { ?>
		<th data-name="status" class="<?php echo $material_status->status->headerCellClass() ?>"><div id="elh_material_status_status" class="material_status_status"><div class="ew-table-header-caption"><?php echo $material_status->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $material_status->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_status->SortUrl($material_status->status) ?>',2);"><div id="elh_material_status_status" class="material_status_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_status->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_status->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_status->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_status->grp->Visible) { // grp ?>
	<?php if ($material_status->sortUrl($material_status->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $material_status->grp->headerCellClass() ?>"><div id="elh_material_status_grp" class="material_status_grp"><div class="ew-table-header-caption"><?php echo $material_status->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $material_status->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_status->SortUrl($material_status->grp) ?>',2);"><div id="elh_material_status_grp" class="material_status_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_status->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_status->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_status->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_status->s_grp->Visible) { // s_grp ?>
	<?php if ($material_status->sortUrl($material_status->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $material_status->s_grp->headerCellClass() ?>"><div id="elh_material_status_s_grp" class="material_status_s_grp"><div class="ew-table-header-caption"><?php echo $material_status->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $material_status->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_status->SortUrl($material_status->s_grp) ?>',2);"><div id="elh_material_status_s_grp" class="material_status_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_status->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_status->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_status->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_status->product->Visible) { // product ?>
	<?php if ($material_status->sortUrl($material_status->product) == "") { ?>
		<th data-name="product" class="<?php echo $material_status->product->headerCellClass() ?>"><div id="elh_material_status_product" class="material_status_product"><div class="ew-table-header-caption"><?php echo $material_status->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $material_status->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_status->SortUrl($material_status->product) ?>',2);"><div id="elh_material_status_product" class="material_status_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_status->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_status->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_status->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($material_status->packing_type->Visible) { // packing_type ?>
	<?php if ($material_status->sortUrl($material_status->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $material_status->packing_type->headerCellClass() ?>"><div id="elh_material_status_packing_type" class="material_status_packing_type"><div class="ew-table-header-caption"><?php echo $material_status->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $material_status->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $material_status->SortUrl($material_status->packing_type) ?>',2);"><div id="elh_material_status_packing_type" class="material_status_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $material_status->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($material_status->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($material_status->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$material_status_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($material_status->ExportAll && $material_status->isExport()) {
	$material_status_list->StopRec = $material_status_list->TotalRecs;
} else {

	// Set the last record to display
	if ($material_status_list->TotalRecs > $material_status_list->StartRec + $material_status_list->DisplayRecs - 1)
		$material_status_list->StopRec = $material_status_list->StartRec + $material_status_list->DisplayRecs - 1;
	else
		$material_status_list->StopRec = $material_status_list->TotalRecs;
}
$material_status_list->RecCnt = $material_status_list->StartRec - 1;
if ($material_status_list->Recordset && !$material_status_list->Recordset->EOF) {
	$material_status_list->Recordset->moveFirst();
	$selectLimit = $material_status_list->UseSelectLimit;
	if (!$selectLimit && $material_status_list->StartRec > 1)
		$material_status_list->Recordset->move($material_status_list->StartRec - 1);
} elseif (!$material_status->AllowAddDeleteRow && $material_status_list->StopRec == 0) {
	$material_status_list->StopRec = $material_status->GridAddRowCount;
}

// Initialize aggregate
$material_status->RowType = ROWTYPE_AGGREGATEINIT;
$material_status->resetAttributes();
$material_status_list->renderRow();
while ($material_status_list->RecCnt < $material_status_list->StopRec) {
	$material_status_list->RecCnt++;
	if ($material_status_list->RecCnt >= $material_status_list->StartRec) {
		$material_status_list->RowCnt++;

		// Set up key count
		$material_status_list->KeyCount = $material_status_list->RowIndex;

		// Init row class and style
		$material_status->resetAttributes();
		$material_status->CssClass = "";
		if ($material_status->isGridAdd()) {
		} else {
			$material_status_list->loadRowValues($material_status_list->Recordset); // Load row values
		}
		$material_status->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$material_status->RowAttrs = array_merge($material_status->RowAttrs, array('data-rowindex'=>$material_status_list->RowCnt, 'id'=>'r' . $material_status_list->RowCnt . '_material_status', 'data-rowtype'=>$material_status->RowType));

		// Render row
		$material_status_list->renderRow();

		// Render list options
		$material_status_list->renderListOptions();
?>
	<tr<?php echo $material_status->rowAttributes() ?>>
<?php

// Render list options (body, left)
$material_status_list->ListOptions->render("body", "left", $material_status_list->RowCnt);
?>
	<?php if ($material_status->id->Visible) { // id ?>
		<td data-name="id"<?php echo $material_status->id->cellAttributes() ?>>
<span id="el<?php echo $material_status_list->RowCnt ?>_material_status_id" class="material_status_id">
<span<?php echo $material_status->id->viewAttributes() ?>>
<?php echo $material_status->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_status->s_code->Visible) { // s_code ?>
		<td data-name="s_code"<?php echo $material_status->s_code->cellAttributes() ?>>
<span id="el<?php echo $material_status_list->RowCnt ?>_material_status_s_code" class="material_status_s_code">
<span<?php echo $material_status->s_code->viewAttributes() ?>>
<?php echo $material_status->s_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_status->image->Visible) { // image ?>
		<td data-name="image"<?php echo $material_status->image->cellAttributes() ?>>
<span id="el<?php echo $material_status_list->RowCnt ?>_material_status_image" class="material_status_image">
<span>
<?php echo GetFileViewTag($material_status->image, $material_status->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_status->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $material_status->product_code->cellAttributes() ?>>
<span id="el<?php echo $material_status_list->RowCnt ?>_material_status_product_code" class="material_status_product_code">
<span<?php echo $material_status->product_code->viewAttributes() ?>>
<?php echo $material_status->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_status->status->Visible) { // status ?>
		<td data-name="status"<?php echo $material_status->status->cellAttributes() ?>>
<span id="el<?php echo $material_status_list->RowCnt ?>_material_status_status" class="material_status_status">
<span<?php echo $material_status->status->viewAttributes() ?>>
<?php echo $material_status->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($material_status->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $material_status->grp->cellAttributes() ?>>
<span id="el<?php echo $material_status_list->RowCnt ?>_material_status_grp" class="material_status_grp">
<span<?php echo $material_status->grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_status->grp->getViewValue())) && $material_status->grp->linkAttributes() <> "") { ?>
<a<?php echo $material_status->grp->linkAttributes() ?>><?php echo $material_status->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_status->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_status->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $material_status->s_grp->cellAttributes() ?>>
<span id="el<?php echo $material_status_list->RowCnt ?>_material_status_s_grp" class="material_status_s_grp">
<span<?php echo $material_status->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_status->s_grp->getViewValue())) && $material_status->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $material_status->s_grp->linkAttributes() ?>><?php echo $material_status->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_status->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_status->product->Visible) { // product ?>
		<td data-name="product"<?php echo $material_status->product->cellAttributes() ?>>
<span id="el<?php echo $material_status_list->RowCnt ?>_material_status_product" class="material_status_product">
<span<?php echo $material_status->product->viewAttributes() ?>>
<?php if ((!EmptyString($material_status->product->getViewValue())) && $material_status->product->linkAttributes() <> "") { ?>
<a<?php echo $material_status->product->linkAttributes() ?>><?php echo $material_status->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_status->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($material_status->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $material_status->packing_type->cellAttributes() ?>>
<span id="el<?php echo $material_status_list->RowCnt ?>_material_status_packing_type" class="material_status_packing_type">
<span<?php echo $material_status->packing_type->viewAttributes() ?>>
<?php echo $material_status->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$material_status_list->ListOptions->render("body", "right", $material_status_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$material_status->isGridAdd())
		$material_status_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$material_status->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($material_status_list->Recordset)
	$material_status_list->Recordset->Close();
?>
<?php if (!$material_status->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$material_status->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($material_status_list->Pager)) $material_status_list->Pager = new PrevNextPager($material_status_list->StartRec, $material_status_list->DisplayRecs, $material_status_list->TotalRecs, $material_status_list->AutoHidePager) ?>
<?php if ($material_status_list->Pager->RecordCount > 0 && $material_status_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($material_status_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $material_status_list->pageUrl() ?>start=<?php echo $material_status_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($material_status_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $material_status_list->pageUrl() ?>start=<?php echo $material_status_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $material_status_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($material_status_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $material_status_list->pageUrl() ?>start=<?php echo $material_status_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($material_status_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $material_status_list->pageUrl() ?>start=<?php echo $material_status_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $material_status_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($material_status_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $material_status_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $material_status_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $material_status_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($material_status_list->TotalRecs > 0 && (!$material_status_list->AutoHidePageSizeSelector || $material_status_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="material_status">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($material_status_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($material_status_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($material_status_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($material_status_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($material_status_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($material_status->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $material_status_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($material_status_list->TotalRecs == 0 && !$material_status->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $material_status_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$material_status_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_status->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$material_status->isExport()) { ?>
<script>
ew.scrollableTable("gmp_material_status", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_status_list->terminate();
?>