<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_status_search = new material_status_search();

// Run the page
$material_status_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_status_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($material_status_search->IsModal) { ?>
var fmaterial_statussearch = currentAdvancedSearchForm = new ew.Form("fmaterial_statussearch", "search");
<?php } else { ?>
var fmaterial_statussearch = currentForm = new ew.Form("fmaterial_statussearch", "search");
<?php } ?>

// Form_CustomValidate event
fmaterial_statussearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_statussearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_statussearch.lists["x_company_id"] = <?php echo $material_status_search->company_id->Lookup->toClientList() ?>;
fmaterial_statussearch.lists["x_company_id"].options = <?php echo JsonEncode($material_status_search->company_id->lookupOptions()) ?>;
fmaterial_statussearch.lists["x_status"] = <?php echo $material_status_search->status->Lookup->toClientList() ?>;
fmaterial_statussearch.lists["x_status"].options = <?php echo JsonEncode($material_status_search->status->options(FALSE, TRUE)) ?>;
fmaterial_statussearch.lists["x_grp"] = <?php echo $material_status_search->grp->Lookup->toClientList() ?>;
fmaterial_statussearch.lists["x_grp"].options = <?php echo JsonEncode($material_status_search->grp->lookupOptions()) ?>;
fmaterial_statussearch.lists["x_s_grp"] = <?php echo $material_status_search->s_grp->Lookup->toClientList() ?>;
fmaterial_statussearch.lists["x_s_grp"].options = <?php echo JsonEncode($material_status_search->s_grp->lookupOptions()) ?>;
fmaterial_statussearch.lists["x_product"] = <?php echo $material_status_search->product->Lookup->toClientList() ?>;
fmaterial_statussearch.lists["x_product"].options = <?php echo JsonEncode($material_status_search->product->lookupOptions()) ?>;
fmaterial_statussearch.lists["x_product_type"] = <?php echo $material_status_search->product_type->Lookup->toClientList() ?>;
fmaterial_statussearch.lists["x_product_type"].options = <?php echo JsonEncode($material_status_search->product_type->lookupOptions()) ?>;
fmaterial_statussearch.autoSuggests["x_product_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_statussearch.lists["x_packing_type"] = <?php echo $material_status_search->packing_type->Lookup->toClientList() ?>;
fmaterial_statussearch.lists["x_packing_type"].options = <?php echo JsonEncode($material_status_search->packing_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmaterial_statussearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($material_status->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $material_status_search->showPageHeader(); ?>
<?php
$material_status_search->showMessage();
?>
<form name="fmaterial_statussearch" id="fmaterial_statussearch" class="<?php echo $material_status_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_status_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_status_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_status">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$material_status_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($material_status->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_id"><?php echo $material_status->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->id->cellAttributes() ?>>
			<span id="el_material_status_id">
<input type="text" data-table="material_status" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($material_status->id->getPlaceHolder()) ?>" value="<?php echo $material_status->id->EditValue ?>"<?php echo $material_status->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_status->s_code->Visible) { // s_code ?>
	<div id="r_s_code" class="form-group row">
		<label for="x_s_code" class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_s_code"><?php echo $material_status->s_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_s_code" id="z_s_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->s_code->cellAttributes() ?>>
			<span id="el_material_status_s_code">
<input type="text" data-table="material_status" data-field="x_s_code" name="x_s_code" id="x_s_code" size="30" maxlength="193" placeholder="<?php echo HtmlEncode($material_status->s_code->getPlaceHolder()) ?>" value="<?php echo $material_status->s_code->EditValue ?>"<?php echo $material_status->s_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_status->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_product_code"><?php echo $material_status->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->product_code->cellAttributes() ?>>
			<span id="el_material_status_product_code">
<input type="text" data-table="material_status" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($material_status->product_code->getPlaceHolder()) ?>" value="<?php echo $material_status->product_code->EditValue ?>"<?php echo $material_status->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_status->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_company_id"><?php echo $material_status->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->company_id->cellAttributes() ?>>
			<span id="el_material_status_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_status" data-field="x_company_id" data-value-separator="<?php echo $material_status->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $material_status->company_id->editAttributes() ?>>
		<?php echo $material_status->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $material_status->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_status->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_status"><?php echo $material_status->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->status->cellAttributes() ?>>
			<span id="el_material_status_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_status" data-field="x_status" data-value-separator="<?php echo $material_status->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $material_status->status->editAttributes() ?>>
		<?php echo $material_status->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_status->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_grp"><?php echo $material_status->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->grp->cellAttributes() ?>>
			<span id="el_material_status_grp">
<?php $material_status->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_status->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_status" data-field="x_grp" data-value-separator="<?php echo $material_status->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $material_status->grp->editAttributes() ?>>
		<?php echo $material_status->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $material_status->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_status->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_s_grp"><?php echo $material_status->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->s_grp->cellAttributes() ?>>
			<span id="el_material_status_s_grp">
<?php $material_status->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$material_status->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_status" data-field="x_s_grp" data-value-separator="<?php echo $material_status->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $material_status->s_grp->editAttributes() ?>>
		<?php echo $material_status->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $material_status->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_status->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_product"><?php echo $material_status->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->product->cellAttributes() ?>>
			<span id="el_material_status_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_status" data-field="x_product" data-value-separator="<?php echo $material_status->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $material_status->product->editAttributes() ?>>
		<?php echo $material_status->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $material_status->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_status->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_product_type"><?php echo $material_status->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_type" id="z_product_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->product_type->cellAttributes() ?>>
			<span id="el_material_status_product_type">
<?php
$wrkonchange = "" . trim(@$material_status->product_type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$material_status->product_type->EditAttrs["onchange"] = "";
?>
<span id="as_x_product_type" class="text-nowrap" style="z-index: 8900">
	<input type="text" class="form-control" name="sv_x_product_type" id="sv_x_product_type" value="<?php echo RemoveHtml($material_status->product_type->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($material_status->product_type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($material_status->product_type->getPlaceHolder()) ?>"<?php echo $material_status->product_type->editAttributes() ?>>
</span>
<input type="hidden" data-table="material_status" data-field="x_product_type" data-value-separator="<?php echo $material_status->product_type->displayValueSeparatorAttribute() ?>" name="x_product_type" id="x_product_type" value="<?php echo HtmlEncode($material_status->product_type->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmaterial_statussearch.createAutoSuggest({"id":"x_product_type","forceSelect":false});
</script>
<?php echo $material_status->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($material_status->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $material_status_search->LeftColumnClass ?>"><span id="elh_material_status_packing_type"><?php echo $material_status->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $material_status_search->RightColumnClass ?>"><div<?php echo $material_status->packing_type->cellAttributes() ?>>
			<span id="el_material_status_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="material_status" data-field="x_packing_type" data-value-separator="<?php echo $material_status->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $material_status->packing_type->editAttributes() ?>>
		<?php echo $material_status->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $material_status->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$material_status_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $material_status_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$material_status_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$material_status_search->terminate();
?>