<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$material_status_view = new material_status_view();

// Run the page
$material_status_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$material_status_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$material_status->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmaterial_statusview = currentForm = new ew.Form("fmaterial_statusview", "view");

// Form_CustomValidate event
fmaterial_statusview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmaterial_statusview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmaterial_statusview.lists["x_company_id"] = <?php echo $material_status_view->company_id->Lookup->toClientList() ?>;
fmaterial_statusview.lists["x_company_id"].options = <?php echo JsonEncode($material_status_view->company_id->lookupOptions()) ?>;
fmaterial_statusview.lists["x_status"] = <?php echo $material_status_view->status->Lookup->toClientList() ?>;
fmaterial_statusview.lists["x_status"].options = <?php echo JsonEncode($material_status_view->status->options(FALSE, TRUE)) ?>;
fmaterial_statusview.lists["x_grp"] = <?php echo $material_status_view->grp->Lookup->toClientList() ?>;
fmaterial_statusview.lists["x_grp"].options = <?php echo JsonEncode($material_status_view->grp->lookupOptions()) ?>;
fmaterial_statusview.lists["x_s_grp"] = <?php echo $material_status_view->s_grp->Lookup->toClientList() ?>;
fmaterial_statusview.lists["x_s_grp"].options = <?php echo JsonEncode($material_status_view->s_grp->lookupOptions()) ?>;
fmaterial_statusview.lists["x_product"] = <?php echo $material_status_view->product->Lookup->toClientList() ?>;
fmaterial_statusview.lists["x_product"].options = <?php echo JsonEncode($material_status_view->product->lookupOptions()) ?>;
fmaterial_statusview.lists["x_product_type"] = <?php echo $material_status_view->product_type->Lookup->toClientList() ?>;
fmaterial_statusview.lists["x_product_type"].options = <?php echo JsonEncode($material_status_view->product_type->lookupOptions()) ?>;
fmaterial_statusview.autoSuggests["x_product_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmaterial_statusview.lists["x_packing_type"] = <?php echo $material_status_view->packing_type->Lookup->toClientList() ?>;
fmaterial_statusview.lists["x_packing_type"].options = <?php echo JsonEncode($material_status_view->packing_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$material_status->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $material_status_view->ExportOptions->render("body") ?>
<?php $material_status_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $material_status_view->showPageHeader(); ?>
<?php
$material_status_view->showMessage();
?>
<form name="fmaterial_statusview" id="fmaterial_statusview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($material_status_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $material_status_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="material_status">
<input type="hidden" name="modal" value="<?php echo (int)$material_status_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($material_status->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_id"><?php echo $material_status->id->caption() ?></span></td>
		<td data-name="id"<?php echo $material_status->id->cellAttributes() ?>>
<span id="el_material_status_id">
<span<?php echo $material_status->id->viewAttributes() ?>>
<?php echo $material_status->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->s_code->Visible) { // s_code ?>
	<tr id="r_s_code">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_s_code"><?php echo $material_status->s_code->caption() ?></span></td>
		<td data-name="s_code"<?php echo $material_status->s_code->cellAttributes() ?>>
<span id="el_material_status_s_code">
<span<?php echo $material_status->s_code->viewAttributes() ?>>
<?php echo $material_status->s_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_image"><?php echo $material_status->image->caption() ?></span></td>
		<td data-name="image"<?php echo $material_status->image->cellAttributes() ?>>
<span id="el_material_status_image">
<span>
<?php echo GetFileViewTag($material_status->image, $material_status->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->product_code->Visible) { // product_code ?>
	<tr id="r_product_code">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_product_code"><?php echo $material_status->product_code->caption() ?></span></td>
		<td data-name="product_code"<?php echo $material_status->product_code->cellAttributes() ?>>
<span id="el_material_status_product_code">
<span<?php echo $material_status->product_code->viewAttributes() ?>>
<?php echo $material_status->product_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_company_id"><?php echo $material_status->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $material_status->company_id->cellAttributes() ?>>
<span id="el_material_status_company_id">
<span<?php echo $material_status->company_id->viewAttributes() ?>>
<?php echo $material_status->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_status"><?php echo $material_status->status->caption() ?></span></td>
		<td data-name="status"<?php echo $material_status->status->cellAttributes() ?>>
<span id="el_material_status_status">
<span<?php echo $material_status->status->viewAttributes() ?>>
<?php echo $material_status->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_grp"><?php echo $material_status->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $material_status->grp->cellAttributes() ?>>
<span id="el_material_status_grp">
<span<?php echo $material_status->grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_status->grp->getViewValue())) && $material_status->grp->linkAttributes() <> "") { ?>
<a<?php echo $material_status->grp->linkAttributes() ?>><?php echo $material_status->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_status->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_s_grp"><?php echo $material_status->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $material_status->s_grp->cellAttributes() ?>>
<span id="el_material_status_s_grp">
<span<?php echo $material_status->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($material_status->s_grp->getViewValue())) && $material_status->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $material_status->s_grp->linkAttributes() ?>><?php echo $material_status->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_status->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_product"><?php echo $material_status->product->caption() ?></span></td>
		<td data-name="product"<?php echo $material_status->product->cellAttributes() ?>>
<span id="el_material_status_product">
<span<?php echo $material_status->product->viewAttributes() ?>>
<?php if ((!EmptyString($material_status->product->getViewValue())) && $material_status->product->linkAttributes() <> "") { ?>
<a<?php echo $material_status->product->linkAttributes() ?>><?php echo $material_status->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_status->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->product_type->Visible) { // product_type ?>
	<tr id="r_product_type">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_product_type"><?php echo $material_status->product_type->caption() ?></span></td>
		<td data-name="product_type"<?php echo $material_status->product_type->cellAttributes() ?>>
<span id="el_material_status_product_type">
<span<?php echo $material_status->product_type->viewAttributes() ?>>
<?php if ((!EmptyString($material_status->product_type->getViewValue())) && $material_status->product_type->linkAttributes() <> "") { ?>
<a<?php echo $material_status->product_type->linkAttributes() ?>><?php echo $material_status->product_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $material_status->product_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($material_status->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $material_status_view->TableLeftColumnClass ?>"><span id="elh_material_status_packing_type"><?php echo $material_status->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $material_status->packing_type->cellAttributes() ?>>
<span id="el_material_status_packing_type">
<span<?php echo $material_status->packing_type->viewAttributes() ?>>
<?php echo $material_status->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php
	if (in_array("product_cart_s", explode(",", $material_status->getCurrentDetailTable())) && $product_cart_s->DetailView) {
?>
<?php if ($material_status->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("product_cart_s", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "product_cart_sgrid.php" ?>
<?php } ?>
<?php
	if (in_array("stock", explode(",", $material_status->getCurrentDetailTable())) && $stock->DetailView) {
?>
<?php if ($material_status->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("stock", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "stockgrid.php" ?>
<?php } ?>
</form>
<?php
$material_status_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$material_status->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$material_status_view->terminate();
?>