<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$member_info_add = new member_info_add();

// Run the page
$member_info_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$member_info_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fmember_infoadd = currentForm = new ew.Form("fmember_infoadd", "add");

// Validate form
fmember_infoadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($member_info_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->type->caption(), $member_info->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->name->caption(), $member_info->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->classification->Required) { ?>
			elm = this.getElements("x" + infix + "_classification");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->classification->caption(), $member_info->classification->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->mobile->caption(), $member_info->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->_email->caption(), $member_info->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($member_info->_email->errorMessage()) ?>");
		<?php if ($member_info_add->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->address->caption(), $member_info->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->blood_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_blood_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->blood_grp->caption(), $member_info->blood_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->dob->Required) { ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->dob->caption(), $member_info->dob->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($member_info->dob->errorMessage()) ?>");
		<?php if ($member_info_add->dom->Required) { ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->dom->caption(), $member_info->dom->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($member_info->dom->errorMessage()) ?>");
		<?php if ($member_info_add->join_date->Required) { ?>
			elm = this.getElements("x" + infix + "_join_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->join_date->caption(), $member_info->join_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_join_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($member_info->join_date->errorMessage()) ?>");
		<?php if ($member_info_add->spouse_name->Required) { ?>
			elm = this.getElements("x" + infix + "_spouse_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->spouse_name->caption(), $member_info->spouse_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->children_name->Required) { ?>
			elm = this.getElements("x" + infix + "_children_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->children_name->caption(), $member_info->children_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $member_info->image->caption(), $member_info->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->remakrs->Required) { ?>
			elm = this.getElements("x" + infix + "_remakrs");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->remakrs->caption(), $member_info->remakrs->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->operator->caption(), $member_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($member_info_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $member_info->datetime->caption(), $member_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmember_infoadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmember_infoadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmember_infoadd.lists["x_type"] = <?php echo $member_info_add->type->Lookup->toClientList() ?>;
fmember_infoadd.lists["x_type"].options = <?php echo JsonEncode($member_info_add->type->lookupOptions()) ?>;
fmember_infoadd.autoSuggests["x_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmember_infoadd.lists["x_blood_grp[]"] = <?php echo $member_info_add->blood_grp->Lookup->toClientList() ?>;
fmember_infoadd.lists["x_blood_grp[]"].options = <?php echo JsonEncode($member_info_add->blood_grp->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $member_info_add->showPageHeader(); ?>
<?php
$member_info_add->showMessage();
?>
<form name="fmember_infoadd" id="fmember_infoadd" class="<?php echo $member_info_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($member_info_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $member_info_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="member_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$member_info_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($member_info->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_member_info_type" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->type->caption() ?><?php echo ($member_info->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->type->cellAttributes() ?>>
<span id="el_member_info_type">
<?php
$wrkonchange = "" . trim(@$member_info->type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$member_info->type->EditAttrs["onchange"] = "";
?>
<span id="as_x_type" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_type" id="sv_x_type" value="<?php echo RemoveHtml($member_info->type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($member_info->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($member_info->type->getPlaceHolder()) ?>"<?php echo $member_info->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="member_info" data-field="x_type" data-value-separator="<?php echo $member_info->type->displayValueSeparatorAttribute() ?>" name="x_type" id="x_type" value="<?php echo HtmlEncode($member_info->type->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmember_infoadd.createAutoSuggest({"id":"x_type","forceSelect":false});
</script>
<?php echo $member_info->type->Lookup->getParamTag("p_x_type") ?>
</span>
<?php echo $member_info->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_member_info_name" for="x_name" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->name->caption() ?><?php echo ($member_info->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->name->cellAttributes() ?>>
<span id="el_member_info_name">
<input type="text" data-table="member_info" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($member_info->name->getPlaceHolder()) ?>" value="<?php echo $member_info->name->EditValue ?>"<?php echo $member_info->name->editAttributes() ?>>
</span>
<?php echo $member_info->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->classification->Visible) { // classification ?>
	<div id="r_classification" class="form-group row">
		<label id="elh_member_info_classification" for="x_classification" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->classification->caption() ?><?php echo ($member_info->classification->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->classification->cellAttributes() ?>>
<span id="el_member_info_classification">
<input type="text" data-table="member_info" data-field="x_classification" name="x_classification" id="x_classification" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($member_info->classification->getPlaceHolder()) ?>" value="<?php echo $member_info->classification->EditValue ?>"<?php echo $member_info->classification->editAttributes() ?>>
</span>
<?php echo $member_info->classification->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_member_info_mobile" for="x_mobile" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->mobile->caption() ?><?php echo ($member_info->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->mobile->cellAttributes() ?>>
<span id="el_member_info_mobile">
<input type="text" data-table="member_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($member_info->mobile->getPlaceHolder()) ?>" value="<?php echo $member_info->mobile->EditValue ?>"<?php echo $member_info->mobile->editAttributes() ?>>
</span>
<?php echo $member_info->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_member_info__email" for="x__email" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->_email->caption() ?><?php echo ($member_info->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->_email->cellAttributes() ?>>
<span id="el_member_info__email">
<input type="text" data-table="member_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($member_info->_email->getPlaceHolder()) ?>" value="<?php echo $member_info->_email->EditValue ?>"<?php echo $member_info->_email->editAttributes() ?>>
</span>
<?php echo $member_info->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_member_info_address" for="x_address" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->address->caption() ?><?php echo ($member_info->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->address->cellAttributes() ?>>
<span id="el_member_info_address">
<textarea data-table="member_info" data-field="x_address" name="x_address" id="x_address" cols="35" rows="3" placeholder="<?php echo HtmlEncode($member_info->address->getPlaceHolder()) ?>"<?php echo $member_info->address->editAttributes() ?>><?php echo $member_info->address->EditValue ?></textarea>
</span>
<?php echo $member_info->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->blood_grp->Visible) { // blood_grp ?>
	<div id="r_blood_grp" class="form-group row">
		<label id="elh_member_info_blood_grp" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->blood_grp->caption() ?><?php echo ($member_info->blood_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->blood_grp->cellAttributes() ?>>
<span id="el_member_info_blood_grp">
<div id="tp_x_blood_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="member_info" data-field="x_blood_grp" data-value-separator="<?php echo $member_info->blood_grp->displayValueSeparatorAttribute() ?>" name="x_blood_grp[]" id="x_blood_grp[]" value="{value}"<?php echo $member_info->blood_grp->editAttributes() ?>></div>
<div id="dsl_x_blood_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $member_info->blood_grp->checkBoxListHtml(FALSE, "x_blood_grp[]") ?>
</div></div>
</span>
<?php echo $member_info->blood_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label id="elh_member_info_dob" for="x_dob" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->dob->caption() ?><?php echo ($member_info->dob->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->dob->cellAttributes() ?>>
<span id="el_member_info_dob">
<input type="text" data-table="member_info" data-field="x_dob" name="x_dob" id="x_dob" placeholder="<?php echo HtmlEncode($member_info->dob->getPlaceHolder()) ?>" value="<?php echo $member_info->dob->EditValue ?>"<?php echo $member_info->dob->editAttributes() ?>>
<?php if (!$member_info->dob->ReadOnly && !$member_info->dob->Disabled && !isset($member_info->dob->EditAttrs["readonly"]) && !isset($member_info->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmember_infoadd", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $member_info->dob->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->dom->Visible) { // dom ?>
	<div id="r_dom" class="form-group row">
		<label id="elh_member_info_dom" for="x_dom" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->dom->caption() ?><?php echo ($member_info->dom->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->dom->cellAttributes() ?>>
<span id="el_member_info_dom">
<input type="text" data-table="member_info" data-field="x_dom" name="x_dom" id="x_dom" placeholder="<?php echo HtmlEncode($member_info->dom->getPlaceHolder()) ?>" value="<?php echo $member_info->dom->EditValue ?>"<?php echo $member_info->dom->editAttributes() ?>>
<?php if (!$member_info->dom->ReadOnly && !$member_info->dom->Disabled && !isset($member_info->dom->EditAttrs["readonly"]) && !isset($member_info->dom->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmember_infoadd", "x_dom", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $member_info->dom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->join_date->Visible) { // join_date ?>
	<div id="r_join_date" class="form-group row">
		<label id="elh_member_info_join_date" for="x_join_date" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->join_date->caption() ?><?php echo ($member_info->join_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->join_date->cellAttributes() ?>>
<span id="el_member_info_join_date">
<input type="text" data-table="member_info" data-field="x_join_date" name="x_join_date" id="x_join_date" placeholder="<?php echo HtmlEncode($member_info->join_date->getPlaceHolder()) ?>" value="<?php echo $member_info->join_date->EditValue ?>"<?php echo $member_info->join_date->editAttributes() ?>>
<?php if (!$member_info->join_date->ReadOnly && !$member_info->join_date->Disabled && !isset($member_info->join_date->EditAttrs["readonly"]) && !isset($member_info->join_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmember_infoadd", "x_join_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $member_info->join_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->spouse_name->Visible) { // spouse_name ?>
	<div id="r_spouse_name" class="form-group row">
		<label id="elh_member_info_spouse_name" for="x_spouse_name" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->spouse_name->caption() ?><?php echo ($member_info->spouse_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->spouse_name->cellAttributes() ?>>
<span id="el_member_info_spouse_name">
<input type="text" data-table="member_info" data-field="x_spouse_name" name="x_spouse_name" id="x_spouse_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($member_info->spouse_name->getPlaceHolder()) ?>" value="<?php echo $member_info->spouse_name->EditValue ?>"<?php echo $member_info->spouse_name->editAttributes() ?>>
</span>
<?php echo $member_info->spouse_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->children_name->Visible) { // children_name ?>
	<div id="r_children_name" class="form-group row">
		<label id="elh_member_info_children_name" for="x_children_name" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->children_name->caption() ?><?php echo ($member_info->children_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->children_name->cellAttributes() ?>>
<span id="el_member_info_children_name">
<textarea data-table="member_info" data-field="x_children_name" name="x_children_name" id="x_children_name" cols="35" rows="3" placeholder="<?php echo HtmlEncode($member_info->children_name->getPlaceHolder()) ?>"<?php echo $member_info->children_name->editAttributes() ?>><?php echo $member_info->children_name->EditValue ?></textarea>
</span>
<?php echo $member_info->children_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_member_info_image" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->image->caption() ?><?php echo ($member_info->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->image->cellAttributes() ?>>
<span id="el_member_info_image">
<div id="fd_x_image">
<span title="<?php echo $member_info->image->title() ? $member_info->image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($member_info->image->ReadOnly || $member_info->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="member_info" data-field="x_image" name="x_image" id="x_image" multiple="multiple"<?php echo $member_info->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $member_info->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="252">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $member_info->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $member_info->image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_image" id= "fc_x_image" value="<?php echo $member_info->image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $member_info->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($member_info->remakrs->Visible) { // remakrs ?>
	<div id="r_remakrs" class="form-group row">
		<label id="elh_member_info_remakrs" for="x_remakrs" class="<?php echo $member_info_add->LeftColumnClass ?>"><?php echo $member_info->remakrs->caption() ?><?php echo ($member_info->remakrs->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $member_info_add->RightColumnClass ?>"><div<?php echo $member_info->remakrs->cellAttributes() ?>>
<span id="el_member_info_remakrs">
<input type="text" data-table="member_info" data-field="x_remakrs" name="x_remakrs" id="x_remakrs" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($member_info->remakrs->getPlaceHolder()) ?>" value="<?php echo $member_info->remakrs->EditValue ?>"<?php echo $member_info->remakrs->editAttributes() ?>>
</span>
<?php echo $member_info->remakrs->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$member_info_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $member_info_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $member_info_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$member_info_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$member_info_add->terminate();
?>