<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$member_info_list = new member_info_list();

// Run the page
$member_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$member_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$member_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmember_infolist = currentForm = new ew.Form("fmember_infolist", "list");
fmember_infolist.formKeyCountName = '<?php echo $member_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmember_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmember_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmember_infolist.lists["x_type"] = <?php echo $member_info_list->type->Lookup->toClientList() ?>;
fmember_infolist.lists["x_type"].options = <?php echo JsonEncode($member_info_list->type->lookupOptions()) ?>;
fmember_infolist.autoSuggests["x_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmember_infolist.lists["x_blood_grp[]"] = <?php echo $member_info_list->blood_grp->Lookup->toClientList() ?>;
fmember_infolist.lists["x_blood_grp[]"].options = <?php echo JsonEncode($member_info_list->blood_grp->options(FALSE, TRUE)) ?>;

// Form object for search
var fmember_infolistsrch = currentSearchForm = new ew.Form("fmember_infolistsrch");

// Validate function for search
fmember_infolistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmember_infolistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmember_infolistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmember_infolistsrch.lists["x_type"] = <?php echo $member_info_list->type->Lookup->toClientList() ?>;
fmember_infolistsrch.lists["x_type"].options = <?php echo JsonEncode($member_info_list->type->lookupOptions()) ?>;
fmember_infolistsrch.autoSuggests["x_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fmember_infolistsrch.filterList = <?php echo $member_info_list->getFilterList() ?>;

// Init search panel as collapsed
fmember_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$member_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($member_info_list->TotalRecs > 0 && $member_info_list->ExportOptions->visible()) { ?>
<?php $member_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($member_info_list->ImportOptions->visible()) { ?>
<?php $member_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($member_info_list->SearchOptions->visible()) { ?>
<?php $member_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($member_info_list->FilterOptions->visible()) { ?>
<?php $member_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$member_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$member_info->isExport() && !$member_info->CurrentAction) { ?>
<form name="fmember_infolistsrch" id="fmember_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($member_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmember_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="member_info">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$member_info_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$member_info->RowType = ROWTYPE_SEARCH;

// Render row
$member_info->resetAttributes();
$member_info_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($member_info->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $member_info->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$member_info->type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$member_info->type->EditAttrs["onchange"] = "";
?>
<span id="as_x_type" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_type" id="sv_x_type" value="<?php echo RemoveHtml($member_info->type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($member_info->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($member_info->type->getPlaceHolder()) ?>"<?php echo $member_info->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="member_info" data-field="x_type" data-value-separator="<?php echo $member_info->type->displayValueSeparatorAttribute() ?>" name="x_type" id="x_type" value="<?php echo HtmlEncode($member_info->type->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmember_infolistsrch.createAutoSuggest({"id":"x_type","forceSelect":false});
</script>
<?php echo $member_info->type->Lookup->getParamTag("p_x_type") ?>
</span>
	</div>
<?php } ?>
<?php if ($member_info->name->Visible) { // name ?>
	<div id="xsc_name" class="ew-cell form-group">
		<label for="x_name" class="ew-search-caption ew-label"><?php echo $member_info->name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="member_info" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($member_info->name->getPlaceHolder()) ?>" value="<?php echo $member_info->name->EditValue ?>"<?php echo $member_info->name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($member_info->mobile->Visible) { // mobile ?>
	<div id="xsc_mobile" class="ew-cell form-group">
		<label for="x_mobile" class="ew-search-caption ew-label"><?php echo $member_info->mobile->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile" id="z_mobile" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="member_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($member_info->mobile->getPlaceHolder()) ?>" value="<?php echo $member_info->mobile->EditValue ?>"<?php echo $member_info->mobile->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($member_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($member_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $member_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($member_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($member_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($member_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($member_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $member_info_list->showPageHeader(); ?>
<?php
$member_info_list->showMessage();
?>
<?php if ($member_info_list->TotalRecs > 0 || $member_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($member_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> member_info">
<?php if (!$member_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$member_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($member_info_list->Pager)) $member_info_list->Pager = new PrevNextPager($member_info_list->StartRec, $member_info_list->DisplayRecs, $member_info_list->TotalRecs, $member_info_list->AutoHidePager) ?>
<?php if ($member_info_list->Pager->RecordCount > 0 && $member_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($member_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $member_info_list->pageUrl() ?>start=<?php echo $member_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($member_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $member_info_list->pageUrl() ?>start=<?php echo $member_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $member_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($member_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $member_info_list->pageUrl() ?>start=<?php echo $member_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($member_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $member_info_list->pageUrl() ?>start=<?php echo $member_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $member_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($member_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $member_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $member_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $member_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($member_info_list->TotalRecs > 0 && (!$member_info_list->AutoHidePageSizeSelector || $member_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="member_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($member_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($member_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($member_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($member_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($member_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($member_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $member_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmember_infolist" id="fmember_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($member_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $member_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="member_info">
<div id="gmp_member_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($member_info_list->TotalRecs > 0 || $member_info->isGridEdit()) { ?>
<table id="tbl_member_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$member_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$member_info_list->renderListOptions();

// Render list options (header, left)
$member_info_list->ListOptions->render("header", "left");
?>
<?php if ($member_info->id->Visible) { // id ?>
	<?php if ($member_info->sortUrl($member_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $member_info->id->headerCellClass() ?>"><div id="elh_member_info_id" class="member_info_id"><div class="ew-table-header-caption"><?php echo $member_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $member_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->id) ?>',2);"><div id="elh_member_info_id" class="member_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($member_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->type->Visible) { // type ?>
	<?php if ($member_info->sortUrl($member_info->type) == "") { ?>
		<th data-name="type" class="<?php echo $member_info->type->headerCellClass() ?>"><div id="elh_member_info_type" class="member_info_type"><div class="ew-table-header-caption"><?php echo $member_info->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $member_info->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->type) ?>',2);"><div id="elh_member_info_type" class="member_info_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->name->Visible) { // name ?>
	<?php if ($member_info->sortUrl($member_info->name) == "") { ?>
		<th data-name="name" class="<?php echo $member_info->name->headerCellClass() ?>"><div id="elh_member_info_name" class="member_info_name"><div class="ew-table-header-caption"><?php echo $member_info->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $member_info->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->name) ?>',2);"><div id="elh_member_info_name" class="member_info_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->classification->Visible) { // classification ?>
	<?php if ($member_info->sortUrl($member_info->classification) == "") { ?>
		<th data-name="classification" class="<?php echo $member_info->classification->headerCellClass() ?>"><div id="elh_member_info_classification" class="member_info_classification"><div class="ew-table-header-caption"><?php echo $member_info->classification->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="classification" class="<?php echo $member_info->classification->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->classification) ?>',2);"><div id="elh_member_info_classification" class="member_info_classification">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->classification->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->classification->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->classification->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->mobile->Visible) { // mobile ?>
	<?php if ($member_info->sortUrl($member_info->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $member_info->mobile->headerCellClass() ?>"><div id="elh_member_info_mobile" class="member_info_mobile"><div class="ew-table-header-caption"><?php echo $member_info->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $member_info->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->mobile) ?>',2);"><div id="elh_member_info_mobile" class="member_info_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->_email->Visible) { // email ?>
	<?php if ($member_info->sortUrl($member_info->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $member_info->_email->headerCellClass() ?>"><div id="elh_member_info__email" class="member_info__email"><div class="ew-table-header-caption"><?php echo $member_info->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $member_info->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->_email) ?>',2);"><div id="elh_member_info__email" class="member_info__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->address->Visible) { // address ?>
	<?php if ($member_info->sortUrl($member_info->address) == "") { ?>
		<th data-name="address" class="<?php echo $member_info->address->headerCellClass() ?>"><div id="elh_member_info_address" class="member_info_address"><div class="ew-table-header-caption"><?php echo $member_info->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $member_info->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->address) ?>',2);"><div id="elh_member_info_address" class="member_info_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->blood_grp->Visible) { // blood_grp ?>
	<?php if ($member_info->sortUrl($member_info->blood_grp) == "") { ?>
		<th data-name="blood_grp" class="<?php echo $member_info->blood_grp->headerCellClass() ?>"><div id="elh_member_info_blood_grp" class="member_info_blood_grp"><div class="ew-table-header-caption"><?php echo $member_info->blood_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="blood_grp" class="<?php echo $member_info->blood_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->blood_grp) ?>',2);"><div id="elh_member_info_blood_grp" class="member_info_blood_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->blood_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($member_info->blood_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->blood_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->dob->Visible) { // dob ?>
	<?php if ($member_info->sortUrl($member_info->dob) == "") { ?>
		<th data-name="dob" class="<?php echo $member_info->dob->headerCellClass() ?>"><div id="elh_member_info_dob" class="member_info_dob"><div class="ew-table-header-caption"><?php echo $member_info->dob->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dob" class="<?php echo $member_info->dob->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->dob) ?>',2);"><div id="elh_member_info_dob" class="member_info_dob">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->dob->caption() ?></span><span class="ew-table-header-sort"><?php if ($member_info->dob->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->dob->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->dom->Visible) { // dom ?>
	<?php if ($member_info->sortUrl($member_info->dom) == "") { ?>
		<th data-name="dom" class="<?php echo $member_info->dom->headerCellClass() ?>"><div id="elh_member_info_dom" class="member_info_dom"><div class="ew-table-header-caption"><?php echo $member_info->dom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dom" class="<?php echo $member_info->dom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->dom) ?>',2);"><div id="elh_member_info_dom" class="member_info_dom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->dom->caption() ?></span><span class="ew-table-header-sort"><?php if ($member_info->dom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->dom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->join_date->Visible) { // join_date ?>
	<?php if ($member_info->sortUrl($member_info->join_date) == "") { ?>
		<th data-name="join_date" class="<?php echo $member_info->join_date->headerCellClass() ?>"><div id="elh_member_info_join_date" class="member_info_join_date"><div class="ew-table-header-caption"><?php echo $member_info->join_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="join_date" class="<?php echo $member_info->join_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->join_date) ?>',2);"><div id="elh_member_info_join_date" class="member_info_join_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->join_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($member_info->join_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->join_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->spouse_name->Visible) { // spouse_name ?>
	<?php if ($member_info->sortUrl($member_info->spouse_name) == "") { ?>
		<th data-name="spouse_name" class="<?php echo $member_info->spouse_name->headerCellClass() ?>"><div id="elh_member_info_spouse_name" class="member_info_spouse_name"><div class="ew-table-header-caption"><?php echo $member_info->spouse_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="spouse_name" class="<?php echo $member_info->spouse_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->spouse_name) ?>',2);"><div id="elh_member_info_spouse_name" class="member_info_spouse_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->spouse_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->spouse_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->spouse_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->children_name->Visible) { // children_name ?>
	<?php if ($member_info->sortUrl($member_info->children_name) == "") { ?>
		<th data-name="children_name" class="<?php echo $member_info->children_name->headerCellClass() ?>"><div id="elh_member_info_children_name" class="member_info_children_name"><div class="ew-table-header-caption"><?php echo $member_info->children_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="children_name" class="<?php echo $member_info->children_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->children_name) ?>',2);"><div id="elh_member_info_children_name" class="member_info_children_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->children_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->children_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->children_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->image->Visible) { // image ?>
	<?php if ($member_info->sortUrl($member_info->image) == "") { ?>
		<th data-name="image" class="<?php echo $member_info->image->headerCellClass() ?>"><div id="elh_member_info_image" class="member_info_image"><div class="ew-table-header-caption"><?php echo $member_info->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $member_info->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->image) ?>',2);"><div id="elh_member_info_image" class="member_info_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->remakrs->Visible) { // remakrs ?>
	<?php if ($member_info->sortUrl($member_info->remakrs) == "") { ?>
		<th data-name="remakrs" class="<?php echo $member_info->remakrs->headerCellClass() ?>"><div id="elh_member_info_remakrs" class="member_info_remakrs"><div class="ew-table-header-caption"><?php echo $member_info->remakrs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remakrs" class="<?php echo $member_info->remakrs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->remakrs) ?>',2);"><div id="elh_member_info_remakrs" class="member_info_remakrs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->remakrs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($member_info->remakrs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->remakrs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->operator->Visible) { // operator ?>
	<?php if ($member_info->sortUrl($member_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $member_info->operator->headerCellClass() ?>"><div id="elh_member_info_operator" class="member_info_operator"><div class="ew-table-header-caption"><?php echo $member_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $member_info->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->operator) ?>',2);"><div id="elh_member_info_operator" class="member_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($member_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($member_info->datetime->Visible) { // datetime ?>
	<?php if ($member_info->sortUrl($member_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $member_info->datetime->headerCellClass() ?>"><div id="elh_member_info_datetime" class="member_info_datetime"><div class="ew-table-header-caption"><?php echo $member_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $member_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $member_info->SortUrl($member_info->datetime) ?>',2);"><div id="elh_member_info_datetime" class="member_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $member_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($member_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($member_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$member_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($member_info->ExportAll && $member_info->isExport()) {
	$member_info_list->StopRec = $member_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($member_info_list->TotalRecs > $member_info_list->StartRec + $member_info_list->DisplayRecs - 1)
		$member_info_list->StopRec = $member_info_list->StartRec + $member_info_list->DisplayRecs - 1;
	else
		$member_info_list->StopRec = $member_info_list->TotalRecs;
}
$member_info_list->RecCnt = $member_info_list->StartRec - 1;
if ($member_info_list->Recordset && !$member_info_list->Recordset->EOF) {
	$member_info_list->Recordset->moveFirst();
	$selectLimit = $member_info_list->UseSelectLimit;
	if (!$selectLimit && $member_info_list->StartRec > 1)
		$member_info_list->Recordset->move($member_info_list->StartRec - 1);
} elseif (!$member_info->AllowAddDeleteRow && $member_info_list->StopRec == 0) {
	$member_info_list->StopRec = $member_info->GridAddRowCount;
}

// Initialize aggregate
$member_info->RowType = ROWTYPE_AGGREGATEINIT;
$member_info->resetAttributes();
$member_info_list->renderRow();
while ($member_info_list->RecCnt < $member_info_list->StopRec) {
	$member_info_list->RecCnt++;
	if ($member_info_list->RecCnt >= $member_info_list->StartRec) {
		$member_info_list->RowCnt++;

		// Set up key count
		$member_info_list->KeyCount = $member_info_list->RowIndex;

		// Init row class and style
		$member_info->resetAttributes();
		$member_info->CssClass = "";
		if ($member_info->isGridAdd()) {
		} else {
			$member_info_list->loadRowValues($member_info_list->Recordset); // Load row values
		}
		$member_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$member_info->RowAttrs = array_merge($member_info->RowAttrs, array('data-rowindex'=>$member_info_list->RowCnt, 'id'=>'r' . $member_info_list->RowCnt . '_member_info', 'data-rowtype'=>$member_info->RowType));

		// Render row
		$member_info_list->renderRow();

		// Render list options
		$member_info_list->renderListOptions();
?>
	<tr<?php echo $member_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$member_info_list->ListOptions->render("body", "left", $member_info_list->RowCnt);
?>
	<?php if ($member_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $member_info->id->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_id" class="member_info_id">
<span<?php echo $member_info->id->viewAttributes() ?>>
<?php echo $member_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->type->Visible) { // type ?>
		<td data-name="type"<?php echo $member_info->type->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_type" class="member_info_type">
<span<?php echo $member_info->type->viewAttributes() ?>>
<?php echo $member_info->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->name->Visible) { // name ?>
		<td data-name="name"<?php echo $member_info->name->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_name" class="member_info_name">
<span<?php echo $member_info->name->viewAttributes() ?>>
<?php echo $member_info->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->classification->Visible) { // classification ?>
		<td data-name="classification"<?php echo $member_info->classification->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_classification" class="member_info_classification">
<span<?php echo $member_info->classification->viewAttributes() ?>>
<?php echo $member_info->classification->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $member_info->mobile->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_mobile" class="member_info_mobile">
<span<?php echo $member_info->mobile->viewAttributes() ?>>
<?php echo $member_info->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $member_info->_email->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info__email" class="member_info__email">
<span<?php echo $member_info->_email->viewAttributes() ?>>
<?php echo $member_info->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->address->Visible) { // address ?>
		<td data-name="address"<?php echo $member_info->address->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_address" class="member_info_address">
<span<?php echo $member_info->address->viewAttributes() ?>>
<?php echo $member_info->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->blood_grp->Visible) { // blood_grp ?>
		<td data-name="blood_grp"<?php echo $member_info->blood_grp->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_blood_grp" class="member_info_blood_grp">
<span<?php echo $member_info->blood_grp->viewAttributes() ?>>
<?php echo $member_info->blood_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->dob->Visible) { // dob ?>
		<td data-name="dob"<?php echo $member_info->dob->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_dob" class="member_info_dob">
<span<?php echo $member_info->dob->viewAttributes() ?>>
<?php echo $member_info->dob->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->dom->Visible) { // dom ?>
		<td data-name="dom"<?php echo $member_info->dom->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_dom" class="member_info_dom">
<span<?php echo $member_info->dom->viewAttributes() ?>>
<?php echo $member_info->dom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->join_date->Visible) { // join_date ?>
		<td data-name="join_date"<?php echo $member_info->join_date->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_join_date" class="member_info_join_date">
<span<?php echo $member_info->join_date->viewAttributes() ?>>
<?php echo $member_info->join_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->spouse_name->Visible) { // spouse_name ?>
		<td data-name="spouse_name"<?php echo $member_info->spouse_name->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_spouse_name" class="member_info_spouse_name">
<span<?php echo $member_info->spouse_name->viewAttributes() ?>>
<?php echo $member_info->spouse_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->children_name->Visible) { // children_name ?>
		<td data-name="children_name"<?php echo $member_info->children_name->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_children_name" class="member_info_children_name">
<span<?php echo $member_info->children_name->viewAttributes() ?>>
<?php echo $member_info->children_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->image->Visible) { // image ?>
		<td data-name="image"<?php echo $member_info->image->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_image" class="member_info_image">
<span>
<?php echo GetFileViewTag($member_info->image, $member_info->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->remakrs->Visible) { // remakrs ?>
		<td data-name="remakrs"<?php echo $member_info->remakrs->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_remakrs" class="member_info_remakrs">
<span<?php echo $member_info->remakrs->viewAttributes() ?>>
<?php echo $member_info->remakrs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $member_info->operator->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_operator" class="member_info_operator">
<span<?php echo $member_info->operator->viewAttributes() ?>>
<?php echo $member_info->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($member_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $member_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $member_info_list->RowCnt ?>_member_info_datetime" class="member_info_datetime">
<span<?php echo $member_info->datetime->viewAttributes() ?>>
<?php echo $member_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$member_info_list->ListOptions->render("body", "right", $member_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$member_info->isGridAdd())
		$member_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$member_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($member_info_list->Recordset)
	$member_info_list->Recordset->Close();
?>
<?php if (!$member_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$member_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($member_info_list->Pager)) $member_info_list->Pager = new PrevNextPager($member_info_list->StartRec, $member_info_list->DisplayRecs, $member_info_list->TotalRecs, $member_info_list->AutoHidePager) ?>
<?php if ($member_info_list->Pager->RecordCount > 0 && $member_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($member_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $member_info_list->pageUrl() ?>start=<?php echo $member_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($member_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $member_info_list->pageUrl() ?>start=<?php echo $member_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $member_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($member_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $member_info_list->pageUrl() ?>start=<?php echo $member_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($member_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $member_info_list->pageUrl() ?>start=<?php echo $member_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $member_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($member_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $member_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $member_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $member_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($member_info_list->TotalRecs > 0 && (!$member_info_list->AutoHidePageSizeSelector || $member_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="member_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($member_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($member_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($member_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($member_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($member_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($member_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $member_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($member_info_list->TotalRecs == 0 && !$member_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $member_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$member_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$member_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$member_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_member_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$member_info_list->terminate();
?>