<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$member_info_search = new member_info_search();

// Run the page
$member_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$member_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($member_info_search->IsModal) { ?>
var fmember_infosearch = currentAdvancedSearchForm = new ew.Form("fmember_infosearch", "search");
<?php } else { ?>
var fmember_infosearch = currentForm = new ew.Form("fmember_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
fmember_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmember_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmember_infosearch.lists["x_type"] = <?php echo $member_info_search->type->Lookup->toClientList() ?>;
fmember_infosearch.lists["x_type"].options = <?php echo JsonEncode($member_info_search->type->lookupOptions()) ?>;
fmember_infosearch.autoSuggests["x_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmember_infosearch.lists["x_blood_grp[]"] = <?php echo $member_info_search->blood_grp->Lookup->toClientList() ?>;
fmember_infosearch.lists["x_blood_grp[]"].options = <?php echo JsonEncode($member_info_search->blood_grp->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fmember_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($member_info->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dob");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($member_info->dob->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dom");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($member_info->dom->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_join_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($member_info->join_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($member_info->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($member_info->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $member_info_search->showPageHeader(); ?>
<?php
$member_info_search->showMessage();
?>
<form name="fmember_infosearch" id="fmember_infosearch" class="<?php echo $member_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($member_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $member_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="member_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$member_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($member_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_id"><?php echo $member_info->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->id->cellAttributes() ?>>
			<span id="el_member_info_id">
<input type="text" data-table="member_info" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($member_info->id->getPlaceHolder()) ?>" value="<?php echo $member_info->id->EditValue ?>"<?php echo $member_info->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_type"><?php echo $member_info->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_type" id="z_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->type->cellAttributes() ?>>
			<span id="el_member_info_type">
<?php
$wrkonchange = "" . trim(@$member_info->type->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$member_info->type->EditAttrs["onchange"] = "";
?>
<span id="as_x_type" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_type" id="sv_x_type" value="<?php echo RemoveHtml($member_info->type->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($member_info->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($member_info->type->getPlaceHolder()) ?>"<?php echo $member_info->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="member_info" data-field="x_type" data-value-separator="<?php echo $member_info->type->displayValueSeparatorAttribute() ?>" name="x_type" id="x_type" value="<?php echo HtmlEncode($member_info->type->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fmember_infosearch.createAutoSuggest({"id":"x_type","forceSelect":false});
</script>
<?php echo $member_info->type->Lookup->getParamTag("p_x_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_name"><?php echo $member_info->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->name->cellAttributes() ?>>
			<span id="el_member_info_name">
<input type="text" data-table="member_info" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($member_info->name->getPlaceHolder()) ?>" value="<?php echo $member_info->name->EditValue ?>"<?php echo $member_info->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->classification->Visible) { // classification ?>
	<div id="r_classification" class="form-group row">
		<label for="x_classification" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_classification"><?php echo $member_info->classification->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_classification" id="z_classification" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->classification->cellAttributes() ?>>
			<span id="el_member_info_classification">
<input type="text" data-table="member_info" data-field="x_classification" name="x_classification" id="x_classification" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($member_info->classification->getPlaceHolder()) ?>" value="<?php echo $member_info->classification->EditValue ?>"<?php echo $member_info->classification->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_mobile"><?php echo $member_info->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile" id="z_mobile" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->mobile->cellAttributes() ?>>
			<span id="el_member_info_mobile">
<input type="text" data-table="member_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($member_info->mobile->getPlaceHolder()) ?>" value="<?php echo $member_info->mobile->EditValue ?>"<?php echo $member_info->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info__email"><?php echo $member_info->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->_email->cellAttributes() ?>>
			<span id="el_member_info__email">
<input type="text" data-table="member_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($member_info->_email->getPlaceHolder()) ?>" value="<?php echo $member_info->_email->EditValue ?>"<?php echo $member_info->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label for="x_address" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_address"><?php echo $member_info->address->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_address" id="z_address" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->address->cellAttributes() ?>>
			<span id="el_member_info_address">
<input type="text" data-table="member_info" data-field="x_address" name="x_address" id="x_address" maxlength="252" placeholder="<?php echo HtmlEncode($member_info->address->getPlaceHolder()) ?>" value="<?php echo $member_info->address->EditValue ?>"<?php echo $member_info->address->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->blood_grp->Visible) { // blood_grp ?>
	<div id="r_blood_grp" class="form-group row">
		<label class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_blood_grp"><?php echo $member_info->blood_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_blood_grp" id="z_blood_grp" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->blood_grp->cellAttributes() ?>>
			<span id="el_member_info_blood_grp">
<div id="tp_x_blood_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="member_info" data-field="x_blood_grp" data-value-separator="<?php echo $member_info->blood_grp->displayValueSeparatorAttribute() ?>" name="x_blood_grp[]" id="x_blood_grp[]" value="{value}"<?php echo $member_info->blood_grp->editAttributes() ?>></div>
<div id="dsl_x_blood_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $member_info->blood_grp->checkBoxListHtml(FALSE, "x_blood_grp[]") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label for="x_dob" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_dob"><?php echo $member_info->dob->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dob" id="z_dob" value="="></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->dob->cellAttributes() ?>>
			<span id="el_member_info_dob">
<input type="text" data-table="member_info" data-field="x_dob" name="x_dob" id="x_dob" placeholder="<?php echo HtmlEncode($member_info->dob->getPlaceHolder()) ?>" value="<?php echo $member_info->dob->EditValue ?>"<?php echo $member_info->dob->editAttributes() ?>>
<?php if (!$member_info->dob->ReadOnly && !$member_info->dob->Disabled && !isset($member_info->dob->EditAttrs["readonly"]) && !isset($member_info->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmember_infosearch", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->dom->Visible) { // dom ?>
	<div id="r_dom" class="form-group row">
		<label for="x_dom" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_dom"><?php echo $member_info->dom->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dom" id="z_dom" value="="></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->dom->cellAttributes() ?>>
			<span id="el_member_info_dom">
<input type="text" data-table="member_info" data-field="x_dom" name="x_dom" id="x_dom" placeholder="<?php echo HtmlEncode($member_info->dom->getPlaceHolder()) ?>" value="<?php echo $member_info->dom->EditValue ?>"<?php echo $member_info->dom->editAttributes() ?>>
<?php if (!$member_info->dom->ReadOnly && !$member_info->dom->Disabled && !isset($member_info->dom->EditAttrs["readonly"]) && !isset($member_info->dom->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmember_infosearch", "x_dom", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->join_date->Visible) { // join_date ?>
	<div id="r_join_date" class="form-group row">
		<label for="x_join_date" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_join_date"><?php echo $member_info->join_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_join_date" id="z_join_date" value="="></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->join_date->cellAttributes() ?>>
			<span id="el_member_info_join_date">
<input type="text" data-table="member_info" data-field="x_join_date" name="x_join_date" id="x_join_date" placeholder="<?php echo HtmlEncode($member_info->join_date->getPlaceHolder()) ?>" value="<?php echo $member_info->join_date->EditValue ?>"<?php echo $member_info->join_date->editAttributes() ?>>
<?php if (!$member_info->join_date->ReadOnly && !$member_info->join_date->Disabled && !isset($member_info->join_date->EditAttrs["readonly"]) && !isset($member_info->join_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmember_infosearch", "x_join_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->spouse_name->Visible) { // spouse_name ?>
	<div id="r_spouse_name" class="form-group row">
		<label for="x_spouse_name" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_spouse_name"><?php echo $member_info->spouse_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_spouse_name" id="z_spouse_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->spouse_name->cellAttributes() ?>>
			<span id="el_member_info_spouse_name">
<input type="text" data-table="member_info" data-field="x_spouse_name" name="x_spouse_name" id="x_spouse_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($member_info->spouse_name->getPlaceHolder()) ?>" value="<?php echo $member_info->spouse_name->EditValue ?>"<?php echo $member_info->spouse_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->children_name->Visible) { // children_name ?>
	<div id="r_children_name" class="form-group row">
		<label for="x_children_name" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_children_name"><?php echo $member_info->children_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_children_name" id="z_children_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->children_name->cellAttributes() ?>>
			<span id="el_member_info_children_name">
<input type="text" data-table="member_info" data-field="x_children_name" name="x_children_name" id="x_children_name" maxlength="192" placeholder="<?php echo HtmlEncode($member_info->children_name->getPlaceHolder()) ?>" value="<?php echo $member_info->children_name->EditValue ?>"<?php echo $member_info->children_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_image"><?php echo $member_info->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->image->cellAttributes() ?>>
			<span id="el_member_info_image">
<input type="text" data-table="member_info" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="252" placeholder="<?php echo HtmlEncode($member_info->image->getPlaceHolder()) ?>" value="<?php echo $member_info->image->EditValue ?>"<?php echo $member_info->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->remakrs->Visible) { // remakrs ?>
	<div id="r_remakrs" class="form-group row">
		<label for="x_remakrs" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_remakrs"><?php echo $member_info->remakrs->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remakrs" id="z_remakrs" value="LIKE"></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->remakrs->cellAttributes() ?>>
			<span id="el_member_info_remakrs">
<input type="text" data-table="member_info" data-field="x_remakrs" name="x_remakrs" id="x_remakrs" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($member_info->remakrs->getPlaceHolder()) ?>" value="<?php echo $member_info->remakrs->EditValue ?>"<?php echo $member_info->remakrs->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_operator"><?php echo $member_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->operator->cellAttributes() ?>>
			<span id="el_member_info_operator">
<input type="text" data-table="member_info" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($member_info->operator->getPlaceHolder()) ?>" value="<?php echo $member_info->operator->EditValue ?>"<?php echo $member_info->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($member_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $member_info_search->LeftColumnClass ?>"><span id="elh_member_info_datetime"><?php echo $member_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $member_info_search->RightColumnClass ?>"><div<?php echo $member_info->datetime->cellAttributes() ?>>
			<span id="el_member_info_datetime">
<input type="text" data-table="member_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($member_info->datetime->getPlaceHolder()) ?>" value="<?php echo $member_info->datetime->EditValue ?>"<?php echo $member_info->datetime->editAttributes() ?>>
<?php if (!$member_info->datetime->ReadOnly && !$member_info->datetime->Disabled && !isset($member_info->datetime->EditAttrs["readonly"]) && !isset($member_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmember_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$member_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $member_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$member_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$member_info_search->terminate();
?>