<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$member_info_view = new member_info_view();

// Run the page
$member_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$member_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$member_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmember_infoview = currentForm = new ew.Form("fmember_infoview", "view");

// Form_CustomValidate event
fmember_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmember_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmember_infoview.lists["x_type"] = <?php echo $member_info_view->type->Lookup->toClientList() ?>;
fmember_infoview.lists["x_type"].options = <?php echo JsonEncode($member_info_view->type->lookupOptions()) ?>;
fmember_infoview.autoSuggests["x_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fmember_infoview.lists["x_blood_grp[]"] = <?php echo $member_info_view->blood_grp->Lookup->toClientList() ?>;
fmember_infoview.lists["x_blood_grp[]"].options = <?php echo JsonEncode($member_info_view->blood_grp->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$member_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $member_info_view->ExportOptions->render("body") ?>
<?php $member_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $member_info_view->showPageHeader(); ?>
<?php
$member_info_view->showMessage();
?>
<form name="fmember_infoview" id="fmember_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($member_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $member_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="member_info">
<input type="hidden" name="modal" value="<?php echo (int)$member_info_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($member_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_id"><?php echo $member_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $member_info->id->cellAttributes() ?>>
<span id="el_member_info_id">
<span<?php echo $member_info->id->viewAttributes() ?>>
<?php echo $member_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_type"><?php echo $member_info->type->caption() ?></span></td>
		<td data-name="type"<?php echo $member_info->type->cellAttributes() ?>>
<span id="el_member_info_type">
<span<?php echo $member_info->type->viewAttributes() ?>>
<?php echo $member_info->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_name"><?php echo $member_info->name->caption() ?></span></td>
		<td data-name="name"<?php echo $member_info->name->cellAttributes() ?>>
<span id="el_member_info_name">
<span<?php echo $member_info->name->viewAttributes() ?>>
<?php echo $member_info->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->classification->Visible) { // classification ?>
	<tr id="r_classification">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_classification"><?php echo $member_info->classification->caption() ?></span></td>
		<td data-name="classification"<?php echo $member_info->classification->cellAttributes() ?>>
<span id="el_member_info_classification">
<span<?php echo $member_info->classification->viewAttributes() ?>>
<?php echo $member_info->classification->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_mobile"><?php echo $member_info->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $member_info->mobile->cellAttributes() ?>>
<span id="el_member_info_mobile">
<span<?php echo $member_info->mobile->viewAttributes() ?>>
<?php echo $member_info->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->_email->Visible) { // email ?>
	<tr id="r__email">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info__email"><?php echo $member_info->_email->caption() ?></span></td>
		<td data-name="_email"<?php echo $member_info->_email->cellAttributes() ?>>
<span id="el_member_info__email">
<span<?php echo $member_info->_email->viewAttributes() ?>>
<?php echo $member_info->_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->address->Visible) { // address ?>
	<tr id="r_address">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_address"><?php echo $member_info->address->caption() ?></span></td>
		<td data-name="address"<?php echo $member_info->address->cellAttributes() ?>>
<span id="el_member_info_address">
<span<?php echo $member_info->address->viewAttributes() ?>>
<?php echo $member_info->address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->blood_grp->Visible) { // blood_grp ?>
	<tr id="r_blood_grp">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_blood_grp"><?php echo $member_info->blood_grp->caption() ?></span></td>
		<td data-name="blood_grp"<?php echo $member_info->blood_grp->cellAttributes() ?>>
<span id="el_member_info_blood_grp">
<span<?php echo $member_info->blood_grp->viewAttributes() ?>>
<?php echo $member_info->blood_grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->dob->Visible) { // dob ?>
	<tr id="r_dob">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_dob"><?php echo $member_info->dob->caption() ?></span></td>
		<td data-name="dob"<?php echo $member_info->dob->cellAttributes() ?>>
<span id="el_member_info_dob">
<span<?php echo $member_info->dob->viewAttributes() ?>>
<?php echo $member_info->dob->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->dom->Visible) { // dom ?>
	<tr id="r_dom">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_dom"><?php echo $member_info->dom->caption() ?></span></td>
		<td data-name="dom"<?php echo $member_info->dom->cellAttributes() ?>>
<span id="el_member_info_dom">
<span<?php echo $member_info->dom->viewAttributes() ?>>
<?php echo $member_info->dom->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->join_date->Visible) { // join_date ?>
	<tr id="r_join_date">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_join_date"><?php echo $member_info->join_date->caption() ?></span></td>
		<td data-name="join_date"<?php echo $member_info->join_date->cellAttributes() ?>>
<span id="el_member_info_join_date">
<span<?php echo $member_info->join_date->viewAttributes() ?>>
<?php echo $member_info->join_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->spouse_name->Visible) { // spouse_name ?>
	<tr id="r_spouse_name">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_spouse_name"><?php echo $member_info->spouse_name->caption() ?></span></td>
		<td data-name="spouse_name"<?php echo $member_info->spouse_name->cellAttributes() ?>>
<span id="el_member_info_spouse_name">
<span<?php echo $member_info->spouse_name->viewAttributes() ?>>
<?php echo $member_info->spouse_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->children_name->Visible) { // children_name ?>
	<tr id="r_children_name">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_children_name"><?php echo $member_info->children_name->caption() ?></span></td>
		<td data-name="children_name"<?php echo $member_info->children_name->cellAttributes() ?>>
<span id="el_member_info_children_name">
<span<?php echo $member_info->children_name->viewAttributes() ?>>
<?php echo $member_info->children_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_image"><?php echo $member_info->image->caption() ?></span></td>
		<td data-name="image"<?php echo $member_info->image->cellAttributes() ?>>
<span id="el_member_info_image">
<span>
<?php echo GetFileViewTag($member_info->image, $member_info->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->remakrs->Visible) { // remakrs ?>
	<tr id="r_remakrs">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_remakrs"><?php echo $member_info->remakrs->caption() ?></span></td>
		<td data-name="remakrs"<?php echo $member_info->remakrs->cellAttributes() ?>>
<span id="el_member_info_remakrs">
<span<?php echo $member_info->remakrs->viewAttributes() ?>>
<?php echo $member_info->remakrs->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_operator"><?php echo $member_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $member_info->operator->cellAttributes() ?>>
<span id="el_member_info_operator">
<span<?php echo $member_info->operator->viewAttributes() ?>>
<?php echo $member_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($member_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $member_info_view->TableLeftColumnClass ?>"><span id="elh_member_info_datetime"><?php echo $member_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $member_info->datetime->cellAttributes() ?>>
<span id="el_member_info_datetime">
<span<?php echo $member_info->datetime->viewAttributes() ?>>
<?php echo $member_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$member_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$member_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$member_info_view->terminate();
?>