<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$menus_edit = new menus_edit();

// Run the page
$menus_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$menus_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fmenusedit = currentForm = new ew.Form("fmenusedit", "edit");

// Validate form
fmenusedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($menus_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->id->caption(), $menus->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->image->Required) { ?>
			elm = this.getElements("x" + infix + "_image");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->image->caption(), $menus->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->show_title->Required) { ?>
			elm = this.getElements("x" + infix + "_show_title");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->show_title->caption(), $menus->show_title->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->page_title->Required) { ?>
			elm = this.getElements("x" + infix + "_page_title");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->page_title->caption(), $menus->page_title->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->page_url->Required) { ?>
			elm = this.getElements("x" + infix + "_page_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->page_url->caption(), $menus->page_url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->target->Required) { ?>
			elm = this.getElements("x" + infix + "_target");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->target->caption(), $menus->target->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->parent_id->Required) { ?>
			elm = this.getElements("x" + infix + "_parent_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->parent_id->caption(), $menus->parent_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->show_in_main_menu->Required) { ?>
			elm = this.getElements("x" + infix + "_show_in_main_menu");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->show_in_main_menu->caption(), $menus->show_in_main_menu->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->status->caption(), $menus->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->order_by->Required) { ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->order_by->caption(), $menus->order_by->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($menus->order_by->errorMessage()) ?>");
		<?php if ($menus_edit->mega_menu->Required) { ?>
			elm = this.getElements("x" + infix + "_mega_menu");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->mega_menu->caption(), $menus->mega_menu->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->bgcolor->Required) { ?>
			elm = this.getElements("x" + infix + "_bgcolor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->bgcolor->caption(), $menus->bgcolor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->submenu->Required) { ?>
			elm = this.getElements("x" + infix + "_submenu");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->submenu->caption(), $menus->submenu->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->submenu_code->Required) { ?>
			elm = this.getElements("x" + infix + "_submenu_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->submenu_code->caption(), $menus->submenu_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->footer_group->Required) { ?>
			elm = this.getElements("x" + infix + "_footer_group");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->footer_group->caption(), $menus->footer_group->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->operator->caption(), $menus->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($menus_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $menus->datetime->caption(), $menus->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmenusedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmenusedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmenusedit.lists["x_show_title"] = <?php echo $menus_edit->show_title->Lookup->toClientList() ?>;
fmenusedit.lists["x_show_title"].options = <?php echo JsonEncode($menus_edit->show_title->options(FALSE, TRUE)) ?>;
fmenusedit.lists["x_target"] = <?php echo $menus_edit->target->Lookup->toClientList() ?>;
fmenusedit.lists["x_target"].options = <?php echo JsonEncode($menus_edit->target->options(FALSE, TRUE)) ?>;
fmenusedit.lists["x_parent_id"] = <?php echo $menus_edit->parent_id->Lookup->toClientList() ?>;
fmenusedit.lists["x_parent_id"].options = <?php echo JsonEncode($menus_edit->parent_id->lookupOptions()) ?>;
fmenusedit.lists["x_show_in_main_menu"] = <?php echo $menus_edit->show_in_main_menu->Lookup->toClientList() ?>;
fmenusedit.lists["x_show_in_main_menu"].options = <?php echo JsonEncode($menus_edit->show_in_main_menu->options(FALSE, TRUE)) ?>;
fmenusedit.lists["x_status"] = <?php echo $menus_edit->status->Lookup->toClientList() ?>;
fmenusedit.lists["x_status"].options = <?php echo JsonEncode($menus_edit->status->options(FALSE, TRUE)) ?>;
fmenusedit.lists["x_mega_menu"] = <?php echo $menus_edit->mega_menu->Lookup->toClientList() ?>;
fmenusedit.lists["x_mega_menu"].options = <?php echo JsonEncode($menus_edit->mega_menu->options(FALSE, TRUE)) ?>;
fmenusedit.lists["x_submenu"] = <?php echo $menus_edit->submenu->Lookup->toClientList() ?>;
fmenusedit.lists["x_submenu"].options = <?php echo JsonEncode($menus_edit->submenu->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $menus_edit->showPageHeader(); ?>
<?php
$menus_edit->showMessage();
?>
<form name="fmenusedit" id="fmenusedit" class="<?php echo $menus_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($menus_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $menus_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="menus">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$menus_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($menus->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_menus_id" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->id->caption() ?><?php echo ($menus->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->id->cellAttributes() ?>>
<span id="el_menus_id">
<span<?php echo $menus->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($menus->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="menus" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($menus->id->CurrentValue) ?>">
<?php echo $menus->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_menus_image" for="x_image" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->image->caption() ?><?php echo ($menus->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->image->cellAttributes() ?>>
<span id="el_menus_image">
<input type="text" data-table="menus" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($menus->image->getPlaceHolder()) ?>" value="<?php echo $menus->image->EditValue ?>"<?php echo $menus->image->editAttributes() ?>>
</span>
<?php echo $menus->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->show_title->Visible) { // show_title ?>
	<div id="r_show_title" class="form-group row">
		<label id="elh_menus_show_title" for="x_show_title" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->show_title->caption() ?><?php echo ($menus->show_title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->show_title->cellAttributes() ?>>
<span id="el_menus_show_title">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_show_title" data-value-separator="<?php echo $menus->show_title->displayValueSeparatorAttribute() ?>" id="x_show_title" name="x_show_title"<?php echo $menus->show_title->editAttributes() ?>>
		<?php echo $menus->show_title->selectOptionListHtml("x_show_title") ?>
	</select>
</div>
</span>
<?php echo $menus->show_title->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->page_title->Visible) { // page_title ?>
	<div id="r_page_title" class="form-group row">
		<label id="elh_menus_page_title" for="x_page_title" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->page_title->caption() ?><?php echo ($menus->page_title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->page_title->cellAttributes() ?>>
<span id="el_menus_page_title">
<input type="text" data-table="menus" data-field="x_page_title" name="x_page_title" id="x_page_title" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($menus->page_title->getPlaceHolder()) ?>" value="<?php echo $menus->page_title->EditValue ?>"<?php echo $menus->page_title->editAttributes() ?>>
</span>
<?php echo $menus->page_title->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->page_url->Visible) { // page_url ?>
	<div id="r_page_url" class="form-group row">
		<label id="elh_menus_page_url" for="x_page_url" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->page_url->caption() ?><?php echo ($menus->page_url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->page_url->cellAttributes() ?>>
<span id="el_menus_page_url">
<input type="text" data-table="menus" data-field="x_page_url" name="x_page_url" id="x_page_url" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($menus->page_url->getPlaceHolder()) ?>" value="<?php echo $menus->page_url->EditValue ?>"<?php echo $menus->page_url->editAttributes() ?>>
</span>
<?php echo $menus->page_url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->target->Visible) { // target ?>
	<div id="r_target" class="form-group row">
		<label id="elh_menus_target" for="x_target" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->target->caption() ?><?php echo ($menus->target->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->target->cellAttributes() ?>>
<span id="el_menus_target">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_target" data-value-separator="<?php echo $menus->target->displayValueSeparatorAttribute() ?>" id="x_target" name="x_target"<?php echo $menus->target->editAttributes() ?>>
		<?php echo $menus->target->selectOptionListHtml("x_target") ?>
	</select>
</div>
</span>
<?php echo $menus->target->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->parent_id->Visible) { // parent_id ?>
	<div id="r_parent_id" class="form-group row">
		<label id="elh_menus_parent_id" for="x_parent_id" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->parent_id->caption() ?><?php echo ($menus->parent_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->parent_id->cellAttributes() ?>>
<span id="el_menus_parent_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_parent_id" data-value-separator="<?php echo $menus->parent_id->displayValueSeparatorAttribute() ?>" id="x_parent_id" name="x_parent_id"<?php echo $menus->parent_id->editAttributes() ?>>
		<?php echo $menus->parent_id->selectOptionListHtml("x_parent_id") ?>
	</select>
</div>
<?php echo $menus->parent_id->Lookup->getParamTag("p_x_parent_id") ?>
</span>
<?php echo $menus->parent_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->show_in_main_menu->Visible) { // show_in_main_menu ?>
	<div id="r_show_in_main_menu" class="form-group row">
		<label id="elh_menus_show_in_main_menu" for="x_show_in_main_menu" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->show_in_main_menu->caption() ?><?php echo ($menus->show_in_main_menu->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->show_in_main_menu->cellAttributes() ?>>
<span id="el_menus_show_in_main_menu">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_show_in_main_menu" data-value-separator="<?php echo $menus->show_in_main_menu->displayValueSeparatorAttribute() ?>" id="x_show_in_main_menu" name="x_show_in_main_menu"<?php echo $menus->show_in_main_menu->editAttributes() ?>>
		<?php echo $menus->show_in_main_menu->selectOptionListHtml("x_show_in_main_menu") ?>
	</select>
</div>
</span>
<?php echo $menus->show_in_main_menu->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_menus_status" for="x_status" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->status->caption() ?><?php echo ($menus->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->status->cellAttributes() ?>>
<span id="el_menus_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_status" data-value-separator="<?php echo $menus->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $menus->status->editAttributes() ?>>
		<?php echo $menus->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $menus->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->order_by->Visible) { // order_by ?>
	<div id="r_order_by" class="form-group row">
		<label id="elh_menus_order_by" for="x_order_by" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->order_by->caption() ?><?php echo ($menus->order_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->order_by->cellAttributes() ?>>
<span id="el_menus_order_by">
<input type="text" data-table="menus" data-field="x_order_by" name="x_order_by" id="x_order_by" size="30" placeholder="<?php echo HtmlEncode($menus->order_by->getPlaceHolder()) ?>" value="<?php echo $menus->order_by->EditValue ?>"<?php echo $menus->order_by->editAttributes() ?>>
</span>
<?php echo $menus->order_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->mega_menu->Visible) { // mega_menu ?>
	<div id="r_mega_menu" class="form-group row">
		<label id="elh_menus_mega_menu" for="x_mega_menu" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->mega_menu->caption() ?><?php echo ($menus->mega_menu->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->mega_menu->cellAttributes() ?>>
<span id="el_menus_mega_menu">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_mega_menu" data-value-separator="<?php echo $menus->mega_menu->displayValueSeparatorAttribute() ?>" id="x_mega_menu" name="x_mega_menu"<?php echo $menus->mega_menu->editAttributes() ?>>
		<?php echo $menus->mega_menu->selectOptionListHtml("x_mega_menu") ?>
	</select>
</div>
</span>
<?php echo $menus->mega_menu->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->bgcolor->Visible) { // bgcolor ?>
	<div id="r_bgcolor" class="form-group row">
		<label id="elh_menus_bgcolor" for="x_bgcolor" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->bgcolor->caption() ?><?php echo ($menus->bgcolor->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->bgcolor->cellAttributes() ?>>
<span id="el_menus_bgcolor">
<input type="text" data-table="menus" data-field="x_bgcolor" name="x_bgcolor" id="x_bgcolor" size="30" maxlength="7" placeholder="<?php echo HtmlEncode($menus->bgcolor->getPlaceHolder()) ?>" value="<?php echo $menus->bgcolor->EditValue ?>"<?php echo $menus->bgcolor->editAttributes() ?>>
</span>
<?php echo $menus->bgcolor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->submenu->Visible) { // submenu ?>
	<div id="r_submenu" class="form-group row">
		<label id="elh_menus_submenu" for="x_submenu" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->submenu->caption() ?><?php echo ($menus->submenu->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->submenu->cellAttributes() ?>>
<span id="el_menus_submenu">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_submenu" data-value-separator="<?php echo $menus->submenu->displayValueSeparatorAttribute() ?>" id="x_submenu" name="x_submenu"<?php echo $menus->submenu->editAttributes() ?>>
		<?php echo $menus->submenu->selectOptionListHtml("x_submenu") ?>
	</select>
</div>
</span>
<?php echo $menus->submenu->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->submenu_code->Visible) { // submenu_code ?>
	<div id="r_submenu_code" class="form-group row">
		<label id="elh_menus_submenu_code" for="x_submenu_code" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->submenu_code->caption() ?><?php echo ($menus->submenu_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->submenu_code->cellAttributes() ?>>
<span id="el_menus_submenu_code">
<textarea data-table="menus" data-field="x_submenu_code" name="x_submenu_code" id="x_submenu_code" cols="35" rows="4" placeholder="<?php echo HtmlEncode($menus->submenu_code->getPlaceHolder()) ?>"<?php echo $menus->submenu_code->editAttributes() ?>><?php echo $menus->submenu_code->EditValue ?></textarea>
</span>
<?php echo $menus->submenu_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($menus->footer_group->Visible) { // footer_group ?>
	<div id="r_footer_group" class="form-group row">
		<label id="elh_menus_footer_group" for="x_footer_group" class="<?php echo $menus_edit->LeftColumnClass ?>"><?php echo $menus->footer_group->caption() ?><?php echo ($menus->footer_group->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $menus_edit->RightColumnClass ?>"><div<?php echo $menus->footer_group->cellAttributes() ?>>
<span id="el_menus_footer_group">
<input type="text" data-table="menus" data-field="x_footer_group" name="x_footer_group" id="x_footer_group" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($menus->footer_group->getPlaceHolder()) ?>" value="<?php echo $menus->footer_group->EditValue ?>"<?php echo $menus->footer_group->editAttributes() ?>>
</span>
<?php echo $menus->footer_group->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$menus_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $menus_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $menus_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$menus_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$menus_edit->terminate();
?>