<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$menus_list = new menus_list();

// Run the page
$menus_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$menus_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$menus->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmenuslist = currentForm = new ew.Form("fmenuslist", "list");
fmenuslist.formKeyCountName = '<?php echo $menus_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmenuslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmenuslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmenuslist.lists["x_show_title"] = <?php echo $menus_list->show_title->Lookup->toClientList() ?>;
fmenuslist.lists["x_show_title"].options = <?php echo JsonEncode($menus_list->show_title->options(FALSE, TRUE)) ?>;
fmenuslist.lists["x_target"] = <?php echo $menus_list->target->Lookup->toClientList() ?>;
fmenuslist.lists["x_target"].options = <?php echo JsonEncode($menus_list->target->options(FALSE, TRUE)) ?>;
fmenuslist.lists["x_parent_id"] = <?php echo $menus_list->parent_id->Lookup->toClientList() ?>;
fmenuslist.lists["x_parent_id"].options = <?php echo JsonEncode($menus_list->parent_id->lookupOptions()) ?>;
fmenuslist.lists["x_show_in_main_menu"] = <?php echo $menus_list->show_in_main_menu->Lookup->toClientList() ?>;
fmenuslist.lists["x_show_in_main_menu"].options = <?php echo JsonEncode($menus_list->show_in_main_menu->options(FALSE, TRUE)) ?>;
fmenuslist.lists["x_status"] = <?php echo $menus_list->status->Lookup->toClientList() ?>;
fmenuslist.lists["x_status"].options = <?php echo JsonEncode($menus_list->status->options(FALSE, TRUE)) ?>;
fmenuslist.lists["x_mega_menu"] = <?php echo $menus_list->mega_menu->Lookup->toClientList() ?>;
fmenuslist.lists["x_mega_menu"].options = <?php echo JsonEncode($menus_list->mega_menu->options(FALSE, TRUE)) ?>;
fmenuslist.lists["x_submenu"] = <?php echo $menus_list->submenu->Lookup->toClientList() ?>;
fmenuslist.lists["x_submenu"].options = <?php echo JsonEncode($menus_list->submenu->options(FALSE, TRUE)) ?>;

// Form object for search
var fmenuslistsrch = currentSearchForm = new ew.Form("fmenuslistsrch");

// Filters
fmenuslistsrch.filterList = <?php echo $menus_list->getFilterList() ?>;

// Init search panel as collapsed
fmenuslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$menus->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($menus_list->TotalRecs > 0 && $menus_list->ExportOptions->visible()) { ?>
<?php $menus_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($menus_list->ImportOptions->visible()) { ?>
<?php $menus_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($menus_list->SearchOptions->visible()) { ?>
<?php $menus_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($menus_list->FilterOptions->visible()) { ?>
<?php $menus_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$menus_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$menus->isExport() && !$menus->CurrentAction) { ?>
<form name="fmenuslistsrch" id="fmenuslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($menus_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmenuslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="menus">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($menus_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($menus_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $menus_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($menus_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($menus_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($menus_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($menus_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $menus_list->showPageHeader(); ?>
<?php
$menus_list->showMessage();
?>
<?php if ($menus_list->TotalRecs > 0 || $menus->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($menus_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> menus">
<?php if (!$menus->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$menus->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($menus_list->Pager)) $menus_list->Pager = new PrevNextPager($menus_list->StartRec, $menus_list->DisplayRecs, $menus_list->TotalRecs, $menus_list->AutoHidePager) ?>
<?php if ($menus_list->Pager->RecordCount > 0 && $menus_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($menus_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $menus_list->pageUrl() ?>start=<?php echo $menus_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($menus_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $menus_list->pageUrl() ?>start=<?php echo $menus_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $menus_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($menus_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $menus_list->pageUrl() ?>start=<?php echo $menus_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($menus_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $menus_list->pageUrl() ?>start=<?php echo $menus_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $menus_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($menus_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $menus_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $menus_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $menus_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($menus_list->TotalRecs > 0 && (!$menus_list->AutoHidePageSizeSelector || $menus_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="menus">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($menus_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($menus_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($menus_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($menus_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($menus_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($menus->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $menus_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmenuslist" id="fmenuslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($menus_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $menus_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="menus">
<div id="gmp_menus" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($menus_list->TotalRecs > 0 || $menus->isGridEdit()) { ?>
<table id="tbl_menuslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$menus_list->RowType = ROWTYPE_HEADER;

// Render list options
$menus_list->renderListOptions();

// Render list options (header, left)
$menus_list->ListOptions->render("header", "left");
?>
<?php if ($menus->id->Visible) { // id ?>
	<?php if ($menus->sortUrl($menus->id) == "") { ?>
		<th data-name="id" class="<?php echo $menus->id->headerCellClass() ?>"><div id="elh_menus_id" class="menus_id"><div class="ew-table-header-caption"><?php echo $menus->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $menus->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->id) ?>',2);"><div id="elh_menus_id" class="menus_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->image->Visible) { // image ?>
	<?php if ($menus->sortUrl($menus->image) == "") { ?>
		<th data-name="image" class="<?php echo $menus->image->headerCellClass() ?>"><div id="elh_menus_image" class="menus_image"><div class="ew-table-header-caption"><?php echo $menus->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $menus->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->image) ?>',2);"><div id="elh_menus_image" class="menus_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($menus->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->show_title->Visible) { // show_title ?>
	<?php if ($menus->sortUrl($menus->show_title) == "") { ?>
		<th data-name="show_title" class="<?php echo $menus->show_title->headerCellClass() ?>"><div id="elh_menus_show_title" class="menus_show_title"><div class="ew-table-header-caption"><?php echo $menus->show_title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="show_title" class="<?php echo $menus->show_title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->show_title) ?>',2);"><div id="elh_menus_show_title" class="menus_show_title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->show_title->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->show_title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->show_title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->page_title->Visible) { // page_title ?>
	<?php if ($menus->sortUrl($menus->page_title) == "") { ?>
		<th data-name="page_title" class="<?php echo $menus->page_title->headerCellClass() ?>"><div id="elh_menus_page_title" class="menus_page_title"><div class="ew-table-header-caption"><?php echo $menus->page_title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="page_title" class="<?php echo $menus->page_title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->page_title) ?>',2);"><div id="elh_menus_page_title" class="menus_page_title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->page_title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($menus->page_title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->page_title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->page_url->Visible) { // page_url ?>
	<?php if ($menus->sortUrl($menus->page_url) == "") { ?>
		<th data-name="page_url" class="<?php echo $menus->page_url->headerCellClass() ?>"><div id="elh_menus_page_url" class="menus_page_url"><div class="ew-table-header-caption"><?php echo $menus->page_url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="page_url" class="<?php echo $menus->page_url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->page_url) ?>',2);"><div id="elh_menus_page_url" class="menus_page_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->page_url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($menus->page_url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->page_url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->target->Visible) { // target ?>
	<?php if ($menus->sortUrl($menus->target) == "") { ?>
		<th data-name="target" class="<?php echo $menus->target->headerCellClass() ?>"><div id="elh_menus_target" class="menus_target"><div class="ew-table-header-caption"><?php echo $menus->target->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="target" class="<?php echo $menus->target->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->target) ?>',2);"><div id="elh_menus_target" class="menus_target">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->target->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->target->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->target->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->parent_id->Visible) { // parent_id ?>
	<?php if ($menus->sortUrl($menus->parent_id) == "") { ?>
		<th data-name="parent_id" class="<?php echo $menus->parent_id->headerCellClass() ?>"><div id="elh_menus_parent_id" class="menus_parent_id"><div class="ew-table-header-caption"><?php echo $menus->parent_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="parent_id" class="<?php echo $menus->parent_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->parent_id) ?>',2);"><div id="elh_menus_parent_id" class="menus_parent_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->parent_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->parent_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->parent_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->show_in_main_menu->Visible) { // show_in_main_menu ?>
	<?php if ($menus->sortUrl($menus->show_in_main_menu) == "") { ?>
		<th data-name="show_in_main_menu" class="<?php echo $menus->show_in_main_menu->headerCellClass() ?>"><div id="elh_menus_show_in_main_menu" class="menus_show_in_main_menu"><div class="ew-table-header-caption"><?php echo $menus->show_in_main_menu->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="show_in_main_menu" class="<?php echo $menus->show_in_main_menu->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->show_in_main_menu) ?>',2);"><div id="elh_menus_show_in_main_menu" class="menus_show_in_main_menu">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->show_in_main_menu->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->show_in_main_menu->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->show_in_main_menu->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->status->Visible) { // status ?>
	<?php if ($menus->sortUrl($menus->status) == "") { ?>
		<th data-name="status" class="<?php echo $menus->status->headerCellClass() ?>"><div id="elh_menus_status" class="menus_status"><div class="ew-table-header-caption"><?php echo $menus->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $menus->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->status) ?>',2);"><div id="elh_menus_status" class="menus_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->order_by->Visible) { // order_by ?>
	<?php if ($menus->sortUrl($menus->order_by) == "") { ?>
		<th data-name="order_by" class="<?php echo $menus->order_by->headerCellClass() ?>"><div id="elh_menus_order_by" class="menus_order_by"><div class="ew-table-header-caption"><?php echo $menus->order_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_by" class="<?php echo $menus->order_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->order_by) ?>',2);"><div id="elh_menus_order_by" class="menus_order_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->order_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->order_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->order_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->mega_menu->Visible) { // mega_menu ?>
	<?php if ($menus->sortUrl($menus->mega_menu) == "") { ?>
		<th data-name="mega_menu" class="<?php echo $menus->mega_menu->headerCellClass() ?>"><div id="elh_menus_mega_menu" class="menus_mega_menu"><div class="ew-table-header-caption"><?php echo $menus->mega_menu->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mega_menu" class="<?php echo $menus->mega_menu->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->mega_menu) ?>',2);"><div id="elh_menus_mega_menu" class="menus_mega_menu">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->mega_menu->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->mega_menu->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->mega_menu->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->bgcolor->Visible) { // bgcolor ?>
	<?php if ($menus->sortUrl($menus->bgcolor) == "") { ?>
		<th data-name="bgcolor" class="<?php echo $menus->bgcolor->headerCellClass() ?>"><div id="elh_menus_bgcolor" class="menus_bgcolor"><div class="ew-table-header-caption"><?php echo $menus->bgcolor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bgcolor" class="<?php echo $menus->bgcolor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->bgcolor) ?>',2);"><div id="elh_menus_bgcolor" class="menus_bgcolor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->bgcolor->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($menus->bgcolor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->bgcolor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->submenu->Visible) { // submenu ?>
	<?php if ($menus->sortUrl($menus->submenu) == "") { ?>
		<th data-name="submenu" class="<?php echo $menus->submenu->headerCellClass() ?>"><div id="elh_menus_submenu" class="menus_submenu"><div class="ew-table-header-caption"><?php echo $menus->submenu->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="submenu" class="<?php echo $menus->submenu->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->submenu) ?>',2);"><div id="elh_menus_submenu" class="menus_submenu">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->submenu->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->submenu->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->submenu->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->footer_group->Visible) { // footer_group ?>
	<?php if ($menus->sortUrl($menus->footer_group) == "") { ?>
		<th data-name="footer_group" class="<?php echo $menus->footer_group->headerCellClass() ?>"><div id="elh_menus_footer_group" class="menus_footer_group"><div class="ew-table-header-caption"><?php echo $menus->footer_group->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="footer_group" class="<?php echo $menus->footer_group->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->footer_group) ?>',2);"><div id="elh_menus_footer_group" class="menus_footer_group">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->footer_group->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($menus->footer_group->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->footer_group->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->operator->Visible) { // operator ?>
	<?php if ($menus->sortUrl($menus->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $menus->operator->headerCellClass() ?>"><div id="elh_menus_operator" class="menus_operator"><div class="ew-table-header-caption"><?php echo $menus->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $menus->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->operator) ?>',2);"><div id="elh_menus_operator" class="menus_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($menus->datetime->Visible) { // datetime ?>
	<?php if ($menus->sortUrl($menus->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $menus->datetime->headerCellClass() ?>"><div id="elh_menus_datetime" class="menus_datetime"><div class="ew-table-header-caption"><?php echo $menus->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $menus->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $menus->SortUrl($menus->datetime) ?>',2);"><div id="elh_menus_datetime" class="menus_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $menus->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($menus->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($menus->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$menus_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($menus->ExportAll && $menus->isExport()) {
	$menus_list->StopRec = $menus_list->TotalRecs;
} else {

	// Set the last record to display
	if ($menus_list->TotalRecs > $menus_list->StartRec + $menus_list->DisplayRecs - 1)
		$menus_list->StopRec = $menus_list->StartRec + $menus_list->DisplayRecs - 1;
	else
		$menus_list->StopRec = $menus_list->TotalRecs;
}
$menus_list->RecCnt = $menus_list->StartRec - 1;
if ($menus_list->Recordset && !$menus_list->Recordset->EOF) {
	$menus_list->Recordset->moveFirst();
	$selectLimit = $menus_list->UseSelectLimit;
	if (!$selectLimit && $menus_list->StartRec > 1)
		$menus_list->Recordset->move($menus_list->StartRec - 1);
} elseif (!$menus->AllowAddDeleteRow && $menus_list->StopRec == 0) {
	$menus_list->StopRec = $menus->GridAddRowCount;
}

// Initialize aggregate
$menus->RowType = ROWTYPE_AGGREGATEINIT;
$menus->resetAttributes();
$menus_list->renderRow();
while ($menus_list->RecCnt < $menus_list->StopRec) {
	$menus_list->RecCnt++;
	if ($menus_list->RecCnt >= $menus_list->StartRec) {
		$menus_list->RowCnt++;

		// Set up key count
		$menus_list->KeyCount = $menus_list->RowIndex;

		// Init row class and style
		$menus->resetAttributes();
		$menus->CssClass = "";
		if ($menus->isGridAdd()) {
		} else {
			$menus_list->loadRowValues($menus_list->Recordset); // Load row values
		}
		$menus->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$menus->RowAttrs = array_merge($menus->RowAttrs, array('data-rowindex'=>$menus_list->RowCnt, 'id'=>'r' . $menus_list->RowCnt . '_menus', 'data-rowtype'=>$menus->RowType));

		// Render row
		$menus_list->renderRow();

		// Render list options
		$menus_list->renderListOptions();
?>
	<tr<?php echo $menus->rowAttributes() ?>>
<?php

// Render list options (body, left)
$menus_list->ListOptions->render("body", "left", $menus_list->RowCnt);
?>
	<?php if ($menus->id->Visible) { // id ?>
		<td data-name="id"<?php echo $menus->id->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_id" class="menus_id">
<span<?php echo $menus->id->viewAttributes() ?>>
<?php echo $menus->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->image->Visible) { // image ?>
		<td data-name="image"<?php echo $menus->image->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_image" class="menus_image">
<span<?php echo $menus->image->viewAttributes() ?>>
<?php echo $menus->image->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->show_title->Visible) { // show_title ?>
		<td data-name="show_title"<?php echo $menus->show_title->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_show_title" class="menus_show_title">
<span<?php echo $menus->show_title->viewAttributes() ?>>
<?php echo $menus->show_title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->page_title->Visible) { // page_title ?>
		<td data-name="page_title"<?php echo $menus->page_title->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_page_title" class="menus_page_title">
<span<?php echo $menus->page_title->viewAttributes() ?>>
<?php echo $menus->page_title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->page_url->Visible) { // page_url ?>
		<td data-name="page_url"<?php echo $menus->page_url->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_page_url" class="menus_page_url">
<span<?php echo $menus->page_url->viewAttributes() ?>>
<?php echo $menus->page_url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->target->Visible) { // target ?>
		<td data-name="target"<?php echo $menus->target->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_target" class="menus_target">
<span<?php echo $menus->target->viewAttributes() ?>>
<?php echo $menus->target->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->parent_id->Visible) { // parent_id ?>
		<td data-name="parent_id"<?php echo $menus->parent_id->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_parent_id" class="menus_parent_id">
<span<?php echo $menus->parent_id->viewAttributes() ?>>
<?php echo $menus->parent_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->show_in_main_menu->Visible) { // show_in_main_menu ?>
		<td data-name="show_in_main_menu"<?php echo $menus->show_in_main_menu->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_show_in_main_menu" class="menus_show_in_main_menu">
<span<?php echo $menus->show_in_main_menu->viewAttributes() ?>>
<?php echo $menus->show_in_main_menu->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->status->Visible) { // status ?>
		<td data-name="status"<?php echo $menus->status->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_status" class="menus_status">
<span<?php echo $menus->status->viewAttributes() ?>>
<?php echo $menus->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->order_by->Visible) { // order_by ?>
		<td data-name="order_by"<?php echo $menus->order_by->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_order_by" class="menus_order_by">
<span<?php echo $menus->order_by->viewAttributes() ?>>
<?php echo $menus->order_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->mega_menu->Visible) { // mega_menu ?>
		<td data-name="mega_menu"<?php echo $menus->mega_menu->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_mega_menu" class="menus_mega_menu">
<span<?php echo $menus->mega_menu->viewAttributes() ?>>
<?php echo $menus->mega_menu->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->bgcolor->Visible) { // bgcolor ?>
		<td data-name="bgcolor"<?php echo $menus->bgcolor->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_bgcolor" class="menus_bgcolor">
<span<?php echo $menus->bgcolor->viewAttributes() ?>>
<?php echo $menus->bgcolor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->submenu->Visible) { // submenu ?>
		<td data-name="submenu"<?php echo $menus->submenu->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_submenu" class="menus_submenu">
<span<?php echo $menus->submenu->viewAttributes() ?>>
<?php echo $menus->submenu->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->footer_group->Visible) { // footer_group ?>
		<td data-name="footer_group"<?php echo $menus->footer_group->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_footer_group" class="menus_footer_group">
<span<?php echo $menus->footer_group->viewAttributes() ?>>
<?php echo $menus->footer_group->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $menus->operator->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_operator" class="menus_operator">
<span<?php echo $menus->operator->viewAttributes() ?>>
<?php echo $menus->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($menus->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $menus->datetime->cellAttributes() ?>>
<span id="el<?php echo $menus_list->RowCnt ?>_menus_datetime" class="menus_datetime">
<span<?php echo $menus->datetime->viewAttributes() ?>>
<?php echo $menus->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$menus_list->ListOptions->render("body", "right", $menus_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$menus->isGridAdd())
		$menus_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$menus->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($menus_list->Recordset)
	$menus_list->Recordset->Close();
?>
<?php if (!$menus->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$menus->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($menus_list->Pager)) $menus_list->Pager = new PrevNextPager($menus_list->StartRec, $menus_list->DisplayRecs, $menus_list->TotalRecs, $menus_list->AutoHidePager) ?>
<?php if ($menus_list->Pager->RecordCount > 0 && $menus_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($menus_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $menus_list->pageUrl() ?>start=<?php echo $menus_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($menus_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $menus_list->pageUrl() ?>start=<?php echo $menus_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $menus_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($menus_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $menus_list->pageUrl() ?>start=<?php echo $menus_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($menus_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $menus_list->pageUrl() ?>start=<?php echo $menus_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $menus_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($menus_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $menus_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $menus_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $menus_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($menus_list->TotalRecs > 0 && (!$menus_list->AutoHidePageSizeSelector || $menus_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="menus">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($menus_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($menus_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($menus_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($menus_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($menus_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($menus->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $menus_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($menus_list->TotalRecs == 0 && !$menus->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $menus_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$menus_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$menus->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$menus->isExport()) { ?>
<script>
ew.scrollableTable("gmp_menus", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$menus_list->terminate();
?>