<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$menus_search = new menus_search();

// Run the page
$menus_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$menus_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($menus_search->IsModal) { ?>
var fmenussearch = currentAdvancedSearchForm = new ew.Form("fmenussearch", "search");
<?php } else { ?>
var fmenussearch = currentForm = new ew.Form("fmenussearch", "search");
<?php } ?>

// Form_CustomValidate event
fmenussearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmenussearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmenussearch.lists["x_show_title"] = <?php echo $menus_search->show_title->Lookup->toClientList() ?>;
fmenussearch.lists["x_show_title"].options = <?php echo JsonEncode($menus_search->show_title->options(FALSE, TRUE)) ?>;
fmenussearch.lists["x_target"] = <?php echo $menus_search->target->Lookup->toClientList() ?>;
fmenussearch.lists["x_target"].options = <?php echo JsonEncode($menus_search->target->options(FALSE, TRUE)) ?>;
fmenussearch.lists["x_parent_id"] = <?php echo $menus_search->parent_id->Lookup->toClientList() ?>;
fmenussearch.lists["x_parent_id"].options = <?php echo JsonEncode($menus_search->parent_id->lookupOptions()) ?>;
fmenussearch.lists["x_show_in_main_menu"] = <?php echo $menus_search->show_in_main_menu->Lookup->toClientList() ?>;
fmenussearch.lists["x_show_in_main_menu"].options = <?php echo JsonEncode($menus_search->show_in_main_menu->options(FALSE, TRUE)) ?>;
fmenussearch.lists["x_status"] = <?php echo $menus_search->status->Lookup->toClientList() ?>;
fmenussearch.lists["x_status"].options = <?php echo JsonEncode($menus_search->status->options(FALSE, TRUE)) ?>;
fmenussearch.lists["x_mega_menu"] = <?php echo $menus_search->mega_menu->Lookup->toClientList() ?>;
fmenussearch.lists["x_mega_menu"].options = <?php echo JsonEncode($menus_search->mega_menu->options(FALSE, TRUE)) ?>;
fmenussearch.lists["x_submenu"] = <?php echo $menus_search->submenu->Lookup->toClientList() ?>;
fmenussearch.lists["x_submenu"].options = <?php echo JsonEncode($menus_search->submenu->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fmenussearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($menus->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_by");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($menus->order_by->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($menus->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($menus->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $menus_search->showPageHeader(); ?>
<?php
$menus_search->showMessage();
?>
<form name="fmenussearch" id="fmenussearch" class="<?php echo $menus_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($menus_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $menus_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="menus">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$menus_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($menus->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_id"><?php echo $menus->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->id->cellAttributes() ?>>
			<span id="el_menus_id">
<input type="text" data-table="menus" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($menus->id->getPlaceHolder()) ?>" value="<?php echo $menus->id->EditValue ?>"<?php echo $menus->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label for="x_image" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_image"><?php echo $menus->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->image->cellAttributes() ?>>
			<span id="el_menus_image">
<input type="text" data-table="menus" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($menus->image->getPlaceHolder()) ?>" value="<?php echo $menus->image->EditValue ?>"<?php echo $menus->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->show_title->Visible) { // show_title ?>
	<div id="r_show_title" class="form-group row">
		<label for="x_show_title" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_show_title"><?php echo $menus->show_title->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_show_title" id="z_show_title" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->show_title->cellAttributes() ?>>
			<span id="el_menus_show_title">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_show_title" data-value-separator="<?php echo $menus->show_title->displayValueSeparatorAttribute() ?>" id="x_show_title" name="x_show_title"<?php echo $menus->show_title->editAttributes() ?>>
		<?php echo $menus->show_title->selectOptionListHtml("x_show_title") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->page_title->Visible) { // page_title ?>
	<div id="r_page_title" class="form-group row">
		<label for="x_page_title" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_page_title"><?php echo $menus->page_title->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_page_title" id="z_page_title" value="LIKE"></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->page_title->cellAttributes() ?>>
			<span id="el_menus_page_title">
<input type="text" data-table="menus" data-field="x_page_title" name="x_page_title" id="x_page_title" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($menus->page_title->getPlaceHolder()) ?>" value="<?php echo $menus->page_title->EditValue ?>"<?php echo $menus->page_title->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->page_url->Visible) { // page_url ?>
	<div id="r_page_url" class="form-group row">
		<label for="x_page_url" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_page_url"><?php echo $menus->page_url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_page_url" id="z_page_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->page_url->cellAttributes() ?>>
			<span id="el_menus_page_url">
<input type="text" data-table="menus" data-field="x_page_url" name="x_page_url" id="x_page_url" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($menus->page_url->getPlaceHolder()) ?>" value="<?php echo $menus->page_url->EditValue ?>"<?php echo $menus->page_url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->target->Visible) { // target ?>
	<div id="r_target" class="form-group row">
		<label for="x_target" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_target"><?php echo $menus->target->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_target" id="z_target" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->target->cellAttributes() ?>>
			<span id="el_menus_target">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_target" data-value-separator="<?php echo $menus->target->displayValueSeparatorAttribute() ?>" id="x_target" name="x_target"<?php echo $menus->target->editAttributes() ?>>
		<?php echo $menus->target->selectOptionListHtml("x_target") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->parent_id->Visible) { // parent_id ?>
	<div id="r_parent_id" class="form-group row">
		<label for="x_parent_id" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_parent_id"><?php echo $menus->parent_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_parent_id" id="z_parent_id" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->parent_id->cellAttributes() ?>>
			<span id="el_menus_parent_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_parent_id" data-value-separator="<?php echo $menus->parent_id->displayValueSeparatorAttribute() ?>" id="x_parent_id" name="x_parent_id"<?php echo $menus->parent_id->editAttributes() ?>>
		<?php echo $menus->parent_id->selectOptionListHtml("x_parent_id") ?>
	</select>
</div>
<?php echo $menus->parent_id->Lookup->getParamTag("p_x_parent_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->show_in_main_menu->Visible) { // show_in_main_menu ?>
	<div id="r_show_in_main_menu" class="form-group row">
		<label for="x_show_in_main_menu" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_show_in_main_menu"><?php echo $menus->show_in_main_menu->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_show_in_main_menu" id="z_show_in_main_menu" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->show_in_main_menu->cellAttributes() ?>>
			<span id="el_menus_show_in_main_menu">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_show_in_main_menu" data-value-separator="<?php echo $menus->show_in_main_menu->displayValueSeparatorAttribute() ?>" id="x_show_in_main_menu" name="x_show_in_main_menu"<?php echo $menus->show_in_main_menu->editAttributes() ?>>
		<?php echo $menus->show_in_main_menu->selectOptionListHtml("x_show_in_main_menu") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_status"><?php echo $menus->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->status->cellAttributes() ?>>
			<span id="el_menus_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_status" data-value-separator="<?php echo $menus->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $menus->status->editAttributes() ?>>
		<?php echo $menus->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->order_by->Visible) { // order_by ?>
	<div id="r_order_by" class="form-group row">
		<label for="x_order_by" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_order_by"><?php echo $menus->order_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_by" id="z_order_by" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->order_by->cellAttributes() ?>>
			<span id="el_menus_order_by">
<input type="text" data-table="menus" data-field="x_order_by" name="x_order_by" id="x_order_by" size="30" placeholder="<?php echo HtmlEncode($menus->order_by->getPlaceHolder()) ?>" value="<?php echo $menus->order_by->EditValue ?>"<?php echo $menus->order_by->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->mega_menu->Visible) { // mega_menu ?>
	<div id="r_mega_menu" class="form-group row">
		<label for="x_mega_menu" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_mega_menu"><?php echo $menus->mega_menu->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_mega_menu" id="z_mega_menu" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->mega_menu->cellAttributes() ?>>
			<span id="el_menus_mega_menu">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_mega_menu" data-value-separator="<?php echo $menus->mega_menu->displayValueSeparatorAttribute() ?>" id="x_mega_menu" name="x_mega_menu"<?php echo $menus->mega_menu->editAttributes() ?>>
		<?php echo $menus->mega_menu->selectOptionListHtml("x_mega_menu") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->bgcolor->Visible) { // bgcolor ?>
	<div id="r_bgcolor" class="form-group row">
		<label for="x_bgcolor" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_bgcolor"><?php echo $menus->bgcolor->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_bgcolor" id="z_bgcolor" value="LIKE"></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->bgcolor->cellAttributes() ?>>
			<span id="el_menus_bgcolor">
<input type="text" data-table="menus" data-field="x_bgcolor" name="x_bgcolor" id="x_bgcolor" size="30" maxlength="7" placeholder="<?php echo HtmlEncode($menus->bgcolor->getPlaceHolder()) ?>" value="<?php echo $menus->bgcolor->EditValue ?>"<?php echo $menus->bgcolor->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->submenu->Visible) { // submenu ?>
	<div id="r_submenu" class="form-group row">
		<label for="x_submenu" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_submenu"><?php echo $menus->submenu->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_submenu" id="z_submenu" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->submenu->cellAttributes() ?>>
			<span id="el_menus_submenu">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="menus" data-field="x_submenu" data-value-separator="<?php echo $menus->submenu->displayValueSeparatorAttribute() ?>" id="x_submenu" name="x_submenu"<?php echo $menus->submenu->editAttributes() ?>>
		<?php echo $menus->submenu->selectOptionListHtml("x_submenu") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->submenu_code->Visible) { // submenu_code ?>
	<div id="r_submenu_code" class="form-group row">
		<label for="x_submenu_code" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_submenu_code"><?php echo $menus->submenu_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_submenu_code" id="z_submenu_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->submenu_code->cellAttributes() ?>>
			<span id="el_menus_submenu_code">
<input type="text" data-table="menus" data-field="x_submenu_code" name="x_submenu_code" id="x_submenu_code" size="35" placeholder="<?php echo HtmlEncode($menus->submenu_code->getPlaceHolder()) ?>" value="<?php echo $menus->submenu_code->EditValue ?>"<?php echo $menus->submenu_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->footer_group->Visible) { // footer_group ?>
	<div id="r_footer_group" class="form-group row">
		<label for="x_footer_group" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_footer_group"><?php echo $menus->footer_group->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_footer_group" id="z_footer_group" value="LIKE"></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->footer_group->cellAttributes() ?>>
			<span id="el_menus_footer_group">
<input type="text" data-table="menus" data-field="x_footer_group" name="x_footer_group" id="x_footer_group" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($menus->footer_group->getPlaceHolder()) ?>" value="<?php echo $menus->footer_group->EditValue ?>"<?php echo $menus->footer_group->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_operator"><?php echo $menus->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->operator->cellAttributes() ?>>
			<span id="el_menus_operator">
<input type="text" data-table="menus" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($menus->operator->getPlaceHolder()) ?>" value="<?php echo $menus->operator->EditValue ?>"<?php echo $menus->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($menus->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $menus_search->LeftColumnClass ?>"><span id="elh_menus_datetime"><?php echo $menus->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $menus_search->RightColumnClass ?>"><div<?php echo $menus->datetime->cellAttributes() ?>>
			<span id="el_menus_datetime">
<input type="text" data-table="menus" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($menus->datetime->getPlaceHolder()) ?>" value="<?php echo $menus->datetime->EditValue ?>"<?php echo $menus->datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$menus_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $menus_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$menus_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$menus_search->terminate();
?>