<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$menus_view = new menus_view();

// Run the page
$menus_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$menus_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$menus->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fmenusview = currentForm = new ew.Form("fmenusview", "view");

// Form_CustomValidate event
fmenusview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmenusview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmenusview.lists["x_show_title"] = <?php echo $menus_view->show_title->Lookup->toClientList() ?>;
fmenusview.lists["x_show_title"].options = <?php echo JsonEncode($menus_view->show_title->options(FALSE, TRUE)) ?>;
fmenusview.lists["x_target"] = <?php echo $menus_view->target->Lookup->toClientList() ?>;
fmenusview.lists["x_target"].options = <?php echo JsonEncode($menus_view->target->options(FALSE, TRUE)) ?>;
fmenusview.lists["x_parent_id"] = <?php echo $menus_view->parent_id->Lookup->toClientList() ?>;
fmenusview.lists["x_parent_id"].options = <?php echo JsonEncode($menus_view->parent_id->lookupOptions()) ?>;
fmenusview.lists["x_show_in_main_menu"] = <?php echo $menus_view->show_in_main_menu->Lookup->toClientList() ?>;
fmenusview.lists["x_show_in_main_menu"].options = <?php echo JsonEncode($menus_view->show_in_main_menu->options(FALSE, TRUE)) ?>;
fmenusview.lists["x_status"] = <?php echo $menus_view->status->Lookup->toClientList() ?>;
fmenusview.lists["x_status"].options = <?php echo JsonEncode($menus_view->status->options(FALSE, TRUE)) ?>;
fmenusview.lists["x_mega_menu"] = <?php echo $menus_view->mega_menu->Lookup->toClientList() ?>;
fmenusview.lists["x_mega_menu"].options = <?php echo JsonEncode($menus_view->mega_menu->options(FALSE, TRUE)) ?>;
fmenusview.lists["x_submenu"] = <?php echo $menus_view->submenu->Lookup->toClientList() ?>;
fmenusview.lists["x_submenu"].options = <?php echo JsonEncode($menus_view->submenu->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$menus->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $menus_view->ExportOptions->render("body") ?>
<?php $menus_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $menus_view->showPageHeader(); ?>
<?php
$menus_view->showMessage();
?>
<form name="fmenusview" id="fmenusview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($menus_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $menus_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="menus">
<input type="hidden" name="modal" value="<?php echo (int)$menus_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($menus->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_id"><?php echo $menus->id->caption() ?></span></td>
		<td data-name="id"<?php echo $menus->id->cellAttributes() ?>>
<span id="el_menus_id">
<span<?php echo $menus->id->viewAttributes() ?>>
<?php echo $menus->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_image"><?php echo $menus->image->caption() ?></span></td>
		<td data-name="image"<?php echo $menus->image->cellAttributes() ?>>
<span id="el_menus_image">
<span<?php echo $menus->image->viewAttributes() ?>>
<?php echo $menus->image->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->show_title->Visible) { // show_title ?>
	<tr id="r_show_title">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_show_title"><?php echo $menus->show_title->caption() ?></span></td>
		<td data-name="show_title"<?php echo $menus->show_title->cellAttributes() ?>>
<span id="el_menus_show_title">
<span<?php echo $menus->show_title->viewAttributes() ?>>
<?php echo $menus->show_title->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->page_title->Visible) { // page_title ?>
	<tr id="r_page_title">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_page_title"><?php echo $menus->page_title->caption() ?></span></td>
		<td data-name="page_title"<?php echo $menus->page_title->cellAttributes() ?>>
<span id="el_menus_page_title">
<span<?php echo $menus->page_title->viewAttributes() ?>>
<?php echo $menus->page_title->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->page_url->Visible) { // page_url ?>
	<tr id="r_page_url">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_page_url"><?php echo $menus->page_url->caption() ?></span></td>
		<td data-name="page_url"<?php echo $menus->page_url->cellAttributes() ?>>
<span id="el_menus_page_url">
<span<?php echo $menus->page_url->viewAttributes() ?>>
<?php echo $menus->page_url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->target->Visible) { // target ?>
	<tr id="r_target">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_target"><?php echo $menus->target->caption() ?></span></td>
		<td data-name="target"<?php echo $menus->target->cellAttributes() ?>>
<span id="el_menus_target">
<span<?php echo $menus->target->viewAttributes() ?>>
<?php echo $menus->target->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->parent_id->Visible) { // parent_id ?>
	<tr id="r_parent_id">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_parent_id"><?php echo $menus->parent_id->caption() ?></span></td>
		<td data-name="parent_id"<?php echo $menus->parent_id->cellAttributes() ?>>
<span id="el_menus_parent_id">
<span<?php echo $menus->parent_id->viewAttributes() ?>>
<?php echo $menus->parent_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->show_in_main_menu->Visible) { // show_in_main_menu ?>
	<tr id="r_show_in_main_menu">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_show_in_main_menu"><?php echo $menus->show_in_main_menu->caption() ?></span></td>
		<td data-name="show_in_main_menu"<?php echo $menus->show_in_main_menu->cellAttributes() ?>>
<span id="el_menus_show_in_main_menu">
<span<?php echo $menus->show_in_main_menu->viewAttributes() ?>>
<?php echo $menus->show_in_main_menu->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_status"><?php echo $menus->status->caption() ?></span></td>
		<td data-name="status"<?php echo $menus->status->cellAttributes() ?>>
<span id="el_menus_status">
<span<?php echo $menus->status->viewAttributes() ?>>
<?php echo $menus->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->order_by->Visible) { // order_by ?>
	<tr id="r_order_by">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_order_by"><?php echo $menus->order_by->caption() ?></span></td>
		<td data-name="order_by"<?php echo $menus->order_by->cellAttributes() ?>>
<span id="el_menus_order_by">
<span<?php echo $menus->order_by->viewAttributes() ?>>
<?php echo $menus->order_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->mega_menu->Visible) { // mega_menu ?>
	<tr id="r_mega_menu">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_mega_menu"><?php echo $menus->mega_menu->caption() ?></span></td>
		<td data-name="mega_menu"<?php echo $menus->mega_menu->cellAttributes() ?>>
<span id="el_menus_mega_menu">
<span<?php echo $menus->mega_menu->viewAttributes() ?>>
<?php echo $menus->mega_menu->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->bgcolor->Visible) { // bgcolor ?>
	<tr id="r_bgcolor">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_bgcolor"><?php echo $menus->bgcolor->caption() ?></span></td>
		<td data-name="bgcolor"<?php echo $menus->bgcolor->cellAttributes() ?>>
<span id="el_menus_bgcolor">
<span<?php echo $menus->bgcolor->viewAttributes() ?>>
<?php echo $menus->bgcolor->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->submenu->Visible) { // submenu ?>
	<tr id="r_submenu">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_submenu"><?php echo $menus->submenu->caption() ?></span></td>
		<td data-name="submenu"<?php echo $menus->submenu->cellAttributes() ?>>
<span id="el_menus_submenu">
<span<?php echo $menus->submenu->viewAttributes() ?>>
<?php echo $menus->submenu->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->submenu_code->Visible) { // submenu_code ?>
	<tr id="r_submenu_code">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_submenu_code"><?php echo $menus->submenu_code->caption() ?></span></td>
		<td data-name="submenu_code"<?php echo $menus->submenu_code->cellAttributes() ?>>
<span id="el_menus_submenu_code">
<span<?php echo $menus->submenu_code->viewAttributes() ?>>
<?php echo $menus->submenu_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->footer_group->Visible) { // footer_group ?>
	<tr id="r_footer_group">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_footer_group"><?php echo $menus->footer_group->caption() ?></span></td>
		<td data-name="footer_group"<?php echo $menus->footer_group->cellAttributes() ?>>
<span id="el_menus_footer_group">
<span<?php echo $menus->footer_group->viewAttributes() ?>>
<?php echo $menus->footer_group->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_operator"><?php echo $menus->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $menus->operator->cellAttributes() ?>>
<span id="el_menus_operator">
<span<?php echo $menus->operator->viewAttributes() ?>>
<?php echo $menus->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($menus->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $menus_view->TableLeftColumnClass ?>"><span id="elh_menus_datetime"><?php echo $menus->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $menus->datetime->cellAttributes() ?>>
<span id="el_menus_datetime">
<span<?php echo $menus->datetime->viewAttributes() ?>>
<?php echo $menus->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$menus_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$menus->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$menus_view->terminate();
?>