<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$message_template_admin_search = new message_template_admin_search();

// Run the page
$message_template_admin_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$message_template_admin_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($message_template_admin_search->IsModal) { ?>
var fmessage_template_adminsearch = currentAdvancedSearchForm = new ew.Form("fmessage_template_adminsearch", "search");
<?php } else { ?>
var fmessage_template_adminsearch = currentForm = new ew.Form("fmessage_template_adminsearch", "search");
<?php } ?>

// Form_CustomValidate event
fmessage_template_adminsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmessage_template_adminsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fmessage_template_adminsearch.multiPage = new ew.MultiPage("fmessage_template_adminsearch");

// Dynamic selection lists
fmessage_template_adminsearch.lists["x_grp"] = <?php echo $message_template_admin_search->grp->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_grp"].options = <?php echo JsonEncode($message_template_admin_search->grp->lookupOptions()) ?>;
fmessage_template_adminsearch.lists["x_status_email_user"] = <?php echo $message_template_admin_search->status_email_user->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_status_email_user"].options = <?php echo JsonEncode($message_template_admin_search->status_email_user->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_status_email_office"] = <?php echo $message_template_admin_search->status_email_office->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_status_email_office"].options = <?php echo JsonEncode($message_template_admin_search->status_email_office->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_status_sms_user"] = <?php echo $message_template_admin_search->status_sms_user->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_status_sms_user"].options = <?php echo JsonEncode($message_template_admin_search->status_sms_user->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_status_sms_office"] = <?php echo $message_template_admin_search->status_sms_office->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_status_sms_office"].options = <?php echo JsonEncode($message_template_admin_search->status_sms_office->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_wa_status_user"] = <?php echo $message_template_admin_search->wa_status_user->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_wa_status_user"].options = <?php echo JsonEncode($message_template_admin_search->wa_status_user->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_wa_type_user"] = <?php echo $message_template_admin_search->wa_type_user->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_wa_type_user"].options = <?php echo JsonEncode($message_template_admin_search->wa_type_user->lookupOptions()) ?>;
fmessage_template_adminsearch.lists["x_wa_status_office"] = <?php echo $message_template_admin_search->wa_status_office->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_wa_status_office"].options = <?php echo JsonEncode($message_template_admin_search->wa_status_office->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_wa_type_office"] = <?php echo $message_template_admin_search->wa_type_office->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_wa_type_office"].options = <?php echo JsonEncode($message_template_admin_search->wa_type_office->lookupOptions()) ?>;
fmessage_template_adminsearch.lists["x_wa_id"] = <?php echo $message_template_admin_search->wa_id->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_wa_id"].options = <?php echo JsonEncode($message_template_admin_search->wa_id->lookupOptions()) ?>;
fmessage_template_adminsearch.lists["x_notification_status_user"] = <?php echo $message_template_admin_search->notification_status_user->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_notification_status_user"].options = <?php echo JsonEncode($message_template_admin_search->notification_status_user->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_notification_status_office"] = <?php echo $message_template_admin_search->notification_status_office->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_notification_status_office"].options = <?php echo JsonEncode($message_template_admin_search->notification_status_office->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_notification_to_office[]"] = <?php echo $message_template_admin_search->notification_to_office->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_notification_to_office[]"].options = <?php echo JsonEncode($message_template_admin_search->notification_to_office->lookupOptions()) ?>;
fmessage_template_adminsearch.lists["x_visible"] = <?php echo $message_template_admin_search->visible->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_visible"].options = <?php echo JsonEncode($message_template_admin_search->visible->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_cron"] = <?php echo $message_template_admin_search->cron->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_cron"].options = <?php echo JsonEncode($message_template_admin_search->cron->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_delay_method"] = <?php echo $message_template_admin_search->delay_method->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_delay_method"].options = <?php echo JsonEncode($message_template_admin_search->delay_method->options(FALSE, TRUE)) ?>;
fmessage_template_adminsearch.lists["x_company_id"] = <?php echo $message_template_admin_search->company_id->Lookup->toClientList() ?>;
fmessage_template_adminsearch.lists["x_company_id"].options = <?php echo JsonEncode($message_template_admin_search->company_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fmessage_template_adminsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($message_template_admin->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_next_cycle");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($message_template_admin->next_cycle->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_delay");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($message_template_admin->delay->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($message_template_admin->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator_admin");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($message_template_admin->operator_admin->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime_admin");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($message_template_admin->datetime_admin->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $message_template_admin_search->showPageHeader(); ?>
<?php
$message_template_admin_search->showMessage();
?>
<form name="fmessage_template_adminsearch" id="fmessage_template_adminsearch" class="<?php echo $message_template_admin_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($message_template_admin_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $message_template_admin_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="message_template_admin">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$message_template_admin_search->IsModal ?>">
<?php if ($message_template_admin_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($message_template_admin->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_id"><?php echo $message_template_admin->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->id->cellAttributes() ?>>
			<span id="el_message_template_admin_id">
<input type="text" data-table="message_template_admin" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($message_template_admin->id->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->id->EditValue ?>"<?php echo $message_template_admin->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_grp"><?php echo $message_template_admin->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->grp->cellAttributes() ?>>
			<span id="el_message_template_admin_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_grp" data-page="0" data-value-separator="<?php echo $message_template_admin->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $message_template_admin->grp->editAttributes() ?>>
		<?php echo $message_template_admin->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $message_template_admin->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_description"><?php echo $message_template_admin->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->description->cellAttributes() ?>>
			<span id="el_message_template_admin_description">
<input type="text" data-table="message_template_admin" data-field="x_description" data-page="0" name="x_description" id="x_description" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($message_template_admin->description->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->description->EditValue ?>"<?php echo $message_template_admin->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->variables->Visible) { // variables ?>
	<div id="r_variables" class="form-group row">
		<label for="x_variables" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_variables"><?php echo $message_template_admin->variables->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_variables" id="z_variables" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->variables->cellAttributes() ?>>
			<span id="el_message_template_admin_variables">
<input type="text" data-table="message_template_admin" data-field="x_variables" data-page="0" name="x_variables" id="x_variables" maxlength="255" placeholder="<?php echo HtmlEncode($message_template_admin->variables->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->variables->EditValue ?>"<?php echo $message_template_admin->variables->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav-tabs" id="message_template_admin_search"><!-- multi-page tabs -->
	<ul class="<?php echo $message_template_admin_search->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $message_template_admin_search->MultiPages->pageStyle("1") ?>" href="#tab_message_template_admin1" data-toggle="tab"><?php echo $message_template_admin->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $message_template_admin_search->MultiPages->pageStyle("2") ?>" href="#tab_message_template_admin2" data-toggle="tab"><?php echo $message_template_admin->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $message_template_admin_search->MultiPages->pageStyle("3") ?>" href="#tab_message_template_admin3" data-toggle="tab"><?php echo $message_template_admin->pageCaption(3) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $message_template_admin_search->MultiPages->pageStyle("4") ?>" href="#tab_message_template_admin4" data-toggle="tab"><?php echo $message_template_admin->pageCaption(4) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $message_template_admin_search->MultiPages->pageStyle("5") ?>" href="#tab_message_template_admin5" data-toggle="tab"><?php echo $message_template_admin->pageCaption(5) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $message_template_admin_search->MultiPages->pageStyle("6") ?>" href="#tab_message_template_admin6" data-toggle="tab"><?php echo $message_template_admin->pageCaption(6) ?></a></li>
	</ul>
	<div class="tab-content"><!-- multi-page tabs .tab-content -->
		<div class="tab-pane<?php echo $message_template_admin_search->MultiPages->pageStyle("1") ?>" id="tab_message_template_admin1"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($message_template_admin->subject->Visible) { // subject ?>
	<div id="r_subject" class="form-group row">
		<label for="x_subject" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_subject"><?php echo $message_template_admin->subject->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_subject" id="z_subject" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->subject->cellAttributes() ?>>
			<span id="el_message_template_admin_subject">
<input type="text" data-table="message_template_admin" data-field="x_subject" data-page="1" name="x_subject" id="x_subject" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($message_template_admin->subject->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->subject->EditValue ?>"<?php echo $message_template_admin->subject->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->status_email_user->Visible) { // status_email_user ?>
	<div id="r_status_email_user" class="form-group row">
		<label for="x_status_email_user" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_status_email_user"><?php echo $message_template_admin->status_email_user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status_email_user" id="z_status_email_user" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->status_email_user->cellAttributes() ?>>
			<span id="el_message_template_admin_status_email_user">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_status_email_user" data-page="1" data-value-separator="<?php echo $message_template_admin->status_email_user->displayValueSeparatorAttribute() ?>" id="x_status_email_user" name="x_status_email_user"<?php echo $message_template_admin->status_email_user->editAttributes() ?>>
		<?php echo $message_template_admin->status_email_user->selectOptionListHtml("x_status_email_user") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->email_template_user->Visible) { // email_template_user ?>
	<div id="r_email_template_user" class="form-group row">
		<label class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_email_template_user"><?php echo $message_template_admin->email_template_user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_email_template_user" id="z_email_template_user" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->email_template_user->cellAttributes() ?>>
			<span id="el_message_template_admin_email_template_user">
<input type="text" data-table="message_template_admin" data-field="x_email_template_user" data-page="1" name="x_email_template_user" id="x_email_template_user" placeholder="<?php echo HtmlEncode($message_template_admin->email_template_user->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->email_template_user->EditValue ?>"<?php echo $message_template_admin->email_template_user->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->mail_to_office->Visible) { // mail_to_office ?>
	<div id="r_mail_to_office" class="form-group row">
		<label for="x_mail_to_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_mail_to_office"><?php echo $message_template_admin->mail_to_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mail_to_office" id="z_mail_to_office" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->mail_to_office->cellAttributes() ?>>
			<span id="el_message_template_admin_mail_to_office">
<input type="text" data-table="message_template_admin" data-field="x_mail_to_office" data-page="1" name="x_mail_to_office" id="x_mail_to_office" size="30" maxlength="196" placeholder="<?php echo HtmlEncode($message_template_admin->mail_to_office->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->mail_to_office->EditValue ?>"<?php echo $message_template_admin->mail_to_office->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->status_email_office->Visible) { // status_email_office ?>
	<div id="r_status_email_office" class="form-group row">
		<label for="x_status_email_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_status_email_office"><?php echo $message_template_admin->status_email_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status_email_office" id="z_status_email_office" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->status_email_office->cellAttributes() ?>>
			<span id="el_message_template_admin_status_email_office">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_status_email_office" data-page="1" data-value-separator="<?php echo $message_template_admin->status_email_office->displayValueSeparatorAttribute() ?>" id="x_status_email_office" name="x_status_email_office"<?php echo $message_template_admin->status_email_office->editAttributes() ?>>
		<?php echo $message_template_admin->status_email_office->selectOptionListHtml("x_status_email_office") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->email_template_office->Visible) { // email_template_office ?>
	<div id="r_email_template_office" class="form-group row">
		<label class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_email_template_office"><?php echo $message_template_admin->email_template_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_email_template_office" id="z_email_template_office" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->email_template_office->cellAttributes() ?>>
			<span id="el_message_template_admin_email_template_office">
<input type="text" data-table="message_template_admin" data-field="x_email_template_office" data-page="1" name="x_email_template_office" id="x_email_template_office" placeholder="<?php echo HtmlEncode($message_template_admin->email_template_office->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->email_template_office->EditValue ?>"<?php echo $message_template_admin->email_template_office->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_company_id"><?php echo $message_template_admin->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->company_id->cellAttributes() ?>>
			<span id="el_message_template_admin_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_company_id" data-page="1" data-value-separator="<?php echo $message_template_admin->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $message_template_admin->company_id->editAttributes() ?>>
		<?php echo $message_template_admin->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $message_template_admin->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $message_template_admin_search->MultiPages->pageStyle("2") ?>" id="tab_message_template_admin2"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($message_template_admin->status_sms_user->Visible) { // status_sms_user ?>
	<div id="r_status_sms_user" class="form-group row">
		<label for="x_status_sms_user" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_status_sms_user"><?php echo $message_template_admin->status_sms_user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status_sms_user" id="z_status_sms_user" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->status_sms_user->cellAttributes() ?>>
			<span id="el_message_template_admin_status_sms_user">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_status_sms_user" data-page="2" data-value-separator="<?php echo $message_template_admin->status_sms_user->displayValueSeparatorAttribute() ?>" id="x_status_sms_user" name="x_status_sms_user"<?php echo $message_template_admin->status_sms_user->editAttributes() ?>>
		<?php echo $message_template_admin->status_sms_user->selectOptionListHtml("x_status_sms_user") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->sms_template_user->Visible) { // sms_template_user ?>
	<div id="r_sms_template_user" class="form-group row">
		<label for="x_sms_template_user" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_template_user"><?php echo $message_template_admin->sms_template_user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sms_template_user" id="z_sms_template_user" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->sms_template_user->cellAttributes() ?>>
			<span id="el_message_template_admin_sms_template_user">
<input type="text" data-table="message_template_admin" data-field="x_sms_template_user" data-page="2" name="x_sms_template_user" id="x_sms_template_user" maxlength="250" placeholder="<?php echo HtmlEncode($message_template_admin->sms_template_user->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->sms_template_user->EditValue ?>"<?php echo $message_template_admin->sms_template_user->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->sms_template_user_id->Visible) { // sms_template_user_id ?>
	<div id="r_sms_template_user_id" class="form-group row">
		<label for="x_sms_template_user_id" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_template_user_id"><?php echo $message_template_admin->sms_template_user_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sms_template_user_id" id="z_sms_template_user_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->sms_template_user_id->cellAttributes() ?>>
			<span id="el_message_template_admin_sms_template_user_id">
<input type="text" data-table="message_template_admin" data-field="x_sms_template_user_id" data-page="2" name="x_sms_template_user_id" id="x_sms_template_user_id" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($message_template_admin->sms_template_user_id->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->sms_template_user_id->EditValue ?>"<?php echo $message_template_admin->sms_template_user_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->status_sms_office->Visible) { // status_sms_office ?>
	<div id="r_status_sms_office" class="form-group row">
		<label for="x_status_sms_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_status_sms_office"><?php echo $message_template_admin->status_sms_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status_sms_office" id="z_status_sms_office" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->status_sms_office->cellAttributes() ?>>
			<span id="el_message_template_admin_status_sms_office">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_status_sms_office" data-page="2" data-value-separator="<?php echo $message_template_admin->status_sms_office->displayValueSeparatorAttribute() ?>" id="x_status_sms_office" name="x_status_sms_office"<?php echo $message_template_admin->status_sms_office->editAttributes() ?>>
		<?php echo $message_template_admin->status_sms_office->selectOptionListHtml("x_status_sms_office") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->sms_to_office->Visible) { // sms_to_office ?>
	<div id="r_sms_to_office" class="form-group row">
		<label for="x_sms_to_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_to_office"><?php echo $message_template_admin->sms_to_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sms_to_office" id="z_sms_to_office" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->sms_to_office->cellAttributes() ?>>
			<span id="el_message_template_admin_sms_to_office">
<input type="text" data-table="message_template_admin" data-field="x_sms_to_office" data-page="2" name="x_sms_to_office" id="x_sms_to_office" size="30" maxlength="44" placeholder="<?php echo HtmlEncode($message_template_admin->sms_to_office->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->sms_to_office->EditValue ?>"<?php echo $message_template_admin->sms_to_office->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->sms_template_office->Visible) { // sms_template_office ?>
	<div id="r_sms_template_office" class="form-group row">
		<label for="x_sms_template_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_template_office"><?php echo $message_template_admin->sms_template_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sms_template_office" id="z_sms_template_office" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->sms_template_office->cellAttributes() ?>>
			<span id="el_message_template_admin_sms_template_office">
<input type="text" data-table="message_template_admin" data-field="x_sms_template_office" data-page="2" name="x_sms_template_office" id="x_sms_template_office" maxlength="250" placeholder="<?php echo HtmlEncode($message_template_admin->sms_template_office->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->sms_template_office->EditValue ?>"<?php echo $message_template_admin->sms_template_office->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->sms_template_office_id->Visible) { // sms_template_office_id ?>
	<div id="r_sms_template_office_id" class="form-group row">
		<label for="x_sms_template_office_id" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_sms_template_office_id"><?php echo $message_template_admin->sms_template_office_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sms_template_office_id" id="z_sms_template_office_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->sms_template_office_id->cellAttributes() ?>>
			<span id="el_message_template_admin_sms_template_office_id">
<input type="text" data-table="message_template_admin" data-field="x_sms_template_office_id" data-page="2" name="x_sms_template_office_id" id="x_sms_template_office_id" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($message_template_admin->sms_template_office_id->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->sms_template_office_id->EditValue ?>"<?php echo $message_template_admin->sms_template_office_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $message_template_admin_search->MultiPages->pageStyle("3") ?>" id="tab_message_template_admin3"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($message_template_admin->notification_status_user->Visible) { // notification_status_user ?>
	<div id="r_notification_status_user" class="form-group row">
		<label for="x_notification_status_user" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_status_user"><?php echo $message_template_admin->notification_status_user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_notification_status_user" id="z_notification_status_user" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->notification_status_user->cellAttributes() ?>>
			<span id="el_message_template_admin_notification_status_user">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_notification_status_user" data-page="3" data-value-separator="<?php echo $message_template_admin->notification_status_user->displayValueSeparatorAttribute() ?>" id="x_notification_status_user" name="x_notification_status_user"<?php echo $message_template_admin->notification_status_user->editAttributes() ?>>
		<?php echo $message_template_admin->notification_status_user->selectOptionListHtml("x_notification_status_user") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->notification_template_user->Visible) { // notification_template_user ?>
	<div id="r_notification_template_user" class="form-group row">
		<label for="x_notification_template_user" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_template_user"><?php echo $message_template_admin->notification_template_user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_notification_template_user" id="z_notification_template_user" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->notification_template_user->cellAttributes() ?>>
			<span id="el_message_template_admin_notification_template_user">
<input type="text" data-table="message_template_admin" data-field="x_notification_template_user" data-page="3" name="x_notification_template_user" id="x_notification_template_user" maxlength="255" placeholder="<?php echo HtmlEncode($message_template_admin->notification_template_user->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->notification_template_user->EditValue ?>"<?php echo $message_template_admin->notification_template_user->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->notification_status_office->Visible) { // notification_status_office ?>
	<div id="r_notification_status_office" class="form-group row">
		<label for="x_notification_status_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_status_office"><?php echo $message_template_admin->notification_status_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_notification_status_office" id="z_notification_status_office" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->notification_status_office->cellAttributes() ?>>
			<span id="el_message_template_admin_notification_status_office">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_notification_status_office" data-page="3" data-value-separator="<?php echo $message_template_admin->notification_status_office->displayValueSeparatorAttribute() ?>" id="x_notification_status_office" name="x_notification_status_office"<?php echo $message_template_admin->notification_status_office->editAttributes() ?>>
		<?php echo $message_template_admin->notification_status_office->selectOptionListHtml("x_notification_status_office") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->notification_to_office->Visible) { // notification_to_office ?>
	<div id="r_notification_to_office" class="form-group row">
		<label for="x_notification_to_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_to_office"><?php echo $message_template_admin->notification_to_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_notification_to_office" id="z_notification_to_office" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->notification_to_office->cellAttributes() ?>>
			<span id="el_message_template_admin_notification_to_office">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_notification_to_office" data-page="3" data-value-separator="<?php echo $message_template_admin->notification_to_office->displayValueSeparatorAttribute() ?>" id="x_notification_to_office[]" name="x_notification_to_office[]" multiple="multiple"<?php echo $message_template_admin->notification_to_office->editAttributes() ?>>
		<?php echo $message_template_admin->notification_to_office->selectOptionListHtml("x_notification_to_office[]") ?>
	</select>
</div>
<?php echo $message_template_admin->notification_to_office->Lookup->getParamTag("p_x_notification_to_office") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->notification_template_office->Visible) { // notification_template_office ?>
	<div id="r_notification_template_office" class="form-group row">
		<label for="x_notification_template_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_notification_template_office"><?php echo $message_template_admin->notification_template_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_notification_template_office" id="z_notification_template_office" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->notification_template_office->cellAttributes() ?>>
			<span id="el_message_template_admin_notification_template_office">
<input type="text" data-table="message_template_admin" data-field="x_notification_template_office" data-page="3" name="x_notification_template_office" id="x_notification_template_office" maxlength="255" placeholder="<?php echo HtmlEncode($message_template_admin->notification_template_office->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->notification_template_office->EditValue ?>"<?php echo $message_template_admin->notification_template_office->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $message_template_admin_search->MultiPages->pageStyle("4") ?>" id="tab_message_template_admin4"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($message_template_admin->wa_status_user->Visible) { // wa_status_user ?>
	<div id="r_wa_status_user" class="form-group row">
		<label for="x_wa_status_user" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_status_user"><?php echo $message_template_admin->wa_status_user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_wa_status_user" id="z_wa_status_user" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->wa_status_user->cellAttributes() ?>>
			<span id="el_message_template_admin_wa_status_user">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_wa_status_user" data-page="4" data-value-separator="<?php echo $message_template_admin->wa_status_user->displayValueSeparatorAttribute() ?>" id="x_wa_status_user" name="x_wa_status_user"<?php echo $message_template_admin->wa_status_user->editAttributes() ?>>
		<?php echo $message_template_admin->wa_status_user->selectOptionListHtml("x_wa_status_user") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->wa_type_user->Visible) { // wa_type_user ?>
	<div id="r_wa_type_user" class="form-group row">
		<label for="x_wa_type_user" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_type_user"><?php echo $message_template_admin->wa_type_user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_wa_type_user" id="z_wa_type_user" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->wa_type_user->cellAttributes() ?>>
			<span id="el_message_template_admin_wa_type_user">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_wa_type_user" data-page="4" data-value-separator="<?php echo $message_template_admin->wa_type_user->displayValueSeparatorAttribute() ?>" id="x_wa_type_user" name="x_wa_type_user"<?php echo $message_template_admin->wa_type_user->editAttributes() ?>>
		<?php echo $message_template_admin->wa_type_user->selectOptionListHtml("x_wa_type_user") ?>
	</select>
</div>
<?php echo $message_template_admin->wa_type_user->Lookup->getParamTag("p_x_wa_type_user") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->wa_template_user->Visible) { // wa_template_user ?>
	<div id="r_wa_template_user" class="form-group row">
		<label for="x_wa_template_user" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_template_user"><?php echo $message_template_admin->wa_template_user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_wa_template_user" id="z_wa_template_user" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->wa_template_user->cellAttributes() ?>>
			<span id="el_message_template_admin_wa_template_user">
<input type="text" data-table="message_template_admin" data-field="x_wa_template_user" data-page="4" name="x_wa_template_user" id="x_wa_template_user" size="35" placeholder="<?php echo HtmlEncode($message_template_admin->wa_template_user->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->wa_template_user->EditValue ?>"<?php echo $message_template_admin->wa_template_user->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->wa_status_office->Visible) { // wa_status_office ?>
	<div id="r_wa_status_office" class="form-group row">
		<label for="x_wa_status_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_status_office"><?php echo $message_template_admin->wa_status_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_wa_status_office" id="z_wa_status_office" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->wa_status_office->cellAttributes() ?>>
			<span id="el_message_template_admin_wa_status_office">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_wa_status_office" data-page="4" data-value-separator="<?php echo $message_template_admin->wa_status_office->displayValueSeparatorAttribute() ?>" id="x_wa_status_office" name="x_wa_status_office"<?php echo $message_template_admin->wa_status_office->editAttributes() ?>>
		<?php echo $message_template_admin->wa_status_office->selectOptionListHtml("x_wa_status_office") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->wa_type_office->Visible) { // wa_type_office ?>
	<div id="r_wa_type_office" class="form-group row">
		<label for="x_wa_type_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_type_office"><?php echo $message_template_admin->wa_type_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_wa_type_office" id="z_wa_type_office" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->wa_type_office->cellAttributes() ?>>
			<span id="el_message_template_admin_wa_type_office">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_wa_type_office" data-page="4" data-value-separator="<?php echo $message_template_admin->wa_type_office->displayValueSeparatorAttribute() ?>" id="x_wa_type_office" name="x_wa_type_office"<?php echo $message_template_admin->wa_type_office->editAttributes() ?>>
		<?php echo $message_template_admin->wa_type_office->selectOptionListHtml("x_wa_type_office") ?>
	</select>
</div>
<?php echo $message_template_admin->wa_type_office->Lookup->getParamTag("p_x_wa_type_office") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->wa_to_office->Visible) { // wa_to_office ?>
	<div id="r_wa_to_office" class="form-group row">
		<label for="x_wa_to_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_to_office"><?php echo $message_template_admin->wa_to_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_wa_to_office" id="z_wa_to_office" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->wa_to_office->cellAttributes() ?>>
			<span id="el_message_template_admin_wa_to_office">
<input type="text" data-table="message_template_admin" data-field="x_wa_to_office" data-page="4" name="x_wa_to_office" id="x_wa_to_office" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($message_template_admin->wa_to_office->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->wa_to_office->EditValue ?>"<?php echo $message_template_admin->wa_to_office->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->wa_template_office->Visible) { // wa_template_office ?>
	<div id="r_wa_template_office" class="form-group row">
		<label for="x_wa_template_office" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_template_office"><?php echo $message_template_admin->wa_template_office->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_wa_template_office" id="z_wa_template_office" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->wa_template_office->cellAttributes() ?>>
			<span id="el_message_template_admin_wa_template_office">
<input type="text" data-table="message_template_admin" data-field="x_wa_template_office" data-page="4" name="x_wa_template_office" id="x_wa_template_office" size="35" placeholder="<?php echo HtmlEncode($message_template_admin->wa_template_office->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->wa_template_office->EditValue ?>"<?php echo $message_template_admin->wa_template_office->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->wa_id->Visible) { // wa_id ?>
	<div id="r_wa_id" class="form-group row">
		<label for="x_wa_id" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_wa_id"><?php echo $message_template_admin->wa_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_wa_id" id="z_wa_id" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->wa_id->cellAttributes() ?>>
			<span id="el_message_template_admin_wa_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_wa_id" data-page="4" data-value-separator="<?php echo $message_template_admin->wa_id->displayValueSeparatorAttribute() ?>" id="x_wa_id" name="x_wa_id"<?php echo $message_template_admin->wa_id->editAttributes() ?>>
		<?php echo $message_template_admin->wa_id->selectOptionListHtml("x_wa_id") ?>
	</select>
</div>
<?php echo $message_template_admin->wa_id->Lookup->getParamTag("p_x_wa_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $message_template_admin_search->MultiPages->pageStyle("5") ?>" id="tab_message_template_admin5"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($message_template_admin->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_code"><?php echo $message_template_admin->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->code->cellAttributes() ?>>
			<span id="el_message_template_admin_code">
<input type="text" data-table="message_template_admin" data-field="x_code" data-page="5" name="x_code" id="x_code" size="35" placeholder="<?php echo HtmlEncode($message_template_admin->code->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->code->EditValue ?>"<?php echo $message_template_admin->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $message_template_admin_search->MultiPages->pageStyle("6") ?>" id="tab_message_template_admin6"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($message_template_admin->visible->Visible) { // visible ?>
	<div id="r_visible" class="form-group row">
		<label for="x_visible" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_visible"><?php echo $message_template_admin->visible->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_visible" id="z_visible" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->visible->cellAttributes() ?>>
			<span id="el_message_template_admin_visible">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_visible" data-page="6" data-value-separator="<?php echo $message_template_admin->visible->displayValueSeparatorAttribute() ?>" id="x_visible" name="x_visible"<?php echo $message_template_admin->visible->editAttributes() ?>>
		<?php echo $message_template_admin->visible->selectOptionListHtml("x_visible") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->cron->Visible) { // cron ?>
	<div id="r_cron" class="form-group row">
		<label for="x_cron" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_cron"><?php echo $message_template_admin->cron->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cron" id="z_cron" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->cron->cellAttributes() ?>>
			<span id="el_message_template_admin_cron">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_cron" data-page="6" data-value-separator="<?php echo $message_template_admin->cron->displayValueSeparatorAttribute() ?>" id="x_cron" name="x_cron"<?php echo $message_template_admin->cron->editAttributes() ?>>
		<?php echo $message_template_admin->cron->selectOptionListHtml("x_cron") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->next_cycle->Visible) { // next_cycle ?>
	<div id="r_next_cycle" class="form-group row">
		<label for="x_next_cycle" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_next_cycle"><?php echo $message_template_admin->next_cycle->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_cycle" id="z_next_cycle" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->next_cycle->cellAttributes() ?>>
			<span id="el_message_template_admin_next_cycle">
<input type="text" data-table="message_template_admin" data-field="x_next_cycle" data-page="6" data-format="11" name="x_next_cycle" id="x_next_cycle" placeholder="<?php echo HtmlEncode($message_template_admin->next_cycle->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->next_cycle->EditValue ?>"<?php echo $message_template_admin->next_cycle->editAttributes() ?>>
<?php if (!$message_template_admin->next_cycle->ReadOnly && !$message_template_admin->next_cycle->Disabled && !isset($message_template_admin->next_cycle->EditAttrs["readonly"]) && !isset($message_template_admin->next_cycle->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmessage_template_adminsearch", "x_next_cycle", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->delay->Visible) { // delay ?>
	<div id="r_delay" class="form-group row">
		<label for="x_delay" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_delay"><?php echo $message_template_admin->delay->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delay" id="z_delay" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->delay->cellAttributes() ?>>
			<span id="el_message_template_admin_delay">
<input type="text" data-table="message_template_admin" data-field="x_delay" data-page="6" name="x_delay" id="x_delay" size="30" placeholder="<?php echo HtmlEncode($message_template_admin->delay->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->delay->EditValue ?>"<?php echo $message_template_admin->delay->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->delay_method->Visible) { // delay_method ?>
	<div id="r_delay_method" class="form-group row">
		<label for="x_delay_method" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_delay_method"><?php echo $message_template_admin->delay_method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delay_method" id="z_delay_method" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->delay_method->cellAttributes() ?>>
			<span id="el_message_template_admin_delay_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="message_template_admin" data-field="x_delay_method" data-page="6" data-value-separator="<?php echo $message_template_admin->delay_method->displayValueSeparatorAttribute() ?>" id="x_delay_method" name="x_delay_method"<?php echo $message_template_admin->delay_method->editAttributes() ?>>
		<?php echo $message_template_admin->delay_method->selectOptionListHtml("x_delay_method") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_operator"><?php echo $message_template_admin->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->operator->cellAttributes() ?>>
			<span id="el_message_template_admin_operator">
<input type="text" data-table="message_template_admin" data-field="x_operator" data-page="6" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($message_template_admin->operator->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->operator->EditValue ?>"<?php echo $message_template_admin->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_datetime"><?php echo $message_template_admin->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->datetime->cellAttributes() ?>>
			<span id="el_message_template_admin_datetime">
<input type="text" data-table="message_template_admin" data-field="x_datetime" data-page="6" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($message_template_admin->datetime->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->datetime->EditValue ?>"<?php echo $message_template_admin->datetime->editAttributes() ?>>
<?php if (!$message_template_admin->datetime->ReadOnly && !$message_template_admin->datetime->Disabled && !isset($message_template_admin->datetime->EditAttrs["readonly"]) && !isset($message_template_admin->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fmessage_template_adminsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->operator_admin->Visible) { // operator_admin ?>
	<div id="r_operator_admin" class="form-group row">
		<label for="x_operator_admin" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_operator_admin"><?php echo $message_template_admin->operator_admin->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator_admin" id="z_operator_admin" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->operator_admin->cellAttributes() ?>>
			<span id="el_message_template_admin_operator_admin">
<input type="text" data-table="message_template_admin" data-field="x_operator_admin" data-page="6" name="x_operator_admin" id="x_operator_admin" size="30" placeholder="<?php echo HtmlEncode($message_template_admin->operator_admin->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->operator_admin->EditValue ?>"<?php echo $message_template_admin->operator_admin->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($message_template_admin->datetime_admin->Visible) { // datetime_admin ?>
	<div id="r_datetime_admin" class="form-group row">
		<label for="x_datetime_admin" class="<?php echo $message_template_admin_search->LeftColumnClass ?>"><span id="elh_message_template_admin_datetime_admin"><?php echo $message_template_admin->datetime_admin->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime_admin" id="z_datetime_admin" value="="></span>
		</label>
		<div class="<?php echo $message_template_admin_search->RightColumnClass ?>"><div<?php echo $message_template_admin->datetime_admin->cellAttributes() ?>>
			<span id="el_message_template_admin_datetime_admin">
<input type="text" data-table="message_template_admin" data-field="x_datetime_admin" data-page="6" name="x_datetime_admin" id="x_datetime_admin" placeholder="<?php echo HtmlEncode($message_template_admin->datetime_admin->getPlaceHolder()) ?>" value="<?php echo $message_template_admin->datetime_admin->EditValue ?>"<?php echo $message_template_admin->datetime_admin->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
	</div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?php if (!$message_template_admin_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $message_template_admin_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$message_template_admin_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$message_template_admin_search->terminate();
?>