<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$message_template_office_list = new message_template_office_list();

// Run the page
$message_template_office_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$message_template_office_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$message_template_office->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmessage_template_officelist = currentForm = new ew.Form("fmessage_template_officelist", "list");
fmessage_template_officelist.formKeyCountName = '<?php echo $message_template_office_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmessage_template_officelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmessage_template_officelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmessage_template_officelist.lists["x_status_email_user"] = <?php echo $message_template_office_list->status_email_user->Lookup->toClientList() ?>;
fmessage_template_officelist.lists["x_status_email_user"].options = <?php echo JsonEncode($message_template_office_list->status_email_user->options(FALSE, TRUE)) ?>;
fmessage_template_officelist.lists["x_status_email_office"] = <?php echo $message_template_office_list->status_email_office->Lookup->toClientList() ?>;
fmessage_template_officelist.lists["x_status_email_office"].options = <?php echo JsonEncode($message_template_office_list->status_email_office->options(FALSE, TRUE)) ?>;
fmessage_template_officelist.lists["x_status_sms_user"] = <?php echo $message_template_office_list->status_sms_user->Lookup->toClientList() ?>;
fmessage_template_officelist.lists["x_status_sms_user"].options = <?php echo JsonEncode($message_template_office_list->status_sms_user->options(FALSE, TRUE)) ?>;
fmessage_template_officelist.lists["x_status_sms_office"] = <?php echo $message_template_office_list->status_sms_office->Lookup->toClientList() ?>;
fmessage_template_officelist.lists["x_status_sms_office"].options = <?php echo JsonEncode($message_template_office_list->status_sms_office->options(FALSE, TRUE)) ?>;
fmessage_template_officelist.lists["x_wa_status_user"] = <?php echo $message_template_office_list->wa_status_user->Lookup->toClientList() ?>;
fmessage_template_officelist.lists["x_wa_status_user"].options = <?php echo JsonEncode($message_template_office_list->wa_status_user->options(FALSE, TRUE)) ?>;
fmessage_template_officelist.lists["x_wa_type_user"] = <?php echo $message_template_office_list->wa_type_user->Lookup->toClientList() ?>;
fmessage_template_officelist.lists["x_wa_type_user"].options = <?php echo JsonEncode($message_template_office_list->wa_type_user->lookupOptions()) ?>;
fmessage_template_officelist.lists["x_wa_status_office"] = <?php echo $message_template_office_list->wa_status_office->Lookup->toClientList() ?>;
fmessage_template_officelist.lists["x_wa_status_office"].options = <?php echo JsonEncode($message_template_office_list->wa_status_office->options(FALSE, TRUE)) ?>;
fmessage_template_officelist.lists["x_wa_type_office"] = <?php echo $message_template_office_list->wa_type_office->Lookup->toClientList() ?>;
fmessage_template_officelist.lists["x_wa_type_office"].options = <?php echo JsonEncode($message_template_office_list->wa_type_office->lookupOptions()) ?>;
fmessage_template_officelist.lists["x_wa_id"] = <?php echo $message_template_office_list->wa_id->Lookup->toClientList() ?>;
fmessage_template_officelist.lists["x_wa_id"].options = <?php echo JsonEncode($message_template_office_list->wa_id->lookupOptions()) ?>;

// Form object for search
var fmessage_template_officelistsrch = currentSearchForm = new ew.Form("fmessage_template_officelistsrch");

// Validate function for search
fmessage_template_officelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($message_template_office->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fmessage_template_officelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmessage_template_officelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fmessage_template_officelistsrch.filterList = <?php echo $message_template_office_list->getFilterList() ?>;

// Init search panel as collapsed
fmessage_template_officelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$message_template_office->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($message_template_office_list->TotalRecs > 0 && $message_template_office_list->ExportOptions->visible()) { ?>
<?php $message_template_office_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($message_template_office_list->ImportOptions->visible()) { ?>
<?php $message_template_office_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($message_template_office_list->SearchOptions->visible()) { ?>
<?php $message_template_office_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($message_template_office_list->FilterOptions->visible()) { ?>
<?php $message_template_office_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$message_template_office_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$message_template_office->isExport() && !$message_template_office->CurrentAction) { ?>
<form name="fmessage_template_officelistsrch" id="fmessage_template_officelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($message_template_office_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmessage_template_officelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="message_template_office">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$message_template_office_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$message_template_office->RowType = ROWTYPE_SEARCH;

// Render row
$message_template_office->resetAttributes();
$message_template_office_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($message_template_office->id->Visible) { // id ?>
	<div id="xsc_id" class="ew-cell form-group">
		<label for="x_id" class="ew-search-caption ew-label"><?php echo $message_template_office->id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="message_template_office" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($message_template_office->id->getPlaceHolder()) ?>" value="<?php echo $message_template_office->id->EditValue ?>"<?php echo $message_template_office->id->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($message_template_office_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($message_template_office_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $message_template_office_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($message_template_office_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($message_template_office_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($message_template_office_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($message_template_office_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $message_template_office_list->showPageHeader(); ?>
<?php
$message_template_office_list->showMessage();
?>
<?php if ($message_template_office_list->TotalRecs > 0 || $message_template_office->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($message_template_office_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> message_template_office">
<?php if (!$message_template_office->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$message_template_office->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($message_template_office_list->Pager)) $message_template_office_list->Pager = new PrevNextPager($message_template_office_list->StartRec, $message_template_office_list->DisplayRecs, $message_template_office_list->TotalRecs, $message_template_office_list->AutoHidePager) ?>
<?php if ($message_template_office_list->Pager->RecordCount > 0 && $message_template_office_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($message_template_office_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $message_template_office_list->pageUrl() ?>start=<?php echo $message_template_office_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($message_template_office_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $message_template_office_list->pageUrl() ?>start=<?php echo $message_template_office_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $message_template_office_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($message_template_office_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $message_template_office_list->pageUrl() ?>start=<?php echo $message_template_office_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($message_template_office_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $message_template_office_list->pageUrl() ?>start=<?php echo $message_template_office_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $message_template_office_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($message_template_office_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $message_template_office_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $message_template_office_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $message_template_office_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($message_template_office_list->TotalRecs > 0 && (!$message_template_office_list->AutoHidePageSizeSelector || $message_template_office_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="message_template_office">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($message_template_office_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($message_template_office_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($message_template_office_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($message_template_office_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($message_template_office_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($message_template_office->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $message_template_office_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmessage_template_officelist" id="fmessage_template_officelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($message_template_office_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $message_template_office_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="message_template_office">
<div id="gmp_message_template_office" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($message_template_office_list->TotalRecs > 0 || $message_template_office->isGridEdit()) { ?>
<table id="tbl_message_template_officelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$message_template_office_list->RowType = ROWTYPE_HEADER;

// Render list options
$message_template_office_list->renderListOptions();

// Render list options (header, left)
$message_template_office_list->ListOptions->render("header", "left");
?>
<?php if ($message_template_office->id->Visible) { // id ?>
	<?php if ($message_template_office->sortUrl($message_template_office->id) == "") { ?>
		<th data-name="id" class="<?php echo $message_template_office->id->headerCellClass() ?>"><div id="elh_message_template_office_id" class="message_template_office_id"><div class="ew-table-header-caption"><?php echo $message_template_office->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $message_template_office->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->id) ?>',2);"><div id="elh_message_template_office_id" class="message_template_office_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->description->Visible) { // description ?>
	<?php if ($message_template_office->sortUrl($message_template_office->description) == "") { ?>
		<th data-name="description" class="<?php echo $message_template_office->description->headerCellClass() ?>"><div id="elh_message_template_office_description" class="message_template_office_description"><div class="ew-table-header-caption"><?php echo $message_template_office->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $message_template_office->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->description) ?>',2);"><div id="elh_message_template_office_description" class="message_template_office_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->status_email_user->Visible) { // status_email_user ?>
	<?php if ($message_template_office->sortUrl($message_template_office->status_email_user) == "") { ?>
		<th data-name="status_email_user" class="<?php echo $message_template_office->status_email_user->headerCellClass() ?>"><div id="elh_message_template_office_status_email_user" class="message_template_office_status_email_user"><div class="ew-table-header-caption"><?php echo $message_template_office->status_email_user->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_email_user" class="<?php echo $message_template_office->status_email_user->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->status_email_user) ?>',2);"><div id="elh_message_template_office_status_email_user" class="message_template_office_status_email_user">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->status_email_user->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->status_email_user->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->status_email_user->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->status_email_office->Visible) { // status_email_office ?>
	<?php if ($message_template_office->sortUrl($message_template_office->status_email_office) == "") { ?>
		<th data-name="status_email_office" class="<?php echo $message_template_office->status_email_office->headerCellClass() ?>"><div id="elh_message_template_office_status_email_office" class="message_template_office_status_email_office"><div class="ew-table-header-caption"><?php echo $message_template_office->status_email_office->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_email_office" class="<?php echo $message_template_office->status_email_office->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->status_email_office) ?>',2);"><div id="elh_message_template_office_status_email_office" class="message_template_office_status_email_office">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->status_email_office->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->status_email_office->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->status_email_office->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->status_sms_user->Visible) { // status_sms_user ?>
	<?php if ($message_template_office->sortUrl($message_template_office->status_sms_user) == "") { ?>
		<th data-name="status_sms_user" class="<?php echo $message_template_office->status_sms_user->headerCellClass() ?>"><div id="elh_message_template_office_status_sms_user" class="message_template_office_status_sms_user"><div class="ew-table-header-caption"><?php echo $message_template_office->status_sms_user->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_sms_user" class="<?php echo $message_template_office->status_sms_user->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->status_sms_user) ?>',2);"><div id="elh_message_template_office_status_sms_user" class="message_template_office_status_sms_user">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->status_sms_user->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->status_sms_user->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->status_sms_user->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->sms_template_user_id->Visible) { // sms_template_user_id ?>
	<?php if ($message_template_office->sortUrl($message_template_office->sms_template_user_id) == "") { ?>
		<th data-name="sms_template_user_id" class="<?php echo $message_template_office->sms_template_user_id->headerCellClass() ?>"><div id="elh_message_template_office_sms_template_user_id" class="message_template_office_sms_template_user_id"><div class="ew-table-header-caption"><?php echo $message_template_office->sms_template_user_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sms_template_user_id" class="<?php echo $message_template_office->sms_template_user_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->sms_template_user_id) ?>',2);"><div id="elh_message_template_office_sms_template_user_id" class="message_template_office_sms_template_user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->sms_template_user_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->sms_template_user_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->sms_template_user_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->status_sms_office->Visible) { // status_sms_office ?>
	<?php if ($message_template_office->sortUrl($message_template_office->status_sms_office) == "") { ?>
		<th data-name="status_sms_office" class="<?php echo $message_template_office->status_sms_office->headerCellClass() ?>"><div id="elh_message_template_office_status_sms_office" class="message_template_office_status_sms_office"><div class="ew-table-header-caption"><?php echo $message_template_office->status_sms_office->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_sms_office" class="<?php echo $message_template_office->status_sms_office->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->status_sms_office) ?>',2);"><div id="elh_message_template_office_status_sms_office" class="message_template_office_status_sms_office">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->status_sms_office->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->status_sms_office->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->status_sms_office->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->sms_template_office_id->Visible) { // sms_template_office_id ?>
	<?php if ($message_template_office->sortUrl($message_template_office->sms_template_office_id) == "") { ?>
		<th data-name="sms_template_office_id" class="<?php echo $message_template_office->sms_template_office_id->headerCellClass() ?>"><div id="elh_message_template_office_sms_template_office_id" class="message_template_office_sms_template_office_id"><div class="ew-table-header-caption"><?php echo $message_template_office->sms_template_office_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sms_template_office_id" class="<?php echo $message_template_office->sms_template_office_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->sms_template_office_id) ?>',2);"><div id="elh_message_template_office_sms_template_office_id" class="message_template_office_sms_template_office_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->sms_template_office_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->sms_template_office_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->sms_template_office_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->wa_status_user->Visible) { // wa_status_user ?>
	<?php if ($message_template_office->sortUrl($message_template_office->wa_status_user) == "") { ?>
		<th data-name="wa_status_user" class="<?php echo $message_template_office->wa_status_user->headerCellClass() ?>"><div id="elh_message_template_office_wa_status_user" class="message_template_office_wa_status_user"><div class="ew-table-header-caption"><?php echo $message_template_office->wa_status_user->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="wa_status_user" class="<?php echo $message_template_office->wa_status_user->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->wa_status_user) ?>',2);"><div id="elh_message_template_office_wa_status_user" class="message_template_office_wa_status_user">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->wa_status_user->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->wa_status_user->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->wa_status_user->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->wa_type_user->Visible) { // wa_type_user ?>
	<?php if ($message_template_office->sortUrl($message_template_office->wa_type_user) == "") { ?>
		<th data-name="wa_type_user" class="<?php echo $message_template_office->wa_type_user->headerCellClass() ?>"><div id="elh_message_template_office_wa_type_user" class="message_template_office_wa_type_user"><div class="ew-table-header-caption"><?php echo $message_template_office->wa_type_user->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="wa_type_user" class="<?php echo $message_template_office->wa_type_user->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->wa_type_user) ?>',2);"><div id="elh_message_template_office_wa_type_user" class="message_template_office_wa_type_user">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->wa_type_user->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->wa_type_user->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->wa_type_user->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->wa_status_office->Visible) { // wa_status_office ?>
	<?php if ($message_template_office->sortUrl($message_template_office->wa_status_office) == "") { ?>
		<th data-name="wa_status_office" class="<?php echo $message_template_office->wa_status_office->headerCellClass() ?>"><div id="elh_message_template_office_wa_status_office" class="message_template_office_wa_status_office"><div class="ew-table-header-caption"><?php echo $message_template_office->wa_status_office->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="wa_status_office" class="<?php echo $message_template_office->wa_status_office->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->wa_status_office) ?>',2);"><div id="elh_message_template_office_wa_status_office" class="message_template_office_wa_status_office">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->wa_status_office->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->wa_status_office->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->wa_status_office->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->wa_type_office->Visible) { // wa_type_office ?>
	<?php if ($message_template_office->sortUrl($message_template_office->wa_type_office) == "") { ?>
		<th data-name="wa_type_office" class="<?php echo $message_template_office->wa_type_office->headerCellClass() ?>"><div id="elh_message_template_office_wa_type_office" class="message_template_office_wa_type_office"><div class="ew-table-header-caption"><?php echo $message_template_office->wa_type_office->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="wa_type_office" class="<?php echo $message_template_office->wa_type_office->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->wa_type_office) ?>',2);"><div id="elh_message_template_office_wa_type_office" class="message_template_office_wa_type_office">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->wa_type_office->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->wa_type_office->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->wa_type_office->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->wa_to_office->Visible) { // wa_to_office ?>
	<?php if ($message_template_office->sortUrl($message_template_office->wa_to_office) == "") { ?>
		<th data-name="wa_to_office" class="<?php echo $message_template_office->wa_to_office->headerCellClass() ?>"><div id="elh_message_template_office_wa_to_office" class="message_template_office_wa_to_office"><div class="ew-table-header-caption"><?php echo $message_template_office->wa_to_office->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="wa_to_office" class="<?php echo $message_template_office->wa_to_office->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->wa_to_office) ?>',2);"><div id="elh_message_template_office_wa_to_office" class="message_template_office_wa_to_office">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->wa_to_office->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->wa_to_office->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->wa_to_office->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_template_office->wa_id->Visible) { // wa_id ?>
	<?php if ($message_template_office->sortUrl($message_template_office->wa_id) == "") { ?>
		<th data-name="wa_id" class="<?php echo $message_template_office->wa_id->headerCellClass() ?>"><div id="elh_message_template_office_wa_id" class="message_template_office_wa_id"><div class="ew-table-header-caption"><?php echo $message_template_office->wa_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="wa_id" class="<?php echo $message_template_office->wa_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_template_office->SortUrl($message_template_office->wa_id) ?>',2);"><div id="elh_message_template_office_wa_id" class="message_template_office_wa_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_template_office->wa_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_template_office->wa_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_template_office->wa_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$message_template_office_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($message_template_office->ExportAll && $message_template_office->isExport()) {
	$message_template_office_list->StopRec = $message_template_office_list->TotalRecs;
} else {

	// Set the last record to display
	if ($message_template_office_list->TotalRecs > $message_template_office_list->StartRec + $message_template_office_list->DisplayRecs - 1)
		$message_template_office_list->StopRec = $message_template_office_list->StartRec + $message_template_office_list->DisplayRecs - 1;
	else
		$message_template_office_list->StopRec = $message_template_office_list->TotalRecs;
}
$message_template_office_list->RecCnt = $message_template_office_list->StartRec - 1;
if ($message_template_office_list->Recordset && !$message_template_office_list->Recordset->EOF) {
	$message_template_office_list->Recordset->moveFirst();
	$selectLimit = $message_template_office_list->UseSelectLimit;
	if (!$selectLimit && $message_template_office_list->StartRec > 1)
		$message_template_office_list->Recordset->move($message_template_office_list->StartRec - 1);
} elseif (!$message_template_office->AllowAddDeleteRow && $message_template_office_list->StopRec == 0) {
	$message_template_office_list->StopRec = $message_template_office->GridAddRowCount;
}

// Initialize aggregate
$message_template_office->RowType = ROWTYPE_AGGREGATEINIT;
$message_template_office->resetAttributes();
$message_template_office_list->renderRow();
while ($message_template_office_list->RecCnt < $message_template_office_list->StopRec) {
	$message_template_office_list->RecCnt++;
	if ($message_template_office_list->RecCnt >= $message_template_office_list->StartRec) {
		$message_template_office_list->RowCnt++;

		// Set up key count
		$message_template_office_list->KeyCount = $message_template_office_list->RowIndex;

		// Init row class and style
		$message_template_office->resetAttributes();
		$message_template_office->CssClass = "";
		if ($message_template_office->isGridAdd()) {
		} else {
			$message_template_office_list->loadRowValues($message_template_office_list->Recordset); // Load row values
		}
		$message_template_office->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$message_template_office->RowAttrs = array_merge($message_template_office->RowAttrs, array('data-rowindex'=>$message_template_office_list->RowCnt, 'id'=>'r' . $message_template_office_list->RowCnt . '_message_template_office', 'data-rowtype'=>$message_template_office->RowType));

		// Render row
		$message_template_office_list->renderRow();

		// Render list options
		$message_template_office_list->renderListOptions();
?>
	<tr<?php echo $message_template_office->rowAttributes() ?>>
<?php

// Render list options (body, left)
$message_template_office_list->ListOptions->render("body", "left", $message_template_office_list->RowCnt);
?>
	<?php if ($message_template_office->id->Visible) { // id ?>
		<td data-name="id"<?php echo $message_template_office->id->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_id" class="message_template_office_id">
<span<?php echo $message_template_office->id->viewAttributes() ?>>
<?php echo $message_template_office->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->description->Visible) { // description ?>
		<td data-name="description"<?php echo $message_template_office->description->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_description" class="message_template_office_description">
<span<?php echo $message_template_office->description->viewAttributes() ?>>
<?php if ((!EmptyString($message_template_office->description->getViewValue())) && $message_template_office->description->linkAttributes() <> "") { ?>
<a<?php echo $message_template_office->description->linkAttributes() ?>><?php echo $message_template_office->description->getViewValue() ?></a>
<?php } else { ?>
<?php echo $message_template_office->description->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->status_email_user->Visible) { // status_email_user ?>
		<td data-name="status_email_user"<?php echo $message_template_office->status_email_user->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_status_email_user" class="message_template_office_status_email_user">
<span<?php echo $message_template_office->status_email_user->viewAttributes() ?>>
<?php echo $message_template_office->status_email_user->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->status_email_office->Visible) { // status_email_office ?>
		<td data-name="status_email_office"<?php echo $message_template_office->status_email_office->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_status_email_office" class="message_template_office_status_email_office">
<span<?php echo $message_template_office->status_email_office->viewAttributes() ?>>
<?php echo $message_template_office->status_email_office->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->status_sms_user->Visible) { // status_sms_user ?>
		<td data-name="status_sms_user"<?php echo $message_template_office->status_sms_user->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_status_sms_user" class="message_template_office_status_sms_user">
<span<?php echo $message_template_office->status_sms_user->viewAttributes() ?>>
<?php echo $message_template_office->status_sms_user->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->sms_template_user_id->Visible) { // sms_template_user_id ?>
		<td data-name="sms_template_user_id"<?php echo $message_template_office->sms_template_user_id->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_sms_template_user_id" class="message_template_office_sms_template_user_id">
<span<?php echo $message_template_office->sms_template_user_id->viewAttributes() ?>>
<?php echo $message_template_office->sms_template_user_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->status_sms_office->Visible) { // status_sms_office ?>
		<td data-name="status_sms_office"<?php echo $message_template_office->status_sms_office->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_status_sms_office" class="message_template_office_status_sms_office">
<span<?php echo $message_template_office->status_sms_office->viewAttributes() ?>>
<?php echo $message_template_office->status_sms_office->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->sms_template_office_id->Visible) { // sms_template_office_id ?>
		<td data-name="sms_template_office_id"<?php echo $message_template_office->sms_template_office_id->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_sms_template_office_id" class="message_template_office_sms_template_office_id">
<span<?php echo $message_template_office->sms_template_office_id->viewAttributes() ?>>
<?php echo $message_template_office->sms_template_office_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->wa_status_user->Visible) { // wa_status_user ?>
		<td data-name="wa_status_user"<?php echo $message_template_office->wa_status_user->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_wa_status_user" class="message_template_office_wa_status_user">
<span<?php echo $message_template_office->wa_status_user->viewAttributes() ?>>
<?php echo $message_template_office->wa_status_user->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->wa_type_user->Visible) { // wa_type_user ?>
		<td data-name="wa_type_user"<?php echo $message_template_office->wa_type_user->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_wa_type_user" class="message_template_office_wa_type_user">
<span<?php echo $message_template_office->wa_type_user->viewAttributes() ?>>
<?php echo $message_template_office->wa_type_user->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->wa_status_office->Visible) { // wa_status_office ?>
		<td data-name="wa_status_office"<?php echo $message_template_office->wa_status_office->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_wa_status_office" class="message_template_office_wa_status_office">
<span<?php echo $message_template_office->wa_status_office->viewAttributes() ?>>
<?php echo $message_template_office->wa_status_office->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->wa_type_office->Visible) { // wa_type_office ?>
		<td data-name="wa_type_office"<?php echo $message_template_office->wa_type_office->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_wa_type_office" class="message_template_office_wa_type_office">
<span<?php echo $message_template_office->wa_type_office->viewAttributes() ?>>
<?php echo $message_template_office->wa_type_office->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->wa_to_office->Visible) { // wa_to_office ?>
		<td data-name="wa_to_office"<?php echo $message_template_office->wa_to_office->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_wa_to_office" class="message_template_office_wa_to_office">
<span<?php echo $message_template_office->wa_to_office->viewAttributes() ?>>
<?php echo $message_template_office->wa_to_office->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_template_office->wa_id->Visible) { // wa_id ?>
		<td data-name="wa_id"<?php echo $message_template_office->wa_id->cellAttributes() ?>>
<span id="el<?php echo $message_template_office_list->RowCnt ?>_message_template_office_wa_id" class="message_template_office_wa_id">
<span<?php echo $message_template_office->wa_id->viewAttributes() ?>>
<?php echo $message_template_office->wa_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$message_template_office_list->ListOptions->render("body", "right", $message_template_office_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$message_template_office->isGridAdd())
		$message_template_office_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$message_template_office->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($message_template_office_list->Recordset)
	$message_template_office_list->Recordset->Close();
?>
<?php if (!$message_template_office->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$message_template_office->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($message_template_office_list->Pager)) $message_template_office_list->Pager = new PrevNextPager($message_template_office_list->StartRec, $message_template_office_list->DisplayRecs, $message_template_office_list->TotalRecs, $message_template_office_list->AutoHidePager) ?>
<?php if ($message_template_office_list->Pager->RecordCount > 0 && $message_template_office_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($message_template_office_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $message_template_office_list->pageUrl() ?>start=<?php echo $message_template_office_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($message_template_office_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $message_template_office_list->pageUrl() ?>start=<?php echo $message_template_office_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $message_template_office_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($message_template_office_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $message_template_office_list->pageUrl() ?>start=<?php echo $message_template_office_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($message_template_office_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $message_template_office_list->pageUrl() ?>start=<?php echo $message_template_office_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $message_template_office_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($message_template_office_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $message_template_office_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $message_template_office_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $message_template_office_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($message_template_office_list->TotalRecs > 0 && (!$message_template_office_list->AutoHidePageSizeSelector || $message_template_office_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="message_template_office">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($message_template_office_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($message_template_office_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($message_template_office_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($message_template_office_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($message_template_office_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($message_template_office->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $message_template_office_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($message_template_office_list->TotalRecs == 0 && !$message_template_office->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $message_template_office_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$message_template_office_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$message_template_office->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$message_template_office->isExport()) { ?>
<script>
ew.scrollableTable("gmp_message_template_office", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$message_template_office_list->terminate();
?>