<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$message_type_list = new message_type_list();

// Run the page
$message_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$message_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$message_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmessage_typelist = currentForm = new ew.Form("fmessage_typelist", "list");
fmessage_typelist.formKeyCountName = '<?php echo $message_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmessage_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmessage_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fmessage_typelistsrch = currentSearchForm = new ew.Form("fmessage_typelistsrch");

// Filters
fmessage_typelistsrch.filterList = <?php echo $message_type_list->getFilterList() ?>;

// Init search panel as collapsed
fmessage_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$message_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($message_type_list->TotalRecs > 0 && $message_type_list->ExportOptions->visible()) { ?>
<?php $message_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($message_type_list->ImportOptions->visible()) { ?>
<?php $message_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($message_type_list->SearchOptions->visible()) { ?>
<?php $message_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($message_type_list->FilterOptions->visible()) { ?>
<?php $message_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$message_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$message_type->isExport() && !$message_type->CurrentAction) { ?>
<form name="fmessage_typelistsrch" id="fmessage_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($message_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmessage_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="message_type">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($message_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($message_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $message_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($message_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($message_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($message_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($message_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $message_type_list->showPageHeader(); ?>
<?php
$message_type_list->showMessage();
?>
<?php if ($message_type_list->TotalRecs > 0 || $message_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($message_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> message_type">
<?php if (!$message_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$message_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($message_type_list->Pager)) $message_type_list->Pager = new PrevNextPager($message_type_list->StartRec, $message_type_list->DisplayRecs, $message_type_list->TotalRecs, $message_type_list->AutoHidePager) ?>
<?php if ($message_type_list->Pager->RecordCount > 0 && $message_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($message_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $message_type_list->pageUrl() ?>start=<?php echo $message_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($message_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $message_type_list->pageUrl() ?>start=<?php echo $message_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $message_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($message_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $message_type_list->pageUrl() ?>start=<?php echo $message_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($message_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $message_type_list->pageUrl() ?>start=<?php echo $message_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $message_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($message_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $message_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $message_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $message_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($message_type_list->TotalRecs > 0 && (!$message_type_list->AutoHidePageSizeSelector || $message_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="message_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($message_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($message_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($message_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($message_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($message_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($message_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $message_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmessage_typelist" id="fmessage_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($message_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $message_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="message_type">
<div id="gmp_message_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($message_type_list->TotalRecs > 0 || $message_type->isGridEdit()) { ?>
<table id="tbl_message_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$message_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$message_type_list->renderListOptions();

// Render list options (header, left)
$message_type_list->ListOptions->render("header", "left");
?>
<?php if ($message_type->id->Visible) { // id ?>
	<?php if ($message_type->sortUrl($message_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $message_type->id->headerCellClass() ?>"><div id="elh_message_type_id" class="message_type_id"><div class="ew-table-header-caption"><?php echo $message_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $message_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_type->SortUrl($message_type->id) ?>',2);"><div id="elh_message_type_id" class="message_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_type->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_type->item->Visible) { // item ?>
	<?php if ($message_type->sortUrl($message_type->item) == "") { ?>
		<th data-name="item" class="<?php echo $message_type->item->headerCellClass() ?>"><div id="elh_message_type_item" class="message_type_item"><div class="ew-table-header-caption"><?php echo $message_type->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $message_type->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_type->SortUrl($message_type->item) ?>',2);"><div id="elh_message_type_item" class="message_type_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_type->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($message_type->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_type->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_type->grp->Visible) { // grp ?>
	<?php if ($message_type->sortUrl($message_type->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $message_type->grp->headerCellClass() ?>"><div id="elh_message_type_grp" class="message_type_grp"><div class="ew-table-header-caption"><?php echo $message_type->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $message_type->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_type->SortUrl($message_type->grp) ?>',2);"><div id="elh_message_type_grp" class="message_type_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_type->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_type->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_type->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_type->status->Visible) { // status ?>
	<?php if ($message_type->sortUrl($message_type->status) == "") { ?>
		<th data-name="status" class="<?php echo $message_type->status->headerCellClass() ?>"><div id="elh_message_type_status" class="message_type_status"><div class="ew-table-header-caption"><?php echo $message_type->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $message_type->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_type->SortUrl($message_type->status) ?>',2);"><div id="elh_message_type_status" class="message_type_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_type->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_type->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_type->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_type->operator->Visible) { // operator ?>
	<?php if ($message_type->sortUrl($message_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $message_type->operator->headerCellClass() ?>"><div id="elh_message_type_operator" class="message_type_operator"><div class="ew-table-header-caption"><?php echo $message_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $message_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_type->SortUrl($message_type->operator) ?>',2);"><div id="elh_message_type_operator" class="message_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_type->datetime->Visible) { // datetime ?>
	<?php if ($message_type->sortUrl($message_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $message_type->datetime->headerCellClass() ?>"><div id="elh_message_type_datetime" class="message_type_datetime"><div class="ew-table-header-caption"><?php echo $message_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $message_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_type->SortUrl($message_type->datetime) ?>',2);"><div id="elh_message_type_datetime" class="message_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($message_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($message_type->status_text->Visible) { // status_text ?>
	<?php if ($message_type->sortUrl($message_type->status_text) == "") { ?>
		<th data-name="status_text" class="<?php echo $message_type->status_text->headerCellClass() ?>"><div id="elh_message_type_status_text" class="message_type_status_text"><div class="ew-table-header-caption"><?php echo $message_type->status_text->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_text" class="<?php echo $message_type->status_text->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $message_type->SortUrl($message_type->status_text) ?>',2);"><div id="elh_message_type_status_text" class="message_type_status_text">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $message_type->status_text->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($message_type->status_text->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($message_type->status_text->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$message_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($message_type->ExportAll && $message_type->isExport()) {
	$message_type_list->StopRec = $message_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($message_type_list->TotalRecs > $message_type_list->StartRec + $message_type_list->DisplayRecs - 1)
		$message_type_list->StopRec = $message_type_list->StartRec + $message_type_list->DisplayRecs - 1;
	else
		$message_type_list->StopRec = $message_type_list->TotalRecs;
}
$message_type_list->RecCnt = $message_type_list->StartRec - 1;
if ($message_type_list->Recordset && !$message_type_list->Recordset->EOF) {
	$message_type_list->Recordset->moveFirst();
	$selectLimit = $message_type_list->UseSelectLimit;
	if (!$selectLimit && $message_type_list->StartRec > 1)
		$message_type_list->Recordset->move($message_type_list->StartRec - 1);
} elseif (!$message_type->AllowAddDeleteRow && $message_type_list->StopRec == 0) {
	$message_type_list->StopRec = $message_type->GridAddRowCount;
}

// Initialize aggregate
$message_type->RowType = ROWTYPE_AGGREGATEINIT;
$message_type->resetAttributes();
$message_type_list->renderRow();
while ($message_type_list->RecCnt < $message_type_list->StopRec) {
	$message_type_list->RecCnt++;
	if ($message_type_list->RecCnt >= $message_type_list->StartRec) {
		$message_type_list->RowCnt++;

		// Set up key count
		$message_type_list->KeyCount = $message_type_list->RowIndex;

		// Init row class and style
		$message_type->resetAttributes();
		$message_type->CssClass = "";
		if ($message_type->isGridAdd()) {
		} else {
			$message_type_list->loadRowValues($message_type_list->Recordset); // Load row values
		}
		$message_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$message_type->RowAttrs = array_merge($message_type->RowAttrs, array('data-rowindex'=>$message_type_list->RowCnt, 'id'=>'r' . $message_type_list->RowCnt . '_message_type', 'data-rowtype'=>$message_type->RowType));

		// Render row
		$message_type_list->renderRow();

		// Render list options
		$message_type_list->renderListOptions();
?>
	<tr<?php echo $message_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$message_type_list->ListOptions->render("body", "left", $message_type_list->RowCnt);
?>
	<?php if ($message_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $message_type->id->cellAttributes() ?>>
<span id="el<?php echo $message_type_list->RowCnt ?>_message_type_id" class="message_type_id">
<span<?php echo $message_type->id->viewAttributes() ?>>
<?php echo $message_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_type->item->Visible) { // item ?>
		<td data-name="item"<?php echo $message_type->item->cellAttributes() ?>>
<span id="el<?php echo $message_type_list->RowCnt ?>_message_type_item" class="message_type_item">
<span<?php echo $message_type->item->viewAttributes() ?>>
<?php echo $message_type->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_type->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $message_type->grp->cellAttributes() ?>>
<span id="el<?php echo $message_type_list->RowCnt ?>_message_type_grp" class="message_type_grp">
<span<?php echo $message_type->grp->viewAttributes() ?>>
<?php echo $message_type->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_type->status->Visible) { // status ?>
		<td data-name="status"<?php echo $message_type->status->cellAttributes() ?>>
<span id="el<?php echo $message_type_list->RowCnt ?>_message_type_status" class="message_type_status">
<span<?php echo $message_type->status->viewAttributes() ?>>
<?php echo $message_type->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $message_type->operator->cellAttributes() ?>>
<span id="el<?php echo $message_type_list->RowCnt ?>_message_type_operator" class="message_type_operator">
<span<?php echo $message_type->operator->viewAttributes() ?>>
<?php echo $message_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $message_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $message_type_list->RowCnt ?>_message_type_datetime" class="message_type_datetime">
<span<?php echo $message_type->datetime->viewAttributes() ?>>
<?php echo $message_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($message_type->status_text->Visible) { // status_text ?>
		<td data-name="status_text"<?php echo $message_type->status_text->cellAttributes() ?>>
<span id="el<?php echo $message_type_list->RowCnt ?>_message_type_status_text" class="message_type_status_text">
<span<?php echo $message_type->status_text->viewAttributes() ?>>
<?php echo $message_type->status_text->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$message_type_list->ListOptions->render("body", "right", $message_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$message_type->isGridAdd())
		$message_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$message_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($message_type_list->Recordset)
	$message_type_list->Recordset->Close();
?>
<?php if (!$message_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$message_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($message_type_list->Pager)) $message_type_list->Pager = new PrevNextPager($message_type_list->StartRec, $message_type_list->DisplayRecs, $message_type_list->TotalRecs, $message_type_list->AutoHidePager) ?>
<?php if ($message_type_list->Pager->RecordCount > 0 && $message_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($message_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $message_type_list->pageUrl() ?>start=<?php echo $message_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($message_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $message_type_list->pageUrl() ?>start=<?php echo $message_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $message_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($message_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $message_type_list->pageUrl() ?>start=<?php echo $message_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($message_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $message_type_list->pageUrl() ?>start=<?php echo $message_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $message_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($message_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $message_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $message_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $message_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($message_type_list->TotalRecs > 0 && (!$message_type_list->AutoHidePageSizeSelector || $message_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="message_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($message_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($message_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($message_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($message_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($message_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($message_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $message_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($message_type_list->TotalRecs == 0 && !$message_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $message_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$message_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$message_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$message_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_message_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$message_type_list->terminate();
?>