<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$method_delete = new method_delete();

// Run the page
$method_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$method_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fmethoddelete = currentForm = new ew.Form("fmethoddelete", "delete");

// Form_CustomValidate event
fmethoddelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmethoddelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmethoddelete.lists["x_grp"] = <?php echo $method_delete->grp->Lookup->toClientList() ?>;
fmethoddelete.lists["x_grp"].options = <?php echo JsonEncode($method_delete->grp->lookupOptions()) ?>;
fmethoddelete.lists["x_status"] = <?php echo $method_delete->status->Lookup->toClientList() ?>;
fmethoddelete.lists["x_status"].options = <?php echo JsonEncode($method_delete->status->options(FALSE, TRUE)) ?>;
fmethoddelete.lists["x_operator"] = <?php echo $method_delete->operator->Lookup->toClientList() ?>;
fmethoddelete.lists["x_operator"].options = <?php echo JsonEncode($method_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $method_delete->showPageHeader(); ?>
<?php
$method_delete->showMessage();
?>
<form name="fmethoddelete" id="fmethoddelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($method_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $method_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="method">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($method_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($method->id->Visible) { // id ?>
		<th class="<?php echo $method->id->headerCellClass() ?>"><span id="elh_method_id" class="method_id"><?php echo $method->id->caption() ?></span></th>
<?php } ?>
<?php if ($method->grp->Visible) { // grp ?>
		<th class="<?php echo $method->grp->headerCellClass() ?>"><span id="elh_method_grp" class="method_grp"><?php echo $method->grp->caption() ?></span></th>
<?php } ?>
<?php if ($method->item->Visible) { // item ?>
		<th class="<?php echo $method->item->headerCellClass() ?>"><span id="elh_method_item" class="method_item"><?php echo $method->item->caption() ?></span></th>
<?php } ?>
<?php if ($method->status->Visible) { // status ?>
		<th class="<?php echo $method->status->headerCellClass() ?>"><span id="elh_method_status" class="method_status"><?php echo $method->status->caption() ?></span></th>
<?php } ?>
<?php if ($method->operator->Visible) { // operator ?>
		<th class="<?php echo $method->operator->headerCellClass() ?>"><span id="elh_method_operator" class="method_operator"><?php echo $method->operator->caption() ?></span></th>
<?php } ?>
<?php if ($method->datetime->Visible) { // datetime ?>
		<th class="<?php echo $method->datetime->headerCellClass() ?>"><span id="elh_method_datetime" class="method_datetime"><?php echo $method->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$method_delete->RecCnt = 0;
$i = 0;
while (!$method_delete->Recordset->EOF) {
	$method_delete->RecCnt++;
	$method_delete->RowCnt++;

	// Set row properties
	$method->resetAttributes();
	$method->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$method_delete->loadRowValues($method_delete->Recordset);

	// Render row
	$method_delete->renderRow();
?>
	<tr<?php echo $method->rowAttributes() ?>>
<?php if ($method->id->Visible) { // id ?>
		<td<?php echo $method->id->cellAttributes() ?>>
<span id="el<?php echo $method_delete->RowCnt ?>_method_id" class="method_id">
<span<?php echo $method->id->viewAttributes() ?>>
<?php echo $method->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($method->grp->Visible) { // grp ?>
		<td<?php echo $method->grp->cellAttributes() ?>>
<span id="el<?php echo $method_delete->RowCnt ?>_method_grp" class="method_grp">
<span<?php echo $method->grp->viewAttributes() ?>>
<?php echo $method->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($method->item->Visible) { // item ?>
		<td<?php echo $method->item->cellAttributes() ?>>
<span id="el<?php echo $method_delete->RowCnt ?>_method_item" class="method_item">
<span<?php echo $method->item->viewAttributes() ?>>
<?php echo $method->item->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($method->status->Visible) { // status ?>
		<td<?php echo $method->status->cellAttributes() ?>>
<span id="el<?php echo $method_delete->RowCnt ?>_method_status" class="method_status">
<span<?php echo $method->status->viewAttributes() ?>>
<?php echo $method->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($method->operator->Visible) { // operator ?>
		<td<?php echo $method->operator->cellAttributes() ?>>
<span id="el<?php echo $method_delete->RowCnt ?>_method_operator" class="method_operator">
<span<?php echo $method->operator->viewAttributes() ?>>
<?php echo $method->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($method->datetime->Visible) { // datetime ?>
		<td<?php echo $method->datetime->cellAttributes() ?>>
<span id="el<?php echo $method_delete->RowCnt ?>_method_datetime" class="method_datetime">
<span<?php echo $method->datetime->viewAttributes() ?>>
<?php echo $method->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$method_delete->Recordset->moveNext();
}
$method_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $method_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$method_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$method_delete->terminate();
?>