<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$method_edit = new method_edit();

// Run the page
$method_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$method_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fmethodedit = currentForm = new ew.Form("fmethodedit", "edit");

// Validate form
fmethodedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($method_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $method->id->caption(), $method->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($method_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $method->grp->caption(), $method->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($method_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $method->item->caption(), $method->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($method_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $method->status->caption(), $method->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($method_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $method->operator->caption(), $method->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($method_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $method->datetime->caption(), $method->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fmethodedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmethodedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmethodedit.lists["x_grp"] = <?php echo $method_edit->grp->Lookup->toClientList() ?>;
fmethodedit.lists["x_grp"].options = <?php echo JsonEncode($method_edit->grp->lookupOptions()) ?>;
fmethodedit.lists["x_status"] = <?php echo $method_edit->status->Lookup->toClientList() ?>;
fmethodedit.lists["x_status"].options = <?php echo JsonEncode($method_edit->status->options(FALSE, TRUE)) ?>;
fmethodedit.lists["x_operator"] = <?php echo $method_edit->operator->Lookup->toClientList() ?>;
fmethodedit.lists["x_operator"].options = <?php echo JsonEncode($method_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $method_edit->showPageHeader(); ?>
<?php
$method_edit->showMessage();
?>
<form name="fmethodedit" id="fmethodedit" class="<?php echo $method_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($method_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $method_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="method">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$method_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($method->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_method_id" class="<?php echo $method_edit->LeftColumnClass ?>"><?php echo $method->id->caption() ?><?php echo ($method->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $method_edit->RightColumnClass ?>"><div<?php echo $method->id->cellAttributes() ?>>
<span id="el_method_id">
<span<?php echo $method->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($method->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="method" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($method->id->CurrentValue) ?>">
<?php echo $method->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($method->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_method_grp" for="x_grp" class="<?php echo $method_edit->LeftColumnClass ?>"><?php echo $method->grp->caption() ?><?php echo ($method->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $method_edit->RightColumnClass ?>"><div<?php echo $method->grp->cellAttributes() ?>>
<span id="el_method_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="method" data-field="x_grp" data-value-separator="<?php echo $method->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $method->grp->editAttributes() ?>>
		<?php echo $method->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $method->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $method->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($method->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_method_item" for="x_item" class="<?php echo $method_edit->LeftColumnClass ?>"><?php echo $method->item->caption() ?><?php echo ($method->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $method_edit->RightColumnClass ?>"><div<?php echo $method->item->cellAttributes() ?>>
<span id="el_method_item">
<input type="text" data-table="method" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($method->item->getPlaceHolder()) ?>" value="<?php echo $method->item->EditValue ?>"<?php echo $method->item->editAttributes() ?>>
</span>
<?php echo $method->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($method->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_method_status" for="x_status" class="<?php echo $method_edit->LeftColumnClass ?>"><?php echo $method->status->caption() ?><?php echo ($method->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $method_edit->RightColumnClass ?>"><div<?php echo $method->status->cellAttributes() ?>>
<span id="el_method_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="method" data-field="x_status" data-value-separator="<?php echo $method->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $method->status->editAttributes() ?>>
		<?php echo $method->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $method->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$method_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $method_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $method_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$method_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$method_edit->terminate();
?>