<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$method_list = new method_list();

// Run the page
$method_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$method_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$method->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fmethodlist = currentForm = new ew.Form("fmethodlist", "list");
fmethodlist.formKeyCountName = '<?php echo $method_list->FormKeyCountName ?>';

// Form_CustomValidate event
fmethodlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fmethodlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fmethodlist.lists["x_grp"] = <?php echo $method_list->grp->Lookup->toClientList() ?>;
fmethodlist.lists["x_grp"].options = <?php echo JsonEncode($method_list->grp->lookupOptions()) ?>;
fmethodlist.lists["x_status"] = <?php echo $method_list->status->Lookup->toClientList() ?>;
fmethodlist.lists["x_status"].options = <?php echo JsonEncode($method_list->status->options(FALSE, TRUE)) ?>;
fmethodlist.lists["x_operator"] = <?php echo $method_list->operator->Lookup->toClientList() ?>;
fmethodlist.lists["x_operator"].options = <?php echo JsonEncode($method_list->operator->lookupOptions()) ?>;

// Form object for search
var fmethodlistsrch = currentSearchForm = new ew.Form("fmethodlistsrch");

// Filters
fmethodlistsrch.filterList = <?php echo $method_list->getFilterList() ?>;

// Init search panel as collapsed
fmethodlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$method->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($method_list->TotalRecs > 0 && $method_list->ExportOptions->visible()) { ?>
<?php $method_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($method_list->ImportOptions->visible()) { ?>
<?php $method_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($method_list->SearchOptions->visible()) { ?>
<?php $method_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($method_list->FilterOptions->visible()) { ?>
<?php $method_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$method_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$method->isExport() && !$method->CurrentAction) { ?>
<form name="fmethodlistsrch" id="fmethodlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($method_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fmethodlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="method">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($method_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($method_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $method_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($method_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($method_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($method_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($method_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $method_list->showPageHeader(); ?>
<?php
$method_list->showMessage();
?>
<?php if ($method_list->TotalRecs > 0 || $method->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($method_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> method">
<?php if (!$method->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$method->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($method_list->Pager)) $method_list->Pager = new PrevNextPager($method_list->StartRec, $method_list->DisplayRecs, $method_list->TotalRecs, $method_list->AutoHidePager) ?>
<?php if ($method_list->Pager->RecordCount > 0 && $method_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($method_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $method_list->pageUrl() ?>start=<?php echo $method_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($method_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $method_list->pageUrl() ?>start=<?php echo $method_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $method_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($method_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $method_list->pageUrl() ?>start=<?php echo $method_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($method_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $method_list->pageUrl() ?>start=<?php echo $method_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $method_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($method_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $method_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $method_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $method_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($method_list->TotalRecs > 0 && (!$method_list->AutoHidePageSizeSelector || $method_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="method">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($method_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($method_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($method_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($method_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($method_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($method->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $method_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fmethodlist" id="fmethodlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($method_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $method_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="method">
<div id="gmp_method" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($method_list->TotalRecs > 0 || $method->isGridEdit()) { ?>
<table id="tbl_methodlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$method_list->RowType = ROWTYPE_HEADER;

// Render list options
$method_list->renderListOptions();

// Render list options (header, left)
$method_list->ListOptions->render("header", "left");
?>
<?php if ($method->id->Visible) { // id ?>
	<?php if ($method->sortUrl($method->id) == "") { ?>
		<th data-name="id" class="<?php echo $method->id->headerCellClass() ?>"><div id="elh_method_id" class="method_id"><div class="ew-table-header-caption"><?php echo $method->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $method->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $method->SortUrl($method->id) ?>',2);"><div id="elh_method_id" class="method_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $method->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($method->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($method->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($method->grp->Visible) { // grp ?>
	<?php if ($method->sortUrl($method->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $method->grp->headerCellClass() ?>"><div id="elh_method_grp" class="method_grp"><div class="ew-table-header-caption"><?php echo $method->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $method->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $method->SortUrl($method->grp) ?>',2);"><div id="elh_method_grp" class="method_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $method->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($method->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($method->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($method->item->Visible) { // item ?>
	<?php if ($method->sortUrl($method->item) == "") { ?>
		<th data-name="item" class="<?php echo $method->item->headerCellClass() ?>"><div id="elh_method_item" class="method_item"><div class="ew-table-header-caption"><?php echo $method->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $method->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $method->SortUrl($method->item) ?>',2);"><div id="elh_method_item" class="method_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $method->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($method->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($method->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($method->status->Visible) { // status ?>
	<?php if ($method->sortUrl($method->status) == "") { ?>
		<th data-name="status" class="<?php echo $method->status->headerCellClass() ?>"><div id="elh_method_status" class="method_status"><div class="ew-table-header-caption"><?php echo $method->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $method->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $method->SortUrl($method->status) ?>',2);"><div id="elh_method_status" class="method_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $method->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($method->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($method->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($method->operator->Visible) { // operator ?>
	<?php if ($method->sortUrl($method->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $method->operator->headerCellClass() ?>"><div id="elh_method_operator" class="method_operator"><div class="ew-table-header-caption"><?php echo $method->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $method->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $method->SortUrl($method->operator) ?>',2);"><div id="elh_method_operator" class="method_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $method->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($method->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($method->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($method->datetime->Visible) { // datetime ?>
	<?php if ($method->sortUrl($method->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $method->datetime->headerCellClass() ?>"><div id="elh_method_datetime" class="method_datetime"><div class="ew-table-header-caption"><?php echo $method->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $method->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $method->SortUrl($method->datetime) ?>',2);"><div id="elh_method_datetime" class="method_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $method->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($method->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($method->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$method_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($method->ExportAll && $method->isExport()) {
	$method_list->StopRec = $method_list->TotalRecs;
} else {

	// Set the last record to display
	if ($method_list->TotalRecs > $method_list->StartRec + $method_list->DisplayRecs - 1)
		$method_list->StopRec = $method_list->StartRec + $method_list->DisplayRecs - 1;
	else
		$method_list->StopRec = $method_list->TotalRecs;
}
$method_list->RecCnt = $method_list->StartRec - 1;
if ($method_list->Recordset && !$method_list->Recordset->EOF) {
	$method_list->Recordset->moveFirst();
	$selectLimit = $method_list->UseSelectLimit;
	if (!$selectLimit && $method_list->StartRec > 1)
		$method_list->Recordset->move($method_list->StartRec - 1);
} elseif (!$method->AllowAddDeleteRow && $method_list->StopRec == 0) {
	$method_list->StopRec = $method->GridAddRowCount;
}

// Initialize aggregate
$method->RowType = ROWTYPE_AGGREGATEINIT;
$method->resetAttributes();
$method_list->renderRow();
while ($method_list->RecCnt < $method_list->StopRec) {
	$method_list->RecCnt++;
	if ($method_list->RecCnt >= $method_list->StartRec) {
		$method_list->RowCnt++;

		// Set up key count
		$method_list->KeyCount = $method_list->RowIndex;

		// Init row class and style
		$method->resetAttributes();
		$method->CssClass = "";
		if ($method->isGridAdd()) {
		} else {
			$method_list->loadRowValues($method_list->Recordset); // Load row values
		}
		$method->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$method->RowAttrs = array_merge($method->RowAttrs, array('data-rowindex'=>$method_list->RowCnt, 'id'=>'r' . $method_list->RowCnt . '_method', 'data-rowtype'=>$method->RowType));

		// Render row
		$method_list->renderRow();

		// Render list options
		$method_list->renderListOptions();
?>
	<tr<?php echo $method->rowAttributes() ?>>
<?php

// Render list options (body, left)
$method_list->ListOptions->render("body", "left", $method_list->RowCnt);
?>
	<?php if ($method->id->Visible) { // id ?>
		<td data-name="id"<?php echo $method->id->cellAttributes() ?>>
<span id="el<?php echo $method_list->RowCnt ?>_method_id" class="method_id">
<span<?php echo $method->id->viewAttributes() ?>>
<?php echo $method->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($method->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $method->grp->cellAttributes() ?>>
<span id="el<?php echo $method_list->RowCnt ?>_method_grp" class="method_grp">
<span<?php echo $method->grp->viewAttributes() ?>>
<?php echo $method->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($method->item->Visible) { // item ?>
		<td data-name="item"<?php echo $method->item->cellAttributes() ?>>
<span id="el<?php echo $method_list->RowCnt ?>_method_item" class="method_item">
<span<?php echo $method->item->viewAttributes() ?>>
<?php echo $method->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($method->status->Visible) { // status ?>
		<td data-name="status"<?php echo $method->status->cellAttributes() ?>>
<span id="el<?php echo $method_list->RowCnt ?>_method_status" class="method_status">
<span<?php echo $method->status->viewAttributes() ?>>
<?php echo $method->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($method->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $method->operator->cellAttributes() ?>>
<span id="el<?php echo $method_list->RowCnt ?>_method_operator" class="method_operator">
<span<?php echo $method->operator->viewAttributes() ?>>
<?php echo $method->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($method->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $method->datetime->cellAttributes() ?>>
<span id="el<?php echo $method_list->RowCnt ?>_method_datetime" class="method_datetime">
<span<?php echo $method->datetime->viewAttributes() ?>>
<?php echo $method->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$method_list->ListOptions->render("body", "right", $method_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$method->isGridAdd())
		$method_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$method->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($method_list->Recordset)
	$method_list->Recordset->Close();
?>
<?php if (!$method->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$method->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($method_list->Pager)) $method_list->Pager = new PrevNextPager($method_list->StartRec, $method_list->DisplayRecs, $method_list->TotalRecs, $method_list->AutoHidePager) ?>
<?php if ($method_list->Pager->RecordCount > 0 && $method_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($method_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $method_list->pageUrl() ?>start=<?php echo $method_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($method_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $method_list->pageUrl() ?>start=<?php echo $method_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $method_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($method_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $method_list->pageUrl() ?>start=<?php echo $method_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($method_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $method_list->pageUrl() ?>start=<?php echo $method_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $method_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($method_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $method_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $method_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $method_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($method_list->TotalRecs > 0 && (!$method_list->AutoHidePageSizeSelector || $method_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="method">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($method_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($method_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($method_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($method_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($method_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($method->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $method_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($method_list->TotalRecs == 0 && !$method->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $method_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$method_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$method->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$method->isExport()) { ?>
<script>
ew.scrollableTable("gmp_method", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$method_list->terminate();
?>